"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseDigestAuth = exports.generateDigestAuthHeader = exports.createDigestContext = void 0;
var md5_1 = __importDefault(require("md5"));
var crypto_1 = require("../tools/crypto");
var NONCE_CHARS = "abcdef0123456789";
var NONCE_SIZE = 32;
function createDigestContext(username, password) {
    return { username: username, password: password, nc: 0, algorithm: "md5", hasDigestAuth: false };
}
exports.createDigestContext = createDigestContext;
function generateDigestAuthHeader(options, digest) {
    var url = options.url.replace("//", "");
    var uri = url.indexOf("/") == -1 ? "/" : url.slice(url.indexOf("/"));
    var method = options.method ? options.method.toUpperCase() : "GET";
    var qop = /(^|,)\s*auth\s*($|,)/.test(digest.qop) ? "auth" : false;
    var ncString = "00000000".concat(digest.nc).slice(-8);
    var ha1 = (0, crypto_1.ha1Compute)(digest.algorithm, digest.username, digest.realm, digest.password, digest.nonce, digest.cnonce);
    var ha2 = (0, md5_1.default)("".concat(method, ":").concat(uri));
    var digestResponse = qop
        ? (0, md5_1.default)("".concat(ha1, ":").concat(digest.nonce, ":").concat(ncString, ":").concat(digest.cnonce, ":").concat(qop, ":").concat(ha2))
        : (0, md5_1.default)("".concat(ha1, ":").concat(digest.nonce, ":").concat(ha2));
    var authValues = {
        username: digest.username,
        realm: digest.realm,
        nonce: digest.nonce,
        uri: uri,
        qop: qop,
        response: digestResponse,
        nc: ncString,
        cnonce: digest.cnonce,
        algorithm: digest.algorithm,
        opaque: digest.opaque
    };
    var authHeader = [];
    for (var k in authValues) {
        if (authValues[k]) {
            if (k === "qop" || k === "nc" || k === "algorithm") {
                authHeader.push("".concat(k, "=").concat(authValues[k]));
            }
            else {
                authHeader.push("".concat(k, "=\"").concat(authValues[k], "\""));
            }
        }
    }
    return "Digest ".concat(authHeader.join(", "));
}
exports.generateDigestAuthHeader = generateDigestAuthHeader;
function makeNonce() {
    var uid = "";
    for (var i = 0; i < NONCE_SIZE; ++i) {
        uid = "".concat(uid).concat(NONCE_CHARS[Math.floor(Math.random() * NONCE_CHARS.length)]);
    }
    return uid;
}
function parseDigestAuth(response, _digest) {
    var authHeader = response.headers["www-authenticate"] || "";
    if (authHeader.split(/\s/)[0].toLowerCase() !== "digest") {
        return false;
    }
    var re = /([a-z0-9_-]+)=(?:"([^"]+)"|([a-z0-9_-]+))/gi;
    for (;;) {
        var match = re.exec(authHeader);
        if (!match) {
            break;
        }
        _digest[match[1]] = match[2] || match[3];
    }
    _digest.nc += 1;
    _digest.cnonce = makeNonce();
    return true;
}
exports.parseDigestAuth = parseDigestAuth;
