/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.StringConditionAdapter;
import org.freeplane.features.link.ConnectorChecker;
import org.freeplane.features.link.NodeConnectorChecker;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class ConnectorLabelCondition
extends StringConditionAdapter
implements ConnectorChecker {
    static final String TEXT = "TEXT";
    private final String text;
    private final StringMatchingStrategy stringMatchingStrategy;

    protected StringMatchingStrategy getStringMatchingStrategy() {
        return this.stringMatchingStrategy;
    }

    public ConnectorLabelCondition(String text, boolean matchCase, boolean matchApproximately, boolean matchWordwise, boolean ignoreDiacritics) {
        super(matchCase, matchApproximately, matchWordwise, ignoreDiacritics);
        this.text = text;
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        return NodeConnectorChecker.checkNodeConnectors(node, this);
    }

    @Override
    protected void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(TEXT, this.text);
    }

    @Override
    protected Object conditionValue() {
        return this.text;
    }
}

