/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.JSJSONParser;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.CIPChirality;
import org.jmol.symmetry.CIPData;
import org.jmol.symmetry.CIPDataSmiles;
import org.jmol.symmetry.CLEG;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SpaceGroupFinder;
import org.jmol.symmetry.SpecialGroupFactory;
import org.jmol.symmetry.SymmetryDesc;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.symmetry.UnitCellIterator;
import org.jmol.symmetry.WyckoffFinder;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class Symmetry
implements SymmetryInterface {
    private static SymmetryDesc nullDesc;
    private static Map<String, Object> aflowStructures;
    private static Map<String, Object>[] itaData;
    private static Map<String, Object>[] itaSubData;
    private static Map<String, Object>[] planeData;
    private static Map<String, Object>[] layerData;
    private static Map<String, Object>[] rodData;
    private static Map<String, Object>[] friezeData;
    private static int[][][] itaSubList;
    private static int[][][] planeSubList;
    private static int[][][] layerSubList;
    private static int[][][] rodSubList;
    private static int[][][] friezeSubList;
    private static Lst<Object> allDataITA;
    private static Lst<Object> allPlaneData;
    private static Lst<Object> allLayerData;
    private static Lst<Object> allRodData;
    private static Lst<Object> allFriezeData;
    private static Lst<Object> planeSubData;
    private static Lst<Object> layerSubData;
    private static Lst<Object> rodSubData;
    private static Lst<Object> friezeSubData;
    private static WyckoffFinder wyckoffFinder;
    private static CLEG clegInstance;
    public SpaceGroup spaceGroup;
    public UnitCell unitCell;
    public boolean isBio;
    PointGroup pointGroup;
    CIPChirality cip;
    private SymmetryInfo symmetryInfo;
    private SymmetryDesc desc;
    private M4 transformMatrix;
    private Viewer vwr = null;
    private static SpecialGroupFactory groupFactory;

    @Override
    public String[] getSymopList(boolean doNormalize) {
        int n = this.spaceGroup.operationCount;
        String[] list = new String[n];
        for (int i = 0; i < n; ++i) {
            list[i] = "" + this.getSpaceGroupXyz(i, doNormalize);
        }
        return list;
    }

    @Override
    public boolean isBio() {
        return this.isBio;
    }

    @Override
    public SymmetryInterface setPointGroup(Viewer vwr, SymmetryInterface siLast, T3 center, T3[] atomset, BS bsAtoms, boolean haveVibration, float distanceTolerance, float linearTolerance, int maxAtoms, boolean localEnvOnly) {
        this.pointGroup = PointGroup.getPointGroup(siLast == null ? null : ((Symmetry)siLast).pointGroup, center, atomset, bsAtoms, haveVibration, distanceTolerance, linearTolerance, maxAtoms, localEnvOnly, vwr.getBoolean(603979956), vwr.getScalePixelsPerAngstrom(false));
        return this;
    }

    @Override
    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    @Override
    public Object getPointGroupInfo(int modelIndex, String drawID, boolean asInfo, String type, int index, float scale) {
        if (drawID == null && !asInfo && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (drawID == null && this.pointGroup.isDrawType(type, index, scale)) {
            return this.pointGroup.drawInfo;
        }
        if (asInfo && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(modelIndex, drawID, asInfo, type, index, scale);
    }

    @Override
    public void setSpaceGroup(boolean doNormalize) {
        this.symmetryInfo = null;
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, doNormalize, false);
        }
    }

    @Override
    public int addSpaceGroupOperation(String xyz, int opId) {
        return this.spaceGroup.addSymmetry(xyz, opId, false);
    }

    @Override
    public int addBioMoleculeOperation(M4 mat, boolean isReverse) {
        this.spaceGroup.isBio = true;
        this.isBio = true;
        return this.spaceGroup.addSymmetry((isReverse ? "!" : "") + "[[bio" + mat, 0, false);
    }

    @Override
    public void setLattice(int latt) {
        this.spaceGroup.setLatticeParam(latt);
    }

    @Override
    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    @Override
    public Object getSpaceGroupInfoObj(String name, Object params, boolean isFull, boolean addNonstandard) {
        boolean isNumOrTrm = false;
        switch (name) {
            case "list": {
                return this.getSpaceGroupList((Integer)params);
            }
            case "opsCtr": {
                return this.spaceGroup.getOpsCtr((String)params);
            }
            case "itaTransform": 
            case "itaNumber": {
                isNumOrTrm = true;
            }
            case "nameToXYZList": 
            case "itaIndex": 
            case "hmName": 
            case "hmNameShort": {
                SpaceGroup sg = null;
                if (params != null) {
                    String s = (String)params;
                    if (s.endsWith("'")) {
                        s = SpaceGroup.convertWyckoffHMCleg(s, null);
                        if (isNumOrTrm && s != null) {
                            int pt = s.indexOf(":");
                            return "itaNumber".equals(name) ? s.substring(0, pt) : s.substring(pt + 1);
                        }
                        return null;
                    }
                    if (s.length() > 1 && s.charAt(1) == '/') {
                        int specialType = SpaceGroup.getExplicitSpecialGroupType(s);
                        Map<String, Object> info = Symmetry.getSpecialSettingInfo(this.vwr, s, specialType);
                        if (info != null) {
                            switch (name) {
                                case "itaData": {
                                    return info;
                                }
                                case "hmName": 
                                case "hmNameShort": {
                                    return info.get("hm");
                                }
                                case "nameToXYZList": {
                                    return info.get("gp");
                                }
                                case "itaIndex": {
                                    return "" + info.get("sg") + "." + info.get("set");
                                }
                                case "itaTransform": {
                                    return info.get("trm");
                                }
                                case "itaNumber": {
                                    return "" + info.get("sg");
                                }
                            }
                        }
                        return null;
                    }
                    if (s.startsWith("ITA/")) {
                        s = s.substring(4);
                    }
                    if ((sg = SpaceGroup.determineSpaceGroupN(s)) == null && "nameToXYZList".equals(name)) {
                        sg = SpaceGroup.createSpaceGroupN(s, true);
                    }
                } else if (this.spaceGroup != null) {
                    sg = this.spaceGroup;
                } else if (this.symmetryInfo != null) {
                    sg = this.symmetryInfo.getDerivedSpaceGroup();
                }
                switch (sg == null ? "" : name) {
                    case "hmName": {
                        return sg.getHMName();
                    }
                    case "hmNameShort": {
                        return sg.getHMNameShort();
                    }
                    case "nameToXYZList": {
                        Lst<String> genPos = new Lst<String>();
                        sg.setFinalOperationsSafely();
                        int n = sg.getOperationCount();
                        for (int i = 0; i < n; ++i) {
                            genPos.addLast(((SymmetryOperation)sg.getOperation((int)i)).xyz);
                        }
                        return genPos;
                    }
                    case "itaIndex": {
                        return sg.getItaIndex();
                    }
                    case "itaTransform": {
                        return sg.itaTransform;
                    }
                    case "itaNumber": {
                        return sg.itaNumber;
                    }
                }
                return null;
            }
        }
        return SpaceGroup.getInfo(this.spaceGroup, name, (float[])params, isFull, addNonstandard);
    }

    private String getSpaceGroupList(Integer sg0) {
        SB sb = new SB();
        Lst list = (Lst)this.getSpaceGroupJSON(this.vwr, "ITA", "ALL", 0);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Map map = (Map)list.get(i);
            Integer sg = (Integer)map.get("sg");
            if (sg0 != null && !sg.equals(sg0)) continue;
            sb.appendO(sg).appendC('.').appendO(map.get("set")).appendC('\t').appendO(map.get("hm")).appendC('\t').appendO(map.get("sg")).appendC(':').appendO(map.get("trm")).appendC('\n');
        }
        return sb.toString();
    }

    @Override
    public Object getLatticeDesignation() {
        return this.spaceGroup.getShelxLATTDesignation();
    }

    @Override
    public void setFinalOperations(int dim, String name, P3[] atoms, int iAtomFirst, int noSymmetryCount, boolean doNormalize, String filterSymop) {
        boolean doCalculate;
        if (name != null && (name.startsWith("bio") || name.indexOf(" *(") >= 0)) {
            this.spaceGroup.setName(name);
        }
        if (doCalculate = "unspecified!".equals(name)) {
            filterSymop = "calculated";
        }
        if (filterSymop != null) {
            Lst<SymmetryOperation> lst = new Lst<SymmetryOperation>();
            lst.addLast(this.spaceGroup.matrixOperations[0]);
            for (int i = 1; i < this.spaceGroup.operationCount; ++i) {
                if (!doCalculate && !filterSymop.contains(" " + (i + 1) + " ")) continue;
                lst.addLast(this.spaceGroup.matrixOperations[i]);
            }
            this.spaceGroup = SpaceGroup.createSpaceGroup(-1, name + " *(" + filterSymop.trim() + ")", lst, -1);
        }
        this.spaceGroup.setFinalOperationsForAtoms(dim, atoms, iAtomFirst, noSymmetryCount, doNormalize);
    }

    @Override
    public M4 getSpaceGroupOperation(int i) {
        return this.spaceGroup == null || this.spaceGroup.matrixOperations == null || i >= this.spaceGroup.matrixOperations.length ? null : (this.spaceGroup.finalOperations == null ? this.spaceGroup.matrixOperations[i] : this.spaceGroup.finalOperations[i]);
    }

    @Override
    public String getSpaceGroupXyz(int i, boolean doNormalize) {
        return this.spaceGroup.getXyz(i, doNormalize);
    }

    @Override
    public void newSpaceGroupPoint(P3 pt, int i, M4 o, int transX, int transY, int transZ, P3 retPoint) {
        if (o == null && this.spaceGroup.finalOperations == null) {
            SymmetryOperation op = this.spaceGroup.matrixOperations[i];
            if (!op.isFinalized) {
                op.doFinalize();
            }
            o = op;
        }
        SymmetryOperation.rotateAndTranslatePoint(o == null ? this.spaceGroup.finalOperations[i] : o, pt, transX, transY, transZ, retPoint);
    }

    @Override
    public V3[] rotateAxes(int iop, V3[] axes, P3 ptTemp, M3 mTemp) {
        return iop == 0 ? axes : this.spaceGroup.finalOperations[iop].rotateAxes(axes, this.unitCell, ptTemp, mTemp);
    }

    @Override
    public int getSpinOp(int op) {
        return this.spaceGroup.matrixOperations[op].getMagneticOp();
    }

    @Override
    public int getLatticeOp() {
        return this.spaceGroup.latticeOp;
    }

    @Override
    public Lst<P3> getLatticeCentering() {
        return SymmetryOperation.getLatticeCentering(this.getSymmetryOperations());
    }

    @Override
    public Matrix getOperationRsVs(int iop) {
        return (this.spaceGroup.finalOperations == null ? this.spaceGroup.matrixOperations : this.spaceGroup.finalOperations)[iop].rsvs;
    }

    @Override
    public int getSiteMultiplicity(P3 pt) {
        return this.spaceGroup.getSiteMultiplicity(pt, this.unitCell);
    }

    @Override
    public String getSpaceGroupName() {
        return this.spaceGroup != null ? this.spaceGroup.getName() : (this.symmetryInfo != null ? this.symmetryInfo.sgName : (this.unitCell != null && this.unitCell.name.length() > 0 ? "cell=" + this.unitCell.name : ""));
    }

    @Override
    public String geCIFWriterValue(String type) {
        return this.spaceGroup == null ? null : this.spaceGroup.getCIFWriterValue(type, this);
    }

    @Override
    public char getLatticeType() {
        return this.symmetryInfo != null ? this.symmetryInfo.latticeType : (this.spaceGroup == null ? (char)'P' : this.spaceGroup.latticeType);
    }

    @Override
    public String getIntTableNumber() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableNo : (this.spaceGroup == null ? null : this.spaceGroup.itaNumber);
    }

    @Override
    public String getIntTableIndex() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableIndexNdotM : (this.spaceGroup == null ? null : this.spaceGroup.getItaIndex());
    }

    @Override
    public String getIntTableTransform() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableTransform : (this.spaceGroup == null ? null : this.spaceGroup.itaTransform);
    }

    @Override
    public String getSpaceGroupClegId() {
        return this.symmetryInfo != null ? this.symmetryInfo.getClegId() : this.spaceGroup.getClegId();
    }

    @Override
    public String getSpaceGroupJmolId() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableJmolId : (this.spaceGroup == null ? null : this.spaceGroup.jmolId);
    }

    @Override
    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo == null || this.symmetryInfo.coordinatesAreFractional;
    }

    @Override
    public int[] getCellRange() {
        return this.symmetryInfo == null ? null : this.symmetryInfo.cellRange;
    }

    @Override
    public String getSymmetryInfoStr() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.infoStr;
        }
        if (this.spaceGroup == null) {
            return "";
        }
        this.symmetryInfo = new SymmetryInfo();
        this.symmetryInfo.setSymmetryInfoFromModelkit(this.spaceGroup);
        return this.symmetryInfo.infoStr;
    }

    @Override
    public int getSpaceGroupOperationCount() {
        return this.symmetryInfo != null && this.symmetryInfo.symmetryOperations != null ? this.symmetryInfo.symmetryOperations.length : (this.spaceGroup != null ? (this.spaceGroup.finalOperations != null ? this.spaceGroup.finalOperations.length : this.spaceGroup.operationCount) : 0);
    }

    public SymmetryOperation[] getSymmetryOperations() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.symmetryOperations;
        }
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, false, true);
        }
        this.spaceGroup.setFinalOperationsSafely();
        return this.spaceGroup.finalOperations;
    }

    @Override
    public int getAdditionalOperationsCount() {
        return this.symmetryInfo != null && this.symmetryInfo.symmetryOperations != null && this.symmetryInfo.getAdditionalOperations() != null ? this.symmetryInfo.additionalOperations.length : (this.spaceGroup != null && this.spaceGroup.finalOperations != null ? this.spaceGroup.getAdditionalOperationsCount() : 0);
    }

    @Override
    public M4[] getAdditionalOperations() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.getAdditionalOperations();
        }
        this.getSymmetryOperations();
        return this.spaceGroup.getAdditionalOperations();
    }

    @Override
    public boolean isSimple() {
        return this.spaceGroup == null && (this.symmetryInfo == null || this.symmetryInfo.symmetryOperations == null);
    }

    @Override
    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    @Override
    public SymmetryInterface setUnitCellFromParams(float[] unitCellParams, boolean setRelative, float slop) {
        if (unitCellParams == null) {
            unitCellParams = new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f};
        }
        this.unitCell = UnitCell.fromParams(unitCellParams, setRelative, slop);
        return this;
    }

    @Override
    public boolean unitCellEquals(SymmetryInterface uc2) {
        return ((Symmetry)uc2).unitCell.isSameAs(this.unitCell.getF2C());
    }

    @Override
    public boolean isSymmetryCell(SymmetryInterface sym) {
        UnitCell uc = ((Symmetry)sym).unitCell;
        float[][] myf2c = !uc.isStandard() ? (float[][])null : (this.symmetryInfo != null ? this.symmetryInfo.spaceGroupF2C : this.unitCell.getF2C());
        boolean ret = uc.isSameAs(myf2c);
        if (this.symmetryInfo != null && this.symmetryInfo.setIsCurrentCell(ret)) {
            this.setUnitCellFromParams(this.symmetryInfo.spaceGroupF2CParams, false, Float.NaN);
        }
        return ret;
    }

    @Override
    public String getUnitCellState() {
        if (this.unitCell == null) {
            return "";
        }
        return this.unitCell.getState();
    }

    @Override
    public Lst<String> getMoreInfo() {
        return this.unitCell.moreInfo;
    }

    @Override
    public void initializeOrientation(M3 mat) {
        this.unitCell.initOrientation(mat);
    }

    @Override
    public void unitize(T3 ptFrac) {
        this.unitCell.unitize(ptFrac);
    }

    @Override
    public void toUnitCell(T3 pt, T3 offset) {
        this.unitCell.toUnitCell(pt, offset);
    }

    @Override
    public P3 toSupercell(P3 fpt) {
        return this.unitCell.toSupercell(fpt);
    }

    @Override
    public void toFractional(T3 pt, boolean ignoreOffset) {
        if (!this.isBio) {
            this.unitCell.toFractional(pt, ignoreOffset);
        }
    }

    @Override
    public void toCartesian(T3 pt, boolean ignoreOffset) {
        if (!this.isBio) {
            this.unitCell.toCartesian(pt, ignoreOffset);
        }
    }

    @Override
    public float[] getUnitCellParams() {
        return this.unitCell.getUnitCellParams();
    }

    @Override
    public float[] getUnitCellAsArray(boolean vectorsOnly) {
        return this.unitCell.getUnitCellAsArray(vectorsOnly);
    }

    @Override
    public P3[] getUnitCellVerticesNoOffset() {
        return this.unitCell.getVertices();
    }

    @Override
    public P3 getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    @Override
    public P3 getFractionalOffset(boolean onlyIfFractional) {
        P3 offset = this.unitCell.getFractionalOffset();
        return onlyIfFractional && offset != null && offset.x == (float)((int)offset.x) && offset.y == (float)((int)offset.y) && offset.z == (float)((int)offset.z) ? null : offset;
    }

    @Override
    public void setOffsetPt(T3 pt) {
        this.unitCell.setOffset(pt);
    }

    @Override
    public void setOffset(int nnn) {
        P3 pt = new P3();
        SimpleUnitCell.ijkToPoint3f(nnn, pt, 0, 0);
        this.unitCell.setOffset(pt);
    }

    @Override
    public T3 getUnitCellMultiplier() {
        return this.unitCell.getUnitCellMultiplier();
    }

    @Override
    public SymmetryInterface getUnitCellMultiplied() {
        UnitCell uc = this.unitCell.getUnitCellMultiplied();
        if (uc == this.unitCell) {
            return this;
        }
        Symmetry s = new Symmetry();
        s.unitCell = uc;
        return s;
    }

    @Override
    public P3[] getCanonicalCopy(float scale, boolean withOffset) {
        return this.unitCell.getCanonicalCopy(scale, withOffset);
    }

    @Override
    public float getUnitCellInfoType(int infoType) {
        return this.unitCell.getInfo(infoType);
    }

    @Override
    public String getUnitCellInfo(boolean scaled) {
        return this.unitCell == null ? null : this.unitCell.dumpInfo(false, scaled);
    }

    @Override
    public boolean isSlab() {
        return this.unitCell.isSlab();
    }

    @Override
    public boolean isPolymer() {
        return this.unitCell.isPolymer();
    }

    @Override
    public P3[] getUnitCellVectors() {
        return this.unitCell.getUnitCellVectors();
    }

    @Override
    public SymmetryInterface getUnitCell(T3[] oabc, boolean setRelative, String name) {
        if (oabc == null) {
            return null;
        }
        this.unitCell = UnitCell.fromOABC(oabc, setRelative);
        if (name != null) {
            this.unitCell.name = name;
        }
        return this;
    }

    @Override
    public boolean isSupercell() {
        return this.unitCell.isSupercell();
    }

    @Override
    public BS notInCentroid(ModelSet modelSet, BS bsAtoms, int[] minmax) {
        try {
            BS bsDelete = new BS();
            int iAtom0 = bsAtoms.nextSetBit(0);
            JmolMolecule[] molecules = modelSet.getMolecules();
            int moleculeCount = molecules.length;
            Atom[] atoms = modelSet.at;
            boolean isOneMolecule = molecules[moleculeCount - 1].firstAtomIndex == modelSet.am[atoms[iAtom0].mi].firstAtomIndex;
            P3 center = new P3();
            float packing = (float)minmax[6] / 100.0f;
            boolean centroidPacked = packing != 0.0f;
            int i = moleculeCount;
            block2: while (--i >= 0 && bsAtoms.get(molecules[i].firstAtomIndex)) {
                BS bs = molecules[i].atomList;
                center.set(0.0f, 0.0f, 0.0f);
                int n = 0;
                int j = bs.nextSetBit(0);
                while (j >= 0) {
                    if (isOneMolecule || centroidPacked) {
                        center.setT(atoms[j]);
                        if (this.isNotCentroid(center, 1, minmax, packing)) {
                            if (isOneMolecule) {
                                bsDelete.set(j);
                            }
                        } else if (!isOneMolecule) {
                            continue block2;
                        }
                    } else {
                        center.add(atoms[j]);
                        ++n;
                    }
                    j = bs.nextSetBit(j + 1);
                }
                if (!centroidPacked && (n <= 0 || !this.isNotCentroid(center, n, minmax, 0.0f))) continue;
                bsDelete.or(bs);
            }
            return bsDelete;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isNotCentroid(P3 center, int n, int[] minmax, float packing) {
        center.scale(1.0f / (float)n);
        this.toFractional(center, false);
        if (packing != 0.0f) {
            float d = packing >= 0.0f ? packing : 5.0E-6f;
            return center.x + d <= (float)minmax[0] || center.x - d > (float)minmax[3] || center.y + d <= (float)minmax[1] || center.y - d > (float)minmax[4] || center.z + d <= (float)minmax[2] || center.z - d > (float)minmax[5];
        }
        return center.x + 5.0E-6f <= (float)minmax[0] || center.x + 5.0E-5f > (float)minmax[3] || center.y + 5.0E-6f <= (float)minmax[1] || center.y + 5.0E-5f > (float)minmax[4] || center.z + 5.0E-6f <= (float)minmax[2] || center.z + 5.0E-5f > (float)minmax[5];
    }

    private SymmetryDesc getDesc(ModelSet modelSet) {
        if (modelSet == null) {
            return nullDesc == null ? (nullDesc = (SymmetryDesc)Interface.getInterface("org.jmol.symmetry.SymmetryDesc", null, "modelkit")) : nullDesc;
        }
        return (this.desc == null ? (this.desc = (SymmetryDesc)Interface.getInterface("org.jmol.symmetry.SymmetryDesc", modelSet.vwr, "eval")) : this.desc).set(modelSet);
    }

    @Override
    public Object getSymmetryInfoAtom(ModelSet modelSet, int iatom, String xyz, int op, P3 translation, P3 pt, P3 pt2, String id, int type, float scaleFactor, int nth, int options, int[] opList) {
        return this.getDesc(modelSet).getSymopInfo(iatom, xyz, op, translation, pt, pt2, id, type, scaleFactor, nth, options, opList);
    }

    @Override
    public Map<String, Object> getSpaceGroupInfo(ModelSet modelSet, String sgName, int modelIndex, boolean isFull, float[] cellParams) {
        boolean isForModel;
        boolean bl = isForModel = sgName == null;
        if (sgName == null) {
            Map<String, Object> info;
            if (modelIndex < 0) {
                modelIndex = this.vwr.am.cmi;
            }
            if ((info = modelSet.getModelAuxiliaryInfo(modelIndex)) != null) {
                sgName = (String)info.get("spaceGroup");
            }
        }
        SymmetryInterface cellInfo = null;
        if (cellParams != null) {
            cellInfo = new Symmetry().setUnitCellFromParams(cellParams, false, Float.NaN);
        }
        return this.getDesc(modelSet).getSpaceGroupInfo(this, modelIndex, sgName, 0, null, null, null, 0.0f, -1, isFull, isForModel, 0, cellInfo, null);
    }

    @Override
    public T3[] getV0abc(Object def, M4 retMatrix) {
        Object t = null;
        return (t != null ? t instanceof T3 : def instanceof T3[]) ? (T3[])def : UnitCell.getMatrixAndUnitCell(this.unitCell, def, retMatrix);
    }

    @Override
    public Quat getQuaternionRotation(String abc) {
        return this.unitCell == null ? null : this.unitCell.getQuaternionRotation(abc);
    }

    @Override
    public P3 getFractionalOrigin() {
        return this.unitCell.getFractionalOrigin();
    }

    @Override
    public boolean getState(ModelSet ms, int modelIndex, SB commands) {
        T3 ptm;
        boolean isAssigned = ms.getInfo(modelIndex, "spaceGroupAssigned") != null;
        P3 pt = this.getFractionalOffset(false);
        boolean loadUC = false;
        if (pt != null && (pt.x != 0.0f || pt.y != 0.0f || pt.z != 0.0f)) {
            commands.append("; set unitcell ").append(Escape.eP(pt));
            loadUC = true;
        }
        if ((ptm = this.getUnitCellMultiplier()) != null) {
            commands.append("; set unitcell ").append(SimpleUnitCell.escapeMultiplier(ptm));
            loadUC = true;
        }
        String sg = (String)ms.getInfo(modelIndex, "spaceGroup");
        if (isAssigned && sg != null) {
            int ipt = sg.indexOf("#");
            if (ipt >= 0) {
                sg = sg.substring(ipt + 1);
            }
            String cmd = "\n UNITCELL " + Escape.e(ms.getUnitCell(modelIndex).getUnitCellVectors());
            commands.append(cmd);
            commands.append("\n MODELKIT SPACEGROUP " + PT.esc(sg));
            commands.append(cmd);
            loadUC = true;
        }
        return loadUC;
    }

    @Override
    public AtomIndexIterator getIterator(Viewer vwr, Atom atom, BS bsAtoms, float radius) {
        return ((UnitCellIterator)Interface.getInterface("org.jmol.symmetry.UnitCellIterator", vwr, "script")).set(this, atom, vwr.ms.at, bsAtoms, radius);
    }

    @Override
    public boolean toFromPrimitive(boolean toPrimitive, char type, T3[] oabc, M3 primitiveToCrystal) {
        if (this.unitCell == null) {
            this.unitCell = UnitCell.fromOABC(oabc, false);
        }
        return this.unitCell.toFromPrimitive(toPrimitive, type, oabc, primitiveToCrystal);
    }

    @Override
    public Lst<P3> generateCrystalClass(P3 pt00) {
        P3 pt0;
        if (this.symmetryInfo == null || !this.symmetryInfo.isCurrentCell) {
            return null;
        }
        SymmetryOperation[] ops = this.getSymmetryOperations();
        Lst<P3> lst = new Lst<P3>();
        boolean isRandom = pt00 == null;
        float rand1 = 0.0f;
        float rand2 = 0.0f;
        float rand3 = 0.0f;
        if (isRandom) {
            rand1 = (float)Math.E;
            rand2 = (float)Math.PI;
            rand3 = (float)Math.log10(2000.0);
            pt0 = P3.new3(rand1 + 1.0f, rand2 + 2.0f, rand3 + 3.0f);
        } else {
            pt0 = P3.newP(pt00);
        }
        if (ops == null || this.unitCell == null) {
            lst.addLast(pt0);
        } else {
            this.unitCell.toFractional(pt0, true);
            P3 pt1 = null;
            P3 pt2 = null;
            if (isRandom) {
                pt1 = P3.new3(rand2 + 4.0f, rand3 + 5.0f, rand1 + 6.0f);
                this.unitCell.toFractional(pt1, true);
                pt2 = P3.new3(rand3 + 7.0f, rand1 + 8.0f, rand2 + 9.0f);
                this.unitCell.toFractional(pt2, true);
            }
            Bspt bspt = new Bspt(3, 0);
            CubeIterator iter = bspt.allocateCubeIterator();
            P3 pt = new P3();
            int i = ops.length;
            while (--i >= 0) {
                ops[i].rotate2(pt0, pt);
                iter.initialize(pt, 0.001f, false);
                if (iter.hasMoreElements()) continue;
                P3 ptNew = P3.newP(pt);
                lst.addLast(ptNew);
                bspt.addTuple(ptNew);
                if (!isRandom) continue;
                if (pt2 != null) {
                    ops[i].rotate2(pt2, pt);
                    lst.addLast(P3.newP(pt));
                }
                if (pt1 == null) continue;
                ops[i].rotate2(pt1, pt);
                lst.addLast(P3.newP(pt));
            }
            int j = lst.size();
            while (--j >= 0) {
                pt = (P3)lst.get(j);
                if (isRandom) {
                    pt.scale(0.5f);
                }
                this.unitCell.toCartesian(pt, true);
            }
        }
        return lst;
    }

    @Override
    public void calculateCIPChiralityForAtoms(Viewer vwr, BS bsAtoms) {
        vwr.setCursor(3);
        CIPChirality cip = this.getCIPChirality(vwr);
        String dataClass = vwr.getBoolean(603979960) ? "CIPData" : "CIPDataTracker";
        CIPData data = ((CIPData)Interface.getInterface("org.jmol.symmetry." + dataClass, vwr, "script")).set(vwr, bsAtoms);
        data.setRule6Full(vwr.getBoolean(603979823));
        cip.getChiralityForAtoms(data);
        vwr.setCursor(0);
    }

    @Override
    public String[] calculateCIPChiralityForSmiles(Viewer vwr, String smiles) throws Exception {
        vwr.setCursor(3);
        CIPChirality cip = this.getCIPChirality(vwr);
        CIPDataSmiles data = ((CIPDataSmiles)Interface.getInterface("org.jmol.symmetry.CIPDataSmiles", vwr, "script")).setAtomsForSmiles(vwr, smiles);
        cip.getChiralityForAtoms(data);
        vwr.setCursor(0);
        return data.getSmilesChiralityArray();
    }

    private CIPChirality getCIPChirality(Viewer vwr) {
        return this.cip == null ? (this.cip = (CIPChirality)Interface.getInterface("org.jmol.symmetry.CIPChirality", vwr, "script")) : this.cip;
    }

    @Override
    public Map<String, Object> getUnitCellInfoMap() {
        return this.unitCell == null ? null : this.unitCell.getInfo();
    }

    @Override
    public void setUnitCell(SymmetryInterface uc) {
        this.unitCell = UnitCell.cloneUnitCell(((Symmetry)uc).unitCell);
    }

    @Override
    public Object findSpaceGroup(Viewer vwr, BS atoms, String xyzList, float[] unitCellParams, T3 origin, T3[] oabc, int flags) {
        return ((SpaceGroupFinder)Interface.getInterface("org.jmol.symmetry.SpaceGroupFinder", vwr, "eval")).findSpaceGroup(vwr, atoms, xyzList, unitCellParams, origin, oabc, this, flags);
    }

    @Override
    public void setSpaceGroupName(String name) {
        this.symmetryInfo = null;
        if (this.spaceGroup != null) {
            this.spaceGroup.setName(name);
        }
    }

    @Override
    public void setSpaceGroupTo(Object sg) {
        this.symmetryInfo = null;
        this.spaceGroup = sg instanceof SpaceGroup ? (SpaceGroup)sg : SpaceGroup.getSpaceGroupFromJmolClegOrITA(this.vwr, sg.toString());
    }

    @Override
    public BS removeDuplicates(ModelSet ms, BS bs, boolean highPrec) {
        UnitCell uc = this.unitCell;
        Atom[] atoms = ms.at;
        float[] occs = ms.occupancies;
        boolean haveOccupancies = occs != null;
        P3[] unitized = new P3[bs.length()];
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            P3 pt = unitized[i] = P3.newP(atoms[i]);
            uc.toFractional(pt, false);
            if (highPrec) {
                uc.unitizeRnd(pt);
            } else {
                uc.unitize(pt);
            }
            i = bs.nextSetBit(i + 1);
        }
        i = bs.nextSetBit(0);
        while (i >= 0) {
            Atom a = atoms[i];
            P3 pt = unitized[i];
            int type = a.getAtomicAndIsotopeNumber();
            float occ = haveOccupancies ? occs[i] : 0.0f;
            int j = bs.nextSetBit(i + 1);
            while (j >= 0) {
                P3 pt2;
                Atom b = atoms[j];
                if (type == b.getAtomicAndIsotopeNumber() && (!haveOccupancies || occ == occs[j]) && pt.distanceSquared(pt2 = unitized[j]) < 1.96E-6f) {
                    bs.clear(j);
                }
                j = bs.nextSetBit(j + 1);
            }
            i = bs.nextSetBit(i + 1);
        }
        return bs;
    }

    @Override
    public Lst<P3> getEquivPoints(Lst<P3> pts, P3 pt, String flags) {
        M4[] ops = this.getSymmetryOperations();
        return ops == null || this.unitCell == null ? null : this.unitCell.getEquivPoints(pt, flags, ops, pts == null ? new Lst<P3>() : pts, 0, 0, 0, this.getPeriodicity());
    }

    @Override
    public int getPeriodicity() {
        return this.spaceGroup == null ? 7 : this.spaceGroup.periodicity;
    }

    @Override
    public int getDimensionality() {
        return this.spaceGroup == null ? 3 : this.spaceGroup.nDim;
    }

    @Override
    public void getEquivPointList(Lst<P3> pts, int nInitial, String flags, M4[] opsCtr) {
        int i;
        int dup0;
        int n0;
        boolean tofractional;
        M4[] ops = opsCtr == null ? this.getSymmetryOperations() : opsCtr;
        boolean newPt = flags.indexOf("newpt") >= 0;
        boolean zapped = flags.indexOf("zapped") >= 0;
        int n = pts.size();
        boolean bl = tofractional = flags.indexOf("tofractional") >= 0;
        if (flags.indexOf("fromfractional") < 0) {
            for (int i2 = 0; i2 < pts.size(); ++i2) {
                this.toFractional((T3)pts.get(i2), false);
            }
        }
        flags = flags + ",fromfractional,tofractional";
        int check0 = nInitial > 0 ? 0 : n;
        boolean allPoints = nInitial == n;
        int n2 = n0 = nInitial > 0 ? nInitial : n;
        if (allPoints) {
            --nInitial;
            --n0;
        }
        if (zapped) {
            n0 = 0;
        }
        P3 p0 = nInitial > 0 ? (P3)pts.get(nInitial) : null;
        int n3 = dup0 = opsCtr == null ? n0 : check0;
        if (ops != null || this.unitCell != null) {
            for (i = nInitial; i < n; ++i) {
                this.unitCell.getEquivPoints((P3)pts.get(i), flags, ops, pts, check0, n0, dup0, this.getPeriodicity());
            }
        }
        if (!zapped && (pts.size() == nInitial || pts.get(nInitial) != p0 || allPoints || newPt)) {
            --n;
        }
        i = n - nInitial;
        while (--i >= 0) {
            pts.removeItemAt(nInitial);
        }
        if (!tofractional) {
            i = pts.size();
            while (--i >= nInitial) {
                this.toCartesian((T3)pts.get(i), false);
            }
        }
    }

    @Override
    public int[] getInvariantSymops(P3 pt, int[] v0) {
        SymmetryOperation[] ops = this.getSymmetryOperations();
        if (ops == null) {
            return new int[0];
        }
        BS bs = new BS();
        P3 p = new P3();
        P3 p0 = new P3();
        int nops = ops.length;
        for (int i = 1; i < nops; ++i) {
            p.setT(pt);
            this.unitCell.toFractional(p, false);
            this.unitCell.unitize(p);
            p0.setT(p);
            ops[i].rotTrans(p);
            this.unitCell.unitize(p);
            if (!(p0.distanceSquared(p) < 1.96E-6f)) continue;
            bs.set(i);
        }
        int[] ret = new int[bs.cardinality()];
        if (v0 != null && ret.length != v0.length) {
            return null;
        }
        int k = 0;
        for (int i = 1; i < nops; ++i) {
            boolean isOK = bs.get(i);
            if (!isOK) continue;
            if (v0 != null && v0[k] != i + 1) {
                return null;
            }
            ret[k++] = i + 1;
        }
        return ret;
    }

    @Override
    public Object getWyckoffPosition(Viewer vwr, P3 p, String letter) {
        if (this.unitCell == null) {
            return "";
        }
        SpaceGroup sg = this.spaceGroup;
        if (sg == null && this.symmetryInfo != null && (sg = SpaceGroup.determineSpaceGroupN(this.symmetryInfo.sgName)) == null) {
            String id = this.getSpaceGroupJmolId();
            if (id == null) {
                id = this.getSpaceGroupClegId();
            }
            sg = SpaceGroup.getSpaceGroupFromJmolClegOrITA(vwr, id);
        }
        if (sg == null || sg.itaNumber == null) {
            return "?";
        }
        if (p == null) {
            p = P3.new3(0.53f, 0.2f, 0.16f);
        } else if (!"L".equals(letter)) {
            p = P3.newP(p);
            this.unitCell.toFractional(p, false);
            this.unitCell.unitize(p);
        }
        try {
            int mode;
            boolean withMult;
            WyckoffFinder w = this.getWyckoffFinder().getWyckoffFinder(vwr, sg);
            boolean bl = withMult = letter != null && letter.charAt(0) == 'M';
            if (withMult) {
                String string = letter = letter.length() == 1 ? null : letter.substring(1);
            }
            int n = letter == null ? -1 : ("L".equals(letter) ? -4 : (letter.equalsIgnoreCase("coord") ? -2 : (letter.equalsIgnoreCase("coords") ? -3 : (mode = letter.endsWith("*") ? (int)letter.charAt(0) : 0))));
            if (mode != 0) {
                return w == null ? "?" : w.getInfo(this.unitCell, p, mode, withMult, vwr.is2D());
            }
            if (w.findPositionFor(p, letter) == null) {
                return null;
            }
            this.unitCell.toCartesian(p, false);
            return p;
        }
        catch (Exception e) {
            e.printStackTrace();
            return letter == null ? "?" : null;
        }
    }

    private WyckoffFinder getWyckoffFinder() {
        if (wyckoffFinder == null) {
            wyckoffFinder = (WyckoffFinder)Interface.getInterface("org.jmol.symmetry.WyckoffFinder", null, "symmetry");
        }
        return wyckoffFinder;
    }

    @Override
    public M4 getTransform(P3 fracA, P3 fracB, boolean best) {
        return this.getDesc(null).getTransform(this.unitCell, this.getSymmetryOperations(), fracA, fracB, best);
    }

    @Override
    public boolean isWithinUnitCell(P3 pt, float x, float y, float z) {
        return this.unitCell.isWithinUnitCell(x, y, z, pt);
    }

    @Override
    public boolean checkPeriodic(P3 pt) {
        return this.unitCell.checkPeriodic(pt);
    }

    @Override
    public Object staticConvertOperation(String xyz, M4 matrix) {
        return matrix == null ? SymmetryOperation.stringToMatrix(xyz) : SymmetryOperation.getXYZFromMatrixFrac(matrix, false, false, false, true);
    }

    @Override
    public Object getSubgroupJSON(String nameFrom, String nameTo, int i1, int i2, int flags, Map<String, Object> retMap, Lst<Object> retLst) {
        int itaTo;
        String sgNameFrom;
        int groupType2;
        int groupType1;
        if (nameFrom.startsWith("ITA/")) {
            nameFrom = nameFrom.substring(4);
        }
        if (nameTo != null && nameTo.startsWith("ITA/")) {
            nameTo = nameTo.substring(4);
        }
        if ((groupType1 = SpaceGroup.getExplicitSpecialGroupType(nameFrom)) == -1) {
            return null;
        }
        int n = groupType2 = nameTo == null || nameTo.length() == 0 ? groupType1 : SpaceGroup.getExplicitSpecialGroupType(nameFrom);
        if (groupType2 != groupType1) {
            return null;
        }
        String string = sgNameFrom = groupType1 == 0 ? nameFrom : nameFrom.substring(2);
        if (sgNameFrom.equalsIgnoreCase("all")) {
            return this.getAllITSubData(groupType1);
        }
        int itaFrom = PT.parseInt((String)this.getSpaceGroupInfoObj("itaNumber", sgNameFrom, false, false));
        int n2 = nameTo == null ? -1 : (nameTo.length() == 0 ? 0 : (itaTo = PT.parseInt((String)this.getSpaceGroupInfoObj("itaNumber", groupType1 == 0 ? nameTo : nameTo.substring(2), false, false))));
        if (flags != 0) {
            int n3;
            String prefix = SpaceGroup.getGroupTypePrefix(groupType1);
            int indexMax = flags >> 24 & 0xFF;
            int indexMin = flags >> 16 & 0xFF;
            int depthMax = flags >> 8 & 0xFF;
            int depthMin = flags & 0xFF;
            int[][][] data = this.getSubgroupIndexData(groupType1);
            Lst<String> lstAll = retLst == null ? null : new Lst<String>();
            Stack<int[]> stack = new Stack<int[]>();
            String indexPath = this.findSubTransform(itaFrom, itaTo, indexMax, indexMin, depthMax, depthMin, data, 1, 1, 1, BSUtil.newAndSetBit(itaFrom), stack, lstAll);
            if (indexPath == null ? lstAll == null : indexPath.endsWith("!")) {
                return indexPath;
            }
            String trm = indexPath;
            int n4 = n3 = lstAll == null ? 1 : lstAll.size();
            for (int ilist = 0; ilist < n3; ++ilist) {
                int i;
                Hashtable<String, Object> ret;
                Hashtable<String, Object> hashtable = ret = retMap == null ? new Hashtable<String, Object>() : retMap;
                if (retLst != null && ret != retMap) {
                    retLst.addLast(ret);
                }
                if (lstAll != null) {
                    indexPath = (String)lstAll.get(ilist);
                }
                String[] tokens = indexPath.split(">");
                int nt = tokens.length;
                String[] hmCleg = new String[nt];
                String cleg = "";
                String bcsPath = "";
                int index = 1;
                int depth = 0;
                for (i = nt - 3; i >= 0; i -= 2) {
                    ++depth;
                    String g1 = prefix + tokens[i];
                    String string2 = prefix + tokens[i + 2];
                    tokens[i + 2] = string2;
                    String g2 = string2;
                    index *= Integer.parseInt(tokens[i + 1].substring(1, tokens[i + 1].length() - 1));
                    String string3 = (String)this.getSubgroupJSON(g1, g2, 0, 1, 0, null, null);
                    tokens[i + 1] = string3;
                    trm = string3;
                    cleg = cleg + ">" + trm;
                    hmCleg[i] = (String)this.getSpaceGroupInfoObj("hmNameShort", g1, false, false);
                    hmCleg[i + 1] = "";
                    if (i != nt - 3) continue;
                    hmCleg[i + 2] = (String)this.getSpaceGroupInfoObj("hmNameShort", g2, false, false);
                }
                tokens[0] = prefix + tokens[0];
                for (i = 0; i < nt; i += 2) {
                    bcsPath = bcsPath + ">" + hmCleg[i];
                }
                bcsPath = bcsPath.substring(1);
                M4 m = (M4)this.convertTransform(cleg.substring(1), null);
                ret.put("trm", this.convertTransform(null, m));
                ret.put("trmat", m);
                ret.put("index", index);
                ret.put("depth", depth);
                ret.put("indexPath", indexPath);
                ret.put("cleg", PT.join(tokens, '>', 0));
                ret.put("bcsPath", PT.rep(bcsPath, " ", ""));
            }
            return trm;
        }
        boolean allSubsMap = itaTo < 0;
        boolean asIntArray = itaTo == 0 && i1 == 0;
        boolean asSSIntArray = itaTo == 0 && i1 < 0;
        boolean isIndexMap = itaTo == 0 && i1 > 0 && i2 < 0;
        boolean isIndexTStr = itaTo == 0 && i1 > 0 && i2 > 0;
        boolean isWhereList = itaTo > 0 && i1 < 0;
        boolean isWhereMap = itaTo > 0 && i1 > 0 && i2 < 0;
        boolean isWhereTStr = itaTo > 0 && i1 > 0 && i2 > 0;
        try {
            Map o = (Map)this.getSpaceGroupJSON(this.vwr, "subgroups", nameFrom, itaFrom);
            int ithis = 0;
            if (o != null) {
                if (allSubsMap) {
                    return o;
                }
                if (asIntArray || asSSIntArray) {
                    Lst list = (Lst)o.get("subgroups");
                    int n5 = list.size();
                    int[][] groups = asIntArray ? AU.newInt2(n5) : (int[][])null;
                    BS bs = asSSIntArray ? new BS() : null;
                    int i = n5;
                    while (--i >= 0) {
                        o = (Map)list.get(i);
                        int isub = (Integer)o.get("subgroup");
                        if (asSSIntArray) {
                            bs.set(isub);
                            continue;
                        }
                        int subIndex = (Integer)o.get("subgroupIndex");
                        int trType = "k".equals(o.get("trType")) ? 2 : 1;
                        String subType = trType == 1 ? (String)o.get("trSubtype") : "";
                        double det = ((Number)o.get("det")).doubleValue();
                        int idet = (int)(det < 1.0 ? -1.0 / det : det);
                        if (subType.equals("ct")) {
                            trType = 3;
                        } else if (subType.equals("eu")) {
                            trType = 4;
                        }
                        int ntrm = ((Lst)o.get("trm")).size();
                        groups[i] = new int[]{isub, ntrm, subIndex, idet, trType};
                    }
                    if (asSSIntArray) {
                        int[] a = new int[bs.cardinality()];
                        int p = 0;
                        int i3 = bs.nextSetBit(0);
                        while (i3 >= 0) {
                            a[p++] = i3;
                            i3 = bs.nextSetBit(i3 + 1);
                        }
                        return a;
                    }
                    return groups;
                }
                Lst list = (Lst)o.get("subgroups");
                int i0 = 0;
                int n6 = list.size();
                if (isIndexMap || isIndexTStr) {
                    if (i1 > n6) {
                        throw new ArrayIndexOutOfBoundsException("no map.subgroups[" + i1 + "]!");
                    }
                    i0 = i1 - 1;
                    if (isIndexMap) {
                        return list.get(i0);
                    }
                    n6 = i1;
                }
                Lst<Map> whereList = isWhereList ? new Lst<Map>() : null;
                for (int i = i0; i < n6; ++i) {
                    o = (Map)list.get(i);
                    int isub = (Integer)o.get("sg");
                    if (!isIndexTStr && isub != itaTo) continue;
                    if (++ithis == i1) {
                        if (isWhereMap) {
                            return o;
                        }
                    } else if (isWhereTStr) continue;
                    if (isWhereList) {
                        whereList.addLast(o);
                        continue;
                    }
                    Lst trms = (Lst)o.get("trms");
                    n6 = trms.size();
                    if (i2 < 1 || i2 > n6) {
                        return null;
                    }
                    Map m = (Map)trms.get(i2 - 1);
                    return m.get("trm");
                }
                if (isWhereList && !whereList.isEmpty()) {
                    return whereList;
                }
            }
            if (i1 == 0) {
                return null;
            }
            if (isWhereTStr && ithis > 0) {
                throw new ArrayIndexOutOfBoundsException("only " + ithis + " maximal subgroup information for " + itaFrom + ">>" + itaTo + "!");
            }
            throw new ArrayIndexOutOfBoundsException("no subgroup information for " + itaFrom + ">>" + itaTo + "!");
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String findSubTransform(int itaFrom, int itaTo, int indexMax, int indexMin, int depthMax, int depthMin, int[][][] data, int depth, int indexLast, int index0, BS bs, Stack<int[]> stack, Lst<String> retAll) {
        int step;
        int[][] fromData = data[itaFrom];
        if (depthMax > 0 && depth > depthMax) {
            return null;
        }
        boolean isFirstA2A = itaFrom == itaTo && depth == 1;
        int i2 = isFirstA2A ? 2 : 3;
        int n = step = depth > 0 && depth < depthMin ? 2 : 1;
        while (step < i2) {
            int n2 = fromData.length;
            block5: for (int i = 0; i < n2; ++i) {
                int index;
                int indexNew;
                int group = fromData[i][0];
                if (bs.get(group) && !isFirstA2A || (indexNew = (index = fromData[i][1]) * index0) > indexMax) continue;
                switch (step) {
                    case 1: {
                        if (group != itaTo || indexNew < indexMin) break;
                        String s = "";
                        int ns = stack.size();
                        for (int is = 0; is < ns; ++is) {
                            int[] gi = (int[])stack.get(is);
                            s = s + gi[0] + ">[" + gi[1] + "]>";
                        }
                        s = s + itaFrom + ">[" + index + "]>" + group;
                        if (retAll == null) {
                            return s;
                        }
                        retAll.addLast(s);
                        break block5;
                    }
                    case 2: {
                        if (group == itaTo || bs.get(group)) break;
                        BS bsNew = BSUtil.copy(bs);
                        bsNew.set(group);
                        stack.push(new int[]{itaFrom, index});
                        String s = this.findSubTransform(group, itaTo, indexMax, indexMin, depthMax, depthMin, data, depth + 1, index, indexNew, bsNew, stack, retAll);
                        stack.pop();
                        if (retAll != null) break;
                        return s;
                    }
                }
            }
            ++step;
        }
        return null;
    }

    @Override
    public Object getSpaceGroupJSON(Viewer vwr, String name, String data, int index) {
        boolean isThis;
        if (vwr == null) {
            vwr = this.vwr;
        }
        boolean isSetting = name.equals("setting");
        boolean isSettings = name.equals("settings");
        boolean isAFLOW = name.equalsIgnoreCase("AFLOW");
        boolean isSubgroups = !isSettings && name.equals("subgroups");
        boolean bl = isThis = (isSetting || isSettings || isSubgroups) && index == Integer.MIN_VALUE;
        String s0 = !isSettings && !isSetting && !isSubgroups ? name : (isThis ? this.getSpaceGroupName() : "" + index);
        try {
            int itno;
            String sgname;
            boolean isInt;
            boolean isTM;
            int specialType;
            int n = specialType = data == null ? 0 : SpaceGroup.getExplicitSpecialGroupType(data);
            if (specialType > 0) {
                data = data.substring(2);
            }
            String tm = null;
            if (isSetting && data == null || isSettings || isSubgroups) {
                isTM = false;
                isInt = true;
                String string = sgname = isSetting ? data : null;
                if (isThis) {
                    itno = PT.parseInt(this.getIntTableNumber());
                    if (isSetting || isSettings) {
                        if (this.spaceGroup == null) {
                            SpaceGroup sg = this.symmetryInfo.getDerivedSpaceGroup();
                            if (sg == null) {
                                return new Hashtable();
                            }
                            sgname = sg.jmolId;
                        } else {
                            sgname = this.getSpaceGroupClegId();
                            if (isSetting) {
                                tm = sgname.substring(sgname.indexOf(":") + 1);
                            } else if (isSettings) {
                                index = 0;
                            }
                        }
                    }
                } else {
                    itno = index;
                }
            } else {
                int pt;
                if (!isAFLOW) {
                    index = 0;
                }
                if ((pt = (sgname = data).indexOf("(")) < 0) {
                    pt = sgname.indexOf(":");
                }
                boolean bl2 = isTM = pt >= 0 && sgname.indexOf(",") > pt;
                if (isTM) {
                    tm = sgname.substring(pt + 1, sgname.length() - (sgname.endsWith(")") ? 1 : 0));
                    sgname = sgname.substring(0, pt);
                    isThis = true;
                }
                itno = sgname.equalsIgnoreCase("ALL") ? 0 : PT.parseInt(sgname);
                isInt = itno != Integer.MIN_VALUE;
                pt = sgname.indexOf(46);
                if (!isTM && isInt && index == 0 && pt > 0) {
                    index = PT.parseInt(sgname.substring(pt + 1));
                    sgname = sgname.substring(0, pt);
                }
            }
            if (isInt && (itno > SpaceGroup.getMax(specialType) || (isSettings || isSetting ? itno < 1 : itno < 0))) {
                throw new ArrayIndexOutOfBoundsException(itno);
            }
            if (isSubgroups) {
                Map<String, Object> resource = this.getITSubJSONResource(specialType, itno);
                if (resource != null) {
                    return resource;
                }
            } else if (isSetting || isSettings || name.equalsIgnoreCase("ITA")) {
                if (itno == 0) {
                    return Symmetry.getAllITAData(vwr, specialType, true);
                }
                boolean isSpecial = specialType > 0;
                Map<String, Object> resource = Symmetry.getITJSONResource(vwr, specialType, itno, data);
                if (resource != null) {
                    if (index == 0 && tm == null) {
                        return isSettings ? resource.get("its") : resource;
                    }
                    Lst its = (Lst)resource.get("its");
                    if (its != null) {
                        int i0;
                        if (isSettings && !isThis) {
                            return its;
                        }
                        int n2 = its.size();
                        int n3 = isSetting ? Math.max(index, 1) : (i0 = isInt && !isThis ? index : n2);
                        if (i0 > n2) {
                            return null;
                        }
                        if (isSetting) {
                            return its.get(i0 - 1);
                        }
                        Map map = null;
                        int i = i0;
                        while (--i >= 0) {
                            map = (Map)its.get(i);
                            if (i == index - 1 || (tm == null ? (isSpecial ? SpaceGroup.hmMatches((String)map.get("hm"), sgname, specialType) : sgname.equals(map.get("jmolId"))) : tm.equals(map.get("trm")))) {
                                if (map.containsKey("more")) break;
                                return map;
                            }
                            map = null;
                        }
                        if (map != null) {
                            return SpaceGroup.fillMoreData(vwr, map, data, itno, (Map)its.get(0));
                        }
                    }
                }
            } else if (isAFLOW && tm == null) {
                if (aflowStructures == null) {
                    aflowStructures = (Map)Symmetry.getResource(vwr, "sg/json/aflow_structures.json");
                }
                if (itno == 0) {
                    return aflowStructures;
                }
                if (itno == Integer.MIN_VALUE) {
                    Lst<String> start = null;
                    if (sgname.endsWith("*")) {
                        start = new Lst<String>();
                        sgname = sgname.substring(0, sgname.length() - 1);
                    }
                    for (int j = 1; j <= 230; ++j) {
                        Lst list = (Lst)aflowStructures.get("" + j);
                        int n4 = list.size();
                        for (int i = 0; i < n4; ++i) {
                            String id = (String)list.get(i);
                            if (start != null && id.startsWith(sgname)) {
                                start.addLast("=aflowlib/" + j + "." + (i + 1) + "\t" + id);
                                continue;
                            }
                            if (!id.equalsIgnoreCase(sgname)) continue;
                            return j + "." + (i + 1);
                        }
                    }
                    return start != null && start.size() > 0 ? start : null;
                }
                Lst adata = (Lst)aflowStructures.get("" + sgname);
                if (index <= adata.size()) {
                    return index == 0 ? adata : adata.get(index - 1);
                }
            }
            if (isThis) {
                return new Hashtable();
            }
            throw new IllegalArgumentException(s0);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    static Map<String, Object> getITJSONResource(Viewer vwr, int type, int itno, String specialName) {
        if (type == 0) {
            Map resource;
            if (itaData == null) {
                itaData = new Map[230];
            }
            if ((resource = itaData[itno - 1]) == null) {
                Symmetry.itaData[itno - 1] = resource = (Map)Symmetry.getResource(vwr, "sg/json/ita_" + itno + ".json");
            }
            return resource;
        }
        Map[] data = (Map[])Symmetry.getAllITAData(vwr, type, false);
        if (itno > 0) {
            return data[itno - 1];
        }
        return Symmetry.getSpecialSettingJSON(data, specialName, type, false);
    }

    static Map<String, Object> getSpecialSettingJSON(Map<String, Object>[] data, String name, int specialType, boolean thisSettingOnly) {
        Map<String, Object> info = null;
        boolean isCleg = Character.isDigit(name.charAt(2));
        if (isCleg && name.endsWith(";0,0,0")) {
            name = name.substring(0, name.length() - 6);
        }
        String key = isCleg ? "clegId" : "hm";
        int i = data.length;
        while (--i >= 0) {
            Lst lst = (Lst)data[i].get("its");
            int j = lst.size();
            while (--j >= 0) {
                info = (Map<String, Object>)lst.get(j);
                String val = (String)info.get(key);
                if (!(isCleg ? name.equals(val) : SpaceGroup.hmMatches(val, name, specialType))) continue;
                return thisSettingOnly ? info : data[i];
            }
        }
        return null;
    }

    static Object getAllITAData(Viewer vwr, int type, boolean isAll) {
        switch (type) {
            case 0: {
                if (allDataITA == null) {
                    allDataITA = (Lst)Symmetry.getResource(vwr, "sg/json/ita_all.json");
                }
                return allDataITA;
            }
        }
        String name = "sg/json/it" + (type == 300 ? "a" : "e") + "_all_" + SpaceGroup.getSpecialGroupName(type) + ".json";
        switch (type) {
            case 300: {
                if (allPlaneData == null) {
                    allPlaneData = (Lst)Symmetry.getResource(vwr, name);
                    planeData = Symmetry.createSpecialData(type, allPlaneData);
                }
                return isAll ? allPlaneData : planeData;
            }
            case 400: {
                if (allLayerData == null) {
                    allLayerData = (Lst)Symmetry.getResource(vwr, name);
                    layerData = Symmetry.createSpecialData(type, allLayerData);
                }
                return isAll ? allLayerData : layerData;
            }
            case 500: {
                if (allRodData == null) {
                    allRodData = (Lst)Symmetry.getResource(vwr, name);
                    rodData = Symmetry.createSpecialData(type, allRodData);
                }
                return isAll ? allRodData : rodData;
            }
            case 600: {
                if (allFriezeData == null) {
                    allFriezeData = (Lst)Symmetry.getResource(vwr, name);
                    friezeData = Symmetry.createSpecialData(type, allFriezeData);
                }
                return isAll ? allFriezeData : friezeData;
            }
        }
        return null;
    }

    private static Map<String, Object>[] createSpecialData(int type, Lst<Object> data) {
        int i;
        int n = SpaceGroup.getMax(type);
        Map[] list = new Map[n];
        for (i = 0; i < n; ++i) {
            list[i] = new Hashtable();
            list[i].put("sg", i + 1);
            list[i].put("its", new Lst());
        }
        int nd = data.size();
        for (i = 0; i < nd; ++i) {
            Map map = (Map)data.get(i);
            int sg = (Integer)map.get("sg");
            ((Lst)list[sg - 1].get("its")).addLast(map);
        }
        for (i = 0; i < n; ++i) {
            list[i].put("n", ((Lst)list[i].get("its")).size());
        }
        return list;
    }

    private Lst<Object> getAllITSubData(int type) {
        switch (type) {
            default: {
                return null;
            }
            case 300: {
                if (planeSubData == null) {
                    planeSubData = (Lst)Symmetry.getResource(this.vwr, "sg/json/sub_all_plane.json");
                }
                return planeSubData;
            }
            case 400: {
                if (layerSubData == null) {
                    layerSubData = (Lst)Symmetry.getResource(this.vwr, "sg/json/sub_all_layer.json");
                }
                return layerSubData;
            }
            case 500: {
                if (rodSubData == null) {
                    rodSubData = (Lst)Symmetry.getResource(this.vwr, "sg/json/sub_all_rod.json");
                }
                return rodSubData;
            }
            case 600: 
        }
        if (friezeSubData == null) {
            friezeSubData = (Lst)Symmetry.getResource(this.vwr, "sg/json/sub_all_frieze.json");
        }
        return friezeSubData;
    }

    private Map<String, Object> getITSubJSONResource(int type, int itno) {
        if (type == 0) {
            Map resource;
            if (itaSubData == null) {
                itaSubData = new Map[230];
            }
            if ((resource = itaSubData[itno - 1]) == null) {
                Symmetry.itaSubData[itno - 1] = resource = (Map)Symmetry.getResource(this.vwr, "sg/json/sub_" + itno + ".json");
            }
            return resource;
        }
        return (Map)this.getAllITSubData(type).get(itno - 1);
    }

    private int[][][] getSubgroupIndexData(int groupType) {
        int[][][] data;
        String typeName = SpaceGroup.getSpecialGroupName(groupType);
        int nGroups = SpaceGroup.getMax(groupType);
        switch (groupType) {
            default: {
                if (itaSubList == null) {
                    itaSubList = AU.newInt3(nGroups + 1, 0);
                }
                data = itaSubList;
                break;
            }
            case 300: {
                if (planeSubList == null) {
                    planeSubList = AU.newInt3(nGroups + 1, 0);
                }
                data = planeSubList;
                break;
            }
            case 400: {
                if (layerSubList == null) {
                    layerSubList = AU.newInt3(nGroups + 1, 0);
                }
                data = layerSubList;
                break;
            }
            case 500: {
                if (rodSubList == null) {
                    rodSubList = AU.newInt3(nGroups + 1, 0);
                }
                data = rodSubList;
                break;
            }
            case 600: {
                if (friezeSubList == null) {
                    friezeSubList = AU.newInt3(nGroups + 1, 0);
                }
                data = friezeSubList;
            }
        }
        Lst o = (Lst)Symmetry.getResource(this.vwr, "sg/json/sub_" + (groupType == 0 ? "" : typeName + "_") + "index.json");
        int i = o.size();
        while (--i >= 0) {
            Lst l = (Lst)o.get(i);
            int n = l.size() / 2;
            int[][] nArray = AU.newInt2(n);
            data[i + 1] = nArray;
            int[][] a = nArray;
            int pt = 0;
            for (int j = 0; j < n; ++j) {
                a[j] = new int[]{(Integer)l.get(pt++), (Integer)l.get(pt++)};
            }
        }
        return data;
    }

    private static Object getResource(Viewer vwr, String resource) {
        try {
            BufferedReader r = FileManager.getBufferedReaderForResource(vwr, Symmetry.class, "org/jmol/symmetry/", resource);
            String[] data = new String[1];
            if (Rdr.readAllAsString(r, Integer.MAX_VALUE, false, data, 0)) {
                return new JSJSONParser().parse(data[0], true);
            }
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    @Override
    public float getCellWeight(P3 pt) {
        return this.unitCell.getCellWeight(pt);
    }

    @Override
    public float getPrecision() {
        return this.unitCell == null ? Float.NaN : this.unitCell.getPrecision();
    }

    @Override
    public boolean fixUnitCell(float[] params) {
        return this.spaceGroup.createCompatibleUnitCell(params, null, true);
    }

    @Override
    public String staticGetTransformABC(Object transform, boolean normalize) {
        return SymmetryOperation.getTransformABC(transform, normalize);
    }

    void setCartesianOffset(T3 origin) {
        this.unitCell.setCartesianOffset(origin);
    }

    public void setSymmetryInfoFromFile(ModelSet ms, int modelIndex, float[] unitCellParams) {
        Map<String, Object> modelAuxiliaryInfo = ms.getModelAuxiliaryInfo(modelIndex);
        this.symmetryInfo = new SymmetryInfo();
        float[] params = this.symmetryInfo.setSymmetryInfoFromFile(modelAuxiliaryInfo, unitCellParams);
        if (params != null) {
            String s;
            this.setUnitCellFromParams(params, modelAuxiliaryInfo.containsKey("jmolData"), Float.NaN);
            this.unitCell.moreInfo = (Lst)modelAuxiliaryInfo.get("moreUnitCellInfo");
            modelAuxiliaryInfo.put("infoUnitCell", this.getUnitCellAsArray(false));
            this.setOffsetPt((T3)modelAuxiliaryInfo.get("unitCellOffset"));
            M3 matUnitCellOrientation = (M3)modelAuxiliaryInfo.get("matUnitCellOrientation");
            if (matUnitCellOrientation != null) {
                this.initializeOrientation(matUnitCellOrientation);
            }
            if ((s = this.symmetryInfo.strSUPERCELL) != null) {
                T3[] oabc = this.unitCell.getUnitCellVectors();
                oabc[0] = new P3();
                ms.setModelCagePts(modelIndex, oabc, "conventional");
            }
            if (Logger.debugging) {
                Logger.debug("symmetryInfos[" + modelIndex + "]:\n" + this.unitCell.dumpInfo(true, true));
            }
        }
    }

    public void transformUnitCell(M4 trm) {
        if (trm == null) {
            trm = UnitCell.toTrm(this.spaceGroup.itaTransform, null);
        }
        M4 trmInv = M4.newM4(trm);
        trmInv.invert();
        T3[] oabc = this.getUnitCellVectors();
        for (int i = 1; i <= 3; ++i) {
            this.toFractional(oabc[i], true);
            trmInv.rotate(oabc[i]);
            this.toCartesian(oabc[i], true);
        }
        P3 o = new P3();
        trm.getTranslation(o);
        this.toCartesian(o, true);
        oabc[0].add(o);
        this.unitCell = UnitCell.fromOABC(oabc, false);
    }

    @Override
    public Object getITASettingValue(Viewer vwr, String itaIndex, String key) {
        Object o = this.getSpaceGroupJSON(vwr, "ITA", itaIndex, 0);
        return o instanceof Map ? ((Map)o).get(key) : o;
    }

    @Override
    public String staticCleanTransform(String tr) {
        return SymmetryOperation.getTransformABC(UnitCell.toTrm(tr, null), true);
    }

    @Override
    public M4 replaceTransformMatrix(M4 trm) {
        M4 trm0 = this.transformMatrix;
        this.transformMatrix = trm;
        return trm0;
    }

    @Override
    public String getUnitCellDisplayName() {
        String name = this.spaceGroup != null ? this.spaceGroup.getDisplayName() : (this.symmetryInfo != null ? this.symmetryInfo.getDisplayName(this) : null);
        return name.length() > 0 ? name : null;
    }

    @Override
    public String staticToRationalXYZ(P3 fPt, String sep) {
        String s = SymmetryOperation.fcoord(fPt, sep);
        return ",".equals(sep) ? s : "(" + s + ")";
    }

    @Override
    public int getFinalOperationCount() {
        this.setFinalOperations(3, null, null, -1, -1, false, null);
        return this.spaceGroup.getOperationCount();
    }

    @Override
    public Object convertTransform(String transform, M4 trm) {
        if (transform == null) {
            return this.staticGetTransformABC(trm, false);
        }
        if (transform.equals("xyz")) {
            return trm == null ? null : SymmetryOperation.getXYZFromMatrix(trm, false, false, false);
        }
        if (trm == null) {
            trm = new M4();
        }
        UnitCell.getMatrixAndUnitCell(null, transform, trm);
        return trm;
    }

    @Override
    public M4 staticGetMatrixTransform(String cleg, Object retLstOrMap) {
        return this.getCLEGInstance().getMatrixTransform(this.vwr, cleg, retLstOrMap);
    }

    @Override
    public String staticTransformSpaceGroup(BS bs, String cleg, Object paramsOrUC, SB sb) {
        return this.getCLEGInstance().transformSpaceGroup(this.vwr, bs, cleg, paramsOrUC, sb);
    }

    private CLEG getCLEGInstance() {
        if (clegInstance == null) {
            clegInstance = (CLEG)Interface.getInterface("org.jmol.symmetry.CLEG", null, "symmetry");
        }
        return clegInstance;
    }

    @Override
    public SymmetryInterface setViewer(Viewer vwr) {
        this.vwr = vwr;
        return this;
    }

    @Override
    public P3 getUnitCellCenter() {
        return this.unitCell.getCenter(this.getPeriodicity());
    }

    static SpecialGroupFactory getSGFactory() {
        if (groupFactory == null) {
            groupFactory = (SpecialGroupFactory)Interface.getInterface("org.jmol.symmetry.SpecialGroupFactory", null, "symmetry");
        }
        return groupFactory;
    }

    static Map<String, Object> getSpecialSettingInfo(Viewer vwr, String name, int type) {
        String s = name.substring(2);
        int ptCleg = s.indexOf(":");
        int ptTrm = s.indexOf(",");
        int ptIndex = s.indexOf(".");
        int pt = ptCleg > 0 && ptTrm > ptCleg ? ptCleg : ptIndex;
        int itno = SpaceGroup.getITNo(s, pt);
        int itindex = pt > 0 && pt == ptCleg || itno < 0 ? 0 : (pt > 0 ? SpaceGroup.getITNo(s.substring(pt + 1), 0) : 1);
        Map[] data = (Map[])Symmetry.getAllITAData(vwr, type, false);
        if (itindex > 0) {
            return (Map)((Lst)data[itno - 1].get("its")).get(itindex - 1);
        }
        return Symmetry.getSpecialSettingJSON(data, name, type, true);
    }
}

