/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.AsynchronousChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import sun.nio.ch.Cancellable;

final class PendingFuture<V, A>
implements Future<V> {
    private static final CancellationException CANCELLED = new CancellationException();
    private final AsynchronousChannel channel;
    private final CompletionHandler<V, ? super A> handler;
    private final A attachment;
    private volatile boolean haveResult;
    private volatile V result;
    private volatile Throwable exc;
    private CountDownLatch latch;
    private Future<?> timeoutTask;
    private volatile Object context;

    PendingFuture(AsynchronousChannel channel, CompletionHandler<V, ? super A> handler, A attachment, Object context) {
        this.channel = channel;
        this.handler = handler;
        this.attachment = attachment;
        this.context = context;
    }

    PendingFuture(AsynchronousChannel channel, CompletionHandler<V, ? super A> handler, A attachment) {
        this.channel = channel;
        this.handler = handler;
        this.attachment = attachment;
    }

    PendingFuture(AsynchronousChannel channel) {
        this(channel, null, null);
    }

    PendingFuture(AsynchronousChannel channel, Object context) {
        this(channel, null, null, context);
    }

    AsynchronousChannel channel() {
        return this.channel;
    }

    CompletionHandler<V, ? super A> handler() {
        return this.handler;
    }

    A attachment() {
        return this.attachment;
    }

    void setContext(Object context) {
        this.context = context;
    }

    Object getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeoutTask(Future<?> task) {
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                task.cancel(false);
            } else {
                this.timeoutTask = task;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareForWait() {
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                return false;
            }
            if (this.latch == null) {
                this.latch = new CountDownLatch(1);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResult(V res) {
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                return;
            }
            this.result = res;
            this.haveResult = true;
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFailure(Throwable x) {
        if (!(x instanceof IOException) && !(x instanceof SecurityException)) {
            x = new IOException(x);
        }
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                return;
            }
            this.exc = x;
            this.haveResult = true;
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    void setResult(V res, Throwable x) {
        if (x == null) {
            this.setResult(res);
        } else {
            this.setFailure(x);
        }
    }

    @Override
    public V get() throws ExecutionException, InterruptedException {
        boolean needToWait;
        if (!this.haveResult && (needToWait = this.prepareForWait())) {
            this.latch.await();
        }
        if (this.exc != null) {
            if (this.exc == CANCELLED) {
                throw new CancellationException();
            }
            throw new ExecutionException(this.exc);
        }
        return this.result;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        boolean needToWait;
        if (!this.haveResult && (needToWait = this.prepareForWait()) && !this.latch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this.exc != null) {
            if (this.exc == CANCELLED) {
                throw new CancellationException();
            }
            throw new ExecutionException(this.exc);
        }
        return this.result;
    }

    Throwable exception() {
        return this.exc != CANCELLED ? this.exc : null;
    }

    V value() {
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.exc == CANCELLED;
    }

    @Override
    public boolean isDone() {
        return this.haveResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                return false;
            }
            if (this.channel() instanceof Cancellable) {
                ((Cancellable)((Object)this.channel())).onCancel(this);
            }
            this.exc = CANCELLED;
            this.haveResult = true;
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
        }
        if (mayInterruptIfRunning) {
            try {
                this.channel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
        return true;
    }
}

