/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityUtils;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.dot.DotData;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterManager;
import net.sourceforge.plantuml.svek.ConcurrentStates;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.GraphvizImageBuilder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.InnerStateAutonom;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.svek.image.EntityImageStateCommon;

public final class GroupMakerState {
    private final CucaDiagram diagram;
    private final Entity group;
    private final StringBounder stringBounder;
    private final DotMode dotMode;

    public GroupMakerState(CucaDiagram diagram, Entity group, StringBounder stringBounder, DotMode dotMode) {
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        this.group = group;
        this.dotMode = dotMode;
        if (!group.isGroup()) {
            throw new IllegalArgumentException();
        }
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            if (!EntityUtils.isPureInnerLink12(this.group, link)) continue;
            result.add(link);
        }
        return result;
    }

    public IEntityImage getImage() {
        IEntityImage image;
        UStroke stroke;
        HColor backColor;
        Display display = this.group.getDisplay();
        ISkinParam skinParam = this.diagram.getSkinParam();
        Style style = EntityImageStateCommon.getStyleState(this.group, skinParam);
        Style styleTitle = EntityImageStateCommon.getStyleStateTitle(this.group, skinParam);
        Style styleBody = EntityImageStateCommon.getStyleStateBody(this.group, skinParam);
        double rounded = style.value(PName.RoundCorner).asDouble();
        double shadowing = style.value(PName.Shadowing).asDouble();
        FontConfiguration titleFontConfiguration = styleTitle.getFontConfiguration(skinParam.getIHtmlColorSet());
        TextBlock title = display.create(titleFontConfiguration, HorizontalAlignment.CENTER, this.diagram.getSkinParam());
        if (this.group.countChildren() == 0 && this.group.groups().size() == 0) {
            return new EntityImageState(this.group, this.diagram.getSkinParam());
        }
        if (this.group.getGroupType() == GroupType.CONCURRENT_STATE) {
            return this.createGeneralImageBuilder(this.group.leafs()).buildImage(this.stringBounder, null, new String[0], false);
        }
        if (this.group.getGroupType() != GroupType.STATE) {
            throw new UnsupportedOperationException(this.group.getGroupType().toString());
        }
        HColor borderColor = this.group.getColors().getColor(ColorType.LINE);
        if (borderColor == null) {
            borderColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        }
        if ((backColor = this.group.getColors().getColor(ColorType.BACK)) == null) {
            backColor = style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
        }
        if ((stroke = this.group.getColors().getSpecificLineStroke()) == null) {
            stroke = style.getStroke();
        }
        if (this.containsSomeConcurrentStates()) {
            ArrayList<IEntityImage> inners = new ArrayList<IEntityImage>();
            inners.add(this.createGeneralImageBuilder(this.filter(this.group.leafs())).buildImage(this.stringBounder, null, new String[0], false));
            for (Entity inner : this.group.leafs()) {
                if (inner.getLeafType() != LeafType.STATE_CONCURRENT) continue;
                inners.add(inner.getSvekImage());
            }
            image = new ConcurrentStates(inners, this.group.getConcurrentSeparator(), skinParam, this.group.getStereotype());
        } else {
            image = this.createGeneralImageBuilder(this.filter(this.group.leafs())).buildImage(this.stringBounder, null, new String[0], false);
        }
        HColor bodyColor = styleBody.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
        boolean withSymbol = this.group.getStereotype() != null && this.group.getStereotype().isWithOOSymbol();
        return new InnerStateAutonom(image, title, this.group.getStateHeader(skinParam), borderColor, backColor, this.group.getUrl99(), withSymbol, stroke, rounded, shadowing, bodyColor);
    }

    protected GraphvizImageBuilder createGeneralImageBuilder(Collection<Entity> leafs) {
        List<Link> links = this.getPureInnerLinks();
        Bibliotekon bibliotekon = new Bibliotekon(links);
        DotData dotData = new DotData(this.diagram, this.group, links, leafs, new InnerGroupHierarchy(), PortionShower.ALL);
        Cluster root = new Cluster(this.diagram, bibliotekon.getColorSequence(), dotData.getRootGroup());
        ClusterManager clusterManager = new ClusterManager(bibliotekon, root);
        DotStringFactory dotStringFactory = new DotStringFactory(bibliotekon, root, this.diagram.getUmlDiagramType(), this.diagram.getSkinParam());
        return new GraphvizImageBuilder(dotData, this.diagram.getSource(), this.diagram.getPragma(), SName.stateDiagram, this.dotMode, dotStringFactory, clusterManager);
    }

    private Collection<Entity> filter(Collection<Entity> leafs) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity leaf : leafs) {
            if (leaf.getLeafType() == LeafType.STATE_CONCURRENT) continue;
            result.add(leaf);
        }
        return result;
    }

    private boolean containsSomeConcurrentStates() {
        for (Entity entity : this.group.leafs()) {
            if (entity.getLeafType() != LeafType.STATE_CONCURRENT) continue;
            return true;
        }
        return false;
    }

    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public Entity getRootGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Entity> getChildrenGroups(Entity parent) {
            if (parent.isRoot()) {
                return this.filter(GroupMakerState.this.diagram.getChildrenGroups(GroupMakerState.this.group));
            }
            return this.filter(GroupMakerState.this.diagram.getChildrenGroups(parent));
        }

        private Collection<Entity> filter(Collection<Entity> groups) {
            ArrayList<Entity> result = new ArrayList<Entity>();
            for (Entity g2 : groups) {
                if (g2.getGroupType() == GroupType.CONCURRENT_STATE) continue;
                result.add(g2);
            }
            return result;
        }

        @Override
        public boolean isEmpty(Entity g2) {
            return GroupMakerState.this.diagram.isEmpty(g2);
        }
    }
}

