/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.io.AnonymousIndividualProperties;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAnonymousIndividualByIdProvider;
import org.semanticweb.owlapi.model.OWLDataFactory;

public class RemappingIndividualProvider
implements OWLAnonymousIndividualByIdProvider {
    private OWLDataFactory df;
    private boolean remapEnabled;
    private Map<String, OWLAnonymousIndividual> map;

    public RemappingIndividualProvider(OWLDataFactory df) {
        this(df, AnonymousIndividualProperties.shouldRemapAllAnonymousIndividualsIds());
    }

    public RemappingIndividualProvider(OWLDataFactory df, boolean remapEnabled) {
        this.df = df;
        this.remapEnabled = remapEnabled;
        if (remapEnabled) {
            this.map = new HashMap<String, OWLAnonymousIndividual>();
        }
    }

    @Override
    public OWLAnonymousIndividual getOWLAnonymousIndividual(String nodeId) {
        if (!this.remapEnabled) {
            return this.df.getOWLAnonymousIndividual(nodeId);
        }
        OWLAnonymousIndividual toReturn = this.map.get(nodeId);
        if (toReturn == null) {
            toReturn = this.df.getOWLAnonymousIndividual();
            this.map.put(nodeId, toReturn);
        }
        return toReturn;
    }
}

