// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const isStandardSyntaxRule = require('../../utils/isStandardSyntaxRule.cjs');
const selectors = require('../../reference/selectors.cjs');
const parseSelector = require('../../utils/parseSelector.cjs');
const report = require('../../utils/report.cjs');
const ruleMessages = require('../../utils/ruleMessages.cjs');
const validateOptions = require('../../utils/validateOptions.cjs');

const ruleName = 'selector-pseudo-element-colon-notation';

const messages = ruleMessages(ruleName, {
	expected: (q) => `Expected ${q} colon pseudo-element notation`,
});

const meta = {
	url: 'https://stylelint.io/user-guide/rules/selector-pseudo-element-colon-notation',
	fixable: true,
};

/** @type {import('stylelint').CoreRules[ruleName]} */
const rule = (primary) => {
	return (root, result) => {
		const validOptions = validateOptions(result, ruleName, {
			actual: primary,
			possible: ['single', 'double'],
		});

		if (!validOptions) {
			return;
		}

		let fixedColon = '';

		if (primary === 'single') {
			fixedColon = ':';
		} else if (primary === 'double') {
			fixedColon = '::';
		}

		root.walkRules((ruleNode) => {
			if (!isStandardSyntaxRule(ruleNode)) {
				return;
			}

			const selector = ruleNode.selector;

			// get out early if no pseudo elements or classes
			if (!selector.includes(':')) {
				return;
			}

			const selectorRoot = parseSelector(selector, result, ruleNode);

			if (!selectorRoot) return;

			selectorRoot.walkPseudos((pseudo) => {
				const pseudoElement = pseudo.value.replaceAll(':', '');

				if (!selectors.levelOneAndTwoPseudoElements.has(pseudoElement.toLowerCase())) {
					return;
				}

				const isDouble = pseudo.value.startsWith('::');

				if (primary === 'single' && !isDouble) {
					return;
				}

				if (primary === 'double' && isDouble) {
					return;
				}

				const fix = () => {
					pseudo.replaceWith(pseudo.clone({ value: fixedColon + pseudoElement }));
					ruleNode.selector = selectorRoot.toString();
				};

				report({
					message: messages.expected(primary),
					node: ruleNode,
					index: pseudo.sourceIndex,
					endIndex: pseudo.sourceIndex + (isDouble ? 2 : 1),
					result,
					ruleName,
					fix,
				});
			});
		});
	};
};

rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;

module.exports = rule;
