/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.activemime;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ActiveMimeParser
extends AbstractParser {
    private static final MediaType MEDIA_TYPE = MediaType.application((String)"x-activemime");
    private static final Set<MediaType> SUPPORTED = Collections.singleton(MEDIA_TYPE);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        IOUtils.skipFully((InputStream)stream, (long)12L);
        IOUtils.skipFully((InputStream)stream, (long)2L);
        IOUtils.skipFully((InputStream)stream, (long)4L);
        IOUtils.skipFully((InputStream)stream, (long)4L);
        IOUtils.skipFully((InputStream)stream, (long)4L);
        IOUtils.skipFully((InputStream)stream, (long)4L);
        long zlibOffset = LittleEndian.readUInt((InputStream)stream);
        IOUtils.skipFully((InputStream)stream, (long)4L);
        IOUtils.skipFully((InputStream)stream, (long)4L);
        IOUtils.skipFully((InputStream)stream, (long)4L);
        IOUtils.skipFully((InputStream)stream, (long)zlibOffset);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        EmbeddedDocumentExtractor ex = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
        try (DeflateCompressorInputStream payload = new DeflateCompressorInputStream(stream);
             POIFSFileSystem poifs = new POIFSFileSystem((InputStream)payload);){
            OfficeParser.extractMacros(poifs, (ContentHandler)xhtml, ex);
        }
        xhtml.endDocument();
    }
}

