/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.filtered;

import java.io.IOException;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.filtered.KNNIterator;
import org.opensearch.knn.index.vectorvalues.KNNBinaryVectorValues;

public class FilteredIdsKNNByteIterator
implements KNNIterator {
    protected final BitSet filterIdsBitSet;
    protected final BitSetIterator bitSetIterator;
    protected final byte[] queryVector;
    protected final KNNBinaryVectorValues binaryVectorValues;
    protected final SpaceType spaceType;
    protected float currentScore = Float.NEGATIVE_INFINITY;
    protected int docId;

    public FilteredIdsKNNByteIterator(BitSet filterIdsBitSet, byte[] queryVector, KNNBinaryVectorValues binaryVectorValues, SpaceType spaceType) {
        this.filterIdsBitSet = filterIdsBitSet;
        this.bitSetIterator = new BitSetIterator(filterIdsBitSet, (long)filterIdsBitSet.length());
        this.queryVector = queryVector;
        this.binaryVectorValues = binaryVectorValues;
        this.spaceType = spaceType;
        this.docId = this.bitSetIterator.nextDoc();
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int doc = this.binaryVectorValues.advance(this.docId);
        this.currentScore = this.computeScore();
        this.docId = this.bitSetIterator.nextDoc();
        return doc;
    }

    @Override
    public float score() {
        return this.currentScore;
    }

    protected float computeScore() throws IOException {
        byte[] vector = this.binaryVectorValues.getVector();
        return this.spaceType.getKnnVectorSimilarityFunction().compare(this.queryVector, vector);
    }
}

