/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.filtered;

import java.io.IOException;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.SegmentLevelQuantizationInfo;
import org.opensearch.knn.index.query.SegmentLevelQuantizationUtil;
import org.opensearch.knn.index.query.filtered.KNNIterator;
import org.opensearch.knn.index.vectorvalues.KNNFloatVectorValues;

public class FilteredIdsKNNIterator
implements KNNIterator {
    protected final BitSet filterIdsBitSet;
    protected final BitSetIterator bitSetIterator;
    protected final float[] queryVector;
    private final byte[] quantizedQueryVector;
    protected final KNNFloatVectorValues knnFloatVectorValues;
    protected final SpaceType spaceType;
    protected float currentScore = Float.NEGATIVE_INFINITY;
    protected int docId;
    private final SegmentLevelQuantizationInfo segmentLevelQuantizationInfo;

    FilteredIdsKNNIterator(BitSet filterIdsBitSet, float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType) {
        this(filterIdsBitSet, queryVector, knnFloatVectorValues, spaceType, null, null);
    }

    public FilteredIdsKNNIterator(BitSet filterIdsBitSet, float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType, byte[] quantizedQueryVector, SegmentLevelQuantizationInfo segmentLevelQuantizationInfo) {
        this.filterIdsBitSet = filterIdsBitSet;
        this.bitSetIterator = new BitSetIterator(filterIdsBitSet, (long)filterIdsBitSet.length());
        this.queryVector = queryVector;
        this.knnFloatVectorValues = knnFloatVectorValues;
        this.spaceType = spaceType;
        this.docId = this.bitSetIterator.nextDoc();
        this.quantizedQueryVector = quantizedQueryVector;
        this.segmentLevelQuantizationInfo = segmentLevelQuantizationInfo;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int doc = this.knnFloatVectorValues.advance(this.docId);
        this.currentScore = this.computeScore();
        this.docId = this.bitSetIterator.nextDoc();
        return doc;
    }

    @Override
    public float score() {
        return this.currentScore;
    }

    protected float computeScore() throws IOException {
        float[] vector = this.knnFloatVectorValues.getVector();
        if (this.segmentLevelQuantizationInfo != null && this.quantizedQueryVector != null) {
            byte[] quantizedVector = SegmentLevelQuantizationUtil.quantizeVector(vector, this.segmentLevelQuantizationInfo);
            return SpaceType.HAMMING.getKnnVectorSimilarityFunction().compare(this.quantizedQueryVector, quantizedVector);
        }
        return this.spaceType.getKnnVectorSimilarityFunction().compare(this.queryVector, vector);
    }
}

