/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.identity;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.identity.Subject;
import org.opensearch.identity.noop.NoopSubject;
import org.opensearch.identity.tokens.AuthToken;
import org.opensearch.identity.tokens.OnBehalfOfClaims;
import org.opensearch.identity.tokens.TokenManager;
import org.opensearch.security.authtoken.jwt.ExpiringBearerAuthToken;
import org.opensearch.security.authtoken.jwt.JwtVendor;
import org.opensearch.security.securityconf.ConfigModel;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.user.User;
import org.opensearch.security.user.UserService;
import org.opensearch.threadpool.ThreadPool;

public class SecurityTokenManager
implements TokenManager {
    private static final Logger logger = LogManager.getLogger(SecurityTokenManager.class);
    private final ClusterService cs;
    private final ThreadPool threadPool;
    private final UserService userService;
    private JwtVendor jwtVendor = null;
    private ConfigModel configModel = null;

    public SecurityTokenManager(ClusterService cs, ThreadPool threadPool, UserService userService) {
        this.cs = cs;
        this.threadPool = threadPool;
        this.userService = userService;
    }

    @Subscribe
    public void onConfigModelChanged(ConfigModel configModel) {
        this.configModel = configModel;
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        Settings oboSettings = dcm.getDynamicOnBehalfOfSettings();
        Boolean enabled = oboSettings.getAsBoolean("enabled", Boolean.valueOf(false));
        this.jwtVendor = enabled != false ? this.createJwtVendor(oboSettings) : null;
    }

    JwtVendor createJwtVendor(Settings settings) {
        try {
            return new JwtVendor(settings, Optional.empty());
        }
        catch (Exception ex) {
            logger.error("Unable to create the JwtVendor instance", (Throwable)ex);
            return null;
        }
    }

    public boolean issueOnBehalfOfTokenAllowed() {
        return this.jwtVendor != null && this.configModel != null;
    }

    public ExpiringBearerAuthToken issueOnBehalfOfToken(Subject subject, OnBehalfOfClaims claims) {
        if (!this.issueOnBehalfOfTokenAllowed()) {
            throw new OpenSearchSecurityException("The OnBehalfOf token generation is not enabled, see {link to doc} for more information on this feature.", new Object[0]);
        }
        if (subject != null && !(subject instanceof NoopSubject)) {
            logger.warn("Unsupported subject for OnBehalfOfToken token generation, {}", (Object)subject);
            throw new IllegalArgumentException("Unsupported subject to generate OnBehalfOfToken");
        }
        if (Strings.isNullOrEmpty((String)claims.getAudience())) {
            throw new IllegalArgumentException("Claims must be supplied with an audience value");
        }
        User user = (User)this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
        if (user == null) {
            throw new OpenSearchSecurityException("Unsupported user to generate OnBehalfOfToken", new Object[0]);
        }
        TransportAddress callerAddress = null;
        Set<String> mappedRoles = this.configModel.mapSecurityRoles(user, callerAddress);
        try {
            return this.jwtVendor.createJwt(this.cs.getClusterName().value(), user.getName(), claims.getAudience(), claims.getExpiration(), mappedRoles.stream().collect(Collectors.toList()), user.getRoles().stream().collect(Collectors.toList()), false);
        }
        catch (Exception ex) {
            logger.error("Error creating OnBehalfOfToken for " + user.getName(), (Throwable)ex);
            throw new OpenSearchSecurityException("Unable to generate OnBehalfOfToken", new Object[0]);
        }
    }

    public AuthToken issueServiceAccountToken(String serviceId) {
        try {
            return this.userService.generateAuthToken(serviceId);
        }
        catch (Exception e) {
            logger.error("Error creating sevice final account auth token, service " + serviceId, (Throwable)e);
            throw new OpenSearchSecurityException("Unable to issue service account token", new Object[0]);
        }
    }
}

