/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.flint.operation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.client.EMRServerlessClientFactory;
import org.opensearch.sql.spark.flint.FlintIndexMetadata;
import org.opensearch.sql.spark.flint.FlintIndexState;
import org.opensearch.sql.spark.flint.FlintIndexStateModel;
import org.opensearch.sql.spark.flint.FlintIndexStateModelService;
import org.opensearch.sql.spark.flint.operation.FlintIndexOp;
import org.opensearch.sql.spark.scheduler.AsyncQueryScheduler;

public class FlintIndexOpDrop
extends FlintIndexOp {
    private static final Logger LOG = LogManager.getLogger();
    private final AsyncQueryScheduler asyncQueryScheduler;

    public FlintIndexOpDrop(FlintIndexStateModelService flintIndexStateModelService, String datasourceName, EMRServerlessClientFactory emrServerlessClientFactory, AsyncQueryScheduler asyncQueryScheduler) {
        super(flintIndexStateModelService, datasourceName, emrServerlessClientFactory);
        this.asyncQueryScheduler = asyncQueryScheduler;
    }

    @Override
    public boolean validate(FlintIndexState state) {
        return state == FlintIndexState.REFRESHING || state == FlintIndexState.EMPTY || state == FlintIndexState.ACTIVE || state == FlintIndexState.CREATING;
    }

    @Override
    FlintIndexState transitioningState() {
        return FlintIndexState.DELETING;
    }

    @Override
    void runOp(FlintIndexMetadata flintIndexMetadata, FlintIndexStateModel flintIndexStateModel, AsyncQueryRequestContext asyncQueryRequestContext) {
        LOG.debug("Performing drop index operation for index: {}", (Object)flintIndexMetadata.getOpensearchIndexName());
        if (flintIndexMetadata.getFlintIndexOptions().isExternalScheduler()) {
            this.asyncQueryScheduler.unscheduleJob(flintIndexMetadata.getOpensearchIndexName());
        } else {
            this.cancelStreamingJob(flintIndexStateModel);
        }
    }

    @Override
    FlintIndexState stableState() {
        return FlintIndexState.DELETED;
    }
}

