/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.caching;

import com.amazonaws.encryptionsdk.internal.Utils;
import com.amazonaws.encryptionsdk.model.DecryptionMaterials;
import com.amazonaws.encryptionsdk.model.EncryptionMaterials;
import java.util.Objects;

public interface CryptoMaterialsCache {
    public EncryptCacheEntry getEntryForEncrypt(byte[] var1, UsageStats var2);

    public EncryptCacheEntry putEntryForEncrypt(byte[] var1, EncryptionMaterials var2, CacheHint var3, UsageStats var4);

    public DecryptCacheEntry getEntryForDecrypt(byte[] var1);

    public void putEntryForDecrypt(byte[] var1, DecryptionMaterials var2, CacheHint var3);

    public static interface DecryptCacheEntry {
        public DecryptionMaterials getResult();

        public void invalidate();

        public long getEntryCreationTime();
    }

    public static final class UsageStats {
        public static final UsageStats ZERO = new UsageStats(0L, 0L);
        private final long bytesEncrypted;
        private final long messagesEncrypted;

        public UsageStats(long bytesEncrypted, long messagesEncrypted) {
            if (bytesEncrypted < 0L) {
                throw new IllegalArgumentException("Negative bytes encrypted is not permitted");
            }
            if (messagesEncrypted < 0L) {
                throw new IllegalArgumentException("Negative messages encrypted is not permitted");
            }
            this.bytesEncrypted = bytesEncrypted;
            this.messagesEncrypted = messagesEncrypted;
        }

        public long getBytesEncrypted() {
            return this.bytesEncrypted;
        }

        public long getMessagesEncrypted() {
            return this.messagesEncrypted;
        }

        public UsageStats add(UsageStats other) {
            return new UsageStats(UsageStats.saturatingAdd(this.getBytesEncrypted(), other.getBytesEncrypted()), UsageStats.saturatingAdd(this.getMessagesEncrypted(), other.getMessagesEncrypted()));
        }

        static long saturatingAdd(long a, long b) {
            if (a < 0L || b < 0L) {
                throw new IllegalArgumentException("Negative usage values are not permitted");
            }
            return Utils.saturatingAdd(a, b);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UsageStats that = (UsageStats)o;
            return this.getBytesEncrypted() == that.getBytesEncrypted() && this.getMessagesEncrypted() == that.getMessagesEncrypted();
        }

        public int hashCode() {
            return Objects.hash(this.getBytesEncrypted(), this.getMessagesEncrypted());
        }

        public String toString() {
            return "UsageStats{bytesEncrypted=" + this.bytesEncrypted + ", messagesEncrypted=" + this.messagesEncrypted + '}';
        }
    }

    public static interface EncryptCacheEntry {
        public UsageStats getUsageStats();

        public long getEntryCreationTime();

        public EncryptionMaterials getResult();

        default public void invalidate() {
        }
    }

    public static interface CacheHint {
        public long getMaxAgeMillis();
    }
}

