/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.shards;

import org.opensearch.action.admin.cluster.shards.CatShardsRequest;
import org.opensearch.action.admin.cluster.shards.CatShardsResponse;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.TimeoutTaskCancellationUtility;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.NotifyOnceListener;
import org.opensearch.core.tasks.TaskCancelledException;
import org.opensearch.tasks.CancellableTask;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportCatShardsAction
extends HandledTransportAction<CatShardsRequest, CatShardsResponse> {
    private final NodeClient client;

    @Inject
    public TransportCatShardsAction(NodeClient client, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:monitor/shards", transportService, actionFilters, CatShardsRequest::new);
        this.client = client;
    }

    @Override
    public void doExecute(final Task parentTask, final CatShardsRequest shardsRequest, final ActionListener<CatShardsResponse> listener) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.setShouldCancelOnTimeout(true);
        clusterStateRequest.local(shardsRequest.local());
        clusterStateRequest.clusterManagerNodeTimeout(shardsRequest.clusterManagerNodeTimeout());
        clusterStateRequest.clear().nodes(true).routingTable(true).indices(shardsRequest.getIndices());
        assert (parentTask instanceof CancellableTask);
        clusterStateRequest.setParentTask(this.client.getLocalNodeId(), parentTask.getId());
        NotifyOnceListener<CatShardsResponse> originalListener = new NotifyOnceListener<CatShardsResponse>(){

            protected void innerOnResponse(CatShardsResponse catShardsResponse) {
                listener.onResponse((Object)catShardsResponse);
            }

            protected void innerOnFailure(Exception e) {
                listener.onFailure(e);
            }
        };
        final ActionListener cancellableListener = TimeoutTaskCancellationUtility.wrapWithCancellationListener(this.client, (CancellableTask)parentTask, ((CancellableTask)parentTask).getCancellationTimeout(), originalListener, arg_0 -> TransportCatShardsAction.lambda$doExecute$0((ActionListener)originalListener, arg_0));
        final CatShardsResponse catShardsResponse = new CatShardsResponse();
        try {
            this.client.admin().cluster().state(clusterStateRequest, new ActionListener<ClusterStateResponse>(){

                public void onResponse(ClusterStateResponse clusterStateResponse) {
                    catShardsResponse.setClusterStateResponse(clusterStateResponse);
                    IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
                    indicesStatsRequest.setShouldCancelOnTimeout(true);
                    indicesStatsRequest.all();
                    indicesStatsRequest.indices(shardsRequest.getIndices());
                    indicesStatsRequest.setParentTask(TransportCatShardsAction.this.client.getLocalNodeId(), parentTask.getId());
                    try {
                        TransportCatShardsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                            public void onResponse(IndicesStatsResponse indicesStatsResponse) {
                                catShardsResponse.setIndicesStatsResponse(indicesStatsResponse);
                                cancellableListener.onResponse((Object)catShardsResponse);
                            }

                            public void onFailure(Exception e) {
                                cancellableListener.onFailure(e);
                            }
                        });
                    }
                    catch (Exception e) {
                        cancellableListener.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    cancellableListener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            cancellableListener.onFailure(e);
        }
    }

    private static /* synthetic */ void lambda$doExecute$0(ActionListener originalListener, TaskCancelledException e) {
        originalListener.onFailure((Exception)e);
    }
}

