/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStage;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.opensearch.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.SnapshotsInProgress;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.snapshots.IndexShardSnapshotStatus;
import org.opensearch.repositories.IndexId;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryData;
import org.opensearch.snapshots.Snapshot;
import org.opensearch.snapshots.SnapshotId;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotMissingException;
import org.opensearch.snapshots.SnapshotShardFailure;
import org.opensearch.snapshots.SnapshotState;
import org.opensearch.snapshots.SnapshotsService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportSnapshotsStatusAction
extends TransportClusterManagerNodeAction<SnapshotsStatusRequest, SnapshotsStatusResponse> {
    private static final Logger logger = LogManager.getLogger(TransportSnapshotsStatusAction.class);
    private final RepositoriesService repositoriesService;
    private final TransportNodesSnapshotsStatus transportNodesSnapshotsStatus;
    private long maximumAllowedShardCount;

    @Inject
    public TransportSnapshotsStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RepositoriesService repositoriesService, TransportNodesSnapshotsStatus transportNodesSnapshotsStatus, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/snapshot/status", transportService, clusterService, threadPool, actionFilters, SnapshotsStatusRequest::new, indexNameExpressionResolver);
        this.repositoriesService = repositoriesService;
        this.transportNodesSnapshotsStatus = transportNodesSnapshotsStatus;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected ClusterBlockException checkBlock(SnapshotsStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected SnapshotsStatusResponse read(StreamInput in) throws IOException {
        return new SnapshotsStatusResponse(in);
    }

    @Override
    protected void clusterManagerOperation(SnapshotsStatusRequest request, ClusterState state, ActionListener<SnapshotsStatusResponse> listener) throws Exception {
        SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
        List<SnapshotsInProgress.Entry> currentSnapshots = SnapshotsService.currentSnapshots(snapshotsInProgress, request.repository(), Arrays.asList(request.snapshots()));
        if (currentSnapshots.isEmpty()) {
            this.buildResponse(snapshotsInProgress, request, currentSnapshots, null, listener);
            return;
        }
        HashSet<String> nodesIds = new HashSet<String>();
        for (SnapshotsInProgress.Entry entry : currentSnapshots) {
            for (SnapshotsInProgress.ShardSnapshotStatus status : entry.shards().values()) {
                if (status.nodeId() == null) continue;
                nodesIds.add(status.nodeId());
            }
        }
        if (!nodesIds.isEmpty()) {
            Snapshot[] snapshots = new Snapshot[currentSnapshots.size()];
            for (int i = 0; i < currentSnapshots.size(); ++i) {
                snapshots[i] = currentSnapshots.get(i).snapshot();
            }
            this.transportNodesSnapshotsStatus.execute((TransportNodesSnapshotsStatus.Request)new TransportNodesSnapshotsStatus.Request(nodesIds.toArray(Strings.EMPTY_ARRAY)).snapshots(snapshots).timeout(request.clusterManagerNodeTimeout()), ActionListener.wrap(nodeSnapshotStatuses -> this.threadPool.generic().execute(ActionRunnable.wrap(listener, l -> this.buildResponse(snapshotsInProgress, request, currentSnapshots, (TransportNodesSnapshotsStatus.NodesSnapshotStatus)((Object)nodeSnapshotStatuses), (ActionListener<SnapshotsStatusResponse>)l))), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.buildResponse(snapshotsInProgress, request, currentSnapshots, null, listener);
        }
    }

    private void buildResponse(SnapshotsInProgress snapshotsInProgress, SnapshotsStatusRequest request, List<SnapshotsInProgress.Entry> currentSnapshotEntries, TransportNodesSnapshotsStatus.NodesSnapshotStatus nodeSnapshotStatuses, ActionListener<SnapshotsStatusResponse> listener) {
        String repositoryName;
        ArrayList<SnapshotStatus> builder = new ArrayList<SnapshotStatus>();
        HashSet<String> currentSnapshotNames = new HashSet<String>();
        if (!currentSnapshotEntries.isEmpty()) {
            Map nodeSnapshotStatusMap = nodeSnapshotStatuses != null ? nodeSnapshotStatuses.getNodesMap() : new HashMap();
            for (SnapshotsInProgress.Entry entry : currentSnapshotEntries) {
                currentSnapshotNames.add(entry.snapshot().getSnapshotId().getName());
                ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                Map indexIdLookup = null;
                for (Map.Entry<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardEntry : entry.shards().entrySet()) {
                    SnapshotIndexShardStatus shardStatus;
                    SnapshotIndexShardStage stage;
                    SnapshotIndexShardStatus shardStatus2;
                    Map<ShardId, SnapshotIndexShardStatus> shardStatues;
                    TransportNodesSnapshotsStatus.NodeSnapshotStatus nodeStatus;
                    SnapshotsInProgress.ShardSnapshotStatus status = shardEntry.getValue();
                    if (status.nodeId() != null && (nodeStatus = (TransportNodesSnapshotsStatus.NodeSnapshotStatus)((Object)nodeSnapshotStatusMap.get(status.nodeId()))) != null && (shardStatues = nodeStatus.status().get(entry.snapshot())) != null && (shardStatus2 = shardStatues.get(shardEntry.getKey())) != null) {
                        if (shardStatus2.getStage() == SnapshotIndexShardStage.DONE && shardEntry.getValue().state() != SnapshotsInProgress.ShardState.SUCCESS) {
                            shardStatus2 = new SnapshotIndexShardStatus(shardEntry.getKey(), SnapshotIndexShardStage.FINALIZE, shardStatus2.getStats(), shardStatus2.getNodeId(), shardStatus2.getFailure());
                        }
                        shardStatusBuilder.add(shardStatus2);
                        continue;
                    }
                    switch (shardEntry.getValue().state()) {
                        case FAILED: 
                        case ABORTED: 
                        case MISSING: {
                            stage = SnapshotIndexShardStage.FAILURE;
                            break;
                        }
                        case INIT: 
                        case WAITING: 
                        case QUEUED: {
                            stage = SnapshotIndexShardStage.STARTED;
                            break;
                        }
                        case SUCCESS: {
                            stage = SnapshotIndexShardStage.DONE;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown snapshot state " + shardEntry.getValue().state());
                        }
                    }
                    if (stage == SnapshotIndexShardStage.DONE) {
                        if (indexIdLookup == null) {
                            indexIdLookup = entry.indices().stream().collect(Collectors.toMap(IndexId::getName, Function.identity()));
                        }
                        ShardId shardId = shardEntry.getKey();
                        shardStatus = new SnapshotIndexShardStatus(shardId, this.repositoriesService.repository(entry.repository()).getShardSnapshotStatus(entry.snapshot().getSnapshotId(), (IndexId)indexIdLookup.get(shardId.getIndexName()), shardId).asCopy());
                    } else {
                        shardStatus = new SnapshotIndexShardStatus(shardEntry.getKey(), stage);
                    }
                    shardStatusBuilder.add(shardStatus);
                }
                builder.add(new SnapshotStatus(entry.snapshot(), entry.state(), Collections.unmodifiableList(shardStatusBuilder), entry.includeGlobalState(), entry.startTime(), Math.max(this.threadPool.absoluteTimeInMillis() - entry.startTime(), 0L)));
            }
        }
        if (Strings.hasText((String)(repositoryName = request.repository())) && !CollectionUtils.isEmpty((Object[])request.snapshots())) {
            this.loadRepositoryData(snapshotsInProgress, request, builder, currentSnapshotNames, repositoryName, listener);
        } else {
            listener.onResponse((Object)new SnapshotsStatusResponse(Collections.unmodifiableList(builder)));
        }
    }

    private void loadRepositoryData(SnapshotsInProgress snapshotsInProgress, SnapshotsStatusRequest request, List<SnapshotStatus> builder, Set<String> currentSnapshotNames, String repositoryName, ActionListener<SnapshotsStatusResponse> listener) {
        this.maximumAllowedShardCount = this.clusterService.getClusterSettings().get(SnapshotsService.MAX_SHARDS_ALLOWED_IN_STATUS_API).intValue();
        StepListener repositoryDataListener = new StepListener();
        this.repositoriesService.getRepositoryData(repositoryName, (ActionListener<RepositoryData>)repositoryDataListener);
        repositoryDataListener.whenComplete(repositoryData -> {
            Map<SnapshotId, SnapshotInfo> snapshotsInfoMap = this.snapshotsInfo(request, repositoryName, (RepositoryData)repositoryData, snapshotsInProgress, currentSnapshotNames);
            for (Map.Entry<SnapshotId, SnapshotInfo> entry : snapshotsInfoMap.entrySet()) {
                SnapshotsInProgress.State state;
                SnapshotId snapshotId = entry.getKey();
                SnapshotInfo snapshotInfo = entry.getValue();
                ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                if (!snapshotInfo.state().completed()) continue;
                Map<ShardId, IndexShardSnapshotStatus> shardStatuses = this.snapshotShards(request, repositoryName, (RepositoryData)repositoryData, snapshotInfo);
                boolean isShallowV2Snapshot = snapshotInfo.getPinnedTimestamp() > 0L;
                long initialSnapshotTotalSize = 0L;
                if (!isShallowV2Snapshot || request.indices().length == 0) {
                    // empty if block
                }
                for (Map.Entry<ShardId, IndexShardSnapshotStatus> shardStatus : shardStatuses.entrySet()) {
                    IndexShardSnapshotStatus.Copy lastSnapshotStatus = shardStatus.getValue().asCopy();
                    shardStatusBuilder.add(new SnapshotIndexShardStatus(shardStatus.getKey(), lastSnapshotStatus));
                }
                switch (snapshotInfo.state()) {
                    case FAILED: {
                        state = SnapshotsInProgress.State.FAILED;
                        break;
                    }
                    case SUCCESS: {
                        state = SnapshotsInProgress.State.SUCCESS;
                        break;
                    }
                    case PARTIAL: {
                        state = SnapshotsInProgress.State.PARTIAL;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown snapshot state " + snapshotInfo.state());
                    }
                }
                long startTime = snapshotInfo.startTime();
                long endTime = snapshotInfo.endTime();
                assert (endTime >= startTime || endTime == 0L && !snapshotInfo.state().completed()) : "Inconsistent timestamps found in SnapshotInfo [" + snapshotInfo + "]";
                builder.add(new SnapshotStatus(new Snapshot(repositoryName, snapshotId), state, Collections.unmodifiableList(shardStatusBuilder), snapshotInfo.includeGlobalState(), startTime, (endTime == 0L ? this.threadPool.absoluteTimeInMillis() : endTime) - startTime));
            }
            listener.onResponse((Object)new SnapshotsStatusResponse(Collections.unmodifiableList(builder)));
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private SnapshotInfo snapshot(SnapshotsInProgress snapshotsInProgress, String repositoryName, SnapshotId snapshotId) {
        List<SnapshotsInProgress.Entry> entries = SnapshotsService.currentSnapshots(snapshotsInProgress, repositoryName, Collections.singletonList(snapshotId.getName()));
        if (!entries.isEmpty()) {
            return new SnapshotInfo(entries.iterator().next());
        }
        return this.repositoriesService.repository(repositoryName).getSnapshotInfo(snapshotId);
    }

    private Map<SnapshotId, SnapshotInfo> snapshotsInfo(SnapshotsStatusRequest request, String repositoryName, RepositoryData repositoryData, SnapshotsInProgress snapshotsInProgress, Set<String> currentSnapshotNames) {
        HashSet requestedSnapshotNames = Sets.newHashSet((Object[])request.snapshots());
        HashMap<SnapshotId, SnapshotInfo> snapshotsInfoMap = new HashMap<SnapshotId, SnapshotInfo>();
        Map matchedSnapshotIds = repositoryData.getSnapshotIds().stream().filter(s -> requestedSnapshotNames.contains(s.getName())).collect(Collectors.toMap(SnapshotId::getName, Function.identity()));
        int totalShardsAcrossSnapshots = 0;
        for (String snapshotName : request.snapshots()) {
            boolean isV2Snapshot;
            if (currentSnapshotNames.contains(snapshotName)) continue;
            SnapshotId snapshotId = (SnapshotId)matchedSnapshotIds.get(snapshotName);
            if (snapshotId == null) {
                if (request.ignoreUnavailable()) {
                    logger.debug("snapshot status request ignoring snapshot [{}], not found in repository [{}]", (Object)snapshotName, (Object)repositoryName);
                    continue;
                }
                throw new SnapshotMissingException(repositoryName, snapshotName);
            }
            SnapshotInfo snapshotInfo = this.snapshot(snapshotsInProgress, repositoryName, snapshotId);
            boolean bl = isV2Snapshot = snapshotInfo.getPinnedTimestamp() > 0L;
            if (!isV2Snapshot && request.indices().length == 0) {
                totalShardsAcrossSnapshots += snapshotInfo.totalShards();
            }
            snapshotsInfoMap.put(snapshotId, snapshotInfo);
        }
        if ((long)totalShardsAcrossSnapshots > this.maximumAllowedShardCount && request.indices().length == 0) {
            String message = "[" + repositoryName + ":" + String.join((CharSequence)", ", request.snapshots()) + "] Total shard count [" + totalShardsAcrossSnapshots + "] is more than the maximum allowed value of shard count [" + this.maximumAllowedShardCount + "] for snapshot status request";
            throw new CircuitBreakingException(message, CircuitBreaker.Durability.PERMANENT);
        }
        return Collections.unmodifiableMap(snapshotsInfoMap);
    }

    private Map<ShardId, IndexShardSnapshotStatus> snapshotShards(SnapshotsStatusRequest request, String repositoryName, RepositoryData repositoryData, SnapshotInfo snapshotInfo) throws IOException {
        HashSet requestedIndexNames = Sets.newHashSet((Object[])request.indices());
        String snapshotName = snapshotInfo.snapshotId().getName();
        HashSet indices = Sets.newHashSet(snapshotInfo.indices());
        if (!requestedIndexNames.isEmpty()) {
            HashSet finalIndices = indices;
            List indicesNotFound = requestedIndexNames.stream().filter(i -> !finalIndices.contains(i)).collect(Collectors.toList());
            if (!indicesNotFound.isEmpty()) {
                this.handleIndexNotFound(String.join((CharSequence)", ", indicesNotFound), request, snapshotName, repositoryName);
            }
            indices = requestedIndexNames;
        }
        Repository repository = this.repositoriesService.repository(repositoryName);
        boolean isV2Snapshot = snapshotInfo.getPinnedTimestamp() > 0L;
        int totalShardsAcrossIndices = 0;
        HashMap<IndexId, IndexMetadata> indexMetadataMap = new HashMap<IndexId, IndexMetadata>();
        for (String index : indices) {
            IndexId indexId = repositoryData.resolveIndexId(index);
            IndexMetadata indexMetadata = repository.getSnapshotIndexMetaData(repositoryData, snapshotInfo.snapshotId(), indexId);
            if (indexMetadata != null) {
                if (!requestedIndexNames.isEmpty() && !isV2Snapshot) {
                    totalShardsAcrossIndices += indexMetadata.getNumberOfShards();
                }
                indexMetadataMap.put(indexId, indexMetadata);
                continue;
            }
            if (requestedIndexNames.isEmpty()) continue;
            this.handleIndexNotFound(index, request, snapshotName, repositoryName);
        }
        if ((long)totalShardsAcrossIndices > this.maximumAllowedShardCount && !requestedIndexNames.isEmpty() && !isV2Snapshot) {
            String message = "[" + repositoryName + ":" + String.join((CharSequence)", ", request.snapshots()) + "] Total shard count [" + totalShardsAcrossIndices + "] across the requested indices [" + requestedIndexNames.stream().collect(Collectors.joining(", ")) + "] is more than the maximum allowed value of shard count [" + this.maximumAllowedShardCount + "] for snapshot status request";
            throw new CircuitBreakingException(message, CircuitBreaker.Durability.PERMANENT);
        }
        HashMap<ShardId, IndexShardSnapshotStatus> shardStatus = new HashMap<ShardId, IndexShardSnapshotStatus>();
        for (Map.Entry entry : indexMetadataMap.entrySet()) {
            IndexId indexId = (IndexId)entry.getKey();
            IndexMetadata indexMetadata = (IndexMetadata)entry.getValue();
            if (indexMetadata == null) continue;
            int numberOfShards = indexMetadata.getNumberOfShards();
            for (int i2 = 0; i2 < numberOfShards; ++i2) {
                ShardId shardId = new ShardId(indexMetadata.getIndex(), i2);
                SnapshotShardFailure shardFailure = TransportSnapshotsStatusAction.findShardFailure(snapshotInfo.shardFailures(), shardId);
                if (shardFailure != null) {
                    shardStatus.put(shardId, IndexShardSnapshotStatus.newFailed(shardFailure.reason()));
                    continue;
                }
                IndexShardSnapshotStatus shardSnapshotStatus = snapshotInfo.state() == SnapshotState.FAILED ? IndexShardSnapshotStatus.newFailed("skipped") : (isV2Snapshot ? IndexShardSnapshotStatus.newDone(0L, 0L, 0, 0, 0L, 0L, null) : repository.getShardSnapshotStatus(snapshotInfo.snapshotId(), indexId, shardId));
                shardStatus.put(shardId, shardSnapshotStatus);
            }
        }
        return Collections.unmodifiableMap(shardStatus);
    }

    private void handleIndexNotFound(String index, SnapshotsStatusRequest request, String snapshotName, String repositoryName) {
        if (!request.ignoreUnavailable()) {
            String cause = "indices [" + index + "] missing in snapshot [" + snapshotName + "] of repository [" + repositoryName + "]";
            throw new IndexNotFoundException(index, (Throwable)new IllegalArgumentException(cause));
        }
        logger.debug("snapshot status request ignoring indices [{}], not found in snapshot[{}] in repository [{}]", (Object)index, (Object)snapshotName, (Object)repositoryName);
    }

    private static SnapshotShardFailure findShardFailure(List<SnapshotShardFailure> shardFailures, ShardId shardId) {
        for (SnapshotShardFailure shardFailure : shardFailures) {
            if (!shardId.getIndexName().equals(shardFailure.index()) || shardId.getId() != shardFailure.shardId()) continue;
            return shardFailure;
        }
        return null;
    }
}

