/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import java.io.IOException;
import org.opensearch.cluster.coordination.TermVersionRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class RemotePublishRequest
extends TermVersionRequest {
    private final String clusterName;
    private final String clusterUUID;
    private final String manifestFile;

    public RemotePublishRequest(DiscoveryNode sourceNode, long term, long version, String clusterName, String clusterUUID, String manifestFile) {
        super(sourceNode, term, version);
        this.clusterName = clusterName;
        this.clusterUUID = clusterUUID;
        this.manifestFile = manifestFile;
    }

    public RemotePublishRequest(StreamInput in) throws IOException {
        super(in);
        this.clusterName = in.readString();
        this.clusterUUID = in.readString();
        this.manifestFile = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.clusterName);
        out.writeString(this.clusterUUID);
        out.writeString(this.manifestFile);
    }

    @Override
    public String toString() {
        return "RemotePublishRequest{term=" + this.term + ", version=" + this.version + ", clusterName=" + this.clusterName + ", clusterUUID=" + this.clusterUUID + ", sourceNode=" + this.sourceNode + ", manifestFile=" + this.manifestFile + "}";
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public String getManifestFile() {
        return this.manifestFile;
    }
}

