/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.repositories.IndexId;
import org.opensearch.snapshots.Snapshot;

@PublicApi(since="1.0.0")
public abstract class RecoverySource
implements Writeable,
ToXContentObject {
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", (Object)this.getType());
        this.addAdditionalFields(builder, params);
        return builder.endObject();
    }

    public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static RecoverySource readFrom(StreamInput in) throws IOException {
        Type type = Type.values()[in.readByte()];
        switch (type) {
            case EMPTY_STORE: {
                return EmptyStoreRecoverySource.INSTANCE;
            }
            case EXISTING_STORE: {
                return ExistingStoreRecoverySource.read(in);
            }
            case PEER: {
                return PeerRecoverySource.INSTANCE;
            }
            case SNAPSHOT: {
                return new SnapshotRecoverySource(in);
            }
            case LOCAL_SHARDS: {
                return LocalShardsRecoverySource.INSTANCE;
            }
            case REMOTE_STORE: {
                return new RemoteStoreRecoverySource(in);
            }
        }
        throw new IllegalArgumentException("unknown recovery type: " + type.name());
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeByte((byte)this.getType().ordinal());
        this.writeAdditionalFields(out);
    }

    protected void writeAdditionalFields(StreamOutput out) throws IOException {
    }

    public abstract Type getType();

    public boolean shouldBootstrapNewHistoryUUID() {
        return false;
    }

    public boolean expectEmptyRetentionLeases() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecoverySource that = (RecoverySource)o;
        return this.getType() == that.getType();
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    @PublicApi(since="1.0.0")
    public static enum Type {
        EMPTY_STORE,
        EXISTING_STORE,
        PEER,
        SNAPSHOT,
        LOCAL_SHARDS,
        REMOTE_STORE;

    }

    public static final class EmptyStoreRecoverySource
    extends RecoverySource {
        public static final EmptyStoreRecoverySource INSTANCE = new EmptyStoreRecoverySource();

        @Override
        public Type getType() {
            return Type.EMPTY_STORE;
        }

        public String toString() {
            return "new shard recovery";
        }
    }

    public static final class ExistingStoreRecoverySource
    extends RecoverySource {
        public static final String FORCED_ALLOCATION_ID = "_forced_allocation_";
        public static final ExistingStoreRecoverySource INSTANCE = new ExistingStoreRecoverySource(false);
        public static final ExistingStoreRecoverySource FORCE_STALE_PRIMARY_INSTANCE = new ExistingStoreRecoverySource(true);
        private final boolean bootstrapNewHistoryUUID;

        private ExistingStoreRecoverySource(boolean bootstrapNewHistoryUUID) {
            this.bootstrapNewHistoryUUID = bootstrapNewHistoryUUID;
        }

        private static ExistingStoreRecoverySource read(StreamInput in) throws IOException {
            return in.readBoolean() ? FORCE_STALE_PRIMARY_INSTANCE : INSTANCE;
        }

        @Override
        public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("bootstrap_new_history_uuid", this.bootstrapNewHistoryUUID);
        }

        @Override
        protected void writeAdditionalFields(StreamOutput out) throws IOException {
            out.writeBoolean(this.bootstrapNewHistoryUUID);
        }

        @Override
        public boolean shouldBootstrapNewHistoryUUID() {
            return this.bootstrapNewHistoryUUID;
        }

        @Override
        public Type getType() {
            return Type.EXISTING_STORE;
        }

        public String toString() {
            return "existing store recovery; bootstrap_history_uuid=" + this.bootstrapNewHistoryUUID;
        }

        @Override
        public boolean expectEmptyRetentionLeases() {
            return this.bootstrapNewHistoryUUID;
        }
    }

    public static class PeerRecoverySource
    extends RecoverySource {
        public static final PeerRecoverySource INSTANCE = new PeerRecoverySource();

        private PeerRecoverySource() {
        }

        @Override
        public Type getType() {
            return Type.PEER;
        }

        public String toString() {
            return "peer recovery";
        }

        @Override
        public boolean expectEmptyRetentionLeases() {
            return false;
        }
    }

    @PublicApi(since="1.0.0")
    public static class SnapshotRecoverySource
    extends RecoverySource {
        public static final String NO_API_RESTORE_UUID = "_no_api_";
        private final String restoreUUID;
        private final Snapshot snapshot;
        private final IndexId index;
        private final Version version;
        private final boolean isSearchableSnapshot;
        private final boolean remoteStoreIndexShallowCopy;
        private final String sourceRemoteStoreRepository;
        private final String sourceRemoteTranslogRepository;
        private final long pinnedTimestamp;

        public SnapshotRecoverySource(String restoreUUID, Snapshot snapshot, Version version, IndexId indexId) {
            this(restoreUUID, snapshot, version, indexId, false, false, null);
        }

        public SnapshotRecoverySource(String restoreUUID, Snapshot snapshot, Version version, IndexId indexId, boolean isSearchableSnapshot, boolean remoteStoreIndexShallowCopy, @Nullable String sourceRemoteStoreRepository) {
            this(restoreUUID, snapshot, version, indexId, isSearchableSnapshot, remoteStoreIndexShallowCopy, sourceRemoteStoreRepository, null, 0L);
        }

        public SnapshotRecoverySource(String restoreUUID, Snapshot snapshot, Version version, IndexId indexId, boolean isSearchableSnapshot, boolean remoteStoreIndexShallowCopy, @Nullable String sourceRemoteStoreRepository, @Nullable String sourceRemoteTranslogRepository, long pinnedTimestamp) {
            this.restoreUUID = restoreUUID;
            this.snapshot = Objects.requireNonNull(snapshot);
            this.version = Objects.requireNonNull(version);
            this.index = Objects.requireNonNull(indexId);
            this.isSearchableSnapshot = isSearchableSnapshot;
            this.remoteStoreIndexShallowCopy = remoteStoreIndexShallowCopy;
            this.sourceRemoteStoreRepository = sourceRemoteStoreRepository;
            this.sourceRemoteTranslogRepository = sourceRemoteTranslogRepository;
            this.pinnedTimestamp = pinnedTimestamp;
        }

        SnapshotRecoverySource(StreamInput in) throws IOException {
            this.restoreUUID = in.readString();
            this.snapshot = new Snapshot(in);
            this.version = in.readVersion();
            this.index = in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_7_0) ? new IndexId(in) : new IndexId(in.readString(), "_na_");
            this.isSearchableSnapshot = in.getVersion().onOrAfter(Version.V_2_7_0) ? in.readBoolean() : false;
            if (in.getVersion().onOrAfter(Version.V_2_9_0)) {
                this.remoteStoreIndexShallowCopy = in.readBoolean();
                this.sourceRemoteStoreRepository = in.readOptionalString();
            } else {
                this.remoteStoreIndexShallowCopy = false;
                this.sourceRemoteStoreRepository = null;
            }
            if (in.getVersion().onOrAfter(Version.V_2_17_0)) {
                this.sourceRemoteTranslogRepository = in.readOptionalString();
                this.pinnedTimestamp = in.readLong();
            } else {
                this.sourceRemoteTranslogRepository = null;
                this.pinnedTimestamp = 0L;
            }
        }

        public String restoreUUID() {
            return this.restoreUUID;
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public IndexId index() {
            return this.index;
        }

        public Version version() {
            return this.version;
        }

        public boolean isSearchableSnapshot() {
            return this.isSearchableSnapshot;
        }

        public String sourceRemoteStoreRepository() {
            return this.sourceRemoteStoreRepository;
        }

        public String sourceRemoteTranslogRepository() {
            return this.sourceRemoteTranslogRepository;
        }

        public boolean remoteStoreIndexShallowCopy() {
            return this.remoteStoreIndexShallowCopy;
        }

        public long pinnedTimestamp() {
            return this.pinnedTimestamp;
        }

        @Override
        protected void writeAdditionalFields(StreamOutput out) throws IOException {
            out.writeString(this.restoreUUID);
            this.snapshot.writeTo(out);
            out.writeVersion(this.version);
            if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_7_0)) {
                this.index.writeTo(out);
            } else {
                out.writeString(this.index.getName());
            }
            if (out.getVersion().onOrAfter(Version.V_2_7_0)) {
                out.writeBoolean(this.isSearchableSnapshot);
            }
            if (out.getVersion().onOrAfter(Version.V_2_9_0)) {
                out.writeBoolean(this.remoteStoreIndexShallowCopy);
                out.writeOptionalString(this.sourceRemoteStoreRepository);
            }
            if (out.getVersion().onOrAfter(Version.V_2_17_0)) {
                out.writeOptionalString(this.sourceRemoteTranslogRepository);
                out.writeLong(this.pinnedTimestamp);
            }
        }

        @Override
        public Type getType() {
            return Type.SNAPSHOT;
        }

        @Override
        public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("repository", this.snapshot.getRepository()).field("snapshot", this.snapshot.getSnapshotId().getName()).field("version", this.version.toString()).field("index", this.index.getName()).field("restoreUUID", this.restoreUUID).field("isSearchableSnapshot", this.isSearchableSnapshot).field("remoteStoreIndexShallowCopy", this.remoteStoreIndexShallowCopy).field("sourceRemoteStoreRepository", this.sourceRemoteStoreRepository).field("sourceRemoteTranslogRepository", this.sourceRemoteTranslogRepository);
        }

        public String toString() {
            return "snapshot recovery [" + this.restoreUUID + "] from " + this.snapshot;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnapshotRecoverySource that = (SnapshotRecoverySource)o;
            return this.restoreUUID.equals(that.restoreUUID) && this.snapshot.equals(that.snapshot) && this.index.equals(that.index) && this.version.equals((Object)that.version) && this.isSearchableSnapshot == that.isSearchableSnapshot && this.remoteStoreIndexShallowCopy == that.remoteStoreIndexShallowCopy && this.sourceRemoteStoreRepository != null ? this.sourceRemoteStoreRepository.equals(that.sourceRemoteStoreRepository) : (that.sourceRemoteStoreRepository == null && this.sourceRemoteTranslogRepository != null ? this.sourceRemoteTranslogRepository.equals(that.sourceRemoteTranslogRepository) : that.sourceRemoteTranslogRepository == null && this.pinnedTimestamp == that.pinnedTimestamp);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.restoreUUID, this.snapshot, this.index, this.version, this.isSearchableSnapshot, this.remoteStoreIndexShallowCopy, this.sourceRemoteStoreRepository, this.sourceRemoteTranslogRepository, this.pinnedTimestamp);
        }
    }

    public static class LocalShardsRecoverySource
    extends RecoverySource {
        public static final LocalShardsRecoverySource INSTANCE = new LocalShardsRecoverySource();

        private LocalShardsRecoverySource() {
        }

        @Override
        public Type getType() {
            return Type.LOCAL_SHARDS;
        }

        public String toString() {
            return "local shards recovery";
        }
    }

    @PublicApi(since="1.0.0")
    public static class RemoteStoreRecoverySource
    extends RecoverySource {
        private final String restoreUUID;
        private final IndexId index;
        private final Version version;

        public RemoteStoreRecoverySource(String restoreUUID, Version version, IndexId indexId) {
            this.restoreUUID = restoreUUID;
            this.version = Objects.requireNonNull(version);
            this.index = Objects.requireNonNull(indexId);
        }

        RemoteStoreRecoverySource(StreamInput in) throws IOException {
            this.restoreUUID = in.readString();
            this.version = in.readVersion();
            this.index = in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_7_0) ? new IndexId(in) : new IndexId(in.readString(), "_na_");
        }

        public String restoreUUID() {
            return this.restoreUUID;
        }

        public IndexId index() {
            return this.index;
        }

        public Version version() {
            return this.version;
        }

        @Override
        protected void writeAdditionalFields(StreamOutput out) throws IOException {
            out.writeString(this.restoreUUID);
            out.writeVersion(this.version);
            if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_7_0)) {
                this.index.writeTo(out);
            } else {
                out.writeString(this.index.getName());
            }
        }

        @Override
        public Type getType() {
            return Type.REMOTE_STORE;
        }

        @Override
        public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("version", this.version.toString()).field("index", this.index.getName()).field("restoreUUID", this.restoreUUID);
        }

        public String toString() {
            return "remote store recovery [" + this.restoreUUID + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteStoreRecoverySource that = (RemoteStoreRecoverySource)o;
            return this.restoreUUID.equals(that.restoreUUID) && this.index.equals(that.index) && this.version.equals((Object)that.version);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.restoreUUID, this.index, this.version);
        }

        @Override
        public boolean expectEmptyRetentionLeases() {
            return false;
        }
    }
}

