/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RoutingChangesObserver;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.cluster.routing.allocation.StaleShard;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.remote.RemoteMigrationIndexMetadataUpdater;

public class IndexMetadataUpdater
extends RoutingChangesObserver.AbstractRoutingChangesObserver {
    private final Logger logger = LogManager.getLogger(IndexMetadataUpdater.class);
    private final Map<ShardId, Updates> shardChanges = new HashMap<ShardId, Updates>();
    private boolean ongoingRemoteStoreMigration = false;

    @Override
    public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
        assert (!initializedShard.isRelocationTarget()) : "shardInitialized is not called on relocation target: " + initializedShard;
        if (initializedShard.primary()) {
            this.increasePrimaryTerm(initializedShard.shardId());
            Updates updates = this.changes(initializedShard.shardId());
            assert (updates.initializedPrimary == null) : "Primary cannot be initialized more than once in same allocation round: (previous: " + updates.initializedPrimary + ", next: " + initializedShard + ")";
            updates.initializedPrimary = initializedShard;
        }
    }

    @Override
    public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
        assert (Objects.equals(initializingShard.allocationId().getId(), startedShard.allocationId().getId())) : "initializingShard.allocationId [" + initializingShard.allocationId().getId() + "] and startedShard.allocationId [" + startedShard.allocationId().getId() + "] have to have the same";
        Updates updates = this.changes(startedShard.shardId());
        updates.addedAllocationIds.add(startedShard.allocationId().getId());
        if (startedShard.primary() && initializingShard.recoverySource() == RecoverySource.ExistingStoreRecoverySource.FORCE_STALE_PRIMARY_INSTANCE) {
            updates.removedAllocationIds.add("_forced_allocation_");
        }
    }

    @Override
    public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
        if (failedShard.active() && failedShard.primary()) {
            Updates updates = this.changes(failedShard.shardId());
            if (updates.firstFailedPrimary == null) {
                updates.firstFailedPrimary = failedShard;
            }
            this.increasePrimaryTerm(failedShard.shardId());
        }
        if (this.ongoingRemoteStoreMigration) {
            this.changes(failedShard.shardId());
        }
    }

    @Override
    public void relocationCompleted(ShardRouting removedRelocationSource) {
        this.removeAllocationId(removedRelocationSource);
    }

    @Override
    public void relocationStarted(ShardRouting startedShard, ShardRouting targetRelocatingShard) {
        if (this.ongoingRemoteStoreMigration) {
            this.changes(targetRelocatingShard.shardId());
        }
    }

    public Metadata applyChanges(Metadata oldMetadata, RoutingTable newRoutingTable, DiscoveryNodes discoveryNodes) {
        Map<Index, List<Map.Entry>> changesGroupedByIndex = this.shardChanges.entrySet().stream().collect(Collectors.groupingBy(e -> ((ShardId)e.getKey()).getIndex()));
        Metadata.Builder metadataBuilder = null;
        for (Map.Entry<Index, List<Map.Entry>> indexChanges : changesGroupedByIndex.entrySet()) {
            Index index = indexChanges.getKey();
            IndexMetadata oldIndexMetadata = oldMetadata.getIndexSafe(index);
            IndexMetadata.Builder indexMetadataBuilder = null;
            for (Map.Entry shardEntry : indexChanges.getValue()) {
                ShardId shardId = (ShardId)shardEntry.getKey();
                Updates updates = (Updates)shardEntry.getValue();
                indexMetadataBuilder = this.updateInSyncAllocations(newRoutingTable, oldIndexMetadata, indexMetadataBuilder, shardId, updates);
                indexMetadataBuilder = this.updatePrimaryTerm(oldIndexMetadata, indexMetadataBuilder, shardId, updates);
                if (!this.ongoingRemoteStoreMigration) continue;
                RemoteMigrationIndexMetadataUpdater migrationImdUpdater = new RemoteMigrationIndexMetadataUpdater(discoveryNodes, newRoutingTable, oldIndexMetadata, oldMetadata.settings(), this.logger);
                migrationImdUpdater.maybeUpdateRemoteStoreCustomMetadata(indexMetadataBuilder, index.getName());
                migrationImdUpdater.maybeAddRemoteIndexSettings(indexMetadataBuilder, index.getName());
            }
            if (indexMetadataBuilder == null) continue;
            if (metadataBuilder == null) {
                metadataBuilder = Metadata.builder(oldMetadata);
            }
            metadataBuilder.put(indexMetadataBuilder);
        }
        if (metadataBuilder != null) {
            return metadataBuilder.build();
        }
        return oldMetadata;
    }

    private IndexMetadata.Builder updateInSyncAllocations(RoutingTable newRoutingTable, IndexMetadata oldIndexMetadata, IndexMetadata.Builder indexMetadataBuilder, ShardId shardId, Updates updates) {
        assert (Sets.haveEmptyIntersection(updates.addedAllocationIds, updates.removedAllocationIds)) : "allocation ids cannot be both added and removed in the same allocation round, added ids: " + updates.addedAllocationIds + ", removed ids: " + updates.removedAllocationIds;
        Set<String> oldInSyncAllocationIds = oldIndexMetadata.inSyncAllocationIds(shardId.id());
        if (updates.initializedPrimary != null && !oldInSyncAllocationIds.isEmpty() && !oldInSyncAllocationIds.contains(updates.initializedPrimary.allocationId().getId())) {
            boolean emptyPrimary;
            RecoverySource recoverySource = updates.initializedPrimary.recoverySource();
            RecoverySource.Type recoverySourceType = recoverySource.getType();
            boolean bl = emptyPrimary = recoverySourceType == RecoverySource.Type.EMPTY_STORE;
            assert (updates.addedAllocationIds.isEmpty()) : (emptyPrimary ? "empty" : "stale") + " primary is not force-initialized in same allocation round where shards are started";
            if (indexMetadataBuilder == null) {
                indexMetadataBuilder = IndexMetadata.builder(oldIndexMetadata);
            }
            if (emptyPrimary) {
                indexMetadataBuilder.putInSyncAllocationIds(shardId.id(), Collections.emptySet());
            } else {
                String allocationId;
                if (recoverySource == RecoverySource.ExistingStoreRecoverySource.FORCE_STALE_PRIMARY_INSTANCE) {
                    allocationId = "_forced_allocation_";
                } else {
                    assert (recoverySource instanceof RecoverySource.SnapshotRecoverySource || recoverySource instanceof RecoverySource.RemoteStoreRecoverySource) : recoverySource;
                    allocationId = updates.initializedPrimary.allocationId().getId();
                }
                indexMetadataBuilder.putInSyncAllocationIds(shardId.id(), Collections.singleton(allocationId));
            }
        } else {
            Set<String> inSyncAllocationIds = new HashSet<String>(oldInSyncAllocationIds);
            inSyncAllocationIds.addAll(updates.addedAllocationIds);
            inSyncAllocationIds.removeAll(updates.removedAllocationIds);
            assert (!oldInSyncAllocationIds.contains("_forced_allocation_") || !inSyncAllocationIds.contains("_forced_allocation_")) : "fake allocation id has to be removed, inSyncAllocationIds:" + inSyncAllocationIds;
            int maxActiveShards = oldIndexMetadata.getNumberOfReplicas() + oldIndexMetadata.getNumberOfSearchOnlyReplicas() + 1;
            IndexShardRoutingTable newShardRoutingTable = newRoutingTable.shardRoutingTable(shardId);
            assert (newShardRoutingTable.assignedShards().stream().filter(ShardRouting::isRelocationTarget).map(s -> s.allocationId().getId()).noneMatch(inSyncAllocationIds::contains)) : newShardRoutingTable.assignedShards() + " vs " + inSyncAllocationIds;
            if (inSyncAllocationIds.size() > oldInSyncAllocationIds.size() && inSyncAllocationIds.size() > maxActiveShards) {
                List assignedShards = newShardRoutingTable.assignedShards().stream().filter(s -> !s.isRelocationTarget()).collect(Collectors.toList());
                assert (assignedShards.size() <= maxActiveShards) : "cannot have more assigned shards " + assignedShards + " than maximum possible active shards " + maxActiveShards;
                Set assignedAllocations = assignedShards.stream().map(s -> s.allocationId().getId()).collect(Collectors.toSet());
                inSyncAllocationIds = inSyncAllocationIds.stream().sorted(Comparator.comparing(assignedAllocations::contains).reversed()).limit(maxActiveShards).collect(Collectors.toSet());
            }
            if (newShardRoutingTable.activeShards().isEmpty() && updates.firstFailedPrimary != null) {
                inSyncAllocationIds.add(updates.firstFailedPrimary.allocationId().getId());
            }
            assert (!inSyncAllocationIds.isEmpty() || oldInSyncAllocationIds.isEmpty()) : "in-sync allocations cannot become empty after they have been non-empty: " + oldInSyncAllocationIds;
            if (!inSyncAllocationIds.isEmpty()) {
                if (indexMetadataBuilder == null) {
                    indexMetadataBuilder = IndexMetadata.builder(oldIndexMetadata);
                }
                indexMetadataBuilder.putInSyncAllocationIds(shardId.id(), inSyncAllocationIds);
            }
        }
        return indexMetadataBuilder;
    }

    public static ClusterState removeStaleIdsWithoutRoutings(ClusterState clusterState, List<StaleShard> staleShards, Logger logger) {
        Metadata oldMetadata = clusterState.metadata();
        RoutingTable oldRoutingTable = clusterState.routingTable();
        Metadata.Builder metadataBuilder = null;
        for (Map.Entry<Index, List<StaleShard>> indexEntry : staleShards.stream().collect(Collectors.groupingBy(fs -> fs.getShardId().getIndex())).entrySet()) {
            IndexMetadata oldIndexMetadata = oldMetadata.getIndexSafe(indexEntry.getKey());
            IndexMetadata.Builder indexMetadataBuilder = null;
            for (Map.Entry<ShardId, List<StaleShard>> shardEntry : indexEntry.getValue().stream().collect(Collectors.groupingBy(staleShard -> staleShard.getShardId())).entrySet()) {
                int shardNumber = shardEntry.getKey().getId();
                Set<String> oldInSyncAllocations = oldIndexMetadata.inSyncAllocationIds(shardNumber);
                Set idsToRemove = shardEntry.getValue().stream().map(e -> e.getAllocationId()).collect(Collectors.toSet());
                assert (idsToRemove.stream().allMatch(id -> oldRoutingTable.getByAllocationId((ShardId)shardEntry.getKey(), (String)id) == null)) : "removing stale ids: " + idsToRemove + ", some of which have still a routing entry: " + oldRoutingTable;
                Set remainingInSyncAllocations = Sets.difference(oldInSyncAllocations, idsToRemove);
                assert (!remainingInSyncAllocations.isEmpty()) : "Set of in-sync ids cannot become empty for shard " + shardEntry.getKey() + " (before: " + oldInSyncAllocations + ", ids to remove: " + idsToRemove + ")";
                if (!remainingInSyncAllocations.isEmpty()) {
                    if (indexMetadataBuilder == null) {
                        indexMetadataBuilder = IndexMetadata.builder(oldIndexMetadata);
                    }
                    indexMetadataBuilder.putInSyncAllocationIds(shardNumber, remainingInSyncAllocations);
                }
                logger.warn("{} marking unavailable shards as stale: {}", (Object)shardEntry.getKey(), idsToRemove);
            }
            if (indexMetadataBuilder == null) continue;
            if (metadataBuilder == null) {
                metadataBuilder = Metadata.builder(oldMetadata);
            }
            metadataBuilder.put(indexMetadataBuilder);
        }
        if (metadataBuilder != null) {
            return ClusterState.builder(clusterState).metadata(metadataBuilder).build();
        }
        return clusterState;
    }

    private IndexMetadata.Builder updatePrimaryTerm(IndexMetadata oldIndexMetadata, IndexMetadata.Builder indexMetadataBuilder, ShardId shardId, Updates updates) {
        if (updates.increaseTerm) {
            if (indexMetadataBuilder == null) {
                indexMetadataBuilder = IndexMetadata.builder(oldIndexMetadata);
            }
            indexMetadataBuilder.primaryTerm(shardId.id(), oldIndexMetadata.primaryTerm(shardId.id()) + 1L);
        }
        return indexMetadataBuilder;
    }

    private Updates changes(ShardId shardId) {
        return this.shardChanges.computeIfAbsent(shardId, k -> new Updates());
    }

    void removeAllocationId(ShardRouting shardRouting) {
        if (shardRouting.active()) {
            this.changes((ShardId)shardRouting.shardId()).removedAllocationIds.add(shardRouting.allocationId().getId());
        }
    }

    private void increasePrimaryTerm(ShardId shardId) {
        this.changes((ShardId)shardId).increaseTerm = true;
    }

    public void setOngoingRemoteStoreMigration(boolean ongoingRemoteStoreMigration) {
        this.ongoingRemoteStoreMigration = ongoingRemoteStoreMigration;
    }

    private static class Updates {
        private boolean increaseTerm;
        private Set<String> addedAllocationIds = new HashSet<String>();
        private Set<String> removedAllocationIds = new HashSet<String>();
        private ShardRouting initializedPrimary = null;
        private ShardRouting firstFailedPrimary = null;

        private Updates() {
        }
    }
}

