/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.RoutingNodes;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.opensearch.cluster.routing.allocation.NodeAllocationResult;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.gateway.BaseGatewayShardAllocator;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadata;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadataHelper;

public abstract class ReplicaShardAllocator
extends BaseGatewayShardAllocator {
    protected boolean shouldSkipFetchForRecovery(ShardRouting shard) {
        if (shard.primary()) {
            return true;
        }
        if (!shard.initializing()) {
            return true;
        }
        if (shard.relocatingNodeId() != null) {
            return true;
        }
        return shard.unassignedInfo() != null && shard.unassignedInfo().getReason() == UnassignedInfo.Reason.INDEX_CREATED;
    }

    protected Runnable cancelExistingRecoveryForBetterMatch(ShardRouting shard, RoutingAllocation allocation, Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> nodeShardStores) {
        DiscoveryNode nodeWithHighestMatch;
        DiscoveryNode currentNode;
        if (nodeShardStores == null) {
            this.logger.trace("{}: fetching new stores for initializing shard", (Object)shard);
            return null;
        }
        Metadata metadata = allocation.metadata();
        RoutingNodes routingNodes = allocation.routingNodes();
        ShardRouting primaryShard = allocation.routingNodes().activePrimary(shard.shardId());
        if (primaryShard == null) {
            this.logger.trace("{}: no active primary shard found or allocated, letting actual allocation figure it out", (Object)shard);
            return null;
        }
        assert (primaryShard.currentNodeId() != null);
        DiscoveryNode primaryNode = allocation.nodes().get(primaryShard.currentNodeId());
        TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata primaryStore = ReplicaShardAllocator.findStore(primaryNode, nodeShardStores);
        if (primaryStore == null) {
            this.logger.trace("{}: no primary shard store found or allocated, letting actual allocation figure it out", (Object)shard);
            return null;
        }
        MatchingNodes matchingNodes = this.findMatchingNodes(shard, allocation, true, primaryNode, primaryStore, nodeShardStores, false);
        if (matchingNodes.getNodeWithHighestMatch() != null && !(currentNode = allocation.nodes().get(shard.currentNodeId())).equals(nodeWithHighestMatch = matchingNodes.getNodeWithHighestMatch()) && matchingNodes.canPerformNoopRecovery(nodeWithHighestMatch) && !ReplicaShardAllocator.canPerformOperationBasedRecovery(primaryStore, nodeShardStores, currentNode)) {
            this.logger.debug("cancelling allocation of replica on [{}], can perform a noop recovery on node [{}]", (Object)currentNode, (Object)nodeWithHighestMatch);
            Set<String> failedNodeIds = shard.unassignedInfo() == null ? Collections.emptySet() : shard.unassignedInfo().getFailedNodeIds();
            UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.REALLOCATED_REPLICA, "existing allocation of replica to [" + currentNode + "] cancelled, can perform a noop recovery on [" + nodeWithHighestMatch + "]", null, 0, allocation.getCurrentNanoTime(), System.currentTimeMillis(), false, UnassignedInfo.AllocationStatus.NO_ATTEMPT, failedNodeIds);
            return () -> routingNodes.failShard(this.logger, shard, unassignedInfo, metadata.getIndexSafe(shard.index()), allocation.changes());
        }
        return null;
    }

    public void processExistingRecoveries(RoutingAllocation allocation) {
        RoutingNodes routingNodes = allocation.routingNodes();
        ArrayList<Runnable> shardCancellationActions = new ArrayList<Runnable>();
        for (RoutingNode routingNode : routingNodes) {
            for (ShardRouting shard : routingNode) {
                AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> shardStores;
                Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> nodeShardStores;
                Runnable cancellationAction;
                if (this.shouldSkipFetchForRecovery(shard) || (cancellationAction = this.cancelExistingRecoveryForBetterMatch(shard, allocation, nodeShardStores = this.convertToNodeStoreFilesMetadataMap(shardStores = this.fetchData(shard, allocation)))) == null) continue;
                shardCancellationActions.add(cancellationAction);
            }
        }
        for (Runnable action : shardCancellationActions) {
            action.run();
        }
    }

    @Override
    protected boolean isResponsibleFor(ShardRouting shard) {
        return !shard.primary() && shard.unassigned() && shard.unassignedInfo().getReason() != UnassignedInfo.Reason.INDEX_CREATED;
    }

    @Override
    public AllocateUnassignedDecision makeAllocationDecision(ShardRouting unassignedShard, RoutingAllocation allocation, Logger logger) {
        if (!this.isResponsibleFor(unassignedShard)) {
            return AllocateUnassignedDecision.NOT_TAKEN;
        }
        Tuple<Decision, Map<String, NodeAllocationResult>> result = ReplicaShardAllocator.canBeAllocatedToAtLeastOneNode(unassignedShard, allocation);
        Decision allocateDecision = (Decision)result.v1();
        if (!(allocateDecision.type() == Decision.Type.YES || allocation.debugDecision() && this.hasInitiatedFetching(unassignedShard))) {
            logger.trace("{}: ignoring allocation, can't be allocated on any node", (Object)unassignedShard);
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.fromDecision(allocateDecision.type()), result.v2() != null ? new ArrayList(((Map)result.v2()).values()) : null);
        }
        AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> shardStores = this.fetchData(unassignedShard, allocation);
        Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> nodeShardStores = this.convertToNodeStoreFilesMetadataMap(shardStores);
        return this.getAllocationDecision(unassignedShard, allocation, nodeShardStores, result, logger);
    }

    protected AllocateUnassignedDecision getAllocationDecision(ShardRouting unassignedShard, RoutingAllocation allocation, Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> nodeShardStores, Tuple<Decision, Map<String, NodeAllocationResult>> allocationDecision, Logger logger) {
        if (nodeShardStores == null) {
            logger.trace("{}: ignoring allocation, still fetching shard stores", (Object)unassignedShard);
            allocation.setHasPendingAsyncFetch();
            List<NodeAllocationResult> nodeDecisions = null;
            if (allocation.debugDecision()) {
                nodeDecisions = ReplicaShardAllocator.buildDecisionsForAllNodes(unassignedShard, allocation);
            }
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, nodeDecisions);
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        boolean explain = allocation.debugDecision();
        ShardRouting primaryShard = routingNodes.activePrimary(unassignedShard.shardId());
        if (primaryShard == null) {
            assert (explain) : "primary should only be null here if we are in explain mode, so we didn't exit early when canBeAllocatedToAtLeastOneNode didn't return a YES decision";
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.fromDecision(((Decision)allocationDecision.v1()).type()), new ArrayList<NodeAllocationResult>(((Map)allocationDecision.v2()).values()));
        }
        assert (primaryShard.currentNodeId() != null);
        DiscoveryNode primaryNode = allocation.nodes().get(primaryShard.currentNodeId());
        TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata primaryStore = ReplicaShardAllocator.findStore(primaryNode, nodeShardStores);
        if (primaryStore == null) {
            logger.trace("{}: no primary shard store found or allocated, letting actual allocation figure it out", (Object)unassignedShard);
            return AllocateUnassignedDecision.NOT_TAKEN;
        }
        MatchingNodes matchingNodes = this.findMatchingNodes(unassignedShard, allocation, false, primaryNode, primaryStore, nodeShardStores, explain);
        assert (!explain || matchingNodes.nodeDecisions != null) : "in explain mode, we must have individual node decisions";
        List<NodeAllocationResult> nodeDecisions = ReplicaShardAllocator.augmentExplanationsWithStoreInfo((Map)allocationDecision.v2(), matchingNodes.nodeDecisions);
        if (((Decision)allocationDecision.v1()).type() != Decision.Type.YES) {
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.fromDecision(((Decision)allocationDecision.v1()).type()), nodeDecisions);
        }
        if (matchingNodes.getNodeWithHighestMatch() != null) {
            RoutingNode nodeWithHighestMatch = allocation.routingNodes().node(matchingNodes.getNodeWithHighestMatch().getId());
            Decision decision = allocation.deciders().canAllocate(unassignedShard, nodeWithHighestMatch, allocation);
            if (decision.type() == Decision.Type.THROTTLE) {
                logger.debug("[{}][{}]: throttling allocation [{}] to [{}] in order to reuse its unallocated persistent store", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)nodeWithHighestMatch.node());
                return AllocateUnassignedDecision.throttle(nodeDecisions);
            }
            logger.debug("[{}][{}]: allocating [{}] to [{}] in order to reuse its unallocated persistent store", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)nodeWithHighestMatch.node());
            return AllocateUnassignedDecision.yes(nodeWithHighestMatch.node(), null, nodeDecisions, true);
        }
        if (!matchingNodes.hasAnyData() && unassignedShard.unassignedInfo().isDelayed()) {
            logger.debug("{}: allocation of [{}] is delayed", (Object)unassignedShard.shardId(), (Object)unassignedShard);
            long remainingDelayMillis = 0L;
            long totalDelayMillis = 0L;
            if (explain) {
                UnassignedInfo unassignedInfo = unassignedShard.unassignedInfo();
                Metadata metadata = allocation.metadata();
                IndexMetadata indexMetadata = metadata.index(unassignedShard.index());
                totalDelayMillis = UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.get(indexMetadata.getSettings()).getMillis();
                long remainingDelayNanos = unassignedInfo.getRemainingDelay(System.nanoTime(), indexMetadata.getSettings());
                remainingDelayMillis = TimeValue.timeValueNanos((long)remainingDelayNanos).millis();
            }
            return AllocateUnassignedDecision.delayed(remainingDelayMillis, totalDelayMillis, nodeDecisions);
        }
        return AllocateUnassignedDecision.NOT_TAKEN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Tuple<Decision, Map<String, NodeAllocationResult>> canBeAllocatedToAtLeastOneNode(ShardRouting shard, RoutingAllocation allocation) {
        Decision madeDecision = Decision.NO;
        boolean explain = allocation.debugDecision();
        HashMap<String, NodeAllocationResult> nodeDecisions = explain ? new HashMap<String, NodeAllocationResult>() : null;
        for (DiscoveryNode cursor : allocation.nodes().getDataNodes().values()) {
            RoutingNode node = allocation.routingNodes().node(cursor.getId());
            if (node == null) continue;
            Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
            if (decision.type() == Decision.Type.YES && madeDecision.type() != Decision.Type.YES) {
                if (!explain) return Tuple.tuple((Object)decision, null);
                madeDecision = decision;
            } else if (madeDecision.type() == Decision.Type.NO && decision.type() == Decision.Type.THROTTLE) {
                madeDecision = decision;
            }
            if (!explain) continue;
            nodeDecisions.put(node.nodeId(), new NodeAllocationResult(node.node(), null, decision));
        }
        return Tuple.tuple((Object)madeDecision, nodeDecisions);
    }

    private static List<NodeAllocationResult> augmentExplanationsWithStoreInfo(Map<String, NodeAllocationResult> nodeDecisions, Map<String, NodeAllocationResult> withShardStores) {
        if (nodeDecisions == null || withShardStores == null) {
            return null;
        }
        ArrayList<NodeAllocationResult> augmented = new ArrayList<NodeAllocationResult>();
        for (Map.Entry<String, NodeAllocationResult> entry : nodeDecisions.entrySet()) {
            if (withShardStores.containsKey(entry.getKey())) {
                augmented.add(withShardStores.get(entry.getKey()));
                continue;
            }
            augmented.add(entry.getValue());
        }
        return augmented;
    }

    private static TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata findStore(DiscoveryNode node, Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> data) {
        if (!data.containsKey(node)) {
            return null;
        }
        return data.get(node);
    }

    private MatchingNodes findMatchingNodes(ShardRouting shard, RoutingAllocation allocation, boolean noMatchFailedNodes, DiscoveryNode primaryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata primaryStore, Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> data, boolean explain) {
        HashMap<DiscoveryNode, MatchingNode> matchingNodes = new HashMap<DiscoveryNode, MatchingNode>();
        HashMap<String, NodeAllocationResult> nodeDecisions = explain ? new HashMap<String, NodeAllocationResult>() : null;
        for (Map.Entry<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> nodeStoreEntry : data.entrySet()) {
            RoutingNode node;
            TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata;
            DiscoveryNode discoNode = nodeStoreEntry.getKey();
            if (noMatchFailedNodes && shard.unassignedInfo() != null && shard.unassignedInfo().getFailedNodeIds().contains(discoNode.getId()) || (storeFilesMetadata = nodeStoreEntry.getValue()).isEmpty() || (node = allocation.routingNodes().node(discoNode.getId())) == null) continue;
            Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
            MatchingNode matchingNode = null;
            if (explain) {
                matchingNode = ReplicaShardAllocator.computeMatchingNode(primaryNode, primaryStore, discoNode, storeFilesMetadata);
                NodeAllocationResult.ShardStoreInfo shardStoreInfo = new NodeAllocationResult.ShardStoreInfo(matchingNode.matchingBytes);
                nodeDecisions.put(node.nodeId(), new NodeAllocationResult(discoNode, shardStoreInfo, decision));
            }
            if (decision.type() == Decision.Type.NO) continue;
            if (matchingNode == null) {
                matchingNode = ReplicaShardAllocator.computeMatchingNode(primaryNode, primaryStore, discoNode, storeFilesMetadata);
            }
            matchingNodes.put(discoNode, matchingNode);
            if (!this.logger.isTraceEnabled()) continue;
            if (matchingNode.isNoopRecovery) {
                this.logger.trace("{}: node [{}] can perform a noop recovery", (Object)shard, (Object)discoNode.getName());
                continue;
            }
            if (matchingNode.retainingSeqNo >= 0L) {
                this.logger.trace("{}: node [{}] can perform operation-based recovery with retaining sequence number [{}]", (Object)shard, (Object)discoNode.getName(), (Object)matchingNode.retainingSeqNo);
                continue;
            }
            this.logger.trace("{}: node [{}] has [{}/{}] bytes of re-usable data", (Object)shard, (Object)discoNode.getName(), (Object)new ByteSizeValue(matchingNode.matchingBytes), (Object)matchingNode.matchingBytes);
        }
        return new MatchingNodes(matchingNodes, nodeDecisions);
    }

    private Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> convertToNodeStoreFilesMetadataMap(AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> data) {
        if (!data.hasData()) {
            return null;
        }
        return data.getData().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata)((Object)((Object)entry.getValue()))).storeFilesMetadata()));
    }

    private static long computeMatchingBytes(TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata primaryStore, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata) {
        long sizeMatched = 0L;
        for (StoreFileMetadata storeFileMetadata : storeFilesMetadata) {
            String metadataFileName = storeFileMetadata.name();
            if (!primaryStore.fileExists(metadataFileName) || !primaryStore.file(metadataFileName).isSame(storeFileMetadata)) continue;
            sizeMatched += storeFileMetadata.length();
        }
        return sizeMatched;
    }

    private static boolean hasMatchingSyncId(TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata primaryStore, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata replicaStore) {
        String primarySyncId = primaryStore.syncId();
        return primarySyncId != null && primarySyncId.equals(replicaStore.syncId());
    }

    private static MatchingNode computeMatchingNode(DiscoveryNode primaryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata primaryStore, DiscoveryNode replicaNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata replicaStore) {
        long retainingSeqNoForPrimary = primaryStore.getPeerRecoveryRetentionLeaseRetainingSeqNo(primaryNode);
        long retainingSeqNoForReplica = primaryStore.getPeerRecoveryRetentionLeaseRetainingSeqNo(replicaNode);
        boolean isNoopRecovery = retainingSeqNoForReplica >= retainingSeqNoForPrimary && retainingSeqNoForPrimary >= 0L || ReplicaShardAllocator.hasMatchingSyncId(primaryStore, replicaStore);
        long matchingBytes = ReplicaShardAllocator.computeMatchingBytes(primaryStore, replicaStore);
        return new MatchingNode(matchingBytes, retainingSeqNoForReplica, isNoopRecovery);
    }

    private static boolean canPerformOperationBasedRecovery(TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata primaryStore, Map<DiscoveryNode, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata> shardStores, DiscoveryNode targetNode) {
        TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata targetNodeStore = shardStores.get(targetNode);
        if (targetNodeStore == null || targetNodeStore.isEmpty()) {
            return false;
        }
        if (ReplicaShardAllocator.hasMatchingSyncId(primaryStore, targetNodeStore)) {
            return true;
        }
        return primaryStore.getPeerRecoveryRetentionLeaseRetainingSeqNo(targetNode) >= 0L;
    }

    protected abstract AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> fetchData(ShardRouting var1, RoutingAllocation var2);

    protected abstract boolean hasInitiatedFetching(ShardRouting var1);

    static class MatchingNodes {
        private final Map<DiscoveryNode, MatchingNode> matchingNodes;
        private final DiscoveryNode nodeWithHighestMatch;
        @Nullable
        private final Map<String, NodeAllocationResult> nodeDecisions;

        MatchingNodes(Map<DiscoveryNode, MatchingNode> matchingNodes, @Nullable Map<String, NodeAllocationResult> nodeDecisions) {
            this.matchingNodes = matchingNodes;
            this.nodeDecisions = nodeDecisions;
            this.nodeWithHighestMatch = matchingNodes.entrySet().stream().filter(e -> ((MatchingNode)e.getValue()).anyMatch()).max(Comparator.comparing(Map.Entry::getValue, MatchingNode.COMPARATOR)).map(Map.Entry::getKey).orElse(null);
        }

        @Nullable
        public DiscoveryNode getNodeWithHighestMatch() {
            return this.nodeWithHighestMatch;
        }

        boolean canPerformNoopRecovery(DiscoveryNode node) {
            MatchingNode matchingNode = this.matchingNodes.get(node);
            return matchingNode.isNoopRecovery;
        }

        public boolean hasAnyData() {
            return !this.matchingNodes.isEmpty();
        }
    }

    protected static class MatchingNode {
        static final Comparator<MatchingNode> COMPARATOR = Comparator.comparing(m -> m.isNoopRecovery).thenComparing(m -> m.retainingSeqNo).thenComparing(m -> m.matchingBytes);
        final long matchingBytes;
        final long retainingSeqNo;
        final boolean isNoopRecovery;

        MatchingNode(long matchingBytes, long retainingSeqNo, boolean isNoopRecovery) {
            this.matchingBytes = matchingBytes;
            this.retainingSeqNo = retainingSeqNo;
            this.isNoopRecovery = isNoopRecovery;
        }

        boolean anyMatch() {
            return this.isNoopRecovery || this.retainingSeqNo >= 0L || this.matchingBytes > 0L;
        }
    }
}

