/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.http.HttpResponse;
import org.opensearch.rest.RestRequest;

@PublicApi(since="1.0.0")
public interface HttpRequest {
    public RestRequest.Method method();

    public String uri();

    public BytesReference content();

    public Map<String, List<String>> getHeaders();

    default public String header(String name) {
        List<String> values = this.getHeaders().get(name);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    default public List<String> allHeaders(String name) {
        List<String> values = this.getHeaders().get(name);
        if (values != null) {
            return Collections.unmodifiableList(values);
        }
        return null;
    }

    public List<String> strictCookies();

    public HttpVersion protocolVersion();

    public HttpRequest removeHeader(String var1);

    public HttpResponse createResponse(RestStatus var1, BytesReference var2);

    @Nullable
    public Exception getInboundException();

    public void release();

    public HttpRequest releaseAndCopy();

    @PublicApi(since="1.0.0")
    public static enum HttpVersion {
        HTTP_1_0,
        HTTP_1_1;

    }
}

