/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.builder;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeDocument;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.opensearch.index.compositeindex.datacube.startree.aggregators.MetricAggregatorInfo;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeDocumentBitSetUtil;
import org.opensearch.index.mapper.FieldValueConverter;
import org.opensearch.index.mapper.NumberFieldMapper;

@ExperimentalApi
public abstract class AbstractDocumentsFileManager
implements Closeable {
    private static final Logger logger = LogManager.getLogger(AbstractDocumentsFileManager.class);
    protected final StarTreeField starTreeField;
    protected final List<MetricAggregatorInfo> metricAggregatorInfos;
    protected final int numMetrics;
    protected final TrackingDirectoryWrapper tmpDirectory;
    protected final SegmentWriteState state;
    protected int docSizeInBytes = -1;

    public AbstractDocumentsFileManager(SegmentWriteState state, StarTreeField starTreeField, List<MetricAggregatorInfo> metricAggregatorInfos) {
        this.starTreeField = starTreeField;
        this.tmpDirectory = new TrackingDirectoryWrapper(state.directory);
        this.metricAggregatorInfos = metricAggregatorInfos;
        this.state = state;
        this.numMetrics = metricAggregatorInfos.size();
    }

    private void setDocSizeInBytes(int numBytes) {
        if (this.docSizeInBytes == -1) {
            this.docSizeInBytes = numBytes;
        }
        assert (this.docSizeInBytes == numBytes);
    }

    protected int writeStarTreeDocument(StarTreeDocument starTreeDocument, IndexOutput output, boolean isAggregatedDoc) throws IOException {
        int numBytes = this.writeDimensions(starTreeDocument, output);
        this.setDocSizeInBytes(numBytes += this.writeMetrics(starTreeDocument, output, isAggregatedDoc));
        return numBytes;
    }

    protected int writeDimensions(StarTreeDocument starTreeDocument, IndexOutput output) throws IOException {
        int numBytes = 0;
        for (int i = 0; i < starTreeDocument.dimensions.length; ++i) {
            output.writeLong(starTreeDocument.dimensions[i] == null ? 0L : starTreeDocument.dimensions[i]);
            numBytes += 8;
        }
        return numBytes += StarTreeDocumentBitSetUtil.writeBitSet(starTreeDocument.dimensions, output);
    }

    protected int writeMetrics(StarTreeDocument starTreeDocument, IndexOutput output, boolean isAggregatedDoc) throws IOException {
        int numBytes = 0;
        for (int i = 0; i < starTreeDocument.metrics.length; ++i) {
            FieldValueConverter aggregatedValueType = this.metricAggregatorInfos.get(i).getValueAggregators().getAggregatedValueType();
            if (aggregatedValueType.equals(NumberFieldMapper.NumberType.LONG)) {
                output.writeLong(starTreeDocument.metrics[i] == null ? 0L : (Long)starTreeDocument.metrics[i]);
                numBytes += 8;
                continue;
            }
            if (aggregatedValueType.equals(NumberFieldMapper.NumberType.DOUBLE)) {
                if (isAggregatedDoc) {
                    long val = NumericUtils.doubleToSortableLong((double)(starTreeDocument.metrics[i] == null ? 0.0 : (Double)starTreeDocument.metrics[i]));
                    output.writeLong(val);
                } else {
                    output.writeLong(starTreeDocument.metrics[i] == null ? 0L : (Long)starTreeDocument.metrics[i]);
                }
                numBytes += 8;
                continue;
            }
            throw new IllegalStateException("Unsupported metric type");
        }
        return numBytes += StarTreeDocumentBitSetUtil.writeBitSet(starTreeDocument.metrics, output);
    }

    protected StarTreeDocument readStarTreeDocument(RandomAccessInput input, long offset, boolean isAggregatedDoc) throws IOException {
        int dimSize = this.starTreeField.getDimensionsOrder().size();
        Long[] dimensions = new Long[dimSize];
        long initialOffset = offset;
        offset = this.readDimensions(dimensions, input, offset);
        Object[] metrics = new Object[this.numMetrics];
        offset = this.readMetrics(input, offset, this.numMetrics, metrics, isAggregatedDoc);
        assert (offset - initialOffset == (long)this.docSizeInBytes);
        return new StarTreeDocument(dimensions, metrics);
    }

    protected long readDimensions(Long[] dimensions, RandomAccessInput input, long offset) throws IOException {
        for (int i = 0; i < dimensions.length; ++i) {
            try {
                dimensions[i] = input.readLong(offset);
            }
            catch (Exception e) {
                logger.error("Error reading dimension value at offset {} for dimension {}", (Object)offset, (Object)i);
                throw e;
            }
            offset += 8L;
        }
        offset += (long)StarTreeDocumentBitSetUtil.readBitSet(input, offset, dimensions, index -> null);
        return offset;
    }

    protected long readMetrics(RandomAccessInput input, long offset, int numMetrics, Object[] metrics, boolean isAggregatedDoc) throws IOException {
        for (int i = 0; i < numMetrics; ++i) {
            FieldValueConverter aggregatedValueType = this.metricAggregatorInfos.get(i).getValueAggregators().getAggregatedValueType();
            if (aggregatedValueType.equals(NumberFieldMapper.NumberType.LONG)) {
                metrics[i] = input.readLong(offset);
                offset += 8L;
                continue;
            }
            if (aggregatedValueType.equals(NumberFieldMapper.NumberType.DOUBLE)) {
                long val = input.readLong(offset);
                metrics[i] = isAggregatedDoc ? (Number)NumberFieldMapper.NumberType.DOUBLE.toDoubleValue(val) : (Number)val;
                offset += 8L;
                continue;
            }
            throw new IllegalStateException("Unsupported metric type");
        }
        offset += (long)StarTreeDocumentBitSetUtil.readBitSet(input, offset, metrics, index -> null);
        return offset;
    }

    public abstract void writeStarTreeDocument(StarTreeDocument var1, boolean var2) throws IOException;

    public abstract StarTreeDocument readStarTreeDocument(int var1, boolean var2) throws IOException;

    public abstract Long[] readDimensions(int var1) throws IOException;

    public abstract Long getDimensionValue(int var1, int var2) throws IOException;

    public void deleteFiles(boolean success) throws IOException {
        if (success) {
            for (String file : this.tmpDirectory.getCreatedFiles()) {
                this.tmpDirectory.deleteFile(file);
            }
        } else {
            this.deleteFilesIgnoringException();
        }
    }

    private void deleteFilesIgnoringException() throws IOException {
        for (String file : this.tmpDirectory.getCreatedFiles()) {
            try {
                this.tmpDirectory.deleteFile(file);
            }
            catch (IOException iOException) {}
        }
    }
}

