/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.codec.composite.composite99.Composite99DocValuesReader;
import org.opensearch.index.compositeindex.CompositeIndexMetadata;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.ReadDimension;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeFieldConfiguration;
import org.opensearch.index.compositeindex.datacube.startree.fileformats.meta.StarTreeMetadata;
import org.opensearch.index.compositeindex.datacube.startree.index.CompositeIndexValues;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeFactory;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeNode;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeUtils;

@ExperimentalApi
public class StarTreeValues
implements CompositeIndexValues {
    private final StarTreeField starTreeField;
    private final StarTreeNode root;
    private final Map<String, Supplier<DocIdSetIterator>> dimensionDocValuesIteratorMap;
    private final Map<String, Supplier<DocIdSetIterator>> metricDocValuesIteratorMap;
    private final Map<String, String> attributes;
    private final StarTreeMetadata starTreeMetadata;

    public StarTreeValues(StarTreeField starTreeField, StarTreeNode root, Map<String, Supplier<DocIdSetIterator>> dimensionDocValuesIteratorMap, Map<String, Supplier<DocIdSetIterator>> metricDocValuesIteratorMap, Map<String, String> attributes, StarTreeMetadata compositeIndexMetadata) {
        this.starTreeField = starTreeField;
        this.root = root;
        this.dimensionDocValuesIteratorMap = dimensionDocValuesIteratorMap;
        this.metricDocValuesIteratorMap = metricDocValuesIteratorMap;
        this.attributes = attributes;
        this.starTreeMetadata = compositeIndexMetadata;
    }

    public StarTreeValues(CompositeIndexMetadata compositeIndexMetadata, IndexInput compositeIndexDataIn, DocValuesProducer compositeDocValuesProducer, SegmentReadState readState) throws IOException {
        this.starTreeMetadata = (StarTreeMetadata)compositeIndexMetadata;
        Set<String> skipStarNodeCreationInDims = this.starTreeMetadata.getSkipStarNodeCreationInDims();
        ArrayList<Dimension> readDimensions = new ArrayList<Dimension>();
        for (String dimension : this.starTreeMetadata.getDimensionFields()) {
            readDimensions.add(new ReadDimension(dimension));
        }
        this.starTreeField = new StarTreeField(this.starTreeMetadata.getCompositeFieldName(), readDimensions, this.starTreeMetadata.getMetrics(), new StarTreeFieldConfiguration(this.starTreeMetadata.getMaxLeafDocs(), skipStarNodeCreationInDims, this.starTreeMetadata.getStarTreeBuildMode()));
        this.root = StarTreeFactory.createStarTree(compositeIndexDataIn, this.starTreeMetadata);
        this.dimensionDocValuesIteratorMap = new LinkedHashMap<String, Supplier<DocIdSetIterator>>();
        this.metricDocValuesIteratorMap = new LinkedHashMap<String, Supplier<DocIdSetIterator>>();
        for (String dimension : this.starTreeMetadata.getDimensionFields()) {
            this.dimensionDocValuesIteratorMap.put(dimension, () -> {
                try {
                    FieldInfo dimensionfieldInfo;
                    SortedNumericDocValues dimensionSortedNumericDocValues = null;
                    if (readState != null && (dimensionfieldInfo = readState.fieldInfos.fieldInfo(StarTreeUtils.fullyQualifiedFieldNameForStarTreeDimensionsDocValues(this.starTreeField.getName(), dimension))) != null) {
                        dimensionSortedNumericDocValues = compositeDocValuesProducer.getSortedNumeric(dimensionfieldInfo);
                    }
                    return Composite99DocValuesReader.getSortedNumericDocValues(dimensionSortedNumericDocValues);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error loading dimension DocIdSetIterator", e);
                }
            });
        }
        for (Metric metric : this.starTreeMetadata.getMetrics()) {
            for (MetricStat metricStat : metric.getBaseMetrics()) {
                String metricFullName = StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(this.starTreeField.getName(), metric.getField(), metricStat.getTypeName());
                this.metricDocValuesIteratorMap.put(metricFullName, () -> {
                    try {
                        FieldInfo metricFieldInfo;
                        SortedNumericDocValues metricSortedNumericDocValues = null;
                        if (readState != null && (metricFieldInfo = readState.fieldInfos.fieldInfo(metricFullName)) != null) {
                            metricSortedNumericDocValues = compositeDocValuesProducer.getSortedNumeric(metricFieldInfo);
                        }
                        return Composite99DocValuesReader.getSortedNumericDocValues(metricSortedNumericDocValues);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading metric DocIdSetIterator", e);
                    }
                });
            }
        }
        this.attributes = Map.of("segmentDocsCount", String.valueOf(this.starTreeMetadata.getSegmentAggregatedDocCount()), "starTreeDocsCount", String.valueOf(this.starTreeMetadata.getStarTreeDocCount()));
    }

    @Override
    public CompositeIndexValues getValues() {
        return this;
    }

    public StarTreeField getStarTreeField() {
        return this.starTreeField;
    }

    public StarTreeNode getRoot() {
        return this.root;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public DocIdSetIterator getDimensionDocIdSetIterator(String dimension) {
        if (this.dimensionDocValuesIteratorMap.containsKey(dimension)) {
            return this.dimensionDocValuesIteratorMap.get(dimension).get();
        }
        throw new IllegalArgumentException("dimension [" + dimension + "] does not exist in the segment.");
    }

    public DocIdSetIterator getMetricDocIdSetIterator(String fullyQualifiedMetricName) {
        if (this.metricDocValuesIteratorMap.containsKey(fullyQualifiedMetricName)) {
            return this.metricDocValuesIteratorMap.get(fullyQualifiedMetricName).get();
        }
        throw new IllegalArgumentException("metric [" + fullyQualifiedMetricName + "] does not exist in the segment.");
    }

    public int getStarTreeDocumentCount() {
        return this.starTreeMetadata.getStarTreeDocCount();
    }
}

