/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.utils;

import java.io.IOException;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.common.annotation.ExperimentalApi;

@ExperimentalApi
public class SequentialDocValuesIterator {
    private final DocIdSetIterator docIdSetIterator;
    private Long docValue;
    private int docId = -1;

    public SequentialDocValuesIterator(DocIdSetIterator docIdSetIterator) {
        this.docIdSetIterator = docIdSetIterator;
    }

    public int getDocId() {
        return this.docId;
    }

    private void setDocId(int docId) {
        this.docId = docId;
    }

    public DocIdSetIterator getDocIdSetIterator() {
        return this.docIdSetIterator;
    }

    public int nextDoc(int currentDocId) throws IOException {
        if (this.docId >= currentDocId) {
            return this.docId;
        }
        this.setDocId(this.docIdSetIterator.nextDoc());
        return this.docId;
    }

    public Long value(int currentDocId) throws IOException {
        if (this.getDocIdSetIterator() instanceof SortedNumericDocValues) {
            SortedNumericDocValues sortedNumericDocValues = (SortedNumericDocValues)this.getDocIdSetIterator();
            if (currentDocId < 0) {
                throw new IllegalStateException("invalid doc id to fetch the next value");
            }
            if (currentDocId == Integer.MAX_VALUE) {
                throw new IllegalStateException("DocValuesIterator is already exhausted");
            }
            if (this.docId == Integer.MAX_VALUE || this.docId != currentDocId) {
                return null;
            }
            return sortedNumericDocValues.nextValue();
        }
        throw new IllegalStateException("Unsupported Iterator requested for SequentialDocValuesIterator");
    }
}

