/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.remote.RemoteStoreEnums;

@PublicApi(since="2.14.0")
public class RemoteStoreSettings {
    private static final int MIN_CLUSTER_REMOTE_MAX_TRANSLOG_READERS = 100;
    public static final Setting<TimeValue> CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING = Setting.timeSetting("cluster.remote_store.translog.buffer_interval", IndexSettings.DEFAULT_REMOTE_TRANSLOG_BUFFER_INTERVAL, IndexSettings.MINIMUM_REMOTE_TRANSLOG_BUFFER_INTERVAL, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Integer> CLUSTER_REMOTE_INDEX_SEGMENT_METADATA_RETENTION_MAX_COUNT_SETTING = Setting.intSetting("cluster.remote_store.index.segment_metadata.retention.max_count", 10, -1, v -> {
        if (v == 0) {
            throw new IllegalArgumentException("Value 0 is not allowed for this setting as it would delete all the data from remote segment store");
        }
    }, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> CLUSTER_REMOTE_TRANSLOG_TRANSFER_TIMEOUT_SETTING = Setting.timeSetting("cluster.remote_store.translog.transfer_timeout", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)30L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    @ExperimentalApi
    public static final Setting<RemoteStoreEnums.PathType> CLUSTER_REMOTE_STORE_PATH_TYPE_SETTING = new Setting<RemoteStoreEnums.PathType>("cluster.remote_store.index.path.type", RemoteStoreEnums.PathType.FIXED.toString(), RemoteStoreEnums.PathType::parseString, Setting.Property.NodeScope, Setting.Property.Dynamic);
    @ExperimentalApi
    public static final Setting<Boolean> CLUSTER_REMOTE_STORE_TRANSLOG_METADATA = Setting.boolSetting("cluster.remote_store.index.translog.translog_metadata", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    @ExperimentalApi
    public static final Setting<RemoteStoreEnums.PathHashAlgorithm> CLUSTER_REMOTE_STORE_PATH_HASH_ALGORITHM_SETTING = new Setting<RemoteStoreEnums.PathHashAlgorithm>("cluster.remote_store.index.path.hash_algorithm", RemoteStoreEnums.PathHashAlgorithm.FNV_1A_COMPOSITE_1.toString(), RemoteStoreEnums.PathHashAlgorithm::parseString, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Integer> CLUSTER_REMOTE_MAX_TRANSLOG_READERS = Setting.intSetting("cluster.remote_store.translog.max_readers", 1000, -1, v -> {
        if (v != -1 && v < 100) {
            throw new IllegalArgumentException("Cannot set value lower than 100");
        }
    }, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> CLUSTER_REMOTE_SEGMENT_TRANSFER_TIMEOUT_SETTING = Setting.timeSetting("cluster.remote_store.segment.transfer_timeout", TimeValue.timeValueMinutes((long)30L), TimeValue.timeValueMinutes((long)10L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Boolean> CLUSTER_REMOTE_STORE_PINNED_TIMESTAMP_ENABLED = Setting.boolSetting("cluster.remote_store.pinned_timestamps.enabled", false, Setting.Property.NodeScope);
    public static final Setting<TimeValue> CLUSTER_REMOTE_STORE_PINNED_TIMESTAMP_SCHEDULER_INTERVAL = Setting.timeSetting("cluster.remote_store.pinned_timestamps.scheduler_interval", TimeValue.timeValueMinutes((long)3L), TimeValue.timeValueMinutes((long)1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> CLUSTER_REMOTE_STORE_PINNED_TIMESTAMP_LOOKBACK_INTERVAL = Setting.timeSetting("cluster.remote_store.pinned_timestamps.lookback_interval", TimeValue.timeValueMinutes((long)1L), TimeValue.timeValueMinutes((long)1L), TimeValue.timeValueMinutes((long)5L), Setting.Property.NodeScope);
    public static final Setting<String> CLUSTER_REMOTE_STORE_TRANSLOG_PATH_PREFIX = Setting.simpleString("cluster.remote_store.translog.path.prefix", "", Setting.Property.NodeScope, Setting.Property.Final);
    public static final Setting<String> CLUSTER_REMOTE_STORE_SEGMENTS_PATH_PREFIX = Setting.simpleString("cluster.remote_store.segments.path.prefix", "", Setting.Property.NodeScope, Setting.Property.Final);
    private volatile TimeValue clusterRemoteTranslogBufferInterval;
    private volatile int minRemoteSegmentMetadataFiles;
    private volatile TimeValue clusterRemoteTranslogTransferTimeout;
    private volatile TimeValue clusterRemoteSegmentTransferTimeout;
    private volatile RemoteStoreEnums.PathType pathType;
    private volatile RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm;
    private volatile int maxRemoteTranslogReaders;
    private volatile boolean isTranslogMetadataEnabled;
    private static volatile boolean isPinnedTimestampsEnabled;
    private static volatile TimeValue pinnedTimestampsSchedulerInterval;
    private static volatile TimeValue pinnedTimestampsLookbackInterval;
    private final String translogPathFixedPrefix;
    private final String segmentsPathFixedPrefix;

    public RemoteStoreSettings(Settings settings, ClusterSettings clusterSettings) {
        this.clusterRemoteTranslogBufferInterval = CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING, this::setClusterRemoteTranslogBufferInterval);
        this.minRemoteSegmentMetadataFiles = CLUSTER_REMOTE_INDEX_SEGMENT_METADATA_RETENTION_MAX_COUNT_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_INDEX_SEGMENT_METADATA_RETENTION_MAX_COUNT_SETTING, this::setMinRemoteSegmentMetadataFiles);
        this.clusterRemoteTranslogTransferTimeout = CLUSTER_REMOTE_TRANSLOG_TRANSFER_TIMEOUT_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_TRANSLOG_TRANSFER_TIMEOUT_SETTING, this::setClusterRemoteTranslogTransferTimeout);
        this.pathType = clusterSettings.get(CLUSTER_REMOTE_STORE_PATH_TYPE_SETTING);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_STORE_PATH_TYPE_SETTING, this::setPathType);
        this.isTranslogMetadataEnabled = clusterSettings.get(CLUSTER_REMOTE_STORE_TRANSLOG_METADATA);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_STORE_TRANSLOG_METADATA, this::setTranslogMetadataEnabled);
        this.pathHashAlgorithm = clusterSettings.get(CLUSTER_REMOTE_STORE_PATH_HASH_ALGORITHM_SETTING);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_STORE_PATH_HASH_ALGORITHM_SETTING, this::setPathHashAlgorithm);
        this.maxRemoteTranslogReaders = CLUSTER_REMOTE_MAX_TRANSLOG_READERS.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_MAX_TRANSLOG_READERS, this::setMaxRemoteTranslogReaders);
        this.clusterRemoteSegmentTransferTimeout = CLUSTER_REMOTE_SEGMENT_TRANSFER_TIMEOUT_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_SEGMENT_TRANSFER_TIMEOUT_SETTING, this::setClusterRemoteSegmentTransferTimeout);
        pinnedTimestampsSchedulerInterval = CLUSTER_REMOTE_STORE_PINNED_TIMESTAMP_SCHEDULER_INTERVAL.get(settings);
        pinnedTimestampsLookbackInterval = CLUSTER_REMOTE_STORE_PINNED_TIMESTAMP_LOOKBACK_INTERVAL.get(settings);
        isPinnedTimestampsEnabled = CLUSTER_REMOTE_STORE_PINNED_TIMESTAMP_ENABLED.get(settings);
        this.translogPathFixedPrefix = CLUSTER_REMOTE_STORE_TRANSLOG_PATH_PREFIX.get(settings);
        this.segmentsPathFixedPrefix = CLUSTER_REMOTE_STORE_SEGMENTS_PATH_PREFIX.get(settings);
    }

    public TimeValue getClusterRemoteTranslogBufferInterval() {
        return this.clusterRemoteTranslogBufferInterval;
    }

    private void setClusterRemoteTranslogBufferInterval(TimeValue clusterRemoteTranslogBufferInterval) {
        this.clusterRemoteTranslogBufferInterval = clusterRemoteTranslogBufferInterval;
    }

    private void setMinRemoteSegmentMetadataFiles(int minRemoteSegmentMetadataFiles) {
        this.minRemoteSegmentMetadataFiles = minRemoteSegmentMetadataFiles;
    }

    public int getMinRemoteSegmentMetadataFiles() {
        return this.minRemoteSegmentMetadataFiles;
    }

    public TimeValue getClusterRemoteTranslogTransferTimeout() {
        return this.clusterRemoteTranslogTransferTimeout;
    }

    public TimeValue getClusterRemoteSegmentTransferTimeout() {
        return this.clusterRemoteSegmentTransferTimeout;
    }

    private void setClusterRemoteTranslogTransferTimeout(TimeValue clusterRemoteTranslogTransferTimeout) {
        this.clusterRemoteTranslogTransferTimeout = clusterRemoteTranslogTransferTimeout;
    }

    private void setClusterRemoteSegmentTransferTimeout(TimeValue clusterRemoteSegmentTransferTimeout) {
        this.clusterRemoteSegmentTransferTimeout = clusterRemoteSegmentTransferTimeout;
    }

    @ExperimentalApi
    public RemoteStoreEnums.PathType getPathType() {
        return this.pathType;
    }

    @ExperimentalApi
    public RemoteStoreEnums.PathHashAlgorithm getPathHashAlgorithm() {
        return this.pathHashAlgorithm;
    }

    private void setPathType(RemoteStoreEnums.PathType pathType) {
        this.pathType = pathType;
    }

    private void setTranslogMetadataEnabled(boolean isTranslogMetadataEnabled) {
        this.isTranslogMetadataEnabled = isTranslogMetadataEnabled;
    }

    public boolean isTranslogMetadataEnabled() {
        return this.isTranslogMetadataEnabled;
    }

    private void setPathHashAlgorithm(RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm) {
        this.pathHashAlgorithm = pathHashAlgorithm;
    }

    public int getMaxRemoteTranslogReaders() {
        return this.maxRemoteTranslogReaders;
    }

    private void setMaxRemoteTranslogReaders(int maxRemoteTranslogReaders) {
        this.maxRemoteTranslogReaders = maxRemoteTranslogReaders;
    }

    public static TimeValue getPinnedTimestampsSchedulerInterval() {
        return pinnedTimestampsSchedulerInterval;
    }

    public static TimeValue getPinnedTimestampsLookbackInterval() {
        return pinnedTimestampsLookbackInterval;
    }

    public static void setPinnedTimestampsLookbackInterval(TimeValue pinnedTimestampsLookbackInterval) {
        RemoteStoreSettings.pinnedTimestampsLookbackInterval = pinnedTimestampsLookbackInterval;
    }

    public static boolean isPinnedTimestampsEnabled() {
        return isPinnedTimestampsEnabled;
    }

    public String getTranslogPathFixedPrefix() {
        return this.translogPathFixedPrefix;
    }

    public String getSegmentsPathFixedPrefix() {
        return this.segmentsPathFixedPrefix;
    }
}

