/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.trackers;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.backpressure.trackers.TaskResourceUsageTrackerType;
import org.opensearch.search.backpressure.trackers.TaskResourceUsageTrackers;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskCancellation;

public class CpuUsageTracker
extends TaskResourceUsageTrackers.TaskResourceUsageTracker {
    private final LongSupplier thresholdSupplier;

    public CpuUsageTracker(LongSupplier thresholdSupplier) {
        this(thresholdSupplier, task -> {
            long threshold;
            long usage = task.getTotalResourceStats().getCpuTimeInNanos();
            if (usage < (threshold = thresholdSupplier.getAsLong())) {
                return Optional.empty();
            }
            return Optional.of(new TaskCancellation.Reason("cpu usage exceeded [" + new TimeValue(usage, TimeUnit.NANOSECONDS) + " >= " + new TimeValue(threshold, TimeUnit.NANOSECONDS) + "]", 1));
        });
    }

    public CpuUsageTracker(LongSupplier thresholdSupplier, TaskResourceUsageTrackers.TaskResourceUsageTracker.ResourceUsageBreachEvaluator resourceUsageBreachEvaluator) {
        this.thresholdSupplier = thresholdSupplier;
        this.resourceUsageBreachEvaluator = resourceUsageBreachEvaluator;
    }

    @Override
    public String name() {
        return TaskResourceUsageTrackerType.CPU_USAGE_TRACKER.getName();
    }

    @Override
    public TaskResourceUsageTrackers.TaskResourceUsageTracker.Stats stats(List<? extends Task> activeTasks) {
        long currentMax = activeTasks.stream().mapToLong(t -> t.getTotalResourceStats().getCpuTimeInNanos()).max().orElse(0L);
        long currentAvg = (long)activeTasks.stream().mapToLong(t -> t.getTotalResourceStats().getCpuTimeInNanos()).average().orElse(0.0);
        return new Stats(this.getCancellations(), currentMax, currentAvg);
    }

    public static class Stats
    implements TaskResourceUsageTrackers.TaskResourceUsageTracker.Stats {
        private final long cancellationCount;
        private final long currentMax;
        private final long currentAvg;

        public Stats(long cancellationCount, long currentMax, long currentAvg) {
            this.cancellationCount = cancellationCount;
            this.currentMax = currentMax;
            this.currentAvg = currentAvg;
        }

        public Stats(StreamInput in) throws IOException {
            this(in.readVLong(), in.readVLong(), in.readVLong());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("cancellation_count", this.cancellationCount).humanReadableField("current_max_millis", "current_max", (Object)new TimeValue(this.currentMax, TimeUnit.NANOSECONDS)).humanReadableField("current_avg_millis", "current_avg", (Object)new TimeValue(this.currentAvg, TimeUnit.NANOSECONDS)).endObject();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.cancellationCount);
            out.writeVLong(this.currentMax);
            out.writeVLong(this.currentAvg);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stats stats = (Stats)o;
            return this.cancellationCount == stats.cancellationCount && this.currentMax == stats.currentMax && this.currentAvg == stats.currentAvg;
        }

        public int hashCode() {
            return Objects.hash(this.cancellationCount, this.currentMax, this.currentAvg);
        }
    }
}

