/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.tasks.resourcetracker.ResourceStats;
import org.opensearch.tasks.Task;

@PublicApi(since="2.17.0")
public enum ResourceType {
    CPU("cpu", task -> task.getTotalResourceUtilization(ResourceStats.CPU), true),
    MEMORY("memory", task -> task.getTotalResourceUtilization(ResourceStats.MEMORY), true);

    private final String name;
    private final Function<Task, Long> getResourceUsage;
    private final boolean statsEnabled;
    private static List<ResourceType> sortedValues;

    private ResourceType(String name, Function<Task, Long> getResourceUsage, boolean statsEnabled) {
        this.name = name;
        this.getResourceUsage = getResourceUsage;
        this.statsEnabled = statsEnabled;
    }

    public static ResourceType fromName(String s) {
        for (ResourceType resourceType : ResourceType.values()) {
            if (!resourceType.getName().equals(s)) continue;
            return resourceType;
        }
        throw new IllegalArgumentException("Unknown resource type: [" + s + "]");
    }

    public static void writeTo(StreamOutput out, ResourceType resourceType) throws IOException {
        out.writeString(resourceType.getName());
    }

    public String getName() {
        return this.name;
    }

    public long getResourceUsage(Task task) {
        return this.getResourceUsage.apply(task);
    }

    public boolean hasStatsEnabled() {
        return this.statsEnabled;
    }

    public static List<ResourceType> getSortedValues() {
        return sortedValues;
    }

    static {
        sortedValues = List.of(CPU, MEMORY);
    }
}

