/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.util;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.alerting.util.AlertingExceptionKt;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.indices.InvalidIndexNameException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/commons/alerting/util/AlertingException;", "Lorg/opensearch/OpenSearchException;", "message", "", "status", "Lorg/opensearch/core/rest/RestStatus;", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Lorg/opensearch/core/rest/RestStatus;Ljava/lang/Exception;)V", "getEx", "()Ljava/lang/Exception;", "getStatus", "()Lorg/opensearch/core/rest/RestStatus;", "Companion", "common-utils"})
public final class AlertingException
extends OpenSearchException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RestStatus status;
    @NotNull
    private final Exception ex;

    public AlertingException(@NotNull String message, @NotNull RestStatus status, @NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        super(message, (Throwable)ex, new Object[0]);
        this.status = status;
        this.ex = ex;
    }

    @NotNull
    public final RestStatus getStatus() {
        return this.status;
    }

    @NotNull
    public final Exception getEx() {
        return this.ex;
    }

    @NotNull
    public RestStatus status() {
        return this.status;
    }

    @JvmStatic
    @NotNull
    public static final OpenSearchException wrap(@NotNull Exception ex) {
        return Companion.wrap(ex);
    }

    @JvmStatic
    @NotNull
    public static final AlertingException merge(AlertingException ... ex) {
        return Companion.merge(ex);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u00020\t2\n\u0010\u0005\u001a\u00060\nj\u0002`\u000bH\u0007\u00a8\u0006\f"}, d2={"Lorg/opensearch/commons/alerting/util/AlertingException$Companion;", "", "()V", "merge", "Lorg/opensearch/commons/alerting/util/AlertingException;", "ex", "", "([Lorg/opensearch/commons/alerting/util/AlertingException;)Lorg/opensearch/commons/alerting/util/AlertingException;", "wrap", "Lorg/opensearch/OpenSearchException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "common-utils"})
    @SourceDebugExtension(value={"SMAP\nAlertingException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertingException.kt\norg/opensearch/commons/alerting/util/AlertingException$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,90:1\n13579#2,2:91\n*S KotlinDebug\n*F\n+ 1 AlertingException.kt\norg/opensearch/commons/alerting/util/AlertingException$Companion\n*L\n77#1:91,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OpenSearchException wrap(@NotNull Exception ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            AlertingExceptionKt.access$getLog$p().error("Alerting error: " + ex);
            Object friendlyMsg = "Unknown error";
            RestStatus status = RestStatus.INTERNAL_SERVER_ERROR;
            Exception exception = ex;
            if (exception instanceof IndexNotFoundException) {
                RestStatus restStatus = ((IndexNotFoundException)ex).status();
                Intrinsics.checkNotNullExpressionValue((Object)restStatus, (String)"ex.status()");
                status = restStatus;
                friendlyMsg = "Configured indices are not found: " + ((IndexNotFoundException)ex).getIndex();
            } else if (exception instanceof OpenSearchSecurityException) {
                RestStatus restStatus = ((OpenSearchSecurityException)ex).status();
                Intrinsics.checkNotNullExpressionValue((Object)restStatus, (String)"ex.status()");
                status = restStatus;
                friendlyMsg = "User doesn't have permissions to execute this action. Contact administrator.";
            } else if (exception instanceof OpenSearchStatusException) {
                RestStatus restStatus = ((OpenSearchStatusException)ex).status();
                Intrinsics.checkNotNullExpressionValue((Object)restStatus, (String)"ex.status()");
                status = restStatus;
                String string = ex.getMessage();
                Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
                friendlyMsg = string;
            } else if (exception instanceof IllegalArgumentException) {
                status = RestStatus.BAD_REQUEST;
                String string = ex.getMessage();
                Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
                friendlyMsg = string;
            } else if (exception instanceof VersionConflictEngineException) {
                RestStatus restStatus = ((VersionConflictEngineException)ex).status();
                Intrinsics.checkNotNullExpressionValue((Object)restStatus, (String)"ex.status()");
                status = restStatus;
                String string = ex.getMessage();
                Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
                friendlyMsg = string;
            } else if (exception instanceof InvalidIndexNameException) {
                status = RestStatus.BAD_REQUEST;
                String string = ex.getMessage();
                Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
                friendlyMsg = string;
            } else if (!Strings.isNullOrEmpty((String)ex.getMessage())) {
                String string = ex.getMessage();
                Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
                friendlyMsg = string;
            }
            return new AlertingException((String)friendlyMsg, status, new Exception(ex.getClass().getName() + ": " + ex.getMessage()));
        }

        @JvmStatic
        @NotNull
        public final AlertingException merge(AlertingException ... ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            Object friendlyMsg = null;
            friendlyMsg = "";
            Object unwrappedExceptionMsg = null;
            unwrappedExceptionMsg = "";
            AlertingException[] $this$forEach$iv = ex;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                AlertingException element$iv;
                AlertingException it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)friendlyMsg, (Object)"")) {
                    friendlyMsg = friendlyMsg + ", " + it.getMessage();
                    unwrappedExceptionMsg = unwrappedExceptionMsg + ", " + it.getEx().getMessage();
                    continue;
                }
                String string = it.getMessage();
                if (string == null) {
                    string = "";
                }
                friendlyMsg = string;
                unwrappedExceptionMsg = String.valueOf(it.getEx().getMessage());
            }
            return new AlertingException((String)friendlyMsg, ((AlertingException)((Object)ArraysKt.first((Object[])ex))).getStatus(), new Exception((String)unwrappedExceptionMsg));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

