/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.slhdsa;

import org.bouncycastle.pqc.crypto.slhdsa.SIG_FORS;
import org.bouncycastle.pqc.crypto.slhdsa.SIG_XMSS;

class SIG {
    private final byte[] r;
    private final SIG_FORS[] sig_fors;
    private final SIG_XMSS[] sig_ht;

    public SIG(int n, int k, int a, int d, int hPrime, int wots_len, byte[] signature) {
        int j;
        byte[][] authPath;
        int i;
        this.r = new byte[n];
        System.arraycopy(signature, 0, this.r, 0, n);
        this.sig_fors = new SIG_FORS[k];
        int offset = n;
        for (i = 0; i != k; ++i) {
            byte[] sk = new byte[n];
            System.arraycopy(signature, offset, sk, 0, n);
            offset += n;
            authPath = new byte[a][];
            for (j = 0; j != a; ++j) {
                authPath[j] = new byte[n];
                System.arraycopy(signature, offset, authPath[j], 0, n);
                offset += n;
            }
            this.sig_fors[i] = new SIG_FORS(sk, authPath);
        }
        this.sig_ht = new SIG_XMSS[d];
        for (i = 0; i != d; ++i) {
            byte[] sig = new byte[wots_len * n];
            System.arraycopy(signature, offset, sig, 0, sig.length);
            offset += sig.length;
            authPath = new byte[hPrime][];
            for (j = 0; j != hPrime; ++j) {
                authPath[j] = new byte[n];
                System.arraycopy(signature, offset, authPath[j], 0, n);
                offset += n;
            }
            this.sig_ht[i] = new SIG_XMSS(sig, authPath);
        }
        if (offset != signature.length) {
            throw new IllegalArgumentException("signature wrong length");
        }
    }

    public byte[] getR() {
        return this.r;
    }

    public SIG_FORS[] getSIG_FORS() {
        return this.sig_fors;
    }

    public SIG_XMSS[] getSIG_HT() {
        return this.sig_ht;
    }
}

