/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.util;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.agreement.kdf.ConcatenationKDFGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.params.KDFParameters;
import org.bouncycastle.jcajce.spec.KEMKDFSpec;
import org.bouncycastle.util.Arrays;

public class KdfUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] makeKeyBytes(KEMKDFSpec kdfSpec, byte[] secret) {
        byte[] keyBytes;
        block8: {
            keyBytes = null;
            try {
                if (kdfSpec == null) {
                    keyBytes = new byte[secret.length];
                    System.arraycopy(secret, 0, keyBytes, 0, keyBytes.length);
                }
                AlgorithmIdentifier kdfAlgorithm = kdfSpec.getKdfAlgorithm();
                byte[] otherInfo = kdfSpec.getOtherInfo();
                keyBytes = new byte[(kdfSpec.getKeySize() + 7) / 8];
                if (kdfAlgorithm == null) {
                    System.arraycopy(secret, 0, keyBytes, 0, (kdfSpec.getKeySize() + 7) / 8);
                    break block8;
                }
                if (X9ObjectIdentifiers.id_kdf_kdf2.equals(kdfAlgorithm.getAlgorithm())) {
                    AlgorithmIdentifier digAlg = AlgorithmIdentifier.getInstance(kdfAlgorithm.getParameters());
                    KDF2BytesGenerator kdf = new KDF2BytesGenerator(KdfUtil.getDigest(digAlg.getAlgorithm()));
                    kdf.init(new KDFParameters(secret, otherInfo));
                    kdf.generateBytes(keyBytes, 0, keyBytes.length);
                    break block8;
                }
                if (X9ObjectIdentifiers.id_kdf_kdf3.equals(kdfAlgorithm.getAlgorithm())) {
                    AlgorithmIdentifier digAlg = AlgorithmIdentifier.getInstance(kdfAlgorithm.getParameters());
                    ConcatenationKDFGenerator kdf = new ConcatenationKDFGenerator(KdfUtil.getDigest(digAlg.getAlgorithm()));
                    kdf.init(new KDFParameters(secret, otherInfo));
                    kdf.generateBytes(keyBytes, 0, keyBytes.length);
                    break block8;
                }
                if (NISTObjectIdentifiers.id_shake256.equals(kdfAlgorithm.getAlgorithm())) {
                    SHAKEDigest xof = new SHAKEDigest(256);
                    xof.update(secret, 0, secret.length);
                    xof.update(otherInfo, 0, otherInfo.length);
                    xof.doFinal(keyBytes, 0, keyBytes.length);
                    break block8;
                }
                throw new IllegalStateException("Unrecognized KDF: " + kdfAlgorithm.getAlgorithm());
            }
            finally {
                Arrays.clear(secret);
            }
        }
        return keyBytes;
    }

    static Digest getDigest(ASN1ObjectIdentifier oid) {
        if (oid.equals(NISTObjectIdentifiers.id_sha256)) {
            return new SHA256Digest();
        }
        if (oid.equals(NISTObjectIdentifiers.id_sha512)) {
            return new SHA512Digest();
        }
        if (oid.equals(NISTObjectIdentifiers.id_shake128)) {
            return new SHAKEDigest(128);
        }
        if (oid.equals(NISTObjectIdentifiers.id_shake256)) {
            return new SHAKEDigest(256);
        }
        throw new IllegalArgumentException("unrecognized digest OID: " + oid);
    }
}

