/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;
import tim.prune.data.Field;

public class FieldSelectionTableModel
extends AbstractTableModel {
    private int _numRows = 0;
    private Field[] _fieldArray = null;
    private final String _customText = I18nManager.getText("fieldname.custom");

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return I18nManager.getText("dialog.load.table.field");
        }
        if (n == 1) {
            return I18nManager.getText("dialog.load.table.datatype");
        }
        return I18nManager.getText("dialog.load.table.description");
    }

    @Override
    public int getRowCount() {
        return this._fieldArray == null ? 2 : this._numRows;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this._fieldArray == null) {
            return "";
        }
        if (n2 == 0) {
            return "" + (n + 1);
        }
        Field field = this._fieldArray[n];
        if (n2 == 1) {
            return field.isBuiltIn() ? field.getName() : this._customText;
        }
        return field.isBuiltIn() ? "" : field.getName();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 <= 1) {
            return n2 == 1;
        }
        Field field = this._fieldArray[n];
        return !field.isBuiltIn();
    }

    public void updateData(Field[] fieldArray) {
        this._fieldArray = fieldArray;
        this._numRows = this._fieldArray == null ? 0 : this._fieldArray.length;
        this.fireTableStructureChanged();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Field field;
        super.setValueAt(object, n, n2);
        if (n2 == 1) {
            Field field2 = this._fieldArray[n];
            if (!field2.getName().equals(object.toString())) {
                this.manageFieldChange(n, object.toString());
            }
        } else if (n2 == 2 && !(field = this._fieldArray[n]).isBuiltIn()) {
            field.setName(object.toString());
        }
    }

    public void moveUp(int n) {
        if (n > 0) {
            this.swapItems(n - 1, n);
        }
    }

    public void moveDown(int n) {
        if (n > -1 && n < this._numRows - 1) {
            this.swapItems(n, n + 1);
        }
    }

    private void swapItems(int n, int n2) {
        Field field = this._fieldArray[n];
        this._fieldArray[n] = this._fieldArray[n2];
        this._fieldArray[n2] = field;
        this.fireTableRowsUpdated(n, n2);
    }

    private void manageFieldChange(int n, String string) {
        Field field = this._fieldArray[n];
        if (field == Field.LATITUDE || field == Field.LONGITUDE) {
            return;
        }
        if (string.equals(I18nManager.getText("fieldname.latitude")) || string.equals(I18nManager.getText("fieldname.longitude"))) {
            return;
        }
        boolean bl = string.equals(I18nManager.getText("fieldname.custom"));
        if (bl) {
            if (field.isBuiltIn()) {
                String string2 = String.valueOf(I18nManager.getText("fieldname.prefix")) + " ";
                int n2 = n + 1;
                while (this.hasField(String.valueOf(string2) + n2)) {
                    ++n2;
                }
                this._fieldArray[n] = new Field(String.valueOf(string2) + n2);
            }
        } else if (!this.hasField(string)) {
            this._fieldArray[n] = Field.getField(string);
        }
        this.fireTableRowsUpdated(n, n);
    }

    public Field[] getFieldArray() {
        return this._fieldArray;
    }

    private boolean hasField(String string) {
        if (this._fieldArray == null || string == null) {
            return false;
        }
        int n = 0;
        while (n < this._numRows) {
            if (this._fieldArray[n].getName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

