/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.netbeans.modules.autoupdate.services.MessageChecksumValidator;
import org.netbeans.modules.autoupdate.services.MessageDigestValidator;
import org.netbeans.modules.autoupdate.services.MessageMultiValidator;
import org.netbeans.modules.autoupdate.services.MessageValidator;
import org.netbeans.modules.autoupdate.services.Utilities;

public class ExternalFile {
    private static final Logger LOG = Logger.getLogger(ExternalFile.class.getName());
    private String name;
    private final List<String> urls = new ArrayList<String>();
    private Long crc32 = null;
    private Integer size = null;
    private final Map<String, byte[]> messageDigest = new HashMap<String, byte[]>();

    public static ExternalFile fromStream(String string, InputStream inputStream) throws IOException {
        ExternalFile externalFile = new ExternalFile();
        externalFile.setName(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (!string2.startsWith("#")) {
                Object object;
                if (string2.startsWith("SIZE:")) {
                    externalFile.setSize(Integer.parseInt(string2.substring(5).trim()));
                } else if (string2.startsWith("CRC:")) {
                    externalFile.setCrc32(Long.parseLong(string2.substring(4).trim()));
                } else if (string2.startsWith("URL:")) {
                    int n;
                    object = string2.substring(4).trim();
                    while ((n = object.indexOf("${")) != -1) {
                        int n2 = object.indexOf("}", n);
                        String string3 = object.substring(n + 2, n2);
                        String string4 = System.getProperty(string3);
                        if (string4 == null) {
                            throw new IOException("Can't find property " + string3);
                        }
                        object = object.substring(0, n) + string4 + object.substring(n2 + 1);
                    }
                    externalFile.getModifiableUrls().add((String)object);
                } else if (string2.startsWith("MessageDigest:")) {
                    object = string2.substring(14).trim().split("\\s+");
                    if (((String[])object).length == 2) {
                        try {
                            externalFile.getModifiableMessageDigests().put(object[0], Utilities.hexDecode(object[1]));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            LOG.log(Level.INFO, MessageFormat.format("Invalidly formatted MessageDigest line found in {1}: {0}", string2, string), illegalArgumentException);
                        }
                    } else {
                        LOG.log(Level.INFO, "Invalidly formatted MessageDigest line found in {1}: {0}", new Object[]{string2, string});
                    }
                } else if (!string2.trim().isEmpty()) {
                    LOG.log(Level.INFO, "Invalid content found in {1}: {0}", new Object[]{string2, string});
                }
            }
            string2 = bufferedReader.readLine();
        }
        return externalFile;
    }

    private ExternalFile() {
    }

    public List<String> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }

    public Map<String, byte[]> getMessageDigests() {
        return Collections.unmodifiableMap(this.messageDigest);
    }

    private List<String> getModifiableUrls() {
        return this.urls;
    }

    private Map<String, byte[]> getModifiableMessageDigests() {
        return this.messageDigest;
    }

    public Long getCrc32() {
        return this.crc32;
    }

    private void setCrc32(Long l) {
        this.crc32 = l;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer n) {
        this.size = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public MessageMultiValidator getValidator() {
        ArrayList<MessageValidator> arrayList = new ArrayList<MessageValidator>(2);
        arrayList.add(new MessageChecksumValidator(new CRC32(), this.getCrc32()));
        for (Map.Entry<String, byte[]> entry : this.getMessageDigests().entrySet()) {
            try {
                arrayList.add(new MessageDigestValidator(MessageDigest.getInstance(entry.getKey()), entry.getValue()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOG.log(Level.INFO, "Requested message digest {0} not found for {1}", new Object[]{entry.getKey(), this.getName()});
            }
        }
        return new MessageMultiValidator(arrayList);
    }
}

