/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.Command;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.InstrumentMethodGroupData;

public class InstrumentMethodGroupCommand
extends Command {
    private InstrumentMethodGroupData b;
    private int instrType;

    public InstrumentMethodGroupCommand(int instrType, String[] instrMethodClasses, int[] instrMethodClassLoaderIds, byte[][] replacementClassFileBytes, boolean[] instrMethodLeaf, int addInfo) {
        super(7);
        this.instrType = instrType;
        this.b = new InstrumentMethodGroupData(instrMethodClasses, instrMethodClassLoaderIds, replacementClassFileBytes, instrMethodLeaf, addInfo);
    }

    public InstrumentMethodGroupCommand(Object dummy) {
        super(7);
        this.instrType = -1;
    }

    InstrumentMethodGroupCommand() {
        super(7);
        this.b = new InstrumentMethodGroupData();
    }

    public InstrumentMethodGroupData getBase() {
        return this.b;
    }

    public int[] getClassLoaderIds() {
        return this.b.instrMethodClassLoaderIds;
    }

    public boolean isEmpty() {
        return this.instrType == -1;
    }

    public boolean[] getInstrMethodLeaf() {
        return this.b.instrMethodLeaf;
    }

    public int getInstrType() {
        return this.instrType;
    }

    public String[] getMethodClasses() {
        return this.b.instrMethodClasses;
    }

    public byte[][] getReplacementClassFileBytes() {
        return this.b.replacementClassFileBytes;
    }

    public void dump() {
        System.err.print("-- InstrumentMethodGroupCommand: ");
        if (this.b != null) {
            this.b.dump();
        }
    }

    public String toString() {
        return super.toString() + " " + (this.b != null ? this.b.toString() : "null");
    }

    void readObject(ObjectInputStream in) throws IOException {
        this.instrType = in.readInt();
        if (!this.isEmpty()) {
            this.b.readObject(in);
        }
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.instrType);
        if (!this.isEmpty()) {
            this.b.writeObject(out);
        }
    }
}

