/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.MultipartFormParameter;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.core.scanner.InputVector;

public class VariantMultipartFormParameters
implements Variant {
    private static final Logger LOGGER = LogManager.getLogger(VariantMultipartFormParameters.class);
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("\\s*content-disposition\\s*:.*\\s+name\\s*\\=?\\s*\\\"?(?<name>.[^;\\\"\\n]*)\\\"?\\;?.*", 2);
    private static final Pattern FIELD_VALUE_PATTERN = Pattern.compile("[\\r\\n]{2}(?<value>.*)");
    private static final Pattern FILENAME_PART_PATTERN = Pattern.compile("\\s*content-disposition\\s*:.*filename\\s*\\=?\\s*\\\"?(?<filename>.[^;\"\\n]*)\\\"?\\;?.*", 2);
    private static final Pattern CONTENTTYPE_PART_PATTERN = Pattern.compile("\\s*content-disposition.*content-type\\s*:\\s*\\s*\\\"?(?<contenttype>.[^;\"\\r\\n]*)\\\"?\\;?.*", 34);
    private List<NameValuePair> params = Collections.emptyList();
    private List<MultipartFormParameter> multiPartParams = new ArrayList<MultipartFormParameter>();

    @Override
    public void setMessage(HttpMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Parameter message must not be null.");
        }
        String contentType = msg.getRequestHeader().getHeader("Content-Type");
        if (contentType == null || !contentType.toLowerCase().startsWith("multipart/form-data")) {
            return;
        }
        ArrayList<NameValuePair> extractedParameters = new ArrayList<NameValuePair>();
        int position = 0;
        int offset = 0;
        String boundary = this.getBoundary(contentType) + "\r\n";
        for (String part : msg.getRequestBody().toString().split(boundary)) {
            if (!StringUtils.isBlank(part)) {
                String partHeaderLine = part.substring(0, part.indexOf("\r\n\r\n"));
                boolean isFileParam = partHeaderLine.contains("filename=");
                part = boundary + part;
                Matcher nameMatcher = FIELD_NAME_PATTERN.matcher(partHeaderLine);
                Matcher valueMatcher = FIELD_VALUE_PATTERN.matcher(part);
                nameMatcher.find();
                valueMatcher.find();
                if (StringUtils.isBlank(valueMatcher.group("value"))) {
                    valueMatcher.find();
                }
                String name = nameMatcher.group("name");
                String value = part.replaceAll(Pattern.quote(boundary + partHeaderLine) + "\r\n" + "\r\n", "");
                value = value.replaceAll("\r\n(" + Pattern.quote(this.getBoundary(contentType)) + "--" + "\r\n" + ")?$", "");
                if (isFileParam) {
                    extractedParameters.add(new NameValuePair(34, name, value, position += 2));
                } else {
                    extractedParameters.add(new NameValuePair(33, name, value, position));
                }
                int start = offset + part.indexOf("\r\n\r\n") + 4;
                int end = start + value.length();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Name: " + name + " O: " + offset + " S: " + start + " E: " + end + " Pos: " + position);
                }
                this.multiPartParams.add(new MultipartFormParameter(name, valueMatcher.group("value"), start, end, position, MultipartFormParameter.Type.GENERAL));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Name: " + name + " value: " + valueMatcher.group("value"));
                }
                if (isFileParam) {
                    Matcher fnValueMatcher = FILENAME_PART_PATTERN.matcher(part);
                    fnValueMatcher.find();
                    String fnValue = fnValueMatcher.group("filename");
                    extractedParameters.add(extractedParameters.size() - 1, new NameValuePair(35, name, fnValue, position -= 2));
                    int fnStart = offset + part.indexOf(fnValue);
                    int fnEnd = fnStart + fnValue.length();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Name: " + name + " O: " + offset + " S: " + fnStart + " E: " + fnEnd + " Pos: " + position);
                    }
                    this.multiPartParams.add(this.multiPartParams.size() - 1, new MultipartFormParameter(name, fnValue, fnStart, fnEnd, position, MultipartFormParameter.Type.FILE_NAME));
                    Matcher ctValueMatcher = CONTENTTYPE_PART_PATTERN.matcher(part);
                    ctValueMatcher.find();
                    String ctValue = ctValueMatcher.group("contenttype");
                    extractedParameters.add(extractedParameters.size() - 1, new NameValuePair(36, name, ctValue, ++position));
                    int ctStart = offset + part.indexOf(ctValue);
                    int ctEnd = ctStart + ctValue.length();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Name: " + name + " O: " + offset + " S: " + ctStart + " E: " + ctEnd + " Pos: " + position);
                    }
                    this.multiPartParams.add(this.multiPartParams.size() - 1, new MultipartFormParameter(name, ctValue, ctStart, ctEnd, position, MultipartFormParameter.Type.FILE_CONTENT_TYPE));
                }
            }
            ++position;
            offset += part.length();
        }
        this.params = Collections.unmodifiableList(extractedParameters);
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, Collections.singletonList(originalPair.getPosition()), Collections.singletonList(value));
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, Collections.singletonList(originalPair.getPosition()), Collections.singletonList(value));
    }

    @Override
    public void setParameters(HttpMessage msg, List<InputVector> inputVectors) {
        this.setParameter(msg, inputVectors.stream().map(InputVector::getPosition).collect(Collectors.toList()), inputVectors.stream().map(InputVector::getValue).collect(Collectors.toList()));
    }

    private String setParameter(HttpMessage msg, List<Integer> nameValuePairPositions, List<String> values) {
        StringBuilder newBodyBuilder = new StringBuilder(msg.getRequestBody().toString());
        int offset = 0;
        for (int index = 0; index < nameValuePairPositions.size(); ++index) {
            int originalPosition = nameValuePairPositions.get(index);
            String value = values.get(index);
            int idx = originalPosition - 1;
            MultipartFormParameter mpPart = this.multiPartParams.get(idx);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("i: " + idx + " pos: " + originalPosition + " S: " + mpPart.getStart() + " E: " + mpPart.getEnd() + " O: " + offset);
            }
            newBodyBuilder.replace(mpPart.getStart() + offset, mpPart.getEnd() + offset, value);
            offset = offset + value.length() - mpPart.getEnd() + mpPart.getStart();
        }
        String newBody = newBodyBuilder.toString();
        msg.getRequestBody().setBody(newBody);
        return newBody;
    }

    private String getBoundary(String contentTypeHeader) {
        int index = contentTypeHeader.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = contentTypeHeader.substring(index + 9);
        if (boundary.charAt(0) == '\"') {
            index = boundary.lastIndexOf(34);
            boundary = boundary.substring(1, index);
        }
        boundary = "--" + boundary;
        return boundary;
    }
}

