/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedPath;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedPaths
implements ComposedChanged {
    private final Map<String, PathItem> oldPathMap;
    private final Map<String, PathItem> newPathMap;
    private Map<String, PathItem> increased;
    private Map<String, PathItem> missing;
    private Map<String, ChangedPath> changed;

    public ChangedPaths(Map<String, PathItem> oldPathMap, Map<String, PathItem> newPathMap) {
        this.oldPathMap = oldPathMap;
        this.newPathMap = newPathMap;
        this.increased = new LinkedHashMap<String, PathItem>();
        this.missing = new LinkedHashMap<String, PathItem>();
        this.changed = new LinkedHashMap<String, ChangedPath>();
    }

    @Override
    public List<Changed> getChangedElements() {
        return new ArrayList<Changed>(this.changed.values());
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.increased.isEmpty() && this.missing.isEmpty()) {
            return DiffResult.NO_CHANGES;
        }
        if (this.missing.isEmpty()) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.INCOMPATIBLE;
    }

    public Map<String, PathItem> getOldPathMap() {
        return this.oldPathMap;
    }

    public Map<String, PathItem> getNewPathMap() {
        return this.newPathMap;
    }

    public Map<String, PathItem> getIncreased() {
        return this.increased;
    }

    public Map<String, PathItem> getMissing() {
        return this.missing;
    }

    public Map<String, ChangedPath> getChanged() {
        return this.changed;
    }

    public void setIncreased(Map<String, PathItem> increased) {
        this.increased = increased;
    }

    public void setMissing(Map<String, PathItem> missing) {
        this.missing = missing;
    }

    public void setChanged(Map<String, ChangedPath> changed) {
        this.changed = changed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedPaths that = (ChangedPaths)o;
        return Objects.equals(this.oldPathMap, that.oldPathMap) && Objects.equals(this.newPathMap, that.newPathMap) && Objects.equals(this.increased, that.increased) && Objects.equals(this.missing, that.missing) && Objects.equals(this.changed, that.changed);
    }

    public int hashCode() {
        return Objects.hash(this.oldPathMap, this.newPathMap, this.increased, this.missing, this.changed);
    }

    public String toString() {
        return "ChangedPaths(oldPathMap=" + this.getOldPathMap() + ", newPathMap=" + this.getNewPathMap() + ", increased=" + this.getIncreased() + ", missing=" + this.getMissing() + ", changed=" + this.getChanged() + ")";
    }
}

