"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observabilityOverviewID = exports.observabilityNotebookTitle = exports.observabilityNotebookPluginOrder = exports.observabilityNotebookID = exports.observabilityMetricsTitle = exports.observabilityMetricsPluginOrder = exports.observabilityMetricsID = exports.observabilityLogsTitle = exports.observabilityLogsPluginOrder = exports.observabilityLogsID = exports.observabilityIntegrationsTitle = exports.observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsID = exports.observabilityID = exports.observabilityGettingStartedTitle = exports.observabilityGettingStartedPluginOrder = exports.observabilityGettingStartedID = exports.observabilityDataConnectionsTitle = exports.observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsID = exports.observabilityApplicationsTitle = exports.observabilityApplicationsPluginOrder = exports.observabilityApplicationsID = exports.discoverPluginID = exports.anomalyDetectionPluginID = exports.alertingPluginID = exports.WAITING_TIME_ON_USER_ACTIONS = exports.VIS_CHART_TYPES = exports.VISUALIZATION_ERROR = exports.UI_DATE_FORMAT = exports.TIMESTAMP_DATETIME_TYPES = exports.THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_OPACITY = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SPAN_REGEX = exports.SLIDER_STEP = exports.SLIDER_MIN_VALUE = exports.SLIDER_MAX_VALUE = exports.SECURITY_ROLES = exports.SECURITY_PLUGIN_ACCOUNT_API = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.S3_DATA_SOURCE_TYPE = exports.QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_END_TIME = exports.PROMQL_METRIC_SUBTYPE = exports.PPL_WHERE_CLAUSE_REGEX = exports.PPL_STATS_REGEX = exports.PPL_SPAN_REGEX = exports.PPL_SEARCH = exports.PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_NEWLINE_REGEX = exports.PPL_METRIC_SUBTYPE = exports.PPL_INDEX_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_DESCRIBE_INDEX_REGEX = exports.PPL_DATE_FORMAT = exports.PPL_BASE = exports.PLOT_MARGIN = exports.PLOTLY_COLOR = exports.OTEL_METRIC_SUBTYPE = exports.OTEL_DATE_FORMAT = exports.OPENSEARCH_PANELS_API = exports.OPENSEARCH_DATACONNECTIONS_API = exports.OBSERVABILITY_BASE = exports.NUMERICAL_FIELDS = exports.MAX_BUCKET_LENGTH = exports.LONG_CHART_COLOR = exports.LIVE_OPTIONS = exports.LIVE_END_TIME = exports.JOB_RESULT_ENDPOINT = exports.JOBS_ENDPOINT_BASE = exports.JOBS_BASE = exports.INTEGRATIONS_BASE = exports.FILLOPACITY_DIV_FACTOR = exports.EVENT_ANALYTICS = exports.ENABLED_VIS_TYPES = exports.EDIT = exports.DSL_SETTINGS = exports.DSL_SEARCH = exports.DSL_MAPPING = exports.DSL_ENDPOINT = exports.DSL_CAT = exports.DSL_BASE = exports.DIRECT_DUMMY_QUERY = exports.DEFAULT_START_TIME = exports.DEFAULT_CHART_STYLES = exports.DATACONNECTIONS_UPDATE_STATUS = exports.DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_BASE = exports.CONSOLE_PROXY = exports.BarOrientation = exports.ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_DATASOURCE_CACHE = exports.ASYNC_QUERY_ACCELERATIONS_CACHE = void 0;
exports.tutorialSampleDataPluginId = exports.queryWorkbenchPluginID = exports.queryWorkbenchPluginCheck = exports.pageStyles = exports.observabilityTracesTitle = exports.observabilityTracesPluginOrder = exports.observabilityTracesNewNavURL = exports.observabilityTracesNewNavID = exports.observabilityTracesID = exports.observabilityTitle = exports.observabilityServicesTitle = exports.observabilityServicesPluginOrder = exports.observabilityServicesNewNavURL = exports.observabilityServicesNewNavID = exports.observabilityServicesID = exports.observabilityPluginOrder = exports.observabilityPanelsTitle = exports.observabilityPanelsPluginOrder = exports.observabilityPanelsID = exports.observabilityOverviewTitle = exports.observabilityOverviewPluginOrder = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Client route
const PPL_BASE = exports.PPL_BASE = '/api/ppl';
const PPL_SEARCH = exports.PPL_SEARCH = '/search';
const DSL_BASE = exports.DSL_BASE = '/api/dsl';
const DSL_SEARCH = exports.DSL_SEARCH = '/search';
const DSL_CAT = exports.DSL_CAT = '/cat.indices';
const DSL_MAPPING = exports.DSL_MAPPING = '/indices.getFieldMapping';
const DSL_SETTINGS = exports.DSL_SETTINGS = '/indices.getFieldSettings';
const OBSERVABILITY_BASE = exports.OBSERVABILITY_BASE = '/api/observability';
const INTEGRATIONS_BASE = exports.INTEGRATIONS_BASE = '/api/integrations';
const JOBS_BASE = exports.JOBS_BASE = '/query/jobs';
const DATACONNECTIONS_BASE = exports.DATACONNECTIONS_BASE = '/api/dataconnections';
const EDIT = exports.EDIT = '/edit';
const DATACONNECTIONS_UPDATE_STATUS = exports.DATACONNECTIONS_UPDATE_STATUS = '/status';
const SECURITY_ROLES = exports.SECURITY_ROLES = '/api/v1/configuration/roles';
const EVENT_ANALYTICS = exports.EVENT_ANALYTICS = '/event_analytics';
const SAVED_OBJECTS = exports.SAVED_OBJECTS = '/saved_objects';
const SAVED_QUERY = exports.SAVED_QUERY = '/query';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = '/vis';
const CONSOLE_PROXY = exports.CONSOLE_PROXY = '/api/console/proxy';
const SECURITY_PLUGIN_ACCOUNT_API = exports.SECURITY_PLUGIN_ACCOUNT_API = '/api/v1/configuration/account';

// Server route
const PPL_ENDPOINT = exports.PPL_ENDPOINT = '/_plugins/_ppl';
const SQL_ENDPOINT = exports.SQL_ENDPOINT = '/_plugins/_sql';
const DSL_ENDPOINT = exports.DSL_ENDPOINT = '/_plugins/_dsl';
const DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_ENDPOINT = '/_plugins/_query/_datasources';
const JOBS_ENDPOINT_BASE = exports.JOBS_ENDPOINT_BASE = '/_plugins/_async_query';
const JOB_RESULT_ENDPOINT = exports.JOB_RESULT_ENDPOINT = '/result';
const tutorialSampleDataPluginId = exports.tutorialSampleDataPluginId = 'import_sample_data';
const observabilityID = exports.observabilityID = 'observability-logs';
const observabilityTitle = exports.observabilityTitle = 'Observability';
const observabilityPluginOrder = exports.observabilityPluginOrder = 1500;
const observabilityOverviewID = exports.observabilityOverviewID = 'observability-overview';
const observabilityOverviewTitle = exports.observabilityOverviewTitle = 'Observability overview';
const observabilityOverviewPluginOrder = exports.observabilityOverviewPluginOrder = 5088;
const observabilityGettingStartedID = exports.observabilityGettingStartedID = 'observability-gettingStarted';
const observabilityGettingStartedTitle = exports.observabilityGettingStartedTitle = 'Get started';
const observabilityGettingStartedPluginOrder = exports.observabilityGettingStartedPluginOrder = 5089;
const observabilityApplicationsID = exports.observabilityApplicationsID = 'observability-applications';
const observabilityApplicationsTitle = exports.observabilityApplicationsTitle = 'Applications';
const observabilityApplicationsPluginOrder = exports.observabilityApplicationsPluginOrder = 5090;
const observabilityLogsID = exports.observabilityLogsID = 'observability-logs';
const observabilityLogsTitle = exports.observabilityLogsTitle = 'Logs';
const observabilityLogsPluginOrder = exports.observabilityLogsPluginOrder = 5091;
const observabilityMetricsID = exports.observabilityMetricsID = 'observability-metrics';
const observabilityMetricsTitle = exports.observabilityMetricsTitle = 'Metrics';
const observabilityMetricsPluginOrder = exports.observabilityMetricsPluginOrder = 5092;
const observabilityTracesNewNavID = exports.observabilityTracesNewNavID = 'observability-traces-nav';
const observabilityTracesNewNavURL = exports.observabilityTracesNewNavURL = observabilityTracesNewNavID + '#/traces';
const observabilityTracesID = exports.observabilityTracesID = 'observability-traces';
const observabilityTracesTitle = exports.observabilityTracesTitle = 'Traces';
const observabilityTracesPluginOrder = exports.observabilityTracesPluginOrder = 5093;
const observabilityServicesNewNavID = exports.observabilityServicesNewNavID = 'observability-services-nav';
const observabilityServicesNewNavURL = exports.observabilityServicesNewNavURL = observabilityServicesNewNavID + '#/services';
const observabilityServicesID = exports.observabilityServicesID = 'observability-services';
const observabilityServicesTitle = exports.observabilityServicesTitle = 'Services';
const observabilityServicesPluginOrder = exports.observabilityServicesPluginOrder = 5092;
const observabilityNotebookID = exports.observabilityNotebookID = 'observability-notebooks';
const observabilityNotebookTitle = exports.observabilityNotebookTitle = 'Notebooks';
const observabilityNotebookPluginOrder = exports.observabilityNotebookPluginOrder = 5094;
const observabilityPanelsID = exports.observabilityPanelsID = 'observability-dashboards';
const observabilityPanelsTitle = exports.observabilityPanelsTitle = 'Dashboards';
const observabilityPanelsPluginOrder = exports.observabilityPanelsPluginOrder = 5095;
const observabilityIntegrationsID = exports.observabilityIntegrationsID = 'integrations';
const observabilityIntegrationsTitle = exports.observabilityIntegrationsTitle = 'Integrations';
const observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsPluginOrder = 9020;
const observabilityDataConnectionsID = exports.observabilityDataConnectionsID = 'datasources';
const observabilityDataConnectionsTitle = exports.observabilityDataConnectionsTitle = 'Data sources';
const observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsPluginOrder = 9030;
const queryWorkbenchPluginID = exports.queryWorkbenchPluginID = 'opensearch-query-workbench';
const queryWorkbenchPluginCheck = exports.queryWorkbenchPluginCheck = 'plugin:queryWorkbenchDashboards';
const alertingPluginID = exports.alertingPluginID = 'alerting';
const anomalyDetectionPluginID = exports.anomalyDetectionPluginID = 'anomaly-detection-dashboards';
const discoverPluginID = exports.discoverPluginID = 'data-explorer/discover';

// Shared Constants
const SQL_DOCUMENTATION_URL = exports.SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
const PPL_DOCUMENTATION_URL = exports.PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/ppl/index';
const PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_PATTERNS_DOCUMENTATION_URL = 'https://github.com/opensearch-project/sql/blob/2.x/docs/user/ppl/cmd/patterns.rst#description';
const UI_DATE_FORMAT = exports.UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
const PPL_DATE_FORMAT = exports.PPL_DATE_FORMAT = 'YYYY-MM-DD HH:mm:ss.SSSSSS';
const OTEL_DATE_FORMAT = exports.OTEL_DATE_FORMAT = 'YYYY-MM-DDTHH:mm:ss';
const SPAN_REGEX = exports.SPAN_REGEX = /span/;
const PROMQL_METRIC_SUBTYPE = exports.PROMQL_METRIC_SUBTYPE = 'promqlmetric';
const OTEL_METRIC_SUBTYPE = exports.OTEL_METRIC_SUBTYPE = 'openTelemetryMetric';
const PPL_METRIC_SUBTYPE = exports.PPL_METRIC_SUBTYPE = 'metric';
const PPL_SPAN_REGEX = exports.PPL_SPAN_REGEX = /by\s*span/i;
const PPL_STATS_REGEX = exports.PPL_STATS_REGEX = /\|\s*stats/i;
const PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)(.*)/i;
const PPL_INDEX_REGEX = exports.PPL_INDEX_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)/i;
const PPL_WHERE_CLAUSE_REGEX = exports.PPL_WHERE_CLAUSE_REGEX = /\s*where\s+/i;
const PPL_NEWLINE_REGEX = exports.PPL_NEWLINE_REGEX = /[\n\r]+/g;
const PPL_DESCRIBE_INDEX_REGEX = exports.PPL_DESCRIBE_INDEX_REGEX = /(describe)\s+([^|\s]+)/i;

// Observability plugin URI
const BASE_OBSERVABILITY_URI = '/_plugins/_observability';
const BASE_DATACONNECTIONS_URI = '/_plugins/_query/_datasources';
const OPENSEARCH_PANELS_API = exports.OPENSEARCH_PANELS_API = {
  OBJECT: `${BASE_OBSERVABILITY_URI}/object`
};
const OPENSEARCH_DATACONNECTIONS_API = exports.OPENSEARCH_DATACONNECTIONS_API = {
  DATACONNECTION: `${BASE_DATACONNECTIONS_URI}`
};

// Saved Objects
const SAVED_OBJECT = exports.SAVED_OBJECT = '/object';

// Color Constants
const PLOTLY_COLOR = exports.PLOTLY_COLOR = ['#3CA1C7', '#54B399', '#DB748A', '#F2BE4B', '#68CCC2', '#2A7866', '#843769', '#374FB8', '#BD6F26', '#4C636F'];
const LONG_CHART_COLOR = exports.LONG_CHART_COLOR = PLOTLY_COLOR[1];
const pageStyles = exports.pageStyles = {
  float: 'left',
  width: '100%'
};
let VIS_CHART_TYPES = exports.VIS_CHART_TYPES = /*#__PURE__*/function (VIS_CHART_TYPES) {
  VIS_CHART_TYPES["Bar"] = "bar";
  VIS_CHART_TYPES["HorizontalBar"] = "horizontal_bar";
  VIS_CHART_TYPES["Line"] = "line";
  VIS_CHART_TYPES["Pie"] = "pie";
  VIS_CHART_TYPES["HeatMap"] = "heatmap";
  VIS_CHART_TYPES["Text"] = "text";
  VIS_CHART_TYPES["Histogram"] = "histogram";
  return VIS_CHART_TYPES;
}({});
const NUMERICAL_FIELDS = exports.NUMERICAL_FIELDS = ['short', 'integer', 'long', 'float', 'double'];
const ENABLED_VIS_TYPES = exports.ENABLED_VIS_TYPES = [VIS_CHART_TYPES.Bar, VIS_CHART_TYPES.HorizontalBar, VIS_CHART_TYPES.Line, VIS_CHART_TYPES.Pie, VIS_CHART_TYPES.HeatMap, VIS_CHART_TYPES.Text];

// Live tail constants
const LIVE_OPTIONS = exports.LIVE_OPTIONS = [{
  label: '5s',
  startTime: 'now-5s',
  delayTime: 5000
}, {
  label: '10s',
  startTime: 'now-10s',
  delayTime: 10000
}, {
  label: '30s',
  startTime: 'now-30s',
  delayTime: 30000
}, {
  label: '1m',
  startTime: 'now-1m',
  delayTime: 60000
}, {
  label: '5m',
  startTime: 'now-5m',
  delayTime: 60000 * 5
}, {
  label: '15m',
  startTime: 'now-15m',
  delayTime: 60000 * 15
}, {
  label: '30m',
  startTime: 'now-30m',
  delayTime: 60000 * 30
}, {
  label: '1h',
  startTime: 'now-1h',
  delayTime: 60000 * 60
}, {
  label: '2h',
  startTime: 'now-2h',
  delayTime: 60000 * 120
}];
const LIVE_END_TIME = exports.LIVE_END_TIME = 'now';
const DEFAULT_CHART_STYLES = exports.DEFAULT_CHART_STYLES = {
  DefaultModeLine: 'lines',
  Interpolation: 'spline',
  LineWidth: 0,
  FillOpacity: 100,
  MarkerSize: 5,
  ShowLegend: 'show',
  LegendPosition: 'v',
  LabelAngle: 0,
  DefaultSortSectors: 'largest_to_smallest',
  DefaultModeScatter: 'markers'
};
const FILLOPACITY_DIV_FACTOR = exports.FILLOPACITY_DIV_FACTOR = 200;
const SLIDER_MIN_VALUE = exports.SLIDER_MIN_VALUE = 0;
const SLIDER_MAX_VALUE = exports.SLIDER_MAX_VALUE = 100;
const SLIDER_STEP = exports.SLIDER_STEP = 1;
const THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_WIDTH = 3;
const THRESHOLD_LINE_OPACITY = exports.THRESHOLD_LINE_OPACITY = 0.7;
const MAX_BUCKET_LENGTH = exports.MAX_BUCKET_LENGTH = 16;
let BarOrientation = exports.BarOrientation = /*#__PURE__*/function (BarOrientation) {
  BarOrientation["horizontal"] = "h";
  BarOrientation["vertical"] = "v";
  return BarOrientation;
}({});
const PLOT_MARGIN = exports.PLOT_MARGIN = {
  l: 30,
  r: 5,
  b: 30,
  t: 50,
  pad: 4
};
const WAITING_TIME_ON_USER_ACTIONS = exports.WAITING_TIME_ON_USER_ACTIONS = 300;
const VISUALIZATION_ERROR = exports.VISUALIZATION_ERROR = {
  NO_DATA: 'No data found.',
  INVALID_DATA: 'Invalid visualization data',
  NO_SERIES: 'Add a field to start',
  NO_METRIC: 'Invalid Metric MetaData'
};
const S3_DATA_SOURCE_TYPE = exports.S3_DATA_SOURCE_TYPE = 's3glue';
const ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_SESSION_ID = 'async-query-session-id';
const ASYNC_QUERY_DATASOURCE_CACHE = exports.ASYNC_QUERY_DATASOURCE_CACHE = 'async-query-catalog-cache';
const ASYNC_QUERY_ACCELERATIONS_CACHE = exports.ASYNC_QUERY_ACCELERATIONS_CACHE = 'async-query-acclerations-cache';
const DIRECT_DUMMY_QUERY = exports.DIRECT_DUMMY_QUERY = 'select 1';
const DEFAULT_START_TIME = exports.DEFAULT_START_TIME = 'now-15m';
const QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_START_TIME = 'now-40y';
const QUERY_ASSIST_END_TIME = exports.QUERY_ASSIST_END_TIME = 'now';
const TIMESTAMP_DATETIME_TYPES = exports.TIMESTAMP_DATETIME_TYPES = ['date', 'date_nanos'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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