# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
from __future__ import annotations
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".

# mypy: disable-error-code="override, overload-overlap"
"""

# Module `PySide6.QtGui`

import PySide6.QtGui
import PySide6.QtCore

import os
import enum
import typing
from collections.abc import Iterable
from PySide6.QtCore import Signal
from shiboken6 import Shiboken


NoneType: typing.TypeAlias = type[None]


class QAbstractFileIconProvider(Shiboken.Object):

    class IconType(enum.Enum):

        Computer                  = ...  # 0x0
        Desktop                   = ...  # 0x1
        Trashcan                  = ...  # 0x2
        Network                   = ...  # 0x3
        Drive                     = ...  # 0x4
        Folder                    = ...  # 0x5
        File                      = ...  # 0x6

    class Option(enum.Flag):

        DontUseCustomDirectoryIcons = ...  # 0x1


    def __init__(self) -> None: ...

    @typing.overload
    def icon(self, arg__1: PySide6.QtCore.QFileInfo) -> PySide6.QtGui.QIcon: ...
    @typing.overload
    def icon(self, arg__1: PySide6.QtGui.QAbstractFileIconProvider.IconType) -> PySide6.QtGui.QIcon: ...
    def options(self) -> PySide6.QtGui.QAbstractFileIconProvider.Option: ...
    def setOptions(self, arg__1: PySide6.QtGui.QAbstractFileIconProvider.Option) -> None: ...
    def type(self, arg__1: PySide6.QtCore.QFileInfo) -> str: ...


class QAbstractTextDocumentLayout(PySide6.QtCore.QObject):

    documentSizeChanged      : typing.ClassVar[Signal] = ... # documentSizeChanged(QSizeF)
    pageCountChanged         : typing.ClassVar[Signal] = ... # pageCountChanged(int)
    update                   : typing.ClassVar[Signal] = ... # update(); update(QRectF)
    updateBlock              : typing.ClassVar[Signal] = ... # updateBlock(QTextBlock)

    class PaintContext(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, PaintContext: PySide6.QtGui.QAbstractTextDocumentLayout.PaintContext) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class Selection(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Selection: PySide6.QtGui.QAbstractTextDocumentLayout.Selection) -> None: ...

        @staticmethod
        def __copy__() -> None: ...


    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None: ...

    def anchorAt(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> str: ...
    def blockBoundingRect(self, block: PySide6.QtGui.QTextBlock) -> PySide6.QtCore.QRectF: ...
    def blockWithMarkerAt(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> PySide6.QtGui.QTextBlock: ...
    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def documentChanged(self, from_: int, charsRemoved: int, charsAdded: int) -> None: ...
    def documentSize(self) -> PySide6.QtCore.QSizeF: ...
    def draw(self, painter: PySide6.QtGui.QPainter, context: PySide6.QtGui.QAbstractTextDocumentLayout.PaintContext) -> None: ...
    def drawInlineObject(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, object: PySide6.QtGui.QTextInlineObject, posInDocument: int, format: PySide6.QtGui.QTextFormat) -> None: ...
    def format(self, pos: int) -> PySide6.QtGui.QTextCharFormat: ...
    def formatAt(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> PySide6.QtGui.QTextFormat: ...
    def formatIndex(self, pos: int) -> int: ...
    def frameBoundingRect(self, frame: PySide6.QtGui.QTextFrame) -> PySide6.QtCore.QRectF: ...
    def handlerForObject(self, objectType: int) -> PySide6.QtGui.QTextObjectInterface: ...
    def hitTest(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, accuracy: PySide6.QtCore.Qt.HitTestAccuracy) -> int: ...
    def imageAt(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> str: ...
    def pageCount(self) -> int: ...
    def paintDevice(self) -> PySide6.QtGui.QPaintDevice: ...
    def positionInlineObject(self, item: PySide6.QtGui.QTextInlineObject, posInDocument: int, format: PySide6.QtGui.QTextFormat) -> None: ...
    def registerHandler(self, objectType: int, component: PySide6.QtCore.QObject) -> None: ...
    def resizeInlineObject(self, item: PySide6.QtGui.QTextInlineObject, posInDocument: int, format: PySide6.QtGui.QTextFormat) -> None: ...
    def setPaintDevice(self, device: PySide6.QtGui.QPaintDevice) -> None: ...
    def unregisterHandler(self, objectType: int, component: PySide6.QtCore.QObject | None= ...) -> None: ...


class PaintContext(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, PaintContext: PySide6.QtGui.QAbstractTextDocumentLayout.PaintContext) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class Selection(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, Selection: PySide6.QtGui.QAbstractTextDocumentLayout.Selection) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QAccessible(Shiboken.Object):

    class AnnouncementPoliteness(enum.Enum):

        Polite                    = ...  # 0x0
        Assertive                 = ...  # 0x1

    class Attribute(enum.Enum):

        Custom                    = ...  # 0x0
        Level                     = ...  # 0x1

    class Event(enum.Enum):

        SoundPlayed               = ...  # 0x1
        Alert                     = ...  # 0x2
        ForegroundChanged         = ...  # 0x3
        MenuStart                 = ...  # 0x4
        MenuEnd                   = ...  # 0x5
        PopupMenuStart            = ...  # 0x6
        PopupMenuEnd              = ...  # 0x7
        ContextHelpStart          = ...  # 0xc
        ContextHelpEnd            = ...  # 0xd
        DragDropStart             = ...  # 0xe
        DragDropEnd               = ...  # 0xf
        DialogStart               = ...  # 0x10
        DialogEnd                 = ...  # 0x11
        ScrollingStart            = ...  # 0x12
        ScrollingEnd              = ...  # 0x13
        MenuCommand               = ...  # 0x18
        ActionChanged             = ...  # 0x101
        ActiveDescendantChanged   = ...  # 0x102
        AttributeChanged          = ...  # 0x103
        DocumentContentChanged    = ...  # 0x104
        DocumentLoadComplete      = ...  # 0x105
        DocumentLoadStopped       = ...  # 0x106
        DocumentReload            = ...  # 0x107
        HyperlinkEndIndexChanged  = ...  # 0x108
        HyperlinkNumberOfAnchorsChanged = ...  # 0x109
        HyperlinkSelectedLinkChanged = ...  # 0x10a
        HypertextLinkActivated    = ...  # 0x10b
        HypertextLinkSelected     = ...  # 0x10c
        HyperlinkStartIndexChanged = ...  # 0x10d
        HypertextChanged          = ...  # 0x10e
        HypertextNLinksChanged    = ...  # 0x10f
        ObjectAttributeChanged    = ...  # 0x110
        PageChanged               = ...  # 0x111
        SectionChanged            = ...  # 0x112
        TableCaptionChanged       = ...  # 0x113
        TableColumnDescriptionChanged = ...  # 0x114
        TableColumnHeaderChanged  = ...  # 0x115
        TableModelChanged         = ...  # 0x116
        TableRowDescriptionChanged = ...  # 0x117
        TableRowHeaderChanged     = ...  # 0x118
        TableSummaryChanged       = ...  # 0x119
        TextAttributeChanged      = ...  # 0x11a
        TextCaretMoved            = ...  # 0x11b
        TextColumnChanged         = ...  # 0x11d
        TextInserted              = ...  # 0x11e
        TextRemoved               = ...  # 0x11f
        TextUpdated               = ...  # 0x120
        TextSelectionChanged      = ...  # 0x121
        VisibleDataChanged        = ...  # 0x122
        ObjectCreated             = ...  # 0x8000
        ObjectDestroyed           = ...  # 0x8001
        ObjectShow                = ...  # 0x8002
        ObjectHide                = ...  # 0x8003
        ObjectReorder             = ...  # 0x8004
        Focus                     = ...  # 0x8005
        Selection                 = ...  # 0x8006
        SelectionAdd              = ...  # 0x8007
        SelectionRemove           = ...  # 0x8008
        SelectionWithin           = ...  # 0x8009
        StateChanged              = ...  # 0x800a
        LocationChanged           = ...  # 0x800b
        NameChanged               = ...  # 0x800c
        DescriptionChanged        = ...  # 0x800d
        ValueChanged              = ...  # 0x800e
        ParentChanged             = ...  # 0x800f
        HelpChanged               = ...  # 0x80a0
        DefaultActionChanged      = ...  # 0x80b0
        AcceleratorChanged        = ...  # 0x80c0
        InvalidEvent              = ...  # 0x80c1
        Announcement              = ...  # 0x80d0
        IdentifierChanged         = ...  # 0x80e0

    class InterfaceType(enum.Enum):

        TextInterface             = ...  # 0x0
        EditableTextInterface     = ...  # 0x1
        ValueInterface            = ...  # 0x2
        ActionInterface           = ...  # 0x3
        ImageInterface            = ...  # 0x4
        TableInterface            = ...  # 0x5
        TableCellInterface        = ...  # 0x6
        HyperlinkInterface        = ...  # 0x7
        SelectionInterface        = ...  # 0x8
        AttributesInterface       = ...  # 0x9

    class RelationFlag(enum.Flag):

        Label                     = ...  # 0x1
        Labelled                  = ...  # 0x2
        Controller                = ...  # 0x4
        Controlled                = ...  # 0x8
        DescriptionFor            = ...  # 0x10
        Described                 = ...  # 0x20
        FlowsFrom                 = ...  # 0x40
        FlowsTo                   = ...  # 0x80
        AllRelations              = ...  # 0xffffffff

    class Role(enum.Enum):

        NoRole                    = ...  # 0x0
        TitleBar                  = ...  # 0x1
        MenuBar                   = ...  # 0x2
        ScrollBar                 = ...  # 0x3
        Grip                      = ...  # 0x4
        Sound                     = ...  # 0x5
        Cursor                    = ...  # 0x6
        Caret                     = ...  # 0x7
        AlertMessage              = ...  # 0x8
        Window                    = ...  # 0x9
        Client                    = ...  # 0xa
        PopupMenu                 = ...  # 0xb
        MenuItem                  = ...  # 0xc
        ToolTip                   = ...  # 0xd
        Application               = ...  # 0xe
        Document                  = ...  # 0xf
        Pane                      = ...  # 0x10
        Chart                     = ...  # 0x11
        Dialog                    = ...  # 0x12
        Border                    = ...  # 0x13
        Grouping                  = ...  # 0x14
        Separator                 = ...  # 0x15
        ToolBar                   = ...  # 0x16
        StatusBar                 = ...  # 0x17
        Table                     = ...  # 0x18
        ColumnHeader              = ...  # 0x19
        RowHeader                 = ...  # 0x1a
        Column                    = ...  # 0x1b
        Row                       = ...  # 0x1c
        Cell                      = ...  # 0x1d
        Link                      = ...  # 0x1e
        HelpBalloon               = ...  # 0x1f
        Assistant                 = ...  # 0x20
        List                      = ...  # 0x21
        ListItem                  = ...  # 0x22
        Tree                      = ...  # 0x23
        TreeItem                  = ...  # 0x24
        PageTab                   = ...  # 0x25
        PropertyPage              = ...  # 0x26
        Indicator                 = ...  # 0x27
        Graphic                   = ...  # 0x28
        StaticText                = ...  # 0x29
        EditableText              = ...  # 0x2a
        Button                    = ...  # 0x2b
        PushButton                = ...  # 0x2b
        CheckBox                  = ...  # 0x2c
        RadioButton               = ...  # 0x2d
        ComboBox                  = ...  # 0x2e
        ProgressBar               = ...  # 0x30
        Dial                      = ...  # 0x31
        HotkeyField               = ...  # 0x32
        Slider                    = ...  # 0x33
        SpinBox                   = ...  # 0x34
        Canvas                    = ...  # 0x35
        Animation                 = ...  # 0x36
        Equation                  = ...  # 0x37
        ButtonDropDown            = ...  # 0x38
        ButtonMenu                = ...  # 0x39
        ButtonDropGrid            = ...  # 0x3a
        Whitespace                = ...  # 0x3b
        PageTabList               = ...  # 0x3c
        Clock                     = ...  # 0x3d
        Splitter                  = ...  # 0x3e
        LayeredPane               = ...  # 0x80
        Terminal                  = ...  # 0x81
        Desktop                   = ...  # 0x82
        Paragraph                 = ...  # 0x83
        WebDocument               = ...  # 0x84
        Section                   = ...  # 0x85
        Notification              = ...  # 0x86
        ColorChooser              = ...  # 0x404
        Footer                    = ...  # 0x40e
        Form                      = ...  # 0x410
        Heading                   = ...  # 0x414
        Note                      = ...  # 0x41b
        ComplementaryContent      = ...  # 0x42c
        UserRole                  = ...  # 0xffff

    class State(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, State: PySide6.QtGui.QAccessible.State) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class Text(enum.Enum):

        Name                      = ...  # 0x0
        Description               = ...  # 0x1
        Value                     = ...  # 0x2
        Help                      = ...  # 0x3
        Accelerator               = ...  # 0x4
        DebugDescription          = ...  # 0x5
        Identifier                = ...  # 0x6
        UserText                  = ...  # 0xffff

    class TextBoundaryType(enum.Enum):

        CharBoundary              = ...  # 0x0
        WordBoundary              = ...  # 0x1
        SentenceBoundary          = ...  # 0x2
        ParagraphBoundary         = ...  # 0x3
        LineBoundary              = ...  # 0x4
        NoBoundary                = ...  # 0x5


    def __init__(self, QAccessible: PySide6.QtGui.QAccessible) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def accessibleInterface(uniqueId: int) -> PySide6.QtGui.QAccessibleInterface: ...
    @staticmethod
    def cleanup() -> None: ...
    @staticmethod
    def deleteAccessibleInterface(uniqueId: int) -> None: ...
    @staticmethod
    def installFactory(arg__1: typing.Callable) -> None: ...
    @staticmethod
    def isActive() -> bool: ...
    @staticmethod
    def qAccessibleTextBoundaryHelper(cursor: PySide6.QtGui.QTextCursor, boundaryType: PySide6.QtGui.QAccessible.TextBoundaryType) -> typing.Tuple[int, int]: ...
    @staticmethod
    def queryAccessibleInterface(arg__1: PySide6.QtCore.QObject) -> PySide6.QtGui.QAccessibleInterface: ...
    @staticmethod
    def registerAccessibleInterface(iface: PySide6.QtGui.QAccessibleInterface) -> int: ...
    @staticmethod
    def setActive(active: bool) -> None: ...
    @staticmethod
    def setRootObject(object: PySide6.QtCore.QObject) -> None: ...
    @staticmethod
    def uniqueId(iface: PySide6.QtGui.QAccessibleInterface) -> int: ...
    @staticmethod
    def updateAccessibility(event: PySide6.QtGui.QAccessibleEvent) -> None: ...


class State(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, State: PySide6.QtGui.QAccessible.State) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QAccessibleActionInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def actionNames(self) -> typing.List[str]: ...
    @staticmethod
    def decreaseAction() -> str: ...
    def doAction(self, actionName: str) -> None: ...
    @staticmethod
    def increaseAction() -> str: ...
    def keyBindingsForAction(self, actionName: str) -> typing.List[str]: ...
    def localizedActionDescription(self, name: str) -> str: ...
    def localizedActionName(self, name: str) -> str: ...
    @staticmethod
    def nextPageAction() -> str: ...
    @staticmethod
    def pressAction() -> str: ...
    @staticmethod
    def previousPageAction() -> str: ...
    @staticmethod
    def scrollDownAction() -> str: ...
    @staticmethod
    def scrollLeftAction() -> str: ...
    @staticmethod
    def scrollRightAction() -> str: ...
    @staticmethod
    def scrollUpAction() -> str: ...
    @staticmethod
    def setFocusAction() -> str: ...
    @staticmethod
    def showMenuAction() -> str: ...
    @staticmethod
    def toggleAction() -> str: ...


class QAccessibleAnnouncementEvent(PySide6.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, message: str) -> None: ...
    @typing.overload
    def __init__(self, object: PySide6.QtCore.QObject, message: str) -> None: ...

    def message(self) -> str: ...
    def politeness(self) -> PySide6.QtGui.QAccessible.AnnouncementPoliteness: ...
    def setPoliteness(self, politeness: PySide6.QtGui.QAccessible.AnnouncementPoliteness) -> None: ...


class QAccessibleAttributesInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def attributeKeys(self) -> typing.List[PySide6.QtGui.QAccessible.Attribute]: ...
    def attributeValue(self, key: PySide6.QtGui.QAccessible.Attribute) -> typing.Any: ...


class QAccessibleEditableTextInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def deleteText(self, startOffset: int, endOffset: int) -> None: ...
    def insertText(self, offset: int, text: str) -> None: ...
    def replaceText(self, startOffset: int, endOffset: int, text: str) -> None: ...


class QAccessibleEvent(Shiboken.Object):

    @typing.overload
    def __init__(self, obj: PySide6.QtCore.QObject, typ: PySide6.QtGui.QAccessible.Event) -> None: ...
    @typing.overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, typ: PySide6.QtGui.QAccessible.Event) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def accessibleInterface(self) -> PySide6.QtGui.QAccessibleInterface: ...
    def child(self) -> int: ...
    def object(self) -> PySide6.QtCore.QObject: ...
    def setChild(self, chld: int) -> None: ...
    def type(self) -> PySide6.QtGui.QAccessible.Event: ...
    def uniqueId(self) -> int: ...


class QAccessibleInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def actionInterface(self) -> PySide6.QtGui.QAccessibleActionInterface: ...
    def attributesInterface(self) -> PySide6.QtGui.QAccessibleAttributesInterface: ...
    def backgroundColor(self) -> PySide6.QtGui.QColor: ...
    def child(self, index: int) -> PySide6.QtGui.QAccessibleInterface: ...
    def childAt(self, x: int, y: int) -> PySide6.QtGui.QAccessibleInterface: ...
    def childCount(self) -> int: ...
    def editableTextInterface(self) -> PySide6.QtGui.QAccessibleEditableTextInterface: ...
    def focusChild(self) -> PySide6.QtGui.QAccessibleInterface: ...
    def foregroundColor(self) -> PySide6.QtGui.QColor: ...
    def indexOfChild(self, arg__1: PySide6.QtGui.QAccessibleInterface) -> int: ...
    def interface_cast(self, arg__1: PySide6.QtGui.QAccessible.InterfaceType) -> int: ...
    def isValid(self) -> bool: ...
    def object(self) -> PySide6.QtCore.QObject: ...
    def parent(self) -> PySide6.QtGui.QAccessibleInterface: ...
    def rect(self) -> PySide6.QtCore.QRect: ...
    def relations(self, match: PySide6.QtGui.QAccessible.RelationFlag = ...) -> typing.List[typing.Tuple[PySide6.QtGui.QAccessibleInterface, PySide6.QtGui.QAccessible.RelationFlag]]: ...
    def role(self) -> PySide6.QtGui.QAccessible.Role: ...
    def selectionInterface(self) -> PySide6.QtGui.QAccessibleSelectionInterface: ...
    def setText(self, t: PySide6.QtGui.QAccessible.Text, text: str) -> None: ...
    def state(self) -> PySide6.QtGui.QAccessible.State: ...
    def tableCellInterface(self) -> PySide6.QtGui.QAccessibleTableCellInterface: ...
    def text(self, t: PySide6.QtGui.QAccessible.Text) -> str: ...
    def textInterface(self) -> PySide6.QtGui.QAccessibleTextInterface: ...
    def valueInterface(self) -> PySide6.QtGui.QAccessibleValueInterface: ...
    def virtual_hook(self, id: int, data: int) -> None: ...
    def window(self) -> PySide6.QtGui.QWindow: ...


class QAccessibleObject(PySide6.QtGui.QAccessibleInterface):

    def __init__(self, object: PySide6.QtCore.QObject) -> None: ...

    def childAt(self, x: int, y: int) -> PySide6.QtGui.QAccessibleInterface: ...
    def isValid(self) -> bool: ...
    def object(self) -> PySide6.QtCore.QObject: ...
    def rect(self) -> PySide6.QtCore.QRect: ...
    def setText(self, t: PySide6.QtGui.QAccessible.Text, text: str) -> None: ...


class QAccessibleSelectionInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def clear(self) -> bool: ...
    def isSelected(self, childItem: PySide6.QtGui.QAccessibleInterface) -> bool: ...
    def select(self, childItem: PySide6.QtGui.QAccessibleInterface) -> bool: ...
    def selectAll(self) -> bool: ...
    def selectedItem(self, selectionIndex: int) -> PySide6.QtGui.QAccessibleInterface: ...
    def selectedItemCount(self) -> int: ...
    def selectedItems(self) -> typing.List[PySide6.QtGui.QAccessibleInterface]: ...
    def unselect(self, childItem: PySide6.QtGui.QAccessibleInterface) -> bool: ...


class QAccessibleStateChangeEvent(PySide6.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, state: PySide6.QtGui.QAccessible.State) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide6.QtCore.QObject, state: PySide6.QtGui.QAccessible.State) -> None: ...

    def changedStates(self) -> PySide6.QtGui.QAccessible.State: ...


class QAccessibleTableCellInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def columnExtent(self) -> int: ...
    def columnHeaderCells(self) -> typing.List[PySide6.QtGui.QAccessibleInterface]: ...
    def columnIndex(self) -> int: ...
    def isSelected(self) -> bool: ...
    def rowExtent(self) -> int: ...
    def rowHeaderCells(self) -> typing.List[PySide6.QtGui.QAccessibleInterface]: ...
    def rowIndex(self) -> int: ...
    def table(self) -> PySide6.QtGui.QAccessibleInterface: ...


class QAccessibleTableModelChangeEvent(PySide6.QtGui.QAccessibleEvent):

    class ModelChangeType(enum.Enum):

        ModelReset                = ...  # 0x0
        DataChanged               = ...  # 0x1
        RowsInserted              = ...  # 0x2
        ColumnsInserted           = ...  # 0x3
        RowsRemoved               = ...  # 0x4
        ColumnsRemoved            = ...  # 0x5


    @typing.overload
    def __init__(self, obj: PySide6.QtCore.QObject, changeType: PySide6.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...
    @typing.overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, changeType: PySide6.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...

    def firstColumn(self) -> int: ...
    def firstRow(self) -> int: ...
    def lastColumn(self) -> int: ...
    def lastRow(self) -> int: ...
    def modelChangeType(self) -> PySide6.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType: ...
    def setFirstColumn(self, col: int) -> None: ...
    def setFirstRow(self, row: int) -> None: ...
    def setLastColumn(self, col: int) -> None: ...
    def setLastRow(self, row: int) -> None: ...
    def setModelChangeType(self, changeType: PySide6.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...


class QAccessibleTextCursorEvent(PySide6.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, obj: PySide6.QtCore.QObject, cursorPos: int) -> None: ...
    @typing.overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, cursorPos: int) -> None: ...

    def cursorPosition(self) -> int: ...
    def setCursorPosition(self, position: int) -> None: ...


class QAccessibleTextInsertEvent(PySide6.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, position: int, text: str) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide6.QtCore.QObject, position: int, text: str) -> None: ...

    def changePosition(self) -> int: ...
    def textInserted(self) -> str: ...


class QAccessibleTextInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def addSelection(self, startOffset: int, endOffset: int) -> None: ...
    def attributes(self, offset: int) -> typing.Tuple[str, int, int]: ...
    def characterCount(self) -> int: ...
    def characterRect(self, offset: int) -> PySide6.QtCore.QRect: ...
    def cursorPosition(self) -> int: ...
    def offsetAtPoint(self, point: PySide6.QtCore.QPoint) -> int: ...
    def removeSelection(self, selectionIndex: int) -> None: ...
    def scrollToSubstring(self, startIndex: int, endIndex: int) -> None: ...
    def selection(self, selectionIndex: int) -> typing.Tuple[int, int]: ...
    def selectionCount(self) -> int: ...
    def setCursorPosition(self, position: int) -> None: ...
    def setSelection(self, selectionIndex: int, startOffset: int, endOffset: int) -> None: ...
    def text(self, startOffset: int, endOffset: int) -> str: ...
    def textAfterOffset(self, offset: int, boundaryType: PySide6.QtGui.QAccessible.TextBoundaryType) -> typing.Tuple[str, int, int]: ...
    def textAtOffset(self, offset: int, boundaryType: PySide6.QtGui.QAccessible.TextBoundaryType) -> typing.Tuple[str, int, int]: ...
    def textBeforeOffset(self, offset: int, boundaryType: PySide6.QtGui.QAccessible.TextBoundaryType) -> typing.Tuple[str, int, int]: ...


class QAccessibleTextRemoveEvent(PySide6.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, position: int, text: str) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide6.QtCore.QObject, position: int, text: str) -> None: ...

    def changePosition(self) -> int: ...
    def textRemoved(self) -> str: ...


class QAccessibleTextSelectionEvent(PySide6.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, start: int, end: int) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide6.QtCore.QObject, start: int, end: int) -> None: ...

    def selectionEnd(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setSelection(self, start: int, end: int) -> None: ...


class QAccessibleTextUpdateEvent(PySide6.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, position: int, oldText: str, text: str) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide6.QtCore.QObject, position: int, oldText: str, text: str) -> None: ...

    def changePosition(self) -> int: ...
    def textInserted(self) -> str: ...
    def textRemoved(self) -> str: ...


class QAccessibleValueChangeEvent(PySide6.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface: PySide6.QtGui.QAccessibleInterface, val: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, obj: PySide6.QtCore.QObject, val: typing.Any) -> None: ...

    def setValue(self, val: typing.Any) -> None: ...
    def value(self) -> typing.Any: ...


class QAccessibleValueInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def currentValue(self) -> typing.Any: ...
    def maximumValue(self) -> typing.Any: ...
    def minimumStepSize(self) -> typing.Any: ...
    def minimumValue(self) -> typing.Any: ...
    def setCurrentValue(self, value: typing.Any) -> None: ...


class QAction(PySide6.QtCore.QObject):

    changed                  : typing.ClassVar[Signal] = ... # changed()
    checkableChanged         : typing.ClassVar[Signal] = ... # checkableChanged(bool)
    enabledChanged           : typing.ClassVar[Signal] = ... # enabledChanged(bool)
    hovered                  : typing.ClassVar[Signal] = ... # hovered()
    toggled                  : typing.ClassVar[Signal] = ... # toggled(bool)
    triggered                : typing.ClassVar[Signal] = ... # triggered(); triggered(bool)
    visibleChanged           : typing.ClassVar[Signal] = ... # visibleChanged()

    class ActionEvent(enum.Enum):

        Trigger                   = ...  # 0x0
        Hover                     = ...  # 0x1

    class MenuRole(enum.Enum):

        NoRole                    = ...  # 0x0
        TextHeuristicRole         = ...  # 0x1
        ApplicationSpecificRole   = ...  # 0x2
        AboutQtRole               = ...  # 0x3
        AboutRole                 = ...  # 0x4
        PreferencesRole           = ...  # 0x5
        QuitRole                  = ...  # 0x6

    class Priority(enum.Enum):

        LowPriority               = ...  # 0x0
        NormalPriority            = ...  # 0x80
        HighPriority              = ...  # 0x100


    @typing.overload
    def __init__(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, parent: PySide6.QtCore.QObject | None= ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def actionGroup(self) -> PySide6.QtGui.QActionGroup: ...
    def activate(self, event: PySide6.QtGui.QAction.ActionEvent) -> None: ...
    def associatedObjects(self) -> typing.List[PySide6.QtCore.QObject]: ...
    def autoRepeat(self) -> bool: ...
    def data(self) -> typing.Any: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def hover(self) -> None: ...
    def icon(self) -> PySide6.QtGui.QIcon: ...
    def iconText(self) -> str: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isIconVisibleInMenu(self) -> bool: ...
    def isSeparator(self) -> bool: ...
    def isShortcutVisibleInContextMenu(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def menu(self) -> PySide6.QtCore.QObject: ...
    def menuRole(self) -> PySide6.QtGui.QAction.MenuRole: ...
    def priority(self) -> PySide6.QtGui.QAction.Priority: ...
    def resetEnabled(self) -> None: ...
    def setActionGroup(self, group: PySide6.QtGui.QActionGroup) -> None: ...
    def setAutoRepeat(self, arg__1: bool) -> None: ...
    def setCheckable(self, arg__1: bool) -> None: ...
    def setChecked(self, arg__1: bool) -> None: ...
    def setData(self, var: typing.Any) -> None: ...
    def setDisabled(self, b: bool) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setFont(self, font: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> None: ...
    def setIcon(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap) -> None: ...
    def setIconText(self, text: str) -> None: ...
    def setIconVisibleInMenu(self, visible: bool) -> None: ...
    def setMenu(self, arg__1: PySide6.QtCore.QObject) -> None: ...
    def setMenuRole(self, menuRole: PySide6.QtGui.QAction.MenuRole) -> None: ...
    def setPriority(self, priority: PySide6.QtGui.QAction.Priority) -> None: ...
    def setSeparator(self, b: bool) -> None: ...
    @typing.overload
    def setShortcut(self, arg__1: PySide6.QtCore.Qt.Key) -> None: ...
    @typing.overload
    def setShortcut(self, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int) -> None: ...
    def setShortcutContext(self, context: PySide6.QtCore.Qt.ShortcutContext) -> None: ...
    def setShortcutVisibleInContextMenu(self, show: bool) -> None: ...
    @typing.overload
    def setShortcuts(self, arg__1: PySide6.QtGui.QKeySequence.StandardKey) -> None: ...
    @typing.overload
    def setShortcuts(self, shortcuts: typing.Sequence[PySide6.QtGui.QKeySequence]) -> None: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def setToolTip(self, tip: str) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...
    def setWhatsThis(self, what: str) -> None: ...
    def shortcut(self) -> PySide6.QtGui.QKeySequence: ...
    def shortcutContext(self) -> PySide6.QtCore.Qt.ShortcutContext: ...
    def shortcuts(self) -> typing.List[PySide6.QtGui.QKeySequence]: ...
    def showStatusText(self, object: PySide6.QtCore.QObject | None= ...) -> bool: ...
    def statusTip(self) -> str: ...
    def text(self) -> str: ...
    def toggle(self) -> None: ...
    def toolTip(self) -> str: ...
    def trigger(self) -> None: ...
    def whatsThis(self) -> str: ...


class QActionEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, type: int, action: PySide6.QtGui.QAction, before: PySide6.QtGui.QAction | None= ...) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QActionEvent) -> None: ...

    def action(self) -> PySide6.QtGui.QAction: ...
    def before(self) -> PySide6.QtGui.QAction: ...
    def clone(self) -> PySide6.QtGui.QActionEvent: ...


class QActionGroup(PySide6.QtCore.QObject):

    hovered                  : typing.ClassVar[Signal] = ... # hovered(QAction*)
    triggered                : typing.ClassVar[Signal] = ... # triggered(QAction*)

    class ExclusionPolicy(enum.Enum):

        None_                     = ...  # 0x0
        Exclusive                 = ...  # 0x1
        ExclusiveOptional         = ...  # 0x2


    def __init__(self, parent: PySide6.QtCore.QObject) -> None: ...

    def actions(self) -> typing.List[PySide6.QtGui.QAction]: ...
    @typing.overload
    def addAction(self, text: str) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, a: PySide6.QtGui.QAction) -> PySide6.QtGui.QAction: ...
    def checkedAction(self) -> PySide6.QtGui.QAction: ...
    def exclusionPolicy(self) -> PySide6.QtGui.QActionGroup.ExclusionPolicy: ...
    def isEnabled(self) -> bool: ...
    def isExclusive(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def removeAction(self, a: PySide6.QtGui.QAction) -> None: ...
    def setDisabled(self, b: bool) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setExclusionPolicy(self, policy: PySide6.QtGui.QActionGroup.ExclusionPolicy) -> None: ...
    def setExclusive(self, arg__1: bool) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...


class QBackingStore(Shiboken.Object):

    def __init__(self, window: PySide6.QtGui.QWindow) -> None: ...

    def beginPaint(self, arg__1: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> None: ...
    def endPaint(self) -> None: ...
    def flush(self, region: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect, window: PySide6.QtGui.QWindow | None= ..., offset: PySide6.QtCore.QPoint = ...) -> None: ...
    def hasStaticContents(self) -> bool: ...
    def paintDevice(self) -> PySide6.QtGui.QPaintDevice: ...
    def resize(self, size: PySide6.QtCore.QSize) -> None: ...
    def scroll(self, area: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect, dx: int, dy: int) -> bool: ...
    def setStaticContents(self, region: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def staticContents(self) -> PySide6.QtGui.QRegion: ...
    def window(self) -> PySide6.QtGui.QWindow: ...


class QBitmap(PySide6.QtGui.QPixmap):

    @typing.overload
    def __init__(self, fileName: str, format: bytes | bytearray | memoryview | None= ...) -> None: ...
    @typing.overload
    def __init__(self, w: int, h: int) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, QBitmap: PySide6.QtGui.QBitmap) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def clear(self) -> None: ...
    @staticmethod
    def fromData(size: PySide6.QtCore.QSize, bits: bytes | bytearray | memoryview, monoFormat: PySide6.QtGui.QImage.Format = ...) -> PySide6.QtGui.QBitmap: ...
    @staticmethod
    def fromImage(image: PySide6.QtGui.QImage, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QBitmap: ...
    @staticmethod
    def fromPixmap(pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> PySide6.QtGui.QBitmap: ...
    def swap(self, other: PySide6.QtGui.QBitmap | str) -> None: ...
    def transformed(self, matrix: PySide6.QtGui.QTransform) -> PySide6.QtGui.QBitmap: ...


class QBrush(Shiboken.Object):

    @typing.overload
    def __init__(self, bs: PySide6.QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def __init__(self, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, bs: PySide6.QtCore.Qt.BrushStyle = ...) -> None: ...
    @typing.overload
    def __init__(self, image: PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, brush: PySide6.QtGui.QBrush) -> None: ...
    @typing.overload
    def __init__(self, color: PySide6.QtCore.Qt.GlobalColor, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, color: PySide6.QtCore.Qt.GlobalColor, bs: PySide6.QtCore.Qt.BrushStyle = ...) -> None: ...
    @typing.overload
    def __init__(self, gradient: PySide6.QtGui.QGradient | PySide6.QtGui.QGradient.Preset) -> None: ...
    @typing.overload
    def __init__(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def color(self) -> PySide6.QtGui.QColor: ...
    def gradient(self) -> PySide6.QtGui.QGradient: ...
    def isOpaque(self) -> bool: ...
    @typing.overload
    def setColor(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    @typing.overload
    def setColor(self, color: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    def setStyle(self, arg__1: PySide6.QtCore.Qt.BrushStyle) -> None: ...
    def setTexture(self, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...
    def setTextureImage(self, image: PySide6.QtGui.QImage) -> None: ...
    def setTransform(self, arg__1: PySide6.QtGui.QTransform) -> None: ...
    def style(self) -> PySide6.QtCore.Qt.BrushStyle: ...
    def swap(self, other: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def texture(self) -> PySide6.QtGui.QPixmap: ...
    def textureImage(self) -> PySide6.QtGui.QImage: ...
    def transform(self) -> PySide6.QtGui.QTransform: ...


class QChildWindowEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QChildWindowEvent) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, childWindow: PySide6.QtGui.QWindow) -> None: ...

    def child(self) -> PySide6.QtGui.QWindow: ...
    def clone(self) -> PySide6.QtGui.QChildWindowEvent: ...


class QClipboard(PySide6.QtCore.QObject):

    changed                  : typing.ClassVar[Signal] = ... # changed(QClipboard::Mode)
    dataChanged              : typing.ClassVar[Signal] = ... # dataChanged()
    findBufferChanged        : typing.ClassVar[Signal] = ... # findBufferChanged()
    selectionChanged         : typing.ClassVar[Signal] = ... # selectionChanged()

    class Mode(enum.Enum):

        Clipboard                 = ...  # 0x0
        Selection                 = ...  # 0x1
        FindBuffer                = ...  # 0x2
        LastMode                  = ...  # 0x2


    def clear(self, mode: PySide6.QtGui.QClipboard.Mode = ...) -> None: ...
    def image(self, mode: PySide6.QtGui.QClipboard.Mode = ...) -> PySide6.QtGui.QImage: ...
    def mimeData(self, mode: PySide6.QtGui.QClipboard.Mode = ...) -> PySide6.QtCore.QMimeData: ...
    def ownsClipboard(self) -> bool: ...
    def ownsFindBuffer(self) -> bool: ...
    def ownsSelection(self) -> bool: ...
    def pixmap(self, mode: PySide6.QtGui.QClipboard.Mode = ...) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    def setImage(self, arg__1: PySide6.QtGui.QImage, mode: PySide6.QtGui.QClipboard.Mode = ...) -> None: ...
    @typing.overload
    def setImage(self, path: str | bytes | os.PathLike[str]) -> None: ...
    def setMimeData(self, data: PySide6.QtCore.QMimeData, mode: PySide6.QtGui.QClipboard.Mode = ...) -> None: ...
    @typing.overload
    def setPixmap(self, arg__1: PySide6.QtGui.QPixmap, mode: PySide6.QtGui.QClipboard.Mode = ...) -> None: ...
    @typing.overload
    def setPixmap(self, path: str | bytes | os.PathLike[str]) -> None: ...
    def setText(self, arg__1: str, mode: PySide6.QtGui.QClipboard.Mode = ...) -> None: ...
    def supportsFindBuffer(self) -> bool: ...
    def supportsSelection(self) -> bool: ...
    @typing.overload
    def text(self, subtype: str, mode: PySide6.QtGui.QClipboard.Mode = ...) -> typing.Tuple[str, PySide6.QtGui.QClipboard.Mode]: ...
    @typing.overload
    def text(self, mode: PySide6.QtGui.QClipboard.Mode = ...) -> str: ...


class QCloseEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QCloseEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QCloseEvent: ...


class QColor(Shiboken.Object):

    class NameFormat(enum.Enum):

        HexRgb                    = ...  # 0x0
        HexArgb                   = ...  # 0x1

    class Spec(enum.Enum):

        Invalid                   = ...  # 0x0
        Rgb                       = ...  # 0x1
        Hsv                       = ...  # 0x2
        Cmyk                      = ...  # 0x3
        Hsl                       = ...  # 0x4
        ExtendedRgb               = ...  # 0x5


    @typing.overload
    def __init__(self, spec: PySide6.QtGui.QColor.Spec, a1: int, a2: int, a3: int, a4: int, a5: int = ...) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Any) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name: str) -> None: ...
    @typing.overload
    def __init__(self, rgba64: PySide6.QtGui.QRgba64) -> None: ...
    @typing.overload
    def __init__(self, r: int, g: int, b: int, a: int = ...) -> None: ...
    @typing.overload
    def __init__(self, color: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def __init__(self, rgb: int) -> None: ...
    @typing.overload
    def __init__(self, QColor: PySide6.QtGui.QColor) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __setstate__(self, arg__1: object) -> object: ...
    def __str__(self) -> str: ...
    def alpha(self) -> int: ...
    def alphaF(self) -> float: ...
    def black(self) -> int: ...
    def blackF(self) -> float: ...
    def blue(self) -> int: ...
    def blueF(self) -> float: ...
    @staticmethod
    def colorNames() -> typing.List[str]: ...
    def convertTo(self, colorSpec: PySide6.QtGui.QColor.Spec) -> PySide6.QtGui.QColor: ...
    def cyan(self) -> int: ...
    def cyanF(self) -> float: ...
    def darker(self, f: int = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromCmyk(c: int, m: int, y: int, k: int, a: int = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromCmykF(c: float, m: float, y: float, k: float, a: float = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromHsl(h: int, s: int, l: int, a: int = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromHslF(h: float, s: float, l: float, a: float = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromHsv(h: int, s: int, v: int, a: int = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromHsvF(h: float, s: float, v: float, a: float = ...) -> PySide6.QtGui.QColor: ...
    @typing.overload
    @staticmethod
    def fromRgb(rgb: int) -> PySide6.QtGui.QColor: ...
    @typing.overload
    @staticmethod
    def fromRgb(r: int, g: int, b: int, a: int = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromRgbF(r: float, g: float, b: float, a: float = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromRgba(rgba: int) -> PySide6.QtGui.QColor: ...
    @typing.overload
    @staticmethod
    def fromRgba64(rgba: PySide6.QtGui.QRgba64) -> PySide6.QtGui.QColor: ...
    @typing.overload
    @staticmethod
    def fromRgba64(r: int, g: int, b: int, a: int = ...) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def fromString(name: str) -> PySide6.QtGui.QColor: ...
    def getCmyk(self) -> object: ...
    def getCmykF(self) -> object: ...
    def getHsl(self) -> object: ...
    def getHslF(self) -> object: ...
    def getHsv(self) -> object: ...
    def getHsvF(self) -> object: ...
    def getRgb(self) -> object: ...
    def getRgbF(self) -> object: ...
    def green(self) -> int: ...
    def greenF(self) -> float: ...
    def hslHue(self) -> int: ...
    def hslHueF(self) -> float: ...
    def hslSaturation(self) -> int: ...
    def hslSaturationF(self) -> float: ...
    def hsvHue(self) -> int: ...
    def hsvHueF(self) -> float: ...
    def hsvSaturation(self) -> int: ...
    def hsvSaturationF(self) -> float: ...
    def hue(self) -> int: ...
    def hueF(self) -> float: ...
    def isValid(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isValidColor(arg__1: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isValidColor(name: str) -> bool: ...
    @staticmethod
    def isValidColorName(arg__1: str) -> bool: ...
    def lighter(self, f: int = ...) -> PySide6.QtGui.QColor: ...
    def lightness(self) -> int: ...
    def lightnessF(self) -> float: ...
    def magenta(self) -> int: ...
    def magentaF(self) -> float: ...
    def name(self, format: PySide6.QtGui.QColor.NameFormat = ...) -> str: ...
    def red(self) -> int: ...
    def redF(self) -> float: ...
    def rgb(self) -> int: ...
    def rgba(self) -> int: ...
    def rgba64(self) -> PySide6.QtGui.QRgba64: ...
    def saturation(self) -> int: ...
    def saturationF(self) -> float: ...
    def setAlpha(self, alpha: int) -> None: ...
    def setAlphaF(self, alpha: float) -> None: ...
    def setBlue(self, blue: int) -> None: ...
    def setBlueF(self, blue: float) -> None: ...
    def setCmyk(self, c: int, m: int, y: int, k: int, a: int = ...) -> None: ...
    def setCmykF(self, c: float, m: float, y: float, k: float, a: float = ...) -> None: ...
    def setGreen(self, green: int) -> None: ...
    def setGreenF(self, green: float) -> None: ...
    def setHsl(self, h: int, s: int, l: int, a: int = ...) -> None: ...
    def setHslF(self, h: float, s: float, l: float, a: float = ...) -> None: ...
    def setHsv(self, h: int, s: int, v: int, a: int = ...) -> None: ...
    def setHsvF(self, h: float, s: float, v: float, a: float = ...) -> None: ...
    def setNamedColor(self, name: str) -> None: ...
    def setRed(self, red: int) -> None: ...
    def setRedF(self, red: float) -> None: ...
    @typing.overload
    def setRgb(self, rgb: int) -> None: ...
    @typing.overload
    def setRgb(self, r: int, g: int, b: int, a: int = ...) -> None: ...
    def setRgbF(self, r: float, g: float, b: float, a: float = ...) -> None: ...
    def setRgba(self, rgba: int) -> None: ...
    def setRgba64(self, rgba: PySide6.QtGui.QRgba64) -> None: ...
    def spec(self) -> PySide6.QtGui.QColor.Spec: ...
    def toCmyk(self) -> PySide6.QtGui.QColor: ...
    def toExtendedRgb(self) -> PySide6.QtGui.QColor: ...
    def toHsl(self) -> PySide6.QtGui.QColor: ...
    def toHsv(self) -> PySide6.QtGui.QColor: ...
    def toRgb(self) -> PySide6.QtGui.QColor: ...
    def toTuple(self) -> object: ...
    def value(self) -> int: ...
    def valueF(self) -> float: ...
    def yellow(self) -> int: ...
    def yellowF(self) -> float: ...


class QColorConstants(Shiboken.Object):

    Black                     = ...  # type: PySide6.QtGui.QColor
    Blue                      = ...  # type: PySide6.QtGui.QColor
    Color0                    = ...  # type: PySide6.QtGui.QColor
    Color1                    = ...  # type: PySide6.QtGui.QColor
    Cyan                      = ...  # type: PySide6.QtGui.QColor
    DarkBlue                  = ...  # type: PySide6.QtGui.QColor
    DarkCyan                  = ...  # type: PySide6.QtGui.QColor
    DarkGray                  = ...  # type: PySide6.QtGui.QColor
    DarkGreen                 = ...  # type: PySide6.QtGui.QColor
    DarkMagenta               = ...  # type: PySide6.QtGui.QColor
    DarkRed                   = ...  # type: PySide6.QtGui.QColor
    DarkYellow                = ...  # type: PySide6.QtGui.QColor
    Gray                      = ...  # type: PySide6.QtGui.QColor
    Green                     = ...  # type: PySide6.QtGui.QColor
    LightGray                 = ...  # type: PySide6.QtGui.QColor
    Magenta                   = ...  # type: PySide6.QtGui.QColor
    Red                       = ...  # type: PySide6.QtGui.QColor
    Transparent               = ...  # type: PySide6.QtGui.QColor
    White                     = ...  # type: PySide6.QtGui.QColor
    Yellow                    = ...  # type: PySide6.QtGui.QColor

    class Svg(Shiboken.Object):

        aliceblue                 = ...  # type: PySide6.QtGui.QColor
        antiquewhite              = ...  # type: PySide6.QtGui.QColor
        aqua                      = ...  # type: PySide6.QtGui.QColor
        aquamarine                = ...  # type: PySide6.QtGui.QColor
        azure                     = ...  # type: PySide6.QtGui.QColor
        beige                     = ...  # type: PySide6.QtGui.QColor
        bisque                    = ...  # type: PySide6.QtGui.QColor
        black                     = ...  # type: PySide6.QtGui.QColor
        blanchedalmond            = ...  # type: PySide6.QtGui.QColor
        blue                      = ...  # type: PySide6.QtGui.QColor
        blueviolet                = ...  # type: PySide6.QtGui.QColor
        brown                     = ...  # type: PySide6.QtGui.QColor
        burlywood                 = ...  # type: PySide6.QtGui.QColor
        cadetblue                 = ...  # type: PySide6.QtGui.QColor
        chartreuse                = ...  # type: PySide6.QtGui.QColor
        chocolate                 = ...  # type: PySide6.QtGui.QColor
        coral                     = ...  # type: PySide6.QtGui.QColor
        cornflowerblue            = ...  # type: PySide6.QtGui.QColor
        cornsilk                  = ...  # type: PySide6.QtGui.QColor
        crimson                   = ...  # type: PySide6.QtGui.QColor
        cyan                      = ...  # type: PySide6.QtGui.QColor
        darkblue                  = ...  # type: PySide6.QtGui.QColor
        darkcyan                  = ...  # type: PySide6.QtGui.QColor
        darkgoldenrod             = ...  # type: PySide6.QtGui.QColor
        darkgray                  = ...  # type: PySide6.QtGui.QColor
        darkgreen                 = ...  # type: PySide6.QtGui.QColor
        darkgrey                  = ...  # type: PySide6.QtGui.QColor
        darkkhaki                 = ...  # type: PySide6.QtGui.QColor
        darkmagenta               = ...  # type: PySide6.QtGui.QColor
        darkolivegreen            = ...  # type: PySide6.QtGui.QColor
        darkorange                = ...  # type: PySide6.QtGui.QColor
        darkorchid                = ...  # type: PySide6.QtGui.QColor
        darkred                   = ...  # type: PySide6.QtGui.QColor
        darksalmon                = ...  # type: PySide6.QtGui.QColor
        darkseagreen              = ...  # type: PySide6.QtGui.QColor
        darkslateblue             = ...  # type: PySide6.QtGui.QColor
        darkslategray             = ...  # type: PySide6.QtGui.QColor
        darkslategrey             = ...  # type: PySide6.QtGui.QColor
        darkturquoise             = ...  # type: PySide6.QtGui.QColor
        darkviolet                = ...  # type: PySide6.QtGui.QColor
        deeppink                  = ...  # type: PySide6.QtGui.QColor
        deepskyblue               = ...  # type: PySide6.QtGui.QColor
        dimgray                   = ...  # type: PySide6.QtGui.QColor
        dimgrey                   = ...  # type: PySide6.QtGui.QColor
        dodgerblue                = ...  # type: PySide6.QtGui.QColor
        firebrick                 = ...  # type: PySide6.QtGui.QColor
        floralwhite               = ...  # type: PySide6.QtGui.QColor
        forestgreen               = ...  # type: PySide6.QtGui.QColor
        fuchsia                   = ...  # type: PySide6.QtGui.QColor
        gainsboro                 = ...  # type: PySide6.QtGui.QColor
        ghostwhite                = ...  # type: PySide6.QtGui.QColor
        gold                      = ...  # type: PySide6.QtGui.QColor
        goldenrod                 = ...  # type: PySide6.QtGui.QColor
        gray                      = ...  # type: PySide6.QtGui.QColor
        green                     = ...  # type: PySide6.QtGui.QColor
        greenyellow               = ...  # type: PySide6.QtGui.QColor
        grey                      = ...  # type: PySide6.QtGui.QColor
        honeydew                  = ...  # type: PySide6.QtGui.QColor
        hotpink                   = ...  # type: PySide6.QtGui.QColor
        indianred                 = ...  # type: PySide6.QtGui.QColor
        indigo                    = ...  # type: PySide6.QtGui.QColor
        ivory                     = ...  # type: PySide6.QtGui.QColor
        khaki                     = ...  # type: PySide6.QtGui.QColor
        lavender                  = ...  # type: PySide6.QtGui.QColor
        lavenderblush             = ...  # type: PySide6.QtGui.QColor
        lawngreen                 = ...  # type: PySide6.QtGui.QColor
        lemonchiffon              = ...  # type: PySide6.QtGui.QColor
        lightblue                 = ...  # type: PySide6.QtGui.QColor
        lightcoral                = ...  # type: PySide6.QtGui.QColor
        lightcyan                 = ...  # type: PySide6.QtGui.QColor
        lightgoldenrodyellow      = ...  # type: PySide6.QtGui.QColor
        lightgray                 = ...  # type: PySide6.QtGui.QColor
        lightgreen                = ...  # type: PySide6.QtGui.QColor
        lightgrey                 = ...  # type: PySide6.QtGui.QColor
        lightpink                 = ...  # type: PySide6.QtGui.QColor
        lightsalmon               = ...  # type: PySide6.QtGui.QColor
        lightseagreen             = ...  # type: PySide6.QtGui.QColor
        lightskyblue              = ...  # type: PySide6.QtGui.QColor
        lightslategray            = ...  # type: PySide6.QtGui.QColor
        lightslategrey            = ...  # type: PySide6.QtGui.QColor
        lightsteelblue            = ...  # type: PySide6.QtGui.QColor
        lightyellow               = ...  # type: PySide6.QtGui.QColor
        lime                      = ...  # type: PySide6.QtGui.QColor
        limegreen                 = ...  # type: PySide6.QtGui.QColor
        linen                     = ...  # type: PySide6.QtGui.QColor
        magenta                   = ...  # type: PySide6.QtGui.QColor
        maroon                    = ...  # type: PySide6.QtGui.QColor
        mediumaquamarine          = ...  # type: PySide6.QtGui.QColor
        mediumblue                = ...  # type: PySide6.QtGui.QColor
        mediumorchid              = ...  # type: PySide6.QtGui.QColor
        mediumpurple              = ...  # type: PySide6.QtGui.QColor
        mediumseagreen            = ...  # type: PySide6.QtGui.QColor
        mediumslateblue           = ...  # type: PySide6.QtGui.QColor
        mediumspringgreen         = ...  # type: PySide6.QtGui.QColor
        mediumturquoise           = ...  # type: PySide6.QtGui.QColor
        mediumvioletred           = ...  # type: PySide6.QtGui.QColor
        midnightblue              = ...  # type: PySide6.QtGui.QColor
        mintcream                 = ...  # type: PySide6.QtGui.QColor
        mistyrose                 = ...  # type: PySide6.QtGui.QColor
        moccasin                  = ...  # type: PySide6.QtGui.QColor
        navajowhite               = ...  # type: PySide6.QtGui.QColor
        navy                      = ...  # type: PySide6.QtGui.QColor
        oldlace                   = ...  # type: PySide6.QtGui.QColor
        olive                     = ...  # type: PySide6.QtGui.QColor
        olivedrab                 = ...  # type: PySide6.QtGui.QColor
        orange                    = ...  # type: PySide6.QtGui.QColor
        orangered                 = ...  # type: PySide6.QtGui.QColor
        orchid                    = ...  # type: PySide6.QtGui.QColor
        palegoldenrod             = ...  # type: PySide6.QtGui.QColor
        palegreen                 = ...  # type: PySide6.QtGui.QColor
        paleturquoise             = ...  # type: PySide6.QtGui.QColor
        palevioletred             = ...  # type: PySide6.QtGui.QColor
        papayawhip                = ...  # type: PySide6.QtGui.QColor
        peachpuff                 = ...  # type: PySide6.QtGui.QColor
        peru                      = ...  # type: PySide6.QtGui.QColor
        pink                      = ...  # type: PySide6.QtGui.QColor
        plum                      = ...  # type: PySide6.QtGui.QColor
        powderblue                = ...  # type: PySide6.QtGui.QColor
        purple                    = ...  # type: PySide6.QtGui.QColor
        red                       = ...  # type: PySide6.QtGui.QColor
        rosybrown                 = ...  # type: PySide6.QtGui.QColor
        royalblue                 = ...  # type: PySide6.QtGui.QColor
        saddlebrown               = ...  # type: PySide6.QtGui.QColor
        salmon                    = ...  # type: PySide6.QtGui.QColor
        sandybrown                = ...  # type: PySide6.QtGui.QColor
        seagreen                  = ...  # type: PySide6.QtGui.QColor
        seashell                  = ...  # type: PySide6.QtGui.QColor
        sienna                    = ...  # type: PySide6.QtGui.QColor
        silver                    = ...  # type: PySide6.QtGui.QColor
        skyblue                   = ...  # type: PySide6.QtGui.QColor
        slateblue                 = ...  # type: PySide6.QtGui.QColor
        slategray                 = ...  # type: PySide6.QtGui.QColor
        slategrey                 = ...  # type: PySide6.QtGui.QColor
        snow                      = ...  # type: PySide6.QtGui.QColor
        springgreen               = ...  # type: PySide6.QtGui.QColor
        steelblue                 = ...  # type: PySide6.QtGui.QColor
        tan                       = ...  # type: PySide6.QtGui.QColor
        teal                      = ...  # type: PySide6.QtGui.QColor
        thistle                   = ...  # type: PySide6.QtGui.QColor
        tomato                    = ...  # type: PySide6.QtGui.QColor
        turquoise                 = ...  # type: PySide6.QtGui.QColor
        violet                    = ...  # type: PySide6.QtGui.QColor
        wheat                     = ...  # type: PySide6.QtGui.QColor
        white                     = ...  # type: PySide6.QtGui.QColor
        whitesmoke                = ...  # type: PySide6.QtGui.QColor
        yellow                    = ...  # type: PySide6.QtGui.QColor
        yellowgreen               = ...  # type: PySide6.QtGui.QColor


class Svg(Shiboken.Object):

    aliceblue                 = ...  # type: PySide6.QtGui.QColor
    antiquewhite              = ...  # type: PySide6.QtGui.QColor
    aqua                      = ...  # type: PySide6.QtGui.QColor
    aquamarine                = ...  # type: PySide6.QtGui.QColor
    azure                     = ...  # type: PySide6.QtGui.QColor
    beige                     = ...  # type: PySide6.QtGui.QColor
    bisque                    = ...  # type: PySide6.QtGui.QColor
    black                     = ...  # type: PySide6.QtGui.QColor
    blanchedalmond            = ...  # type: PySide6.QtGui.QColor
    blue                      = ...  # type: PySide6.QtGui.QColor
    blueviolet                = ...  # type: PySide6.QtGui.QColor
    brown                     = ...  # type: PySide6.QtGui.QColor
    burlywood                 = ...  # type: PySide6.QtGui.QColor
    cadetblue                 = ...  # type: PySide6.QtGui.QColor
    chartreuse                = ...  # type: PySide6.QtGui.QColor
    chocolate                 = ...  # type: PySide6.QtGui.QColor
    coral                     = ...  # type: PySide6.QtGui.QColor
    cornflowerblue            = ...  # type: PySide6.QtGui.QColor
    cornsilk                  = ...  # type: PySide6.QtGui.QColor
    crimson                   = ...  # type: PySide6.QtGui.QColor
    cyan                      = ...  # type: PySide6.QtGui.QColor
    darkblue                  = ...  # type: PySide6.QtGui.QColor
    darkcyan                  = ...  # type: PySide6.QtGui.QColor
    darkgoldenrod             = ...  # type: PySide6.QtGui.QColor
    darkgray                  = ...  # type: PySide6.QtGui.QColor
    darkgreen                 = ...  # type: PySide6.QtGui.QColor
    darkgrey                  = ...  # type: PySide6.QtGui.QColor
    darkkhaki                 = ...  # type: PySide6.QtGui.QColor
    darkmagenta               = ...  # type: PySide6.QtGui.QColor
    darkolivegreen            = ...  # type: PySide6.QtGui.QColor
    darkorange                = ...  # type: PySide6.QtGui.QColor
    darkorchid                = ...  # type: PySide6.QtGui.QColor
    darkred                   = ...  # type: PySide6.QtGui.QColor
    darksalmon                = ...  # type: PySide6.QtGui.QColor
    darkseagreen              = ...  # type: PySide6.QtGui.QColor
    darkslateblue             = ...  # type: PySide6.QtGui.QColor
    darkslategray             = ...  # type: PySide6.QtGui.QColor
    darkslategrey             = ...  # type: PySide6.QtGui.QColor
    darkturquoise             = ...  # type: PySide6.QtGui.QColor
    darkviolet                = ...  # type: PySide6.QtGui.QColor
    deeppink                  = ...  # type: PySide6.QtGui.QColor
    deepskyblue               = ...  # type: PySide6.QtGui.QColor
    dimgray                   = ...  # type: PySide6.QtGui.QColor
    dimgrey                   = ...  # type: PySide6.QtGui.QColor
    dodgerblue                = ...  # type: PySide6.QtGui.QColor
    firebrick                 = ...  # type: PySide6.QtGui.QColor
    floralwhite               = ...  # type: PySide6.QtGui.QColor
    forestgreen               = ...  # type: PySide6.QtGui.QColor
    fuchsia                   = ...  # type: PySide6.QtGui.QColor
    gainsboro                 = ...  # type: PySide6.QtGui.QColor
    ghostwhite                = ...  # type: PySide6.QtGui.QColor
    gold                      = ...  # type: PySide6.QtGui.QColor
    goldenrod                 = ...  # type: PySide6.QtGui.QColor
    gray                      = ...  # type: PySide6.QtGui.QColor
    green                     = ...  # type: PySide6.QtGui.QColor
    greenyellow               = ...  # type: PySide6.QtGui.QColor
    grey                      = ...  # type: PySide6.QtGui.QColor
    honeydew                  = ...  # type: PySide6.QtGui.QColor
    hotpink                   = ...  # type: PySide6.QtGui.QColor
    indianred                 = ...  # type: PySide6.QtGui.QColor
    indigo                    = ...  # type: PySide6.QtGui.QColor
    ivory                     = ...  # type: PySide6.QtGui.QColor
    khaki                     = ...  # type: PySide6.QtGui.QColor
    lavender                  = ...  # type: PySide6.QtGui.QColor
    lavenderblush             = ...  # type: PySide6.QtGui.QColor
    lawngreen                 = ...  # type: PySide6.QtGui.QColor
    lemonchiffon              = ...  # type: PySide6.QtGui.QColor
    lightblue                 = ...  # type: PySide6.QtGui.QColor
    lightcoral                = ...  # type: PySide6.QtGui.QColor
    lightcyan                 = ...  # type: PySide6.QtGui.QColor
    lightgoldenrodyellow      = ...  # type: PySide6.QtGui.QColor
    lightgray                 = ...  # type: PySide6.QtGui.QColor
    lightgreen                = ...  # type: PySide6.QtGui.QColor
    lightgrey                 = ...  # type: PySide6.QtGui.QColor
    lightpink                 = ...  # type: PySide6.QtGui.QColor
    lightsalmon               = ...  # type: PySide6.QtGui.QColor
    lightseagreen             = ...  # type: PySide6.QtGui.QColor
    lightskyblue              = ...  # type: PySide6.QtGui.QColor
    lightslategray            = ...  # type: PySide6.QtGui.QColor
    lightslategrey            = ...  # type: PySide6.QtGui.QColor
    lightsteelblue            = ...  # type: PySide6.QtGui.QColor
    lightyellow               = ...  # type: PySide6.QtGui.QColor
    lime                      = ...  # type: PySide6.QtGui.QColor
    limegreen                 = ...  # type: PySide6.QtGui.QColor
    linen                     = ...  # type: PySide6.QtGui.QColor
    magenta                   = ...  # type: PySide6.QtGui.QColor
    maroon                    = ...  # type: PySide6.QtGui.QColor
    mediumaquamarine          = ...  # type: PySide6.QtGui.QColor
    mediumblue                = ...  # type: PySide6.QtGui.QColor
    mediumorchid              = ...  # type: PySide6.QtGui.QColor
    mediumpurple              = ...  # type: PySide6.QtGui.QColor
    mediumseagreen            = ...  # type: PySide6.QtGui.QColor
    mediumslateblue           = ...  # type: PySide6.QtGui.QColor
    mediumspringgreen         = ...  # type: PySide6.QtGui.QColor
    mediumturquoise           = ...  # type: PySide6.QtGui.QColor
    mediumvioletred           = ...  # type: PySide6.QtGui.QColor
    midnightblue              = ...  # type: PySide6.QtGui.QColor
    mintcream                 = ...  # type: PySide6.QtGui.QColor
    mistyrose                 = ...  # type: PySide6.QtGui.QColor
    moccasin                  = ...  # type: PySide6.QtGui.QColor
    navajowhite               = ...  # type: PySide6.QtGui.QColor
    navy                      = ...  # type: PySide6.QtGui.QColor
    oldlace                   = ...  # type: PySide6.QtGui.QColor
    olive                     = ...  # type: PySide6.QtGui.QColor
    olivedrab                 = ...  # type: PySide6.QtGui.QColor
    orange                    = ...  # type: PySide6.QtGui.QColor
    orangered                 = ...  # type: PySide6.QtGui.QColor
    orchid                    = ...  # type: PySide6.QtGui.QColor
    palegoldenrod             = ...  # type: PySide6.QtGui.QColor
    palegreen                 = ...  # type: PySide6.QtGui.QColor
    paleturquoise             = ...  # type: PySide6.QtGui.QColor
    palevioletred             = ...  # type: PySide6.QtGui.QColor
    papayawhip                = ...  # type: PySide6.QtGui.QColor
    peachpuff                 = ...  # type: PySide6.QtGui.QColor
    peru                      = ...  # type: PySide6.QtGui.QColor
    pink                      = ...  # type: PySide6.QtGui.QColor
    plum                      = ...  # type: PySide6.QtGui.QColor
    powderblue                = ...  # type: PySide6.QtGui.QColor
    purple                    = ...  # type: PySide6.QtGui.QColor
    red                       = ...  # type: PySide6.QtGui.QColor
    rosybrown                 = ...  # type: PySide6.QtGui.QColor
    royalblue                 = ...  # type: PySide6.QtGui.QColor
    saddlebrown               = ...  # type: PySide6.QtGui.QColor
    salmon                    = ...  # type: PySide6.QtGui.QColor
    sandybrown                = ...  # type: PySide6.QtGui.QColor
    seagreen                  = ...  # type: PySide6.QtGui.QColor
    seashell                  = ...  # type: PySide6.QtGui.QColor
    sienna                    = ...  # type: PySide6.QtGui.QColor
    silver                    = ...  # type: PySide6.QtGui.QColor
    skyblue                   = ...  # type: PySide6.QtGui.QColor
    slateblue                 = ...  # type: PySide6.QtGui.QColor
    slategray                 = ...  # type: PySide6.QtGui.QColor
    slategrey                 = ...  # type: PySide6.QtGui.QColor
    snow                      = ...  # type: PySide6.QtGui.QColor
    springgreen               = ...  # type: PySide6.QtGui.QColor
    steelblue                 = ...  # type: PySide6.QtGui.QColor
    tan                       = ...  # type: PySide6.QtGui.QColor
    teal                      = ...  # type: PySide6.QtGui.QColor
    thistle                   = ...  # type: PySide6.QtGui.QColor
    tomato                    = ...  # type: PySide6.QtGui.QColor
    turquoise                 = ...  # type: PySide6.QtGui.QColor
    violet                    = ...  # type: PySide6.QtGui.QColor
    wheat                     = ...  # type: PySide6.QtGui.QColor
    white                     = ...  # type: PySide6.QtGui.QColor
    whitesmoke                = ...  # type: PySide6.QtGui.QColor
    yellow                    = ...  # type: PySide6.QtGui.QColor
    yellowgreen               = ...  # type: PySide6.QtGui.QColor


class QColorSpace(Shiboken.Object):

    class ColorModel(enum.Enum):

        Undefined                 = ...  # 0x0
        Rgb                       = ...  # 0x1
        Gray                      = ...  # 0x2
        Cmyk                      = ...  # 0x3

    class NamedColorSpace(enum.Enum):

        SRgb                      = ...  # 0x1
        SRgbLinear                = ...  # 0x2
        AdobeRgb                  = ...  # 0x3
        DisplayP3                 = ...  # 0x4
        ProPhotoRgb               = ...  # 0x5
        Bt2020                    = ...  # 0x6
        Bt2100Pq                  = ...  # 0x7
        Bt2100Hlg                 = ...  # 0x8

    class Primaries(enum.Enum):

        Custom                    = ...  # 0x0
        SRgb                      = ...  # 0x1
        AdobeRgb                  = ...  # 0x2
        DciP3D65                  = ...  # 0x3
        ProPhotoRgb               = ...  # 0x4
        Bt2020                    = ...  # 0x5

    class TransferFunction(enum.Enum):

        Custom                    = ...  # 0x0
        Linear                    = ...  # 0x1
        Gamma                     = ...  # 0x2
        SRgb                      = ...  # 0x3
        ProPhotoRgb               = ...  # 0x4
        Bt2020                    = ...  # 0x5
        St2084                    = ...  # 0x6
        Hlg                       = ...  # 0x7

    class TransformModel(enum.Enum):

        ThreeComponentMatrix      = ...  # 0x0
        ElementListProcessing     = ...  # 0x1


    @typing.overload
    def __init__(self, primaries: PySide6.QtGui.QColorSpace.Primaries, gamma: float) -> None: ...
    @typing.overload
    def __init__(self, whitePoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, redPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, greenPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, bluePoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, transferFunctionTable: typing.Sequence[int]) -> None: ...
    @typing.overload
    def __init__(self, whitePoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, redPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, greenPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, bluePoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, redTransferFunctionTable: typing.Sequence[int], greenTransferFunctionTable: typing.Sequence[int], blueTransferFunctionTable: typing.Sequence[int]) -> None: ...
    @typing.overload
    def __init__(self, primaries: PySide6.QtGui.QColorSpace.Primaries, transferFunction: PySide6.QtGui.QColorSpace.TransferFunction, gamma: float = ...) -> None: ...
    @typing.overload
    def __init__(self, namedColorSpace: PySide6.QtGui.QColorSpace.NamedColorSpace) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, primaries: PySide6.QtGui.QColorSpace.Primaries, transferFunctionTable: typing.Sequence[int]) -> None: ...
    @typing.overload
    def __init__(self, whitePoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, redPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, greenPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, bluePoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, transferFunction: PySide6.QtGui.QColorSpace.TransferFunction, gamma: float = ...) -> None: ...
    @typing.overload
    def __init__(self, whitePoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, transferFunctionTable: typing.Sequence[int]) -> None: ...
    @typing.overload
    def __init__(self, whitePoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, transferFunction: PySide6.QtGui.QColorSpace.TransferFunction, gamma: float = ...) -> None: ...
    @typing.overload
    def __init__(self, colorSpace: PySide6.QtGui.QColorSpace) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def colorModel(self) -> PySide6.QtGui.QColorSpace.ColorModel: ...
    def description(self) -> str: ...
    @staticmethod
    def fromIccProfile(iccProfile: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> PySide6.QtGui.QColorSpace: ...
    def gamma(self) -> float: ...
    def iccProfile(self) -> PySide6.QtCore.QByteArray: ...
    def isValid(self) -> bool: ...
    def isValidTarget(self) -> bool: ...
    def primaries(self) -> PySide6.QtGui.QColorSpace.Primaries: ...
    def setDescription(self, description: str) -> None: ...
    @typing.overload
    def setPrimaries(self, whitePoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, redPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, greenPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, bluePoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def setPrimaries(self, primariesId: PySide6.QtGui.QColorSpace.Primaries) -> None: ...
    @typing.overload
    def setTransferFunction(self, transferFunction: PySide6.QtGui.QColorSpace.TransferFunction, gamma: float = ...) -> None: ...
    @typing.overload
    def setTransferFunction(self, transferFunctionTable: typing.Sequence[int]) -> None: ...
    def setTransferFunctions(self, redTransferFunctionTable: typing.Sequence[int], greenTransferFunctionTable: typing.Sequence[int], blueTransferFunctionTable: typing.Sequence[int]) -> None: ...
    def setWhitePoint(self, whitePoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def swap(self, colorSpace: PySide6.QtGui.QColorSpace | PySide6.QtGui.QColorSpace.NamedColorSpace) -> None: ...
    def transferFunction(self) -> PySide6.QtGui.QColorSpace.TransferFunction: ...
    def transformModel(self) -> PySide6.QtGui.QColorSpace.TransformModel: ...
    def transformationToColorSpace(self, colorspace: PySide6.QtGui.QColorSpace | PySide6.QtGui.QColorSpace.NamedColorSpace) -> PySide6.QtGui.QColorTransform: ...
    def whitePoint(self) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def withTransferFunction(self, transferFunctionTable: typing.Sequence[int]) -> PySide6.QtGui.QColorSpace: ...
    @typing.overload
    def withTransferFunction(self, transferFunction: PySide6.QtGui.QColorSpace.TransferFunction, gamma: float = ...) -> PySide6.QtGui.QColorSpace: ...
    def withTransferFunctions(self, redTransferFunctionTable: typing.Sequence[int], greenTransferFunctionTable: typing.Sequence[int], blueTransferFunctionTable: typing.Sequence[int]) -> PySide6.QtGui.QColorSpace: ...


class QColorTransform(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, colorTransform: PySide6.QtGui.QColorTransform) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def isIdentity(self) -> bool: ...
    @typing.overload
    def map(self, rgba64: PySide6.QtGui.QRgba64) -> PySide6.QtGui.QRgba64: ...
    @typing.overload
    def map(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> PySide6.QtGui.QColor: ...
    @typing.overload
    def map(self, argb: int) -> int: ...
    def swap(self, other: PySide6.QtGui.QColorTransform) -> None: ...


class QConicalGradient(PySide6.QtGui.QGradient):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, cx: float, cy: float, startAngle: float) -> None: ...
    @typing.overload
    def __init__(self, center: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, startAngle: float) -> None: ...
    @typing.overload
    def __init__(self, QConicalGradient: PySide6.QtGui.QConicalGradient) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def angle(self) -> float: ...
    def center(self) -> PySide6.QtCore.QPointF: ...
    def setAngle(self, angle: float) -> None: ...
    @typing.overload
    def setCenter(self, x: float, y: float) -> None: ...
    @typing.overload
    def setCenter(self, center: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...


class QContextMenuEvent(PySide6.QtGui.QInputEvent):

    class Reason(enum.Enum):

        Mouse                     = ...  # 0x0
        Keyboard                  = ...  # 0x1
        Other                     = ...  # 0x2


    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QContextMenuEvent) -> None: ...
    @typing.overload
    def __init__(self, reason: PySide6.QtGui.QContextMenuEvent.Reason, pos: PySide6.QtCore.QPoint, globalPos: PySide6.QtCore.QPoint, modifiers: PySide6.QtCore.Qt.KeyboardModifier = ...) -> None: ...
    @typing.overload
    def __init__(self, reason: PySide6.QtGui.QContextMenuEvent.Reason, pos: PySide6.QtCore.QPoint) -> None: ...

    def clone(self) -> PySide6.QtGui.QContextMenuEvent: ...
    def globalPos(self) -> PySide6.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def reason(self) -> PySide6.QtGui.QContextMenuEvent.Reason: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QCursor(Shiboken.Object):

    @typing.overload
    def __init__(self, shape: PySide6.QtCore.Qt.CursorShape) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, hotX: int = ..., hotY: int = ...) -> None: ...
    @typing.overload
    def __init__(self, bitmap: PySide6.QtGui.QBitmap | str, mask: PySide6.QtGui.QBitmap | str, hotX: int = ..., hotY: int = ...) -> None: ...
    @typing.overload
    def __init__(self, cursor: PySide6.QtGui.QCursor) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, outS: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, inS: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def bitmap(self) -> PySide6.QtGui.QBitmap: ...
    @typing.overload
    def bitmap(self, arg__1: PySide6.QtCore.Qt.ReturnByValueConstant) -> PySide6.QtGui.QBitmap: ...
    def hotSpot(self) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def mask(self) -> PySide6.QtGui.QBitmap: ...
    @typing.overload
    def mask(self, arg__1: PySide6.QtCore.Qt.ReturnByValueConstant) -> PySide6.QtGui.QBitmap: ...
    def pixmap(self) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def pos() -> PySide6.QtCore.QPoint: ...
    @typing.overload
    @staticmethod
    def pos(screen: PySide6.QtGui.QScreen) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    @staticmethod
    def setPos(screen: PySide6.QtGui.QScreen, x: int, y: int) -> None: ...
    @typing.overload
    @staticmethod
    def setPos(screen: PySide6.QtGui.QScreen, p: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    @staticmethod
    def setPos(p: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    @staticmethod
    def setPos(x: int, y: int) -> None: ...
    def setShape(self, newShape: PySide6.QtCore.Qt.CursorShape) -> None: ...
    def shape(self) -> PySide6.QtCore.Qt.CursorShape: ...
    def swap(self, other: PySide6.QtGui.QCursor | PySide6.QtCore.Qt.CursorShape | PySide6.QtGui.QPixmap) -> None: ...


class QDesktopServices(Shiboken.Object):

    def __init__(self) -> None: ...

    @staticmethod
    def openUrl(url: PySide6.QtCore.QUrl | str) -> bool: ...
    @staticmethod
    def setUrlHandler(scheme: str, receiver: PySide6.QtCore.QObject, method: bytes | bytearray | memoryview) -> None: ...
    @staticmethod
    def unsetUrlHandler(scheme: str) -> None: ...


class QDoubleValidator(PySide6.QtGui.QValidator):

    bottomChanged            : typing.ClassVar[Signal] = ... # bottomChanged(double)
    decimalsChanged          : typing.ClassVar[Signal] = ... # decimalsChanged(int)
    notationChanged          : typing.ClassVar[Signal] = ... # notationChanged(QDoubleValidator::Notation)
    topChanged               : typing.ClassVar[Signal] = ... # topChanged(double)

    class Notation(enum.Enum):

        StandardNotation          = ...  # 0x0
        ScientificNotation        = ...  # 0x1


    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...
    @typing.overload
    def __init__(self, bottom: float, top: float, decimals: int, parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    def bottom(self) -> float: ...
    def decimals(self) -> int: ...
    def fixup(self, input: str) -> str: ...
    def notation(self) -> PySide6.QtGui.QDoubleValidator.Notation: ...
    def setBottom(self, arg__1: float) -> None: ...
    def setDecimals(self, arg__1: int) -> None: ...
    def setNotation(self, arg__1: PySide6.QtGui.QDoubleValidator.Notation) -> None: ...
    @typing.overload
    def setRange(self, bottom: float, top: float) -> None: ...
    @typing.overload
    def setRange(self, bottom: float, top: float, decimals: int) -> None: ...
    def setTop(self, arg__1: float) -> None: ...
    def top(self) -> float: ...
    def validate(self, arg__1: str, arg__2: int) -> object: ...


class QDrag(PySide6.QtCore.QObject):

    actionChanged            : typing.ClassVar[Signal] = ... # actionChanged(Qt::DropAction)
    targetChanged            : typing.ClassVar[Signal] = ... # targetChanged(QObject*)

    def __init__(self, dragSource: PySide6.QtCore.QObject) -> None: ...

    @staticmethod
    def cancel() -> None: ...
    def defaultAction(self) -> PySide6.QtCore.Qt.DropAction: ...
    def dragCursor(self, action: PySide6.QtCore.Qt.DropAction) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    def exec(self, supportedActions: PySide6.QtCore.Qt.DropAction = ...) -> PySide6.QtCore.Qt.DropAction: ...
    @typing.overload
    def exec(self, supportedActions: PySide6.QtCore.Qt.DropAction, defaultAction: PySide6.QtCore.Qt.DropAction) -> PySide6.QtCore.Qt.DropAction: ...
    @typing.overload
    def exec_(self, arg__1: PySide6.QtCore.Qt.DropAction, arg__2: PySide6.QtCore.Qt.DropAction) -> PySide6.QtCore.Qt.DropAction: ...
    @typing.overload
    def exec_(self, supportedActions: PySide6.QtCore.Qt.DropAction = ...) -> PySide6.QtCore.Qt.DropAction: ...
    def hotSpot(self) -> PySide6.QtCore.QPoint: ...
    def mimeData(self) -> PySide6.QtCore.QMimeData: ...
    def pixmap(self) -> PySide6.QtGui.QPixmap: ...
    def setDragCursor(self, cursor: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, action: PySide6.QtCore.Qt.DropAction) -> None: ...
    def setHotSpot(self, hotspot: PySide6.QtCore.QPoint) -> None: ...
    def setMimeData(self, data: PySide6.QtCore.QMimeData) -> None: ...
    def setPixmap(self, arg__1: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...
    def source(self) -> PySide6.QtCore.QObject: ...
    def supportedActions(self) -> PySide6.QtCore.Qt.DropAction: ...
    def target(self) -> PySide6.QtCore.QObject: ...


class QDragEnterEvent(PySide6.QtGui.QDragMoveEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QDragEnterEvent) -> None: ...
    @typing.overload
    def __init__(self, pos: PySide6.QtCore.QPoint, actions: PySide6.QtCore.Qt.DropAction, data: PySide6.QtCore.QMimeData, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def clone(self) -> PySide6.QtGui.QDragEnterEvent: ...


class QDragLeaveEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QDragLeaveEvent) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def clone(self) -> PySide6.QtGui.QDragLeaveEvent: ...


class QDragMoveEvent(PySide6.QtGui.QDropEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QDragMoveEvent) -> None: ...
    @typing.overload
    def __init__(self, pos: PySide6.QtCore.QPoint, actions: PySide6.QtCore.Qt.DropAction, data: PySide6.QtCore.QMimeData, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, type: PySide6.QtCore.QEvent.Type = ...) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    @typing.overload
    def accept(self) -> None: ...
    @typing.overload
    def accept(self, r: PySide6.QtCore.QRect) -> None: ...
    def answerRect(self) -> PySide6.QtCore.QRect: ...
    def clone(self) -> PySide6.QtGui.QDragMoveEvent: ...
    @typing.overload
    def ignore(self) -> None: ...
    @typing.overload
    def ignore(self, r: PySide6.QtCore.QRect) -> None: ...


class QDropEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, actions: PySide6.QtCore.Qt.DropAction, data: PySide6.QtCore.QMimeData, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, type: PySide6.QtCore.QEvent.Type = ...) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QDropEvent) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def acceptProposedAction(self) -> None: ...
    def buttons(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def clone(self) -> PySide6.QtGui.QDropEvent: ...
    def dropAction(self) -> PySide6.QtCore.Qt.DropAction: ...
    def keyboardModifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def mimeData(self) -> PySide6.QtCore.QMimeData: ...
    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def mouseButtons(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def posF(self) -> PySide6.QtCore.QPointF: ...
    def position(self) -> PySide6.QtCore.QPointF: ...
    def possibleActions(self) -> PySide6.QtCore.Qt.DropAction: ...
    def proposedAction(self) -> PySide6.QtCore.Qt.DropAction: ...
    def setDropAction(self, action: PySide6.QtCore.Qt.DropAction) -> None: ...
    def source(self) -> PySide6.QtCore.QObject: ...


class QEnterEvent(PySide6.QtGui.QSinglePointEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QEnterEvent) -> None: ...
    @typing.overload
    def __init__(self, localPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, scenePos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, globalPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, device: PySide6.QtGui.QPointingDevice = ...) -> None: ...

    def clone(self) -> PySide6.QtGui.QEnterEvent: ...
    def globalPos(self) -> PySide6.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def localPos(self) -> PySide6.QtCore.QPointF: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def screenPos(self) -> PySide6.QtCore.QPointF: ...
    def windowPos(self) -> PySide6.QtCore.QPointF: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QEventPoint(Shiboken.Object):

    class State(enum.Enum):

        Unknown                   = ...  # 0x0
        Pressed                   = ...  # 0x1
        Updated                   = ...  # 0x2
        Stationary                = ...  # 0x4
        Released                  = ...  # 0x8


    @typing.overload
    def __init__(self, id: int = ..., device: PySide6.QtGui.QPointingDevice | None= ...) -> None: ...
    @typing.overload
    def __init__(self, pointId: int, state: PySide6.QtGui.QEventPoint.State, scenePosition: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, globalPosition: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QEventPoint) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def device(self) -> PySide6.QtGui.QPointingDevice: ...
    def ellipseDiameters(self) -> PySide6.QtCore.QSizeF: ...
    def globalGrabPosition(self) -> PySide6.QtCore.QPointF: ...
    def globalLastPosition(self) -> PySide6.QtCore.QPointF: ...
    def globalPosition(self) -> PySide6.QtCore.QPointF: ...
    def globalPressPosition(self) -> PySide6.QtCore.QPointF: ...
    def grabPosition(self) -> PySide6.QtCore.QPointF: ...
    def id(self) -> int: ...
    def isAccepted(self) -> bool: ...
    def lastNormalizedPos(self) -> PySide6.QtCore.QPointF: ...
    def lastPos(self) -> PySide6.QtCore.QPointF: ...
    def lastPosition(self) -> PySide6.QtCore.QPointF: ...
    def lastScenePos(self) -> PySide6.QtCore.QPointF: ...
    def lastScreenPos(self) -> PySide6.QtCore.QPointF: ...
    def lastTimestamp(self) -> int: ...
    def normalizedPos(self) -> PySide6.QtCore.QPointF: ...
    def normalizedPosition(self) -> PySide6.QtCore.QPointF: ...
    def pos(self) -> PySide6.QtCore.QPointF: ...
    def position(self) -> PySide6.QtCore.QPointF: ...
    def pressPosition(self) -> PySide6.QtCore.QPointF: ...
    def pressTimestamp(self) -> int: ...
    def pressure(self) -> float: ...
    def rotation(self) -> float: ...
    def sceneGrabPosition(self) -> PySide6.QtCore.QPointF: ...
    def sceneLastPosition(self) -> PySide6.QtCore.QPointF: ...
    def scenePos(self) -> PySide6.QtCore.QPointF: ...
    def scenePosition(self) -> PySide6.QtCore.QPointF: ...
    def scenePressPosition(self) -> PySide6.QtCore.QPointF: ...
    def screenPos(self) -> PySide6.QtCore.QPointF: ...
    def setAccepted(self, accepted: bool = ...) -> None: ...
    def startNormalizedPos(self) -> PySide6.QtCore.QPointF: ...
    def startPos(self) -> PySide6.QtCore.QPointF: ...
    def startScenePos(self) -> PySide6.QtCore.QPointF: ...
    def startScreenPos(self) -> PySide6.QtCore.QPointF: ...
    def state(self) -> PySide6.QtGui.QEventPoint.State: ...
    def swap(self, other: PySide6.QtGui.QEventPoint) -> None: ...
    def timeHeld(self) -> float: ...
    def timestamp(self) -> int: ...
    def uniqueId(self) -> PySide6.QtGui.QPointingDeviceUniqueId: ...
    def velocity(self) -> PySide6.QtGui.QVector2D: ...


class QExposeEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QExposeEvent) -> None: ...
    @typing.overload
    def __init__(self, m_region: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> None: ...

    def clone(self) -> PySide6.QtGui.QExposeEvent: ...
    def region(self) -> PySide6.QtGui.QRegion: ...


class QFileOpenEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, file: str) -> None: ...
    @typing.overload
    def __init__(self, url: PySide6.QtCore.QUrl | str) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QFileOpenEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QFileOpenEvent: ...
    def file(self) -> str: ...
    def openFile(self, file: PySide6.QtCore.QFile, flags: PySide6.QtCore.QIODeviceBase.OpenModeFlag) -> bool: ...
    def url(self) -> PySide6.QtCore.QUrl: ...


class QFocusEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, reason: PySide6.QtCore.Qt.FocusReason = ...) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def clone(self) -> PySide6.QtGui.QFocusEvent: ...
    def gotFocus(self) -> bool: ...
    def lostFocus(self) -> bool: ...
    def reason(self) -> PySide6.QtCore.Qt.FocusReason: ...


class QFont(Shiboken.Object):

    class Capitalization(enum.Enum):

        MixedCase                 = ...  # 0x0
        AllUppercase              = ...  # 0x1
        AllLowercase              = ...  # 0x2
        SmallCaps                 = ...  # 0x3
        Capitalize                = ...  # 0x4

    class HintingPreference(enum.Enum):

        PreferDefaultHinting      = ...  # 0x0
        PreferNoHinting           = ...  # 0x1
        PreferVerticalHinting     = ...  # 0x2
        PreferFullHinting         = ...  # 0x3

    class SpacingType(enum.Enum):

        PercentageSpacing         = ...  # 0x0
        AbsoluteSpacing           = ...  # 0x1

    class Stretch(enum.IntEnum):

        AnyStretch                = ...  # 0x0
        UltraCondensed            = ...  # 0x32
        ExtraCondensed            = ...  # 0x3e
        Condensed                 = ...  # 0x4b
        SemiCondensed             = ...  # 0x57
        Unstretched               = ...  # 0x64
        SemiExpanded              = ...  # 0x70
        Expanded                  = ...  # 0x7d
        ExtraExpanded             = ...  # 0x96
        UltraExpanded             = ...  # 0xc8

    class Style(enum.Enum):

        StyleNormal               = ...  # 0x0
        StyleItalic               = ...  # 0x1
        StyleOblique              = ...  # 0x2

    class StyleHint(enum.Enum):

        Helvetica                 = ...  # 0x0
        SansSerif                 = ...  # 0x0
        Serif                     = ...  # 0x1
        Times                     = ...  # 0x1
        Courier                   = ...  # 0x2
        TypeWriter                = ...  # 0x2
        Decorative                = ...  # 0x3
        OldEnglish                = ...  # 0x3
        System                    = ...  # 0x4
        AnyStyle                  = ...  # 0x5
        Cursive                   = ...  # 0x6
        Monospace                 = ...  # 0x7
        Fantasy                   = ...  # 0x8

    class StyleStrategy(enum.Flag):

        PreferDefault             = ...  # 0x1
        PreferBitmap              = ...  # 0x2
        PreferDevice              = ...  # 0x4
        PreferOutline             = ...  # 0x8
        ForceOutline              = ...  # 0x10
        PreferMatch               = ...  # 0x20
        PreferQuality             = ...  # 0x40
        PreferAntialias           = ...  # 0x80
        NoAntialias               = ...  # 0x100
        NoSubpixelAntialias       = ...  # 0x800
        PreferNoShaping           = ...  # 0x1000
        ContextFontMerging        = ...  # 0x2000
        PreferTypoLineMetrics     = ...  # 0x4000
        NoFontMerging             = ...  # 0x8000

    class Tag(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Tag: PySide6.QtGui.QFont.Tag) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def isValid(self) -> bool: ...
        def toString(self) -> PySide6.QtCore.QByteArray: ...
        def value(self) -> int: ...

    class Weight(enum.IntEnum):

        Thin                      = ...  # 0x64
        ExtraLight                = ...  # 0xc8
        Light                     = ...  # 0x12c
        Normal                    = ...  # 0x190
        Medium                    = ...  # 0x1f4
        DemiBold                  = ...  # 0x258
        Bold                      = ...  # 0x2bc
        ExtraBold                 = ...  # 0x320
        Black                     = ...  # 0x384


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, families: typing.Sequence[str], pointSize: int = ..., weight: int = ..., italic: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, family: str, pointSize: int = ..., weight: int = ..., italic: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, font: PySide6.QtGui.QFont | str | typing.Sequence[str], pd: PySide6.QtGui.QPaintDevice) -> None: ...
    @typing.overload
    def __init__(self, font: PySide6.QtGui.QFont) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def bold(self) -> bool: ...
    @staticmethod
    def cacheStatistics() -> None: ...
    def capitalization(self) -> PySide6.QtGui.QFont.Capitalization: ...
    @staticmethod
    def cleanup() -> None: ...
    def clearFeatures(self) -> None: ...
    def clearVariableAxes(self) -> None: ...
    def defaultFamily(self) -> str: ...
    def exactMatch(self) -> bool: ...
    def families(self) -> typing.List[str]: ...
    def family(self) -> str: ...
    def featureTags(self) -> typing.List[PySide6.QtGui.QFont.Tag]: ...
    def featureValue(self, tag: PySide6.QtGui.QFont.Tag) -> int: ...
    def fixedPitch(self) -> bool: ...
    def fromString(self, arg__1: str) -> bool: ...
    def hintingPreference(self) -> PySide6.QtGui.QFont.HintingPreference: ...
    @staticmethod
    def initialize() -> None: ...
    @staticmethod
    def insertSubstitution(arg__1: str, arg__2: str) -> None: ...
    @staticmethod
    def insertSubstitutions(arg__1: str, arg__2: typing.Sequence[str]) -> None: ...
    def isCopyOf(self, arg__1: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> bool: ...
    def isFeatureSet(self, tag: PySide6.QtGui.QFont.Tag) -> bool: ...
    def isVariableAxisSet(self, tag: PySide6.QtGui.QFont.Tag) -> bool: ...
    def italic(self) -> bool: ...
    def kerning(self) -> bool: ...
    def key(self) -> str: ...
    def legacyWeight(self) -> int: ...
    def letterSpacing(self) -> float: ...
    def letterSpacingType(self) -> PySide6.QtGui.QFont.SpacingType: ...
    def overline(self) -> bool: ...
    def pixelSize(self) -> int: ...
    def pointSize(self) -> int: ...
    def pointSizeF(self) -> float: ...
    @staticmethod
    def removeSubstitutions(arg__1: str) -> None: ...
    def resolve(self, arg__1: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> PySide6.QtGui.QFont: ...
    def resolveMask(self) -> int: ...
    def setBold(self, arg__1: bool) -> None: ...
    def setCapitalization(self, arg__1: PySide6.QtGui.QFont.Capitalization) -> None: ...
    def setFamilies(self, arg__1: typing.Sequence[str]) -> None: ...
    def setFamily(self, arg__1: str) -> None: ...
    def setFeature(self, tag: PySide6.QtGui.QFont.Tag, value: int) -> None: ...
    def setFixedPitch(self, arg__1: bool) -> None: ...
    def setHintingPreference(self, hintingPreference: PySide6.QtGui.QFont.HintingPreference) -> None: ...
    def setItalic(self, b: bool) -> None: ...
    def setKerning(self, arg__1: bool) -> None: ...
    def setLegacyWeight(self, legacyWeight: int) -> None: ...
    def setLetterSpacing(self, type: PySide6.QtGui.QFont.SpacingType, spacing: float) -> None: ...
    def setOverline(self, arg__1: bool) -> None: ...
    def setPixelSize(self, arg__1: int) -> None: ...
    def setPointSize(self, arg__1: int) -> None: ...
    def setPointSizeF(self, arg__1: float) -> None: ...
    def setResolveMask(self, mask: int) -> None: ...
    def setStretch(self, arg__1: int) -> None: ...
    def setStrikeOut(self, arg__1: bool) -> None: ...
    def setStyle(self, style: PySide6.QtGui.QFont.Style) -> None: ...
    def setStyleHint(self, arg__1: PySide6.QtGui.QFont.StyleHint, strategy: PySide6.QtGui.QFont.StyleStrategy = ...) -> None: ...
    def setStyleName(self, arg__1: str) -> None: ...
    def setStyleStrategy(self, s: PySide6.QtGui.QFont.StyleStrategy) -> None: ...
    def setUnderline(self, arg__1: bool) -> None: ...
    def setVariableAxis(self, tag: PySide6.QtGui.QFont.Tag, value: float) -> None: ...
    def setWeight(self, weight: PySide6.QtGui.QFont.Weight) -> None: ...
    def setWordSpacing(self, spacing: float) -> None: ...
    def stretch(self) -> int: ...
    def strikeOut(self) -> bool: ...
    def style(self) -> PySide6.QtGui.QFont.Style: ...
    def styleHint(self) -> PySide6.QtGui.QFont.StyleHint: ...
    def styleName(self) -> str: ...
    def styleStrategy(self) -> PySide6.QtGui.QFont.StyleStrategy: ...
    @staticmethod
    def substitute(arg__1: str) -> str: ...
    @staticmethod
    def substitutes(arg__1: str) -> typing.List[str]: ...
    @staticmethod
    def substitutions() -> typing.List[str]: ...
    def swap(self, other: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> None: ...
    def toString(self) -> str: ...
    def underline(self) -> bool: ...
    def unsetFeature(self, tag: PySide6.QtGui.QFont.Tag) -> None: ...
    def unsetVariableAxis(self, tag: PySide6.QtGui.QFont.Tag) -> None: ...
    def variableAxisTags(self) -> typing.List[PySide6.QtGui.QFont.Tag]: ...
    def variableAxisValue(self, tag: PySide6.QtGui.QFont.Tag) -> float: ...
    def weight(self) -> PySide6.QtGui.QFont.Weight: ...
    def wordSpacing(self) -> float: ...


class Tag(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, Tag: PySide6.QtGui.QFont.Tag) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def isValid(self) -> bool: ...
    def toString(self) -> PySide6.QtCore.QByteArray: ...
    def value(self) -> int: ...


class QFontDatabase(Shiboken.Object):

    class SystemFont(enum.Enum):

        GeneralFont               = ...  # 0x0
        FixedFont                 = ...  # 0x1
        TitleFont                 = ...  # 0x2
        SmallestReadableFont      = ...  # 0x3

    class WritingSystem(enum.Enum):

        Any                       = ...  # 0x0
        Latin                     = ...  # 0x1
        Greek                     = ...  # 0x2
        Cyrillic                  = ...  # 0x3
        Armenian                  = ...  # 0x4
        Hebrew                    = ...  # 0x5
        Arabic                    = ...  # 0x6
        Syriac                    = ...  # 0x7
        Thaana                    = ...  # 0x8
        Devanagari                = ...  # 0x9
        Bengali                   = ...  # 0xa
        Gurmukhi                  = ...  # 0xb
        Gujarati                  = ...  # 0xc
        Oriya                     = ...  # 0xd
        Tamil                     = ...  # 0xe
        Telugu                    = ...  # 0xf
        Kannada                   = ...  # 0x10
        Malayalam                 = ...  # 0x11
        Sinhala                   = ...  # 0x12
        Thai                      = ...  # 0x13
        Lao                       = ...  # 0x14
        Tibetan                   = ...  # 0x15
        Myanmar                   = ...  # 0x16
        Georgian                  = ...  # 0x17
        Khmer                     = ...  # 0x18
        SimplifiedChinese         = ...  # 0x19
        TraditionalChinese        = ...  # 0x1a
        Japanese                  = ...  # 0x1b
        Korean                    = ...  # 0x1c
        Vietnamese                = ...  # 0x1d
        Other                     = ...  # 0x1e
        Symbol                    = ...  # 0x1e
        Ogham                     = ...  # 0x1f
        Runic                     = ...  # 0x20
        Nko                       = ...  # 0x21
        WritingSystemsCount       = ...  # 0x22


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QFontDatabase: PySide6.QtGui.QFontDatabase) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def addApplicationFont(fileName: str) -> int: ...
    @staticmethod
    def addApplicationFontFromData(fontData: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> int: ...
    @staticmethod
    def applicationFontFamilies(id: int) -> typing.List[str]: ...
    @staticmethod
    def bold(family: str, style: str) -> bool: ...
    @staticmethod
    def families(writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem = ...) -> typing.List[str]: ...
    @staticmethod
    def font(family: str, style: str, pointSize: int) -> PySide6.QtGui.QFont: ...
    @staticmethod
    def hasFamily(family: str) -> bool: ...
    @staticmethod
    def isBitmapScalable(family: str, style: str = ...) -> bool: ...
    @staticmethod
    def isFixedPitch(family: str, style: str = ...) -> bool: ...
    @staticmethod
    def isPrivateFamily(family: str) -> bool: ...
    @staticmethod
    def isScalable(family: str, style: str = ...) -> bool: ...
    @staticmethod
    def isSmoothlyScalable(family: str, style: str = ...) -> bool: ...
    @staticmethod
    def italic(family: str, style: str) -> bool: ...
    @staticmethod
    def pointSizes(family: str, style: str = ...) -> typing.List[int]: ...
    @staticmethod
    def removeAllApplicationFonts() -> bool: ...
    @staticmethod
    def removeApplicationFont(id: int) -> bool: ...
    @staticmethod
    def smoothSizes(family: str, style: str) -> typing.List[int]: ...
    @staticmethod
    def standardSizes() -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def styleString(fontInfo: PySide6.QtGui.QFontInfo | PySide6.QtGui.QFont) -> str: ...
    @typing.overload
    @staticmethod
    def styleString(font: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> str: ...
    @staticmethod
    def styles(family: str) -> typing.List[str]: ...
    @staticmethod
    def systemFont(type: PySide6.QtGui.QFontDatabase.SystemFont) -> PySide6.QtGui.QFont: ...
    @staticmethod
    def weight(family: str, style: str) -> int: ...
    @staticmethod
    def writingSystemName(writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem) -> str: ...
    @staticmethod
    def writingSystemSample(writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem) -> str: ...
    @typing.overload
    @staticmethod
    def writingSystems() -> typing.List[PySide6.QtGui.QFontDatabase.WritingSystem]: ...
    @typing.overload
    @staticmethod
    def writingSystems(family: str) -> typing.List[PySide6.QtGui.QFontDatabase.WritingSystem]: ...


class QFontInfo(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QFontInfo) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def bold(self) -> bool: ...
    def exactMatch(self) -> bool: ...
    def family(self) -> str: ...
    def fixedPitch(self) -> bool: ...
    def italic(self) -> bool: ...
    def legacyWeight(self) -> int: ...
    def overline(self) -> bool: ...
    def pixelSize(self) -> int: ...
    def pointSize(self) -> int: ...
    def pointSizeF(self) -> float: ...
    def strikeOut(self) -> bool: ...
    def style(self) -> PySide6.QtGui.QFont.Style: ...
    def styleHint(self) -> PySide6.QtGui.QFont.StyleHint: ...
    def styleName(self) -> str: ...
    def swap(self, other: PySide6.QtGui.QFontInfo | PySide6.QtGui.QFont) -> None: ...
    def underline(self) -> bool: ...
    def weight(self) -> int: ...


class QFontMetrics(Shiboken.Object):

    @typing.overload
    def __init__(self, font: PySide6.QtGui.QFont | str | typing.Sequence[str], pd: PySide6.QtGui.QPaintDevice) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QFontMetrics) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def ascent(self) -> int: ...
    def averageCharWidth(self) -> int: ...
    @typing.overload
    def boundingRect(self, x: int, y: int, w: int, h: int, flags: int, text: str, tabstops: int = ..., tabarray: object | None= ...) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, text: str) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, r: PySide6.QtCore.QRect, flags: int, text: str, tabstops: int = ..., tabarray: object | None= ...) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, text: str, textOption: PySide6.QtGui.QTextOption | PySide6.QtCore.Qt.AlignmentFlag) -> PySide6.QtCore.QRect: ...
    def boundingRectChar(self, arg__1: int) -> PySide6.QtCore.QRect: ...
    def capHeight(self) -> int: ...
    def descent(self) -> int: ...
    def elidedText(self, text: str, mode: PySide6.QtCore.Qt.TextElideMode, width: int, flags: int = ...) -> str: ...
    def fontDpi(self) -> float: ...
    def height(self) -> int: ...
    @typing.overload
    def horizontalAdvance(self, arg__1: str, textOption: PySide6.QtGui.QTextOption | PySide6.QtCore.Qt.AlignmentFlag) -> int: ...
    @typing.overload
    def horizontalAdvance(self, arg__1: str, len: int = ...) -> int: ...
    def horizontalAdvanceChar(self, arg__1: int) -> int: ...
    def inFont(self, arg__1: str) -> bool: ...
    def inFontUcs4(self, ucs4: int) -> bool: ...
    def leading(self) -> int: ...
    def leftBearing(self, arg__1: str) -> int: ...
    def lineSpacing(self) -> int: ...
    def lineWidth(self) -> int: ...
    def maxWidth(self) -> int: ...
    def minLeftBearing(self) -> int: ...
    def minRightBearing(self) -> int: ...
    def overlinePos(self) -> int: ...
    def rightBearing(self, arg__1: str) -> int: ...
    def size(self, flags: int, str: str, tabstops: int = ..., tabarray: object | None= ...) -> PySide6.QtCore.QSize: ...
    def strikeOutPos(self) -> int: ...
    def swap(self, other: PySide6.QtGui.QFontMetrics) -> None: ...
    @typing.overload
    def tightBoundingRect(self, text: str) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def tightBoundingRect(self, text: str, textOption: PySide6.QtGui.QTextOption | PySide6.QtCore.Qt.AlignmentFlag) -> PySide6.QtCore.QRect: ...
    def underlinePos(self) -> int: ...
    def xHeight(self) -> int: ...


class QFontMetricsF(Shiboken.Object):

    @typing.overload
    def __init__(self, font: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QFontMetrics) -> None: ...
    @typing.overload
    def __init__(self, font: PySide6.QtGui.QFont | str | typing.Sequence[str], pd: PySide6.QtGui.QPaintDevice) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QFontMetricsF) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def ascent(self) -> float: ...
    def averageCharWidth(self) -> float: ...
    @typing.overload
    def boundingRect(self, string: str) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, flags: int, string: str, tabstops: int = ..., tabarray: object | None= ...) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, text: str, textOption: PySide6.QtGui.QTextOption | PySide6.QtCore.Qt.AlignmentFlag) -> PySide6.QtCore.QRectF: ...
    def boundingRectChar(self, arg__1: int) -> PySide6.QtCore.QRectF: ...
    def capHeight(self) -> float: ...
    def descent(self) -> float: ...
    def elidedText(self, text: str, mode: PySide6.QtCore.Qt.TextElideMode, width: float, flags: int = ...) -> str: ...
    def fontDpi(self) -> float: ...
    def height(self) -> float: ...
    @typing.overload
    def horizontalAdvance(self, string: str, length: int = ...) -> float: ...
    @typing.overload
    def horizontalAdvance(self, string: str, textOption: PySide6.QtGui.QTextOption | PySide6.QtCore.Qt.AlignmentFlag) -> float: ...
    def horizontalAdvanceChar(self, arg__1: int) -> float: ...
    def inFont(self, arg__1: str) -> bool: ...
    def inFontUcs4(self, ucs4: int) -> bool: ...
    def leading(self) -> float: ...
    def leftBearing(self, arg__1: str) -> float: ...
    def lineSpacing(self) -> float: ...
    def lineWidth(self) -> float: ...
    def maxWidth(self) -> float: ...
    def minLeftBearing(self) -> float: ...
    def minRightBearing(self) -> float: ...
    def overlinePos(self) -> float: ...
    def rightBearing(self, arg__1: str) -> float: ...
    def size(self, flags: int, str: str, tabstops: int = ..., tabarray: object | None= ...) -> PySide6.QtCore.QSizeF: ...
    def strikeOutPos(self) -> float: ...
    def swap(self, other: PySide6.QtGui.QFontMetricsF | PySide6.QtGui.QFontMetrics) -> None: ...
    @typing.overload
    def tightBoundingRect(self, text: str) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def tightBoundingRect(self, text: str, textOption: PySide6.QtGui.QTextOption | PySide6.QtCore.Qt.AlignmentFlag) -> PySide6.QtCore.QRectF: ...
    def underlinePos(self) -> float: ...
    def xHeight(self) -> float: ...


class QGlyphRun(Shiboken.Object):

    class GlyphRunFlag(enum.Flag):

        Overline                  = ...  # 0x1
        Underline                 = ...  # 0x2
        StrikeOut                 = ...  # 0x4
        RightToLeft               = ...  # 0x8
        SplitLigature             = ...  # 0x10


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QGlyphRun) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def clear(self) -> None: ...
    def flags(self) -> PySide6.QtGui.QGlyphRun.GlyphRunFlag: ...
    def glyphIndexes(self) -> typing.List[int]: ...
    def isEmpty(self) -> bool: ...
    def isRightToLeft(self) -> bool: ...
    def overline(self) -> bool: ...
    def positions(self) -> typing.List[PySide6.QtCore.QPointF]: ...
    def rawFont(self) -> PySide6.QtGui.QRawFont: ...
    def setBoundingRect(self, boundingRect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    def setFlag(self, flag: PySide6.QtGui.QGlyphRun.GlyphRunFlag, enabled: bool = ...) -> None: ...
    def setFlags(self, flags: PySide6.QtGui.QGlyphRun.GlyphRunFlag) -> None: ...
    def setGlyphIndexes(self, glyphIndexes: typing.Sequence[int]) -> None: ...
    def setOverline(self, overline: bool) -> None: ...
    def setPositions(self, positions: typing.Sequence[PySide6.QtCore.QPointF]) -> None: ...
    def setRawData(self, glyphIndexArray: int, glyphPositionArray: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, size: int) -> None: ...
    def setRawFont(self, rawFont: PySide6.QtGui.QRawFont) -> None: ...
    def setRightToLeft(self, on: bool) -> None: ...
    def setSourceString(self, sourceString: str) -> None: ...
    def setStrikeOut(self, strikeOut: bool) -> None: ...
    def setStringIndexes(self, stringIndexes: typing.Sequence[int]) -> None: ...
    def setUnderline(self, underline: bool) -> None: ...
    def sourceString(self) -> str: ...
    def strikeOut(self) -> bool: ...
    def stringIndexes(self) -> typing.List[int]: ...
    def swap(self, other: PySide6.QtGui.QGlyphRun) -> None: ...
    def underline(self) -> bool: ...


class QGradient(Shiboken.Object):

    class CoordinateMode(enum.Enum):

        LogicalMode               = ...  # 0x0
        StretchToDeviceMode       = ...  # 0x1
        ObjectBoundingMode        = ...  # 0x2
        ObjectMode                = ...  # 0x3

    class InterpolationMode(enum.Enum):

        ColorInterpolation        = ...  # 0x0
        ComponentInterpolation    = ...  # 0x1

    class Preset(enum.Enum):

        WarmFlame                 = ...  # 0x1
        NightFade                 = ...  # 0x2
        SpringWarmth              = ...  # 0x3
        JuicyPeach                = ...  # 0x4
        YoungPassion              = ...  # 0x5
        LadyLips                  = ...  # 0x6
        SunnyMorning              = ...  # 0x7
        RainyAshville             = ...  # 0x8
        FrozenDreams              = ...  # 0x9
        WinterNeva                = ...  # 0xa
        DustyGrass                = ...  # 0xb
        TemptingAzure             = ...  # 0xc
        HeavyRain                 = ...  # 0xd
        AmyCrisp                  = ...  # 0xe
        MeanFruit                 = ...  # 0xf
        DeepBlue                  = ...  # 0x10
        RipeMalinka               = ...  # 0x11
        CloudyKnoxville           = ...  # 0x12
        MalibuBeach               = ...  # 0x13
        NewLife                   = ...  # 0x14
        TrueSunset                = ...  # 0x15
        MorpheusDen               = ...  # 0x16
        RareWind                  = ...  # 0x17
        NearMoon                  = ...  # 0x18
        WildApple                 = ...  # 0x19
        SaintPetersburg           = ...  # 0x1a
        PlumPlate                 = ...  # 0x1c
        EverlastingSky            = ...  # 0x1d
        HappyFisher               = ...  # 0x1e
        Blessing                  = ...  # 0x1f
        SharpeyeEagle             = ...  # 0x20
        LadogaBottom              = ...  # 0x21
        LemonGate                 = ...  # 0x22
        ItmeoBranding             = ...  # 0x23
        ZeusMiracle               = ...  # 0x24
        OldHat                    = ...  # 0x25
        StarWine                  = ...  # 0x26
        HappyAcid                 = ...  # 0x29
        AwesomePine               = ...  # 0x2a
        NewYork                   = ...  # 0x2b
        ShyRainbow                = ...  # 0x2c
        MixedHopes                = ...  # 0x2e
        FlyHigh                   = ...  # 0x2f
        StrongBliss               = ...  # 0x30
        FreshMilk                 = ...  # 0x31
        SnowAgain                 = ...  # 0x32
        FebruaryInk               = ...  # 0x33
        KindSteel                 = ...  # 0x34
        SoftGrass                 = ...  # 0x35
        GrownEarly                = ...  # 0x36
        SharpBlues                = ...  # 0x37
        ShadyWater                = ...  # 0x38
        DirtyBeauty               = ...  # 0x39
        GreatWhale                = ...  # 0x3a
        TeenNotebook              = ...  # 0x3b
        PoliteRumors              = ...  # 0x3c
        SweetPeriod               = ...  # 0x3d
        WideMatrix                = ...  # 0x3e
        SoftCherish               = ...  # 0x3f
        RedSalvation              = ...  # 0x40
        BurningSpring             = ...  # 0x41
        NightParty                = ...  # 0x42
        SkyGlider                 = ...  # 0x43
        HeavenPeach               = ...  # 0x44
        PurpleDivision            = ...  # 0x45
        AquaSplash                = ...  # 0x46
        SpikyNaga                 = ...  # 0x48
        LoveKiss                  = ...  # 0x49
        CleanMirror               = ...  # 0x4b
        PremiumDark               = ...  # 0x4c
        ColdEvening               = ...  # 0x4d
        CochitiLake               = ...  # 0x4e
        SummerGames               = ...  # 0x4f
        PassionateBed             = ...  # 0x50
        MountainRock              = ...  # 0x51
        DesertHump                = ...  # 0x52
        JungleDay                 = ...  # 0x53
        PhoenixStart              = ...  # 0x54
        OctoberSilence            = ...  # 0x55
        FarawayRiver              = ...  # 0x56
        AlchemistLab              = ...  # 0x57
        OverSun                   = ...  # 0x58
        PremiumWhite              = ...  # 0x59
        MarsParty                 = ...  # 0x5a
        EternalConstance          = ...  # 0x5b
        JapanBlush                = ...  # 0x5c
        SmilingRain               = ...  # 0x5d
        CloudyApple               = ...  # 0x5e
        BigMango                  = ...  # 0x5f
        HealthyWater              = ...  # 0x60
        AmourAmour                = ...  # 0x61
        RiskyConcrete             = ...  # 0x62
        StrongStick               = ...  # 0x63
        ViciousStance             = ...  # 0x64
        PaloAlto                  = ...  # 0x65
        HappyMemories             = ...  # 0x66
        MidnightBloom             = ...  # 0x67
        Crystalline               = ...  # 0x68
        PartyBliss                = ...  # 0x6a
        ConfidentCloud            = ...  # 0x6b
        LeCocktail                = ...  # 0x6c
        RiverCity                 = ...  # 0x6d
        FrozenBerry               = ...  # 0x6e
        ChildCare                 = ...  # 0x70
        FlyingLemon               = ...  # 0x71
        NewRetrowave              = ...  # 0x72
        HiddenJaguar              = ...  # 0x73
        AboveTheSky               = ...  # 0x74
        Nega                      = ...  # 0x75
        DenseWater                = ...  # 0x76
        Seashore                  = ...  # 0x78
        MarbleWall                = ...  # 0x79
        CheerfulCaramel           = ...  # 0x7a
        NightSky                  = ...  # 0x7b
        MagicLake                 = ...  # 0x7c
        YoungGrass                = ...  # 0x7d
        ColorfulPeach             = ...  # 0x7e
        GentleCare                = ...  # 0x7f
        PlumBath                  = ...  # 0x80
        HappyUnicorn              = ...  # 0x81
        AfricanField              = ...  # 0x83
        SolidStone                = ...  # 0x84
        OrangeJuice               = ...  # 0x85
        GlassWater                = ...  # 0x86
        NorthMiracle              = ...  # 0x88
        FruitBlend                = ...  # 0x89
        MillenniumPine            = ...  # 0x8a
        HighFlight                = ...  # 0x8b
        MoleHall                  = ...  # 0x8c
        SpaceShift                = ...  # 0x8e
        ForestInei                = ...  # 0x8f
        RoyalGarden               = ...  # 0x90
        RichMetal                 = ...  # 0x91
        JuicyCake                 = ...  # 0x92
        SmartIndigo               = ...  # 0x93
        SandStrike                = ...  # 0x94
        NorseBeauty               = ...  # 0x95
        AquaGuidance              = ...  # 0x96
        SunVeggie                 = ...  # 0x97
        SeaLord                   = ...  # 0x98
        BlackSea                  = ...  # 0x99
        GrassShampoo              = ...  # 0x9a
        LandingAircraft           = ...  # 0x9b
        WitchDance                = ...  # 0x9c
        SleeplessNight            = ...  # 0x9d
        AngelCare                 = ...  # 0x9e
        CrystalRiver              = ...  # 0x9f
        SoftLipstick              = ...  # 0xa0
        SaltMountain              = ...  # 0xa1
        PerfectWhite              = ...  # 0xa2
        FreshOasis                = ...  # 0xa3
        StrictNovember            = ...  # 0xa4
        MorningSalad              = ...  # 0xa5
        DeepRelief                = ...  # 0xa6
        SeaStrike                 = ...  # 0xa7
        NightCall                 = ...  # 0xa8
        SupremeSky                = ...  # 0xa9
        LightBlue                 = ...  # 0xaa
        MindCrawl                 = ...  # 0xab
        LilyMeadow                = ...  # 0xac
        SugarLollipop             = ...  # 0xad
        SweetDessert              = ...  # 0xae
        MagicRay                  = ...  # 0xaf
        TeenParty                 = ...  # 0xb0
        FrozenHeat                = ...  # 0xb1
        GagarinView               = ...  # 0xb2
        FabledSunset              = ...  # 0xb3
        PerfectBlue               = ...  # 0xb4
        NumPresets                = ...  # 0xb5

    class Spread(enum.Enum):

        PadSpread                 = ...  # 0x0
        ReflectSpread             = ...  # 0x1
        RepeatSpread              = ...  # 0x2

    class Type(enum.Enum):

        LinearGradient            = ...  # 0x0
        RadialGradient            = ...  # 0x1
        ConicalGradient           = ...  # 0x2
        NoGradient                = ...  # 0x3


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QGradient.Preset) -> None: ...
    @typing.overload
    def __init__(self, QGradient: PySide6.QtGui.QGradient) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def coordinateMode(self) -> PySide6.QtGui.QGradient.CoordinateMode: ...
    def interpolationMode(self) -> PySide6.QtGui.QGradient.InterpolationMode: ...
    def setColorAt(self, pos: float, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    def setCoordinateMode(self, mode: PySide6.QtGui.QGradient.CoordinateMode) -> None: ...
    def setInterpolationMode(self, mode: PySide6.QtGui.QGradient.InterpolationMode) -> None: ...
    def setSpread(self, spread: PySide6.QtGui.QGradient.Spread) -> None: ...
    def setStops(self, stops: typing.Sequence[typing.Tuple[float, PySide6.QtGui.QColor]]) -> None: ...
    def spread(self) -> PySide6.QtGui.QGradient.Spread: ...
    def stops(self) -> typing.List[typing.Tuple[float, PySide6.QtGui.QColor]]: ...
    def type(self) -> PySide6.QtGui.QGradient.Type: ...


class QGuiApplication(PySide6.QtCore.QCoreApplication):

    applicationDisplayNameChanged: typing.ClassVar[Signal] = ... # applicationDisplayNameChanged()
    applicationStateChanged  : typing.ClassVar[Signal] = ... # applicationStateChanged(Qt::ApplicationState)
    commitDataRequest        : typing.ClassVar[Signal] = ... # commitDataRequest(QSessionManager&)
    focusObjectChanged       : typing.ClassVar[Signal] = ... # focusObjectChanged(QObject*)
    focusWindowChanged       : typing.ClassVar[Signal] = ... # focusWindowChanged(QWindow*)
    fontChanged              : typing.ClassVar[Signal] = ... # fontChanged(QFont)
    fontDatabaseChanged      : typing.ClassVar[Signal] = ... # fontDatabaseChanged()
    lastWindowClosed         : typing.ClassVar[Signal] = ... # lastWindowClosed()
    layoutDirectionChanged   : typing.ClassVar[Signal] = ... # layoutDirectionChanged(Qt::LayoutDirection)
    paletteChanged           : typing.ClassVar[Signal] = ... # paletteChanged(QPalette)
    primaryScreenChanged     : typing.ClassVar[Signal] = ... # primaryScreenChanged(QScreen*)
    saveStateRequest         : typing.ClassVar[Signal] = ... # saveStateRequest(QSessionManager&)
    screenAdded              : typing.ClassVar[Signal] = ... # screenAdded(QScreen*)
    screenRemoved            : typing.ClassVar[Signal] = ... # screenRemoved(QScreen*)

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Sequence[str]) -> None: ...

    @staticmethod
    def allWindows() -> typing.List[PySide6.QtGui.QWindow]: ...
    @staticmethod
    def applicationDisplayName() -> str: ...
    @staticmethod
    def applicationState() -> PySide6.QtCore.Qt.ApplicationState: ...
    @staticmethod
    def changeOverrideCursor(arg__1: PySide6.QtGui.QCursor | PySide6.QtCore.Qt.CursorShape | PySide6.QtGui.QPixmap) -> None: ...
    @staticmethod
    def clipboard() -> PySide6.QtGui.QClipboard: ...
    @staticmethod
    def desktopFileName() -> str: ...
    @staticmethod
    def desktopSettingsAware() -> bool: ...
    def devicePixelRatio(self) -> float: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    @staticmethod
    def exec() -> int: ...
    def exec_(self) -> int: ...
    @staticmethod
    def focusObject() -> PySide6.QtCore.QObject: ...
    @staticmethod
    def focusWindow() -> PySide6.QtGui.QWindow: ...
    @staticmethod
    def font() -> PySide6.QtGui.QFont: ...
    @staticmethod
    def highDpiScaleFactorRoundingPolicy() -> PySide6.QtCore.Qt.HighDpiScaleFactorRoundingPolicy: ...
    @staticmethod
    def inputMethod() -> PySide6.QtGui.QInputMethod: ...
    @staticmethod
    def isLeftToRight() -> bool: ...
    @staticmethod
    def isRightToLeft() -> bool: ...
    def isSavingSession(self) -> bool: ...
    def isSessionRestored(self) -> bool: ...
    @staticmethod
    def keyboardModifiers() -> PySide6.QtCore.Qt.KeyboardModifier: ...
    @staticmethod
    def layoutDirection() -> PySide6.QtCore.Qt.LayoutDirection: ...
    @staticmethod
    def modalWindow() -> PySide6.QtGui.QWindow: ...
    @staticmethod
    def mouseButtons() -> PySide6.QtCore.Qt.MouseButton: ...
    def nativeInterface(self) -> object: ...
    def notify(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent) -> bool: ...
    @staticmethod
    def overrideCursor() -> PySide6.QtGui.QCursor: ...
    @staticmethod
    def palette() -> PySide6.QtGui.QPalette: ...
    @staticmethod
    def platformFunction(function: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> int: ...
    @staticmethod
    def platformName() -> str: ...
    @staticmethod
    def primaryScreen() -> PySide6.QtGui.QScreen: ...
    @staticmethod
    def queryKeyboardModifiers() -> PySide6.QtCore.Qt.KeyboardModifier: ...
    @staticmethod
    def quitOnLastWindowClosed() -> bool: ...
    def resolveInterface(self, name: bytes | bytearray | memoryview, revision: int) -> int: ...
    @staticmethod
    def restoreOverrideCursor() -> None: ...
    @staticmethod
    def screenAt(point: PySide6.QtCore.QPoint) -> PySide6.QtGui.QScreen: ...
    @staticmethod
    def screens() -> typing.List[PySide6.QtGui.QScreen]: ...
    def sessionId(self) -> str: ...
    def sessionKey(self) -> str: ...
    @staticmethod
    def setApplicationDisplayName(name: str) -> None: ...
    def setBadgeNumber(self, number: int) -> None: ...
    @staticmethod
    def setDesktopFileName(name: str) -> None: ...
    @staticmethod
    def setDesktopSettingsAware(on: bool) -> None: ...
    @staticmethod
    def setFont(arg__1: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> None: ...
    @staticmethod
    def setHighDpiScaleFactorRoundingPolicy(policy: PySide6.QtCore.Qt.HighDpiScaleFactorRoundingPolicy) -> None: ...
    @staticmethod
    def setLayoutDirection(direction: PySide6.QtCore.Qt.LayoutDirection) -> None: ...
    @staticmethod
    def setOverrideCursor(arg__1: PySide6.QtGui.QCursor | PySide6.QtCore.Qt.CursorShape | PySide6.QtGui.QPixmap) -> object: ...
    @staticmethod
    def setPalette(pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor) -> None: ...
    @staticmethod
    def setQuitOnLastWindowClosed(quit: bool) -> None: ...
    @staticmethod
    def setWindowIcon(icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap) -> None: ...
    @staticmethod
    def styleHints() -> PySide6.QtGui.QStyleHints: ...
    @staticmethod
    def sync() -> None: ...
    @staticmethod
    def topLevelAt(pos: PySide6.QtCore.QPoint) -> PySide6.QtGui.QWindow: ...
    @staticmethod
    def topLevelWindows() -> typing.List[PySide6.QtGui.QWindow]: ...
    @staticmethod
    def windowIcon() -> PySide6.QtGui.QIcon: ...


class QHelpEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, pos: PySide6.QtCore.QPoint, globalPos: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QHelpEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QHelpEvent: ...
    def globalPos(self) -> PySide6.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QHideEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QHideEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QHideEvent: ...


class QHoverEvent(PySide6.QtGui.QSinglePointEvent):

    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, scenePos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, globalPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, oldPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, modifiers: PySide6.QtCore.Qt.KeyboardModifier = ..., device: PySide6.QtGui.QPointingDevice = ...) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QHoverEvent) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, oldPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, modifiers: PySide6.QtCore.Qt.KeyboardModifier = ..., device: PySide6.QtGui.QPointingDevice = ...) -> None: ...

    def clone(self) -> PySide6.QtGui.QHoverEvent: ...
    def isUpdateEvent(self) -> bool: ...
    def oldPos(self) -> PySide6.QtCore.QPoint: ...
    def oldPosF(self) -> PySide6.QtCore.QPointF: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def posF(self) -> PySide6.QtCore.QPointF: ...


class QIcon(Shiboken.Object):

    class Mode(enum.Enum):

        Normal                    = ...  # 0x0
        Disabled                  = ...  # 0x1
        Active                    = ...  # 0x2
        Selected                  = ...  # 0x3

    class State(enum.Enum):

        On                        = ...  # 0x0
        Off                       = ...  # 0x1

    class ThemeIcon(enum.Enum):

        AddressBookNew            = ...  # 0x0
        ApplicationExit           = ...  # 0x1
        AppointmentNew            = ...  # 0x2
        CallStart                 = ...  # 0x3
        CallStop                  = ...  # 0x4
        ContactNew                = ...  # 0x5
        DocumentNew               = ...  # 0x6
        DocumentOpen              = ...  # 0x7
        DocumentOpenRecent        = ...  # 0x8
        DocumentPageSetup         = ...  # 0x9
        DocumentPrint             = ...  # 0xa
        DocumentPrintPreview      = ...  # 0xb
        DocumentProperties        = ...  # 0xc
        DocumentRevert            = ...  # 0xd
        DocumentSave              = ...  # 0xe
        DocumentSaveAs            = ...  # 0xf
        DocumentSend              = ...  # 0x10
        EditClear                 = ...  # 0x11
        EditCopy                  = ...  # 0x12
        EditCut                   = ...  # 0x13
        EditDelete                = ...  # 0x14
        EditFind                  = ...  # 0x15
        EditPaste                 = ...  # 0x16
        EditRedo                  = ...  # 0x17
        EditSelectAll             = ...  # 0x18
        EditUndo                  = ...  # 0x19
        FolderNew                 = ...  # 0x1a
        FormatIndentLess          = ...  # 0x1b
        FormatIndentMore          = ...  # 0x1c
        FormatJustifyCenter       = ...  # 0x1d
        FormatJustifyFill         = ...  # 0x1e
        FormatJustifyLeft         = ...  # 0x1f
        FormatJustifyRight        = ...  # 0x20
        FormatTextDirectionLtr    = ...  # 0x21
        FormatTextDirectionRtl    = ...  # 0x22
        FormatTextBold            = ...  # 0x23
        FormatTextItalic          = ...  # 0x24
        FormatTextUnderline       = ...  # 0x25
        FormatTextStrikethrough   = ...  # 0x26
        GoDown                    = ...  # 0x27
        GoHome                    = ...  # 0x28
        GoNext                    = ...  # 0x29
        GoPrevious                = ...  # 0x2a
        GoUp                      = ...  # 0x2b
        HelpAbout                 = ...  # 0x2c
        HelpFaq                   = ...  # 0x2d
        InsertImage               = ...  # 0x2e
        InsertLink                = ...  # 0x2f
        InsertText                = ...  # 0x30
        ListAdd                   = ...  # 0x31
        ListRemove                = ...  # 0x32
        MailForward               = ...  # 0x33
        MailMarkImportant         = ...  # 0x34
        MailMarkRead              = ...  # 0x35
        MailMarkUnread            = ...  # 0x36
        MailMessageNew            = ...  # 0x37
        MailReplyAll              = ...  # 0x38
        MailReplySender           = ...  # 0x39
        MailSend                  = ...  # 0x3a
        MediaEject                = ...  # 0x3b
        MediaPlaybackPause        = ...  # 0x3c
        MediaPlaybackStart        = ...  # 0x3d
        MediaPlaybackStop         = ...  # 0x3e
        MediaRecord               = ...  # 0x3f
        MediaSeekBackward         = ...  # 0x40
        MediaSeekForward          = ...  # 0x41
        MediaSkipBackward         = ...  # 0x42
        MediaSkipForward          = ...  # 0x43
        ObjectRotateLeft          = ...  # 0x44
        ObjectRotateRight         = ...  # 0x45
        ProcessStop               = ...  # 0x46
        SystemLockScreen          = ...  # 0x47
        SystemLogOut              = ...  # 0x48
        SystemSearch              = ...  # 0x49
        SystemReboot              = ...  # 0x4a
        SystemShutdown            = ...  # 0x4b
        ToolsCheckSpelling        = ...  # 0x4c
        ViewFullscreen            = ...  # 0x4d
        ViewRefresh               = ...  # 0x4e
        ViewRestore               = ...  # 0x4f
        WindowClose               = ...  # 0x50
        WindowNew                 = ...  # 0x51
        ZoomFitBest               = ...  # 0x52
        ZoomIn                    = ...  # 0x53
        ZoomOut                   = ...  # 0x54
        AudioCard                 = ...  # 0x55
        AudioInputMicrophone      = ...  # 0x56
        Battery                   = ...  # 0x57
        CameraPhoto               = ...  # 0x58
        CameraVideo               = ...  # 0x59
        CameraWeb                 = ...  # 0x5a
        Computer                  = ...  # 0x5b
        DriveHarddisk             = ...  # 0x5c
        DriveOptical              = ...  # 0x5d
        InputGaming               = ...  # 0x5e
        InputKeyboard             = ...  # 0x5f
        InputMouse                = ...  # 0x60
        InputTablet               = ...  # 0x61
        MediaFlash                = ...  # 0x62
        MediaOptical              = ...  # 0x63
        MediaTape                 = ...  # 0x64
        MultimediaPlayer          = ...  # 0x65
        NetworkWired              = ...  # 0x66
        NetworkWireless           = ...  # 0x67
        Phone                     = ...  # 0x68
        Printer                   = ...  # 0x69
        Scanner                   = ...  # 0x6a
        VideoDisplay              = ...  # 0x6b
        AppointmentMissed         = ...  # 0x6c
        AppointmentSoon           = ...  # 0x6d
        AudioVolumeHigh           = ...  # 0x6e
        AudioVolumeLow            = ...  # 0x6f
        AudioVolumeMedium         = ...  # 0x70
        AudioVolumeMuted          = ...  # 0x71
        BatteryCaution            = ...  # 0x72
        BatteryLow                = ...  # 0x73
        DialogError               = ...  # 0x74
        DialogInformation         = ...  # 0x75
        DialogPassword            = ...  # 0x76
        DialogQuestion            = ...  # 0x77
        DialogWarning             = ...  # 0x78
        FolderDragAccept          = ...  # 0x79
        FolderOpen                = ...  # 0x7a
        FolderVisiting            = ...  # 0x7b
        ImageLoading              = ...  # 0x7c
        ImageMissing              = ...  # 0x7d
        MailAttachment            = ...  # 0x7e
        MailUnread                = ...  # 0x7f
        MailRead                  = ...  # 0x80
        MailReplied               = ...  # 0x81
        MediaPlaylistRepeat       = ...  # 0x82
        MediaPlaylistShuffle      = ...  # 0x83
        NetworkOffline            = ...  # 0x84
        PrinterPrinting           = ...  # 0x85
        SecurityHigh              = ...  # 0x86
        SecurityLow               = ...  # 0x87
        SoftwareUpdateAvailable   = ...  # 0x88
        SoftwareUpdateUrgent      = ...  # 0x89
        SyncError                 = ...  # 0x8a
        SyncSynchronizing         = ...  # 0x8b
        UserAvailable             = ...  # 0x8c
        UserOffline               = ...  # 0x8d
        WeatherClear              = ...  # 0x8e
        WeatherClearNight         = ...  # 0x8f
        WeatherFewClouds          = ...  # 0x90
        WeatherFewCloudsNight     = ...  # 0x91
        WeatherFog                = ...  # 0x92
        WeatherShowers            = ...  # 0x93
        WeatherSnow               = ...  # 0x94
        WeatherStorm              = ...  # 0x95
        NThemeIcons               = ...  # 0x96


    @typing.overload
    def __init__(self, engine: PySide6.QtGui.QIconEngine) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QIcon) -> None: ...
    @typing.overload
    def __init__(self, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName: str) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def actualSize(self, window: PySide6.QtGui.QWindow, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtCore.QSize: ...
    @typing.overload
    def actualSize(self, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtCore.QSize: ...
    def addFile(self, fileName: str, size: PySide6.QtCore.QSize = ..., mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> None: ...
    @typing.overload
    def addPixmap(self, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> None: ...
    @typing.overload
    def addPixmap(self, path: str | bytes | os.PathLike[str]) -> None: ...
    def availableSizes(self, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> typing.List[PySide6.QtCore.QSize]: ...
    def cacheKey(self) -> int: ...
    @staticmethod
    def fallbackSearchPaths() -> typing.List[str]: ...
    @staticmethod
    def fallbackThemeName() -> str: ...
    @typing.overload
    @staticmethod
    def fromTheme(icon: PySide6.QtGui.QIcon.ThemeIcon) -> PySide6.QtGui.QIcon: ...
    @typing.overload
    @staticmethod
    def fromTheme(name: str, fallback: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap) -> PySide6.QtGui.QIcon: ...
    @typing.overload
    @staticmethod
    def fromTheme(icon: PySide6.QtGui.QIcon.ThemeIcon, fallback: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap) -> PySide6.QtGui.QIcon: ...
    @typing.overload
    @staticmethod
    def fromTheme(name: str) -> PySide6.QtGui.QIcon: ...
    @typing.overload
    @staticmethod
    def hasThemeIcon(icon: PySide6.QtGui.QIcon.ThemeIcon) -> bool: ...
    @typing.overload
    @staticmethod
    def hasThemeIcon(name: str) -> bool: ...
    def isMask(self) -> bool: ...
    def isNull(self) -> bool: ...
    def name(self) -> str: ...
    @typing.overload
    def paint(self, painter: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, alignment: PySide6.QtCore.Qt.AlignmentFlag = ..., mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> None: ...
    @typing.overload
    def paint(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, alignment: PySide6.QtCore.Qt.AlignmentFlag = ..., mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> None: ...
    @typing.overload
    def pixmap(self, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    def pixmap(self, w: int, h: int, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    def pixmap(self, extent: int, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    def pixmap(self, size: PySide6.QtCore.QSize, devicePixelRatio: float, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    def pixmap(self, window: PySide6.QtGui.QWindow, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> PySide6.QtGui.QPixmap: ...
    @staticmethod
    def setFallbackSearchPaths(paths: typing.Sequence[str]) -> None: ...
    @staticmethod
    def setFallbackThemeName(name: str) -> None: ...
    def setIsMask(self, isMask: bool) -> None: ...
    @staticmethod
    def setThemeName(path: str) -> None: ...
    @staticmethod
    def setThemeSearchPaths(searchpath: typing.Sequence[str]) -> None: ...
    def swap(self, other: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap) -> None: ...
    @staticmethod
    def themeName() -> str: ...
    @staticmethod
    def themeSearchPaths() -> typing.List[str]: ...


class QIconDragEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QIconDragEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QIconDragEvent: ...


class QIconEngine(Shiboken.Object):

    class IconEngineHook(enum.Enum):

        IsNullHook                = ...  # 0x3
        ScaledPixmapHook          = ...  # 0x4

    class ScaledPixmapArgument(Shiboken.Object):

        def __init__(self) -> None: ...


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QIconEngine) -> None: ...

    def actualSize(self, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode, state: PySide6.QtGui.QIcon.State) -> PySide6.QtCore.QSize: ...
    def addFile(self, fileName: str, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode, state: PySide6.QtGui.QIcon.State) -> None: ...
    def addPixmap(self, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, mode: PySide6.QtGui.QIcon.Mode, state: PySide6.QtGui.QIcon.State) -> None: ...
    def availableSizes(self, mode: PySide6.QtGui.QIcon.Mode = ..., state: PySide6.QtGui.QIcon.State = ...) -> typing.List[PySide6.QtCore.QSize]: ...
    def clone(self) -> PySide6.QtGui.QIconEngine: ...
    def iconName(self) -> str: ...
    def isNull(self) -> bool: ...
    def key(self) -> str: ...
    def paint(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, mode: PySide6.QtGui.QIcon.Mode, state: PySide6.QtGui.QIcon.State) -> None: ...
    def pixmap(self, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode, state: PySide6.QtGui.QIcon.State) -> PySide6.QtGui.QPixmap: ...
    def read(self, in_: PySide6.QtCore.QDataStream) -> bool: ...
    def scaledPixmap(self, size: PySide6.QtCore.QSize, mode: PySide6.QtGui.QIcon.Mode, state: PySide6.QtGui.QIcon.State, scale: float) -> PySide6.QtGui.QPixmap: ...
    def write(self, out: PySide6.QtCore.QDataStream) -> bool: ...


class ScaledPixmapArgument(Shiboken.Object):

    def __init__(self) -> None: ...


class QImage(PySide6.QtGui.QPaintDevice):

    class Format(enum.Enum):

        Format_Invalid            = ...  # 0x0
        Format_Mono               = ...  # 0x1
        Format_MonoLSB            = ...  # 0x2
        Format_Indexed8           = ...  # 0x3
        Format_RGB32              = ...  # 0x4
        Format_ARGB32             = ...  # 0x5
        Format_ARGB32_Premultiplied = ...  # 0x6
        Format_RGB16              = ...  # 0x7
        Format_ARGB8565_Premultiplied = ...  # 0x8
        Format_RGB666             = ...  # 0x9
        Format_ARGB6666_Premultiplied = ...  # 0xa
        Format_RGB555             = ...  # 0xb
        Format_ARGB8555_Premultiplied = ...  # 0xc
        Format_RGB888             = ...  # 0xd
        Format_RGB444             = ...  # 0xe
        Format_ARGB4444_Premultiplied = ...  # 0xf
        Format_RGBX8888           = ...  # 0x10
        Format_RGBA8888           = ...  # 0x11
        Format_RGBA8888_Premultiplied = ...  # 0x12
        Format_BGR30              = ...  # 0x13
        Format_A2BGR30_Premultiplied = ...  # 0x14
        Format_RGB30              = ...  # 0x15
        Format_A2RGB30_Premultiplied = ...  # 0x16
        Format_Alpha8             = ...  # 0x17
        Format_Grayscale8         = ...  # 0x18
        Format_RGBX64             = ...  # 0x19
        Format_RGBA64             = ...  # 0x1a
        Format_RGBA64_Premultiplied = ...  # 0x1b
        Format_Grayscale16        = ...  # 0x1c
        Format_BGR888             = ...  # 0x1d
        Format_RGBX16FPx4         = ...  # 0x1e
        Format_RGBA16FPx4         = ...  # 0x1f
        Format_RGBA16FPx4_Premultiplied = ...  # 0x20
        Format_RGBX32FPx4         = ...  # 0x21
        Format_RGBA32FPx4         = ...  # 0x22
        Format_RGBA32FPx4_Premultiplied = ...  # 0x23
        Format_CMYK8888           = ...  # 0x24
        NImageFormats             = ...  # 0x25

    class InvertMode(enum.Enum):

        InvertRgb                 = ...  # 0x0
        InvertRgba                = ...  # 0x1


    @typing.overload
    def __init__(self, width: int, height: int, format: PySide6.QtGui.QImage.Format) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName: str | bytes | os.PathLike[str], format: bytes | bytearray | memoryview | None= ...) -> None: ...
    @typing.overload
    def __init__(self, xpm: typing.Iterable) -> None: ...
    @typing.overload
    def __init__(self, arg__1: str, arg__2: int, arg__3: int, arg__4: int, arg__5: PySide6.QtGui.QImage.Format) -> None: ...
    @typing.overload
    def __init__(self, arg__1: str, arg__2: int, arg__3: int, arg__4: PySide6.QtGui.QImage.Format) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, data: bytes | bytearray | memoryview, width: int, height: int, format: PySide6.QtGui.QImage.Format, cleanupFunction: typing.Callable | None= ..., cleanupInfo: int | None= ...) -> None: ...
    @typing.overload
    def __init__(self, size: PySide6.QtCore.QSize, format: PySide6.QtGui.QImage.Format) -> None: ...
    @typing.overload
    def __init__(self, data: bytes | bytearray | memoryview, width: int, height: int, bytesPerLine: int, format: PySide6.QtGui.QImage.Format, cleanupFunction: typing.Callable | None= ..., cleanupInfo: int | None= ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def allGray(self) -> bool: ...
    @typing.overload
    def applyColorTransform(self, transform: PySide6.QtGui.QColorTransform, format: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @typing.overload
    def applyColorTransform(self, transform: PySide6.QtGui.QColorTransform) -> None: ...
    def bitPlaneCount(self) -> int: ...
    def bits(self) -> bytes | bytearray | memoryview: ...
    def bytesPerLine(self) -> int: ...
    def cacheKey(self) -> int: ...
    def color(self, i: int) -> int: ...
    def colorCount(self) -> int: ...
    def colorSpace(self) -> PySide6.QtGui.QColorSpace: ...
    def colorTable(self) -> typing.List[int]: ...
    @typing.overload
    def colorTransformed(self, transform: PySide6.QtGui.QColorTransform) -> PySide6.QtGui.QImage: ...
    @typing.overload
    def colorTransformed(self, transform: PySide6.QtGui.QColorTransform, format: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QImage: ...
    def constBits(self) -> bytes | bytearray | memoryview: ...
    def constScanLine(self, arg__1: int) -> object: ...
    def convertTo(self, f: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @typing.overload
    def convertToColorSpace(self, colorSpace: PySide6.QtGui.QColorSpace | PySide6.QtGui.QColorSpace.NamedColorSpace) -> None: ...
    @typing.overload
    def convertToColorSpace(self, colorSpace: PySide6.QtGui.QColorSpace | PySide6.QtGui.QColorSpace.NamedColorSpace, format: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @typing.overload
    def convertToFormat(self, f: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QImage: ...
    @typing.overload
    def convertToFormat(self, f: PySide6.QtGui.QImage.Format, colorTable: typing.Sequence[int], flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QImage: ...
    def convertToFormat_helper(self, format: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag) -> PySide6.QtGui.QImage: ...
    def convertToFormat_inplace(self, format: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag) -> bool: ...
    def convertedTo(self, f: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QImage: ...
    @typing.overload
    def convertedToColorSpace(self, colorSpace: PySide6.QtGui.QColorSpace | PySide6.QtGui.QColorSpace.NamedColorSpace, format: PySide6.QtGui.QImage.Format, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QImage: ...
    @typing.overload
    def convertedToColorSpace(self, colorSpace: PySide6.QtGui.QColorSpace | PySide6.QtGui.QColorSpace.NamedColorSpace) -> PySide6.QtGui.QImage: ...
    @typing.overload
    def copy(self, rect: PySide6.QtCore.QRect = ...) -> PySide6.QtGui.QImage: ...
    @typing.overload
    def copy(self, x: int, y: int, w: int, h: int) -> PySide6.QtGui.QImage: ...
    def createAlphaMask(self, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QImage: ...
    def createHeuristicMask(self, clipTight: bool = ...) -> PySide6.QtGui.QImage: ...
    def createMaskFromColor(self, color: int, mode: PySide6.QtCore.Qt.MaskMode = ...) -> PySide6.QtGui.QImage: ...
    def depth(self) -> int: ...
    def detachMetadata(self, invalidateCache: bool = ...) -> None: ...
    def devType(self) -> int: ...
    def deviceIndependentSize(self) -> PySide6.QtCore.QSizeF: ...
    def devicePixelRatio(self) -> float: ...
    def dotsPerMeterX(self) -> int: ...
    def dotsPerMeterY(self) -> int: ...
    @typing.overload
    def fill(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    @typing.overload
    def fill(self, color: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def fill(self, pixel: int) -> None: ...
    def format(self) -> PySide6.QtGui.QImage.Format: ...
    @staticmethod
    def fromData(data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, format: bytes | bytearray | memoryview | None= ...) -> PySide6.QtGui.QImage: ...
    def hasAlphaChannel(self) -> bool: ...
    def height(self) -> int: ...
    def invertPixels(self, mode: PySide6.QtGui.QImage.InvertMode = ...) -> None: ...
    def isGrayscale(self) -> bool: ...
    def isNull(self) -> bool: ...
    @typing.overload
    def load(self, device: PySide6.QtCore.QIODevice, format: bytes | bytearray | memoryview) -> bool: ...
    @typing.overload
    def load(self, fileName: str, format: bytes | bytearray | memoryview | None= ...) -> bool: ...
    def loadFromData(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, format: bytes | bytearray | memoryview | None= ...) -> bool: ...
    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def mirror(self, horizontally: bool = ..., vertically: bool = ...) -> None: ...
    def mirrored(self, horizontally: bool = ..., vertically: bool = ...) -> PySide6.QtGui.QImage: ...
    def mirrored_helper(self, horizontal: bool, vertical: bool) -> PySide6.QtGui.QImage: ...
    def mirrored_inplace(self, horizontal: bool, vertical: bool) -> None: ...
    def offset(self) -> PySide6.QtCore.QPoint: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    @typing.overload
    def pixel(self, x: int, y: int) -> int: ...
    @typing.overload
    def pixel(self, pt: PySide6.QtCore.QPoint) -> int: ...
    @typing.overload
    def pixelColor(self, pt: PySide6.QtCore.QPoint) -> PySide6.QtGui.QColor: ...
    @typing.overload
    def pixelColor(self, x: int, y: int) -> PySide6.QtGui.QColor: ...
    def pixelFormat(self) -> PySide6.QtGui.QPixelFormat: ...
    @typing.overload
    def pixelIndex(self, x: int, y: int) -> int: ...
    @typing.overload
    def pixelIndex(self, pt: PySide6.QtCore.QPoint) -> int: ...
    def rect(self) -> PySide6.QtCore.QRect: ...
    def reinterpretAsFormat(self, f: PySide6.QtGui.QImage.Format) -> bool: ...
    def rgbSwap(self) -> None: ...
    def rgbSwapped(self) -> PySide6.QtGui.QImage: ...
    def rgbSwapped_helper(self) -> PySide6.QtGui.QImage: ...
    def rgbSwapped_inplace(self) -> None: ...
    @typing.overload
    def save(self, device: PySide6.QtCore.QIODevice, format: bytes | bytearray | memoryview | None= ..., quality: int = ...) -> bool: ...
    @typing.overload
    def save(self, fileName: str, format: bytes | bytearray | memoryview | None= ..., quality: int = ...) -> bool: ...
    @typing.overload
    def scaled(self, w: int, h: int, aspectMode: PySide6.QtCore.Qt.AspectRatioMode = ..., mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QImage: ...
    @typing.overload
    def scaled(self, s: PySide6.QtCore.QSize, aspectMode: PySide6.QtCore.Qt.AspectRatioMode = ..., mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QImage: ...
    def scaledToHeight(self, h: int, mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QImage: ...
    def scaledToWidth(self, w: int, mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QImage: ...
    def scanLine(self, arg__1: int) -> object: ...
    def setAlphaChannel(self, alphaChannel: PySide6.QtGui.QImage) -> None: ...
    def setColor(self, i: int, c: int) -> None: ...
    def setColorCount(self, arg__1: int) -> None: ...
    def setColorSpace(self, colorSpace: PySide6.QtGui.QColorSpace | PySide6.QtGui.QColorSpace.NamedColorSpace) -> None: ...
    def setColorTable(self, colors: typing.Sequence[int]) -> None: ...
    def setDevicePixelRatio(self, scaleFactor: float) -> None: ...
    def setDotsPerMeterX(self, arg__1: int) -> None: ...
    def setDotsPerMeterY(self, arg__1: int) -> None: ...
    def setOffset(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def setPixel(self, pt: PySide6.QtCore.QPoint, index_or_rgb: int) -> None: ...
    @typing.overload
    def setPixel(self, x: int, y: int, index_or_rgb: int) -> None: ...
    @typing.overload
    def setPixelColor(self, x: int, y: int, c: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    @typing.overload
    def setPixelColor(self, pt: PySide6.QtCore.QPoint, c: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    def setText(self, key: str, value: str) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def sizeInBytes(self) -> int: ...
    def smoothScaled(self, w: int, h: int) -> PySide6.QtGui.QImage: ...
    def swap(self, other: PySide6.QtGui.QImage) -> None: ...
    def text(self, key: str = ...) -> str: ...
    def textKeys(self) -> typing.List[str]: ...
    @staticmethod
    def toImageFormat(format: PySide6.QtGui.QPixelFormat) -> PySide6.QtGui.QImage.Format: ...
    @staticmethod
    def toPixelFormat(format: PySide6.QtGui.QImage.Format) -> PySide6.QtGui.QPixelFormat: ...
    def transformed(self, matrix: PySide6.QtGui.QTransform, mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QImage: ...
    @staticmethod
    def trueMatrix(arg__1: PySide6.QtGui.QTransform, w: int, h: int) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    def valid(self, x: int, y: int) -> bool: ...
    @typing.overload
    def valid(self, pt: PySide6.QtCore.QPoint) -> bool: ...
    def width(self) -> int: ...


class QImageIOHandler(Shiboken.Object):

    class ImageOption(enum.Enum):

        Size                      = ...  # 0x0
        ClipRect                  = ...  # 0x1
        Description               = ...  # 0x2
        ScaledClipRect            = ...  # 0x3
        ScaledSize                = ...  # 0x4
        CompressionRatio          = ...  # 0x5
        Gamma                     = ...  # 0x6
        Quality                   = ...  # 0x7
        Name                      = ...  # 0x8
        SubType                   = ...  # 0x9
        IncrementalReading        = ...  # 0xa
        Endianness                = ...  # 0xb
        Animation                 = ...  # 0xc
        BackgroundColor           = ...  # 0xd
        ImageFormat               = ...  # 0xe
        SupportedSubTypes         = ...  # 0xf
        OptimizedWrite            = ...  # 0x10
        ProgressiveScanWrite      = ...  # 0x11
        ImageTransformation       = ...  # 0x12

    class Transformation(enum.Flag):

        TransformationNone        = ...  # 0x0
        TransformationMirror      = ...  # 0x1
        TransformationFlip        = ...  # 0x2
        TransformationRotate180   = ...  # 0x3
        TransformationRotate90    = ...  # 0x4
        TransformationMirrorAndRotate90 = ...  # 0x5
        TransformationFlipAndRotate90 = ...  # 0x6
        TransformationRotate270   = ...  # 0x7


    def __init__(self) -> None: ...

    @staticmethod
    def allocateImage(size: PySide6.QtCore.QSize, format: PySide6.QtGui.QImage.Format, image: PySide6.QtGui.QImage) -> bool: ...
    def canRead(self) -> bool: ...
    def currentImageNumber(self) -> int: ...
    def currentImageRect(self) -> PySide6.QtCore.QRect: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def format(self) -> PySide6.QtCore.QByteArray: ...
    def imageCount(self) -> int: ...
    def jumpToImage(self, imageNumber: int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    def loopCount(self) -> int: ...
    def nextImageDelay(self) -> int: ...
    def option(self, option: PySide6.QtGui.QImageIOHandler.ImageOption) -> typing.Any: ...
    def read(self, image: PySide6.QtGui.QImage) -> bool: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def setFormat(self, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    def setOption(self, option: PySide6.QtGui.QImageIOHandler.ImageOption, value: typing.Any) -> None: ...
    def supportsOption(self, option: PySide6.QtGui.QImageIOHandler.ImageOption) -> bool: ...
    def write(self, image: PySide6.QtGui.QImage) -> bool: ...


class QImageReader(Shiboken.Object):

    class ImageReaderError(enum.Enum):

        UnknownError              = ...  # 0x0
        FileNotFoundError         = ...  # 0x1
        DeviceError               = ...  # 0x2
        UnsupportedFormatError    = ...  # 0x3
        InvalidDataError          = ...  # 0x4


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device: PySide6.QtCore.QIODevice, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ...) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ...) -> None: ...

    @staticmethod
    def allocationLimit() -> int: ...
    def autoDetectImageFormat(self) -> bool: ...
    def autoTransform(self) -> bool: ...
    def backgroundColor(self) -> PySide6.QtGui.QColor: ...
    def canRead(self) -> bool: ...
    def clipRect(self) -> PySide6.QtCore.QRect: ...
    def currentImageNumber(self) -> int: ...
    def currentImageRect(self) -> PySide6.QtCore.QRect: ...
    def decideFormatFromContent(self) -> bool: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def error(self) -> PySide6.QtGui.QImageReader.ImageReaderError: ...
    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide6.QtCore.QByteArray: ...
    def imageCount(self) -> int: ...
    @typing.overload    # type: ignore[misc]
    @staticmethod
    def imageFormat(device: PySide6.QtCore.QIODevice) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def imageFormat(self) -> PySide6.QtGui.QImage.Format: ...
    @typing.overload
    @staticmethod
    def imageFormat(fileName: str) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def imageFormatsForMimeType(mimeType: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> typing.List[PySide6.QtCore.QByteArray]: ...
    def jumpToImage(self, imageNumber: int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    def loopCount(self) -> int: ...
    def nextImageDelay(self) -> int: ...
    def quality(self) -> int: ...
    def read(self) -> PySide6.QtGui.QImage: ...
    def scaledClipRect(self) -> PySide6.QtCore.QRect: ...
    def scaledSize(self) -> PySide6.QtCore.QSize: ...
    @staticmethod
    def setAllocationLimit(mbLimit: int) -> None: ...
    def setAutoDetectImageFormat(self, enabled: bool) -> None: ...
    def setAutoTransform(self, enabled: bool) -> None: ...
    def setBackgroundColor(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    def setClipRect(self, rect: PySide6.QtCore.QRect) -> None: ...
    def setDecideFormatFromContent(self, ignored: bool) -> None: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setFormat(self, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    def setQuality(self, quality: int) -> None: ...
    def setScaledClipRect(self, rect: PySide6.QtCore.QRect) -> None: ...
    def setScaledSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def subType(self) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def supportedImageFormats() -> typing.List[PySide6.QtCore.QByteArray]: ...
    @staticmethod
    def supportedMimeTypes() -> typing.List[PySide6.QtCore.QByteArray]: ...
    def supportedSubTypes(self) -> typing.List[PySide6.QtCore.QByteArray]: ...
    def supportsAnimation(self) -> bool: ...
    def supportsOption(self, option: PySide6.QtGui.QImageIOHandler.ImageOption) -> bool: ...
    def text(self, key: str) -> str: ...
    def textKeys(self) -> typing.List[str]: ...
    def transformation(self) -> PySide6.QtGui.QImageIOHandler.Transformation: ...


class QImageWriter(Shiboken.Object):

    class ImageWriterError(enum.Enum):

        UnknownError              = ...  # 0x0
        DeviceError               = ...  # 0x1
        UnsupportedFormatError    = ...  # 0x2
        InvalidImageError         = ...  # 0x3


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ...) -> None: ...
    @typing.overload
    def __init__(self, device: PySide6.QtCore.QIODevice, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...

    def canWrite(self) -> bool: ...
    def compression(self) -> int: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def error(self) -> PySide6.QtGui.QImageWriter.ImageWriterError: ...
    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def imageFormatsForMimeType(mimeType: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> typing.List[PySide6.QtCore.QByteArray]: ...
    def optimizedWrite(self) -> bool: ...
    def progressiveScanWrite(self) -> bool: ...
    def quality(self) -> int: ...
    def setCompression(self, compression: int) -> None: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setFormat(self, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    def setOptimizedWrite(self, optimize: bool) -> None: ...
    def setProgressiveScanWrite(self, progressive: bool) -> None: ...
    def setQuality(self, quality: int) -> None: ...
    def setSubType(self, type: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    def setText(self, key: str, text: str) -> None: ...
    def setTransformation(self, orientation: PySide6.QtGui.QImageIOHandler.Transformation) -> None: ...
    def subType(self) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def supportedImageFormats() -> typing.List[PySide6.QtCore.QByteArray]: ...
    @staticmethod
    def supportedMimeTypes() -> typing.List[PySide6.QtCore.QByteArray]: ...
    def supportedSubTypes(self) -> typing.List[PySide6.QtCore.QByteArray]: ...
    def supportsOption(self, option: PySide6.QtGui.QImageIOHandler.ImageOption) -> bool: ...
    def transformation(self) -> PySide6.QtGui.QImageIOHandler.Transformation: ...
    def write(self, image: PySide6.QtGui.QImage) -> bool: ...


class QInputDevice(PySide6.QtCore.QObject):

    availableVirtualGeometryChanged: typing.ClassVar[Signal] = ... # availableVirtualGeometryChanged(QRect)

    class Capability(enum.Flag):

        None_                     = ...  # 0x0
        Position                  = ...  # 0x1
        Area                      = ...  # 0x2
        Pressure                  = ...  # 0x4
        Velocity                  = ...  # 0x8
        NormalizedPosition        = ...  # 0x20
        MouseEmulation            = ...  # 0x40
        PixelScroll               = ...  # 0x80
        Scroll                    = ...  # 0x100
        Hover                     = ...  # 0x200
        Rotation                  = ...  # 0x400
        XTilt                     = ...  # 0x800
        YTilt                     = ...  # 0x1000
        TangentialPressure        = ...  # 0x2000
        ZPosition                 = ...  # 0x4000
        All                       = ...  # 0x7fffffff

    class DeviceType(enum.Flag):

        Unknown                   = ...  # 0x0
        Mouse                     = ...  # 0x1
        TouchScreen               = ...  # 0x2
        TouchPad                  = ...  # 0x4
        Puck                      = ...  # 0x8
        Stylus                    = ...  # 0x10
        Airbrush                  = ...  # 0x20
        Keyboard                  = ...  # 0x1000
        AllDevices                = ...  # 0x7fffffff


    @typing.overload
    def __init__(self, name: str, systemId: int, type: PySide6.QtGui.QInputDevice.DeviceType, seatName: str = ..., parent: PySide6.QtCore.QObject | None= ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def availableVirtualGeometry(self) -> PySide6.QtCore.QRect: ...
    def capabilities(self) -> PySide6.QtGui.QInputDevice.Capability: ...
    @staticmethod
    def devices() -> typing.List[PySide6.QtGui.QInputDevice]: ...
    def hasCapability(self, cap: PySide6.QtGui.QInputDevice.Capability) -> bool: ...
    def name(self) -> str: ...
    @staticmethod
    def primaryKeyboard(seatName: str = ...) -> PySide6.QtGui.QInputDevice: ...
    def seatName(self) -> str: ...
    @staticmethod
    def seatNames() -> typing.List[str]: ...
    def systemId(self) -> int: ...
    def type(self) -> PySide6.QtGui.QInputDevice.DeviceType: ...


class QInputEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QInputEvent) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, m_dev: PySide6.QtGui.QInputDevice, modifiers: PySide6.QtCore.Qt.KeyboardModifier = ...) -> None: ...

    def clone(self) -> PySide6.QtGui.QInputEvent: ...
    def device(self) -> PySide6.QtGui.QInputDevice: ...
    def deviceType(self) -> PySide6.QtGui.QInputDevice.DeviceType: ...
    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> None: ...
    def setTimestamp(self, timestamp: int) -> None: ...
    def timestamp(self) -> int: ...


class QInputMethod(PySide6.QtCore.QObject):

    anchorRectangleChanged   : typing.ClassVar[Signal] = ... # anchorRectangleChanged()
    animatingChanged         : typing.ClassVar[Signal] = ... # animatingChanged()
    cursorRectangleChanged   : typing.ClassVar[Signal] = ... # cursorRectangleChanged()
    inputDirectionChanged    : typing.ClassVar[Signal] = ... # inputDirectionChanged(Qt::LayoutDirection)
    inputItemClipRectangleChanged: typing.ClassVar[Signal] = ... # inputItemClipRectangleChanged()
    keyboardRectangleChanged : typing.ClassVar[Signal] = ... # keyboardRectangleChanged()
    localeChanged            : typing.ClassVar[Signal] = ... # localeChanged()
    visibleChanged           : typing.ClassVar[Signal] = ... # visibleChanged()

    class Action(enum.Enum):

        Click                     = ...  # 0x0
        ContextMenu               = ...  # 0x1


    def anchorRectangle(self) -> PySide6.QtCore.QRectF: ...
    def commit(self) -> None: ...
    def cursorRectangle(self) -> PySide6.QtCore.QRectF: ...
    def hide(self) -> None: ...
    def inputDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def inputItemClipRectangle(self) -> PySide6.QtCore.QRectF: ...
    def inputItemRectangle(self) -> PySide6.QtCore.QRectF: ...
    def inputItemTransform(self) -> PySide6.QtGui.QTransform: ...
    def invokeAction(self, a: PySide6.QtGui.QInputMethod.Action, cursorPosition: int) -> None: ...
    def isAnimating(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def keyboardRectangle(self) -> PySide6.QtCore.QRectF: ...
    def locale(self) -> PySide6.QtCore.QLocale: ...
    @staticmethod
    def queryFocusObject(query: PySide6.QtCore.Qt.InputMethodQuery, argument: typing.Any) -> typing.Any: ...
    def reset(self) -> None: ...
    def setInputItemRectangle(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    def setInputItemTransform(self, transform: PySide6.QtGui.QTransform) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def show(self) -> None: ...
    def update(self, queries: PySide6.QtCore.Qt.InputMethodQuery) -> None: ...


class QInputMethodEvent(PySide6.QtCore.QEvent):

    class Attribute(Shiboken.Object):

        @typing.overload
        def __init__(self, typ: PySide6.QtGui.QInputMethodEvent.AttributeType, s: int, l: int, val: typing.Any) -> None: ...
        @typing.overload
        def __init__(self, typ: PySide6.QtGui.QInputMethodEvent.AttributeType, s: int, l: int) -> None: ...
        @typing.overload
        def __init__(self, Attribute: PySide6.QtGui.QInputMethodEvent.Attribute) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class AttributeType(enum.Enum):

        TextFormat                = ...  # 0x0
        Cursor                    = ...  # 0x1
        Language                  = ...  # 0x2
        Ruby                      = ...  # 0x3
        Selection                 = ...  # 0x4


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, preeditText: str, attributes: typing.Sequence[PySide6.QtGui.QInputMethodEvent.Attribute]) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QInputMethodEvent) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def attributes(self) -> typing.List[PySide6.QtGui.QInputMethodEvent.Attribute]: ...
    def clone(self) -> PySide6.QtGui.QInputMethodEvent: ...
    def commitString(self) -> str: ...
    def preeditString(self) -> str: ...
    def replacementLength(self) -> int: ...
    def replacementStart(self) -> int: ...
    def setCommitString(self, commitString: str, replaceFrom: int = ..., replaceLength: int = ...) -> None: ...


class Attribute(Shiboken.Object):

    @typing.overload
    def __init__(self, typ: PySide6.QtGui.QInputMethodEvent.AttributeType, s: int, l: int, val: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, typ: PySide6.QtGui.QInputMethodEvent.AttributeType, s: int, l: int) -> None: ...
    @typing.overload
    def __init__(self, Attribute: PySide6.QtGui.QInputMethodEvent.Attribute) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QInputMethodQueryEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, queries: PySide6.QtCore.Qt.InputMethodQuery) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QInputMethodQueryEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QInputMethodQueryEvent: ...
    def queries(self) -> PySide6.QtCore.Qt.InputMethodQuery: ...
    def setValue(self, query: PySide6.QtCore.Qt.InputMethodQuery, value: typing.Any) -> None: ...
    def value(self, query: PySide6.QtCore.Qt.InputMethodQuery) -> typing.Any: ...


class QIntList(object): ...


class QIntValidator(PySide6.QtGui.QValidator):

    bottomChanged            : typing.ClassVar[Signal] = ... # bottomChanged(int)
    topChanged               : typing.ClassVar[Signal] = ... # topChanged(int)

    @typing.overload
    def __init__(self, bottom: int, top: int, parent: PySide6.QtCore.QObject | None= ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    def bottom(self) -> int: ...
    def fixup(self, input: str) -> str: ...
    def setBottom(self, arg__1: int) -> None: ...
    def setRange(self, bottom: int, top: int) -> None: ...
    def setTop(self, arg__1: int) -> None: ...
    def top(self) -> int: ...
    def validate(self, arg__1: str, arg__2: int) -> object: ...


class QKeyEvent(PySide6.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, key: int, modifiers: PySide6.QtCore.Qt.KeyboardModifier, nativeScanCode: int, nativeVirtualKey: int, nativeModifiers: int, text: str = ..., autorep: bool = ..., count: int = ..., device: PySide6.QtGui.QInputDevice = ...) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, key: int, modifiers: PySide6.QtCore.Qt.KeyboardModifier, text: str = ..., autorep: bool = ..., count: int = ...) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def clone(self) -> PySide6.QtGui.QKeyEvent: ...
    def count(self) -> int: ...
    def isAutoRepeat(self) -> bool: ...
    def key(self) -> int: ...
    def keyCombination(self) -> PySide6.QtCore.QKeyCombination: ...
    def matches(self, key: PySide6.QtGui.QKeySequence.StandardKey) -> bool: ...
    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def nativeModifiers(self) -> int: ...
    def nativeScanCode(self) -> int: ...
    def nativeVirtualKey(self) -> int: ...
    def text(self) -> str: ...


class QKeySequence(Shiboken.Object):

    class SequenceFormat(enum.Enum):

        NativeText                = ...  # 0x0
        PortableText              = ...  # 0x1

    class SequenceMatch(enum.Enum):

        NoMatch                   = ...  # 0x0
        PartialMatch              = ...  # 0x1
        ExactMatch                = ...  # 0x2

    class StandardKey(enum.Enum):

        UnknownKey                = ...  # 0x0
        HelpContents              = ...  # 0x1
        WhatsThis                 = ...  # 0x2
        Open                      = ...  # 0x3
        Close                     = ...  # 0x4
        Save                      = ...  # 0x5
        New                       = ...  # 0x6
        Delete                    = ...  # 0x7
        Cut                       = ...  # 0x8
        Copy                      = ...  # 0x9
        Paste                     = ...  # 0xa
        Undo                      = ...  # 0xb
        Redo                      = ...  # 0xc
        Back                      = ...  # 0xd
        Forward                   = ...  # 0xe
        Refresh                   = ...  # 0xf
        ZoomIn                    = ...  # 0x10
        ZoomOut                   = ...  # 0x11
        Print                     = ...  # 0x12
        AddTab                    = ...  # 0x13
        NextChild                 = ...  # 0x14
        PreviousChild             = ...  # 0x15
        Find                      = ...  # 0x16
        FindNext                  = ...  # 0x17
        FindPrevious              = ...  # 0x18
        Replace                   = ...  # 0x19
        SelectAll                 = ...  # 0x1a
        Bold                      = ...  # 0x1b
        Italic                    = ...  # 0x1c
        Underline                 = ...  # 0x1d
        MoveToNextChar            = ...  # 0x1e
        MoveToPreviousChar        = ...  # 0x1f
        MoveToNextWord            = ...  # 0x20
        MoveToPreviousWord        = ...  # 0x21
        MoveToNextLine            = ...  # 0x22
        MoveToPreviousLine        = ...  # 0x23
        MoveToNextPage            = ...  # 0x24
        MoveToPreviousPage        = ...  # 0x25
        MoveToStartOfLine         = ...  # 0x26
        MoveToEndOfLine           = ...  # 0x27
        MoveToStartOfBlock        = ...  # 0x28
        MoveToEndOfBlock          = ...  # 0x29
        MoveToStartOfDocument     = ...  # 0x2a
        MoveToEndOfDocument       = ...  # 0x2b
        SelectNextChar            = ...  # 0x2c
        SelectPreviousChar        = ...  # 0x2d
        SelectNextWord            = ...  # 0x2e
        SelectPreviousWord        = ...  # 0x2f
        SelectNextLine            = ...  # 0x30
        SelectPreviousLine        = ...  # 0x31
        SelectNextPage            = ...  # 0x32
        SelectPreviousPage        = ...  # 0x33
        SelectStartOfLine         = ...  # 0x34
        SelectEndOfLine           = ...  # 0x35
        SelectStartOfBlock        = ...  # 0x36
        SelectEndOfBlock          = ...  # 0x37
        SelectStartOfDocument     = ...  # 0x38
        SelectEndOfDocument       = ...  # 0x39
        DeleteStartOfWord         = ...  # 0x3a
        DeleteEndOfWord           = ...  # 0x3b
        DeleteEndOfLine           = ...  # 0x3c
        InsertParagraphSeparator  = ...  # 0x3d
        InsertLineSeparator       = ...  # 0x3e
        SaveAs                    = ...  # 0x3f
        Preferences               = ...  # 0x40
        Quit                      = ...  # 0x41
        FullScreen                = ...  # 0x42
        Deselect                  = ...  # 0x43
        DeleteCompleteLine        = ...  # 0x44
        Backspace                 = ...  # 0x45
        Cancel                    = ...  # 0x46


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, k1: PySide6.QtCore.QKeyCombination | PySide6.QtCore.Qt.KeyboardModifier | PySide6.QtCore.Qt.Key, k2: PySide6.QtCore.QKeyCombination | PySide6.QtCore.Qt.KeyboardModifier | PySide6.QtCore.Qt.Key= ..., k3: PySide6.QtCore.QKeyCombination | PySide6.QtCore.Qt.KeyboardModifier | PySide6.QtCore.Qt.Key= ..., k4: PySide6.QtCore.QKeyCombination | PySide6.QtCore.Qt.KeyboardModifier | PySide6.QtCore.Qt.Key= ...) -> None: ...
    @typing.overload
    def __init__(self, key: str, format: PySide6.QtGui.QKeySequence.SequenceFormat = ...) -> None: ...
    @typing.overload
    def __init__(self, k1: int, k2: int = ..., k3: int = ..., k4: int = ...) -> None: ...
    @typing.overload
    def __init__(self, ks: PySide6.QtGui.QKeySequence) -> None: ...
    @typing.overload
    def __init__(self, key: PySide6.QtGui.QKeySequence.StandardKey) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, in_: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, out: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def count(self) -> int: ...
    @staticmethod
    def fromString(str: str, format: PySide6.QtGui.QKeySequence.SequenceFormat = ...) -> PySide6.QtGui.QKeySequence: ...
    def isEmpty(self) -> bool: ...
    @staticmethod
    def keyBindings(key: PySide6.QtGui.QKeySequence.StandardKey) -> typing.List[PySide6.QtGui.QKeySequence]: ...
    @staticmethod
    def listFromString(str: str, format: PySide6.QtGui.QKeySequence.SequenceFormat = ...) -> typing.List[PySide6.QtGui.QKeySequence]: ...
    @staticmethod
    def listToString(list: typing.Sequence[PySide6.QtGui.QKeySequence], format: PySide6.QtGui.QKeySequence.SequenceFormat = ...) -> str: ...
    def matches(self, seq: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int) -> PySide6.QtGui.QKeySequence.SequenceMatch: ...
    @staticmethod
    def mnemonic(text: str) -> PySide6.QtGui.QKeySequence: ...
    def swap(self, other: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int) -> None: ...
    def toString(self, format: PySide6.QtGui.QKeySequence.SequenceFormat = ...) -> str: ...


class QLinearGradient(PySide6.QtGui.QGradient):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, xStart: float, yStart: float, xFinalStop: float, yFinalStop: float) -> None: ...
    @typing.overload
    def __init__(self, QLinearGradient: PySide6.QtGui.QLinearGradient) -> None: ...
    @typing.overload
    def __init__(self, start: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, finalStop: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def finalStop(self) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def setFinalStop(self, stop: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def setFinalStop(self, x: float, y: float) -> None: ...
    @typing.overload
    def setStart(self, x: float, y: float) -> None: ...
    @typing.overload
    def setStart(self, start: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def start(self) -> PySide6.QtCore.QPointF: ...


class QMatrix2x2(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @typing.overload
    def __init__(self, QMatrix2x2: PySide6.QtGui.QMatrix2x2) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix2x2) -> PySide6.QtGui.QMatrix2x2: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix2x2: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix2x2) -> PySide6.QtGui.QMatrix2x2: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix2x2: ...


class QMatrix2x3(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix2x3: PySide6.QtGui.QMatrix2x3) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix2x3) -> PySide6.QtGui.QMatrix2x3: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix2x3: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix2x3) -> PySide6.QtGui.QMatrix2x3: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix3x2: ...


class QMatrix2x4(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @typing.overload
    def __init__(self, QMatrix2x4: PySide6.QtGui.QMatrix2x4) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix2x4) -> PySide6.QtGui.QMatrix2x4: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix2x4: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix2x4) -> PySide6.QtGui.QMatrix2x4: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix4x2: ...


class QMatrix3x2(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @typing.overload
    def __init__(self, QMatrix3x2: PySide6.QtGui.QMatrix3x2) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix3x2) -> PySide6.QtGui.QMatrix3x2: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix3x2: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix3x2) -> PySide6.QtGui.QMatrix3x2: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix2x3: ...


class QMatrix3x3(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix3x3: PySide6.QtGui.QMatrix3x3) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix3x3) -> PySide6.QtGui.QMatrix3x3: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix3x3: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix3x3) -> PySide6.QtGui.QMatrix3x3: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix3x3: ...


class QMatrix3x4(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @typing.overload
    def __init__(self, QMatrix3x4: PySide6.QtGui.QMatrix3x4) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix3x4) -> PySide6.QtGui.QMatrix3x4: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix3x4: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix3x4) -> PySide6.QtGui.QMatrix3x4: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix4x3: ...


class QMatrix4x2(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix4x2: PySide6.QtGui.QMatrix4x2) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix4x2) -> PySide6.QtGui.QMatrix4x2: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix4x2: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix4x2) -> PySide6.QtGui.QMatrix4x2: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix2x4: ...


class QMatrix4x3(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: typing.Iterable) -> None: ...
    @typing.overload
    def __init__(self, QMatrix4x3: PySide6.QtGui.QMatrix4x3) -> None: ...

    def __call__(self, row: int, column: int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix4x3) -> PySide6.QtGui.QMatrix4x3: ...
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix4x3: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix4x3) -> PySide6.QtGui.QMatrix4x3: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def data(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix3x4: ...


class QMatrix4x4(Shiboken.Object):

    class Flag(enum.Flag):

        Identity                  = ...  # 0x0
        Translation               = ...  # 0x1
        Scale                     = ...  # 0x2
        Rotation2D                = ...  # 0x4
        Rotation                  = ...  # 0x8
        Perspective               = ...  # 0x10
        General                   = ...  # 0x1f


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, transform: PySide6.QtGui.QTransform) -> None: ...
    @typing.overload
    def __init__(self, values: typing.Iterable) -> None: ...
    @typing.overload
    def __init__(self, m11: float, m12: float, m13: float, m14: float, m21: float, m22: float, m23: float, m24: float, m31: float, m32: float, m33: float, m34: float, m41: float, m42: float, m43: float, m44: float) -> None: ...

    def __add__(self, m2: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform) -> PySide6.QtGui.QMatrix4x4: ...
    @staticmethod
    def __copy__() -> None: ...
    def __dummy(self, arg__1: typing.Sequence[float]) -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform) -> PySide6.QtGui.QMatrix4x4: ...
    @typing.overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QMatrix4x4: ...
    @typing.overload
    def __imul__(self, other: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform) -> PySide6.QtGui.QMatrix4x4: ...
    def __isub__(self, other: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform) -> PySide6.QtGui.QMatrix4x4: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QMatrix4x4: ...
    @typing.overload
    def __mul__(self, point: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def __mul__(self, m2: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform) -> PySide6.QtGui.QMatrix4x4: ...
    def __neg__(self) -> PySide6.QtGui.QMatrix4x4: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, m2: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform) -> PySide6.QtGui.QMatrix4x4: ...
    def column(self, index: int) -> PySide6.QtGui.QVector4D: ...
    def copyDataTo(self) -> typing.Tuple: ...
    def data(self) -> typing.List[float]: ...
    def determinant(self) -> float: ...
    def fill(self, value: float) -> None: ...
    def flags(self) -> PySide6.QtGui.QMatrix4x4.Flag: ...
    def flipCoordinates(self) -> None: ...
    def frustum(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
    def inverted(self) -> typing.Tuple[PySide6.QtGui.QMatrix4x4, bool]: ...
    def isAffine(self) -> bool: ...
    def isIdentity(self) -> bool: ...
    def lookAt(self, eye: PySide6.QtGui.QVector3D, center: PySide6.QtGui.QVector3D, up: PySide6.QtGui.QVector3D) -> None: ...
    @typing.overload
    def map(self, point: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @typing.overload
    def map(self, point: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def map(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def map(self, point: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    @typing.overload
    def mapRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapRect(self, rect: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    def mapVector(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    def normalMatrix(self) -> PySide6.QtGui.QMatrix3x3: ...
    def optimize(self) -> None: ...
    @typing.overload
    def ortho(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
    @typing.overload
    def ortho(self, rect: PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def ortho(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    def perspective(self, verticalAngle: float, aspectRatio: float, nearPlane: float, farPlane: float) -> None: ...
    @typing.overload
    def projectedRotate(self, angle: float, x: float, y: float, z: float, distanceToPlane: float) -> None: ...
    @typing.overload
    def projectedRotate(self, angle: float, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def rotate(self, angle: float, x: float, y: float, z: float = ...) -> None: ...
    @typing.overload
    def rotate(self, angle: float, vector: PySide6.QtGui.QVector3D) -> None: ...
    @typing.overload
    def rotate(self, quaternion: PySide6.QtGui.QQuaternion) -> None: ...
    def row(self, index: int) -> PySide6.QtGui.QVector4D: ...
    @typing.overload
    def scale(self, factor: float) -> None: ...
    @typing.overload
    def scale(self, x: float, y: float) -> None: ...
    @typing.overload
    def scale(self, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def scale(self, vector: PySide6.QtGui.QVector3D) -> None: ...
    def setColumn(self, index: int, value: PySide6.QtGui.QVector4D) -> None: ...
    def setRow(self, index: int, value: PySide6.QtGui.QVector4D) -> None: ...
    def setToIdentity(self) -> None: ...
    @typing.overload
    def toTransform(self, distanceToPlane: float) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    def toTransform(self) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    def translate(self, x: float, y: float) -> None: ...
    @typing.overload
    def translate(self, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def translate(self, vector: PySide6.QtGui.QVector3D) -> None: ...
    def transposed(self) -> PySide6.QtGui.QMatrix4x4: ...
    @typing.overload
    def viewport(self, left: float, bottom: float, width: float, height: float, nearPlane: float = ..., farPlane: float = ...) -> None: ...
    @typing.overload
    def viewport(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...


class QMouseEvent(PySide6.QtGui.QSinglePointEvent):

    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, localPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, device: PySide6.QtGui.QPointingDevice = ...) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, localPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, scenePos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, globalPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, device: PySide6.QtGui.QPointingDevice = ...) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, localPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, globalPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, device: PySide6.QtGui.QPointingDevice = ...) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, localPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, scenePos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, globalPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, source: PySide6.QtCore.Qt.MouseEventSource, device: PySide6.QtGui.QPointingDevice = ...) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def clone(self) -> PySide6.QtGui.QMouseEvent: ...
    def flags(self) -> PySide6.QtCore.Qt.MouseEventFlag: ...
    def globalPos(self) -> PySide6.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def localPos(self) -> PySide6.QtCore.QPointF: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def screenPos(self) -> PySide6.QtCore.QPointF: ...
    def source(self) -> PySide6.QtCore.Qt.MouseEventSource: ...
    def windowPos(self) -> PySide6.QtCore.QPointF: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QMoveEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QMoveEvent) -> None: ...
    @typing.overload
    def __init__(self, pos: PySide6.QtCore.QPoint, oldPos: PySide6.QtCore.QPoint) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def clone(self) -> PySide6.QtGui.QMoveEvent: ...
    def oldPos(self) -> PySide6.QtCore.QPoint: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...


class QMovie(PySide6.QtCore.QObject):

    error                    : typing.ClassVar[Signal] = ... # error(QImageReader::ImageReaderError)
    finished                 : typing.ClassVar[Signal] = ... # finished()
    frameChanged             : typing.ClassVar[Signal] = ... # frameChanged(int)
    resized                  : typing.ClassVar[Signal] = ... # resized(QSize)
    started                  : typing.ClassVar[Signal] = ... # started()
    stateChanged             : typing.ClassVar[Signal] = ... # stateChanged(QMovie::MovieState)
    updated                  : typing.ClassVar[Signal] = ... # updated(QRect)

    class CacheMode(enum.Enum):

        CacheNone                 = ...  # 0x0
        CacheAll                  = ...  # 0x1

    class MovieState(enum.Enum):

        NotRunning                = ...  # 0x0
        Paused                    = ...  # 0x1
        Running                   = ...  # 0x2


    @typing.overload
    def __init__(self, fileName: str, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ..., parent: PySide6.QtCore.QObject | None= ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...
    @typing.overload
    def __init__(self, device: PySide6.QtCore.QIODevice, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ..., parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    def backgroundColor(self) -> PySide6.QtGui.QColor: ...
    def cacheMode(self) -> PySide6.QtGui.QMovie.CacheMode: ...
    def currentFrameNumber(self) -> int: ...
    def currentImage(self) -> PySide6.QtGui.QImage: ...
    def currentPixmap(self) -> PySide6.QtGui.QPixmap: ...
    def device(self) -> PySide6.QtCore.QIODevice: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide6.QtCore.QByteArray: ...
    def frameCount(self) -> int: ...
    def frameRect(self) -> PySide6.QtCore.QRect: ...
    def isValid(self) -> bool: ...
    def jumpToFrame(self, frameNumber: int) -> bool: ...
    def jumpToNextFrame(self) -> bool: ...
    def lastError(self) -> PySide6.QtGui.QImageReader.ImageReaderError: ...
    def lastErrorString(self) -> str: ...
    def loopCount(self) -> int: ...
    def nextFrameDelay(self) -> int: ...
    def scaledSize(self) -> PySide6.QtCore.QSize: ...
    def setBackgroundColor(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    def setCacheMode(self, mode: PySide6.QtGui.QMovie.CacheMode) -> None: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setFormat(self, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    def setPaused(self, paused: bool) -> None: ...
    def setScaledSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setSpeed(self, percentSpeed: int) -> None: ...
    def speed(self) -> int: ...
    def start(self) -> None: ...
    def state(self) -> PySide6.QtGui.QMovie.MovieState: ...
    def stop(self) -> None: ...
    @staticmethod
    def supportedFormats() -> typing.List[PySide6.QtCore.QByteArray]: ...


class QNativeGestureEvent(PySide6.QtGui.QSinglePointEvent):

    @typing.overload
    def __init__(self, type: PySide6.QtCore.Qt.NativeGestureType, dev: PySide6.QtGui.QPointingDevice, fingerCount: int, localPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, scenePos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, globalPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, value: float, delta: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, sequenceId: int = ...) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.Qt.NativeGestureType, dev: PySide6.QtGui.QPointingDevice, localPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, scenePos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, globalPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, value: float, sequenceId: int, intArgument: int) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QNativeGestureEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QNativeGestureEvent: ...
    def delta(self) -> PySide6.QtCore.QPointF: ...
    def fingerCount(self) -> int: ...
    def gestureType(self) -> PySide6.QtCore.Qt.NativeGestureType: ...
    def globalPos(self) -> PySide6.QtCore.QPoint: ...
    def localPos(self) -> PySide6.QtCore.QPointF: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def screenPos(self) -> PySide6.QtCore.QPointF: ...
    def value(self) -> float: ...
    def windowPos(self) -> PySide6.QtCore.QPointF: ...


class QNativeInterface(Shiboken.Object):

    class QX11Application(Shiboken.Object):

        def __init__(self) -> None: ...

        def connection(self) -> int: ...
        def display(self) -> int: ...


class QX11Application(Shiboken.Object):

    def __init__(self) -> None: ...

    def connection(self) -> int: ...
    def display(self) -> int: ...


class QOffscreenSurface(PySide6.QtCore.QObject, PySide6.QtGui.QSurface):

    screenChanged            : typing.ClassVar[Signal] = ... # screenChanged(QScreen*)

    def __init__(self, screen: PySide6.QtGui.QScreen | None= ..., parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    def create(self) -> None: ...
    def destroy(self) -> None: ...
    def format(self) -> PySide6.QtGui.QSurfaceFormat: ...
    def isValid(self) -> bool: ...
    def requestedFormat(self) -> PySide6.QtGui.QSurfaceFormat: ...
    def resolveInterface(self, name: bytes | bytearray | memoryview, revision: int) -> int: ...
    def screen(self) -> PySide6.QtGui.QScreen: ...
    def setFormat(self, format: PySide6.QtGui.QSurfaceFormat | PySide6.QtGui.QSurfaceFormat.FormatOption) -> None: ...
    def setScreen(self, screen: PySide6.QtGui.QScreen) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> PySide6.QtGui.QSurface.SurfaceType: ...


class QOpenGLContext(PySide6.QtCore.QObject):

    aboutToBeDestroyed       : typing.ClassVar[Signal] = ... # aboutToBeDestroyed()

    class OpenGLModuleType(enum.Enum):

        LibGL                     = ...  # 0x0
        LibGLES                   = ...  # 0x1


    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    @staticmethod
    def areSharing(first: PySide6.QtGui.QOpenGLContext, second: PySide6.QtGui.QOpenGLContext) -> bool: ...
    def create(self) -> bool: ...
    @staticmethod
    def currentContext() -> PySide6.QtGui.QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self) -> None: ...
    def extensions(self) -> typing.Set[PySide6.QtCore.QByteArray]: ...
    def extraFunctions(self) -> PySide6.QtGui.QOpenGLExtraFunctions: ...
    def format(self) -> PySide6.QtGui.QSurfaceFormat: ...
    def functions(self) -> PySide6.QtGui.QOpenGLFunctions: ...
    @typing.overload
    def getProcAddress(self, procName: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> int: ...
    @typing.overload
    def getProcAddress(self, procName: bytes | bytearray | memoryview) -> int: ...
    @staticmethod
    def globalShareContext() -> PySide6.QtGui.QOpenGLContext: ...
    def hasExtension(self, extension: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> bool: ...
    def isOpenGLES(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self, surface: PySide6.QtGui.QSurface) -> bool: ...
    @staticmethod
    def openGLModuleType() -> PySide6.QtGui.QOpenGLContext.OpenGLModuleType: ...
    def resolveInterface(self, name: bytes | bytearray | memoryview, revision: int) -> int: ...
    def screen(self) -> PySide6.QtGui.QScreen: ...
    def setFormat(self, format: PySide6.QtGui.QSurfaceFormat | PySide6.QtGui.QSurfaceFormat.FormatOption) -> None: ...
    def setScreen(self, screen: PySide6.QtGui.QScreen) -> None: ...
    def setShareContext(self, shareContext: PySide6.QtGui.QOpenGLContext) -> None: ...
    def shareContext(self) -> PySide6.QtGui.QOpenGLContext: ...
    def shareGroup(self) -> PySide6.QtGui.QOpenGLContextGroup: ...
    @staticmethod
    def supportsThreadedOpenGL() -> bool: ...
    def surface(self) -> PySide6.QtGui.QSurface: ...
    def swapBuffers(self, surface: PySide6.QtGui.QSurface) -> None: ...


class QOpenGLContextGroup(PySide6.QtCore.QObject):
    @staticmethod
    def __repr__() -> str: ...
    @staticmethod
    def currentContextGroup() -> PySide6.QtGui.QOpenGLContextGroup: ...
    def shares(self) -> typing.List[PySide6.QtGui.QOpenGLContext]: ...


class QOpenGLExtraFunctions(PySide6.QtGui.QOpenGLFunctions):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, context: PySide6.QtGui.QOpenGLContext) -> None: ...

    def glActiveShaderProgram(self, pipeline: int, program: int) -> None: ...
    def glBeginQuery(self, target: int, id: int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode: int) -> None: ...
    def glBindBufferBase(self, target: int, index: int, buffer: int) -> None: ...
    def glBindImageTexture(self, unit: int, texture: int, level: int, layered: int, layer: int, access: int, format: int) -> None: ...
    def glBindProgramPipeline(self, pipeline: int) -> None: ...
    def glBindSampler(self, unit: int, sampler: int) -> None: ...
    def glBindTransformFeedback(self, target: int, id: int) -> None: ...
    def glBindVertexArray(self, array: int) -> None: ...
    def glBlendBarrier(self) -> None: ...
    def glBlendEquationSeparatei(self, buf: int, modeRGB: int, modeAlpha: int) -> None: ...
    def glBlendEquationi(self, buf: int, mode: int) -> None: ...
    def glBlendFuncSeparatei(self, buf: int, srcRGB: int, dstRGB: int, srcAlpha: int, dstAlpha: int) -> None: ...
    def glBlendFunci(self, buf: int, src: int, dst: int) -> None: ...
    def glBlitFramebuffer(self, srcX0: int, srcY0: int, srcX1: int, srcY1: int, dstX0: int, dstY0: int, dstX1: int, dstY1: int, mask: int, filter: int) -> None: ...
    def glClearBufferfi(self, buffer: int, drawbuffer: int, depth: float, stencil: int) -> None: ...
    def glClearBufferfv(self, buffer: int, drawbuffer: int, value: typing.Sequence[float]) -> None: ...
    def glClearBufferiv(self, buffer: int, drawbuffer: int, value: typing.Sequence[int]) -> None: ...
    def glClearBufferuiv(self, buffer: int, drawbuffer: int, value: typing.Sequence[int]) -> None: ...
    def glColorMaski(self, index: int, r: int, g: int, b: int, a: int) -> None: ...
    def glCompressedTexImage3D(self, target: int, level: int, internalformat: int, width: int, height: int, depth: int, border: int, imageSize: int, data: int) -> None: ...
    def glCompressedTexSubImage3D(self, target: int, level: int, xoffset: int, yoffset: int, zoffset: int, width: int, height: int, depth: int, format: int, imageSize: int, data: int) -> None: ...
    def glCopyImageSubData(self, srcName: int, srcTarget: int, srcLevel: int, srcX: int, srcY: int, srcZ: int, dstName: int, dstTarget: int, dstLevel: int, dstX: int, dstY: int, dstZ: int, srcWidth: int, srcHeight: int, srcDepth: int) -> None: ...
    def glCopyTexSubImage3D(self, target: int, level: int, xoffset: int, yoffset: int, zoffset: int, x: int, y: int, width: int, height: int) -> None: ...
    def glDebugMessageControl(self, source: int, type: int, severity: int, count: int, ids: typing.Sequence[int], enabled: int) -> None: ...
    def glDebugMessageInsert(self, source: int, type: int, id: int, severity: int, length: int, buf: bytes | bytearray | memoryview) -> None: ...
    def glDeleteProgramPipelines(self, n: int, pipelines: typing.Sequence[int]) -> None: ...
    def glDeleteQueries(self, n: int, ids: typing.Sequence[int]) -> None: ...
    def glDeleteSamplers(self, count: int, samplers: typing.Sequence[int]) -> None: ...
    def glDeleteTransformFeedbacks(self, n: int, ids: typing.Sequence[int]) -> None: ...
    def glDeleteVertexArrays(self, n: int, arrays: typing.Sequence[int]) -> None: ...
    def glDisablei(self, target: int, index: int) -> None: ...
    def glDispatchCompute(self, num_groups_x: int, num_groups_y: int, num_groups_z: int) -> None: ...
    def glDrawArraysIndirect(self, mode: int, indirect: int) -> None: ...
    def glDrawArraysInstanced(self, mode: int, first: int, count: int, instancecount: int) -> None: ...
    def glDrawBuffers(self, n: int, bufs: typing.Sequence[int]) -> None: ...
    def glDrawElementsBaseVertex(self, mode: int, count: int, type: int, indices: int, basevertex: int) -> None: ...
    def glDrawElementsIndirect(self, mode: int, type: int, indirect: int) -> None: ...
    def glDrawElementsInstanced(self, mode: int, count: int, type: int, indices: int, instancecount: int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode: int, count: int, type: int, indices: int, instancecount: int, basevertex: int) -> None: ...
    def glDrawRangeElements(self, mode: int, start: int, end: int, count: int, type: int, indices: int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode: int, start: int, end: int, count: int, type: int, indices: int, basevertex: int) -> None: ...
    def glEnablei(self, target: int, index: int) -> None: ...
    def glEndQuery(self, target: int) -> None: ...
    def glFramebufferParameteri(self, target: int, pname: int, param: int) -> None: ...
    def glFramebufferTexture(self, target: int, attachment: int, texture: int, level: int) -> None: ...
    def glFramebufferTextureLayer(self, target: int, attachment: int, texture: int, level: int, layer: int) -> None: ...
    def glGenProgramPipelines(self, n: int, pipelines: typing.Sequence[int]) -> None: ...
    def glGenQueries(self, n: int, ids: typing.Sequence[int]) -> None: ...
    def glGenSamplers(self, count: int, samplers: typing.Sequence[int]) -> None: ...
    def glGenTransformFeedbacks(self, n: int, ids: typing.Sequence[int]) -> None: ...
    def glGenVertexArrays(self, n: int, arrays: typing.Sequence[int]) -> None: ...
    def glGetActiveUniformBlockiv(self, program: int, uniformBlockIndex: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetActiveUniformsiv(self, program: int, uniformCount: int, uniformIndices: typing.Sequence[int], pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetBooleani_v(self, target: int, index: int) -> bool | typing.List[typing.Any]: ...
    def glGetFragDataLocation(self, program: int, name: bytes | bytearray | memoryview) -> int: ...
    def glGetFramebufferParameteriv(self, target: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetGraphicsResetStatus(self) -> int: ...
    @typing.overload
    def glGetIntegeri_v(self, arg__1: int, arg__2: int) -> int | typing.List[typing.Any]: ...
    @typing.overload
    def glGetIntegeri_v(self, target: int, index: int, data: typing.Sequence[int]) -> None: ...
    def glGetInternalformativ(self, target: int, internalformat: int, pname: int, bufSize: int, params: typing.Sequence[int]) -> None: ...
    def glGetMultisamplefv(self, pname: int, index: int, val: typing.Sequence[float]) -> None: ...
    def glGetProgramInterfaceiv(self, program: int, programInterface: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetProgramPipelineiv(self, pipeline: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetProgramResourceIndex(self, program: int, programInterface: int, name: bytes | bytearray | memoryview) -> int: ...
    def glGetProgramResourceLocation(self, program: int, programInterface: int, name: bytes | bytearray | memoryview) -> int: ...
    def glGetProgramResourceiv(self, program: int, programInterface: int, index: int, propCount: int, props: typing.Sequence[int], bufSize: int, length: typing.Sequence[int], params: typing.Sequence[int]) -> None: ...
    def glGetQueryObjectuiv(self, id: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetQueryiv(self, target: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetSamplerParameterIiv(self, sampler: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetSamplerParameterIuiv(self, sampler: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetSamplerParameterfv(self, sampler: int, pname: int, params: typing.Sequence[float]) -> None: ...
    def glGetSamplerParameteriv(self, sampler: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetStringi(self, name: int, index: int) -> str: ...
    def glGetTexLevelParameterfv(self, target: int, level: int, pname: int, params: typing.Sequence[float]) -> None: ...
    def glGetTexLevelParameteriv(self, target: int, level: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetTexParameterIiv(self, target: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetTexParameterIuiv(self, target: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetUniformBlockIndex(self, program: int, uniformBlockName: bytes | bytearray | memoryview) -> int: ...
    def glGetUniformuiv(self, program: int, location: int, params: typing.Sequence[int]) -> None: ...
    def glGetVertexAttribIiv(self, index: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetVertexAttribIuiv(self, index: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetnUniformfv(self, program: int, location: int, bufSize: int) -> float: ...
    def glGetnUniformiv(self, program: int, location: int, bufSize: int, params: typing.Sequence[int]) -> None: ...
    def glGetnUniformuiv(self, program: int, location: int, bufSize: int, params: typing.Sequence[int]) -> None: ...
    def glInvalidateFramebuffer(self, target: int, numAttachments: int, attachments: typing.Sequence[int]) -> None: ...
    def glInvalidateSubFramebuffer(self, target: int, numAttachments: int, attachments: typing.Sequence[int], x: int, y: int, width: int, height: int) -> None: ...
    def glIsEnabledi(self, target: int, index: int) -> int: ...
    def glIsProgramPipeline(self, pipeline: int) -> int: ...
    def glIsQuery(self, id: int) -> int: ...
    def glIsSampler(self, sampler: int) -> int: ...
    def glIsTransformFeedback(self, id: int) -> int: ...
    def glIsVertexArray(self, array: int) -> int: ...
    def glMemoryBarrier(self, barriers: int) -> None: ...
    def glMemoryBarrierByRegion(self, barriers: int) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glObjectLabel(self, identifier: int, name: int, length: int, label: bytes | bytearray | memoryview) -> None: ...
    def glObjectPtrLabel(self, ptr: int, length: int, label: bytes | bytearray | memoryview) -> None: ...
    def glPatchParameteri(self, pname: int, value: int) -> None: ...
    def glPopDebugGroup(self) -> None: ...
    def glPrimitiveBoundingBox(self, minX: float, minY: float, minZ: float, minW: float, maxX: float, maxY: float, maxZ: float, maxW: float) -> None: ...
    def glProgramBinary(self, program: int, binaryFormat: int, binary: int, length: int) -> None: ...
    def glProgramParameteri(self, program: int, pname: int, value: int) -> None: ...
    def glProgramUniform1f(self, program: int, location: int, v0: float) -> None: ...
    def glProgramUniform1fv(self, program: int, location: int, count: int, value: typing.Sequence[float]) -> None: ...
    def glProgramUniform1i(self, program: int, location: int, v0: int) -> None: ...
    def glProgramUniform1iv(self, program: int, location: int, count: int, value: typing.Sequence[int]) -> None: ...
    def glProgramUniform1ui(self, program: int, location: int, v0: int) -> None: ...
    def glProgramUniform1uiv(self, program: int, location: int, count: int, value: typing.Sequence[int]) -> None: ...
    def glProgramUniform2f(self, program: int, location: int, v0: float, v1: float) -> None: ...
    def glProgramUniform2fv(self, program: int, location: int, count: int, value: typing.Sequence[float]) -> None: ...
    def glProgramUniform2i(self, program: int, location: int, v0: int, v1: int) -> None: ...
    def glProgramUniform2iv(self, program: int, location: int, count: int, value: typing.Sequence[int]) -> None: ...
    def glProgramUniform2ui(self, program: int, location: int, v0: int, v1: int) -> None: ...
    def glProgramUniform2uiv(self, program: int, location: int, count: int, value: typing.Sequence[int]) -> None: ...
    def glProgramUniform3f(self, program: int, location: int, v0: float, v1: float, v2: float) -> None: ...
    def glProgramUniform3fv(self, program: int, location: int, count: int, value: typing.Sequence[float]) -> None: ...
    def glProgramUniform3i(self, program: int, location: int, v0: int, v1: int, v2: int) -> None: ...
    def glProgramUniform3iv(self, program: int, location: int, count: int, value: typing.Sequence[int]) -> None: ...
    def glProgramUniform3ui(self, program: int, location: int, v0: int, v1: int, v2: int) -> None: ...
    def glProgramUniform3uiv(self, program: int, location: int, count: int, value: typing.Sequence[int]) -> None: ...
    def glProgramUniform4f(self, program: int, location: int, v0: float, v1: float, v2: float, v3: float) -> None: ...
    def glProgramUniform4fv(self, program: int, location: int, count: int, value: typing.Sequence[float]) -> None: ...
    def glProgramUniform4i(self, program: int, location: int, v0: int, v1: int, v2: int, v3: int) -> None: ...
    def glProgramUniform4iv(self, program: int, location: int, count: int, value: typing.Sequence[int]) -> None: ...
    def glProgramUniform4ui(self, program: int, location: int, v0: int, v1: int, v2: int, v3: int) -> None: ...
    def glProgramUniform4uiv(self, program: int, location: int, count: int, value: typing.Sequence[int]) -> None: ...
    def glProgramUniformMatrix2fv(self, program: int, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program: int, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program: int, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glProgramUniformMatrix3fv(self, program: int, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program: int, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program: int, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glProgramUniformMatrix4fv(self, program: int, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program: int, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program: int, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glPushDebugGroup(self, source: int, id: int, length: int, message: bytes | bytearray | memoryview) -> None: ...
    def glReadBuffer(self, mode: int) -> None: ...
    def glReadnPixels(self, x: int, y: int, width: int, height: int, format: int, type: int, bufSize: int, data: int) -> None: ...
    def glRenderbufferStorageMultisample(self, target: int, samples: int, internalformat: int, width: int, height: int) -> None: ...
    def glSampleMaski(self, maskNumber: int, mask: int) -> None: ...
    def glSamplerParameterIiv(self, sampler: int, pname: int, param: typing.Sequence[int]) -> None: ...
    def glSamplerParameterIuiv(self, sampler: int, pname: int, param: typing.Sequence[int]) -> None: ...
    def glSamplerParameterf(self, sampler: int, pname: int, param: float) -> None: ...
    def glSamplerParameterfv(self, sampler: int, pname: int, param: typing.Sequence[float]) -> None: ...
    def glSamplerParameteri(self, sampler: int, pname: int, param: int) -> None: ...
    def glSamplerParameteriv(self, sampler: int, pname: int, param: typing.Sequence[int]) -> None: ...
    def glTexBuffer(self, target: int, internalformat: int, buffer: int) -> None: ...
    def glTexImage3D(self, target: int, level: int, internalformat: int, width: int, height: int, depth: int, border: int, format: int, type: int, pixels: int) -> None: ...
    def glTexParameterIiv(self, target: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glTexParameterIuiv(self, target: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glTexStorage2D(self, target: int, levels: int, internalformat: int, width: int, height: int) -> None: ...
    def glTexStorage2DMultisample(self, target: int, samples: int, internalformat: int, width: int, height: int, fixedsamplelocations: int) -> None: ...
    def glTexStorage3D(self, target: int, levels: int, internalformat: int, width: int, height: int, depth: int) -> None: ...
    def glTexStorage3DMultisample(self, target: int, samples: int, internalformat: int, width: int, height: int, depth: int, fixedsamplelocations: int) -> None: ...
    def glTexSubImage3D(self, target: int, level: int, xoffset: int, yoffset: int, zoffset: int, width: int, height: int, depth: int, format: int, type: int, pixels: int) -> None: ...
    def glUniform1ui(self, location: int, v0: int) -> None: ...
    def glUniform1uiv(self, location: int, count: int, value: typing.Sequence[int]) -> None: ...
    def glUniform2ui(self, location: int, v0: int, v1: int) -> None: ...
    def glUniform2uiv(self, location: int, count: int, value: typing.Sequence[int]) -> None: ...
    def glUniform3ui(self, location: int, v0: int, v1: int, v2: int) -> None: ...
    def glUniform3uiv(self, location: int, count: int, value: typing.Sequence[int]) -> None: ...
    def glUniform4ui(self, location: int, v0: int, v1: int, v2: int, v3: int) -> None: ...
    def glUniform4uiv(self, location: int, count: int, value: typing.Sequence[int]) -> None: ...
    def glUniformBlockBinding(self, program: int, uniformBlockIndex: int, uniformBlockBinding: int) -> None: ...
    def glUniformMatrix2x3fv(self, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glUniformMatrix2x4fv(self, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glUniformMatrix3x2fv(self, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glUniformMatrix3x4fv(self, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glUniformMatrix4x2fv(self, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glUniformMatrix4x3fv(self, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glUnmapBuffer(self, target: int) -> int: ...
    def glUseProgramStages(self, pipeline: int, stages: int, program: int) -> None: ...
    def glValidateProgramPipeline(self, pipeline: int) -> None: ...
    def glVertexAttribBinding(self, attribindex: int, bindingindex: int) -> None: ...
    def glVertexAttribDivisor(self, index: int, divisor: int) -> None: ...
    def glVertexAttribFormat(self, attribindex: int, size: int, type: int, normalized: int, relativeoffset: int) -> None: ...
    def glVertexAttribI4i(self, index: int, x: int, y: int, z: int, w: int) -> None: ...
    def glVertexAttribI4iv(self, index: int, v: typing.Sequence[int]) -> None: ...
    def glVertexAttribI4ui(self, index: int, x: int, y: int, z: int, w: int) -> None: ...
    def glVertexAttribI4uiv(self, index: int, v: typing.Sequence[int]) -> None: ...
    def glVertexAttribIFormat(self, attribindex: int, size: int, type: int, relativeoffset: int) -> None: ...
    def glVertexAttribIPointer(self, index: int, size: int, type: int, stride: int, pointer: int) -> None: ...
    def glVertexBindingDivisor(self, bindingindex: int, divisor: int) -> None: ...


class QOpenGLFunctions(Shiboken.Object):

    class OpenGLFeature(enum.Flag):

        Multitexture              = ...  # 0x1
        Shaders                   = ...  # 0x2
        Buffers                   = ...  # 0x4
        Framebuffers              = ...  # 0x8
        BlendColor                = ...  # 0x10
        BlendEquation             = ...  # 0x20
        BlendEquationSeparate     = ...  # 0x40
        BlendFuncSeparate         = ...  # 0x80
        BlendSubtract             = ...  # 0x100
        CompressedTextures        = ...  # 0x200
        Multisample               = ...  # 0x400
        StencilSeparate           = ...  # 0x800
        NPOTTextures              = ...  # 0x1000
        NPOTTextureRepeat         = ...  # 0x2000
        FixedFunctionPipeline     = ...  # 0x4000
        TextureRGFormats          = ...  # 0x8000
        MultipleRenderTargets     = ...  # 0x10000
        BlendEquationAdvanced     = ...  # 0x20000


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, context: PySide6.QtGui.QOpenGLContext) -> None: ...

    def glActiveTexture(self, texture: int) -> None: ...
    def glAttachShader(self, program: int, shader: int) -> None: ...
    def glBindAttribLocation(self, program: int, index: int, name: bytes | bytearray | memoryview) -> None: ...
    def glBindBuffer(self, target: int, buffer: int) -> None: ...
    def glBindFramebuffer(self, target: int, framebuffer: int) -> None: ...
    def glBindRenderbuffer(self, target: int, renderbuffer: int) -> None: ...
    def glBindTexture(self, target: int, texture: int) -> None: ...
    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glBlendEquation(self, mode: int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB: int, modeAlpha: int) -> None: ...
    def glBlendFunc(self, sfactor: int, dfactor: int) -> None: ...
    def glBlendFuncSeparate(self, srcRGB: int, dstRGB: int, srcAlpha: int, dstAlpha: int) -> None: ...
    def glCheckFramebufferStatus(self, target: int) -> int: ...
    def glClear(self, mask: int) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepthf(self, depth: float) -> None: ...
    def glClearStencil(self, s: int) -> None: ...
    def glColorMask(self, red: int, green: int, blue: int, alpha: int) -> None: ...
    def glCompileShader(self, shader: int) -> None: ...
    def glCompressedTexImage2D(self, target: int, level: int, internalformat: int, width: int, height: int, border: int, imageSize: int, data: int) -> None: ...
    def glCompressedTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, width: int, height: int, format: int, imageSize: int, data: int) -> None: ...
    def glCopyTexImage2D(self, target: int, level: int, internalformat: int, x: int, y: int, width: int, height: int, border: int) -> None: ...
    def glCopyTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, x: int, y: int, width: int, height: int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type: int) -> int: ...
    def glCullFace(self, mode: int) -> None: ...
    def glDeleteBuffers(self, n: int, buffers: typing.Sequence[int]) -> None: ...
    def glDeleteFramebuffers(self, n: int, framebuffers: typing.Sequence[int]) -> None: ...
    def glDeleteProgram(self, program: int) -> None: ...
    def glDeleteRenderbuffers(self, n: int, renderbuffers: typing.Sequence[int]) -> None: ...
    def glDeleteShader(self, shader: int) -> None: ...
    def glDeleteTextures(self, n: int, textures: typing.Sequence[int]) -> None: ...
    def glDepthFunc(self, func: int) -> None: ...
    def glDepthMask(self, flag: int) -> None: ...
    def glDepthRangef(self, zNear: float, zFar: float) -> None: ...
    def glDetachShader(self, program: int, shader: int) -> None: ...
    def glDisable(self, cap: int) -> None: ...
    def glDisableVertexAttribArray(self, index: int) -> None: ...
    def glDrawArrays(self, mode: int, first: int, count: int) -> None: ...
    def glDrawElements(self, mode: int, count: int, type: int, indices: int) -> None: ...
    def glEnable(self, cap: int) -> None: ...
    def glEnableVertexAttribArray(self, index: int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferRenderbuffer(self, target: int, attachment: int, renderbuffertarget: int, renderbuffer: int) -> None: ...
    def glFramebufferTexture2D(self, target: int, attachment: int, textarget: int, texture: int, level: int) -> None: ...
    def glFrontFace(self, mode: int) -> None: ...
    def glGenBuffers(self, n: int, buffers: typing.Sequence[int]) -> None: ...
    def glGenFramebuffers(self, n: int, framebuffers: typing.Sequence[int]) -> None: ...
    def glGenRenderbuffers(self, n: int, renderbuffers: typing.Sequence[int]) -> None: ...
    def glGenTextures(self, n: int, textures: typing.Sequence[int]) -> None: ...
    def glGenerateMipmap(self, target: int) -> None: ...
    def glGetAttachedShaders(self, program: int, maxcount: int, count: typing.Sequence[int], shaders: typing.Sequence[int]) -> None: ...
    def glGetAttribLocation(self, program: int, name: bytes | bytearray | memoryview) -> int: ...
    def glGetBooleanv(self, pname: int) -> bool | typing.List[typing.Any]: ...
    def glGetBufferParameteriv(self, target: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetError(self) -> int: ...
    @typing.overload
    def glGetFloatv(self, arg__1: int) -> float | typing.List[typing.Any]: ...
    @typing.overload
    def glGetFloatv(self, pname: int, params: typing.Sequence[float]) -> None: ...
    def glGetFramebufferAttachmentParameteriv(self, target: int, attachment: int, pname: int, params: typing.Sequence[int]) -> None: ...
    @typing.overload
    def glGetIntegerv(self, arg__1: int) -> int | typing.List[typing.Any]: ...
    @typing.overload
    def glGetIntegerv(self, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetProgramiv(self, program: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetRenderbufferParameteriv(self, target: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetShaderPrecisionFormat(self, shadertype: int, precisiontype: int, range: typing.Sequence[int], precision: typing.Sequence[int]) -> None: ...
    def glGetShaderSource(self, shader: int) -> bytes | bytearray | memoryview: ...
    def glGetShaderiv(self, shader: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetString(self, name: int) -> str: ...
    def glGetTexParameterfv(self, target: int, pname: int, params: typing.Sequence[float]) -> None: ...
    def glGetTexParameteriv(self, target: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glGetUniformLocation(self, program: int, name: bytes | bytearray | memoryview) -> int: ...
    def glGetUniformfv(self, program: int, location: int, params: typing.Sequence[float]) -> None: ...
    def glGetUniformiv(self, program: int, location: int, params: typing.Sequence[int]) -> None: ...
    def glGetVertexAttribfv(self, index: int, pname: int, params: typing.Sequence[float]) -> None: ...
    def glGetVertexAttribiv(self, index: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glHint(self, target: int, mode: int) -> None: ...
    def glIsBuffer(self, buffer: int) -> int: ...
    def glIsEnabled(self, cap: int) -> int: ...
    def glIsFramebuffer(self, framebuffer: int) -> int: ...
    def glIsProgram(self, program: int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer: int) -> int: ...
    def glIsShader(self, shader: int) -> int: ...
    def glIsTexture(self, texture: int) -> int: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLinkProgram(self, program: int) -> None: ...
    def glPixelStorei(self, pname: int, param: int) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glReadPixels(self, x: int, y: int, width: int, height: int, format: int, type: int, pixels: int) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderbufferStorage(self, target: int, internalformat: int, width: int, height: int) -> None: ...
    def glSampleCoverage(self, value: float, invert: int) -> None: ...
    def glScissor(self, x: int, y: int, width: int, height: int) -> None: ...
    def glShaderBinary(self, n: int, shaders: typing.Sequence[int], binaryformat: int, binary: int, length: int) -> None: ...
    def glShaderSource(self, shader: int, source: str) -> None: ...
    def glStencilFunc(self, func: int, ref: int, mask: int) -> None: ...
    def glStencilFuncSeparate(self, face: int, func: int, ref: int, mask: int) -> None: ...
    def glStencilMask(self, mask: int) -> None: ...
    def glStencilMaskSeparate(self, face: int, mask: int) -> None: ...
    def glStencilOp(self, fail: int, zfail: int, zpass: int) -> None: ...
    def glStencilOpSeparate(self, face: int, fail: int, zfail: int, zpass: int) -> None: ...
    def glTexImage2D(self, target: int, level: int, internalformat: int, width: int, height: int, border: int, format: int, type: int, pixels: int) -> None: ...
    def glTexParameterf(self, target: int, pname: int, param: float) -> None: ...
    def glTexParameterfv(self, target: int, pname: int, params: typing.Sequence[float]) -> None: ...
    def glTexParameteri(self, target: int, pname: int, param: int) -> None: ...
    def glTexParameteriv(self, target: int, pname: int, params: typing.Sequence[int]) -> None: ...
    def glTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, width: int, height: int, format: int, type: int, pixels: int) -> None: ...
    def glUniform1f(self, location: int, x: float) -> None: ...
    def glUniform1fv(self, location: int, count: int, v: typing.Sequence[float]) -> None: ...
    def glUniform1i(self, location: int, x: int) -> None: ...
    def glUniform1iv(self, location: int, count: int, v: typing.Sequence[int]) -> None: ...
    def glUniform2f(self, location: int, x: float, y: float) -> None: ...
    def glUniform2fv(self, location: int, count: int, v: typing.Sequence[float]) -> None: ...
    def glUniform2i(self, location: int, x: int, y: int) -> None: ...
    def glUniform2iv(self, location: int, count: int, v: typing.Sequence[int]) -> None: ...
    def glUniform3f(self, location: int, x: float, y: float, z: float) -> None: ...
    def glUniform3fv(self, location: int, count: int, v: typing.Sequence[float]) -> None: ...
    def glUniform3i(self, location: int, x: int, y: int, z: int) -> None: ...
    def glUniform3iv(self, location: int, count: int, v: typing.Sequence[int]) -> None: ...
    def glUniform4f(self, location: int, x: float, y: float, z: float, w: float) -> None: ...
    def glUniform4fv(self, location: int, count: int, v: typing.Sequence[float]) -> None: ...
    def glUniform4i(self, location: int, x: int, y: int, z: int, w: int) -> None: ...
    def glUniform4iv(self, location: int, count: int, v: typing.Sequence[int]) -> None: ...
    def glUniformMatrix2fv(self, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glUniformMatrix3fv(self, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glUniformMatrix4fv(self, location: int, count: int, transpose: int, value: typing.Sequence[float]) -> None: ...
    def glUseProgram(self, program: int) -> None: ...
    def glValidateProgram(self, program: int) -> None: ...
    def glVertexAttrib1f(self, indx: int, x: float) -> None: ...
    def glVertexAttrib1fv(self, indx: int, values: typing.Sequence[float]) -> None: ...
    def glVertexAttrib2f(self, indx: int, x: float, y: float) -> None: ...
    def glVertexAttrib2fv(self, indx: int, values: typing.Sequence[float]) -> None: ...
    def glVertexAttrib3f(self, indx: int, x: float, y: float, z: float) -> None: ...
    def glVertexAttrib3fv(self, indx: int, values: typing.Sequence[float]) -> None: ...
    def glVertexAttrib4f(self, indx: int, x: float, y: float, z: float, w: float) -> None: ...
    def glVertexAttrib4fv(self, indx: int, values: typing.Sequence[float]) -> None: ...
    def glVertexAttribPointer(self, indx: int, size: int, type: int, normalized: int, stride: int, ptr: int) -> None: ...
    def glViewport(self, x: int, y: int, width: int, height: int) -> None: ...
    def hasOpenGLFeature(self, feature: PySide6.QtGui.QOpenGLFunctions.OpenGLFeature) -> bool: ...
    def initializeOpenGLFunctions(self) -> None: ...
    def openGLFeatures(self) -> PySide6.QtGui.QOpenGLFunctions.OpenGLFeature: ...


class QOverrideCursorGuard(Shiboken.Object):

    def __init__(self) -> None: ...

    def __enter__(self) -> PySide6.QtGui.QOverrideCursorGuard: ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object) -> None: ...
    def restoreOverrideCursor(self) -> None: ...


class QPageLayout(Shiboken.Object):

    class Mode(enum.Enum):

        StandardMode              = ...  # 0x0
        FullPageMode              = ...  # 0x1

    class Orientation(enum.Enum):

        Portrait                  = ...  # 0x0
        Landscape                 = ...  # 0x1

    class OutOfBoundsPolicy(enum.Enum):

        Reject                    = ...  # 0x0
        Clamp                     = ...  # 0x1

    class Unit(enum.Enum):

        Millimeter                = ...  # 0x0
        Point                     = ...  # 0x1
        Inch                      = ...  # 0x2
        Pica                      = ...  # 0x3
        Didot                     = ...  # 0x4
        Cicero                    = ...  # 0x5


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QPageLayout) -> None: ...
    @typing.overload
    def __init__(self, pageSize: PySide6.QtGui.QPageSize | PySide6.QtGui.QPageSize.PageSizeId | PySide6.QtCore.QSize, orientation: PySide6.QtGui.QPageLayout.Orientation, margins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, units: PySide6.QtGui.QPageLayout.Unit = ..., minMargins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins= ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    @typing.overload
    def fullRect(self) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def fullRect(self, units: PySide6.QtGui.QPageLayout.Unit) -> PySide6.QtCore.QRectF: ...
    def fullRectPixels(self, resolution: int) -> PySide6.QtCore.QRect: ...
    def fullRectPoints(self) -> PySide6.QtCore.QRect: ...
    def isEquivalentTo(self, other: PySide6.QtGui.QPageLayout) -> bool: ...
    def isValid(self) -> bool: ...
    @typing.overload
    def margins(self, units: PySide6.QtGui.QPageLayout.Unit) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def margins(self) -> PySide6.QtCore.QMarginsF: ...
    def marginsPixels(self, resolution: int) -> PySide6.QtCore.QMargins: ...
    def marginsPoints(self) -> PySide6.QtCore.QMargins: ...
    def maximumMargins(self) -> PySide6.QtCore.QMarginsF: ...
    def minimumMargins(self) -> PySide6.QtCore.QMarginsF: ...
    def mode(self) -> PySide6.QtGui.QPageLayout.Mode: ...
    def orientation(self) -> PySide6.QtGui.QPageLayout.Orientation: ...
    def pageSize(self) -> PySide6.QtGui.QPageSize: ...
    @typing.overload
    def paintRect(self) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def paintRect(self, units: PySide6.QtGui.QPageLayout.Unit) -> PySide6.QtCore.QRectF: ...
    def paintRectPixels(self, resolution: int) -> PySide6.QtCore.QRect: ...
    def paintRectPoints(self) -> PySide6.QtCore.QRect: ...
    def setBottomMargin(self, bottomMargin: float, outOfBoundsPolicy: PySide6.QtGui.QPageLayout.OutOfBoundsPolicy = ...) -> bool: ...
    def setLeftMargin(self, leftMargin: float, outOfBoundsPolicy: PySide6.QtGui.QPageLayout.OutOfBoundsPolicy = ...) -> bool: ...
    def setMargins(self, margins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, outOfBoundsPolicy: PySide6.QtGui.QPageLayout.OutOfBoundsPolicy = ...) -> bool: ...
    def setMinimumMargins(self, minMargins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins) -> None: ...
    def setMode(self, mode: PySide6.QtGui.QPageLayout.Mode) -> None: ...
    def setOrientation(self, orientation: PySide6.QtGui.QPageLayout.Orientation) -> None: ...
    def setPageSize(self, pageSize: PySide6.QtGui.QPageSize | PySide6.QtGui.QPageSize.PageSizeId | PySide6.QtCore.QSize, minMargins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins= ...) -> None: ...
    def setRightMargin(self, rightMargin: float, outOfBoundsPolicy: PySide6.QtGui.QPageLayout.OutOfBoundsPolicy = ...) -> bool: ...
    def setTopMargin(self, topMargin: float, outOfBoundsPolicy: PySide6.QtGui.QPageLayout.OutOfBoundsPolicy = ...) -> bool: ...
    def setUnits(self, units: PySide6.QtGui.QPageLayout.Unit) -> None: ...
    def swap(self, other: PySide6.QtGui.QPageLayout) -> None: ...
    def units(self) -> PySide6.QtGui.QPageLayout.Unit: ...


class QPageRanges(Shiboken.Object):

    class Range(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Range: PySide6.QtGui.QPageRanges.Range) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def contains(self, pageNumber: int) -> bool: ...


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QPageRanges) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def addPage(self, pageNumber: int) -> None: ...
    def addRange(self, from_: int, to: int) -> None: ...
    def clear(self) -> None: ...
    def contains(self, pageNumber: int) -> bool: ...
    def firstPage(self) -> int: ...
    @staticmethod
    def fromString(ranges: str) -> PySide6.QtGui.QPageRanges: ...
    def isEmpty(self) -> bool: ...
    def lastPage(self) -> int: ...
    def swap(self, other: PySide6.QtGui.QPageRanges) -> None: ...
    def toRangeList(self) -> typing.List[PySide6.QtGui.QPageRanges.Range]: ...
    def toString(self) -> str: ...


class Range(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, Range: PySide6.QtGui.QPageRanges.Range) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def contains(self, pageNumber: int) -> bool: ...


class QPageSize(Shiboken.Object):

    class PageSizeId(enum.Enum):

        AnsiA                     = ...  # 0x0
        Letter                    = ...  # 0x0
        Legal                     = ...  # 0x1
        Executive                 = ...  # 0x2
        A0                        = ...  # 0x3
        A1                        = ...  # 0x4
        A2                        = ...  # 0x5
        A3                        = ...  # 0x6
        A4                        = ...  # 0x7
        A5                        = ...  # 0x8
        A6                        = ...  # 0x9
        A7                        = ...  # 0xa
        A8                        = ...  # 0xb
        A9                        = ...  # 0xc
        A10                       = ...  # 0xd
        B0                        = ...  # 0xe
        B1                        = ...  # 0xf
        B2                        = ...  # 0x10
        B3                        = ...  # 0x11
        B4                        = ...  # 0x12
        B5                        = ...  # 0x13
        B6                        = ...  # 0x14
        B7                        = ...  # 0x15
        B8                        = ...  # 0x16
        B9                        = ...  # 0x17
        B10                       = ...  # 0x18
        C5E                       = ...  # 0x19
        EnvelopeC5                = ...  # 0x19
        Comm10E                   = ...  # 0x1a
        Envelope10                = ...  # 0x1a
        DLE                       = ...  # 0x1b
        EnvelopeDL                = ...  # 0x1b
        Folio                     = ...  # 0x1c
        AnsiB                     = ...  # 0x1d
        Ledger                    = ...  # 0x1d
        Tabloid                   = ...  # 0x1e
        Custom                    = ...  # 0x1f
        A3Extra                   = ...  # 0x20
        A4Extra                   = ...  # 0x21
        A4Plus                    = ...  # 0x22
        A4Small                   = ...  # 0x23
        A5Extra                   = ...  # 0x24
        B5Extra                   = ...  # 0x25
        JisB0                     = ...  # 0x26
        JisB1                     = ...  # 0x27
        JisB2                     = ...  # 0x28
        JisB3                     = ...  # 0x29
        JisB4                     = ...  # 0x2a
        JisB5                     = ...  # 0x2b
        JisB6                     = ...  # 0x2c
        JisB7                     = ...  # 0x2d
        JisB8                     = ...  # 0x2e
        JisB9                     = ...  # 0x2f
        JisB10                    = ...  # 0x30
        AnsiC                     = ...  # 0x31
        AnsiD                     = ...  # 0x32
        AnsiE                     = ...  # 0x33
        LegalExtra                = ...  # 0x34
        LetterExtra               = ...  # 0x35
        LetterPlus                = ...  # 0x36
        LetterSmall               = ...  # 0x37
        TabloidExtra              = ...  # 0x38
        ArchA                     = ...  # 0x39
        ArchB                     = ...  # 0x3a
        ArchC                     = ...  # 0x3b
        ArchD                     = ...  # 0x3c
        ArchE                     = ...  # 0x3d
        Imperial7x9               = ...  # 0x3e
        Imperial8x10              = ...  # 0x3f
        Imperial9x11              = ...  # 0x40
        Imperial9x12              = ...  # 0x41
        Imperial10x11             = ...  # 0x42
        Imperial10x13             = ...  # 0x43
        Imperial10x14             = ...  # 0x44
        Imperial12x11             = ...  # 0x45
        Imperial15x11             = ...  # 0x46
        ExecutiveStandard         = ...  # 0x47
        Note                      = ...  # 0x48
        Quarto                    = ...  # 0x49
        Statement                 = ...  # 0x4a
        SuperA                    = ...  # 0x4b
        SuperB                    = ...  # 0x4c
        Postcard                  = ...  # 0x4d
        DoublePostcard            = ...  # 0x4e
        Prc16K                    = ...  # 0x4f
        Prc32K                    = ...  # 0x50
        Prc32KBig                 = ...  # 0x51
        FanFoldUS                 = ...  # 0x52
        FanFoldGerman             = ...  # 0x53
        FanFoldGermanLegal        = ...  # 0x54
        EnvelopeB4                = ...  # 0x55
        EnvelopeB5                = ...  # 0x56
        EnvelopeB6                = ...  # 0x57
        EnvelopeC0                = ...  # 0x58
        EnvelopeC1                = ...  # 0x59
        EnvelopeC2                = ...  # 0x5a
        EnvelopeC3                = ...  # 0x5b
        EnvelopeC4                = ...  # 0x5c
        EnvelopeC6                = ...  # 0x5d
        EnvelopeC65               = ...  # 0x5e
        EnvelopeC7                = ...  # 0x5f
        Envelope9                 = ...  # 0x60
        Envelope11                = ...  # 0x61
        Envelope12                = ...  # 0x62
        Envelope14                = ...  # 0x63
        EnvelopeMonarch           = ...  # 0x64
        EnvelopePersonal          = ...  # 0x65
        EnvelopeChou3             = ...  # 0x66
        EnvelopeChou4             = ...  # 0x67
        EnvelopeInvite            = ...  # 0x68
        EnvelopeItalian           = ...  # 0x69
        EnvelopeKaku2             = ...  # 0x6a
        EnvelopeKaku3             = ...  # 0x6b
        EnvelopePrc1              = ...  # 0x6c
        EnvelopePrc2              = ...  # 0x6d
        EnvelopePrc3              = ...  # 0x6e
        EnvelopePrc4              = ...  # 0x6f
        EnvelopePrc5              = ...  # 0x70
        EnvelopePrc6              = ...  # 0x71
        EnvelopePrc7              = ...  # 0x72
        EnvelopePrc8              = ...  # 0x73
        EnvelopePrc9              = ...  # 0x74
        EnvelopePrc10             = ...  # 0x75
        EnvelopeYou4              = ...  # 0x76
        LastPageSize              = ...  # 0x76

    class SizeMatchPolicy(enum.Enum):

        FuzzyMatch                = ...  # 0x0
        FuzzyOrientationMatch     = ...  # 0x1
        ExactMatch                = ...  # 0x2

    class Unit(enum.Enum):

        Millimeter                = ...  # 0x0
        Point                     = ...  # 0x1
        Inch                      = ...  # 0x2
        Pica                      = ...  # 0x3
        Didot                     = ...  # 0x4
        Cicero                    = ...  # 0x5


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QPageSize) -> None: ...
    @typing.overload
    def __init__(self, pointSize: PySide6.QtCore.QSize, name: str = ..., matchPolicy: PySide6.QtGui.QPageSize.SizeMatchPolicy = ...) -> None: ...
    @typing.overload
    def __init__(self, size: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, units: PySide6.QtGui.QPageSize.Unit, name: str = ..., matchPolicy: PySide6.QtGui.QPageSize.SizeMatchPolicy = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    @typing.overload    # type: ignore[misc]
    def definitionSize(self) -> PySide6.QtCore.QSizeF: ...
    @typing.overload
    @staticmethod
    def definitionSize(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> PySide6.QtCore.QSizeF: ...
    @typing.overload    # type: ignore[misc]
    @staticmethod
    def definitionUnits(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> PySide6.QtGui.QPageSize.Unit: ...
    @typing.overload
    def definitionUnits(self) -> PySide6.QtGui.QPageSize.Unit: ...
    @typing.overload    # type: ignore[misc]
    @staticmethod
    def id(windowsId: int) -> PySide6.QtGui.QPageSize.PageSizeId: ...
    @typing.overload
    def id(self) -> PySide6.QtGui.QPageSize.PageSizeId: ...
    @typing.overload
    @staticmethod
    def id(size: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, units: PySide6.QtGui.QPageSize.Unit, matchPolicy: PySide6.QtGui.QPageSize.SizeMatchPolicy = ...) -> PySide6.QtGui.QPageSize.PageSizeId: ...
    @typing.overload
    @staticmethod
    def id(pointSize: PySide6.QtCore.QSize, matchPolicy: PySide6.QtGui.QPageSize.SizeMatchPolicy = ...) -> PySide6.QtGui.QPageSize.PageSizeId: ...
    def isEquivalentTo(self, other: PySide6.QtGui.QPageSize | PySide6.QtGui.QPageSize.PageSizeId | PySide6.QtCore.QSize) -> bool: ...
    def isValid(self) -> bool: ...
    @typing.overload    # type: ignore[misc]
    def key(self) -> str: ...
    @typing.overload
    @staticmethod
    def key(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> str: ...
    @typing.overload    # type: ignore[misc]
    def name(self) -> str: ...
    @typing.overload
    @staticmethod
    def name(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> str: ...
    def rect(self, units: PySide6.QtGui.QPageSize.Unit) -> PySide6.QtCore.QRectF: ...
    def rectPixels(self, resolution: int) -> PySide6.QtCore.QRect: ...
    def rectPoints(self) -> PySide6.QtCore.QRect: ...
    @typing.overload    # type: ignore[misc]
    def size(self, units: PySide6.QtGui.QPageSize.Unit) -> PySide6.QtCore.QSizeF: ...
    @typing.overload
    @staticmethod
    def size(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId, units: PySide6.QtGui.QPageSize.Unit) -> PySide6.QtCore.QSizeF: ...
    @typing.overload    # type: ignore[misc]
    def sizePixels(self, resolution: int) -> PySide6.QtCore.QSize: ...
    @typing.overload
    @staticmethod
    def sizePixels(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId, resolution: int) -> PySide6.QtCore.QSize: ...
    @typing.overload    # type: ignore[misc]
    @staticmethod
    def sizePoints(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> PySide6.QtCore.QSize: ...
    @typing.overload
    def sizePoints(self) -> PySide6.QtCore.QSize: ...
    def swap(self, other: PySide6.QtGui.QPageSize | PySide6.QtGui.QPageSize.PageSizeId | PySide6.QtCore.QSize) -> None: ...
    @typing.overload    # type: ignore[misc]
    def windowsId(self) -> int: ...
    @typing.overload
    @staticmethod
    def windowsId(pageSizeId: PySide6.QtGui.QPageSize.PageSizeId) -> int: ...


class QPagedPaintDevice(PySide6.QtGui.QPaintDevice):

    class PdfVersion(enum.Enum):

        PdfVersion_1_4            = ...  # 0x0
        PdfVersion_A1b            = ...  # 0x1
        PdfVersion_1_6            = ...  # 0x2
        PdfVersion_X4             = ...  # 0x3


    def newPage(self) -> bool: ...
    def pageLayout(self) -> PySide6.QtGui.QPageLayout: ...
    def pageRanges(self) -> PySide6.QtGui.QPageRanges: ...
    def setPageLayout(self, pageLayout: PySide6.QtGui.QPageLayout) -> bool: ...
    def setPageMargins(self, margins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, units: PySide6.QtGui.QPageLayout.Unit = ...) -> bool: ...
    def setPageOrientation(self, orientation: PySide6.QtGui.QPageLayout.Orientation) -> bool: ...
    def setPageRanges(self, ranges: PySide6.QtGui.QPageRanges) -> None: ...
    def setPageSize(self, pageSize: PySide6.QtGui.QPageSize | PySide6.QtGui.QPageSize.PageSizeId | PySide6.QtCore.QSize) -> bool: ...


class QPaintDevice(Shiboken.Object):

    class PaintDeviceMetric(enum.Enum):

        PdmWidth                  = ...  # 0x1
        PdmHeight                 = ...  # 0x2
        PdmWidthMM                = ...  # 0x3
        PdmHeightMM               = ...  # 0x4
        PdmNumColors              = ...  # 0x5
        PdmDepth                  = ...  # 0x6
        PdmDpiX                   = ...  # 0x7
        PdmDpiY                   = ...  # 0x8
        PdmPhysicalDpiX           = ...  # 0x9
        PdmPhysicalDpiY           = ...  # 0xa
        PdmDevicePixelRatio       = ...  # 0xb
        PdmDevicePixelRatioScaled = ...  # 0xc
        PdmDevicePixelRatioF_EncodedA = ...  # 0xd
        PdmDevicePixelRatioF_EncodedB = ...  # 0xe


    def __init__(self) -> None: ...

    def colorCount(self) -> int: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    def devicePixelRatioF(self) -> float: ...
    @staticmethod
    def devicePixelRatioFScale() -> float: ...
    @staticmethod
    def encodeMetricF(metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric, value: float) -> int: ...
    def height(self) -> int: ...
    def heightMM(self) -> int: ...
    def initPainter(self, painter: PySide6.QtGui.QPainter) -> None: ...
    def logicalDpiX(self) -> int: ...
    def logicalDpiY(self) -> int: ...
    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def paintingActive(self) -> bool: ...
    def physicalDpiX(self) -> int: ...
    def physicalDpiY(self) -> int: ...
    def redirected(self, offset: PySide6.QtCore.QPoint) -> PySide6.QtGui.QPaintDevice: ...
    def sharedPainter(self) -> PySide6.QtGui.QPainter: ...
    def width(self) -> int: ...
    def widthMM(self) -> int: ...


class QPaintDeviceWindow(PySide6.QtGui.QWindow, PySide6.QtGui.QPaintDevice):
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1: PySide6.QtGui.QExposeEvent) -> None: ...
    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None: ...
    @typing.overload
    def update(self) -> None: ...
    @typing.overload
    def update(self, rect: PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def update(self, region: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> None: ...


class QPaintEngine(Shiboken.Object):

    class DirtyFlag(enum.Flag):

        DirtyPen                  = ...  # 0x1
        DirtyBrush                = ...  # 0x2
        DirtyBrushOrigin          = ...  # 0x4
        DirtyFont                 = ...  # 0x8
        DirtyBackground           = ...  # 0x10
        DirtyBackgroundMode       = ...  # 0x20
        DirtyTransform            = ...  # 0x40
        DirtyClipRegion           = ...  # 0x80
        DirtyClipPath             = ...  # 0x100
        DirtyHints                = ...  # 0x200
        DirtyCompositionMode      = ...  # 0x400
        DirtyClipEnabled          = ...  # 0x800
        DirtyOpacity              = ...  # 0x1000
        AllDirty                  = ...  # 0xffff

    class PaintEngineFeature(enum.Flag):

        PrimitiveTransform        = ...  # 0x1
        PatternTransform          = ...  # 0x2
        PixmapTransform           = ...  # 0x4
        PatternBrush              = ...  # 0x8
        LinearGradientFill        = ...  # 0x10
        RadialGradientFill        = ...  # 0x20
        ConicalGradientFill       = ...  # 0x40
        AlphaBlend                = ...  # 0x80
        PorterDuff                = ...  # 0x100
        PainterPaths              = ...  # 0x200
        Antialiasing              = ...  # 0x400
        BrushStroke               = ...  # 0x800
        ConstantOpacity           = ...  # 0x1000
        MaskedBrush               = ...  # 0x2000
        PerspectiveTransform      = ...  # 0x4000
        BlendModes                = ...  # 0x8000
        ObjectBoundingModeGradients = ...  # 0x10000
        RasterOpModes             = ...  # 0x20000
        PaintOutsidePaintEvent    = ...  # 0x20000000
        AllFeatures               = ...  # 0xffffffff

    class PolygonDrawMode(enum.Enum):

        OddEvenMode               = ...  # 0x0
        WindingMode               = ...  # 0x1
        ConvexMode                = ...  # 0x2
        PolylineMode              = ...  # 0x3

    class Type(enum.Enum):

        X11                       = ...  # 0x0
        Windows                   = ...  # 0x1
        QuickDraw                 = ...  # 0x2
        CoreGraphics              = ...  # 0x3
        MacPrinter                = ...  # 0x4
        QWindowSystem             = ...  # 0x5
        OpenGL                    = ...  # 0x6
        Picture                   = ...  # 0x7
        SVG                       = ...  # 0x8
        Raster                    = ...  # 0x9
        Direct3D                  = ...  # 0xa
        Pdf                       = ...  # 0xb
        OpenVG                    = ...  # 0xc
        OpenGL2                   = ...  # 0xd
        PaintBuffer               = ...  # 0xe
        Blitter                   = ...  # 0xf
        Direct2D                  = ...  # 0x10
        User                      = ...  # 0x32
        MaxUser                   = ...  # 0x64


    def __init__(self, features: PySide6.QtGui.QPaintEngine.PaintEngineFeature = ...) -> None: ...

    def begin(self, pdev: PySide6.QtGui.QPaintDevice) -> bool: ...
    def clearDirty(self, df: PySide6.QtGui.QPaintEngine.DirtyFlag) -> None: ...
    def coordinateOffset(self) -> PySide6.QtCore.QPoint: ...
    def createPixmap(self, size: PySide6.QtCore.QSize) -> PySide6.QtGui.QPixmap: ...
    def createPixmapFromImage(self, image: PySide6.QtGui.QImage, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    def drawEllipse(self, r: PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def drawEllipse(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    def drawImage(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, pm: PySide6.QtGui.QImage, sr: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @typing.overload
    def drawLines(self, lines: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, lineCount: int) -> None: ...
    @typing.overload
    def drawLines(self, lines: PySide6.QtCore.QLine, lineCount: int) -> None: ...
    def drawPath(self, path: PySide6.QtGui.QPainterPath) -> None: ...
    def drawPixmap(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, pm: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, sr: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def drawPoints(self, points: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, pointCount: int) -> None: ...
    @typing.overload
    def drawPoints(self, points: PySide6.QtCore.QPoint, pointCount: int) -> None: ...
    @typing.overload
    def drawPolygon(self, points: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, pointCount: int, mode: PySide6.QtGui.QPaintEngine.PolygonDrawMode) -> None: ...
    @typing.overload
    def drawPolygon(self, points: PySide6.QtCore.QPoint, pointCount: int, mode: PySide6.QtGui.QPaintEngine.PolygonDrawMode) -> None: ...
    @typing.overload
    def drawRects(self, rects: PySide6.QtCore.QRect, rectCount: int) -> None: ...
    @typing.overload
    def drawRects(self, rects: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, rectCount: int) -> None: ...
    def drawTextItem(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, textItem: PySide6.QtGui.QTextItem) -> None: ...
    def drawTiledPixmap(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, s: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def end(self) -> bool: ...
    def hasFeature(self, feature: PySide6.QtGui.QPaintEngine.PaintEngineFeature) -> bool: ...
    def isActive(self) -> bool: ...
    def isExtended(self) -> bool: ...
    def paintDevice(self) -> PySide6.QtGui.QPaintDevice: ...
    def painter(self) -> PySide6.QtGui.QPainter: ...
    def setActive(self, newState: bool) -> None: ...
    def setDirty(self, df: PySide6.QtGui.QPaintEngine.DirtyFlag) -> None: ...
    def setSystemClip(self, baseClip: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> None: ...
    def setSystemRect(self, rect: PySide6.QtCore.QRect) -> None: ...
    def syncState(self) -> None: ...
    def systemClip(self) -> PySide6.QtGui.QRegion: ...
    def systemRect(self) -> PySide6.QtCore.QRect: ...
    def testDirty(self, df: PySide6.QtGui.QPaintEngine.DirtyFlag) -> bool: ...
    def type(self) -> PySide6.QtGui.QPaintEngine.Type: ...
    def updateState(self, state: PySide6.QtGui.QPaintEngineState) -> None: ...


class QPaintEngineState(Shiboken.Object):

    def __init__(self) -> None: ...

    def backgroundBrush(self) -> PySide6.QtGui.QBrush: ...
    def backgroundMode(self) -> PySide6.QtCore.Qt.BGMode: ...
    def brush(self) -> PySide6.QtGui.QBrush: ...
    def brushNeedsResolving(self) -> bool: ...
    def brushOrigin(self) -> PySide6.QtCore.QPointF: ...
    def clipOperation(self) -> PySide6.QtCore.Qt.ClipOperation: ...
    def clipPath(self) -> PySide6.QtGui.QPainterPath: ...
    def clipRegion(self) -> PySide6.QtGui.QRegion: ...
    def compositionMode(self) -> PySide6.QtGui.QPainter.CompositionMode: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def isClipEnabled(self) -> bool: ...
    def opacity(self) -> float: ...
    def painter(self) -> PySide6.QtGui.QPainter: ...
    def pen(self) -> PySide6.QtGui.QPen: ...
    def penNeedsResolving(self) -> bool: ...
    def renderHints(self) -> PySide6.QtGui.QPainter.RenderHint: ...
    def state(self) -> PySide6.QtGui.QPaintEngine.DirtyFlag: ...
    def transform(self) -> PySide6.QtGui.QTransform: ...


class QPaintEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, paintRect: PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def __init__(self, paintRegion: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QPaintEvent: ...
    def rect(self) -> PySide6.QtCore.QRect: ...
    def region(self) -> PySide6.QtGui.QRegion: ...


class QPainter(Shiboken.Object):

    class CompositionMode(enum.Enum):

        CompositionMode_SourceOver = ...  # 0x0
        CompositionMode_DestinationOver = ...  # 0x1
        CompositionMode_Clear     = ...  # 0x2
        CompositionMode_Source    = ...  # 0x3
        CompositionMode_Destination = ...  # 0x4
        CompositionMode_SourceIn  = ...  # 0x5
        CompositionMode_DestinationIn = ...  # 0x6
        CompositionMode_SourceOut = ...  # 0x7
        CompositionMode_DestinationOut = ...  # 0x8
        CompositionMode_SourceAtop = ...  # 0x9
        CompositionMode_DestinationAtop = ...  # 0xa
        CompositionMode_Xor       = ...  # 0xb
        CompositionMode_Plus      = ...  # 0xc
        CompositionMode_Multiply  = ...  # 0xd
        CompositionMode_Screen    = ...  # 0xe
        CompositionMode_Overlay   = ...  # 0xf
        CompositionMode_Darken    = ...  # 0x10
        CompositionMode_Lighten   = ...  # 0x11
        CompositionMode_ColorDodge = ...  # 0x12
        CompositionMode_ColorBurn = ...  # 0x13
        CompositionMode_HardLight = ...  # 0x14
        CompositionMode_SoftLight = ...  # 0x15
        CompositionMode_Difference = ...  # 0x16
        CompositionMode_Exclusion = ...  # 0x17
        RasterOp_SourceOrDestination = ...  # 0x18
        RasterOp_SourceAndDestination = ...  # 0x19
        RasterOp_SourceXorDestination = ...  # 0x1a
        RasterOp_NotSourceAndNotDestination = ...  # 0x1b
        RasterOp_NotSourceOrNotDestination = ...  # 0x1c
        RasterOp_NotSourceXorDestination = ...  # 0x1d
        RasterOp_NotSource        = ...  # 0x1e
        RasterOp_NotSourceAndDestination = ...  # 0x1f
        RasterOp_SourceAndNotDestination = ...  # 0x20
        RasterOp_NotSourceOrDestination = ...  # 0x21
        RasterOp_SourceOrNotDestination = ...  # 0x22
        RasterOp_ClearDestination = ...  # 0x23
        RasterOp_SetDestination   = ...  # 0x24
        RasterOp_NotDestination   = ...  # 0x25

    class PixmapFragment(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, PixmapFragment: PySide6.QtGui.QPainter.PixmapFragment) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        @staticmethod
        def create(pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, sourceRect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, scaleX: float = ..., scaleY: float = ..., rotation: float = ..., opacity: float = ...) -> PySide6.QtGui.QPainter.PixmapFragment: ...

    class PixmapFragmentHint(enum.Flag):

        OpaqueHint                = ...  # 0x1

    class RenderHint(enum.Flag):

        Antialiasing              = ...  # 0x1
        TextAntialiasing          = ...  # 0x2
        SmoothPixmapTransform     = ...  # 0x4
        VerticalSubpixelPositioning = ...  # 0x8
        LosslessImageRendering    = ...  # 0x40
        NonCosmeticBrushPatterns  = ...  # 0x80


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QPaintDevice) -> None: ...

    def __enter__(self) -> PySide6.QtGui.QPainter: ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object) -> None: ...
    def background(self) -> PySide6.QtGui.QBrush: ...
    def backgroundMode(self) -> PySide6.QtCore.Qt.BGMode: ...
    def begin(self, arg__1: PySide6.QtGui.QPaintDevice) -> bool: ...
    def beginNativePainting(self) -> None: ...
    @typing.overload
    def boundingRect(self, rect: PySide6.QtCore.QRect, flags: int, text: str) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, text: str, o: PySide6.QtGui.QTextOption | PySide6.QtCore.Qt.AlignmentFlag= ...) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, flags: int, text: str) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, x: int, y: int, w: int, h: int, flags: int, text: str) -> PySide6.QtCore.QRect: ...
    def brush(self) -> PySide6.QtGui.QBrush: ...
    def brushOrigin(self) -> PySide6.QtCore.QPoint: ...
    def clipBoundingRect(self) -> PySide6.QtCore.QRectF: ...
    def clipPath(self) -> PySide6.QtGui.QPainterPath: ...
    def clipRegion(self) -> PySide6.QtGui.QRegion: ...
    def combinedTransform(self) -> PySide6.QtGui.QTransform: ...
    def compositionMode(self) -> PySide6.QtGui.QPainter.CompositionMode: ...
    def device(self) -> PySide6.QtGui.QPaintDevice: ...
    def deviceTransform(self) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    def drawArc(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, a: int, alen: int) -> None: ...
    @typing.overload
    def drawArc(self, arg__1: PySide6.QtCore.QRect, a: int, alen: int) -> None: ...
    @typing.overload
    def drawArc(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @typing.overload
    def drawChord(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, a: int, alen: int) -> None: ...
    @typing.overload
    def drawChord(self, arg__1: PySide6.QtCore.QRect, a: int, alen: int) -> None: ...
    @typing.overload
    def drawChord(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @typing.overload
    def drawConvexPolygon(self, polygon: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> None: ...
    @typing.overload
    def drawConvexPolygon(self, arg__1: typing.Sequence[PySide6.QtCore.QPointF]) -> None: ...
    @typing.overload
    def drawConvexPolygon(self, polygon: PySide6.QtGui.QPolygon | typing.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def drawConvexPolygon(self, arg__1: typing.Sequence[PySide6.QtCore.QPoint]) -> None: ...
    @typing.overload
    def drawEllipse(self, center: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, rx: float, ry: float) -> None: ...
    @typing.overload
    def drawEllipse(self, r: PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def drawEllipse(self, center: PySide6.QtCore.QPoint, rx: int, ry: int) -> None: ...
    @typing.overload
    def drawEllipse(self, x: int, y: int, w: int, h: int) -> None: ...
    @typing.overload
    def drawEllipse(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    def drawGlyphRun(self, position: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, glyphRun: PySide6.QtGui.QGlyphRun) -> None: ...
    @typing.overload
    def drawImage(self, targetRect: PySide6.QtCore.QRect, image: PySide6.QtGui.QImage, sourceRect: PySide6.QtCore.QRect, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @typing.overload
    def drawImage(self, targetRect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, image: PySide6.QtGui.QImage, sourceRect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @typing.overload
    def drawImage(self, x: int, y: int, image: PySide6.QtGui.QImage, sx: int = ..., sy: int = ..., sw: int = ..., sh: int = ..., flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @typing.overload
    def drawImage(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, image: PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def drawImage(self, p: PySide6.QtCore.QPoint, image: PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def drawImage(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, image: PySide6.QtGui.QImage, sr: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @typing.overload
    def drawImage(self, r: PySide6.QtCore.QRect, image: PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def drawImage(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, image: PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def drawImage(self, p: PySide6.QtCore.QPoint, image: PySide6.QtGui.QImage, sr: PySide6.QtCore.QRect, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @typing.overload
    def drawLine(self, line: PySide6.QtCore.QLineF | PySide6.QtCore.QLine) -> None: ...
    @typing.overload
    def drawLine(self, line: PySide6.QtCore.QLine) -> None: ...
    @typing.overload
    def drawLine(self, x1: int, y1: int, x2: int, y2: int) -> None: ...
    @typing.overload
    def drawLine(self, p1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, p2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def drawLine(self, p1: PySide6.QtCore.QPoint, p2: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def drawLines(self, lines: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, lineCount: int) -> None: ...
    @typing.overload
    def drawLines(self, pointPairs: typing.Sequence[PySide6.QtCore.QPointF]) -> None: ...
    @typing.overload
    def drawLines(self, pointPairs: typing.Sequence[PySide6.QtCore.QPoint]) -> None: ...
    @typing.overload
    def drawLines(self, lines: typing.Sequence[PySide6.QtCore.QLine]) -> None: ...
    @typing.overload
    def drawLines(self, lines: typing.Sequence[PySide6.QtCore.QLineF]) -> None: ...
    def drawPath(self, path: PySide6.QtGui.QPainterPath) -> None: ...
    @typing.overload
    def drawPicture(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, picture: PySide6.QtGui.QPicture | int) -> None: ...
    @typing.overload
    def drawPicture(self, p: PySide6.QtCore.QPoint, picture: PySide6.QtGui.QPicture | int) -> None: ...
    @typing.overload
    def drawPicture(self, x: int, y: int, picture: PySide6.QtGui.QPicture | int) -> None: ...
    @typing.overload
    def drawPie(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, a: int, alen: int) -> None: ...
    @typing.overload
    def drawPie(self, arg__1: PySide6.QtCore.QRect, a: int, alen: int) -> None: ...
    @typing.overload
    def drawPie(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @typing.overload
    def drawPixmap(self, x: int, y: int, pm: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def drawPixmap(self, targetRect: PySide6.QtCore.QRect, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, sourceRect: PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def drawPixmap(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, pm: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def drawPixmap(self, p: PySide6.QtCore.QPoint, pm: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def drawPixmap(self, x: int, y: int, pm: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, sx: int, sy: int, sw: int, sh: int) -> None: ...
    @typing.overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, sx: int, sy: int, sw: int, sh: int) -> None: ...
    @typing.overload
    def drawPixmap(self, targetRect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, sourceRect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def drawPixmap(self, r: PySide6.QtCore.QRect, pm: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def drawPixmap(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, pm: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, sr: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def drawPixmap(self, p: PySide6.QtCore.QPoint, pm: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, sr: PySide6.QtCore.QRect) -> None: ...
    def drawPixmapFragments(self, fragments: PySide6.QtGui.QPainter.PixmapFragment, fragmentCount: int, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, hints: PySide6.QtGui.QPainter.PixmapFragmentHint = ...) -> None: ...
    @typing.overload
    def drawPoint(self, pt: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def drawPoint(self, p: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def drawPoint(self, x: int, y: int) -> None: ...
    @typing.overload
    def drawPoints(self, points: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> None: ...
    @typing.overload
    def drawPoints(self, points: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, pointCount: int) -> None: ...
    @typing.overload
    def drawPoints(self, arg__1: typing.Sequence[PySide6.QtCore.QPointF]) -> None: ...
    @typing.overload
    def drawPoints(self, arg__1: typing.Sequence[PySide6.QtCore.QPoint]) -> None: ...
    @typing.overload
    def drawPoints(self, points: PySide6.QtGui.QPolygon | typing.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect) -> None: ...
    def drawPointsNp(self, x: typing.Sequence[typing.Any], y: typing.Sequence[typing.Any]) -> None: ...
    @typing.overload
    def drawPolygon(self, arg__1: typing.Sequence[PySide6.QtCore.QPoint], arg__2: PySide6.QtCore.Qt.FillRule) -> None: ...
    @typing.overload
    def drawPolygon(self, polygon: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, fillRule: PySide6.QtCore.Qt.FillRule = ...) -> None: ...
    @typing.overload
    def drawPolygon(self, polygon: PySide6.QtGui.QPolygon | typing.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect, fillRule: PySide6.QtCore.Qt.FillRule = ...) -> None: ...
    @typing.overload
    def drawPolygon(self, arg__1: typing.Sequence[PySide6.QtCore.QPointF], arg__2: PySide6.QtCore.Qt.FillRule) -> None: ...
    @typing.overload
    def drawPolyline(self, arg__1: typing.Sequence[PySide6.QtCore.QPointF]) -> None: ...
    @typing.overload
    def drawPolyline(self, polygon: PySide6.QtGui.QPolygon | typing.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def drawPolyline(self, polyline: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> None: ...
    @typing.overload
    def drawPolyline(self, arg__1: typing.Sequence[PySide6.QtCore.QPoint]) -> None: ...
    @typing.overload
    def drawRect(self, rect: PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def drawRect(self, x1: int, y1: int, w: int, h: int) -> None: ...
    @typing.overload
    def drawRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def drawRects(self, rectangles: typing.Sequence[PySide6.QtCore.QRectF]) -> None: ...
    @typing.overload
    def drawRects(self, rects: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, rectCount: int) -> None: ...
    @typing.overload
    def drawRects(self, rectangles: typing.Sequence[PySide6.QtCore.QRect]) -> None: ...
    @typing.overload
    def drawRoundedRect(self, x: int, y: int, w: int, h: int, xRadius: float, yRadius: float, mode: PySide6.QtCore.Qt.SizeMode = ...) -> None: ...
    @typing.overload
    def drawRoundedRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, xRadius: float, yRadius: float, mode: PySide6.QtCore.Qt.SizeMode = ...) -> None: ...
    @typing.overload
    def drawRoundedRect(self, rect: PySide6.QtCore.QRect, xRadius: float, yRadius: float, mode: PySide6.QtCore.Qt.SizeMode = ...) -> None: ...
    @typing.overload
    def drawStaticText(self, left: int, top: int, staticText: PySide6.QtGui.QStaticText) -> None: ...
    @typing.overload
    def drawStaticText(self, topLeftPosition: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, staticText: PySide6.QtGui.QStaticText) -> None: ...
    @typing.overload
    def drawStaticText(self, topLeftPosition: PySide6.QtCore.QPoint, staticText: PySide6.QtGui.QStaticText) -> None: ...
    @typing.overload
    def drawText(self, x: int, y: int, s: str) -> None: ...
    @typing.overload
    def drawText(self, x: int, y: int, w: int, h: int, flags: int, text: str) -> None: ...
    @typing.overload
    def drawText(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, flags: int, text: str) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def drawText(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, text: str, o: PySide6.QtGui.QTextOption | PySide6.QtCore.Qt.AlignmentFlag= ...) -> None: ...
    @typing.overload
    def drawText(self, r: PySide6.QtCore.QRect, flags: int, text: str) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def drawText(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, s: str) -> None: ...
    @typing.overload
    def drawText(self, p: PySide6.QtCore.QPoint, s: str) -> None: ...
    @typing.overload
    def drawTextItem(self, x: int, y: int, ti: PySide6.QtGui.QTextItem) -> None: ...
    @typing.overload
    def drawTextItem(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, ti: PySide6.QtGui.QTextItem) -> None: ...
    @typing.overload
    def drawTextItem(self, p: PySide6.QtCore.QPoint, ti: PySide6.QtGui.QTextItem) -> None: ...
    @typing.overload
    def drawTiledPixmap(self, x: int, y: int, w: int, h: int, arg__5: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, sx: int = ..., sy: int = ...) -> None: ...
    @typing.overload
    def drawTiledPixmap(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, pm: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, offset: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element= ...) -> None: ...
    @typing.overload
    def drawTiledPixmap(self, arg__1: PySide6.QtCore.QRect, arg__2: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, pos: PySide6.QtCore.QPoint = ...) -> None: ...
    def end(self) -> bool: ...
    def endNativePainting(self) -> None: ...
    @typing.overload
    def eraseRect(self, arg__1: PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def eraseRect(self, arg__1: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def eraseRect(self, x: int, y: int, w: int, h: int) -> None: ...
    def fillPath(self, path: PySide6.QtGui.QPainterPath, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    @typing.overload
    def fillRect(self, arg__1: PySide6.QtCore.QRect, arg__2: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    @typing.overload
    def fillRect(self, arg__1: PySide6.QtCore.QRect, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    @typing.overload
    def fillRect(self, r: PySide6.QtCore.QRect, preset: PySide6.QtGui.QGradient.Preset) -> None: ...
    @typing.overload
    def fillRect(self, arg__1: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, c: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, style: PySide6.QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def fillRect(self, arg__1: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, arg__2: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    @typing.overload
    def fillRect(self, r: PySide6.QtCore.QRect, style: PySide6.QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def fillRect(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, style: PySide6.QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def fillRect(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, c: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, preset: PySide6.QtGui.QGradient.Preset) -> None: ...
    @typing.overload
    def fillRect(self, r: PySide6.QtCore.QRect, c: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, arg__5: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    @typing.overload
    def fillRect(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, preset: PySide6.QtGui.QGradient.Preset) -> None: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def fontInfo(self) -> PySide6.QtGui.QFontInfo: ...
    def fontMetrics(self) -> PySide6.QtGui.QFontMetrics: ...
    def hasClipping(self) -> bool: ...
    def isActive(self) -> bool: ...
    def layoutDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def opacity(self) -> float: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def pen(self) -> PySide6.QtGui.QPen: ...
    def renderHints(self) -> PySide6.QtGui.QPainter.RenderHint: ...
    def resetTransform(self) -> None: ...
    def restore(self) -> None: ...
    def rotate(self, a: float) -> None: ...
    def save(self) -> None: ...
    def scale(self, sx: float, sy: float) -> None: ...
    def setBackground(self, bg: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setBackgroundMode(self, mode: PySide6.QtCore.Qt.BGMode) -> None: ...
    @typing.overload
    def setBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    @typing.overload
    def setBrush(self, style: PySide6.QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def setBrushOrigin(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def setBrushOrigin(self, arg__1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def setBrushOrigin(self, x: int, y: int) -> None: ...
    def setClipPath(self, path: PySide6.QtGui.QPainterPath, op: PySide6.QtCore.Qt.ClipOperation = ...) -> None: ...
    @typing.overload
    def setClipRect(self, x: int, y: int, w: int, h: int, op: PySide6.QtCore.Qt.ClipOperation = ...) -> None: ...
    @typing.overload
    def setClipRect(self, arg__1: PySide6.QtCore.QRect, op: PySide6.QtCore.Qt.ClipOperation = ...) -> None: ...
    @typing.overload
    def setClipRect(self, arg__1: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, op: PySide6.QtCore.Qt.ClipOperation = ...) -> None: ...
    def setClipRegion(self, arg__1: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect, op: PySide6.QtCore.Qt.ClipOperation = ...) -> None: ...
    def setClipping(self, enable: bool) -> None: ...
    def setCompositionMode(self, mode: PySide6.QtGui.QPainter.CompositionMode) -> None: ...
    def setFont(self, f: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> None: ...
    def setLayoutDirection(self, direction: PySide6.QtCore.Qt.LayoutDirection) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    @typing.overload
    def setPen(self, style: PySide6.QtCore.Qt.PenStyle) -> None: ...
    @typing.overload
    def setPen(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    @typing.overload
    def setPen(self, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor) -> None: ...
    def setRenderHint(self, hint: PySide6.QtGui.QPainter.RenderHint, on: bool = ...) -> None: ...
    def setRenderHints(self, hints: PySide6.QtGui.QPainter.RenderHint, on: bool = ...) -> None: ...
    def setTransform(self, transform: PySide6.QtGui.QTransform, combine: bool = ...) -> None: ...
    def setViewTransformEnabled(self, enable: bool) -> None: ...
    @typing.overload
    def setViewport(self, viewport: PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def setViewport(self, x: int, y: int, w: int, h: int) -> None: ...
    @typing.overload
    def setWindow(self, window: PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def setWindow(self, x: int, y: int, w: int, h: int) -> None: ...
    def setWorldMatrixEnabled(self, enabled: bool) -> None: ...
    def setWorldTransform(self, matrix: PySide6.QtGui.QTransform, combine: bool = ...) -> None: ...
    def shear(self, sh: float, sv: float) -> None: ...
    def strokePath(self, path: PySide6.QtGui.QPainterPath, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor) -> None: ...
    def testRenderHint(self, hint: PySide6.QtGui.QPainter.RenderHint) -> bool: ...
    def transform(self) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    def translate(self, offset: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def translate(self, dx: float, dy: float) -> None: ...
    @typing.overload
    def translate(self, offset: PySide6.QtCore.QPoint) -> None: ...
    def viewTransformEnabled(self) -> bool: ...
    def viewport(self) -> PySide6.QtCore.QRect: ...
    def window(self) -> PySide6.QtCore.QRect: ...
    def worldMatrixEnabled(self) -> bool: ...
    def worldTransform(self) -> PySide6.QtGui.QTransform: ...


class PixmapFragment(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, PixmapFragment: PySide6.QtGui.QPainter.PixmapFragment) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def create(pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, sourceRect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, scaleX: float = ..., scaleY: float = ..., rotation: float = ..., opacity: float = ...) -> PySide6.QtGui.QPainter.PixmapFragment: ...


class QPainterPath(Shiboken.Object):

    class Element(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Element: PySide6.QtGui.QPainterPath.Element) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def isCurveTo(self) -> bool: ...
        def isLineTo(self) -> bool: ...
        def isMoveTo(self) -> bool: ...

    class ElementType(enum.Enum):

        MoveToElement             = ...  # 0x0
        LineToElement             = ...  # 0x1
        CurveToElement            = ...  # 0x2
        CurveToDataElement        = ...  # 0x3


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QPainterPath) -> None: ...
    @typing.overload
    def __init__(self, startPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...

    def __add__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def __and__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def __iand__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def __ior__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def __isub__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __mul__(self, m: PySide6.QtGui.QTransform) -> PySide6.QtGui.QPainterPath: ...
    def __or__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @typing.overload
    def addEllipse(self, x: float, y: float, w: float, h: float) -> None: ...
    @typing.overload
    def addEllipse(self, center: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, rx: float, ry: float) -> None: ...
    @typing.overload
    def addEllipse(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    def addPath(self, path: PySide6.QtGui.QPainterPath) -> None: ...
    def addPolygon(self, polygon: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> None: ...
    @typing.overload
    def addRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @typing.overload
    def addRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    def addRegion(self, region: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def addRoundedRect(self, x: float, y: float, w: float, h: float, xRadius: float, yRadius: float, mode: PySide6.QtCore.Qt.SizeMode = ...) -> None: ...
    @typing.overload
    def addRoundedRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, xRadius: float, yRadius: float, mode: PySide6.QtCore.Qt.SizeMode = ...) -> None: ...
    @typing.overload
    def addText(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, f: PySide6.QtGui.QFont | str | typing.Sequence[str], text: str) -> None: ...
    @typing.overload
    def addText(self, x: float, y: float, f: PySide6.QtGui.QFont | str | typing.Sequence[str], text: str) -> None: ...
    def angleAtPercent(self, t: float) -> float: ...
    @typing.overload
    def arcMoveTo(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, angle: float) -> None: ...
    @typing.overload
    def arcMoveTo(self, x: float, y: float, w: float, h: float, angle: float) -> None: ...
    @typing.overload
    def arcTo(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, startAngle: float, arcLength: float) -> None: ...
    @typing.overload
    def arcTo(self, x: float, y: float, w: float, h: float, startAngle: float, arcLength: float) -> None: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def closeSubpath(self) -> None: ...
    def connectPath(self, path: PySide6.QtGui.QPainterPath) -> None: ...
    @typing.overload
    def contains(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> bool: ...
    @typing.overload
    def contains(self, pt: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> bool: ...
    @typing.overload
    def contains(self, p: PySide6.QtGui.QPainterPath) -> bool: ...
    def controlPointRect(self) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def cubicTo(self, ctrlPt1x: float, ctrlPt1y: float, ctrlPt2x: float, ctrlPt2y: float, endPtx: float, endPty: float) -> None: ...
    @typing.overload
    def cubicTo(self, ctrlPt1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, ctrlPt2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, endPt: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def currentPosition(self) -> PySide6.QtCore.QPointF: ...
    def elementAt(self, i: int) -> PySide6.QtGui.QPainterPath.Element: ...
    def elementCount(self) -> int: ...
    def fillRule(self) -> PySide6.QtCore.Qt.FillRule: ...
    def intersected(self, r: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @typing.overload
    def intersects(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> bool: ...
    @typing.overload
    def intersects(self, p: PySide6.QtGui.QPainterPath) -> bool: ...
    def isEmpty(self) -> bool: ...
    def length(self) -> float: ...
    @typing.overload
    def lineTo(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def lineTo(self, x: float, y: float) -> None: ...
    @typing.overload
    def moveTo(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def moveTo(self, x: float, y: float) -> None: ...
    def percentAtLength(self, t: float) -> float: ...
    def pointAtPercent(self, t: float) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def quadTo(self, ctrlPtx: float, ctrlPty: float, endPtx: float, endPty: float) -> None: ...
    @typing.overload
    def quadTo(self, ctrlPt: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, endPt: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def reserve(self, size: int) -> None: ...
    def setElementPositionAt(self, i: int, x: float, y: float) -> None: ...
    def setFillRule(self, fillRule: PySide6.QtCore.Qt.FillRule) -> None: ...
    def simplified(self) -> PySide6.QtGui.QPainterPath: ...
    def slopeAtPercent(self, t: float) -> float: ...
    def subtracted(self, r: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def swap(self, other: PySide6.QtGui.QPainterPath) -> None: ...
    def toFillPolygon(self, matrix: PySide6.QtGui.QTransform = ...) -> PySide6.QtGui.QPolygonF: ...
    def toFillPolygons(self, matrix: PySide6.QtGui.QTransform = ...) -> typing.List[PySide6.QtGui.QPolygonF]: ...
    def toReversed(self) -> PySide6.QtGui.QPainterPath: ...
    def toSubpathPolygons(self, matrix: PySide6.QtGui.QTransform = ...) -> typing.List[PySide6.QtGui.QPolygonF]: ...
    @typing.overload
    def translate(self, offset: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def translate(self, dx: float, dy: float) -> None: ...
    @typing.overload
    def translated(self, offset: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> PySide6.QtGui.QPainterPath: ...
    @typing.overload
    def translated(self, dx: float, dy: float) -> PySide6.QtGui.QPainterPath: ...
    def united(self, r: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...


class Element(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, Element: PySide6.QtGui.QPainterPath.Element) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def isCurveTo(self) -> bool: ...
    def isLineTo(self) -> bool: ...
    def isMoveTo(self) -> bool: ...


class QPainterPathStroker(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor) -> None: ...

    def capStyle(self) -> PySide6.QtCore.Qt.PenCapStyle: ...
    def createStroke(self, path: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    def curveThreshold(self) -> float: ...
    def dashOffset(self) -> float: ...
    def dashPattern(self) -> typing.List[float]: ...
    def joinStyle(self) -> PySide6.QtCore.Qt.PenJoinStyle: ...
    def miterLimit(self) -> float: ...
    def setCapStyle(self, style: PySide6.QtCore.Qt.PenCapStyle) -> None: ...
    def setCurveThreshold(self, threshold: float) -> None: ...
    def setDashOffset(self, offset: float) -> None: ...
    @typing.overload
    def setDashPattern(self, arg__1: PySide6.QtCore.Qt.PenStyle) -> None: ...
    @typing.overload
    def setDashPattern(self, dashPattern: typing.Sequence[float]) -> None: ...
    def setJoinStyle(self, style: PySide6.QtCore.Qt.PenJoinStyle) -> None: ...
    def setMiterLimit(self, length: float) -> None: ...
    def setWidth(self, width: float) -> None: ...
    def width(self) -> float: ...


class QPalette(Shiboken.Object):

    class ColorGroup(enum.Enum):

        Active                    = ...  # 0x0
        Normal                    = ...  # 0x0
        Disabled                  = ...  # 0x1
        Inactive                  = ...  # 0x2
        NColorGroups              = ...  # 0x3
        Current                   = ...  # 0x4
        All                       = ...  # 0x5

    class ColorRole(enum.Enum):

        WindowText                = ...  # 0x0
        Button                    = ...  # 0x1
        Light                     = ...  # 0x2
        Midlight                  = ...  # 0x3
        Dark                      = ...  # 0x4
        Mid                       = ...  # 0x5
        Text                      = ...  # 0x6
        BrightText                = ...  # 0x7
        ButtonText                = ...  # 0x8
        Base                      = ...  # 0x9
        Window                    = ...  # 0xa
        Shadow                    = ...  # 0xb
        Highlight                 = ...  # 0xc
        HighlightedText           = ...  # 0xd
        Link                      = ...  # 0xe
        LinkVisited               = ...  # 0xf
        AlternateBase             = ...  # 0x10
        NoRole                    = ...  # 0x11
        ToolTipBase               = ...  # 0x12
        ToolTipText               = ...  # 0x13
        PlaceholderText           = ...  # 0x14
        Accent                    = ...  # 0x15
        NColorRoles               = ...  # 0x16


    @typing.overload
    def __init__(self, palette: PySide6.QtGui.QPalette) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, button: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    @typing.overload
    def __init__(self, windowText: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, window: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, light: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, dark: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, mid: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, text: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, base: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    @typing.overload
    def __init__(self, button: PySide6.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def __init__(self, windowText: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, button: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, light: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, dark: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, mid: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, text: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, bright_text: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, base: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, window: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    @typing.overload
    def __init__(self, button: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, window: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, ds: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, ds: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def accent(self) -> PySide6.QtGui.QBrush: ...
    def alternateBase(self) -> PySide6.QtGui.QBrush: ...
    def base(self) -> PySide6.QtGui.QBrush: ...
    def brightText(self) -> PySide6.QtGui.QBrush: ...
    @typing.overload
    def brush(self, cr: PySide6.QtGui.QPalette.ColorRole) -> PySide6.QtGui.QBrush: ...
    @typing.overload
    def brush(self, cg: PySide6.QtGui.QPalette.ColorGroup, cr: PySide6.QtGui.QPalette.ColorRole) -> PySide6.QtGui.QBrush: ...
    def button(self) -> PySide6.QtGui.QBrush: ...
    def buttonText(self) -> PySide6.QtGui.QBrush: ...
    def cacheKey(self) -> int: ...
    @typing.overload
    def color(self, cr: PySide6.QtGui.QPalette.ColorRole) -> PySide6.QtGui.QColor: ...
    @typing.overload
    def color(self, cg: PySide6.QtGui.QPalette.ColorGroup, cr: PySide6.QtGui.QPalette.ColorRole) -> PySide6.QtGui.QColor: ...
    def currentColorGroup(self) -> PySide6.QtGui.QPalette.ColorGroup: ...
    def dark(self) -> PySide6.QtGui.QBrush: ...
    def highlight(self) -> PySide6.QtGui.QBrush: ...
    def highlightedText(self) -> PySide6.QtGui.QBrush: ...
    def isBrushSet(self, cg: PySide6.QtGui.QPalette.ColorGroup, cr: PySide6.QtGui.QPalette.ColorRole) -> bool: ...
    def isCopyOf(self, p: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor) -> bool: ...
    def isEqual(self, cr1: PySide6.QtGui.QPalette.ColorGroup, cr2: PySide6.QtGui.QPalette.ColorGroup) -> bool: ...
    def light(self) -> PySide6.QtGui.QBrush: ...
    def link(self) -> PySide6.QtGui.QBrush: ...
    def linkVisited(self) -> PySide6.QtGui.QBrush: ...
    def mid(self) -> PySide6.QtGui.QBrush: ...
    def midlight(self) -> PySide6.QtGui.QBrush: ...
    def placeholderText(self) -> PySide6.QtGui.QBrush: ...
    def resolve(self, other: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor) -> PySide6.QtGui.QPalette: ...
    def resolveMask(self) -> int: ...
    @typing.overload
    def setBrush(self, cr: PySide6.QtGui.QPalette.ColorRole, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    @typing.overload
    def setBrush(self, cg: PySide6.QtGui.QPalette.ColorGroup, cr: PySide6.QtGui.QPalette.ColorRole, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    @typing.overload
    def setColor(self, cg: PySide6.QtGui.QPalette.ColorGroup, cr: PySide6.QtGui.QPalette.ColorRole, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    @typing.overload
    def setColor(self, cr: PySide6.QtGui.QPalette.ColorRole, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    def setColorGroup(self, cr: PySide6.QtGui.QPalette.ColorGroup, windowText: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, button: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, light: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, dark: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, mid: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, text: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, bright_text: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, base: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, window: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setCurrentColorGroup(self, cg: PySide6.QtGui.QPalette.ColorGroup) -> None: ...
    def setResolveMask(self, mask: int) -> None: ...
    def shadow(self) -> PySide6.QtGui.QBrush: ...
    def swap(self, other: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor) -> None: ...
    def text(self) -> PySide6.QtGui.QBrush: ...
    def toolTipBase(self) -> PySide6.QtGui.QBrush: ...
    def toolTipText(self) -> PySide6.QtGui.QBrush: ...
    def window(self) -> PySide6.QtGui.QBrush: ...
    def windowText(self) -> PySide6.QtGui.QBrush: ...


class QPdfWriter(PySide6.QtCore.QObject, PySide6.QtGui.QPagedPaintDevice):

    class ColorModel(enum.Enum):

        RGB                       = ...  # 0x0
        Grayscale                 = ...  # 0x1
        CMYK                      = ...  # 0x2
        Auto                      = ...  # 0x3


    @typing.overload
    def __init__(self, filename: str) -> None: ...
    @typing.overload
    def __init__(self, device: PySide6.QtCore.QIODevice) -> None: ...

    def addFileAttachment(self, fileName: str, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, mimeType: str = ...) -> None: ...
    def colorModel(self) -> PySide6.QtGui.QPdfWriter.ColorModel: ...
    def creator(self) -> str: ...
    def documentId(self) -> PySide6.QtCore.QUuid: ...
    def documentXmpMetadata(self) -> PySide6.QtCore.QByteArray: ...
    def metric(self, id: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def newPage(self) -> bool: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def pdfVersion(self) -> PySide6.QtGui.QPagedPaintDevice.PdfVersion: ...
    def resolution(self) -> int: ...
    def setColorModel(self, model: PySide6.QtGui.QPdfWriter.ColorModel) -> None: ...
    def setCreator(self, creator: str) -> None: ...
    def setDocumentId(self, documentId: PySide6.QtCore.QUuid) -> None: ...
    def setDocumentXmpMetadata(self, xmpMetadata: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    def setPdfVersion(self, version: PySide6.QtGui.QPagedPaintDevice.PdfVersion) -> None: ...
    def setResolution(self, resolution: int) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...


class QPen(Shiboken.Object):

    @typing.overload
    def __init__(self, pen: PySide6.QtGui.QPen) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.Qt.PenStyle) -> None: ...
    @typing.overload
    def __init__(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, width: float, s: PySide6.QtCore.Qt.PenStyle = ..., c: PySide6.QtCore.Qt.PenCapStyle = ..., j: PySide6.QtCore.Qt.PenJoinStyle = ...) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def brush(self) -> PySide6.QtGui.QBrush: ...
    def capStyle(self) -> PySide6.QtCore.Qt.PenCapStyle: ...
    def color(self) -> PySide6.QtGui.QColor: ...
    def dashOffset(self) -> float: ...
    def dashPattern(self) -> typing.List[float]: ...
    def isCosmetic(self) -> bool: ...
    def isSolid(self) -> bool: ...
    def joinStyle(self) -> PySide6.QtCore.Qt.PenJoinStyle: ...
    def miterLimit(self) -> float: ...
    def setBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setCapStyle(self, pcs: PySide6.QtCore.Qt.PenCapStyle) -> None: ...
    def setColor(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    def setCosmetic(self, cosmetic: bool) -> None: ...
    def setDashOffset(self, doffset: float) -> None: ...
    def setDashPattern(self, pattern: typing.Sequence[float]) -> None: ...
    def setJoinStyle(self, pcs: PySide6.QtCore.Qt.PenJoinStyle) -> None: ...
    def setMiterLimit(self, limit: float) -> None: ...
    def setStyle(self, arg__1: PySide6.QtCore.Qt.PenStyle) -> None: ...
    def setWidth(self, width: int) -> None: ...
    def setWidthF(self, width: float) -> None: ...
    def style(self) -> PySide6.QtCore.Qt.PenStyle: ...
    def swap(self, other: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor) -> None: ...
    def width(self) -> int: ...
    def widthF(self) -> float: ...


class QPicture(PySide6.QtGui.QPaintDevice):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QPicture) -> None: ...
    @typing.overload
    def __init__(self, formatVersion: int = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def boundingRect(self) -> PySide6.QtCore.QRect: ...
    def data(self) -> object: ...
    def devType(self) -> int: ...
    def isNull(self) -> bool: ...
    @typing.overload
    def load(self, dev: PySide6.QtCore.QIODevice) -> bool: ...
    @typing.overload
    def load(self, fileName: str) -> bool: ...
    def metric(self, m: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def play(self, p: PySide6.QtGui.QPainter) -> bool: ...
    @typing.overload
    def save(self, dev: PySide6.QtCore.QIODevice) -> bool: ...
    @typing.overload
    def save(self, fileName: str) -> bool: ...
    def setBoundingRect(self, r: PySide6.QtCore.QRect) -> None: ...
    def setData(self, data: bytes | bytearray | memoryview) -> None: ...
    def size(self) -> int: ...
    def swap(self, other: PySide6.QtGui.QPicture | int) -> None: ...


class QPixelFormat(Shiboken.Object):

    class AlphaPosition(enum.Enum):

        AtBeginning               = ...  # 0x0
        AtEnd                     = ...  # 0x1

    class AlphaPremultiplied(enum.Enum):

        NotPremultiplied          = ...  # 0x0
        Premultiplied             = ...  # 0x1

    class AlphaUsage(enum.Enum):

        UsesAlpha                 = ...  # 0x0
        IgnoresAlpha              = ...  # 0x1

    class ByteOrder(enum.Enum):

        LittleEndian              = ...  # 0x0
        BigEndian                 = ...  # 0x1
        CurrentSystemEndian       = ...  # 0x2

    class ColorModel(enum.Enum):

        RGB                       = ...  # 0x0
        BGR                       = ...  # 0x1
        Indexed                   = ...  # 0x2
        Grayscale                 = ...  # 0x3
        CMYK                      = ...  # 0x4
        HSL                       = ...  # 0x5
        HSV                       = ...  # 0x6
        YUV                       = ...  # 0x7
        Alpha                     = ...  # 0x8

    class TypeInterpretation(enum.Enum):

        UnsignedInteger           = ...  # 0x0
        UnsignedShort             = ...  # 0x1
        UnsignedByte              = ...  # 0x2
        FloatingPoint             = ...  # 0x3

    class YUVLayout(enum.Enum):

        YUV444                    = ...  # 0x0
        YUV422                    = ...  # 0x1
        YUV411                    = ...  # 0x2
        YUV420P                   = ...  # 0x3
        YUV420SP                  = ...  # 0x4
        YV12                      = ...  # 0x5
        UYVY                      = ...  # 0x6
        YUYV                      = ...  # 0x7
        NV12                      = ...  # 0x8
        NV21                      = ...  # 0x9
        IMC1                      = ...  # 0xa
        IMC2                      = ...  # 0xb
        IMC3                      = ...  # 0xc
        IMC4                      = ...  # 0xd
        Y8                        = ...  # 0xe
        Y16                       = ...  # 0xf


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QPixelFormat: PySide6.QtGui.QPixelFormat) -> None: ...
    @typing.overload
    def __init__(self, colorModel: PySide6.QtGui.QPixelFormat.ColorModel, firstSize: int, secondSize: int, thirdSize: int, fourthSize: int, fifthSize: int, alphaSize: int, alphaUsage: PySide6.QtGui.QPixelFormat.AlphaUsage, alphaPosition: PySide6.QtGui.QPixelFormat.AlphaPosition, premultiplied: PySide6.QtGui.QPixelFormat.AlphaPremultiplied, typeInterpretation: PySide6.QtGui.QPixelFormat.TypeInterpretation, byteOrder: PySide6.QtGui.QPixelFormat.ByteOrder = ..., subEnum: int = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alphaPosition(self) -> PySide6.QtGui.QPixelFormat.AlphaPosition: ...
    def alphaSize(self) -> int: ...
    def alphaUsage(self) -> PySide6.QtGui.QPixelFormat.AlphaUsage: ...
    def bitsPerPixel(self) -> int: ...
    def blackSize(self) -> int: ...
    def blueSize(self) -> int: ...
    def brightnessSize(self) -> int: ...
    def byteOrder(self) -> PySide6.QtGui.QPixelFormat.ByteOrder: ...
    def channelCount(self) -> int: ...
    def colorModel(self) -> PySide6.QtGui.QPixelFormat.ColorModel: ...
    def cyanSize(self) -> int: ...
    def greenSize(self) -> int: ...
    def hueSize(self) -> int: ...
    def lightnessSize(self) -> int: ...
    def magentaSize(self) -> int: ...
    def premultiplied(self) -> PySide6.QtGui.QPixelFormat.AlphaPremultiplied: ...
    def redSize(self) -> int: ...
    def saturationSize(self) -> int: ...
    def subEnum(self) -> int: ...
    def typeInterpretation(self) -> PySide6.QtGui.QPixelFormat.TypeInterpretation: ...
    def yellowSize(self) -> int: ...
    def yuvLayout(self) -> PySide6.QtGui.QPixelFormat.YUVLayout: ...


class QPixmap(PySide6.QtGui.QPaintDevice):

    @typing.overload
    def __init__(self, w: int, h: int) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, xpm: typing.Iterable) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName: str | bytes | os.PathLike[str], format: bytes | bytearray | memoryview | None= ..., flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> None: ...
    @typing.overload
    def __init__(self, image: PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QPixmap) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def cacheKey(self) -> int: ...
    def convertFromImage(self, img: PySide6.QtGui.QImage, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> bool: ...
    @typing.overload
    def copy(self, x: int, y: int, width: int, height: int) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    def copy(self, rect: PySide6.QtCore.QRect = ...) -> PySide6.QtGui.QPixmap: ...
    def createHeuristicMask(self, clipTight: bool = ...) -> PySide6.QtGui.QBitmap: ...
    def createMaskFromColor(self, maskColor: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, mode: PySide6.QtCore.Qt.MaskMode = ...) -> PySide6.QtGui.QBitmap: ...
    @staticmethod
    def defaultDepth() -> int: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def deviceIndependentSize(self) -> PySide6.QtCore.QSizeF: ...
    def devicePixelRatio(self) -> float: ...
    def fill(self, fillColor: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int= ...) -> None: ...
    @staticmethod
    def fromImage(image: PySide6.QtGui.QImage, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QPixmap: ...
    @staticmethod
    def fromImageInPlace(image: PySide6.QtGui.QImage, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QPixmap: ...
    @staticmethod
    def fromImageReader(imageReader: PySide6.QtGui.QImageReader, flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> PySide6.QtGui.QPixmap: ...
    def hasAlpha(self) -> bool: ...
    def hasAlphaChannel(self) -> bool: ...
    def height(self) -> int: ...
    def isNull(self) -> bool: ...
    def isQBitmap(self) -> bool: ...
    def load(self, fileName: str, format: bytes | bytearray | memoryview | None= ..., flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> bool: ...
    @typing.overload
    def loadFromData(self, buf: bytes | bytearray | memoryview, format: bytes | bytearray | memoryview | None= ..., flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> bool: ...
    @typing.overload
    def loadFromData(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, format: bytes | bytearray | memoryview | None= ..., flags: PySide6.QtCore.Qt.ImageConversionFlag = ...) -> bool: ...
    def mask(self) -> PySide6.QtGui.QBitmap: ...
    def metric(self, arg__1: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def rect(self) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def save(self, device: PySide6.QtCore.QIODevice, format: str | None= ..., quality: int = ...) -> bool: ...
    @typing.overload
    def save(self, fileName: str, format: str | None= ..., quality: int = ...) -> bool: ...
    @typing.overload
    def scaled(self, s: PySide6.QtCore.QSize, aspectMode: PySide6.QtCore.Qt.AspectRatioMode = ..., mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    def scaled(self, w: int, h: int, aspectMode: PySide6.QtCore.Qt.AspectRatioMode = ..., mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QPixmap: ...
    def scaledToHeight(self, h: int, mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QPixmap: ...
    def scaledToWidth(self, w: int, mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    def scroll(self, dx: int, dy: int, x: int, y: int, width: int, height: int, exposed: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect | None= ...) -> None: ...
    @typing.overload
    def scroll(self, dx: int, dy: int, rect: PySide6.QtCore.QRect, exposed: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect | None= ...) -> None: ...
    def setDevicePixelRatio(self, scaleFactor: float) -> None: ...
    def setMask(self, arg__1: PySide6.QtGui.QBitmap | str) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def swap(self, other: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> None: ...
    def toImage(self) -> PySide6.QtGui.QImage: ...
    def transformed(self, arg__1: PySide6.QtGui.QTransform, mode: PySide6.QtCore.Qt.TransformationMode = ...) -> PySide6.QtGui.QPixmap: ...
    @staticmethod
    def trueMatrix(m: PySide6.QtGui.QTransform, w: int, h: int) -> PySide6.QtGui.QTransform: ...
    def width(self) -> int: ...


class QPixmapCache(Shiboken.Object):

    class Key(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, other: PySide6.QtGui.QPixmapCache.Key) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def isValid(self) -> bool: ...
        def swap(self, other: PySide6.QtGui.QPixmapCache.Key) -> None: ...


    def __init__(self) -> None: ...

    @staticmethod
    def cacheLimit() -> int: ...
    @staticmethod
    def clear() -> None: ...
    @typing.overload    # type: ignore[misc]
    @staticmethod
    def find(key: PySide6.QtGui.QPixmapCache.Key, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> bool: ...
    @typing.overload
    @staticmethod
    def find(key: str, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> bool: ...
    @typing.overload
    def find(self, arg__1: PySide6.QtGui.QPixmapCache.Key) -> None: ...
    @typing.overload
    def find(self, arg__1: str) -> None: ...
    @typing.overload
    @staticmethod
    def insert(pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> PySide6.QtGui.QPixmapCache.Key: ...
    @typing.overload
    @staticmethod
    def insert(key: str, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> bool: ...
    @typing.overload
    @staticmethod
    def remove(key: PySide6.QtGui.QPixmapCache.Key) -> None: ...
    @typing.overload
    @staticmethod
    def remove(key: str) -> None: ...
    @staticmethod
    def replace(key: PySide6.QtGui.QPixmapCache.Key, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage) -> bool: ...
    @staticmethod
    def setCacheLimit(arg__1: int) -> None: ...


class Key(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QPixmapCache.Key) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def isValid(self) -> bool: ...
    def swap(self, other: PySide6.QtGui.QPixmapCache.Key) -> None: ...


class QPlatformSurfaceEvent(PySide6.QtCore.QEvent):

    class SurfaceEventType(enum.Enum):

        SurfaceCreated            = ...  # 0x0
        SurfaceAboutToBeDestroyed = ...  # 0x1


    def __init__(self, arg__1: PySide6.QtGui.QPlatformSurfaceEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QPlatformSurfaceEvent: ...
    def surfaceEventType(self) -> PySide6.QtGui.QPlatformSurfaceEvent.SurfaceEventType: ...


class QPointFList(object): ...


class QPointList(object): ...


class QPointerEvent(PySide6.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QPointerEvent) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, dev: PySide6.QtGui.QPointingDevice, modifiers: PySide6.QtCore.Qt.KeyboardModifier = ..., points: typing.Sequence[PySide6.QtGui.QEventPoint] = ...) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def addPassiveGrabber(self, point: PySide6.QtGui.QEventPoint, grabber: PySide6.QtCore.QObject) -> bool: ...
    def allPointsAccepted(self) -> bool: ...
    def allPointsGrabbed(self) -> bool: ...
    def clearPassiveGrabbers(self, point: PySide6.QtGui.QEventPoint) -> None: ...
    def clone(self) -> PySide6.QtGui.QPointerEvent: ...
    def exclusiveGrabber(self, point: PySide6.QtGui.QEventPoint) -> PySide6.QtCore.QObject: ...
    def isBeginEvent(self) -> bool: ...
    def isEndEvent(self) -> bool: ...
    def isUpdateEvent(self) -> bool: ...
    def point(self, i: int) -> PySide6.QtGui.QEventPoint: ...
    def pointById(self, id: int) -> PySide6.QtGui.QEventPoint: ...
    def pointCount(self) -> int: ...
    def pointerType(self) -> PySide6.QtGui.QPointingDevice.PointerType: ...
    def pointingDevice(self) -> PySide6.QtGui.QPointingDevice: ...
    def points(self) -> typing.List[PySide6.QtGui.QEventPoint]: ...
    def removePassiveGrabber(self, point: PySide6.QtGui.QEventPoint, grabber: PySide6.QtCore.QObject) -> bool: ...
    def setAccepted(self, accepted: bool) -> None: ...
    def setExclusiveGrabber(self, point: PySide6.QtGui.QEventPoint, exclusiveGrabber: PySide6.QtCore.QObject) -> None: ...
    def setTimestamp(self, timestamp: int) -> None: ...


class QPointingDevice(PySide6.QtGui.QInputDevice):

    grabChanged              : typing.ClassVar[Signal] = ... # grabChanged(QObject*,GrabTransition,const QPointerEvent*,QEventPoint)

    class GrabTransition(enum.Enum):

        GrabPassive               = ...  # 0x1
        UngrabPassive             = ...  # 0x2
        CancelGrabPassive         = ...  # 0x3
        OverrideGrabPassive       = ...  # 0x4
        GrabExclusive             = ...  # 0x10
        UngrabExclusive           = ...  # 0x20
        CancelGrabExclusive       = ...  # 0x30

    class PointerType(enum.Flag):

        Unknown                   = ...  # 0x0
        Generic                   = ...  # 0x1
        Finger                    = ...  # 0x2
        Pen                       = ...  # 0x4
        Eraser                    = ...  # 0x8
        Cursor                    = ...  # 0x10
        AllPointerTypes           = ...  # 0x7fff


    @typing.overload
    def __init__(self, name: str, systemId: int, devType: PySide6.QtGui.QInputDevice.DeviceType, pType: PySide6.QtGui.QPointingDevice.PointerType, caps: PySide6.QtGui.QInputDevice.Capability, maxPoints: int, buttonCount: int, seatName: str = ..., uniqueId: PySide6.QtGui.QPointingDeviceUniqueId = ..., parent: PySide6.QtCore.QObject | None= ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def buttonCount(self) -> int: ...
    def maximumPoints(self) -> int: ...
    def pointerType(self) -> PySide6.QtGui.QPointingDevice.PointerType: ...
    @staticmethod
    def primaryPointingDevice(seatName: str = ...) -> PySide6.QtGui.QPointingDevice: ...
    def setCapabilities(self, caps: PySide6.QtGui.QInputDevice.Capability) -> None: ...
    def setMaximumTouchPoints(self, c: int) -> None: ...
    def setType(self, devType: PySide6.QtGui.QInputDevice.DeviceType) -> None: ...
    def uniqueId(self) -> PySide6.QtGui.QPointingDeviceUniqueId: ...


class QPointingDeviceUniqueId(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QPointingDeviceUniqueId: PySide6.QtGui.QPointingDeviceUniqueId) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def fromNumericId(id: int) -> PySide6.QtGui.QPointingDeviceUniqueId: ...
    def isValid(self) -> bool: ...
    def numericId(self) -> int: ...


class QPolygon(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, v: typing.Sequence[PySide6.QtCore.QPoint]) -> None: ...
    @typing.overload
    def __init__(self, r: PySide6.QtCore.QRect, closed: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, QPolygon: PySide6.QtGui.QPolygon) -> None: ...

    def __add__(self, l: typing.Sequence[PySide6.QtCore.QPoint]) -> typing.List[PySide6.QtCore.QPoint]: ...
    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def __lshift__(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def __lshift__(self, stream: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__1: typing.Sequence[PySide6.QtCore.QPoint]) -> None: ...
    def __mul__(self, m: PySide6.QtGui.QTransform) -> PySide6.QtGui.QPolygon: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, stream: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def append(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def append(self, l: typing.Sequence[PySide6.QtCore.QPoint]) -> None: ...
    def at(self, i: int) -> PySide6.QtCore.QPoint: ...
    def back(self) -> PySide6.QtCore.QPoint: ...
    def boundingRect(self) -> PySide6.QtCore.QRect: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def constData(self) -> PySide6.QtCore.QPoint: ...
    def constFirst(self) -> PySide6.QtCore.QPoint: ...
    def constLast(self) -> PySide6.QtCore.QPoint: ...
    def containsPoint(self, pt: PySide6.QtCore.QPoint, fillRule: PySide6.QtCore.Qt.FillRule) -> bool: ...
    def count(self) -> int: ...
    def data(self) -> PySide6.QtCore.QPoint: ...
    def empty(self) -> bool: ...
    @typing.overload
    def first(self) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def first(self, n: int) -> typing.List[PySide6.QtCore.QPoint]: ...
    @staticmethod
    def fromList(list: typing.Sequence[PySide6.QtCore.QPoint]) -> typing.List[PySide6.QtCore.QPoint]: ...
    @staticmethod
    def fromVector(vector: typing.Sequence[PySide6.QtCore.QPoint]) -> typing.List[PySide6.QtCore.QPoint]: ...
    def front(self) -> PySide6.QtCore.QPoint: ...
    def insert(self, arg__1: int, arg__2: PySide6.QtCore.QPoint) -> None: ...
    def intersected(self, r: PySide6.QtGui.QPolygon | typing.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect) -> PySide6.QtGui.QPolygon: ...
    def intersects(self, r: PySide6.QtGui.QPolygon | typing.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other: typing.Sequence[PySide6.QtCore.QPoint]) -> bool: ...
    @typing.overload
    def last(self) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def last(self, n: int) -> typing.List[PySide6.QtCore.QPoint]: ...
    def length(self) -> int: ...
    @staticmethod
    def maxSize() -> int: ...
    def max_size(self) -> int: ...
    def mid(self, pos: int, len: int = ...) -> typing.List[PySide6.QtCore.QPoint]: ...
    def move(self, from_: int, to: int) -> None: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    def push_back(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    def push_front(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    def remove(self, i: int, n: int = ...) -> None: ...
    def removeAll(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    def removeAt(self, i: int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def removeOne(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    def reserve(self, size: int) -> None: ...
    def resize(self, size: int) -> None: ...
    def resizeForOverwrite(self, size: int) -> None: ...
    def shrink_to_fit(self) -> None: ...
    def size(self) -> int: ...
    @typing.overload
    def sliced(self, pos: int, n: int) -> typing.List[PySide6.QtCore.QPoint]: ...
    @typing.overload
    def sliced(self, pos: int) -> typing.List[PySide6.QtCore.QPoint]: ...
    def squeeze(self) -> None: ...
    def subtracted(self, r: PySide6.QtGui.QPolygon | typing.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect) -> PySide6.QtGui.QPolygon: ...
    def swap(self, other: PySide6.QtGui.QPolygon | typing.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect) -> None: ...
    def swapItemsAt(self, i: int, j: int) -> None: ...
    def takeAt(self, i: int) -> PySide6.QtCore.QPoint: ...
    def toList(self) -> typing.List[PySide6.QtCore.QPoint]: ...
    def toPolygonF(self) -> PySide6.QtGui.QPolygonF: ...
    def toVector(self) -> typing.List[PySide6.QtCore.QPoint]: ...
    @typing.overload
    def translate(self, dx: int, dy: int) -> None: ...
    @typing.overload
    def translate(self, offset: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def translated(self, dx: int, dy: int) -> PySide6.QtGui.QPolygon: ...
    @typing.overload
    def translated(self, offset: PySide6.QtCore.QPoint) -> PySide6.QtGui.QPolygon: ...
    def united(self, r: PySide6.QtGui.QPolygon | typing.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect) -> PySide6.QtGui.QPolygon: ...
    def value(self, i: int) -> PySide6.QtCore.QPoint: ...


class QPolygonF(Shiboken.Object):

    @typing.overload
    def __init__(self, v: typing.Sequence[PySide6.QtCore.QPointF]) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def __init__(self, QPolygonF: PySide6.QtGui.QPolygonF) -> None: ...
    @typing.overload
    def __init__(self, a: PySide6.QtGui.QPolygon | typing.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect) -> None: ...

    def __add__(self, l: typing.Sequence[PySide6.QtCore.QPointF]) -> typing.List[PySide6.QtCore.QPointF]: ...
    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, stream: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __mul__(self, m: PySide6.QtGui.QTransform) -> PySide6.QtGui.QPolygonF: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, stream: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def append(self, arg__1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def append(self, l: typing.Sequence[PySide6.QtCore.QPointF]) -> None: ...
    def at(self, i: int) -> PySide6.QtCore.QPointF: ...
    def back(self) -> PySide6.QtCore.QPointF: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def constData(self) -> PySide6.QtCore.QPointF: ...
    def constFirst(self) -> PySide6.QtCore.QPointF: ...
    def constLast(self) -> PySide6.QtCore.QPointF: ...
    def containsPoint(self, pt: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, fillRule: PySide6.QtCore.Qt.FillRule) -> bool: ...
    def count(self) -> int: ...
    def data(self) -> PySide6.QtCore.QPointF: ...
    def empty(self) -> bool: ...
    @typing.overload
    def first(self) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def first(self, n: int) -> typing.List[PySide6.QtCore.QPointF]: ...
    @staticmethod
    def fromList(list: typing.Sequence[PySide6.QtCore.QPointF]) -> typing.List[PySide6.QtCore.QPointF]: ...
    @staticmethod
    def fromVector(vector: typing.Sequence[PySide6.QtCore.QPointF]) -> typing.List[PySide6.QtCore.QPointF]: ...
    def front(self) -> PySide6.QtCore.QPointF: ...
    def insert(self, arg__1: int, arg__2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def intersected(self, r: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> PySide6.QtGui.QPolygonF: ...
    def intersects(self, r: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> bool: ...
    def isClosed(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other: typing.Sequence[PySide6.QtCore.QPointF]) -> bool: ...
    @typing.overload
    def last(self) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def last(self, n: int) -> typing.List[PySide6.QtCore.QPointF]: ...
    def length(self) -> int: ...
    @staticmethod
    def maxSize() -> int: ...
    def max_size(self) -> int: ...
    def mid(self, pos: int, len: int = ...) -> typing.List[PySide6.QtCore.QPointF]: ...
    def move(self, from_: int, to: int) -> None: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, arg__1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def push_back(self, arg__1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def push_front(self, arg__1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def remove(self, i: int, n: int = ...) -> None: ...
    def removeAll(self, arg__1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def removeAt(self, i: int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def removeOne(self, arg__1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def reserve(self, size: int) -> None: ...
    def resize(self, size: int) -> None: ...
    def resizeForOverwrite(self, size: int) -> None: ...
    def shrink_to_fit(self) -> None: ...
    def size(self) -> int: ...
    @typing.overload
    def sliced(self, pos: int, n: int) -> typing.List[PySide6.QtCore.QPointF]: ...
    @typing.overload
    def sliced(self, pos: int) -> typing.List[PySide6.QtCore.QPointF]: ...
    def squeeze(self) -> None: ...
    def subtracted(self, r: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> PySide6.QtGui.QPolygonF: ...
    def swap(self, other: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> None: ...
    def swapItemsAt(self, i: int, j: int) -> None: ...
    def takeAt(self, i: int) -> PySide6.QtCore.QPointF: ...
    def toList(self) -> typing.List[PySide6.QtCore.QPointF]: ...
    def toPolygon(self) -> PySide6.QtGui.QPolygon: ...
    def toVector(self) -> typing.List[PySide6.QtCore.QPointF]: ...
    @typing.overload
    def translate(self, offset: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def translate(self, dx: float, dy: float) -> None: ...
    @typing.overload
    def translated(self, dx: float, dy: float) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def translated(self, offset: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> PySide6.QtGui.QPolygonF: ...
    def united(self, r: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> PySide6.QtGui.QPolygonF: ...
    def value(self, i: int) -> PySide6.QtCore.QPointF: ...


class QPyTextObject(PySide6.QtCore.QObject, PySide6.QtGui.QTextObjectInterface):

    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...


class QQuaternion(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, scalar: float, xpos: float, ypos: float, zpos: float) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide6.QtGui.QVector4D) -> None: ...
    @typing.overload
    def __init__(self, scalar: float, vector: PySide6.QtGui.QVector3D) -> None: ...

    def __add__(self, q2: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, quaternion: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion: ...
    @typing.overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QQuaternion: ...
    @typing.overload
    def __imul__(self, quaternion: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion: ...
    def __isub__(self, quaternion: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QQuaternion: ...
    @typing.overload
    def __mul__(self, q2: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion: ...
    def __neg__(self) -> PySide6.QtGui.QQuaternion: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, q2: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion: ...
    def conjugated(self) -> PySide6.QtGui.QQuaternion: ...
    @staticmethod
    def dotProduct(q1: PySide6.QtGui.QQuaternion, q2: PySide6.QtGui.QQuaternion) -> float: ...
    @staticmethod
    def fromAxes(xAxis: PySide6.QtGui.QVector3D, yAxis: PySide6.QtGui.QVector3D, zAxis: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromAxisAndAngle(x: float, y: float, z: float, angle: float) -> PySide6.QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromAxisAndAngle(axis: PySide6.QtGui.QVector3D, angle: float) -> PySide6.QtGui.QQuaternion: ...
    @staticmethod
    def fromDirection(direction: PySide6.QtGui.QVector3D, up: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromEulerAngles(eulerAngles: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromEulerAngles(pitch: float, yaw: float, roll: float) -> PySide6.QtGui.QQuaternion: ...
    @staticmethod
    def fromRotationMatrix(rot3x3: PySide6.QtGui.QMatrix3x3) -> PySide6.QtGui.QQuaternion: ...
    def getAxes(self, xAxis: PySide6.QtGui.QVector3D, yAxis: PySide6.QtGui.QVector3D, zAxis: PySide6.QtGui.QVector3D) -> None: ...
    def getAxisAndAngle(self) -> typing.Tuple[PySide6.QtGui.QVector3D, float]: ...
    def getEulerAngles(self) -> typing.Tuple[float, float, float]: ...
    def inverted(self) -> PySide6.QtGui.QQuaternion: ...
    def isIdentity(self) -> bool: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    @staticmethod
    def nlerp(q1: PySide6.QtGui.QQuaternion, q2: PySide6.QtGui.QQuaternion, t: float) -> PySide6.QtGui.QQuaternion: ...
    def normalize(self) -> None: ...
    def normalized(self) -> PySide6.QtGui.QQuaternion: ...
    def rotatedVector(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @staticmethod
    def rotationTo(from_: PySide6.QtGui.QVector3D, to: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QQuaternion: ...
    def scalar(self) -> float: ...
    def setScalar(self, scalar: float) -> None: ...
    @typing.overload
    def setVector(self, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def setVector(self, vector: PySide6.QtGui.QVector3D) -> None: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    @staticmethod
    def slerp(q1: PySide6.QtGui.QQuaternion, q2: PySide6.QtGui.QQuaternion, t: float) -> PySide6.QtGui.QQuaternion: ...
    def toEulerAngles(self) -> PySide6.QtGui.QVector3D: ...
    def toRotationMatrix(self) -> PySide6.QtGui.QMatrix3x3: ...
    def toVector4D(self) -> PySide6.QtGui.QVector4D: ...
    def vector(self) -> PySide6.QtGui.QVector3D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QRadialGradient(PySide6.QtGui.QGradient):

    @typing.overload
    def __init__(self, cx: float, cy: float, radius: float) -> None: ...
    @typing.overload
    def __init__(self, center: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, centerRadius: float, focalPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, focalRadius: float) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, cx: float, cy: float, centerRadius: float, fx: float, fy: float, focalRadius: float) -> None: ...
    @typing.overload
    def __init__(self, QRadialGradient: PySide6.QtGui.QRadialGradient) -> None: ...
    @typing.overload
    def __init__(self, cx: float, cy: float, radius: float, fx: float, fy: float) -> None: ...
    @typing.overload
    def __init__(self, center: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, radius: float) -> None: ...
    @typing.overload
    def __init__(self, center: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, radius: float, focalPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def center(self) -> PySide6.QtCore.QPointF: ...
    def centerRadius(self) -> float: ...
    def focalPoint(self) -> PySide6.QtCore.QPointF: ...
    def focalRadius(self) -> float: ...
    def radius(self) -> float: ...
    @typing.overload
    def setCenter(self, x: float, y: float) -> None: ...
    @typing.overload
    def setCenter(self, center: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def setCenterRadius(self, radius: float) -> None: ...
    @typing.overload
    def setFocalPoint(self, x: float, y: float) -> None: ...
    @typing.overload
    def setFocalPoint(self, focalPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def setFocalRadius(self, radius: float) -> None: ...
    def setRadius(self, radius: float) -> None: ...


class QRasterWindow(PySide6.QtGui.QPaintDeviceWindow):

    def __init__(self, parent: PySide6.QtGui.QWindow | None= ...) -> None: ...

    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def redirected(self, arg__1: PySide6.QtCore.QPoint) -> PySide6.QtGui.QPaintDevice: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None: ...


class QRawFont(Shiboken.Object):

    class AntialiasingType(enum.Enum):

        PixelAntialiasing         = ...  # 0x0
        SubPixelAntialiasing      = ...  # 0x1

    class LayoutFlag(enum.Flag):

        SeparateAdvances          = ...  # 0x0
        KernedAdvances            = ...  # 0x1
        UseDesignMetrics          = ...  # 0x2


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, pixelSize: float, hintingPreference: PySide6.QtGui.QFont.HintingPreference = ...) -> None: ...
    @typing.overload
    def __init__(self, fontData: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, pixelSize: float, hintingPreference: PySide6.QtGui.QFont.HintingPreference = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QRawFont) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def advancesForGlyphIndexes(self, glyphIndexes: typing.Sequence[int], layoutFlags: PySide6.QtGui.QRawFont.LayoutFlag) -> typing.List[PySide6.QtCore.QPointF]: ...
    @typing.overload
    def advancesForGlyphIndexes(self, glyphIndexes: typing.Sequence[int]) -> typing.List[PySide6.QtCore.QPointF]: ...
    def alphaMapForGlyph(self, glyphIndex: int, antialiasingType: PySide6.QtGui.QRawFont.AntialiasingType = ..., transform: PySide6.QtGui.QTransform = ...) -> PySide6.QtGui.QImage: ...
    def ascent(self) -> float: ...
    def averageCharWidth(self) -> float: ...
    def boundingRect(self, glyphIndex: int) -> PySide6.QtCore.QRectF: ...
    def capHeight(self) -> float: ...
    def descent(self) -> float: ...
    def familyName(self) -> str: ...
    @typing.overload
    def fontTable(self, tag: PySide6.QtGui.QFont.Tag) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def fontTable(self, tagName: bytes | bytearray | memoryview) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def fromFont(font: PySide6.QtGui.QFont | str | typing.Sequence[str], writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem = ...) -> PySide6.QtGui.QRawFont: ...
    def glyphIndexesForString(self, text: str) -> typing.List[int]: ...
    def hintingPreference(self) -> PySide6.QtGui.QFont.HintingPreference: ...
    def isValid(self) -> bool: ...
    def leading(self) -> float: ...
    def lineThickness(self) -> float: ...
    def loadFromData(self, fontData: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, pixelSize: float, hintingPreference: PySide6.QtGui.QFont.HintingPreference) -> None: ...
    def loadFromFile(self, fileName: str, pixelSize: float, hintingPreference: PySide6.QtGui.QFont.HintingPreference) -> None: ...
    def maxCharWidth(self) -> float: ...
    def pathForGlyph(self, glyphIndex: int) -> PySide6.QtGui.QPainterPath: ...
    def pixelSize(self) -> float: ...
    def setPixelSize(self, pixelSize: float) -> None: ...
    def style(self) -> PySide6.QtGui.QFont.Style: ...
    def styleName(self) -> str: ...
    def supportedWritingSystems(self) -> typing.List[PySide6.QtGui.QFontDatabase.WritingSystem]: ...
    @typing.overload
    def supportsCharacter(self, character: str) -> bool: ...
    @typing.overload
    def supportsCharacter(self, ucs4: int) -> bool: ...
    def swap(self, other: PySide6.QtGui.QRawFont) -> None: ...
    def underlinePosition(self) -> float: ...
    def unitsPerEm(self) -> float: ...
    def weight(self) -> int: ...
    def xHeight(self) -> float: ...


class QRegion(Shiboken.Object):

    class RegionType(enum.Enum):

        Rectangle                 = ...  # 0x0
        Ellipse                   = ...  # 0x1


    @typing.overload
    def __init__(self, region: PySide6.QtGui.QRegion) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: int, y: int, w: int, h: int, t: PySide6.QtGui.QRegion.RegionType = ...) -> None: ...
    @typing.overload
    def __init__(self, pa: PySide6.QtGui.QPolygon | typing.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect, fillRule: PySide6.QtCore.Qt.FillRule = ...) -> None: ...
    @typing.overload
    def __init__(self, r: PySide6.QtCore.QRect, t: PySide6.QtGui.QRegion.RegionType = ...) -> None: ...
    @typing.overload
    def __init__(self, bitmap: PySide6.QtGui.QBitmap | str) -> None: ...

    @typing.overload
    def __add__(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @typing.overload
    def __add__(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @typing.overload
    def __and__(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @typing.overload
    def __and__(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def __iadd__(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @typing.overload
    def __iadd__(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    def __ior__(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    def __isub__(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    def __ixor__(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __mul__(self, m: PySide6.QtGui.QTransform) -> PySide6.QtGui.QRegion: ...
    def __or__(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    def __xor__(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    def begin(self) -> PySide6.QtCore.QRect: ...
    def boundingRect(self) -> PySide6.QtCore.QRect: ...
    def cbegin(self) -> PySide6.QtCore.QRect: ...
    def cend(self) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def contains(self, p: PySide6.QtCore.QPoint) -> bool: ...
    @typing.overload
    def contains(self, r: PySide6.QtCore.QRect) -> bool: ...
    def end(self) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def intersected(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @typing.overload
    def intersected(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @typing.overload
    def intersects(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> bool: ...
    @typing.overload
    def intersects(self, r: PySide6.QtCore.QRect) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def rectCount(self) -> int: ...
    def setRects(self, rect: PySide6.QtCore.QRect, num: int) -> None: ...
    def subtracted(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    def swap(self, other: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def translate(self, dx: int, dy: int) -> None: ...
    @typing.overload
    def translate(self, p: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def translated(self, dx: int, dy: int) -> PySide6.QtGui.QRegion: ...
    @typing.overload
    def translated(self, p: PySide6.QtCore.QPoint) -> PySide6.QtGui.QRegion: ...
    @typing.overload
    def united(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @typing.overload
    def united(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    def xored(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...


class QRegularExpressionValidator(PySide6.QtGui.QValidator):

    regularExpressionChanged : typing.ClassVar[Signal] = ... # regularExpressionChanged(QRegularExpression)

    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...
    @typing.overload
    def __init__(self, re: PySide6.QtCore.QRegularExpression | str, parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    def regularExpression(self) -> PySide6.QtCore.QRegularExpression: ...
    def setRegularExpression(self, re: PySide6.QtCore.QRegularExpression | str) -> None: ...
    def validate(self, input: str, pos: int) -> object: ...


class QResizeEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    @typing.overload
    def __init__(self, size: PySide6.QtCore.QSize, oldSize: PySide6.QtCore.QSize) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def clone(self) -> PySide6.QtGui.QResizeEvent: ...
    def oldSize(self) -> PySide6.QtCore.QSize: ...
    def size(self) -> PySide6.QtCore.QSize: ...


class QRgba64(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRgba64: PySide6.QtGui.QRgba64) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alpha(self) -> int: ...
    def alpha8(self) -> int: ...
    def blue(self) -> int: ...
    def blue8(self) -> int: ...
    @staticmethod
    def fromArgb32(rgb: int) -> PySide6.QtGui.QRgba64: ...
    @staticmethod
    def fromRgba(red: int, green: int, blue: int, alpha: int) -> PySide6.QtGui.QRgba64: ...
    @typing.overload
    @staticmethod
    def fromRgba64(red: int, green: int, blue: int, alpha: int) -> PySide6.QtGui.QRgba64: ...
    @typing.overload
    @staticmethod
    def fromRgba64(c: int) -> PySide6.QtGui.QRgba64: ...
    def green(self) -> int: ...
    def green8(self) -> int: ...
    def isOpaque(self) -> bool: ...
    def isTransparent(self) -> bool: ...
    def premultiplied(self) -> PySide6.QtGui.QRgba64: ...
    def red(self) -> int: ...
    def red8(self) -> int: ...
    def setAlpha(self, _alpha: int) -> None: ...
    def setBlue(self, _blue: int) -> None: ...
    def setGreen(self, _green: int) -> None: ...
    def setRed(self, _red: int) -> None: ...
    def toArgb32(self) -> int: ...
    def toRgb16(self) -> int: ...
    def unpremultiplied(self) -> PySide6.QtGui.QRgba64: ...


class QRhi(Shiboken.Object):

    class BeginFrameFlag(enum.Flag): ...

    class EndFrameFlag(enum.Flag):

        SkipPresent               = ...  # 0x1

    class Feature(enum.Enum):

        MultisampleTexture        = ...  # 0x1
        MultisampleRenderBuffer   = ...  # 0x2
        DebugMarkers              = ...  # 0x3
        Timestamps                = ...  # 0x4
        Instancing                = ...  # 0x5
        CustomInstanceStepRate    = ...  # 0x6
        PrimitiveRestart          = ...  # 0x7
        NonDynamicUniformBuffers  = ...  # 0x8
        NonFourAlignedEffectiveIndexBufferOffset = ...  # 0x9
        NPOTTextureRepeat         = ...  # 0xa
        RedOrAlpha8IsRed          = ...  # 0xb
        ElementIndexUint          = ...  # 0xc
        Compute                   = ...  # 0xd
        WideLines                 = ...  # 0xe
        VertexShaderPointSize     = ...  # 0xf
        BaseVertex                = ...  # 0x10
        BaseInstance              = ...  # 0x11
        TriangleFanTopology       = ...  # 0x12
        ReadBackNonUniformBuffer  = ...  # 0x13
        ReadBackNonBaseMipLevel   = ...  # 0x14
        TexelFetch                = ...  # 0x15
        RenderToNonBaseMipLevel   = ...  # 0x16
        IntAttributes             = ...  # 0x17
        ScreenSpaceDerivatives    = ...  # 0x18
        ReadBackAnyTextureFormat  = ...  # 0x19
        PipelineCacheDataLoadSave = ...  # 0x1a
        ImageDataStride           = ...  # 0x1b
        RenderBufferImport        = ...  # 0x1c
        ThreeDimensionalTextures  = ...  # 0x1d
        RenderTo3DTextureSlice    = ...  # 0x1e
        TextureArrays             = ...  # 0x1f
        Tessellation              = ...  # 0x20
        GeometryShader            = ...  # 0x21
        TextureArrayRange         = ...  # 0x22
        NonFillPolygonMode        = ...  # 0x23
        OneDimensionalTextures    = ...  # 0x24
        OneDimensionalTextureMipmaps = ...  # 0x25
        HalfAttributes            = ...  # 0x26
        RenderToOneDimensionalTexture = ...  # 0x27
        ThreeDimensionalTextureMipmaps = ...  # 0x28
        MultiView                 = ...  # 0x29
        TextureViewFormat         = ...  # 0x2a
        ResolveDepthStencil       = ...  # 0x2b

    class Flag(enum.Flag):

        EnableDebugMarkers        = ...  # 0x1
        PreferSoftwareRenderer    = ...  # 0x2
        EnablePipelineCacheDataSave = ...  # 0x4
        EnableTimestamps          = ...  # 0x8
        SuppressSmokeTestWarnings = ...  # 0x10

    class FrameOpResult(enum.Enum):

        FrameOpSuccess            = ...  # 0x0
        FrameOpError              = ...  # 0x1
        FrameOpSwapChainOutOfDate = ...  # 0x2
        FrameOpDeviceLost         = ...  # 0x3

    class Implementation(enum.Enum):

        Null                      = ...  # 0x0
        Vulkan                    = ...  # 0x1
        OpenGLES2                 = ...  # 0x2
        D3D11                     = ...  # 0x3
        Metal                     = ...  # 0x4
        D3D12                     = ...  # 0x5

    class ResourceLimit(enum.Enum):

        TextureSizeMin            = ...  # 0x1
        TextureSizeMax            = ...  # 0x2
        MaxColorAttachments       = ...  # 0x3
        FramesInFlight            = ...  # 0x4
        MaxAsyncReadbackFrames    = ...  # 0x5
        MaxThreadGroupsPerDimension = ...  # 0x6
        MaxThreadsPerThreadGroup  = ...  # 0x7
        MaxThreadGroupX           = ...  # 0x8
        MaxThreadGroupY           = ...  # 0x9
        MaxThreadGroupZ           = ...  # 0xa
        TextureArraySizeMax       = ...  # 0xb
        MaxUniformBufferRange     = ...  # 0xc
        MaxVertexInputs           = ...  # 0xd
        MaxVertexOutputs          = ...  # 0xe


    def __init__(self) -> None: ...

    def backend(self) -> PySide6.QtGui.QRhi.Implementation: ...
    @typing.overload    # type: ignore[misc]
    def backendName(self) -> bytes | bytearray | memoryview: ...
    @typing.overload
    @staticmethod
    def backendName(impl: PySide6.QtGui.QRhi.Implementation) -> bytes | bytearray | memoryview: ...
    def beginFrame(self, swapChain: PySide6.QtGui.QRhiSwapChain, flags: PySide6.QtGui.QRhi.BeginFrameFlag = ...) -> PySide6.QtGui.QRhi.FrameOpResult: ...
    def beginOffscreenFrame(self, cb: PySide6.QtGui.QRhiCommandBuffer, flags: PySide6.QtGui.QRhi.BeginFrameFlag = ...) -> PySide6.QtGui.QRhi.FrameOpResult: ...
    def clipSpaceCorrMatrix(self) -> PySide6.QtGui.QMatrix4x4: ...
    @staticmethod
    def create(impl: PySide6.QtGui.QRhi.Implementation, params: PySide6.QtGui.QRhiInitParams, flags: PySide6.QtGui.QRhi.Flag = ..., importDevice: PySide6.QtGui.QRhiNativeHandles | None= ...) -> PySide6.QtGui.QRhi: ...
    def currentFrameSlot(self) -> int: ...
    def driverInfo(self) -> PySide6.QtGui.QRhiDriverInfo: ...
    def endFrame(self, swapChain: PySide6.QtGui.QRhiSwapChain, flags: PySide6.QtGui.QRhi.EndFrameFlag = ...) -> PySide6.QtGui.QRhi.FrameOpResult: ...
    def endOffscreenFrame(self, flags: PySide6.QtGui.QRhi.EndFrameFlag = ...) -> PySide6.QtGui.QRhi.FrameOpResult: ...
    def finish(self) -> PySide6.QtGui.QRhi.FrameOpResult: ...
    def isClipDepthZeroToOne(self) -> bool: ...
    def isDeviceLost(self) -> bool: ...
    def isFeatureSupported(self, feature: PySide6.QtGui.QRhi.Feature) -> bool: ...
    def isRecordingFrame(self) -> bool: ...
    def isTextureFormatSupported(self, format: PySide6.QtGui.QRhiTexture.Format, flags: PySide6.QtGui.QRhiTexture.Flag = ...) -> bool: ...
    def isYUpInFramebuffer(self) -> bool: ...
    def isYUpInNDC(self) -> bool: ...
    def makeThreadLocalNativeContextCurrent(self) -> bool: ...
    @staticmethod
    def mipLevelsForSize(size: PySide6.QtCore.QSize) -> int: ...
    def nativeHandles(self) -> PySide6.QtGui.QRhiNativeHandles: ...
    def newBuffer(self, type: PySide6.QtGui.QRhiBuffer.Type, usage: PySide6.QtGui.QRhiBuffer.UsageFlag, size: int) -> PySide6.QtGui.QRhiBuffer: ...
    def newComputePipeline(self) -> PySide6.QtGui.QRhiComputePipeline: ...
    def newGraphicsPipeline(self) -> PySide6.QtGui.QRhiGraphicsPipeline: ...
    def newRenderBuffer(self, type: PySide6.QtGui.QRhiRenderBuffer.Type, pixelSize: PySide6.QtCore.QSize, sampleCount: int = ..., flags: PySide6.QtGui.QRhiRenderBuffer.Flag = ..., backingFormatHint: PySide6.QtGui.QRhiTexture.Format = ...) -> PySide6.QtGui.QRhiRenderBuffer: ...
    def newSampler(self, magFilter: PySide6.QtGui.QRhiSampler.Filter, minFilter: PySide6.QtGui.QRhiSampler.Filter, mipmapMode: PySide6.QtGui.QRhiSampler.Filter, addressU: PySide6.QtGui.QRhiSampler.AddressMode, addressV: PySide6.QtGui.QRhiSampler.AddressMode, addressW: PySide6.QtGui.QRhiSampler.AddressMode = ...) -> PySide6.QtGui.QRhiSampler: ...
    def newShaderResourceBindings(self) -> PySide6.QtGui.QRhiShaderResourceBindings: ...
    def newSwapChain(self) -> PySide6.QtGui.QRhiSwapChain: ...
    @typing.overload
    def newTexture(self, format: PySide6.QtGui.QRhiTexture.Format, width: int, height: int, depth: int, sampleCount: int = ..., flags: PySide6.QtGui.QRhiTexture.Flag = ...) -> PySide6.QtGui.QRhiTexture: ...
    @typing.overload
    def newTexture(self, format: PySide6.QtGui.QRhiTexture.Format, pixelSize: PySide6.QtCore.QSize, sampleCount: int = ..., flags: PySide6.QtGui.QRhiTexture.Flag = ...) -> PySide6.QtGui.QRhiTexture: ...
    def newTextureArray(self, format: PySide6.QtGui.QRhiTexture.Format, arraySize: int, pixelSize: PySide6.QtCore.QSize, sampleCount: int = ..., flags: PySide6.QtGui.QRhiTexture.Flag = ...) -> PySide6.QtGui.QRhiTexture: ...
    def newTextureRenderTarget(self, desc: PySide6.QtGui.QRhiTextureRenderTargetDescription | PySide6.QtGui.QRhiColorAttachment, flags: PySide6.QtGui.QRhiTextureRenderTarget.Flag = ...) -> PySide6.QtGui.QRhiTextureRenderTarget: ...
    def nextResourceUpdateBatch(self) -> PySide6.QtGui.QRhiResourceUpdateBatch: ...
    def pipelineCacheData(self) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def probe(impl: PySide6.QtGui.QRhi.Implementation, params: PySide6.QtGui.QRhiInitParams) -> bool: ...
    def releaseCachedResources(self) -> None: ...
    def removeCleanupCallback(self, key: int) -> None: ...
    def resourceLimit(self, limit: PySide6.QtGui.QRhi.ResourceLimit) -> int: ...
    def runCleanup(self) -> None: ...
    def setPipelineCacheData(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    @staticmethod
    def sizeForMipLevel(mipLevel: int, baseLevelSize: PySide6.QtCore.QSize) -> PySide6.QtCore.QSize: ...
    def statistics(self) -> PySide6.QtGui.QRhiStats: ...
    def supportedSampleCounts(self) -> typing.List[int]: ...
    def thread(self) -> PySide6.QtCore.QThread: ...
    def ubufAligned(self, v: int) -> int: ...
    def ubufAlignment(self) -> int: ...


class QRhiBuffer(PySide6.QtGui.QRhiResource):

    class Type(enum.Enum):

        Immutable                 = ...  # 0x0
        Static                    = ...  # 0x1
        Dynamic                   = ...  # 0x2

    class UsageFlag(enum.Flag):

        VertexBuffer              = ...  # 0x1
        IndexBuffer               = ...  # 0x2
        UniformBuffer             = ...  # 0x4
        StorageBuffer             = ...  # 0x8


    def create(self) -> bool: ...
    def endFullDynamicBufferUpdateForCurrentFrame(self) -> None: ...
    def fullDynamicBufferUpdateForCurrentFrame(self, data: int) -> None: ...
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def setSize(self, sz: int) -> None: ...
    def setType(self, t: PySide6.QtGui.QRhiBuffer.Type) -> None: ...
    def setUsage(self, u: PySide6.QtGui.QRhiBuffer.UsageFlag) -> None: ...
    def size(self) -> int: ...
    def type(self) -> PySide6.QtGui.QRhiBuffer.Type: ...
    def usage(self) -> PySide6.QtGui.QRhiBuffer.UsageFlag: ...


class QRhiColorAttachment(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, texture: PySide6.QtGui.QRhiTexture) -> None: ...
    @typing.overload
    def __init__(self, QRhiColorAttachment: PySide6.QtGui.QRhiColorAttachment) -> None: ...
    @typing.overload
    def __init__(self, renderBuffer: PySide6.QtGui.QRhiRenderBuffer) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def layer(self) -> int: ...
    def level(self) -> int: ...
    def multiViewCount(self) -> int: ...
    def renderBuffer(self) -> PySide6.QtGui.QRhiRenderBuffer: ...
    def resolveLayer(self) -> int: ...
    def resolveLevel(self) -> int: ...
    def resolveTexture(self) -> PySide6.QtGui.QRhiTexture: ...
    def setLayer(self, layer: int) -> None: ...
    def setLevel(self, level: int) -> None: ...
    def setMultiViewCount(self, count: int) -> None: ...
    def setRenderBuffer(self, rb: PySide6.QtGui.QRhiRenderBuffer) -> None: ...
    def setResolveLayer(self, layer: int) -> None: ...
    def setResolveLevel(self, level: int) -> None: ...
    def setResolveTexture(self, tex: PySide6.QtGui.QRhiTexture) -> None: ...
    def setTexture(self, tex: PySide6.QtGui.QRhiTexture) -> None: ...
    def texture(self) -> PySide6.QtGui.QRhiTexture: ...


class QRhiCommandBuffer(PySide6.QtGui.QRhiResource):

    class BeginPassFlag(enum.Flag):

        ExternalContent           = ...  # 0x1
        DoNotTrackResourcesForCompute = ...  # 0x2

    class IndexFormat(enum.Enum):

        IndexUInt16               = ...  # 0x0
        IndexUInt32               = ...  # 0x1


    def beginComputePass(self, resourceUpdates: PySide6.QtGui.QRhiResourceUpdateBatch | None= ..., flags: PySide6.QtGui.QRhiCommandBuffer.BeginPassFlag = ...) -> None: ...
    def beginExternal(self) -> None: ...
    def beginPass(self, rt: PySide6.QtGui.QRhiRenderTarget, colorClearValue: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, depthStencilClearValue: PySide6.QtGui.QRhiDepthStencilClearValue, resourceUpdates: PySide6.QtGui.QRhiResourceUpdateBatch | None= ..., flags: PySide6.QtGui.QRhiCommandBuffer.BeginPassFlag = ...) -> None: ...
    def debugMarkBegin(self, name: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    def debugMarkEnd(self) -> None: ...
    def debugMarkMsg(self, msg: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    def dispatch(self, x: int, y: int, z: int) -> None: ...
    def draw(self, vertexCount: int, instanceCount: int = ..., firstVertex: int = ..., firstInstance: int = ...) -> None: ...
    def drawIndexed(self, indexCount: int, instanceCount: int = ..., firstIndex: int = ..., vertexOffset: int = ..., firstInstance: int = ...) -> None: ...
    def endComputePass(self, resourceUpdates: PySide6.QtGui.QRhiResourceUpdateBatch | None= ...) -> None: ...
    def endExternal(self) -> None: ...
    def endPass(self, resourceUpdates: PySide6.QtGui.QRhiResourceUpdateBatch | None= ...) -> None: ...
    def lastCompletedGpuTime(self) -> float: ...
    def nativeHandles(self) -> PySide6.QtGui.QRhiNativeHandles: ...
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def resourceUpdate(self, resourceUpdates: PySide6.QtGui.QRhiResourceUpdateBatch) -> None: ...
    def setBlendConstants(self, c: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    def setComputePipeline(self, ps: PySide6.QtGui.QRhiComputePipeline) -> None: ...
    def setGraphicsPipeline(self, ps: PySide6.QtGui.QRhiGraphicsPipeline) -> None: ...
    def setScissor(self, scissor: PySide6.QtGui.QRhiScissor) -> None: ...
    def setShaderResources(self, srb: PySide6.QtGui.QRhiShaderResourceBindings | None= ..., dynamicOffsetCount: int = ..., dynamicOffsets: typing.Tuple[int, int] | None= ...) -> None: ...
    def setStencilRef(self, refValue: int) -> None: ...
    def setVertexInput(self, startBinding: int, bindings: typing.Sequence[typing.Tuple[PySide6.QtGui.QRhiBuffer, int]], indexBuf: PySide6.QtGui.QRhiBuffer | None= ..., indexOffset: int = ..., indexFormat: PySide6.QtGui.QRhiCommandBuffer.IndexFormat = ...) -> None: ...
    def setViewport(self, viewport: PySide6.QtGui.QRhiViewport) -> None: ...


class QRhiComputePipeline(PySide6.QtGui.QRhiResource):

    class Flag(enum.Flag):

        CompileShadersWithDebugInfo = ...  # 0x1


    def create(self) -> bool: ...
    def flags(self) -> PySide6.QtGui.QRhiComputePipeline.Flag: ...
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def setFlags(self, f: PySide6.QtGui.QRhiComputePipeline.Flag) -> None: ...
    def setShaderResourceBindings(self, srb: PySide6.QtGui.QRhiShaderResourceBindings) -> None: ...
    def setShaderStage(self, stage: PySide6.QtGui.QRhiShaderStage) -> None: ...
    def shaderResourceBindings(self) -> PySide6.QtGui.QRhiShaderResourceBindings: ...
    def shaderStage(self) -> PySide6.QtGui.QRhiShaderStage: ...


class QRhiDepthStencilClearValue(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiDepthStencilClearValue: PySide6.QtGui.QRhiDepthStencilClearValue) -> None: ...
    @typing.overload
    def __init__(self, d: float, s: int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def depthClearValue(self) -> float: ...
    def setDepthClearValue(self, d: float) -> None: ...
    def setStencilClearValue(self, s: int) -> None: ...
    def stencilClearValue(self) -> int: ...


class QRhiDriverInfo(Shiboken.Object):

    class DeviceType(enum.Enum):

        UnknownDevice             = ...  # 0x0
        IntegratedDevice          = ...  # 0x1
        DiscreteDevice            = ...  # 0x2
        ExternalDevice            = ...  # 0x3
        VirtualDevice             = ...  # 0x4
        CpuDevice                 = ...  # 0x5


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiDriverInfo: PySide6.QtGui.QRhiDriverInfo) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...


class QRhiGles2InitParams(PySide6.QtGui.QRhiInitParams):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiGles2InitParams: PySide6.QtGui.QRhiGles2InitParams) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def newFallbackSurface(format: PySide6.QtGui.QSurfaceFormat | PySide6.QtGui.QSurfaceFormat.FormatOption= ...) -> PySide6.QtGui.QOffscreenSurface: ...


class QRhiGles2NativeHandles(PySide6.QtGui.QRhiNativeHandles):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiGles2NativeHandles: PySide6.QtGui.QRhiGles2NativeHandles) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QRhiGraphicsPipeline(PySide6.QtGui.QRhiResource):

    class BlendFactor(enum.Enum):

        Zero                      = ...  # 0x0
        One                       = ...  # 0x1
        SrcColor                  = ...  # 0x2
        OneMinusSrcColor          = ...  # 0x3
        DstColor                  = ...  # 0x4
        OneMinusDstColor          = ...  # 0x5
        SrcAlpha                  = ...  # 0x6
        OneMinusSrcAlpha          = ...  # 0x7
        DstAlpha                  = ...  # 0x8
        OneMinusDstAlpha          = ...  # 0x9
        ConstantColor             = ...  # 0xa
        OneMinusConstantColor     = ...  # 0xb
        ConstantAlpha             = ...  # 0xc
        OneMinusConstantAlpha     = ...  # 0xd
        SrcAlphaSaturate          = ...  # 0xe
        Src1Color                 = ...  # 0xf
        OneMinusSrc1Color         = ...  # 0x10
        Src1Alpha                 = ...  # 0x11
        OneMinusSrc1Alpha         = ...  # 0x12

    class BlendOp(enum.Enum):

        Add                       = ...  # 0x0
        Subtract                  = ...  # 0x1
        ReverseSubtract           = ...  # 0x2
        Min                       = ...  # 0x3
        Max                       = ...  # 0x4

    class ColorMaskComponent(enum.Flag):

        R                         = ...  # 0x1
        G                         = ...  # 0x2
        B                         = ...  # 0x4
        A                         = ...  # 0x8

    class CompareOp(enum.Enum):

        Never                     = ...  # 0x0
        Less                      = ...  # 0x1
        Equal                     = ...  # 0x2
        LessOrEqual               = ...  # 0x3
        Greater                   = ...  # 0x4
        NotEqual                  = ...  # 0x5
        GreaterOrEqual            = ...  # 0x6
        Always                    = ...  # 0x7

    class CullMode(enum.Enum):

        None_                     = ...  # 0x0
        Front                     = ...  # 0x1
        Back                      = ...  # 0x2

    class Flag(enum.Flag):

        UsesBlendConstants        = ...  # 0x1
        UsesStencilRef            = ...  # 0x2
        UsesScissor               = ...  # 0x4
        CompileShadersWithDebugInfo = ...  # 0x8

    class FrontFace(enum.Enum):

        CCW                       = ...  # 0x0
        CW                        = ...  # 0x1

    class PolygonMode(enum.Enum):

        Fill                      = ...  # 0x0
        Line                      = ...  # 0x1

    class StencilOp(enum.Enum):

        StencilZero               = ...  # 0x0
        Keep                      = ...  # 0x1
        Replace                   = ...  # 0x2
        IncrementAndClamp         = ...  # 0x3
        DecrementAndClamp         = ...  # 0x4
        Invert                    = ...  # 0x5
        IncrementAndWrap          = ...  # 0x6
        DecrementAndWrap          = ...  # 0x7

    class StencilOpState(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, StencilOpState: PySide6.QtGui.QRhiGraphicsPipeline.StencilOpState) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class TargetBlend(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, TargetBlend: PySide6.QtGui.QRhiGraphicsPipeline.TargetBlend) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class Topology(enum.Enum):

        Triangles                 = ...  # 0x0
        TriangleStrip             = ...  # 0x1
        TriangleFan               = ...  # 0x2
        Lines                     = ...  # 0x3
        LineStrip                 = ...  # 0x4
        Points                    = ...  # 0x5
        Patches                   = ...  # 0x6


    def cbeginShaderStages(self) -> PySide6.QtGui.QRhiShaderStage: ...
    def cbeginTargetBlends(self) -> PySide6.QtGui.QRhiGraphicsPipeline.TargetBlend: ...
    def cendShaderStages(self) -> PySide6.QtGui.QRhiShaderStage: ...
    def cendTargetBlends(self) -> PySide6.QtGui.QRhiGraphicsPipeline.TargetBlend: ...
    def create(self) -> bool: ...
    def cullMode(self) -> PySide6.QtGui.QRhiGraphicsPipeline.CullMode: ...
    def depthBias(self) -> int: ...
    def depthOp(self) -> PySide6.QtGui.QRhiGraphicsPipeline.CompareOp: ...
    def flags(self) -> PySide6.QtGui.QRhiGraphicsPipeline.Flag: ...
    def frontFace(self) -> PySide6.QtGui.QRhiGraphicsPipeline.FrontFace: ...
    def hasDepthTest(self) -> bool: ...
    def hasDepthWrite(self) -> bool: ...
    def hasStencilTest(self) -> bool: ...
    def lineWidth(self) -> float: ...
    def multiViewCount(self) -> int: ...
    def patchControlPointCount(self) -> int: ...
    def polygonMode(self) -> PySide6.QtGui.QRhiGraphicsPipeline.PolygonMode: ...
    def renderPassDescriptor(self) -> PySide6.QtGui.QRhiRenderPassDescriptor: ...
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def sampleCount(self) -> int: ...
    def setCullMode(self, mode: PySide6.QtGui.QRhiGraphicsPipeline.CullMode) -> None: ...
    def setDepthBias(self, bias: int) -> None: ...
    def setDepthOp(self, op: PySide6.QtGui.QRhiGraphicsPipeline.CompareOp) -> None: ...
    def setDepthTest(self, enable: bool) -> None: ...
    def setDepthWrite(self, enable: bool) -> None: ...
    def setFlags(self, f: PySide6.QtGui.QRhiGraphicsPipeline.Flag) -> None: ...
    def setFrontFace(self, f: PySide6.QtGui.QRhiGraphicsPipeline.FrontFace) -> None: ...
    def setLineWidth(self, width: float) -> None: ...
    def setMultiViewCount(self, count: int) -> None: ...
    def setPatchControlPointCount(self, count: int) -> None: ...
    def setPolygonMode(self, mode: PySide6.QtGui.QRhiGraphicsPipeline.PolygonMode) -> None: ...
    def setRenderPassDescriptor(self, desc: PySide6.QtGui.QRhiRenderPassDescriptor) -> None: ...
    def setSampleCount(self, s: int) -> None: ...
    def setShaderResourceBindings(self, srb: PySide6.QtGui.QRhiShaderResourceBindings) -> None: ...
    def setShaderStages(self, stages: typing.Sequence[PySide6.QtGui.QRhiShaderStage]) -> None: ...
    def setSlopeScaledDepthBias(self, bias: float) -> None: ...
    def setStencilBack(self, state: PySide6.QtGui.QRhiGraphicsPipeline.StencilOpState) -> None: ...
    def setStencilFront(self, state: PySide6.QtGui.QRhiGraphicsPipeline.StencilOpState) -> None: ...
    def setStencilReadMask(self, mask: int) -> None: ...
    def setStencilTest(self, enable: bool) -> None: ...
    def setStencilWriteMask(self, mask: int) -> None: ...
    def setTargetBlends(self, blends: typing.Sequence[PySide6.QtGui.QRhiGraphicsPipeline.TargetBlend]) -> None: ...
    def setTopology(self, t: PySide6.QtGui.QRhiGraphicsPipeline.Topology) -> None: ...
    def setVertexInputLayout(self, layout: PySide6.QtGui.QRhiVertexInputLayout) -> None: ...
    def shaderResourceBindings(self) -> PySide6.QtGui.QRhiShaderResourceBindings: ...
    def shaderStageAt(self, index: int) -> PySide6.QtGui.QRhiShaderStage: ...
    def shaderStageCount(self) -> int: ...
    def slopeScaledDepthBias(self) -> float: ...
    def stencilBack(self) -> PySide6.QtGui.QRhiGraphicsPipeline.StencilOpState: ...
    def stencilFront(self) -> PySide6.QtGui.QRhiGraphicsPipeline.StencilOpState: ...
    def stencilReadMask(self) -> int: ...
    def stencilWriteMask(self) -> int: ...
    def targetBlendAt(self, index: int) -> PySide6.QtGui.QRhiGraphicsPipeline.TargetBlend: ...
    def targetBlendCount(self) -> int: ...
    def topology(self) -> PySide6.QtGui.QRhiGraphicsPipeline.Topology: ...
    def vertexInputLayout(self) -> PySide6.QtGui.QRhiVertexInputLayout: ...


class StencilOpState(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, StencilOpState: PySide6.QtGui.QRhiGraphicsPipeline.StencilOpState) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class TargetBlend(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, TargetBlend: PySide6.QtGui.QRhiGraphicsPipeline.TargetBlend) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QRhiInitParams(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiInitParams: PySide6.QtGui.QRhiInitParams) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QRhiNativeHandles(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiNativeHandles: PySide6.QtGui.QRhiNativeHandles) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QRhiNullInitParams(PySide6.QtGui.QRhiInitParams):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiNullInitParams: PySide6.QtGui.QRhiNullInitParams) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QRhiReadbackDescription(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, texture: PySide6.QtGui.QRhiTexture) -> None: ...
    @typing.overload
    def __init__(self, QRhiReadbackDescription: PySide6.QtGui.QRhiReadbackDescription) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def layer(self) -> int: ...
    def level(self) -> int: ...
    def setLayer(self, layer: int) -> None: ...
    def setLevel(self, level: int) -> None: ...
    def setTexture(self, tex: PySide6.QtGui.QRhiTexture) -> None: ...
    def texture(self) -> PySide6.QtGui.QRhiTexture: ...


class QRhiReadbackResult(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiReadbackResult: PySide6.QtGui.QRhiReadbackResult) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QRhiRenderBuffer(PySide6.QtGui.QRhiResource):

    class Flag(enum.Flag):

        UsedWithSwapChainOnly     = ...  # 0x1

    class Type(enum.Enum):

        DepthStencil              = ...  # 0x0
        Color                     = ...  # 0x1


    def backingFormat(self) -> PySide6.QtGui.QRhiTexture.Format: ...
    def create(self) -> bool: ...
    def flags(self) -> PySide6.QtGui.QRhiRenderBuffer.Flag: ...
    def pixelSize(self) -> PySide6.QtCore.QSize: ...
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def sampleCount(self) -> int: ...
    def setFlags(self, f: PySide6.QtGui.QRhiRenderBuffer.Flag) -> None: ...
    def setPixelSize(self, sz: PySide6.QtCore.QSize) -> None: ...
    def setSampleCount(self, s: int) -> None: ...
    def setType(self, t: PySide6.QtGui.QRhiRenderBuffer.Type) -> None: ...
    def type(self) -> PySide6.QtGui.QRhiRenderBuffer.Type: ...


class QRhiRenderPassDescriptor(PySide6.QtGui.QRhiResource):
    def isCompatible(self, other: PySide6.QtGui.QRhiRenderPassDescriptor) -> bool: ...
    def nativeHandles(self) -> PySide6.QtGui.QRhiNativeHandles: ...
    def newCompatibleRenderPassDescriptor(self) -> PySide6.QtGui.QRhiRenderPassDescriptor: ...
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def serializedFormat(self) -> typing.List[int]: ...


class QRhiRenderTarget(PySide6.QtGui.QRhiResource):
    def devicePixelRatio(self) -> float: ...
    def pixelSize(self) -> PySide6.QtCore.QSize: ...
    def renderPassDescriptor(self) -> PySide6.QtGui.QRhiRenderPassDescriptor: ...
    def sampleCount(self) -> int: ...
    def setRenderPassDescriptor(self, desc: PySide6.QtGui.QRhiRenderPassDescriptor) -> None: ...


class QRhiResource(Shiboken.Object):

    class Type(enum.Enum):

        Buffer                    = ...  # 0x0
        Texture                   = ...  # 0x1
        Sampler                   = ...  # 0x2
        RenderBuffer              = ...  # 0x3
        RenderPassDescriptor      = ...  # 0x4
        SwapChainRenderTarget     = ...  # 0x5
        TextureRenderTarget       = ...  # 0x6
        ShaderResourceBindings    = ...  # 0x7
        GraphicsPipeline          = ...  # 0x8
        SwapChain                 = ...  # 0x9
        ComputePipeline           = ...  # 0xa
        CommandBuffer             = ...  # 0xb


    def deleteLater(self) -> None: ...
    def destroy(self) -> None: ...
    def globalResourceId(self) -> int: ...
    def name(self) -> PySide6.QtCore.QByteArray: ...
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def rhi(self) -> PySide6.QtGui.QRhi: ...
    def setName(self, name: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...


class QRhiResourceUpdateBatch(Shiboken.Object):
    def copyTexture(self, dst: PySide6.QtGui.QRhiTexture, src: PySide6.QtGui.QRhiTexture, desc: PySide6.QtGui.QRhiTextureCopyDescription = ...) -> None: ...
    def generateMips(self, tex: PySide6.QtGui.QRhiTexture) -> None: ...
    def hasOptimalCapacity(self) -> bool: ...
    def merge(self, other: PySide6.QtGui.QRhiResourceUpdateBatch) -> None: ...
    def readBackBuffer(self, buf: PySide6.QtGui.QRhiBuffer, offset: int, size: int, result: PySide6.QtGui.QRhiReadbackResult) -> None: ...
    def readBackTexture(self, rb: PySide6.QtGui.QRhiReadbackDescription | PySide6.QtGui.QRhiTexture, result: PySide6.QtGui.QRhiReadbackResult) -> None: ...
    def release(self) -> None: ...
    def updateDynamicBuffer(self, buf: PySide6.QtGui.QRhiBuffer, offset: int, size: int, data: int) -> None: ...
    @typing.overload
    def uploadStaticBuffer(self, buf: PySide6.QtGui.QRhiBuffer, offset: int, size: int, data: int) -> None: ...
    @typing.overload
    def uploadStaticBuffer(self, buf: PySide6.QtGui.QRhiBuffer, data: int) -> None: ...
    @typing.overload
    def uploadTexture(self, tex: PySide6.QtGui.QRhiTexture, image: PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def uploadTexture(self, tex: PySide6.QtGui.QRhiTexture, desc: PySide6.QtGui.QRhiTextureUploadDescription | PySide6.QtGui.QRhiTextureUploadEntry) -> None: ...


class QRhiSampler(PySide6.QtGui.QRhiResource):

    class AddressMode(enum.Enum):

        Repeat                    = ...  # 0x0
        ClampToEdge               = ...  # 0x1
        Mirror                    = ...  # 0x2

    class CompareOp(enum.Enum):

        Never                     = ...  # 0x0
        Less                      = ...  # 0x1
        Equal                     = ...  # 0x2
        LessOrEqual               = ...  # 0x3
        Greater                   = ...  # 0x4
        NotEqual                  = ...  # 0x5
        GreaterOrEqual            = ...  # 0x6
        Always                    = ...  # 0x7

    class Filter(enum.Enum):

        None_                     = ...  # 0x0
        Nearest                   = ...  # 0x1
        Linear                    = ...  # 0x2


    def addressU(self) -> PySide6.QtGui.QRhiSampler.AddressMode: ...
    def addressV(self) -> PySide6.QtGui.QRhiSampler.AddressMode: ...
    def addressW(self) -> PySide6.QtGui.QRhiSampler.AddressMode: ...
    def create(self) -> bool: ...
    def magFilter(self) -> PySide6.QtGui.QRhiSampler.Filter: ...
    def minFilter(self) -> PySide6.QtGui.QRhiSampler.Filter: ...
    def mipmapMode(self) -> PySide6.QtGui.QRhiSampler.Filter: ...
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def setAddressU(self, mode: PySide6.QtGui.QRhiSampler.AddressMode) -> None: ...
    def setAddressV(self, mode: PySide6.QtGui.QRhiSampler.AddressMode) -> None: ...
    def setAddressW(self, mode: PySide6.QtGui.QRhiSampler.AddressMode) -> None: ...
    def setMagFilter(self, f: PySide6.QtGui.QRhiSampler.Filter) -> None: ...
    def setMinFilter(self, f: PySide6.QtGui.QRhiSampler.Filter) -> None: ...
    def setMipmapMode(self, f: PySide6.QtGui.QRhiSampler.Filter) -> None: ...
    def setTextureCompareOp(self, op: PySide6.QtGui.QRhiSampler.CompareOp) -> None: ...
    def textureCompareOp(self) -> PySide6.QtGui.QRhiSampler.CompareOp: ...


class QRhiScissor(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiScissor: PySide6.QtGui.QRhiScissor) -> None: ...
    @typing.overload
    def __init__(self, x: int, y: int, w: int, h: int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def scissor(self) -> typing.List[int]: ...
    def setScissor(self, x: int, y: int, w: int, h: int) -> None: ...


class QRhiShaderResourceBinding(Shiboken.Object):

    class Data(Shiboken.Object):

        class StorageBufferData(Shiboken.Object):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, StorageBufferData: PySide6.QtGui.QRhiShaderResourceBinding.Data.StorageBufferData) -> None: ...

            @staticmethod
            def __copy__() -> None: ...

        class StorageImageData(Shiboken.Object):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, StorageImageData: PySide6.QtGui.QRhiShaderResourceBinding.Data.StorageImageData) -> None: ...

            @staticmethod
            def __copy__() -> None: ...


        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Data: PySide6.QtGui.QRhiShaderResourceBinding.Data) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def arraySize(self) -> int: ...

    class StageFlag(enum.Flag):

        VertexStage               = ...  # 0x1
        TessellationControlStage  = ...  # 0x2
        TessellationEvaluationStage = ...  # 0x4
        GeometryStage             = ...  # 0x8
        FragmentStage             = ...  # 0x10
        ComputeStage              = ...  # 0x20

    class TextureAndSampler(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, TextureAndSampler: PySide6.QtGui.QRhiShaderResourceBinding.TextureAndSampler) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class Type(enum.Enum):

        UniformBuffer             = ...  # 0x0
        SampledTexture            = ...  # 0x1
        Texture                   = ...  # 0x2
        Sampler                   = ...  # 0x3
        ImageLoad                 = ...  # 0x4
        ImageStore                = ...  # 0x5
        ImageLoadStore            = ...  # 0x6
        BufferLoad                = ...  # 0x7
        BufferStore               = ...  # 0x8
        BufferLoadStore           = ...  # 0x9


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiShaderResourceBinding: PySide6.QtGui.QRhiShaderResourceBinding) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    @typing.overload
    @staticmethod
    def bufferLoad(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, buf: PySide6.QtGui.QRhiBuffer) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @typing.overload
    @staticmethod
    def bufferLoad(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, buf: PySide6.QtGui.QRhiBuffer, offset: int, size: int) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @typing.overload
    @staticmethod
    def bufferLoadStore(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, buf: PySide6.QtGui.QRhiBuffer) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @typing.overload
    @staticmethod
    def bufferLoadStore(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, buf: PySide6.QtGui.QRhiBuffer, offset: int, size: int) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @typing.overload
    @staticmethod
    def bufferStore(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, buf: PySide6.QtGui.QRhiBuffer) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @typing.overload
    @staticmethod
    def bufferStore(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, buf: PySide6.QtGui.QRhiBuffer, offset: int, size: int) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @staticmethod
    def imageLoad(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, tex: PySide6.QtGui.QRhiTexture, level: int) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @staticmethod
    def imageLoadStore(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, tex: PySide6.QtGui.QRhiTexture, level: int) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @staticmethod
    def imageStore(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, tex: PySide6.QtGui.QRhiTexture, level: int) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    def isLayoutCompatible(self, other: PySide6.QtGui.QRhiShaderResourceBinding) -> bool: ...
    @staticmethod
    def sampledTexture(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, tex: PySide6.QtGui.QRhiTexture, sampler: PySide6.QtGui.QRhiSampler) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @staticmethod
    def sampledTextures(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, count: int, texSamplers: PySide6.QtGui.QRhiShaderResourceBinding.TextureAndSampler) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @staticmethod
    def sampler(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, sampler: PySide6.QtGui.QRhiSampler) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @staticmethod
    def texture(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, tex: PySide6.QtGui.QRhiTexture) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @staticmethod
    def textures(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, count: int, tex: PySide6.QtGui.QRhiTexture) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @typing.overload
    @staticmethod
    def uniformBuffer(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, buf: PySide6.QtGui.QRhiBuffer) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @typing.overload
    @staticmethod
    def uniformBuffer(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, buf: PySide6.QtGui.QRhiBuffer, offset: int, size: int) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    @staticmethod
    def uniformBufferWithDynamicOffset(binding: int, stage: PySide6.QtGui.QRhiShaderResourceBinding.StageFlag, buf: PySide6.QtGui.QRhiBuffer, size: int) -> PySide6.QtGui.QRhiShaderResourceBinding: ...


class Data(Shiboken.Object):

    class StorageBufferData(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, StorageBufferData: PySide6.QtGui.QRhiShaderResourceBinding.Data.StorageBufferData) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class StorageImageData(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, StorageImageData: PySide6.QtGui.QRhiShaderResourceBinding.Data.StorageImageData) -> None: ...

        @staticmethod
        def __copy__() -> None: ...


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, Data: PySide6.QtGui.QRhiShaderResourceBinding.Data) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def arraySize(self) -> int: ...


class StorageBufferData(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, StorageBufferData: PySide6.QtGui.QRhiShaderResourceBinding.Data.StorageBufferData) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class StorageImageData(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, StorageImageData: PySide6.QtGui.QRhiShaderResourceBinding.Data.StorageImageData) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class TextureAndSampler(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, TextureAndSampler: PySide6.QtGui.QRhiShaderResourceBinding.TextureAndSampler) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QRhiShaderResourceBindings(PySide6.QtGui.QRhiResource):

    class UpdateFlag(enum.Flag):

        BindingsAreSorted         = ...  # 0x1


    @staticmethod
    def __repr__() -> str: ...
    def bindingAt(self, index: int) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    def bindingCount(self) -> int: ...
    def cbeginBindings(self) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    def cendBindings(self) -> PySide6.QtGui.QRhiShaderResourceBinding: ...
    def create(self) -> bool: ...
    def isLayoutCompatible(self, other: PySide6.QtGui.QRhiShaderResourceBindings) -> bool: ...
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def serializedLayoutDescription(self) -> typing.List[int]: ...
    def setBindings(self, bindings: typing.Sequence[PySide6.QtGui.QRhiShaderResourceBinding]) -> None: ...
    def updateResources(self, flags: PySide6.QtGui.QRhiShaderResourceBindings.UpdateFlag = ...) -> None: ...


class QRhiShaderStage(Shiboken.Object):

    class Type(enum.Enum):

        Vertex                    = ...  # 0x0
        TessellationControl       = ...  # 0x1
        TessellationEvaluation    = ...  # 0x2
        Geometry                  = ...  # 0x3
        Fragment                  = ...  # 0x4
        Compute                   = ...  # 0x5


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtGui.QRhiShaderStage.Type, shader: PySide6.QtGui.QShader, v: PySide6.QtGui.QShader.Variant = ...) -> None: ...
    @typing.overload
    def __init__(self, QRhiShaderStage: PySide6.QtGui.QRhiShaderStage) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def setShader(self, s: PySide6.QtGui.QShader) -> None: ...
    def setShaderVariant(self, v: PySide6.QtGui.QShader.Variant) -> None: ...
    def setType(self, t: PySide6.QtGui.QRhiShaderStage.Type) -> None: ...
    def shader(self) -> PySide6.QtGui.QShader: ...
    def shaderVariant(self) -> PySide6.QtGui.QShader.Variant: ...
    def type(self) -> PySide6.QtGui.QRhiShaderStage.Type: ...


class QRhiStats(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiStats: PySide6.QtGui.QRhiStats) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...


class QRhiSwapChain(PySide6.QtGui.QRhiResource):

    class Flag(enum.Flag):

        SurfaceHasPreMulAlpha     = ...  # 0x1
        SurfaceHasNonPreMulAlpha  = ...  # 0x2
        sRGB                      = ...  # 0x4
        UsedAsTransferSource      = ...  # 0x8
        NoVSync                   = ...  # 0x10
        MinimalBufferCount        = ...  # 0x20

    class Format(enum.Enum):

        SDR                       = ...  # 0x0
        HDRExtendedSrgbLinear     = ...  # 0x1
        HDR10                     = ...  # 0x2
        HDRExtendedDisplayP3Linear = ...  # 0x3

    class StereoTargetBuffer(enum.Enum):

        LeftBuffer                = ...  # 0x0
        RightBuffer               = ...  # 0x1


    def createOrResize(self) -> bool: ...
    def currentFrameCommandBuffer(self) -> PySide6.QtGui.QRhiCommandBuffer: ...
    @typing.overload
    def currentFrameRenderTarget(self, targetBuffer: PySide6.QtGui.QRhiSwapChain.StereoTargetBuffer) -> PySide6.QtGui.QRhiRenderTarget: ...
    @typing.overload
    def currentFrameRenderTarget(self) -> PySide6.QtGui.QRhiRenderTarget: ...
    def currentPixelSize(self) -> PySide6.QtCore.QSize: ...
    def depthStencil(self) -> PySide6.QtGui.QRhiRenderBuffer: ...
    def flags(self) -> PySide6.QtGui.QRhiSwapChain.Flag: ...
    def format(self) -> PySide6.QtGui.QRhiSwapChain.Format: ...
    def isFormatSupported(self, f: PySide6.QtGui.QRhiSwapChain.Format) -> bool: ...
    def newCompatibleRenderPassDescriptor(self) -> PySide6.QtGui.QRhiRenderPassDescriptor: ...
    def renderPassDescriptor(self) -> PySide6.QtGui.QRhiRenderPassDescriptor: ...
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def sampleCount(self) -> int: ...
    def setDepthStencil(self, ds: PySide6.QtGui.QRhiRenderBuffer) -> None: ...
    def setFlags(self, f: PySide6.QtGui.QRhiSwapChain.Flag) -> None: ...
    def setFormat(self, f: PySide6.QtGui.QRhiSwapChain.Format) -> None: ...
    def setRenderPassDescriptor(self, desc: PySide6.QtGui.QRhiRenderPassDescriptor) -> None: ...
    def setSampleCount(self, samples: int) -> None: ...
    def setWindow(self, window: PySide6.QtGui.QWindow) -> None: ...
    def surfacePixelSize(self) -> PySide6.QtCore.QSize: ...
    def window(self) -> PySide6.QtGui.QWindow: ...


class QRhiSwapChainRenderTarget(PySide6.QtGui.QRhiRenderTarget):
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def swapChain(self) -> PySide6.QtGui.QRhiSwapChain: ...


class QRhiTexture(PySide6.QtGui.QRhiResource):

    class Flag(enum.Flag):

        RenderTarget              = ...  # 0x1
        CubeMap                   = ...  # 0x4
        MipMapped                 = ...  # 0x8
        sRGB                      = ...  # 0x10
        UsedAsTransferSource      = ...  # 0x20
        UsedWithGenerateMips      = ...  # 0x40
        UsedWithLoadStore         = ...  # 0x80
        UsedAsCompressedAtlas     = ...  # 0x100
        ExternalOES               = ...  # 0x200
        ThreeDimensional          = ...  # 0x400
        TextureRectangleGL        = ...  # 0x800
        TextureArray              = ...  # 0x1000
        OneDimensional            = ...  # 0x2000

    class Format(enum.Enum):

        UnknownFormat             = ...  # 0x0
        RGBA8                     = ...  # 0x1
        BGRA8                     = ...  # 0x2
        R8                        = ...  # 0x3
        RG8                       = ...  # 0x4
        R16                       = ...  # 0x5
        RG16                      = ...  # 0x6
        RED_OR_ALPHA8             = ...  # 0x7
        RGBA16F                   = ...  # 0x8
        RGBA32F                   = ...  # 0x9
        R16F                      = ...  # 0xa
        R32F                      = ...  # 0xb
        RGB10A2                   = ...  # 0xc
        D16                       = ...  # 0xd
        D24                       = ...  # 0xe
        D24S8                     = ...  # 0xf
        D32F                      = ...  # 0x10
        BC1                       = ...  # 0x11
        BC2                       = ...  # 0x12
        BC3                       = ...  # 0x13
        BC4                       = ...  # 0x14
        BC5                       = ...  # 0x15
        BC6H                      = ...  # 0x16
        BC7                       = ...  # 0x17
        ETC2_RGB8                 = ...  # 0x18
        ETC2_RGB8A1               = ...  # 0x19
        ETC2_RGBA8                = ...  # 0x1a
        ASTC_4x4                  = ...  # 0x1b
        ASTC_5x4                  = ...  # 0x1c
        ASTC_5x5                  = ...  # 0x1d
        ASTC_6x5                  = ...  # 0x1e
        ASTC_6x6                  = ...  # 0x1f
        ASTC_8x5                  = ...  # 0x20
        ASTC_8x6                  = ...  # 0x21
        ASTC_8x8                  = ...  # 0x22
        ASTC_10x5                 = ...  # 0x23
        ASTC_10x6                 = ...  # 0x24
        ASTC_10x8                 = ...  # 0x25
        ASTC_10x10                = ...  # 0x26
        ASTC_12x10                = ...  # 0x27
        ASTC_12x12                = ...  # 0x28

    class ViewFormat(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, ViewFormat: PySide6.QtGui.QRhiTexture.ViewFormat) -> None: ...

        @staticmethod
        def __copy__() -> None: ...


    def arrayRangeLength(self) -> int: ...
    def arrayRangeStart(self) -> int: ...
    def arraySize(self) -> int: ...
    def create(self) -> bool: ...
    def depth(self) -> int: ...
    def flags(self) -> PySide6.QtGui.QRhiTexture.Flag: ...
    def format(self) -> PySide6.QtGui.QRhiTexture.Format: ...
    def pixelSize(self) -> PySide6.QtCore.QSize: ...
    def readViewFormat(self) -> PySide6.QtGui.QRhiTexture.ViewFormat: ...
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def sampleCount(self) -> int: ...
    def setArrayRange(self, startIndex: int, count: int) -> None: ...
    def setArraySize(self, arraySize: int) -> None: ...
    def setDepth(self, depth: int) -> None: ...
    def setFlags(self, f: PySide6.QtGui.QRhiTexture.Flag) -> None: ...
    def setFormat(self, fmt: PySide6.QtGui.QRhiTexture.Format) -> None: ...
    def setNativeLayout(self, layout: int) -> None: ...
    def setPixelSize(self, sz: PySide6.QtCore.QSize) -> None: ...
    def setReadViewFormat(self, fmt: PySide6.QtGui.QRhiTexture.ViewFormat) -> None: ...
    def setSampleCount(self, s: int) -> None: ...
    def setWriteViewFormat(self, fmt: PySide6.QtGui.QRhiTexture.ViewFormat) -> None: ...
    def writeViewFormat(self) -> PySide6.QtGui.QRhiTexture.ViewFormat: ...


class ViewFormat(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, ViewFormat: PySide6.QtGui.QRhiTexture.ViewFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QRhiTextureCopyDescription(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiTextureCopyDescription: PySide6.QtGui.QRhiTextureCopyDescription) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def destinationLayer(self) -> int: ...
    def destinationLevel(self) -> int: ...
    def destinationTopLeft(self) -> PySide6.QtCore.QPoint: ...
    def pixelSize(self) -> PySide6.QtCore.QSize: ...
    def setDestinationLayer(self, layer: int) -> None: ...
    def setDestinationLevel(self, level: int) -> None: ...
    def setDestinationTopLeft(self, p: PySide6.QtCore.QPoint) -> None: ...
    def setPixelSize(self, sz: PySide6.QtCore.QSize) -> None: ...
    def setSourceLayer(self, layer: int) -> None: ...
    def setSourceLevel(self, level: int) -> None: ...
    def setSourceTopLeft(self, p: PySide6.QtCore.QPoint) -> None: ...
    def sourceLayer(self) -> int: ...
    def sourceLevel(self) -> int: ...
    def sourceTopLeft(self) -> PySide6.QtCore.QPoint: ...


class QRhiTextureRenderTarget(PySide6.QtGui.QRhiRenderTarget):

    class Flag(enum.Flag):

        PreserveColorContents     = ...  # 0x1
        PreserveDepthStencilContents = ...  # 0x2
        DoNotStoreDepthStencilContents = ...  # 0x4


    def create(self) -> bool: ...
    def description(self) -> PySide6.QtGui.QRhiTextureRenderTargetDescription: ...
    def flags(self) -> PySide6.QtGui.QRhiTextureRenderTarget.Flag: ...
    def newCompatibleRenderPassDescriptor(self) -> PySide6.QtGui.QRhiRenderPassDescriptor: ...
    def resourceType(self) -> PySide6.QtGui.QRhiResource.Type: ...
    def setDescription(self, desc: PySide6.QtGui.QRhiTextureRenderTargetDescription | PySide6.QtGui.QRhiColorAttachment) -> None: ...
    def setFlags(self, f: PySide6.QtGui.QRhiTextureRenderTarget.Flag) -> None: ...


class QRhiTextureRenderTargetDescription(Shiboken.Object):

    @typing.overload
    def __init__(self, colorAttachment: PySide6.QtGui.QRhiColorAttachment | PySide6.QtGui.QRhiRenderBuffer | PySide6.QtGui.QRhiTexture, depthStencilBuffer: PySide6.QtGui.QRhiRenderBuffer) -> None: ...
    @typing.overload
    def __init__(self, QRhiTextureRenderTargetDescription: PySide6.QtGui.QRhiTextureRenderTargetDescription) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, colorAttachment: PySide6.QtGui.QRhiColorAttachment | PySide6.QtGui.QRhiRenderBuffer | PySide6.QtGui.QRhiTexture, depthTexture: PySide6.QtGui.QRhiTexture) -> None: ...
    @typing.overload
    def __init__(self, colorAttachment: PySide6.QtGui.QRhiColorAttachment | PySide6.QtGui.QRhiRenderBuffer | PySide6.QtGui.QRhiTexture) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def cbeginColorAttachments(self) -> PySide6.QtGui.QRhiColorAttachment: ...
    def cendColorAttachments(self) -> PySide6.QtGui.QRhiColorAttachment: ...
    def colorAttachmentAt(self, index: int) -> PySide6.QtGui.QRhiColorAttachment: ...
    def colorAttachmentCount(self) -> int: ...
    def depthResolveTexture(self) -> PySide6.QtGui.QRhiTexture: ...
    def depthStencilBuffer(self) -> PySide6.QtGui.QRhiRenderBuffer: ...
    def depthTexture(self) -> PySide6.QtGui.QRhiTexture: ...
    def setColorAttachments(self, bcolor_attachments: typing.Sequence[PySide6.QtGui.QRhiColorAttachment]) -> None: ...
    def setDepthResolveTexture(self, tex: PySide6.QtGui.QRhiTexture) -> None: ...
    def setDepthStencilBuffer(self, renderBuffer: PySide6.QtGui.QRhiRenderBuffer) -> None: ...
    def setDepthTexture(self, texture: PySide6.QtGui.QRhiTexture) -> None: ...


class QRhiTextureSubresourceUploadDescription(Shiboken.Object):

    @typing.overload
    def __init__(self, QRhiTextureSubresourceUploadDescription: PySide6.QtGui.QRhiTextureSubresourceUploadDescription) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, image: PySide6.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    @typing.overload
    def __init__(self, data: int, size: int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def data(self) -> PySide6.QtCore.QByteArray: ...
    def dataStride(self) -> int: ...
    def destinationTopLeft(self) -> PySide6.QtCore.QPoint: ...
    def image(self) -> PySide6.QtGui.QImage: ...
    def setData(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    def setDataStride(self, stride: int) -> None: ...
    def setDestinationTopLeft(self, p: PySide6.QtCore.QPoint) -> None: ...
    def setImage(self, image: PySide6.QtGui.QImage) -> None: ...
    def setSourceSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setSourceTopLeft(self, p: PySide6.QtCore.QPoint) -> None: ...
    def sourceSize(self) -> PySide6.QtCore.QSize: ...
    def sourceTopLeft(self) -> PySide6.QtCore.QPoint: ...


class QRhiTextureUploadDescription(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, entry: PySide6.QtGui.QRhiTextureUploadEntry) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def cbeginEntries(self) -> PySide6.QtGui.QRhiTextureUploadEntry: ...
    def cendEntries(self) -> PySide6.QtGui.QRhiTextureUploadEntry: ...
    def entryAt(self, index: int) -> PySide6.QtGui.QRhiTextureUploadEntry: ...
    def entryCount(self) -> int: ...
    def setEntries(self, entries: typing.Sequence[PySide6.QtGui.QRhiTextureUploadEntry]) -> None: ...


class QRhiTextureUploadEntry(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiTextureUploadEntry: PySide6.QtGui.QRhiTextureUploadEntry) -> None: ...
    @typing.overload
    def __init__(self, layer: int, level: int, desc: PySide6.QtGui.QRhiTextureSubresourceUploadDescription) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def description(self) -> PySide6.QtGui.QRhiTextureSubresourceUploadDescription: ...
    def layer(self) -> int: ...
    def level(self) -> int: ...
    def setDescription(self, desc: PySide6.QtGui.QRhiTextureSubresourceUploadDescription) -> None: ...
    def setLayer(self, layer: int) -> None: ...
    def setLevel(self, level: int) -> None: ...


class QRhiVertexInputAttribute(Shiboken.Object):

    class Format(enum.Enum):

        Float4                    = ...  # 0x0
        Float3                    = ...  # 0x1
        Float2                    = ...  # 0x2
        Float                     = ...  # 0x3
        UNormByte4                = ...  # 0x4
        UNormByte2                = ...  # 0x5
        UNormByte                 = ...  # 0x6
        UInt4                     = ...  # 0x7
        UInt3                     = ...  # 0x8
        UInt2                     = ...  # 0x9
        UInt                      = ...  # 0xa
        SInt4                     = ...  # 0xb
        SInt3                     = ...  # 0xc
        SInt2                     = ...  # 0xd
        SInt                      = ...  # 0xe
        Half4                     = ...  # 0xf
        Half3                     = ...  # 0x10
        Half2                     = ...  # 0x11
        Half                      = ...  # 0x12
        UShort4                   = ...  # 0x13
        UShort3                   = ...  # 0x14
        UShort2                   = ...  # 0x15
        UShort                    = ...  # 0x16
        SShort4                   = ...  # 0x17
        SShort3                   = ...  # 0x18
        SShort2                   = ...  # 0x19
        SShort                    = ...  # 0x1a


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiVertexInputAttribute: PySide6.QtGui.QRhiVertexInputAttribute) -> None: ...
    @typing.overload
    def __init__(self, binding: int, location: int, format: PySide6.QtGui.QRhiVertexInputAttribute.Format, offset: int, matrixSlice: int = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def binding(self) -> int: ...
    def format(self) -> PySide6.QtGui.QRhiVertexInputAttribute.Format: ...
    def location(self) -> int: ...
    def matrixSlice(self) -> int: ...
    def offset(self) -> int: ...
    def setBinding(self, b: int) -> None: ...
    def setFormat(self, f: PySide6.QtGui.QRhiVertexInputAttribute.Format) -> None: ...
    def setLocation(self, loc: int) -> None: ...
    def setMatrixSlice(self, slice: int) -> None: ...
    def setOffset(self, ofs: int) -> None: ...


class QRhiVertexInputBinding(Shiboken.Object):

    class Classification(enum.Enum):

        PerVertex                 = ...  # 0x0
        PerInstance               = ...  # 0x1


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, stride: int, cls: PySide6.QtGui.QRhiVertexInputBinding.Classification = ..., stepRate: int = ...) -> None: ...
    @typing.overload
    def __init__(self, QRhiVertexInputBinding: PySide6.QtGui.QRhiVertexInputBinding) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def classification(self) -> PySide6.QtGui.QRhiVertexInputBinding.Classification: ...
    def instanceStepRate(self) -> int: ...
    def setClassification(self, c: PySide6.QtGui.QRhiVertexInputBinding.Classification) -> None: ...
    def setInstanceStepRate(self, rate: int) -> None: ...
    def setStride(self, s: int) -> None: ...
    def stride(self) -> int: ...


class QRhiVertexInputLayout(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRhiVertexInputLayout: PySide6.QtGui.QRhiVertexInputLayout) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def attributeAt(self, index: int) -> PySide6.QtGui.QRhiVertexInputAttribute: ...
    def attributeCount(self) -> int: ...
    def bindingAt(self, index: int) -> PySide6.QtGui.QRhiVertexInputBinding: ...
    def bindingCount(self) -> int: ...
    def cbeginAttributes(self) -> PySide6.QtGui.QRhiVertexInputAttribute: ...
    def cbeginBindings(self) -> PySide6.QtGui.QRhiVertexInputBinding: ...
    def cendAttributes(self) -> PySide6.QtGui.QRhiVertexInputAttribute: ...
    def cendBindings(self) -> PySide6.QtGui.QRhiVertexInputBinding: ...
    def setAttributes(self, attributes: typing.Sequence[PySide6.QtGui.QRhiVertexInputAttribute]) -> None: ...
    def setBindings(self, bindings: typing.Sequence[PySide6.QtGui.QRhiVertexInputBinding]) -> None: ...


class QRhiViewport(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, w: float, h: float, minDepth: float = ..., maxDepth: float = ...) -> None: ...
    @typing.overload
    def __init__(self, QRhiViewport: PySide6.QtGui.QRhiViewport) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def maxDepth(self) -> float: ...
    def minDepth(self) -> float: ...
    def setMaxDepth(self, maxDepth: float) -> None: ...
    def setMinDepth(self, minDepth: float) -> None: ...
    def setViewport(self, x: float, y: float, w: float, h: float) -> None: ...
    def viewport(self) -> typing.List[float]: ...


class QScreen(PySide6.QtCore.QObject):

    availableGeometryChanged : typing.ClassVar[Signal] = ... # availableGeometryChanged(QRect)
    geometryChanged          : typing.ClassVar[Signal] = ... # geometryChanged(QRect)
    logicalDotsPerInchChanged: typing.ClassVar[Signal] = ... # logicalDotsPerInchChanged(double)
    orientationChanged       : typing.ClassVar[Signal] = ... # orientationChanged(Qt::ScreenOrientation)
    physicalDotsPerInchChanged: typing.ClassVar[Signal] = ... # physicalDotsPerInchChanged(double)
    physicalSizeChanged      : typing.ClassVar[Signal] = ... # physicalSizeChanged(QSizeF)
    primaryOrientationChanged: typing.ClassVar[Signal] = ... # primaryOrientationChanged(Qt::ScreenOrientation)
    refreshRateChanged       : typing.ClassVar[Signal] = ... # refreshRateChanged(double)
    virtualGeometryChanged   : typing.ClassVar[Signal] = ... # virtualGeometryChanged(QRect)
    @staticmethod
    def __repr__() -> str: ...
    def angleBetween(self, a: PySide6.QtCore.Qt.ScreenOrientation, b: PySide6.QtCore.Qt.ScreenOrientation) -> int: ...
    def availableGeometry(self) -> PySide6.QtCore.QRect: ...
    def availableSize(self) -> PySide6.QtCore.QSize: ...
    def availableVirtualGeometry(self) -> PySide6.QtCore.QRect: ...
    def availableVirtualSize(self) -> PySide6.QtCore.QSize: ...
    def depth(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    def geometry(self) -> PySide6.QtCore.QRect: ...
    def grabWindow(self, window: int = ..., x: int = ..., y: int = ..., w: int = ..., h: int = ...) -> PySide6.QtGui.QPixmap: ...
    def isLandscape(self, orientation: PySide6.QtCore.Qt.ScreenOrientation) -> bool: ...
    def isPortrait(self, orientation: PySide6.QtCore.Qt.ScreenOrientation) -> bool: ...
    def logicalDotsPerInch(self) -> float: ...
    def logicalDotsPerInchX(self) -> float: ...
    def logicalDotsPerInchY(self) -> float: ...
    def manufacturer(self) -> str: ...
    def mapBetween(self, a: PySide6.QtCore.Qt.ScreenOrientation, b: PySide6.QtCore.Qt.ScreenOrientation, rect: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    def model(self) -> str: ...
    def name(self) -> str: ...
    def nativeInterface(self) -> object: ...
    def nativeOrientation(self) -> PySide6.QtCore.Qt.ScreenOrientation: ...
    def orientation(self) -> PySide6.QtCore.Qt.ScreenOrientation: ...
    def physicalDotsPerInch(self) -> float: ...
    def physicalDotsPerInchX(self) -> float: ...
    def physicalDotsPerInchY(self) -> float: ...
    def physicalSize(self) -> PySide6.QtCore.QSizeF: ...
    def primaryOrientation(self) -> PySide6.QtCore.Qt.ScreenOrientation: ...
    def refreshRate(self) -> float: ...
    def resolveInterface(self, name: bytes | bytearray | memoryview, revision: int) -> int: ...
    def serialNumber(self) -> str: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def transformBetween(self, a: PySide6.QtCore.Qt.ScreenOrientation, b: PySide6.QtCore.Qt.ScreenOrientation, target: PySide6.QtCore.QRect) -> PySide6.QtGui.QTransform: ...
    def virtualGeometry(self) -> PySide6.QtCore.QRect: ...
    def virtualSiblingAt(self, point: PySide6.QtCore.QPoint) -> PySide6.QtGui.QScreen: ...
    def virtualSiblings(self) -> typing.List[PySide6.QtGui.QScreen]: ...
    def virtualSize(self) -> PySide6.QtCore.QSize: ...


class QScrollEvent(PySide6.QtCore.QEvent):

    class ScrollState(enum.Enum):

        ScrollStarted             = ...  # 0x0
        ScrollUpdated             = ...  # 0x1
        ScrollFinished            = ...  # 0x2


    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QScrollEvent) -> None: ...
    @typing.overload
    def __init__(self, contentPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, overshoot: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, scrollState: PySide6.QtGui.QScrollEvent.ScrollState) -> None: ...

    def clone(self) -> PySide6.QtGui.QScrollEvent: ...
    def contentPos(self) -> PySide6.QtCore.QPointF: ...
    def overshootDistance(self) -> PySide6.QtCore.QPointF: ...
    def scrollState(self) -> PySide6.QtGui.QScrollEvent.ScrollState: ...


class QScrollPrepareEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, startPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QScrollPrepareEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QScrollPrepareEvent: ...
    def contentPos(self) -> PySide6.QtCore.QPointF: ...
    def contentPosRange(self) -> PySide6.QtCore.QRectF: ...
    def setContentPos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def setContentPosRange(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> None: ...
    def setViewportSize(self, size: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize) -> None: ...
    def startPos(self) -> PySide6.QtCore.QPointF: ...
    def viewportSize(self) -> PySide6.QtCore.QSizeF: ...


class QSessionManager(PySide6.QtCore.QObject):

    class RestartHint(enum.Enum):

        RestartIfRunning          = ...  # 0x0
        RestartAnyway             = ...  # 0x1
        RestartImmediately        = ...  # 0x2
        RestartNever              = ...  # 0x3


    def allowsErrorInteraction(self) -> bool: ...
    def allowsInteraction(self) -> bool: ...
    def cancel(self) -> None: ...
    def discardCommand(self) -> typing.List[str]: ...
    def isPhase2(self) -> bool: ...
    def release(self) -> None: ...
    def requestPhase2(self) -> None: ...
    def restartCommand(self) -> typing.List[str]: ...
    def restartHint(self) -> PySide6.QtGui.QSessionManager.RestartHint: ...
    def sessionId(self) -> str: ...
    def sessionKey(self) -> str: ...
    def setDiscardCommand(self, arg__1: typing.Sequence[str]) -> None: ...
    @typing.overload
    def setManagerProperty(self, name: str, value: str) -> None: ...
    @typing.overload
    def setManagerProperty(self, name: str, value: typing.Sequence[str]) -> None: ...
    def setRestartCommand(self, arg__1: typing.Sequence[str]) -> None: ...
    def setRestartHint(self, arg__1: PySide6.QtGui.QSessionManager.RestartHint) -> None: ...


class QShader(Shiboken.Object):

    class SerializedFormatVersion(enum.Enum):

        Latest                    = ...  # 0x0
        Qt_6_5                    = ...  # 0x1
        Qt_6_4                    = ...  # 0x2

    class Source(enum.Enum):

        SpirvShader               = ...  # 0x0
        GlslShader                = ...  # 0x1
        HlslShader                = ...  # 0x2
        DxbcShader                = ...  # 0x3
        MslShader                 = ...  # 0x4
        DxilShader                = ...  # 0x5
        MetalLibShader            = ...  # 0x6
        WgslShader                = ...  # 0x7

    class Stage(enum.Enum):

        VertexStage               = ...  # 0x0
        TessellationControlStage  = ...  # 0x1
        TessellationEvaluationStage = ...  # 0x2
        GeometryStage             = ...  # 0x3
        FragmentStage             = ...  # 0x4
        ComputeStage              = ...  # 0x5

    class Variant(enum.Enum):

        StandardShader            = ...  # 0x0
        BatchableVertexShader     = ...  # 0x1
        UInt16IndexedVertexAsComputeShader = ...  # 0x2
        UInt32IndexedVertexAsComputeShader = ...  # 0x3
        NonIndexedVertexAsComputeShader = ...  # 0x4


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QShader) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def availableShaders(self) -> typing.List[PySide6.QtGui.QShaderKey]: ...
    @staticmethod
    def fromSerialized(data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> PySide6.QtGui.QShader: ...
    def isValid(self) -> bool: ...
    def nativeResourceBindingMap(self, key: PySide6.QtGui.QShaderKey) -> typing.Dict[int, typing.Tuple[int, int]]: ...
    def removeNativeShaderInfo(self, key: PySide6.QtGui.QShaderKey) -> None: ...
    def removeResourceBindingMap(self, key: PySide6.QtGui.QShaderKey) -> None: ...
    def removeSeparateToCombinedImageSamplerMappingList(self, key: PySide6.QtGui.QShaderKey) -> None: ...
    def removeShader(self, key: PySide6.QtGui.QShaderKey) -> None: ...
    def serialized(self, version: PySide6.QtGui.QShader.SerializedFormatVersion = ...) -> PySide6.QtCore.QByteArray: ...
    def setResourceBindingMap(self, key: PySide6.QtGui.QShaderKey, map: typing.Dict[int, typing.Tuple[int, int]]) -> None: ...
    def setShader(self, key: PySide6.QtGui.QShaderKey, shader: PySide6.QtGui.QShaderCode | PySide6.QtCore.QByteArray) -> None: ...
    def setStage(self, stage: PySide6.QtGui.QShader.Stage) -> None: ...
    def shader(self, key: PySide6.QtGui.QShaderKey) -> PySide6.QtGui.QShaderCode: ...
    def stage(self) -> PySide6.QtGui.QShader.Stage: ...
    def swap(self, other: PySide6.QtGui.QShader) -> None: ...


class QShaderCode(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, code: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, entry: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ...) -> None: ...
    @typing.overload
    def __init__(self, QShaderCode: PySide6.QtGui.QShaderCode) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def entryPoint(self) -> PySide6.QtCore.QByteArray: ...
    def setEntryPoint(self, entry: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    def setShader(self, code: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    def shader(self) -> PySide6.QtCore.QByteArray: ...


class QShaderKey(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, s: PySide6.QtGui.QShader.Source, sver: PySide6.QtGui.QShaderVersion | int, svar: PySide6.QtGui.QShader.Variant = ...) -> None: ...
    @typing.overload
    def __init__(self, QShaderKey: PySide6.QtGui.QShaderKey) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def setSource(self, s: PySide6.QtGui.QShader.Source) -> None: ...
    def setSourceVariant(self, svar: PySide6.QtGui.QShader.Variant) -> None: ...
    def setSourceVersion(self, sver: PySide6.QtGui.QShaderVersion | int) -> None: ...
    def source(self) -> PySide6.QtGui.QShader.Source: ...
    def sourceVariant(self) -> PySide6.QtGui.QShader.Variant: ...
    def sourceVersion(self) -> PySide6.QtGui.QShaderVersion: ...


class QShaderVersion(Shiboken.Object):

    class Flag(enum.Flag):

        GlslEs                    = ...  # 0x1


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, v: int, f: PySide6.QtGui.QShaderVersion.Flag = ...) -> None: ...
    @typing.overload
    def __init__(self, QShaderVersion: PySide6.QtGui.QShaderVersion) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def flags(self) -> PySide6.QtGui.QShaderVersion.Flag: ...
    def setFlags(self, f: PySide6.QtGui.QShaderVersion.Flag) -> None: ...
    def setVersion(self, v: int) -> None: ...
    def version(self) -> int: ...


class QShortcut(PySide6.QtCore.QObject):

    activated                : typing.ClassVar[Signal] = ... # activated()
    activatedAmbiguously     : typing.ClassVar[Signal] = ... # activatedAmbiguously()

    @typing.overload
    def __init__(self, key: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, parent: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview | None= ..., ambiguousMember: bytes | bytearray | memoryview | None= ..., context: PySide6.QtCore.Qt.ShortcutContext = ...) -> None: ...
    @typing.overload
    def __init__(self, key: PySide6.QtGui.QKeySequence.StandardKey, parent: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview | None= ..., ambiguousMember: bytes | bytearray | memoryview | None= ..., context: PySide6.QtCore.Qt.ShortcutContext = ...) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QKeySequence.StandardKey, arg__2: PySide6.QtCore.QObject, arg__3: typing.Callable, arg__4: PySide6.QtCore.Qt.ShortcutContext = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, arg__2: PySide6.QtCore.QObject, arg__3: typing.Callable, arg__4: PySide6.QtCore.Qt.ShortcutContext = ...) -> None: ...

    def autoRepeat(self) -> bool: ...
    def context(self) -> PySide6.QtCore.Qt.ShortcutContext: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def id(self) -> int: ...
    def isEnabled(self) -> bool: ...
    def key(self) -> PySide6.QtGui.QKeySequence: ...
    def keys(self) -> typing.List[PySide6.QtGui.QKeySequence]: ...
    def setAutoRepeat(self, on: bool) -> None: ...
    def setContext(self, context: PySide6.QtCore.Qt.ShortcutContext) -> None: ...
    def setEnabled(self, enable: bool) -> None: ...
    def setKey(self, key: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int) -> None: ...
    @typing.overload
    def setKeys(self, key: PySide6.QtGui.QKeySequence.StandardKey) -> None: ...
    @typing.overload
    def setKeys(self, keys: typing.Sequence[PySide6.QtGui.QKeySequence]) -> None: ...
    def setWhatsThis(self, text: str) -> None: ...
    def whatsThis(self) -> str: ...


class QShortcutEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QShortcutEvent) -> None: ...
    @typing.overload
    def __init__(self, key: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, shortcut: PySide6.QtGui.QShortcut | None= ..., ambiguous: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, key: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, id: int, ambiguous: bool = ...) -> None: ...

    def clone(self) -> PySide6.QtGui.QShortcutEvent: ...
    def isAmbiguous(self) -> bool: ...
    def key(self) -> PySide6.QtGui.QKeySequence: ...
    def shortcutId(self) -> int: ...


class QShowEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QShowEvent: ...


class QSinglePointEvent(PySide6.QtGui.QPointerEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QSinglePointEvent) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, dev: PySide6.QtGui.QPointingDevice, point: PySide6.QtGui.QEventPoint, button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, source: PySide6.QtCore.Qt.MouseEventSource) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, dev: PySide6.QtGui.QPointingDevice, localPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, scenePos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, globalPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, source: PySide6.QtCore.Qt.MouseEventSource = ...) -> None: ...

    def button(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def buttons(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def clone(self) -> PySide6.QtGui.QSinglePointEvent: ...
    def exclusivePointGrabber(self) -> PySide6.QtCore.QObject: ...
    def globalPosition(self) -> PySide6.QtCore.QPointF: ...
    def isBeginEvent(self) -> bool: ...
    def isEndEvent(self) -> bool: ...
    def isUpdateEvent(self) -> bool: ...
    def position(self) -> PySide6.QtCore.QPointF: ...
    def scenePosition(self) -> PySide6.QtCore.QPointF: ...
    def setExclusivePointGrabber(self, exclusiveGrabber: PySide6.QtCore.QObject) -> None: ...


class QStandardItem(Shiboken.Object):

    class ItemType(enum.Enum):

        Type                      = ...  # 0x0
        UserType                  = ...  # 0x3e8


    @typing.overload
    def __init__(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, text: str) -> None: ...
    @typing.overload
    def __init__(self, rows: int, columns: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QStandardItem) -> None: ...

    def __lshift__(self, out: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, in_: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def accessibleDescription(self) -> str: ...
    def accessibleText(self) -> str: ...
    def appendColumn(self, items: typing.Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    @typing.overload
    def appendRow(self, items: typing.Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    @typing.overload
    def appendRow(self, item: PySide6.QtGui.QStandardItem) -> None: ...
    def appendRows(self, items: typing.Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    def background(self) -> PySide6.QtGui.QBrush: ...
    def checkState(self) -> PySide6.QtCore.Qt.CheckState: ...
    def child(self, row: int, column: int = ...) -> PySide6.QtGui.QStandardItem: ...
    def clearData(self) -> None: ...
    def clone(self) -> PySide6.QtGui.QStandardItem: ...
    def column(self) -> int: ...
    def columnCount(self) -> int: ...
    def data(self, role: int = ...) -> typing.Any: ...
    def emitDataChanged(self) -> None: ...
    def flags(self) -> PySide6.QtCore.Qt.ItemFlag: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def foreground(self) -> PySide6.QtGui.QBrush: ...
    def hasChildren(self) -> bool: ...
    def icon(self) -> PySide6.QtGui.QIcon: ...
    def index(self) -> PySide6.QtCore.QModelIndex: ...
    def insertColumn(self, column: int, items: typing.Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    def insertColumns(self, column: int, count: int) -> None: ...
    @typing.overload
    def insertRow(self, row: int, items: typing.Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    @typing.overload
    def insertRow(self, row: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    @typing.overload
    def insertRows(self, row: int, count: int) -> None: ...
    @typing.overload
    def insertRows(self, row: int, items: typing.Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    def isAutoTristate(self) -> bool: ...
    def isCheckable(self) -> bool: ...
    def isDragEnabled(self) -> bool: ...
    def isDropEnabled(self) -> bool: ...
    def isEditable(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isSelectable(self) -> bool: ...
    def isUserTristate(self) -> bool: ...
    def model(self) -> PySide6.QtGui.QStandardItemModel: ...
    def multiData(self, roleDataSpan: PySide6.QtCore.QModelRoleDataSpan | PySide6.QtCore.QModelRoleData) -> None: ...
    def parent(self) -> PySide6.QtGui.QStandardItem: ...
    def read(self, in_: PySide6.QtCore.QDataStream) -> None: ...
    def removeColumn(self, column: int) -> None: ...
    def removeColumns(self, column: int, count: int) -> None: ...
    def removeRow(self, row: int) -> None: ...
    def removeRows(self, row: int, count: int) -> None: ...
    def row(self) -> int: ...
    def rowCount(self) -> int: ...
    def setAccessibleDescription(self, accessibleDescription: str) -> None: ...
    def setAccessibleText(self, accessibleText: str) -> None: ...
    def setAutoTristate(self, tristate: bool) -> None: ...
    def setBackground(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setCheckState(self, checkState: PySide6.QtCore.Qt.CheckState) -> None: ...
    def setCheckable(self, checkable: bool) -> None: ...
    @typing.overload
    def setChild(self, row: int, column: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    @typing.overload
    def setChild(self, row: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    def setColumnCount(self, columns: int) -> None: ...
    def setData(self, value: typing.Any, role: int = ...) -> None: ...
    def setDragEnabled(self, dragEnabled: bool) -> None: ...
    def setDropEnabled(self, dropEnabled: bool) -> None: ...
    def setEditable(self, editable: bool) -> None: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def setFlags(self, flags: PySide6.QtCore.Qt.ItemFlag) -> None: ...
    def setFont(self, font: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> None: ...
    def setForeground(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setIcon(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap) -> None: ...
    def setRowCount(self, rows: int) -> None: ...
    def setSelectable(self, selectable: bool) -> None: ...
    def setSizeHint(self, sizeHint: PySide6.QtCore.QSize) -> None: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextAlignment(self, textAlignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def setUserTristate(self, tristate: bool) -> None: ...
    def setWhatsThis(self, whatsThis: str) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def sortChildren(self, column: int, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def statusTip(self) -> str: ...
    def takeChild(self, row: int, column: int = ...) -> PySide6.QtGui.QStandardItem: ...
    def takeColumn(self, column: int) -> typing.List[PySide6.QtGui.QStandardItem]: ...
    def takeRow(self, row: int) -> typing.List[PySide6.QtGui.QStandardItem]: ...
    def text(self) -> str: ...
    def textAlignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out: PySide6.QtCore.QDataStream) -> None: ...


class QStandardItemModel(PySide6.QtCore.QAbstractItemModel):

    itemChanged              : typing.ClassVar[Signal] = ... # itemChanged(QStandardItem*)

    @typing.overload
    def __init__(self, rows: int, columns: int, parent: PySide6.QtCore.QObject | None= ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    def appendColumn(self, items: typing.Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    @typing.overload
    def appendRow(self, items: typing.Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    @typing.overload
    def appendRow(self, item: PySide6.QtGui.QStandardItem) -> None: ...
    def clear(self) -> None: ...
    def clearItemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex) -> bool: ...
    def columnCount(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def data(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex) -> bool: ...
    def findItems(self, text: str, flags: PySide6.QtCore.Qt.MatchFlag = ..., column: int = ...) -> typing.List[PySide6.QtGui.QStandardItem]: ...
    def flags(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex) -> PySide6.QtCore.Qt.ItemFlag: ...
    def hasChildren(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def horizontalHeaderItem(self, column: int) -> PySide6.QtGui.QStandardItem: ...
    def index(self, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> PySide6.QtCore.QModelIndex: ...
    def indexFromItem(self, item: PySide6.QtGui.QStandardItem) -> PySide6.QtCore.QModelIndex: ...
    @typing.overload
    def insertColumn(self, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    @typing.overload
    def insertColumn(self, column: int, items: typing.Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    def insertColumns(self, column: int, count: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    @typing.overload
    def insertRow(self, row: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    @typing.overload
    def insertRow(self, row: int, items: typing.Sequence[PySide6.QtGui.QStandardItem]) -> None: ...
    @typing.overload
    def insertRow(self, row: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    def insertRows(self, row: int, count: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def invisibleRootItem(self) -> PySide6.QtGui.QStandardItem: ...
    def item(self, row: int, column: int = ...) -> PySide6.QtGui.QStandardItem: ...
    def itemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex) -> typing.Dict[int, typing.Any]: ...
    def itemFromIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex) -> PySide6.QtGui.QStandardItem: ...
    def itemPrototype(self) -> PySide6.QtGui.QStandardItem: ...
    def mimeData(self, indexes: typing.Sequence[PySide6.QtCore.QModelIndex]) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def multiData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, roleDataSpan: PySide6.QtCore.QModelRoleDataSpan | PySide6.QtCore.QModelRoleData) -> None: ...
    @typing.overload
    def parent(self) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def removeColumns(self, column: int, count: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def roleNames(self) -> typing.Dict[int, PySide6.QtCore.QByteArray]: ...
    def rowCount(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def setColumnCount(self, columns: int) -> None: ...
    def setData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, value: typing.Any, role: int = ...) -> bool: ...
    def setHorizontalHeaderItem(self, column: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    def setHorizontalHeaderLabels(self, labels: typing.Sequence[str]) -> None: ...
    @typing.overload
    def setItem(self, row: int, column: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    @typing.overload
    def setItem(self, row: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    def setItemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, roles: typing.Dict[int, typing.Any]) -> bool: ...
    def setItemPrototype(self, item: PySide6.QtGui.QStandardItem) -> None: ...
    def setItemRoleNames(self, roleNames: typing.Dict[int, PySide6.QtCore.QByteArray]) -> None: ...
    def setRowCount(self, rows: int) -> None: ...
    def setSortRole(self, role: int) -> None: ...
    def setVerticalHeaderItem(self, row: int, item: PySide6.QtGui.QStandardItem) -> None: ...
    def setVerticalHeaderLabels(self, labels: typing.Sequence[str]) -> None: ...
    def sort(self, column: int, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def sortRole(self) -> int: ...
    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropAction: ...
    def takeColumn(self, column: int) -> typing.List[PySide6.QtGui.QStandardItem]: ...
    def takeHorizontalHeaderItem(self, column: int) -> PySide6.QtGui.QStandardItem: ...
    def takeItem(self, row: int, column: int = ...) -> PySide6.QtGui.QStandardItem: ...
    def takeRow(self, row: int) -> typing.List[PySide6.QtGui.QStandardItem]: ...
    def takeVerticalHeaderItem(self, row: int) -> PySide6.QtGui.QStandardItem: ...
    def verticalHeaderItem(self, row: int) -> PySide6.QtGui.QStandardItem: ...


class QStaticText(Shiboken.Object):

    class PerformanceHint(enum.Enum):

        ModerateCaching           = ...  # 0x0
        AggressiveCaching         = ...  # 0x1


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QStaticText) -> None: ...
    @typing.overload
    def __init__(self, text: str) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def performanceHint(self) -> PySide6.QtGui.QStaticText.PerformanceHint: ...
    def prepare(self, matrix: PySide6.QtGui.QTransform = ..., font: PySide6.QtGui.QFont | str | typing.Sequence[str]= ...) -> None: ...
    def setPerformanceHint(self, performanceHint: PySide6.QtGui.QStaticText.PerformanceHint) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextFormat(self, textFormat: PySide6.QtCore.Qt.TextFormat) -> None: ...
    def setTextOption(self, textOption: PySide6.QtGui.QTextOption | PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setTextWidth(self, textWidth: float) -> None: ...
    def size(self) -> PySide6.QtCore.QSizeF: ...
    def swap(self, other: PySide6.QtGui.QStaticText) -> None: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide6.QtCore.Qt.TextFormat: ...
    def textOption(self) -> PySide6.QtGui.QTextOption: ...
    def textWidth(self) -> float: ...


class QStatusTipEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, tip: str) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QStatusTipEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QStatusTipEvent: ...
    def tip(self) -> str: ...


class QStyleHints(PySide6.QtCore.QObject):

    colorSchemeChanged       : typing.ClassVar[Signal] = ... # colorSchemeChanged(Qt::ColorScheme)
    contextMenuTriggerChanged: typing.ClassVar[Signal] = ... # contextMenuTriggerChanged(Qt::ContextMenuTrigger)
    cursorFlashTimeChanged   : typing.ClassVar[Signal] = ... # cursorFlashTimeChanged(int)
    keyboardInputIntervalChanged: typing.ClassVar[Signal] = ... # keyboardInputIntervalChanged(int)
    mouseDoubleClickIntervalChanged: typing.ClassVar[Signal] = ... # mouseDoubleClickIntervalChanged(int)
    mousePressAndHoldIntervalChanged: typing.ClassVar[Signal] = ... # mousePressAndHoldIntervalChanged(int)
    mouseQuickSelectionThresholdChanged: typing.ClassVar[Signal] = ... # mouseQuickSelectionThresholdChanged(int)
    showShortcutsInContextMenusChanged: typing.ClassVar[Signal] = ... # showShortcutsInContextMenusChanged(bool)
    startDragDistanceChanged : typing.ClassVar[Signal] = ... # startDragDistanceChanged(int)
    startDragTimeChanged     : typing.ClassVar[Signal] = ... # startDragTimeChanged(int)
    tabFocusBehaviorChanged  : typing.ClassVar[Signal] = ... # tabFocusBehaviorChanged(Qt::TabFocusBehavior)
    useHoverEffectsChanged   : typing.ClassVar[Signal] = ... # useHoverEffectsChanged(bool)
    wheelScrollLinesChanged  : typing.ClassVar[Signal] = ... # wheelScrollLinesChanged(int)
    def colorScheme(self) -> PySide6.QtCore.Qt.ColorScheme: ...
    def contextMenuTrigger(self) -> PySide6.QtCore.Qt.ContextMenuTrigger: ...
    def cursorFlashTime(self) -> int: ...
    def fontSmoothingGamma(self) -> float: ...
    def keyboardAutoRepeatRate(self) -> int: ...
    def keyboardAutoRepeatRateF(self) -> float: ...
    def keyboardInputInterval(self) -> int: ...
    def mouseDoubleClickDistance(self) -> int: ...
    def mouseDoubleClickInterval(self) -> int: ...
    def mousePressAndHoldInterval(self) -> int: ...
    def mouseQuickSelectionThreshold(self) -> int: ...
    def passwordMaskCharacter(self) -> str: ...
    def passwordMaskDelay(self) -> int: ...
    def setColorScheme(self, scheme: PySide6.QtCore.Qt.ColorScheme) -> None: ...
    def setContextMenuTrigger(self, contextMenuTrigger: PySide6.QtCore.Qt.ContextMenuTrigger) -> None: ...
    def setCursorFlashTime(self, cursorFlashTime: int) -> None: ...
    def setFocusOnTouchRelease(self) -> bool: ...
    def setKeyboardInputInterval(self, keyboardInputInterval: int) -> None: ...
    def setMouseDoubleClickInterval(self, mouseDoubleClickInterval: int) -> None: ...
    def setMousePressAndHoldInterval(self, mousePressAndHoldInterval: int) -> None: ...
    def setMouseQuickSelectionThreshold(self, threshold: int) -> None: ...
    def setShowShortcutsInContextMenus(self, showShortcutsInContextMenus: bool) -> None: ...
    def setStartDragDistance(self, startDragDistance: int) -> None: ...
    def setStartDragTime(self, startDragTime: int) -> None: ...
    def setTabFocusBehavior(self, tabFocusBehavior: PySide6.QtCore.Qt.TabFocusBehavior) -> None: ...
    def setUseHoverEffects(self, useHoverEffects: bool) -> None: ...
    def setWheelScrollLines(self, scrollLines: int) -> None: ...
    def showIsFullScreen(self) -> bool: ...
    def showIsMaximized(self) -> bool: ...
    def showShortcutsInContextMenus(self) -> bool: ...
    def singleClickActivation(self) -> bool: ...
    def startDragDistance(self) -> int: ...
    def startDragTime(self) -> int: ...
    def startDragVelocity(self) -> int: ...
    def tabFocusBehavior(self) -> PySide6.QtCore.Qt.TabFocusBehavior: ...
    def touchDoubleTapDistance(self) -> int: ...
    def unsetColorScheme(self) -> None: ...
    def useHoverEffects(self) -> bool: ...
    def useRtlExtensions(self) -> bool: ...
    def wheelScrollLines(self) -> int: ...


class QSurface(Shiboken.Object):

    class SurfaceClass(enum.Enum):

        Window                    = ...  # 0x0
        Offscreen                 = ...  # 0x1

    class SurfaceType(enum.Enum):

        RasterSurface             = ...  # 0x0
        OpenGLSurface             = ...  # 0x1
        RasterGLSurface           = ...  # 0x2
        OpenVGSurface             = ...  # 0x3
        VulkanSurface             = ...  # 0x4
        MetalSurface              = ...  # 0x5
        Direct3DSurface           = ...  # 0x6


    def __init__(self, type: PySide6.QtGui.QSurface.SurfaceClass) -> None: ...

    def format(self) -> PySide6.QtGui.QSurfaceFormat: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def supportsOpenGL(self) -> bool: ...
    def surfaceClass(self) -> PySide6.QtGui.QSurface.SurfaceClass: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> PySide6.QtGui.QSurface.SurfaceType: ...


class QSurfaceFormat(Shiboken.Object):

    class ColorSpace(enum.Enum):

        DefaultColorSpace         = ...  # 0x0
        sRGBColorSpace            = ...  # 0x1

    class FormatOption(enum.Flag):

        StereoBuffers             = ...  # 0x1
        DebugContext              = ...  # 0x2
        DeprecatedFunctions       = ...  # 0x4
        ResetNotification         = ...  # 0x8
        ProtectedContent          = ...  # 0x10

    class OpenGLContextProfile(enum.Enum):

        NoProfile                 = ...  # 0x0
        CoreProfile               = ...  # 0x1
        CompatibilityProfile      = ...  # 0x2

    class RenderableType(enum.Enum):

        DefaultRenderableType     = ...  # 0x0
        OpenGL                    = ...  # 0x1
        OpenGLES                  = ...  # 0x2
        OpenVG                    = ...  # 0x4

    class SwapBehavior(enum.Enum):

        DefaultSwapBehavior       = ...  # 0x0
        SingleBuffer              = ...  # 0x1
        DoubleBuffer              = ...  # 0x2
        TripleBuffer              = ...  # 0x3


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QSurfaceFormat) -> None: ...
    @typing.overload
    def __init__(self, options: PySide6.QtGui.QSurfaceFormat.FormatOption) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def alphaBufferSize(self) -> int: ...
    def blueBufferSize(self) -> int: ...
    def colorSpace(self) -> PySide6.QtGui.QColorSpace: ...
    @staticmethod
    def defaultFormat() -> PySide6.QtGui.QSurfaceFormat: ...
    def depthBufferSize(self) -> int: ...
    def greenBufferSize(self) -> int: ...
    def hasAlpha(self) -> bool: ...
    def majorVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    def options(self) -> PySide6.QtGui.QSurfaceFormat.FormatOption: ...
    def profile(self) -> PySide6.QtGui.QSurfaceFormat.OpenGLContextProfile: ...
    def redBufferSize(self) -> int: ...
    def renderableType(self) -> PySide6.QtGui.QSurfaceFormat.RenderableType: ...
    def samples(self) -> int: ...
    def setAlphaBufferSize(self, size: int) -> None: ...
    def setBlueBufferSize(self, size: int) -> None: ...
    @typing.overload
    def setColorSpace(self, colorSpace: PySide6.QtGui.QColorSpace | PySide6.QtGui.QColorSpace.NamedColorSpace) -> None: ...
    @typing.overload
    def setColorSpace(self, colorSpace: PySide6.QtGui.QSurfaceFormat.ColorSpace) -> None: ...
    @staticmethod
    def setDefaultFormat(format: PySide6.QtGui.QSurfaceFormat | PySide6.QtGui.QSurfaceFormat.FormatOption) -> None: ...
    def setDepthBufferSize(self, size: int) -> None: ...
    def setGreenBufferSize(self, size: int) -> None: ...
    def setMajorVersion(self, majorVersion: int) -> None: ...
    def setMinorVersion(self, minorVersion: int) -> None: ...
    def setOption(self, option: PySide6.QtGui.QSurfaceFormat.FormatOption, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtGui.QSurfaceFormat.FormatOption) -> None: ...
    def setProfile(self, profile: PySide6.QtGui.QSurfaceFormat.OpenGLContextProfile) -> None: ...
    def setRedBufferSize(self, size: int) -> None: ...
    def setRenderableType(self, type: PySide6.QtGui.QSurfaceFormat.RenderableType) -> None: ...
    def setSamples(self, numSamples: int) -> None: ...
    def setStencilBufferSize(self, size: int) -> None: ...
    def setStereo(self, enable: bool) -> None: ...
    def setSwapBehavior(self, behavior: PySide6.QtGui.QSurfaceFormat.SwapBehavior) -> None: ...
    def setSwapInterval(self, interval: int) -> None: ...
    def setVersion(self, major: int, minor: int) -> None: ...
    def stencilBufferSize(self) -> int: ...
    def stereo(self) -> bool: ...
    def swapBehavior(self) -> PySide6.QtGui.QSurfaceFormat.SwapBehavior: ...
    def swapInterval(self) -> int: ...
    def testOption(self, option: PySide6.QtGui.QSurfaceFormat.FormatOption) -> bool: ...
    def version(self) -> typing.Tuple[int, int]: ...


class QSyntaxHighlighter(PySide6.QtCore.QObject):

    @typing.overload
    def __init__(self, parent: PySide6.QtGui.QTextDocument) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject) -> None: ...

    def currentBlock(self) -> PySide6.QtGui.QTextBlock: ...
    def currentBlockState(self) -> int: ...
    def currentBlockUserData(self) -> PySide6.QtGui.QTextBlockUserData: ...
    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def format(self, pos: int) -> PySide6.QtGui.QTextCharFormat: ...
    def highlightBlock(self, text: str) -> None: ...
    def previousBlockState(self) -> int: ...
    def rehighlight(self) -> None: ...
    def rehighlightBlock(self, block: PySide6.QtGui.QTextBlock) -> None: ...
    def setCurrentBlockState(self, newState: int) -> None: ...
    def setCurrentBlockUserData(self, data: PySide6.QtGui.QTextBlockUserData) -> None: ...
    def setDocument(self, doc: PySide6.QtGui.QTextDocument | None) -> None: ...
    @typing.overload
    def setFormat(self, start: int, count: int, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    @typing.overload
    def setFormat(self, start: int, count: int, font: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> None: ...
    @typing.overload
    def setFormat(self, start: int, count: int, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...


class QTabletEvent(PySide6.QtGui.QSinglePointEvent):

    @typing.overload
    def __init__(self, t: PySide6.QtCore.QEvent.Type, device: PySide6.QtGui.QPointingDevice, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, globalPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, pressure: float, xTilt: float, yTilt: float, tangentialPressure: float, rotation: float, z: float, keyState: PySide6.QtCore.Qt.KeyboardModifier, button: PySide6.QtCore.Qt.MouseButton, buttons: PySide6.QtCore.Qt.MouseButton) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QTabletEvent) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def clone(self) -> PySide6.QtGui.QTabletEvent: ...
    def globalPos(self) -> PySide6.QtCore.QPoint: ...
    def globalPosF(self) -> PySide6.QtCore.QPointF: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def hiResGlobalX(self) -> float: ...
    def hiResGlobalY(self) -> float: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def posF(self) -> PySide6.QtCore.QPointF: ...
    def pressure(self) -> float: ...
    def rotation(self) -> float: ...
    def tangentialPressure(self) -> float: ...
    def uniqueId(self) -> int: ...
    def x(self) -> int: ...
    def xTilt(self) -> float: ...
    def y(self) -> int: ...
    def yTilt(self) -> float: ...
    def z(self) -> float: ...


class QTextBlock(Shiboken.Object):

    class iterator(Shiboken.Object):

        def __init__(self) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def __iadd__(self, arg__1: int) -> PySide6.QtGui.QTextBlock.iterator: ...
        def __isub__(self, arg__1: int) -> PySide6.QtGui.QTextBlock.iterator: ...
        def __iter__(self) -> object: ...
        def __next__(self) -> object: ...
        def atEnd(self) -> bool: ...
        def fragment(self) -> PySide6.QtGui.QTextFragment: ...


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o: PySide6.QtGui.QTextBlock) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __iter__(self) -> object: ...
    def begin(self) -> PySide6.QtGui.QTextBlock.iterator: ...
    def blockFormat(self) -> PySide6.QtGui.QTextBlockFormat: ...
    def blockFormatIndex(self) -> int: ...
    def blockNumber(self) -> int: ...
    def charFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def charFormatIndex(self) -> int: ...
    def clearLayout(self) -> None: ...
    def contains(self, position: int) -> bool: ...
    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def end(self) -> PySide6.QtGui.QTextBlock.iterator: ...
    def firstLineNumber(self) -> int: ...
    def fragmentIndex(self) -> int: ...
    def isValid(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def layout(self) -> PySide6.QtGui.QTextLayout: ...
    def length(self) -> int: ...
    def lineCount(self) -> int: ...
    def next(self) -> PySide6.QtGui.QTextBlock: ...
    def position(self) -> int: ...
    def previous(self) -> PySide6.QtGui.QTextBlock: ...
    def revision(self) -> int: ...
    def setLineCount(self, count: int) -> None: ...
    def setRevision(self, rev: int) -> None: ...
    def setUserData(self, data: PySide6.QtGui.QTextBlockUserData) -> None: ...
    def setUserState(self, state: int) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def text(self) -> str: ...
    def textDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def textFormats(self) -> typing.List[PySide6.QtGui.QTextLayout.FormatRange]: ...
    def textList(self) -> PySide6.QtGui.QTextList: ...
    def userData(self) -> PySide6.QtGui.QTextBlockUserData: ...
    def userState(self) -> int: ...


class iterator(Shiboken.Object):

    def __init__(self) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, arg__1: int) -> PySide6.QtGui.QTextBlock.iterator: ...
    def __isub__(self, arg__1: int) -> PySide6.QtGui.QTextBlock.iterator: ...
    def __iter__(self) -> object: ...
    def __next__(self) -> object: ...
    def atEnd(self) -> bool: ...
    def fragment(self) -> PySide6.QtGui.QTextFragment: ...


class QTextBlockFormat(PySide6.QtGui.QTextFormat):

    class LineHeightTypes(enum.Enum):

        SingleHeight              = ...  # 0x0
        ProportionalHeight        = ...  # 0x1
        FixedHeight               = ...  # 0x2
        MinimumHeight             = ...  # 0x3
        LineDistanceHeight        = ...  # 0x4

    class MarkerType(enum.Enum):

        NoMarker                  = ...  # 0x0
        Unchecked                 = ...  # 0x1
        Checked                   = ...  # 0x2


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextBlockFormat: PySide6.QtGui.QTextBlockFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def bottomMargin(self) -> float: ...
    def headingLevel(self) -> int: ...
    def indent(self) -> int: ...
    def isValid(self) -> bool: ...
    def leftMargin(self) -> float: ...
    @typing.overload
    def lineHeight(self, scriptLineHeight: float, scaling: float) -> float: ...
    @typing.overload
    def lineHeight(self) -> float: ...
    def lineHeightType(self) -> int: ...
    def marker(self) -> PySide6.QtGui.QTextBlockFormat.MarkerType: ...
    def nonBreakableLines(self) -> bool: ...
    def pageBreakPolicy(self) -> PySide6.QtGui.QTextFormat.PageBreakFlag: ...
    def rightMargin(self) -> float: ...
    def setAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setBottomMargin(self, margin: float) -> None: ...
    def setHeadingLevel(self, alevel: int) -> None: ...
    def setIndent(self, indent: int) -> None: ...
    def setLeftMargin(self, margin: float) -> None: ...
    def setLineHeight(self, height: float, heightType: int) -> None: ...
    def setMarker(self, marker: PySide6.QtGui.QTextBlockFormat.MarkerType) -> None: ...
    def setNonBreakableLines(self, b: bool) -> None: ...
    def setPageBreakPolicy(self, flags: PySide6.QtGui.QTextFormat.PageBreakFlag) -> None: ...
    def setRightMargin(self, margin: float) -> None: ...
    def setTabPositions(self, tabs: typing.Sequence[PySide6.QtGui.QTextOption.Tab]) -> None: ...
    def setTextIndent(self, aindent: float) -> None: ...
    def setTopMargin(self, margin: float) -> None: ...
    def tabPositions(self) -> typing.List[PySide6.QtGui.QTextOption.Tab]: ...
    def textIndent(self) -> float: ...
    def topMargin(self) -> float: ...


class QTextBlockGroup(PySide6.QtGui.QTextObject):

    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None: ...

    def blockFormatChanged(self, block: PySide6.QtGui.QTextBlock) -> None: ...
    def blockInserted(self, block: PySide6.QtGui.QTextBlock) -> None: ...
    def blockList(self) -> typing.List[PySide6.QtGui.QTextBlock]: ...
    def blockRemoved(self, block: PySide6.QtGui.QTextBlock) -> None: ...


class QTextBlockUserData(Shiboken.Object):

    def __init__(self) -> None: ...


class QTextCharFormat(PySide6.QtGui.QTextFormat):

    class FontPropertiesInheritanceBehavior(enum.Enum):

        FontPropertiesSpecifiedOnly = ...  # 0x0
        FontPropertiesAll         = ...  # 0x1

    class UnderlineStyle(enum.Enum):

        NoUnderline               = ...  # 0x0
        SingleUnderline           = ...  # 0x1
        DashUnderline             = ...  # 0x2
        DotLine                   = ...  # 0x3
        DashDotLine               = ...  # 0x4
        DashDotDotLine            = ...  # 0x5
        WaveUnderline             = ...  # 0x6
        SpellCheckUnderline       = ...  # 0x7

    class VerticalAlignment(enum.Enum):

        AlignNormal               = ...  # 0x0
        AlignSuperScript          = ...  # 0x1
        AlignSubScript            = ...  # 0x2
        AlignMiddle               = ...  # 0x3
        AlignTop                  = ...  # 0x4
        AlignBottom               = ...  # 0x5
        AlignBaseline             = ...  # 0x6


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None: ...
    @typing.overload
    def __init__(self, QTextCharFormat: PySide6.QtGui.QTextCharFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def anchorHref(self) -> str: ...
    def anchorNames(self) -> typing.List[str]: ...
    def baselineOffset(self) -> float: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def fontCapitalization(self) -> PySide6.QtGui.QFont.Capitalization: ...
    def fontFamilies(self) -> typing.Any: ...
    def fontFamily(self) -> str: ...
    def fontFixedPitch(self) -> bool: ...
    def fontHintingPreference(self) -> PySide6.QtGui.QFont.HintingPreference: ...
    def fontItalic(self) -> bool: ...
    def fontKerning(self) -> bool: ...
    def fontLetterSpacing(self) -> float: ...
    def fontLetterSpacingType(self) -> PySide6.QtGui.QFont.SpacingType: ...
    def fontOverline(self) -> bool: ...
    def fontPointSize(self) -> float: ...
    def fontStretch(self) -> int: ...
    def fontStrikeOut(self) -> bool: ...
    def fontStyleHint(self) -> PySide6.QtGui.QFont.StyleHint: ...
    def fontStyleName(self) -> typing.Any: ...
    def fontStyleStrategy(self) -> PySide6.QtGui.QFont.StyleStrategy: ...
    def fontUnderline(self) -> bool: ...
    def fontWeight(self) -> int: ...
    def fontWordSpacing(self) -> float: ...
    def isAnchor(self) -> bool: ...
    def isValid(self) -> bool: ...
    def setAnchor(self, anchor: bool) -> None: ...
    def setAnchorHref(self, value: str) -> None: ...
    def setAnchorNames(self, names: typing.Sequence[str]) -> None: ...
    def setBaselineOffset(self, baseline: float) -> None: ...
    def setFont(self, font: PySide6.QtGui.QFont | str | typing.Sequence[str], behavior: PySide6.QtGui.QTextCharFormat.FontPropertiesInheritanceBehavior = ...) -> None: ...
    def setFontCapitalization(self, capitalization: PySide6.QtGui.QFont.Capitalization) -> None: ...
    def setFontFamilies(self, families: typing.Sequence[str]) -> None: ...
    def setFontFamily(self, family: str) -> None: ...
    def setFontFixedPitch(self, fixedPitch: bool) -> None: ...
    def setFontHintingPreference(self, hintingPreference: PySide6.QtGui.QFont.HintingPreference) -> None: ...
    def setFontItalic(self, italic: bool) -> None: ...
    def setFontKerning(self, enable: bool) -> None: ...
    def setFontLetterSpacing(self, spacing: float) -> None: ...
    def setFontLetterSpacingType(self, letterSpacingType: PySide6.QtGui.QFont.SpacingType) -> None: ...
    def setFontOverline(self, overline: bool) -> None: ...
    def setFontPointSize(self, size: float) -> None: ...
    def setFontStretch(self, factor: int) -> None: ...
    def setFontStrikeOut(self, strikeOut: bool) -> None: ...
    def setFontStyleHint(self, hint: PySide6.QtGui.QFont.StyleHint, strategy: PySide6.QtGui.QFont.StyleStrategy = ...) -> None: ...
    def setFontStyleName(self, styleName: str) -> None: ...
    def setFontStyleStrategy(self, strategy: PySide6.QtGui.QFont.StyleStrategy) -> None: ...
    def setFontUnderline(self, underline: bool) -> None: ...
    def setFontWeight(self, weight: int) -> None: ...
    def setFontWordSpacing(self, spacing: float) -> None: ...
    def setSubScriptBaseline(self, baseline: float) -> None: ...
    def setSuperScriptBaseline(self, baseline: float) -> None: ...
    def setTableCellColumnSpan(self, tableCellColumnSpan: int) -> None: ...
    def setTableCellRowSpan(self, tableCellRowSpan: int) -> None: ...
    def setTextOutline(self, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor) -> None: ...
    def setToolTip(self, tip: str) -> None: ...
    def setUnderlineColor(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int) -> None: ...
    def setUnderlineStyle(self, style: PySide6.QtGui.QTextCharFormat.UnderlineStyle) -> None: ...
    def setVerticalAlignment(self, alignment: PySide6.QtGui.QTextCharFormat.VerticalAlignment) -> None: ...
    def subScriptBaseline(self) -> float: ...
    def superScriptBaseline(self) -> float: ...
    def tableCellColumnSpan(self) -> int: ...
    def tableCellRowSpan(self) -> int: ...
    def textOutline(self) -> PySide6.QtGui.QPen: ...
    def toolTip(self) -> str: ...
    def underlineColor(self) -> PySide6.QtGui.QColor: ...
    def underlineStyle(self) -> PySide6.QtGui.QTextCharFormat.UnderlineStyle: ...
    def verticalAlignment(self) -> PySide6.QtGui.QTextCharFormat.VerticalAlignment: ...


class QTextCursor(Shiboken.Object):

    class MoveMode(enum.Enum):

        MoveAnchor                = ...  # 0x0
        KeepAnchor                = ...  # 0x1

    class MoveOperation(enum.Enum):

        NoMove                    = ...  # 0x0
        Start                     = ...  # 0x1
        Up                        = ...  # 0x2
        StartOfLine               = ...  # 0x3
        StartOfBlock              = ...  # 0x4
        StartOfWord               = ...  # 0x5
        PreviousBlock             = ...  # 0x6
        PreviousCharacter         = ...  # 0x7
        PreviousWord              = ...  # 0x8
        Left                      = ...  # 0x9
        WordLeft                  = ...  # 0xa
        End                       = ...  # 0xb
        Down                      = ...  # 0xc
        EndOfLine                 = ...  # 0xd
        EndOfWord                 = ...  # 0xe
        EndOfBlock                = ...  # 0xf
        NextBlock                 = ...  # 0x10
        NextCharacter             = ...  # 0x11
        NextWord                  = ...  # 0x12
        Right                     = ...  # 0x13
        WordRight                 = ...  # 0x14
        NextCell                  = ...  # 0x15
        PreviousCell              = ...  # 0x16
        NextRow                   = ...  # 0x17
        PreviousRow               = ...  # 0x18

    class SelectionType(enum.Enum):

        WordUnderCursor           = ...  # 0x0
        LineUnderCursor           = ...  # 0x1
        BlockUnderCursor          = ...  # 0x2
        Document                  = ...  # 0x3


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, block: PySide6.QtGui.QTextBlock) -> None: ...
    @typing.overload
    def __init__(self, document: PySide6.QtGui.QTextDocument) -> None: ...
    @typing.overload
    def __init__(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    @typing.overload
    def __init__(self, frame: PySide6.QtGui.QTextFrame) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def anchor(self) -> int: ...
    def atBlockEnd(self) -> bool: ...
    def atBlockStart(self) -> bool: ...
    def atEnd(self) -> bool: ...
    def atStart(self) -> bool: ...
    def beginEditBlock(self) -> None: ...
    def block(self) -> PySide6.QtGui.QTextBlock: ...
    def blockCharFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def blockFormat(self) -> PySide6.QtGui.QTextBlockFormat: ...
    def blockNumber(self) -> int: ...
    def charFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def clearSelection(self) -> None: ...
    def columnNumber(self) -> int: ...
    @typing.overload
    def createList(self, format: PySide6.QtGui.QTextListFormat) -> PySide6.QtGui.QTextList: ...
    @typing.overload
    def createList(self, style: PySide6.QtGui.QTextListFormat.Style) -> PySide6.QtGui.QTextList: ...
    def currentFrame(self) -> PySide6.QtGui.QTextFrame: ...
    def currentList(self) -> PySide6.QtGui.QTextList: ...
    def currentTable(self) -> PySide6.QtGui.QTextTable: ...
    def deleteChar(self) -> None: ...
    def deletePreviousChar(self) -> None: ...
    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def endEditBlock(self) -> None: ...
    def hasComplexSelection(self) -> bool: ...
    def hasSelection(self) -> bool: ...
    @typing.overload
    def insertBlock(self) -> None: ...
    @typing.overload
    def insertBlock(self, format: PySide6.QtGui.QTextBlockFormat, charFormat: PySide6.QtGui.QTextCharFormat) -> None: ...
    @typing.overload
    def insertBlock(self, format: PySide6.QtGui.QTextBlockFormat) -> None: ...
    def insertFragment(self, fragment: PySide6.QtGui.QTextDocumentFragment) -> None: ...
    def insertFrame(self, format: PySide6.QtGui.QTextFrameFormat) -> PySide6.QtGui.QTextFrame: ...
    def insertHtml(self, html: str) -> None: ...
    @typing.overload
    def insertImage(self, format: PySide6.QtGui.QTextImageFormat) -> None: ...
    @typing.overload
    def insertImage(self, name: str) -> None: ...
    @typing.overload
    def insertImage(self, format: PySide6.QtGui.QTextImageFormat, alignment: PySide6.QtGui.QTextFrameFormat.Position) -> None: ...
    @typing.overload
    def insertImage(self, image: PySide6.QtGui.QImage, name: str = ...) -> None: ...
    @typing.overload
    def insertList(self, format: PySide6.QtGui.QTextListFormat) -> PySide6.QtGui.QTextList: ...
    @typing.overload
    def insertList(self, style: PySide6.QtGui.QTextListFormat.Style) -> PySide6.QtGui.QTextList: ...
    def insertMarkdown(self, markdown: str, features: PySide6.QtGui.QTextDocument.MarkdownFeature = ...) -> None: ...
    @typing.overload
    def insertTable(self, rows: int, cols: int, format: PySide6.QtGui.QTextTableFormat) -> PySide6.QtGui.QTextTable: ...
    @typing.overload
    def insertTable(self, rows: int, cols: int) -> PySide6.QtGui.QTextTable: ...
    @typing.overload
    def insertText(self, text: str, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    @typing.overload
    def insertText(self, text: str) -> None: ...
    def isCopyOf(self, other: PySide6.QtGui.QTextCursor) -> bool: ...
    def isNull(self) -> bool: ...
    def joinPreviousEditBlock(self) -> None: ...
    def keepPositionOnInsert(self) -> bool: ...
    def mergeBlockCharFormat(self, modifier: PySide6.QtGui.QTextCharFormat) -> None: ...
    def mergeBlockFormat(self, modifier: PySide6.QtGui.QTextBlockFormat) -> None: ...
    def mergeCharFormat(self, modifier: PySide6.QtGui.QTextCharFormat) -> None: ...
    def movePosition(self, op: PySide6.QtGui.QTextCursor.MoveOperation, arg__2: PySide6.QtGui.QTextCursor.MoveMode = ..., n: int = ...) -> bool: ...
    def position(self) -> int: ...
    def positionInBlock(self) -> int: ...
    def removeSelectedText(self) -> None: ...
    def select(self, selection: PySide6.QtGui.QTextCursor.SelectionType) -> None: ...
    def selectedTableCells(self) -> object: ...
    def selectedText(self) -> str: ...
    def selection(self) -> PySide6.QtGui.QTextDocumentFragment: ...
    def selectionEnd(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setBlockCharFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    def setBlockFormat(self, format: PySide6.QtGui.QTextBlockFormat) -> None: ...
    def setCharFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    def setKeepPositionOnInsert(self, b: bool) -> None: ...
    def setPosition(self, pos: int, mode: PySide6.QtGui.QTextCursor.MoveMode = ...) -> None: ...
    def setVerticalMovementX(self, x: int) -> None: ...
    def setVisualNavigation(self, b: bool) -> None: ...
    def swap(self, other: PySide6.QtGui.QTextCursor) -> None: ...
    def verticalMovementX(self) -> int: ...
    def visualNavigation(self) -> bool: ...


class QTextDocument(PySide6.QtCore.QObject):

    baseUrlChanged           : typing.ClassVar[Signal] = ... # baseUrlChanged(QUrl)
    blockCountChanged        : typing.ClassVar[Signal] = ... # blockCountChanged(int)
    contentsChange           : typing.ClassVar[Signal] = ... # contentsChange(int,int,int)
    contentsChanged          : typing.ClassVar[Signal] = ... # contentsChanged()
    cursorPositionChanged    : typing.ClassVar[Signal] = ... # cursorPositionChanged(QTextCursor)
    documentLayoutChanged    : typing.ClassVar[Signal] = ... # documentLayoutChanged()
    modificationChanged      : typing.ClassVar[Signal] = ... # modificationChanged(bool)
    redoAvailable            : typing.ClassVar[Signal] = ... # redoAvailable(bool)
    undoAvailable            : typing.ClassVar[Signal] = ... # undoAvailable(bool)
    undoCommandAdded         : typing.ClassVar[Signal] = ... # undoCommandAdded()

    class FindFlag(enum.Flag):

        FindBackward              = ...  # 0x1
        FindCaseSensitively       = ...  # 0x2
        FindWholeWords            = ...  # 0x4

    class MarkdownFeature(enum.Flag):

        MarkdownDialectCommonMark = ...  # 0x0
        MarkdownNoHTML            = ...  # 0x60
        MarkdownDialectGitHub     = ...  # 0x104f0c

    class MetaInformation(enum.Enum):

        DocumentTitle             = ...  # 0x0
        DocumentUrl               = ...  # 0x1
        CssMedia                  = ...  # 0x2
        FrontMatter               = ...  # 0x3

    class ResourceType(enum.IntEnum):

        UnknownResource           = ...  # 0x0
        HtmlResource              = ...  # 0x1
        ImageResource             = ...  # 0x2
        StyleSheetResource        = ...  # 0x3
        MarkdownResource          = ...  # 0x4
        UserResource              = ...  # 0x64

    class Stacks(enum.Enum):

        UndoStack                 = ...  # 0x1
        RedoStack                 = ...  # 0x2
        UndoAndRedoStacks         = ...  # 0x3


    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    def addResource(self, type: int, name: PySide6.QtCore.QUrl | str, resource: typing.Any) -> None: ...
    def adjustSize(self) -> None: ...
    def allFormats(self) -> typing.List[PySide6.QtGui.QTextFormat]: ...
    def availableRedoSteps(self) -> int: ...
    def availableUndoSteps(self) -> int: ...
    def baseUrl(self) -> PySide6.QtCore.QUrl: ...
    def baselineOffset(self) -> float: ...
    def begin(self) -> PySide6.QtGui.QTextBlock: ...
    def blockCount(self) -> int: ...
    def characterAt(self, pos: int) -> str: ...
    def characterCount(self) -> int: ...
    def clear(self) -> None: ...
    def clearUndoRedoStacks(self, historyToClear: PySide6.QtGui.QTextDocument.Stacks = ...) -> None: ...
    def clone(self, parent: PySide6.QtCore.QObject | None= ...) -> PySide6.QtGui.QTextDocument: ...
    def createObject(self, f: PySide6.QtGui.QTextFormat) -> PySide6.QtGui.QTextObject: ...
    def defaultCursorMoveStyle(self) -> PySide6.QtCore.Qt.CursorMoveStyle: ...
    def defaultFont(self) -> PySide6.QtGui.QFont: ...
    def defaultStyleSheet(self) -> str: ...
    def defaultTextOption(self) -> PySide6.QtGui.QTextOption: ...
    def documentLayout(self) -> PySide6.QtGui.QAbstractTextDocumentLayout: ...
    def documentMargin(self) -> float: ...
    def drawContents(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect= ...) -> None: ...
    def end(self) -> PySide6.QtGui.QTextBlock: ...
    @typing.overload
    def find(self, expr: PySide6.QtCore.QRegularExpression | str, cursor: PySide6.QtGui.QTextCursor, options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> PySide6.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, expr: PySide6.QtCore.QRegularExpression | str, from_: int = ..., options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> PySide6.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, subString: str, from_: int = ..., options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> PySide6.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, subString: str, cursor: PySide6.QtGui.QTextCursor, options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> PySide6.QtGui.QTextCursor: ...
    def findBlock(self, pos: int) -> PySide6.QtGui.QTextBlock: ...
    def findBlockByLineNumber(self, blockNumber: int) -> PySide6.QtGui.QTextBlock: ...
    def findBlockByNumber(self, blockNumber: int) -> PySide6.QtGui.QTextBlock: ...
    def firstBlock(self) -> PySide6.QtGui.QTextBlock: ...
    def frameAt(self, pos: int) -> PySide6.QtGui.QTextFrame: ...
    def idealWidth(self) -> float: ...
    def indentWidth(self) -> float: ...
    def isEmpty(self) -> bool: ...
    def isLayoutEnabled(self) -> bool: ...
    def isModified(self) -> bool: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def lastBlock(self) -> PySide6.QtGui.QTextBlock: ...
    def lineCount(self) -> int: ...
    def loadResource(self, type: int, name: PySide6.QtCore.QUrl | str) -> typing.Any: ...
    def markContentsDirty(self, from_: int, length: int) -> None: ...
    def maximumBlockCount(self) -> int: ...
    def metaInformation(self, info: PySide6.QtGui.QTextDocument.MetaInformation) -> str: ...
    def object(self, objectIndex: int) -> PySide6.QtGui.QTextObject: ...
    def objectForFormat(self, arg__1: PySide6.QtGui.QTextFormat) -> PySide6.QtGui.QTextObject: ...
    def pageCount(self) -> int: ...
    def pageSize(self) -> PySide6.QtCore.QSizeF: ...
    def print_(self, printer: PySide6.QtGui.QPagedPaintDevice) -> None: ...
    @typing.overload
    def redo(self) -> None: ...
    @typing.overload
    def redo(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    def resource(self, type: int, name: PySide6.QtCore.QUrl | str) -> typing.Any: ...
    def revision(self) -> int: ...
    def rootFrame(self) -> PySide6.QtGui.QTextFrame: ...
    def setBaseUrl(self, url: PySide6.QtCore.QUrl | str) -> None: ...
    def setBaselineOffset(self, baseline: float) -> None: ...
    def setDefaultCursorMoveStyle(self, style: PySide6.QtCore.Qt.CursorMoveStyle) -> None: ...
    def setDefaultFont(self, font: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> None: ...
    def setDefaultStyleSheet(self, sheet: str) -> None: ...
    def setDefaultTextOption(self, option: PySide6.QtGui.QTextOption | PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setDocumentLayout(self, layout: PySide6.QtGui.QAbstractTextDocumentLayout) -> None: ...
    def setDocumentMargin(self, margin: float) -> None: ...
    def setHtml(self, html: str) -> None: ...
    def setIndentWidth(self, width: float) -> None: ...
    def setLayoutEnabled(self, b: bool) -> None: ...
    def setMarkdown(self, markdown: str, features: PySide6.QtGui.QTextDocument.MarkdownFeature = ...) -> None: ...
    def setMaximumBlockCount(self, maximum: int) -> None: ...
    def setMetaInformation(self, info: PySide6.QtGui.QTextDocument.MetaInformation, arg__2: str) -> None: ...
    def setModified(self, m: bool = ...) -> None: ...
    def setPageSize(self, size: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setSubScriptBaseline(self, baseline: float) -> None: ...
    def setSuperScriptBaseline(self, baseline: float) -> None: ...
    def setTextWidth(self, width: float) -> None: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def setUseDesignMetrics(self, b: bool) -> None: ...
    def size(self) -> PySide6.QtCore.QSizeF: ...
    def subScriptBaseline(self) -> float: ...
    def superScriptBaseline(self) -> float: ...
    def textWidth(self) -> float: ...
    def toHtml(self) -> str: ...
    def toMarkdown(self, features: PySide6.QtGui.QTextDocument.MarkdownFeature = ...) -> str: ...
    def toPlainText(self) -> str: ...
    def toRawText(self) -> str: ...
    @typing.overload
    def undo(self) -> None: ...
    @typing.overload
    def undo(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    def useDesignMetrics(self) -> bool: ...


class QTextDocumentFragment(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, document: PySide6.QtGui.QTextDocument) -> None: ...
    @typing.overload
    def __init__(self, range: PySide6.QtGui.QTextCursor) -> None: ...
    @typing.overload
    def __init__(self, rhs: PySide6.QtGui.QTextDocumentFragment) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def fromHtml(html: str, resourceProvider: PySide6.QtGui.QTextDocument | None= ...) -> PySide6.QtGui.QTextDocumentFragment: ...
    @staticmethod
    def fromMarkdown(markdown: str, features: PySide6.QtGui.QTextDocument.MarkdownFeature = ...) -> PySide6.QtGui.QTextDocumentFragment: ...
    @staticmethod
    def fromPlainText(plainText: str) -> PySide6.QtGui.QTextDocumentFragment: ...
    def isEmpty(self) -> bool: ...
    def toHtml(self) -> str: ...
    def toMarkdown(self, features: PySide6.QtGui.QTextDocument.MarkdownFeature = ...) -> str: ...
    def toPlainText(self) -> str: ...
    def toRawText(self) -> str: ...


class QTextDocumentWriter(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ...) -> None: ...
    @typing.overload
    def __init__(self, device: PySide6.QtCore.QIODevice, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...

    def device(self) -> PySide6.QtCore.QIODevice: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide6.QtCore.QByteArray: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setFormat(self, format: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview) -> None: ...
    @staticmethod
    def supportedDocumentFormats() -> typing.List[PySide6.QtCore.QByteArray]: ...
    @typing.overload
    def write(self, fragment: PySide6.QtGui.QTextDocumentFragment) -> bool: ...
    @typing.overload
    def write(self, document: PySide6.QtGui.QTextDocument) -> bool: ...


class QTextFormat(Shiboken.Object):

    class FormatType(enum.IntEnum):

        InvalidFormat             = ...  # -1
        BlockFormat               = ...  # 0x1
        CharFormat                = ...  # 0x2
        ListFormat                = ...  # 0x3
        FrameFormat               = ...  # 0x5
        UserFormat                = ...  # 0x64

    class ObjectTypes(enum.IntEnum):

        NoObject                  = ...  # 0x0
        ImageObject               = ...  # 0x1
        TableObject               = ...  # 0x2
        TableCellObject           = ...  # 0x3
        UserObject                = ...  # 0x1000

    class PageBreakFlag(enum.Flag):

        PageBreak_Auto            = ...  # 0x0
        PageBreak_AlwaysBefore    = ...  # 0x1
        PageBreak_AlwaysAfter     = ...  # 0x10

    class Property(enum.IntEnum):

        ObjectIndex               = ...  # 0x0
        CssFloat                  = ...  # 0x800
        LayoutDirection           = ...  # 0x801
        OutlinePen                = ...  # 0x810
        BackgroundBrush           = ...  # 0x820
        ForegroundBrush           = ...  # 0x821
        BackgroundImageUrl        = ...  # 0x823
        BlockAlignment            = ...  # 0x1010
        BlockTopMargin            = ...  # 0x1030
        BlockBottomMargin         = ...  # 0x1031
        BlockLeftMargin           = ...  # 0x1032
        BlockRightMargin          = ...  # 0x1033
        TextIndent                = ...  # 0x1034
        TabPositions              = ...  # 0x1035
        BlockIndent               = ...  # 0x1040
        LineHeight                = ...  # 0x1048
        LineHeightType            = ...  # 0x1049
        BlockNonBreakableLines    = ...  # 0x1050
        BlockTrailingHorizontalRulerWidth = ...  # 0x1060
        HeadingLevel              = ...  # 0x1070
        BlockQuoteLevel           = ...  # 0x1080
        BlockCodeLanguage         = ...  # 0x1090
        BlockCodeFence            = ...  # 0x1091
        BlockMarker               = ...  # 0x10a0
        FirstFontProperty         = ...  # 0x1fe0
        FontCapitalization        = ...  # 0x1fe0
        FontLetterSpacing         = ...  # 0x1fe1
        FontWordSpacing           = ...  # 0x1fe2
        FontStyleHint             = ...  # 0x1fe3
        FontStyleStrategy         = ...  # 0x1fe4
        FontKerning               = ...  # 0x1fe5
        FontHintingPreference     = ...  # 0x1fe6
        FontFamilies              = ...  # 0x1fe7
        FontStyleName             = ...  # 0x1fe8
        FontLetterSpacingType     = ...  # 0x1fe9
        FontStretch               = ...  # 0x1fea
        FontFamily                = ...  # 0x2000
        OldFontFamily             = ...  # 0x2000
        FontPointSize             = ...  # 0x2001
        FontSizeAdjustment        = ...  # 0x2002
        FontSizeIncrement         = ...  # 0x2002
        FontWeight                = ...  # 0x2003
        FontItalic                = ...  # 0x2004
        FontUnderline             = ...  # 0x2005
        FontOverline              = ...  # 0x2006
        FontStrikeOut             = ...  # 0x2007
        FontFixedPitch            = ...  # 0x2008
        FontPixelSize             = ...  # 0x2009
        LastFontProperty          = ...  # 0x2009
        OldTextUnderlineColor     = ...  # 0x2010
        TextUnderlineColor        = ...  # 0x2020
        TextVerticalAlignment     = ...  # 0x2021
        TextOutline               = ...  # 0x2022
        TextUnderlineStyle        = ...  # 0x2023
        TextToolTip               = ...  # 0x2024
        TextSuperScriptBaseline   = ...  # 0x2025
        TextSubScriptBaseline     = ...  # 0x2026
        TextBaselineOffset        = ...  # 0x2027
        IsAnchor                  = ...  # 0x2030
        AnchorHref                = ...  # 0x2031
        AnchorName                = ...  # 0x2032
        OldFontLetterSpacingType  = ...  # 0x2033
        OldFontStretch            = ...  # 0x2034
        ObjectType                = ...  # 0x2f00
        ListStyle                 = ...  # 0x3000
        ListIndent                = ...  # 0x3001
        ListNumberPrefix          = ...  # 0x3002
        ListNumberSuffix          = ...  # 0x3003
        ListStart                 = ...  # 0x3004
        FrameBorder               = ...  # 0x4000
        FrameMargin               = ...  # 0x4001
        FramePadding              = ...  # 0x4002
        FrameWidth                = ...  # 0x4003
        FrameHeight               = ...  # 0x4004
        FrameTopMargin            = ...  # 0x4005
        FrameBottomMargin         = ...  # 0x4006
        FrameLeftMargin           = ...  # 0x4007
        FrameRightMargin          = ...  # 0x4008
        FrameBorderBrush          = ...  # 0x4009
        FrameBorderStyle          = ...  # 0x4010
        TableColumns              = ...  # 0x4100
        TableColumnWidthConstraints = ...  # 0x4101
        TableCellSpacing          = ...  # 0x4102
        TableCellPadding          = ...  # 0x4103
        TableHeaderRowCount       = ...  # 0x4104
        TableBorderCollapse       = ...  # 0x4105
        TableCellRowSpan          = ...  # 0x4810
        TableCellColumnSpan       = ...  # 0x4811
        TableCellTopPadding       = ...  # 0x4812
        TableCellBottomPadding    = ...  # 0x4813
        TableCellLeftPadding      = ...  # 0x4814
        TableCellRightPadding     = ...  # 0x4815
        TableCellTopBorder        = ...  # 0x4816
        TableCellBottomBorder     = ...  # 0x4817
        TableCellLeftBorder       = ...  # 0x4818
        TableCellRightBorder      = ...  # 0x4819
        TableCellTopBorderStyle   = ...  # 0x481a
        TableCellBottomBorderStyle = ...  # 0x481b
        TableCellLeftBorderStyle  = ...  # 0x481c
        TableCellRightBorderStyle = ...  # 0x481d
        TableCellTopBorderBrush   = ...  # 0x481e
        TableCellBottomBorderBrush = ...  # 0x481f
        TableCellLeftBorderBrush  = ...  # 0x4820
        TableCellRightBorderBrush = ...  # 0x4821
        ImageName                 = ...  # 0x5000
        ImageTitle                = ...  # 0x5001
        ImageAltText              = ...  # 0x5002
        ImageWidth                = ...  # 0x5010
        ImageHeight               = ...  # 0x5011
        ImageQuality              = ...  # 0x5014
        ImageMaxWidth             = ...  # 0x5015
        FullWidthSelection        = ...  # 0x6000
        PageBreakPolicy           = ...  # 0x7000
        UserProperty              = ...  # 0x100000


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, type: int) -> None: ...
    @typing.overload
    def __init__(self, rhs: PySide6.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def background(self) -> PySide6.QtGui.QBrush: ...
    def boolProperty(self, propertyId: int) -> bool: ...
    def brushProperty(self, propertyId: int) -> PySide6.QtGui.QBrush: ...
    def clearBackground(self) -> None: ...
    def clearForeground(self) -> None: ...
    def clearProperty(self, propertyId: int) -> None: ...
    def colorProperty(self, propertyId: int) -> PySide6.QtGui.QColor: ...
    def doubleProperty(self, propertyId: int) -> float: ...
    def foreground(self) -> PySide6.QtGui.QBrush: ...
    def hasProperty(self, propertyId: int) -> bool: ...
    def intProperty(self, propertyId: int) -> int: ...
    def isBlockFormat(self) -> bool: ...
    def isCharFormat(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isFrameFormat(self) -> bool: ...
    def isImageFormat(self) -> bool: ...
    def isListFormat(self) -> bool: ...
    def isTableCellFormat(self) -> bool: ...
    def isTableFormat(self) -> bool: ...
    def isValid(self) -> bool: ...
    def layoutDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def lengthProperty(self, propertyId: int) -> PySide6.QtGui.QTextLength: ...
    def lengthVectorProperty(self, propertyId: int) -> typing.List[PySide6.QtGui.QTextLength]: ...
    def merge(self, other: PySide6.QtGui.QTextFormat) -> None: ...
    def objectIndex(self) -> int: ...
    def objectType(self) -> int: ...
    def penProperty(self, propertyId: int) -> PySide6.QtGui.QPen: ...
    def properties(self) -> typing.Dict[int, typing.Any]: ...
    def property(self, propertyId: int) -> typing.Any: ...
    def propertyCount(self) -> int: ...
    def setBackground(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setForeground(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setLayoutDirection(self, direction: PySide6.QtCore.Qt.LayoutDirection) -> None: ...
    def setObjectIndex(self, object: int) -> None: ...
    def setObjectType(self, type: int) -> None: ...
    @typing.overload
    def setProperty(self, propertyId: int, lengths: typing.Sequence[PySide6.QtGui.QTextLength]) -> None: ...
    @typing.overload
    def setProperty(self, propertyId: int, value: typing.Any) -> None: ...
    def stringProperty(self, propertyId: int) -> str: ...
    def swap(self, other: PySide6.QtGui.QTextFormat) -> None: ...
    def toBlockFormat(self) -> PySide6.QtGui.QTextBlockFormat: ...
    def toCharFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def toFrameFormat(self) -> PySide6.QtGui.QTextFrameFormat: ...
    def toImageFormat(self) -> PySide6.QtGui.QTextImageFormat: ...
    def toListFormat(self) -> PySide6.QtGui.QTextListFormat: ...
    def toTableCellFormat(self) -> PySide6.QtGui.QTextTableCellFormat: ...
    def toTableFormat(self) -> PySide6.QtGui.QTextTableFormat: ...
    def type(self) -> int: ...


class QTextFragment(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o: PySide6.QtGui.QTextFragment) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def charFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def charFormatIndex(self) -> int: ...
    def contains(self, position: int) -> bool: ...
    def glyphRuns(self, from_: int = ..., length: int = ...) -> typing.List[PySide6.QtGui.QGlyphRun]: ...
    def isValid(self) -> bool: ...
    def length(self) -> int: ...
    def position(self) -> int: ...
    def text(self) -> str: ...


class QTextFrame(PySide6.QtGui.QTextObject):

    class iterator(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, iterator: PySide6.QtGui.QTextFrame.iterator) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def __iadd__(self, arg__1: int) -> PySide6.QtGui.QTextFrame.iterator: ...
        def __isub__(self, arg__1: int) -> PySide6.QtGui.QTextFrame.iterator: ...
        def __iter__(self) -> object: ...
        def __next__(self) -> object: ...
        def atEnd(self) -> bool: ...
        def currentBlock(self) -> PySide6.QtGui.QTextBlock: ...
        def currentFrame(self) -> PySide6.QtGui.QTextFrame: ...
        def parentFrame(self) -> PySide6.QtGui.QTextFrame: ...


    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None: ...

    def __iter__(self) -> object: ...
    def begin(self) -> PySide6.QtGui.QTextFrame.iterator: ...
    def childFrames(self) -> typing.List[PySide6.QtGui.QTextFrame]: ...
    def end(self) -> PySide6.QtGui.QTextFrame.iterator: ...
    def firstCursorPosition(self) -> PySide6.QtGui.QTextCursor: ...
    def firstPosition(self) -> int: ...
    def frameFormat(self) -> PySide6.QtGui.QTextFrameFormat: ...
    def lastCursorPosition(self) -> PySide6.QtGui.QTextCursor: ...
    def lastPosition(self) -> int: ...
    def parentFrame(self) -> PySide6.QtGui.QTextFrame: ...
    def setFrameFormat(self, format: PySide6.QtGui.QTextFrameFormat) -> None: ...


class iterator(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, iterator: PySide6.QtGui.QTextFrame.iterator) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, arg__1: int) -> PySide6.QtGui.QTextFrame.iterator: ...
    def __isub__(self, arg__1: int) -> PySide6.QtGui.QTextFrame.iterator: ...
    def __iter__(self) -> object: ...
    def __next__(self) -> object: ...
    def atEnd(self) -> bool: ...
    def currentBlock(self) -> PySide6.QtGui.QTextBlock: ...
    def currentFrame(self) -> PySide6.QtGui.QTextFrame: ...
    def parentFrame(self) -> PySide6.QtGui.QTextFrame: ...


class QTextFrameFormat(PySide6.QtGui.QTextFormat):

    class BorderStyle(enum.Enum):

        BorderStyle_None          = ...  # 0x0
        BorderStyle_Dotted        = ...  # 0x1
        BorderStyle_Dashed        = ...  # 0x2
        BorderStyle_Solid         = ...  # 0x3
        BorderStyle_Double        = ...  # 0x4
        BorderStyle_DotDash       = ...  # 0x5
        BorderStyle_DotDotDash    = ...  # 0x6
        BorderStyle_Groove        = ...  # 0x7
        BorderStyle_Ridge         = ...  # 0x8
        BorderStyle_Inset         = ...  # 0x9
        BorderStyle_Outset        = ...  # 0xa

    class Position(enum.Enum):

        InFlow                    = ...  # 0x0
        FloatLeft                 = ...  # 0x1
        FloatRight                = ...  # 0x2


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None: ...
    @typing.overload
    def __init__(self, QTextFrameFormat: PySide6.QtGui.QTextFrameFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def border(self) -> float: ...
    def borderBrush(self) -> PySide6.QtGui.QBrush: ...
    def borderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle: ...
    def bottomMargin(self) -> float: ...
    def height(self) -> PySide6.QtGui.QTextLength: ...
    def isValid(self) -> bool: ...
    def leftMargin(self) -> float: ...
    def margin(self) -> float: ...
    def padding(self) -> float: ...
    def pageBreakPolicy(self) -> PySide6.QtGui.QTextFormat.PageBreakFlag: ...
    def position(self) -> PySide6.QtGui.QTextFrameFormat.Position: ...
    def rightMargin(self) -> float: ...
    def setBorder(self, border: float) -> None: ...
    def setBorderBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setBottomMargin(self, margin: float) -> None: ...
    @typing.overload
    def setHeight(self, height: PySide6.QtGui.QTextLength) -> None: ...
    @typing.overload
    def setHeight(self, height: float) -> None: ...
    def setLeftMargin(self, margin: float) -> None: ...
    def setMargin(self, margin: float) -> None: ...
    def setPadding(self, padding: float) -> None: ...
    def setPageBreakPolicy(self, flags: PySide6.QtGui.QTextFormat.PageBreakFlag) -> None: ...
    def setPosition(self, f: PySide6.QtGui.QTextFrameFormat.Position) -> None: ...
    def setRightMargin(self, margin: float) -> None: ...
    def setTopMargin(self, margin: float) -> None: ...
    @typing.overload
    def setWidth(self, length: PySide6.QtGui.QTextLength) -> None: ...
    @typing.overload
    def setWidth(self, width: float) -> None: ...
    def topMargin(self) -> float: ...
    def width(self) -> PySide6.QtGui.QTextLength: ...


class QTextImageFormat(PySide6.QtGui.QTextCharFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextImageFormat: PySide6.QtGui.QTextImageFormat) -> None: ...
    @typing.overload
    def __init__(self, format: PySide6.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def height(self) -> float: ...
    def isValid(self) -> bool: ...
    def maximumWidth(self) -> PySide6.QtGui.QTextLength: ...
    def name(self) -> str: ...
    def quality(self) -> int: ...
    def setHeight(self, height: float) -> None: ...
    def setMaximumWidth(self, maxWidth: PySide6.QtGui.QTextLength) -> None: ...
    def setName(self, name: str) -> None: ...
    @typing.overload
    def setQuality(self) -> None: ...
    @typing.overload
    def setQuality(self, quality: int) -> None: ...
    def setWidth(self, width: float) -> None: ...
    def width(self) -> float: ...


class QTextInlineObject(Shiboken.Object):

    def __init__(self) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def ascent(self) -> float: ...
    def descent(self) -> float: ...
    def format(self) -> PySide6.QtGui.QTextFormat: ...
    def formatIndex(self) -> int: ...
    def height(self) -> float: ...
    def isValid(self) -> bool: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    def setAscent(self, a: float) -> None: ...
    def setDescent(self, d: float) -> None: ...
    def setWidth(self, w: float) -> None: ...
    def textDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def textPosition(self) -> int: ...
    def width(self) -> float: ...


class QTextItem(Shiboken.Object):

    class RenderFlag(enum.Flag):

        RightToLeft               = ...  # 0x1
        Overline                  = ...  # 0x10
        Underline                 = ...  # 0x20
        StrikeOut                 = ...  # 0x40
        Dummy                     = ...  # 0xffffffff


    def __init__(self) -> None: ...

    def ascent(self) -> float: ...
    def descent(self) -> float: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def renderFlags(self) -> PySide6.QtGui.QTextItem.RenderFlag: ...
    def text(self) -> str: ...
    def width(self) -> float: ...


class QTextLayout(Shiboken.Object):

    class CursorMode(enum.Enum):

        SkipCharacters            = ...  # 0x0
        SkipWords                 = ...  # 0x1

    class FormatRange(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, FormatRange: PySide6.QtGui.QTextLayout.FormatRange) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class GlyphRunRetrievalFlag(enum.Flag):

        RetrieveGlyphIndexes      = ...  # 0x1
        RetrieveGlyphPositions    = ...  # 0x2
        DefaultRetrievalFlags     = ...  # 0x3
        RetrieveStringIndexes     = ...  # 0x4
        RetrieveString            = ...  # 0x8
        RetrieveAll               = ...  # 0xffff


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, text: str, font: PySide6.QtGui.QFont | str | typing.Sequence[str], paintdevice: PySide6.QtGui.QPaintDevice | None= ...) -> None: ...
    @typing.overload
    def __init__(self, text: str) -> None: ...
    @typing.overload
    def __init__(self, b: PySide6.QtGui.QTextBlock) -> None: ...

    def beginLayout(self) -> None: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def cacheEnabled(self) -> bool: ...
    def clearFormats(self) -> None: ...
    def clearLayout(self) -> None: ...
    def createLine(self) -> PySide6.QtGui.QTextLine: ...
    def cursorMoveStyle(self) -> PySide6.QtCore.Qt.CursorMoveStyle: ...
    def draw(self, p: PySide6.QtGui.QPainter, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, selections: typing.Sequence[PySide6.QtGui.QTextLayout.FormatRange] = ..., clip: PySide6.QtCore.QRectF | PySide6.QtCore.QRect= ...) -> None: ...
    @typing.overload
    def drawCursor(self, p: PySide6.QtGui.QPainter, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, cursorPosition: int) -> None: ...
    @typing.overload
    def drawCursor(self, p: PySide6.QtGui.QPainter, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, cursorPosition: int, width: int) -> None: ...
    def endLayout(self) -> None: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def formats(self) -> typing.List[PySide6.QtGui.QTextLayout.FormatRange]: ...
    @typing.overload
    def glyphRuns(self, from_: int = ..., length: int = ...) -> typing.List[PySide6.QtGui.QGlyphRun]: ...
    @typing.overload
    def glyphRuns(self, from_: int, length: int, flags: PySide6.QtGui.QTextLayout.GlyphRunRetrievalFlag) -> typing.List[PySide6.QtGui.QGlyphRun]: ...
    def isValidCursorPosition(self, pos: int) -> bool: ...
    def leftCursorPosition(self, oldPos: int) -> int: ...
    def lineAt(self, i: int) -> PySide6.QtGui.QTextLine: ...
    def lineCount(self) -> int: ...
    def lineForTextPosition(self, pos: int) -> PySide6.QtGui.QTextLine: ...
    def maximumWidth(self) -> float: ...
    def minimumWidth(self) -> float: ...
    def nextCursorPosition(self, oldPos: int, mode: PySide6.QtGui.QTextLayout.CursorMode = ...) -> int: ...
    def position(self) -> PySide6.QtCore.QPointF: ...
    def preeditAreaPosition(self) -> int: ...
    def preeditAreaText(self) -> str: ...
    def previousCursorPosition(self, oldPos: int, mode: PySide6.QtGui.QTextLayout.CursorMode = ...) -> int: ...
    def rightCursorPosition(self, oldPos: int) -> int: ...
    def setCacheEnabled(self, enable: bool) -> None: ...
    def setCursorMoveStyle(self, style: PySide6.QtCore.Qt.CursorMoveStyle) -> None: ...
    def setFlags(self, flags: int) -> None: ...
    def setFont(self, f: PySide6.QtGui.QFont | str | typing.Sequence[str]) -> None: ...
    def setFormats(self, overrides: typing.Sequence[PySide6.QtGui.QTextLayout.FormatRange]) -> None: ...
    def setPosition(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def setPreeditArea(self, position: int, text: str) -> None: ...
    def setRawFont(self, rawFont: PySide6.QtGui.QRawFont) -> None: ...
    def setText(self, string: str) -> None: ...
    def setTextOption(self, option: PySide6.QtGui.QTextOption | PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def text(self) -> str: ...
    def textOption(self) -> PySide6.QtGui.QTextOption: ...


class FormatRange(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, FormatRange: PySide6.QtGui.QTextLayout.FormatRange) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QTextLength(Shiboken.Object):

    class Type(enum.Enum):

        VariableLength            = ...  # 0x0
        FixedLength               = ...  # 0x1
        PercentageLength          = ...  # 0x2


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtGui.QTextLength.Type, value: float) -> None: ...
    @typing.overload
    def __init__(self, QTextLength: PySide6.QtGui.QTextLength) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __repr__() -> str: ...
    def rawValue(self) -> float: ...
    def type(self) -> PySide6.QtGui.QTextLength.Type: ...
    def value(self, maximumLength: float) -> float: ...


class QTextLine(Shiboken.Object):

    class CursorPosition(enum.Enum):

        CursorBetweenCharacters   = ...  # 0x0
        CursorOnCharacter         = ...  # 0x1

    class Edge(enum.Enum):

        Leading                   = ...  # 0x0
        Trailing                  = ...  # 0x1


    def __init__(self) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def ascent(self) -> float: ...
    def cursorToX(self, cursorPos: int, edge: PySide6.QtGui.QTextLine.Edge = ...) -> object: ...
    def descent(self) -> float: ...
    def draw(self, painter: PySide6.QtGui.QPainter, position: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def glyphRuns(self, from_: int = ..., length: int = ...) -> typing.List[PySide6.QtGui.QGlyphRun]: ...
    @typing.overload
    def glyphRuns(self, from_: int, length: int, flags: PySide6.QtGui.QTextLayout.GlyphRunRetrievalFlag) -> typing.List[PySide6.QtGui.QGlyphRun]: ...
    def height(self) -> float: ...
    def horizontalAdvance(self) -> float: ...
    def isValid(self) -> bool: ...
    def leading(self) -> float: ...
    def leadingIncluded(self) -> bool: ...
    def lineNumber(self) -> int: ...
    def naturalTextRect(self) -> PySide6.QtCore.QRectF: ...
    def naturalTextWidth(self) -> float: ...
    def position(self) -> PySide6.QtCore.QPointF: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    def setLeadingIncluded(self, included: bool) -> None: ...
    def setLineWidth(self, width: float) -> None: ...
    @typing.overload
    def setNumColumns(self, columns: int, alignmentWidth: float) -> None: ...
    @typing.overload
    def setNumColumns(self, columns: int) -> None: ...
    def setPosition(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    def textLength(self) -> int: ...
    def textStart(self) -> int: ...
    def width(self) -> float: ...
    def x(self) -> float: ...
    def xToCursor(self, x: float, edge: PySide6.QtGui.QTextLine.CursorPosition = ...) -> int: ...
    def y(self) -> float: ...


class QTextList(PySide6.QtGui.QTextBlockGroup):

    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None: ...

    def add(self, block: PySide6.QtGui.QTextBlock) -> None: ...
    def count(self) -> int: ...
    def format(self) -> PySide6.QtGui.QTextListFormat: ...
    def item(self, i: int) -> PySide6.QtGui.QTextBlock: ...
    def itemNumber(self, arg__1: PySide6.QtGui.QTextBlock) -> int: ...
    def itemText(self, arg__1: PySide6.QtGui.QTextBlock) -> str: ...
    def remove(self, arg__1: PySide6.QtGui.QTextBlock) -> None: ...
    def removeItem(self, i: int) -> None: ...
    def setFormat(self, format: PySide6.QtGui.QTextListFormat) -> None: ...


class QTextListFormat(PySide6.QtGui.QTextFormat):

    class Style(enum.Enum):

        ListUpperRoman            = ...  # -8
        ListLowerRoman            = ...  # -7
        ListUpperAlpha            = ...  # -6
        ListLowerAlpha            = ...  # -5
        ListDecimal               = ...  # -4
        ListSquare                = ...  # -3
        ListCircle                = ...  # -2
        ListDisc                  = ...  # -1
        ListStyleUndefined        = ...  # 0x0


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None: ...
    @typing.overload
    def __init__(self, QTextListFormat: PySide6.QtGui.QTextListFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def indent(self) -> int: ...
    def isValid(self) -> bool: ...
    def numberPrefix(self) -> str: ...
    def numberSuffix(self) -> str: ...
    def setIndent(self, indent: int) -> None: ...
    def setNumberPrefix(self, numberPrefix: str) -> None: ...
    def setNumberSuffix(self, numberSuffix: str) -> None: ...
    def setStart(self, indent: int) -> None: ...
    def setStyle(self, style: PySide6.QtGui.QTextListFormat.Style) -> None: ...
    def start(self) -> int: ...
    def style(self) -> PySide6.QtGui.QTextListFormat.Style: ...


class QTextObject(PySide6.QtCore.QObject):

    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None: ...

    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def format(self) -> PySide6.QtGui.QTextFormat: ...
    def formatIndex(self) -> int: ...
    def objectIndex(self) -> int: ...
    def setFormat(self, format: PySide6.QtGui.QTextFormat) -> None: ...


class QTextObjectInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def drawObject(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, doc: PySide6.QtGui.QTextDocument, posInDocument: int, format: PySide6.QtGui.QTextFormat) -> None: ...
    def intrinsicSize(self, doc: PySide6.QtGui.QTextDocument, posInDocument: int, format: PySide6.QtGui.QTextFormat) -> PySide6.QtCore.QSizeF: ...


class QTextOption(Shiboken.Object):

    class Flag(enum.Flag):

        ShowTabsAndSpaces         = ...  # 0x1
        ShowLineAndParagraphSeparators = ...  # 0x2
        AddSpaceForLineAndParagraphSeparators = ...  # 0x4
        SuppressColors            = ...  # 0x8
        ShowDocumentTerminator    = ...  # 0x10
        IncludeTrailingSpaces     = ...  # 0x80000000

    class Tab(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Tab: PySide6.QtGui.QTextOption.Tab) -> None: ...
        @typing.overload
        def __init__(self, pos: float, tabType: PySide6.QtGui.QTextOption.TabType, delim: str = ...) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class TabType(enum.Enum):

        LeftTab                   = ...  # 0x0
        RightTab                  = ...  # 0x1
        CenterTab                 = ...  # 0x2
        DelimiterTab              = ...  # 0x3

    class WrapMode(enum.Enum):

        NoWrap                    = ...  # 0x0
        WordWrap                  = ...  # 0x1
        ManualWrap                = ...  # 0x2
        WrapAnywhere              = ...  # 0x3
        WrapAtWordBoundaryOrAnywhere = ...  # 0x4


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o: PySide6.QtGui.QTextOption) -> None: ...
    @typing.overload
    def __init__(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def flags(self) -> PySide6.QtGui.QTextOption.Flag: ...
    def setAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setFlags(self, flags: PySide6.QtGui.QTextOption.Flag) -> None: ...
    def setTabArray(self, tabStops: typing.Sequence[float]) -> None: ...
    def setTabStopDistance(self, tabStopDistance: float) -> None: ...
    def setTabs(self, tabStops: typing.Sequence[PySide6.QtGui.QTextOption.Tab]) -> None: ...
    def setTextDirection(self, aDirection: PySide6.QtCore.Qt.LayoutDirection) -> None: ...
    def setUseDesignMetrics(self, b: bool) -> None: ...
    def setWrapMode(self, wrap: PySide6.QtGui.QTextOption.WrapMode) -> None: ...
    def tabArray(self) -> typing.List[float]: ...
    def tabStopDistance(self) -> float: ...
    def tabs(self) -> typing.List[PySide6.QtGui.QTextOption.Tab]: ...
    def textDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def useDesignMetrics(self) -> bool: ...
    def wrapMode(self) -> PySide6.QtGui.QTextOption.WrapMode: ...


class Tab(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, Tab: PySide6.QtGui.QTextOption.Tab) -> None: ...
    @typing.overload
    def __init__(self, pos: float, tabType: PySide6.QtGui.QTextOption.TabType, delim: str = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QTextTable(PySide6.QtGui.QTextFrame):

    def __init__(self, doc: PySide6.QtGui.QTextDocument) -> None: ...

    def appendColumns(self, count: int) -> None: ...
    def appendRows(self, count: int) -> None: ...
    @typing.overload
    def cellAt(self, position: int) -> PySide6.QtGui.QTextTableCell: ...
    @typing.overload
    def cellAt(self, c: PySide6.QtGui.QTextCursor) -> PySide6.QtGui.QTextTableCell: ...
    @typing.overload
    def cellAt(self, row: int, col: int) -> PySide6.QtGui.QTextTableCell: ...
    def columns(self) -> int: ...
    def format(self) -> PySide6.QtGui.QTextTableFormat: ...
    def insertColumns(self, pos: int, num: int) -> None: ...
    def insertRows(self, pos: int, num: int) -> None: ...
    @typing.overload
    def mergeCells(self, row: int, col: int, numRows: int, numCols: int) -> None: ...
    @typing.overload
    def mergeCells(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    def removeColumns(self, pos: int, num: int) -> None: ...
    def removeRows(self, pos: int, num: int) -> None: ...
    def resize(self, rows: int, cols: int) -> None: ...
    def rowEnd(self, c: PySide6.QtGui.QTextCursor) -> PySide6.QtGui.QTextCursor: ...
    def rowStart(self, c: PySide6.QtGui.QTextCursor) -> PySide6.QtGui.QTextCursor: ...
    def rows(self) -> int: ...
    def setFormat(self, format: PySide6.QtGui.QTextTableFormat) -> None: ...
    def splitCell(self, row: int, col: int, numRows: int, numCols: int) -> None: ...


class QTextTableCell(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o: PySide6.QtGui.QTextTableCell) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def begin(self) -> PySide6.QtGui.QTextFrame.iterator: ...
    def column(self) -> int: ...
    def columnSpan(self) -> int: ...
    def end(self) -> PySide6.QtGui.QTextFrame.iterator: ...
    def firstCursorPosition(self) -> PySide6.QtGui.QTextCursor: ...
    def firstPosition(self) -> int: ...
    def format(self) -> PySide6.QtGui.QTextCharFormat: ...
    def isValid(self) -> bool: ...
    def lastCursorPosition(self) -> PySide6.QtGui.QTextCursor: ...
    def lastPosition(self) -> int: ...
    def row(self) -> int: ...
    def rowSpan(self) -> int: ...
    def setFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    def tableCellFormatIndex(self) -> int: ...


class QTextTableCellFormat(PySide6.QtGui.QTextCharFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None: ...
    @typing.overload
    def __init__(self, QTextTableCellFormat: PySide6.QtGui.QTextTableCellFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def bottomBorder(self) -> float: ...
    def bottomBorderBrush(self) -> PySide6.QtGui.QBrush: ...
    def bottomBorderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle: ...
    def bottomPadding(self) -> float: ...
    def isValid(self) -> bool: ...
    def leftBorder(self) -> float: ...
    def leftBorderBrush(self) -> PySide6.QtGui.QBrush: ...
    def leftBorderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle: ...
    def leftPadding(self) -> float: ...
    def rightBorder(self) -> float: ...
    def rightBorderBrush(self) -> PySide6.QtGui.QBrush: ...
    def rightBorderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle: ...
    def rightPadding(self) -> float: ...
    def setBorder(self, width: float) -> None: ...
    def setBorderBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setBottomBorder(self, width: float) -> None: ...
    def setBottomBorderBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setBottomBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setBottomPadding(self, padding: float) -> None: ...
    def setLeftBorder(self, width: float) -> None: ...
    def setLeftBorderBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setLeftBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setLeftPadding(self, padding: float) -> None: ...
    def setPadding(self, padding: float) -> None: ...
    def setRightBorder(self, width: float) -> None: ...
    def setRightBorderBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setRightBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setRightPadding(self, padding: float) -> None: ...
    def setTopBorder(self, width: float) -> None: ...
    def setTopBorderBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap) -> None: ...
    def setTopBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setTopPadding(self, padding: float) -> None: ...
    def topBorder(self) -> float: ...
    def topBorderBrush(self) -> PySide6.QtGui.QBrush: ...
    def topBorderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle: ...
    def topPadding(self) -> float: ...


class QTextTableFormat(PySide6.QtGui.QTextFrameFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None: ...
    @typing.overload
    def __init__(self, QTextTableFormat: PySide6.QtGui.QTextTableFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def borderCollapse(self) -> bool: ...
    def cellPadding(self) -> float: ...
    def cellSpacing(self) -> float: ...
    def clearColumnWidthConstraints(self) -> None: ...
    def columnWidthConstraints(self) -> typing.List[PySide6.QtGui.QTextLength]: ...
    def columns(self) -> int: ...
    def headerRowCount(self) -> int: ...
    def isValid(self) -> bool: ...
    def setAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setBorderCollapse(self, borderCollapse: bool) -> None: ...
    def setCellPadding(self, padding: float) -> None: ...
    def setCellSpacing(self, spacing: float) -> None: ...
    def setColumnWidthConstraints(self, constraints: typing.Sequence[PySide6.QtGui.QTextLength]) -> None: ...
    def setColumns(self, columns: int) -> None: ...
    def setHeaderRowCount(self, count: int) -> None: ...


class QToolBarChangeEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QToolBarChangeEvent) -> None: ...
    @typing.overload
    def __init__(self, t: bool) -> None: ...

    def clone(self) -> PySide6.QtGui.QToolBarChangeEvent: ...
    def toggle(self) -> bool: ...


class QTouchEvent(PySide6.QtGui.QPointerEvent):

    @typing.overload
    def __init__(self, eventType: PySide6.QtCore.QEvent.Type, device: PySide6.QtGui.QPointingDevice | None= ..., modifiers: PySide6.QtCore.Qt.KeyboardModifier = ..., touchPoints: typing.Sequence[PySide6.QtGui.QEventPoint] = ...) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QTouchEvent) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def clone(self) -> PySide6.QtGui.QTouchEvent: ...
    def isBeginEvent(self) -> bool: ...
    def isEndEvent(self) -> bool: ...
    def isUpdateEvent(self) -> bool: ...
    def target(self) -> PySide6.QtCore.QObject: ...
    def touchPoints(self) -> typing.List[PySide6.QtGui.QEventPoint]: ...


class QTransform(Shiboken.Object):

    class TransformationType(enum.Enum):

        TxNone                    = ...  # 0x0
        TxTranslate               = ...  # 0x1
        TxScale                   = ...  # 0x2
        TxRotate                  = ...  # 0x4
        TxShear                   = ...  # 0x8
        TxProject                 = ...  # 0x10


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, h11: float, h12: float, h21: float, h22: float, dx: float, dy: float) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtGui.QTransform) -> None: ...
    @typing.overload
    def __init__(self, h11: float, h12: float, h13: float, h21: float, h22: float, h23: float, h31: float, h32: float, h33: float) -> None: ...

    def __add__(self, n: float) -> PySide6.QtGui.QTransform: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, div: float) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    def __imul__(self, div: float) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    def __imul__(self, arg__1: PySide6.QtGui.QTransform) -> PySide6.QtGui.QTransform: ...
    def __isub__(self, div: float) -> PySide6.QtGui.QTransform: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def __mul__(self, o: PySide6.QtGui.QTransform) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    def __mul__(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, n: float) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    def __mul__(self, l: PySide6.QtCore.QLineF | PySide6.QtCore.QLine) -> PySide6.QtCore.QLineF: ...
    @typing.overload
    def __mul__(self, l: PySide6.QtCore.QLine) -> PySide6.QtCore.QLine: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, n: float) -> PySide6.QtGui.QTransform: ...
    def adjoint(self) -> PySide6.QtGui.QTransform: ...
    def determinant(self) -> float: ...
    def dx(self) -> float: ...
    def dy(self) -> float: ...
    @staticmethod
    def fromScale(dx: float, dy: float) -> PySide6.QtGui.QTransform: ...
    @staticmethod
    def fromTranslate(dx: float, dy: float) -> PySide6.QtGui.QTransform: ...
    def inverted(self) -> typing.Tuple[PySide6.QtGui.QTransform, bool]: ...
    def isAffine(self) -> bool: ...
    def isIdentity(self) -> bool: ...
    def isInvertible(self) -> bool: ...
    def isRotating(self) -> bool: ...
    def isScaling(self) -> bool: ...
    def isTranslating(self) -> bool: ...
    def m11(self) -> float: ...
    def m12(self) -> float: ...
    def m13(self) -> float: ...
    def m21(self) -> float: ...
    def m22(self) -> float: ...
    def m23(self) -> float: ...
    def m31(self) -> float: ...
    def m32(self) -> float: ...
    def m33(self) -> float: ...
    @typing.overload
    def map(self, a: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def map(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def map(self, x: float, y: float) -> object: ...
    @typing.overload
    def map(self, p: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @typing.overload
    def map(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def map(self, a: PySide6.QtGui.QPolygon | typing.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect) -> PySide6.QtGui.QPolygon: ...
    @typing.overload
    def map(self, r: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion: ...
    @typing.overload
    def map(self, l: PySide6.QtCore.QLineF | PySide6.QtCore.QLine) -> PySide6.QtCore.QLineF: ...
    @typing.overload
    def map(self, l: PySide6.QtCore.QLine) -> PySide6.QtCore.QLine: ...
    @typing.overload
    def mapRect(self, arg__1: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def mapRect(self, arg__1: PySide6.QtCore.QRectF | PySide6.QtCore.QRect) -> PySide6.QtCore.QRectF: ...
    def mapToPolygon(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QPolygon: ...
    @typing.overload
    @staticmethod
    def quadToQuad(one: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, two: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, result: PySide6.QtGui.QTransform) -> bool: ...
    @typing.overload
    @staticmethod
    def quadToQuad(arg__1: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, arg__2: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> object: ...
    @typing.overload
    @staticmethod
    def quadToSquare(arg__1: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> object: ...
    @typing.overload
    @staticmethod
    def quadToSquare(quad: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, result: PySide6.QtGui.QTransform) -> bool: ...
    def reset(self) -> None: ...
    @typing.overload
    def rotate(self, a: float, axis: PySide6.QtCore.Qt.Axis = ...) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    def rotate(self, a: float, axis: PySide6.QtCore.Qt.Axis, distanceToPlane: float) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    def rotateRadians(self, a: float, axis: PySide6.QtCore.Qt.Axis = ...) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    def rotateRadians(self, a: float, axis: PySide6.QtCore.Qt.Axis, distanceToPlane: float) -> PySide6.QtGui.QTransform: ...
    def scale(self, sx: float, sy: float) -> PySide6.QtGui.QTransform: ...
    def setMatrix(self, m11: float, m12: float, m13: float, m21: float, m22: float, m23: float, m31: float, m32: float, m33: float) -> None: ...
    def shear(self, sh: float, sv: float) -> PySide6.QtGui.QTransform: ...
    @typing.overload
    @staticmethod
    def squareToQuad(arg__1: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF) -> object: ...
    @typing.overload
    @staticmethod
    def squareToQuad(square: PySide6.QtGui.QPolygonF | typing.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, result: PySide6.QtGui.QTransform) -> bool: ...
    def translate(self, dx: float, dy: float) -> PySide6.QtGui.QTransform: ...
    def transposed(self) -> PySide6.QtGui.QTransform: ...
    def type(self) -> PySide6.QtGui.QTransform.TransformationType: ...


class QUndoCommand(Shiboken.Object):

    @typing.overload
    def __init__(self, text: str, parent: PySide6.QtGui.QUndoCommand | None= ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtGui.QUndoCommand | None= ...) -> None: ...

    def actionText(self) -> str: ...
    def child(self, index: int) -> PySide6.QtGui.QUndoCommand: ...
    def childCount(self) -> int: ...
    def id(self) -> int: ...
    def isObsolete(self) -> bool: ...
    def mergeWith(self, other: PySide6.QtGui.QUndoCommand) -> bool: ...
    def redo(self) -> None: ...
    def setObsolete(self, obsolete: bool) -> None: ...
    def setText(self, text: str) -> None: ...
    def text(self) -> str: ...
    def undo(self) -> None: ...


class QUndoGroup(PySide6.QtCore.QObject):

    activeStackChanged       : typing.ClassVar[Signal] = ... # activeStackChanged(QUndoStack*)
    canRedoChanged           : typing.ClassVar[Signal] = ... # canRedoChanged(bool)
    canUndoChanged           : typing.ClassVar[Signal] = ... # canUndoChanged(bool)
    cleanChanged             : typing.ClassVar[Signal] = ... # cleanChanged(bool)
    indexChanged             : typing.ClassVar[Signal] = ... # indexChanged(int)
    redoTextChanged          : typing.ClassVar[Signal] = ... # redoTextChanged(QString)
    undoTextChanged          : typing.ClassVar[Signal] = ... # undoTextChanged(QString)

    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    def activeStack(self) -> PySide6.QtGui.QUndoStack: ...
    def addStack(self, stack: PySide6.QtGui.QUndoStack) -> None: ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def createRedoAction(self, parent: PySide6.QtCore.QObject, prefix: str = ...) -> PySide6.QtGui.QAction: ...
    def createUndoAction(self, parent: PySide6.QtCore.QObject, prefix: str = ...) -> PySide6.QtGui.QAction: ...
    def isClean(self) -> bool: ...
    def redo(self) -> None: ...
    def redoText(self) -> str: ...
    def removeStack(self, stack: PySide6.QtGui.QUndoStack) -> None: ...
    def setActiveStack(self, stack: PySide6.QtGui.QUndoStack) -> None: ...
    def stacks(self) -> typing.List[PySide6.QtGui.QUndoStack]: ...
    def undo(self) -> None: ...
    def undoText(self) -> str: ...


class QUndoStack(PySide6.QtCore.QObject):

    canRedoChanged           : typing.ClassVar[Signal] = ... # canRedoChanged(bool)
    canUndoChanged           : typing.ClassVar[Signal] = ... # canUndoChanged(bool)
    cleanChanged             : typing.ClassVar[Signal] = ... # cleanChanged(bool)
    indexChanged             : typing.ClassVar[Signal] = ... # indexChanged(int)
    redoTextChanged          : typing.ClassVar[Signal] = ... # redoTextChanged(QString)
    undoTextChanged          : typing.ClassVar[Signal] = ... # undoTextChanged(QString)

    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    def beginMacro(self, text: str) -> None: ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def cleanIndex(self) -> int: ...
    def clear(self) -> None: ...
    def command(self, index: int) -> PySide6.QtGui.QUndoCommand: ...
    def count(self) -> int: ...
    def createRedoAction(self, parent: PySide6.QtCore.QObject, prefix: str = ...) -> PySide6.QtGui.QAction: ...
    def createUndoAction(self, parent: PySide6.QtCore.QObject, prefix: str = ...) -> PySide6.QtGui.QAction: ...
    def endMacro(self) -> None: ...
    def index(self) -> int: ...
    def isActive(self) -> bool: ...
    def isClean(self) -> bool: ...
    def push(self, cmd: PySide6.QtGui.QUndoCommand) -> None: ...
    def redo(self) -> None: ...
    def redoText(self) -> str: ...
    def resetClean(self) -> None: ...
    def setActive(self, active: bool = ...) -> None: ...
    def setClean(self) -> None: ...
    def setIndex(self, idx: int) -> None: ...
    def setUndoLimit(self, limit: int) -> None: ...
    def text(self, idx: int) -> str: ...
    def undo(self) -> None: ...
    def undoLimit(self) -> int: ...
    def undoText(self) -> str: ...


class QValidator(PySide6.QtCore.QObject):

    changed                  : typing.ClassVar[Signal] = ... # changed()

    class State(enum.Enum):

        Invalid                   = ...  # 0x0
        Intermediate              = ...  # 0x1
        Acceptable                = ...  # 0x2


    def __init__(self, parent: PySide6.QtCore.QObject | None= ...) -> None: ...

    def fixup(self, arg__1: str) -> str: ...
    def locale(self) -> PySide6.QtCore.QLocale: ...
    def setLocale(self, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language) -> None: ...
    def validate(self, arg__1: str, arg__2: int) -> object: ...


class QVector2D(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float) -> None: ...
    @typing.overload
    def __init__(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def __init__(self, point: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide6.QtGui.QVector4D) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide6.QtGui.QVector3D) -> None: ...

    def __add__(self, v2: PySide6.QtGui.QVector2D) -> PySide6.QtGui.QVector2D: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, vector: PySide6.QtGui.QVector2D) -> PySide6.QtGui.QVector2D: ...
    @typing.overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QVector2D: ...
    @typing.overload
    def __imul__(self, vector: PySide6.QtGui.QVector2D) -> PySide6.QtGui.QVector2D: ...
    def __isub__(self, vector: PySide6.QtGui.QVector2D) -> PySide6.QtGui.QVector2D: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, v2: PySide6.QtGui.QVector2D) -> PySide6.QtGui.QVector2D: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QVector2D: ...
    def __neg__(self) -> PySide6.QtGui.QVector2D: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, v2: PySide6.QtGui.QVector2D) -> PySide6.QtGui.QVector2D: ...
    def distanceToLine(self, point: PySide6.QtGui.QVector2D, direction: PySide6.QtGui.QVector2D) -> float: ...
    def distanceToPoint(self, point: PySide6.QtGui.QVector2D) -> float: ...
    @staticmethod
    def dotProduct(v1: PySide6.QtGui.QVector2D, v2: PySide6.QtGui.QVector2D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> PySide6.QtGui.QVector2D: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def toPoint(self) -> PySide6.QtCore.QPoint: ...
    def toPointF(self) -> PySide6.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector3D(self) -> PySide6.QtGui.QVector3D: ...
    def toVector4D(self) -> PySide6.QtGui.QVector4D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...


class QVector2DList(object): ...


class QVector3D(Shiboken.Object):

    @typing.overload
    def __init__(self, xpos: float, ypos: float, zpos: float) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide6.QtGui.QVector2D) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide6.QtGui.QVector2D, zpos: float) -> None: ...
    @typing.overload
    def __init__(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def __init__(self, point: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide6.QtGui.QVector4D) -> None: ...

    def __add__(self, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @typing.overload
    def __imul__(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @typing.overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QVector3D: ...
    def __isub__(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, quaternion: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QVector3D: ...
    @typing.overload
    def __mul__(self, matrix: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform) -> PySide6.QtGui.QVector3D: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QVector3D: ...
    @typing.overload
    def __mul__(self, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    def __neg__(self) -> PySide6.QtGui.QVector3D: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @staticmethod
    def crossProduct(v1: PySide6.QtGui.QVector3D, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    def distanceToLine(self, point: PySide6.QtGui.QVector3D, direction: PySide6.QtGui.QVector3D) -> float: ...
    @typing.overload
    def distanceToPlane(self, plane1: PySide6.QtGui.QVector3D, plane2: PySide6.QtGui.QVector3D, plane3: PySide6.QtGui.QVector3D) -> float: ...
    @typing.overload
    def distanceToPlane(self, plane: PySide6.QtGui.QVector3D, normal: PySide6.QtGui.QVector3D) -> float: ...
    def distanceToPoint(self, point: PySide6.QtGui.QVector3D) -> float: ...
    @staticmethod
    def dotProduct(v1: PySide6.QtGui.QVector3D, v2: PySide6.QtGui.QVector3D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    @typing.overload
    @staticmethod
    def normal(v1: PySide6.QtGui.QVector3D, v2: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    @typing.overload
    @staticmethod
    def normal(v1: PySide6.QtGui.QVector3D, v2: PySide6.QtGui.QVector3D, v3: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D: ...
    def normalize(self) -> None: ...
    def normalized(self) -> PySide6.QtGui.QVector3D: ...
    def project(self, modelView: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform, projection: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform, viewport: PySide6.QtCore.QRect) -> PySide6.QtGui.QVector3D: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    def toPoint(self) -> PySide6.QtCore.QPoint: ...
    def toPointF(self) -> PySide6.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector2D(self) -> PySide6.QtGui.QVector2D: ...
    def toVector4D(self) -> PySide6.QtGui.QVector4D: ...
    def unproject(self, modelView: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform, projection: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform, viewport: PySide6.QtCore.QRect) -> PySide6.QtGui.QVector3D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QVector3DList(object): ...


class QVector4D(Shiboken.Object):

    @typing.overload
    def __init__(self, xpos: float, ypos: float, zpos: float, wpos: float) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide6.QtGui.QVector2D) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide6.QtGui.QVector3D, wpos: float) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> None: ...
    @typing.overload
    def __init__(self, point: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide6.QtGui.QVector2D, zpos: float, wpos: float) -> None: ...
    @typing.overload
    def __init__(self, vector: PySide6.QtGui.QVector3D) -> None: ...

    def __add__(self, v2: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, vector: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    @typing.overload
    def __imul__(self, vector: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    @typing.overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QVector4D: ...
    def __isub__(self, vector: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, v2: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    @typing.overload
    def __mul__(self, matrix: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform) -> PySide6.QtGui.QVector4D: ...
    @typing.overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QVector4D: ...
    def __neg__(self) -> PySide6.QtGui.QVector4D: ...
    def __reduce__(self) -> str: ...
    @staticmethod
    def __repr__() -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __sub__(self, v2: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D: ...
    @staticmethod
    def dotProduct(v1: PySide6.QtGui.QVector4D, v2: PySide6.QtGui.QVector4D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> PySide6.QtGui.QVector4D: ...
    def setW(self, w: float) -> None: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    def toPoint(self) -> PySide6.QtCore.QPoint: ...
    def toPointF(self) -> PySide6.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector2D(self) -> PySide6.QtGui.QVector2D: ...
    def toVector2DAffine(self) -> PySide6.QtGui.QVector2D: ...
    def toVector3D(self) -> PySide6.QtGui.QVector3D: ...
    def toVector3DAffine(self) -> PySide6.QtGui.QVector3D: ...
    def w(self) -> float: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QVector4DList(object): ...


class QWhatsThisClickedEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, href: str) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QWhatsThisClickedEvent) -> None: ...

    def clone(self) -> PySide6.QtGui.QWhatsThisClickedEvent: ...
    def href(self) -> str: ...


class QWheelEvent(PySide6.QtGui.QSinglePointEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QWheelEvent) -> None: ...
    @typing.overload
    def __init__(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, globalPos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, pixelDelta: PySide6.QtCore.QPoint, angleDelta: PySide6.QtCore.QPoint, buttons: PySide6.QtCore.Qt.MouseButton, modifiers: PySide6.QtCore.Qt.KeyboardModifier, phase: PySide6.QtCore.Qt.ScrollPhase, inverted: bool, source: PySide6.QtCore.Qt.MouseEventSource = ..., device: PySide6.QtGui.QPointingDevice = ...) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def angleDelta(self) -> PySide6.QtCore.QPoint: ...
    def clone(self) -> PySide6.QtGui.QWheelEvent: ...
    def hasPixelDelta(self) -> bool: ...
    def inverted(self) -> bool: ...
    def isBeginEvent(self) -> bool: ...
    def isEndEvent(self) -> bool: ...
    def isInverted(self) -> bool: ...
    def isUpdateEvent(self) -> bool: ...
    def phase(self) -> PySide6.QtCore.Qt.ScrollPhase: ...
    def pixelDelta(self) -> PySide6.QtCore.QPoint: ...
    def source(self) -> PySide6.QtCore.Qt.MouseEventSource: ...


class QWindow(PySide6.QtCore.QObject, PySide6.QtGui.QSurface):

    activeChanged            : typing.ClassVar[Signal] = ... # activeChanged()
    contentOrientationChanged: typing.ClassVar[Signal] = ... # contentOrientationChanged(Qt::ScreenOrientation)
    focusObjectChanged       : typing.ClassVar[Signal] = ... # focusObjectChanged(QObject*)
    heightChanged            : typing.ClassVar[Signal] = ... # heightChanged(int)
    maximumHeightChanged     : typing.ClassVar[Signal] = ... # maximumHeightChanged(int)
    maximumWidthChanged      : typing.ClassVar[Signal] = ... # maximumWidthChanged(int)
    minimumHeightChanged     : typing.ClassVar[Signal] = ... # minimumHeightChanged(int)
    minimumWidthChanged      : typing.ClassVar[Signal] = ... # minimumWidthChanged(int)
    modalityChanged          : typing.ClassVar[Signal] = ... # modalityChanged(Qt::WindowModality)
    opacityChanged           : typing.ClassVar[Signal] = ... # opacityChanged(double)
    screenChanged            : typing.ClassVar[Signal] = ... # screenChanged(QScreen*)
    transientParentChanged   : typing.ClassVar[Signal] = ... # transientParentChanged(QWindow*)
    visibilityChanged        : typing.ClassVar[Signal] = ... # visibilityChanged(QWindow::Visibility)
    visibleChanged           : typing.ClassVar[Signal] = ... # visibleChanged(bool)
    widthChanged             : typing.ClassVar[Signal] = ... # widthChanged(int)
    windowStateChanged       : typing.ClassVar[Signal] = ... # windowStateChanged(Qt::WindowState)
    windowTitleChanged       : typing.ClassVar[Signal] = ... # windowTitleChanged(QString)
    xChanged                 : typing.ClassVar[Signal] = ... # xChanged(int)
    yChanged                 : typing.ClassVar[Signal] = ... # yChanged(int)

    class AncestorMode(enum.Enum):

        ExcludeTransients         = ...  # 0x0
        IncludeTransients         = ...  # 0x1

    class Visibility(enum.Enum):

        Hidden                    = ...  # 0x0
        AutomaticVisibility       = ...  # 0x1
        Windowed                  = ...  # 0x2
        Minimized                 = ...  # 0x3
        Maximized                 = ...  # 0x4
        FullScreen                = ...  # 0x5


    @typing.overload
    def __init__(self, screen: PySide6.QtGui.QScreen | None= ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtGui.QWindow) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def accessibleRoot(self) -> PySide6.QtGui.QAccessibleInterface: ...
    def alert(self, msec: int) -> None: ...
    def baseSize(self) -> PySide6.QtCore.QSize: ...
    def close(self) -> bool: ...
    def closeEvent(self, arg__1: PySide6.QtGui.QCloseEvent) -> None: ...
    def contentOrientation(self) -> PySide6.QtCore.Qt.ScreenOrientation: ...
    def create(self) -> None: ...
    def cursor(self) -> PySide6.QtGui.QCursor: ...
    def destroy(self) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1: PySide6.QtGui.QExposeEvent) -> None: ...
    def filePath(self) -> str: ...
    def flags(self) -> PySide6.QtCore.Qt.WindowType: ...
    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusObject(self) -> PySide6.QtCore.QObject: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def format(self) -> PySide6.QtGui.QSurfaceFormat: ...
    def frameGeometry(self) -> PySide6.QtCore.QRect: ...
    def frameMargins(self) -> PySide6.QtCore.QMargins: ...
    def framePosition(self) -> PySide6.QtCore.QPoint: ...
    @staticmethod
    def fromWinId(id: int) -> PySide6.QtGui.QWindow: ...
    def geometry(self) -> PySide6.QtCore.QRect: ...
    def height(self) -> int: ...
    def hide(self) -> None: ...
    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent) -> None: ...
    def icon(self) -> PySide6.QtGui.QIcon: ...
    def isActive(self) -> bool: ...
    def isAncestorOf(self, child: PySide6.QtGui.QWindow, mode: PySide6.QtGui.QWindow.AncestorMode = ...) -> bool: ...
    def isExposed(self) -> bool: ...
    def isModal(self) -> bool: ...
    def isTopLevel(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def lower(self) -> None: ...
    @typing.overload
    def mapFromGlobal(self, pos: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def mapFromGlobal(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapToGlobal(self, pos: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def mapToGlobal(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element) -> PySide6.QtCore.QPointF: ...
    def mask(self) -> PySide6.QtGui.QRegion: ...
    def maximumHeight(self) -> int: ...
    def maximumSize(self) -> PySide6.QtCore.QSize: ...
    def maximumWidth(self) -> int: ...
    def minimumHeight(self) -> int: ...
    def minimumSize(self) -> PySide6.QtCore.QSize: ...
    def minimumWidth(self) -> int: ...
    def modality(self) -> PySide6.QtCore.Qt.WindowModality: ...
    def mouseDoubleClickEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def moveEvent(self, arg__1: PySide6.QtGui.QMoveEvent) -> None: ...
    def nativeEvent(self, eventType: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, message: int) -> object: ...
    def opacity(self) -> float: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def parent(self, mode: PySide6.QtGui.QWindow.AncestorMode = ...) -> PySide6.QtGui.QWindow: ...
    def position(self) -> PySide6.QtCore.QPoint: ...
    def raise_(self) -> None: ...
    def reportContentOrientationChange(self, orientation: PySide6.QtCore.Qt.ScreenOrientation) -> None: ...
    def requestActivate(self) -> None: ...
    def requestUpdate(self) -> None: ...
    def requestedFormat(self) -> PySide6.QtGui.QSurfaceFormat: ...
    @typing.overload
    def resize(self, w: int, h: int) -> None: ...
    @typing.overload
    def resize(self, newSize: PySide6.QtCore.QSize) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def resolveInterface(self, name: bytes | bytearray | memoryview, revision: int) -> int: ...
    def screen(self) -> PySide6.QtGui.QScreen: ...
    def setBaseSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setCursor(self, arg__1: PySide6.QtGui.QCursor | PySide6.QtCore.Qt.CursorShape | PySide6.QtGui.QPixmap) -> None: ...
    def setFilePath(self, filePath: str) -> None: ...
    def setFlag(self, arg__1: PySide6.QtCore.Qt.WindowType, on: bool = ...) -> None: ...
    def setFlags(self, flags: PySide6.QtCore.Qt.WindowType) -> None: ...
    def setFormat(self, format: PySide6.QtGui.QSurfaceFormat | PySide6.QtGui.QSurfaceFormat.FormatOption) -> None: ...
    def setFramePosition(self, point: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def setGeometry(self, rect: PySide6.QtCore.QRect) -> None: ...
    @typing.overload
    def setGeometry(self, posx: int, posy: int, w: int, h: int) -> None: ...
    def setHeight(self, arg: int) -> None: ...
    def setIcon(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap) -> None: ...
    def setKeyboardGrabEnabled(self, grab: bool) -> bool: ...
    def setMask(self, region: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect) -> None: ...
    def setMaximumHeight(self, h: int) -> None: ...
    def setMaximumSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setMaximumWidth(self, w: int) -> None: ...
    def setMinimumHeight(self, h: int) -> None: ...
    def setMinimumSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setMinimumWidth(self, w: int) -> None: ...
    def setModality(self, modality: PySide6.QtCore.Qt.WindowModality) -> None: ...
    def setMouseGrabEnabled(self, grab: bool) -> bool: ...
    def setOpacity(self, level: float) -> None: ...
    def setParent(self, parent: PySide6.QtGui.QWindow) -> None: ...
    @typing.overload
    def setPosition(self, pt: PySide6.QtCore.QPoint) -> None: ...
    @typing.overload
    def setPosition(self, posx: int, posy: int) -> None: ...
    def setScreen(self, screen: PySide6.QtGui.QScreen) -> None: ...
    def setSizeIncrement(self, size: PySide6.QtCore.QSize) -> None: ...
    def setSurfaceType(self, surfaceType: PySide6.QtGui.QSurface.SurfaceType) -> None: ...
    def setTitle(self, arg__1: str) -> None: ...
    def setTransientParent(self, parent: PySide6.QtGui.QWindow) -> None: ...
    def setVisibility(self, v: PySide6.QtGui.QWindow.Visibility) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def setWidth(self, arg: int) -> None: ...
    def setWindowState(self, state: PySide6.QtCore.Qt.WindowState) -> None: ...
    def setWindowStates(self, states: PySide6.QtCore.Qt.WindowState) -> None: ...
    def setX(self, arg: int) -> None: ...
    def setY(self, arg: int) -> None: ...
    def show(self) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...
    def showFullScreen(self) -> None: ...
    def showMaximized(self) -> None: ...
    def showMinimized(self) -> None: ...
    def showNormal(self) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def sizeIncrement(self) -> PySide6.QtCore.QSize: ...
    def startSystemMove(self) -> bool: ...
    def startSystemResize(self, edges: PySide6.QtCore.Qt.Edge) -> bool: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> PySide6.QtGui.QSurface.SurfaceType: ...
    def tabletEvent(self, arg__1: PySide6.QtGui.QTabletEvent) -> None: ...
    def title(self) -> str: ...
    def touchEvent(self, arg__1: PySide6.QtGui.QTouchEvent) -> None: ...
    def transientParent(self) -> PySide6.QtGui.QWindow: ...
    def type(self) -> PySide6.QtCore.Qt.WindowType: ...
    def unsetCursor(self) -> None: ...
    def visibility(self) -> PySide6.QtGui.QWindow.Visibility: ...
    def wheelEvent(self, arg__1: PySide6.QtGui.QWheelEvent) -> None: ...
    def width(self) -> int: ...
    def winId(self) -> int: ...
    def windowState(self) -> PySide6.QtCore.Qt.WindowState: ...
    def windowStates(self) -> PySide6.QtCore.Qt.WindowState: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QWindowStateChangeEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, oldState: PySide6.QtCore.Qt.WindowState, isOverride: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtGui.QWindowStateChangeEvent) -> None: ...

    @staticmethod
    def __repr__() -> str: ...
    def clone(self) -> PySide6.QtGui.QWindowStateChangeEvent: ...
    def isOverride(self) -> bool: ...
    def oldState(self) -> PySide6.QtCore.Qt.WindowState: ...


class Qt(PySide6.QtCore.Qt):
    @staticmethod
    def convertFromPlainText(plain: str, mode: PySide6.QtCore.Qt.WhiteSpaceMode = ...) -> str: ...
    @staticmethod
    def mightBeRichText(arg__1: str) -> bool: ...


def qAlpha(rgb: int) -> int: ...
def qBlue(rgb: int) -> int: ...
@typing.overload
def qFuzzyCompare(arg__1: PySide6.QtGui.QQuaternion, arg__2: PySide6.QtGui.QQuaternion) -> bool: ...
@typing.overload
def qFuzzyCompare(arg__1: PySide6.QtGui.QVector3D, arg__2: PySide6.QtGui.QVector3D) -> bool: ...
@typing.overload
def qFuzzyCompare(arg__1: PySide6.QtGui.QVector4D, arg__2: PySide6.QtGui.QVector4D) -> bool: ...
@typing.overload
def qFuzzyCompare(arg__1: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform, arg__2: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform) -> bool: ...
@typing.overload
def qFuzzyCompare(arg__1: PySide6.QtGui.QVector2D, arg__2: PySide6.QtGui.QVector2D) -> bool: ...
@typing.overload
def qFuzzyCompare(arg__1: PySide6.QtGui.QTransform, arg__2: PySide6.QtGui.QTransform) -> bool: ...
@typing.overload
def qGray(r: int, g: int, b: int) -> int: ...
@typing.overload
def qGray(rgb: int) -> int: ...
def qGreen(rgb: int) -> int: ...
def qIsGray(rgb: int) -> bool: ...
def qPixelFormatAlpha(channelSize: int, typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ...) -> PySide6.QtGui.QPixelFormat: ...
def qPixelFormatCmyk(channelSize: int, alfa: int = ..., usage: PySide6.QtGui.QPixelFormat.AlphaUsage = ..., position: PySide6.QtGui.QPixelFormat.AlphaPosition = ..., typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ...) -> PySide6.QtGui.QPixelFormat: ...
def qPixelFormatGrayscale(channelSize: int, typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ...) -> PySide6.QtGui.QPixelFormat: ...
def qPixelFormatHsl(channelSize: int, alfa: int = ..., usage: PySide6.QtGui.QPixelFormat.AlphaUsage = ..., position: PySide6.QtGui.QPixelFormat.AlphaPosition = ..., typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ...) -> PySide6.QtGui.QPixelFormat: ...
def qPixelFormatHsv(channelSize: int, alfa: int = ..., usage: PySide6.QtGui.QPixelFormat.AlphaUsage = ..., position: PySide6.QtGui.QPixelFormat.AlphaPosition = ..., typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ...) -> PySide6.QtGui.QPixelFormat: ...
def qPixelFormatRgba(red: int, green: int, blue: int, alfa: int, usage: PySide6.QtGui.QPixelFormat.AlphaUsage, position: PySide6.QtGui.QPixelFormat.AlphaPosition, pmul: PySide6.QtGui.QPixelFormat.AlphaPremultiplied = ..., typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ...) -> PySide6.QtGui.QPixelFormat: ...
def qPixelFormatYuv(layout: PySide6.QtGui.QPixelFormat.YUVLayout, alfa: int = ..., usage: PySide6.QtGui.QPixelFormat.AlphaUsage = ..., position: PySide6.QtGui.QPixelFormat.AlphaPosition = ..., p_mul: PySide6.QtGui.QPixelFormat.AlphaPremultiplied = ..., typeInt: PySide6.QtGui.QPixelFormat.TypeInterpretation = ..., b_order: PySide6.QtGui.QPixelFormat.ByteOrder = ...) -> PySide6.QtGui.QPixelFormat: ...
def qRed(rgb: int) -> int: ...
def qRgb(r: int, g: int, b: int) -> int: ...
def qRgba(r: int, g: int, b: int, a: int) -> int: ...
def qt_set_sequence_auto_mnemonic(b: bool) -> None: ...


# eof
