/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import org.graalvm.visualvm.lib.jfluid.heap.HprofByteBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.HprofObject;
import org.graalvm.visualvm.lib.jfluid.heap.StackFrameSegment;

class StackFrame
extends HprofObject {
    static final int NO_LINE_INFO = 0;
    static final int UNKNOWN_LOCATION = -1;
    static final int COMPILED_METHOD = -2;
    static final int NATIVE_METHOD = -3;
    private final StackFrameSegment stackFrameSegment;

    StackFrame(StackFrameSegment segment, long offset) {
        super(offset);
        this.stackFrameSegment = segment;
        assert (this.getHprofBuffer().get(offset) == 4);
    }

    long getStackFrameID() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.stackFrameSegment.stackFrameIDOffset);
    }

    String getMethodName() {
        return this.getStringByOffset(this.stackFrameSegment.methodIDOffset);
    }

    String getMethodSignature() {
        return this.getStringByOffset(this.stackFrameSegment.methodSignatureIDOffset);
    }

    String getSourceFile() {
        return this.getStringByOffset(this.stackFrameSegment.sourceIDOffset);
    }

    String getClassName() {
        int classSerial = this.getHprofBuffer().getInt(this.fileOffset + (long)this.stackFrameSegment.classSerialNumberOffset);
        return this.stackFrameSegment.getClassNameBySerialNumber(classSerial);
    }

    int getLineNumber() {
        return this.getHprofBuffer().getInt(this.fileOffset + (long)this.stackFrameSegment.lineNumberOffset);
    }

    private HprofByteBuffer getHprofBuffer() {
        return this.stackFrameSegment.hprofHeap.dumpBuffer;
    }

    private String getStringByOffset(long offset) {
        long stringID = this.getHprofBuffer().getID(this.fileOffset + offset);
        return this.stackFrameSegment.hprofHeap.getStringSegment().getStringByID(stringID);
    }
}

