import { format as formatJSON } from 'jsonc-parser';
import { Range, TextEdit } from '../jsonLanguageTypes';
export function format(documentToFormat, formattingOptions, formattingRange) {
    let range = undefined;
    if (formattingRange) {
        const offset = documentToFormat.offsetAt(formattingRange.start);
        const length = documentToFormat.offsetAt(formattingRange.end) - offset;
        range = { offset, length };
    }
    const options = {
        tabSize: formattingOptions ? formattingOptions.tabSize : 4,
        insertSpaces: formattingOptions?.insertSpaces === true,
        insertFinalNewline: formattingOptions?.insertFinalNewline === true,
        eol: '\n',
        keepLines: formattingOptions?.keepLines === true
    };
    return formatJSON(documentToFormat.getText(), range, options).map(edit => {
        return TextEdit.replace(Range.create(documentToFormat.positionAt(edit.offset), documentToFormat.positionAt(edit.offset + edit.length)), edit.content);
    });
}
