/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.metric.temperature.byShard.calculators;

import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep1;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.byShard.calculators.ShardBasedTemperatureCalculator;

public class AvgShardBasedTemperatureCalculator
extends ShardBasedTemperatureCalculator {
    public static final String ALIAS = "sum_max";
    public static final String SHARD_AVG = "shard_avg";

    public AvgShardBasedTemperatureCalculator(TemperatureDimension metricType) {
        super(metricType);
    }

    @Override
    protected Field<?> getAggrDimension() {
        return super.getAggrDimension().as(ALIAS);
    }

    @Override
    protected Result<Record> createDslAndFetch(DSLContext context, String tableName, Field<?> aggDimension, List<Field<?>> groupByFieldsList, List<Field<?>> selectFieldsList) {
        SelectSeekStep1<Record, ?> sumByIndexShardGroupsClause = this.getSumOfUtilByIndexShardGroup(context, tableName, aggDimension, groupByFieldsList, selectFieldsList);
        selectFieldsList.clear();
        Field avgOverShards = DSL.avg((Field)DSL.field((Name)DSL.name((String)ALIAS), Double.class)).as(SHARD_AVG);
        selectFieldsList.add(avgOverShards);
        Result r = context.select((SelectField)avgOverShards).from(sumByIndexShardGroupsClause).fetch();
        return r;
    }
}

