/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer;

import org.jruby.lexer.LexingCommon;
import org.jruby.util.ByteList;
import org.jruby.util.RubyDateFormatter;
import org.jruby.util.RubyTimeOutputFormatter;

public class StrftimeLexer {
    static RubyDateFormatter.Token SIX = new RubyDateFormatter.Token(RubyDateFormatter.Format.FORMAT_OUTPUT, new RubyTimeOutputFormatter(ByteList.EMPTY_BYTELIST, 6));
    public char EOF = '\u0000';
    private ByteList input;
    private int length;
    private int n = 0;
    private RubyDateFormatter.Token next = null;

    public void reset(ByteList input) {
        this.input = input;
        this.length = input.length();
        this.n = 0;
    }

    public RubyDateFormatter.Token directive(char c) {
        RubyDateFormatter.Token token2 = RubyDateFormatter.Token.format(c);
        if (token2 != null) {
            return token2;
        }
        return RubyDateFormatter.Token.special(c);
    }

    public RubyDateFormatter.Token formatter(ByteList flags2, Integer widthString) {
        int width = 0;
        if (widthString != null) {
            width = widthString;
        }
        if (flags2 == ByteList.EMPTY_BYTELIST && width == 6) {
            return SIX;
        }
        return new RubyTimeOutputFormatter(flags2, width);
    }

    private char current() {
        return this.n >= this.length ? this.EOF : this.input.charAt(this.n);
    }

    private char peek() {
        return this.n + 1 >= this.length ? this.EOF : this.input.charAt(this.n + 1);
    }

    private boolean consume(char c) {
        if (this.current() == c) {
            ++this.n;
            return true;
        }
        return false;
    }

    public RubyDateFormatter.Token yylex() {
        RubyDateFormatter.Token nextToken = this.next;
        if (nextToken != null) {
            this.next = null;
            return nextToken;
        }
        if (this.n >= this.length) {
            return null;
        }
        if (this.consume('%')) {
            RubyDateFormatter.Token token2 = this.parseLiteralPercent();
            if (token2 != null) {
                return token2;
            }
            token2 = this.parseSimpleDirective();
            if (token2 != null) {
                return token2;
            }
            token2 = this.parseComplexDirective();
            if (token2 != null) {
                return token2;
            }
            return RubyDateFormatter.Token.str(LexingCommon.PERCENT);
        }
        return this.parseUnknown();
    }

    private RubyDateFormatter.Token parseLiteralPercent() {
        if (this.consume('%')) {
            return RubyDateFormatter.Token.str(LexingCommon.PERCENT);
        }
        return null;
    }

    private RubyDateFormatter.Token parseSimpleDirective() {
        return this.parseConversion();
    }

    private RubyDateFormatter.Token parseComplexDirective() {
        int from = this.n;
        ByteList flags2 = this.parseFlags();
        if (flags2 != null) {
            Integer width = this.parseWidth();
            RubyDateFormatter.Token directive = this.parseConversion();
            if (directive != null) {
                this.next = directive;
                return this.formatter(flags2, width);
            }
        } else {
            RubyDateFormatter.Token directive;
            Integer width = this.parseWidth();
            if (width != null && (directive = this.parseConversion()) != null) {
                this.next = directive;
                return this.formatter(ByteList.EMPTY_BYTELIST, width);
            }
        }
        this.n = from;
        return null;
    }

    private ByteList parseFlags() {
        int from = this.n;
        if (this.n < this.length && this.parseFlag()) {
            ++this.n;
            while (this.n < this.length && this.parseFlag()) {
                ++this.n;
            }
            return this.input.makeShared(from, this.n - from);
        }
        return null;
    }

    private boolean parseFlag() {
        switch (this.current()) {
            case '#': 
            case '-': 
            case '0': 
            case '^': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    private Integer parseWidth() {
        char character = this.current();
        if (character < '1' || character > '9') {
            return null;
        }
        ++this.n;
        int count2 = character - 48;
        character = this.current();
        while (character != this.EOF) {
            ++this.n;
            if (!StrftimeLexer.isDecimalDigit(character)) {
                --this.n;
                break;
            }
            count2 = count2 * 10 + (character - 48);
            character = this.current();
        }
        return count2;
    }

    private RubyDateFormatter.Token parseUnknown() {
        int from = this.n;
        while (this.n < this.length && this.current() != '%') {
            ++this.n;
        }
        return RubyDateFormatter.Token.str(this.input.makeShared(from, this.n - from));
    }

    private RubyDateFormatter.Token parseConversion() {
        char c = this.current();
        switch (c) {
            case '+': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'g': 
            case 'h': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'p': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': {
                ++this.n;
                return this.directive(c);
            }
            case 'E': {
                char afterE = this.peek();
                switch (afterE) {
                    case 'C': 
                    case 'X': 
                    case 'Y': 
                    case 'c': 
                    case 'x': 
                    case 'y': {
                        this.n += 2;
                        return this.directive(afterE);
                    }
                }
                return null;
            }
            case 'O': {
                char afterO = this.peek();
                switch (afterO) {
                    case 'H': 
                    case 'I': 
                    case 'M': 
                    case 'S': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'd': 
                    case 'e': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'u': 
                    case 'w': 
                    case 'y': {
                        this.n += 2;
                        return this.directive(afterO);
                    }
                }
                return null;
            }
            case 'z': {
                ++this.n;
                return RubyDateFormatter.Token.zoneOffsetColons(0);
            }
            case ':': {
                int from = this.n++;
                if (this.consume(':')) {
                    if (this.consume(':')) {
                        if (this.consume('z')) {
                            return RubyDateFormatter.Token.zoneOffsetColons(3);
                        }
                        this.n = from;
                        return null;
                    }
                    if (this.consume('z')) {
                        return RubyDateFormatter.Token.zoneOffsetColons(2);
                    }
                    this.n = from;
                    return null;
                }
                if (this.consume('z')) {
                    return RubyDateFormatter.Token.zoneOffsetColons(1);
                }
                this.n = from;
                return null;
            }
        }
        return null;
    }

    private static boolean isDecimalDigit(int character) {
        return character >= 48 && character <= 57;
    }
}

