/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardHostValve;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;

public class StandardHost
extends ContainerBase
implements Host {
    private static final Log log = LogFactory.getLog(StandardHost.class);
    private String[] aliases = new String[0];
    private final Object aliasesLock = new Object();
    private String appBase = "webapps";
    private volatile File appBaseFile = null;
    private String xmlBase = null;
    private volatile File hostConfigBase = null;
    private boolean autoDeploy = true;
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private boolean deployOnStartup = true;
    private boolean deployXML = !Globals.IS_SECURITY_ENABLED;
    private boolean copyXML = false;
    private String errorReportValveClass = "org.apache.catalina.valves.ErrorReportValve";
    private boolean unpackWARs = true;
    private String workDir = null;
    private boolean createDirs = true;
    private final Map<ClassLoader, String> childClassLoaders = new WeakHashMap<ClassLoader, String>();
    private Pattern deployIgnore = null;
    private boolean undeployOldVersions = false;
    private boolean failCtxIfServletStartFails = false;

    public StandardHost() {
        this.pipeline.setBasic(new StandardHostValve());
    }

    @Override
    public boolean getUndeployOldVersions() {
        return this.undeployOldVersions;
    }

    @Override
    public void setUndeployOldVersions(boolean bl) {
        this.undeployOldVersions = bl;
    }

    @Override
    public ExecutorService getStartStopExecutor() {
        return this.startStopExecutor;
    }

    @Override
    public String getAppBase() {
        return this.appBase;
    }

    @Override
    public File getAppBaseFile() {
        if (this.appBaseFile != null) {
            return this.appBaseFile;
        }
        File file = new File(this.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(this.getCatalinaBase(), file.getPath());
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.appBaseFile = file;
        return file;
    }

    @Override
    public void setAppBase(String string) {
        if (string.trim().equals("")) {
            log.warn((Object)sm.getString("standardHost.problematicAppBase", new Object[]{this.getName()}));
        }
        String string2 = this.appBase;
        this.appBase = string;
        this.support.firePropertyChange("appBase", string2, this.appBase);
        this.appBaseFile = null;
    }

    @Override
    public String getXmlBase() {
        return this.xmlBase;
    }

    @Override
    public void setXmlBase(String string) {
        String string2 = this.xmlBase;
        this.xmlBase = string;
        this.support.firePropertyChange("xmlBase", string2, this.xmlBase);
    }

    @Override
    public File getConfigBaseFile() {
        Comparable<StringBuilder> comparable;
        if (this.hostConfigBase != null) {
            return this.hostConfigBase;
        }
        String string = null;
        if (this.getXmlBase() != null) {
            string = this.getXmlBase();
        } else {
            comparable = new StringBuilder("conf");
            Container container = this.getParent();
            if (container instanceof Engine) {
                ((StringBuilder)comparable).append('/');
                ((StringBuilder)comparable).append(container.getName());
            }
            ((StringBuilder)comparable).append('/');
            ((StringBuilder)comparable).append(this.getName());
            string = ((StringBuilder)comparable).toString();
        }
        comparable = new File(string);
        if (!((File)comparable).isAbsolute()) {
            comparable = new File(this.getCatalinaBase(), string);
        }
        try {
            comparable = ((File)comparable).getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.hostConfigBase = comparable;
        return comparable;
    }

    @Override
    public boolean getCreateDirs() {
        return this.createDirs;
    }

    @Override
    public void setCreateDirs(boolean bl) {
        this.createDirs = bl;
    }

    @Override
    public boolean getAutoDeploy() {
        return this.autoDeploy;
    }

    @Override
    public void setAutoDeploy(boolean bl) {
        boolean bl2 = this.autoDeploy;
        this.autoDeploy = bl;
        this.support.firePropertyChange("autoDeploy", bl2, this.autoDeploy);
    }

    @Override
    public String getConfigClass() {
        return this.configClass;
    }

    @Override
    public void setConfigClass(String string) {
        String string2 = this.configClass;
        this.configClass = string;
        this.support.firePropertyChange("configClass", string2, this.configClass);
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String string) {
        String string2 = this.contextClass;
        this.contextClass = string;
        this.support.firePropertyChange("contextClass", string2, this.contextClass);
    }

    @Override
    public boolean getDeployOnStartup() {
        return this.deployOnStartup;
    }

    @Override
    public void setDeployOnStartup(boolean bl) {
        boolean bl2 = this.deployOnStartup;
        this.deployOnStartup = bl;
        this.support.firePropertyChange("deployOnStartup", bl2, this.deployOnStartup);
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean bl) {
        this.deployXML = bl;
    }

    public boolean isCopyXML() {
        return this.copyXML;
    }

    public void setCopyXML(boolean bl) {
        this.copyXML = bl;
    }

    public String getErrorReportValveClass() {
        return this.errorReportValveClass;
    }

    public void setErrorReportValveClass(String string) {
        String string2 = this.errorReportValveClass;
        this.errorReportValveClass = string;
        this.support.firePropertyChange("errorReportValveClass", string2, this.errorReportValveClass);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.nullName"));
        }
        string = string.toLowerCase(Locale.ENGLISH);
        String string2 = this.name;
        this.name = string;
        this.support.firePropertyChange("name", string2, this.name);
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean bl) {
        this.unpackWARs = bl;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String string) {
        this.workDir = string;
    }

    @Override
    public String getDeployIgnore() {
        if (this.deployIgnore == null) {
            return null;
        }
        return this.deployIgnore.toString();
    }

    @Override
    public Pattern getDeployIgnorePattern() {
        return this.deployIgnore;
    }

    @Override
    public void setDeployIgnore(String string) {
        String string2 = this.deployIgnore == null ? null : this.deployIgnore.toString();
        this.deployIgnore = string == null ? null : Pattern.compile(string);
        this.support.firePropertyChange("deployIgnore", string2, string);
    }

    public boolean isFailCtxIfServletStartFails() {
        return this.failCtxIfServletStartFails;
    }

    public void setFailCtxIfServletStartFails(boolean bl) {
        boolean bl2 = this.failCtxIfServletStartFails;
        this.failCtxIfServletStartFails = bl;
        this.support.firePropertyChange("failCtxIfServletStartFails", bl2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAlias(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        Object object = this.aliasesLock;
        synchronized (object) {
            for (String string2 : this.aliases) {
                if (!string2.equals(string)) continue;
                return;
            }
            String[] stringArray = Arrays.copyOf(this.aliases, this.aliases.length + 1);
            stringArray[this.aliases.length] = string;
            this.aliases = stringArray;
        }
        this.fireContainerEvent("addAlias", string);
    }

    @Override
    public void addChild(Container container) {
        if (!(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardHost.notContext"));
        }
        container.addLifecycleListener(new MemoryLeakTrackingListener());
        Context context = (Context)container;
        if (context.getPath() == null) {
            ContextName contextName = new ContextName(context.getDocBase(), true);
            context.setPath(contextName.getPath());
        }
        super.addChild(container);
    }

    public String[] findReloadedContextMemoryLeaks() {
        System.gc();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<ClassLoader, String> entry : this.childClassLoaders.entrySet()) {
            ClassLoader classLoader = entry.getKey();
            if (!(classLoader instanceof WebappClassLoaderBase) || ((WebappClassLoaderBase)classLoader).getState().isAvailable()) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findAliases() {
        Object object = this.aliasesLock;
        synchronized (object) {
            return this.aliases;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAlias(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        Object object = this.aliasesLock;
        synchronized (object) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.aliases.length; ++n) {
                if (!this.aliases[n].equals(string)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            n = 0;
            String[] stringArray = new String[this.aliases.length - 1];
            for (int i = 0; i < this.aliases.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.aliases[i];
            }
            this.aliases = stringArray;
        }
        this.fireContainerEvent("removeAlias", string);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        String string = this.getErrorReportValveClass();
        if (string != null && !string.equals("")) {
            try {
                Valve[] valveArray;
                boolean bl = false;
                for (Valve valve : valveArray = this.getPipeline().getValves()) {
                    if (!string.equals(valve.getClass().getName())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    ErrorReportValve errorReportValve = ErrorReportValve.class.getName().equals(string) ? new ErrorReportValve() : (Valve)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.getPipeline().addValve(errorReportValve);
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("standardHost.invalidErrorReportValveClass", new Object[]{string}), throwable);
            }
        }
        super.startInternal();
    }

    public String[] getValveNames() throws Exception {
        Valve[] valveArray = this.getPipeline().getValves();
        String[] stringArray = new String[valveArray.length];
        for (int i = 0; i < valveArray.length; ++i) {
            ObjectName objectName;
            if (!(valveArray[i] instanceof JmxEnabled) || (objectName = ((JmxEnabled)((Object)valveArray[i])).getObjectName()) == null) continue;
            stringArray[i] = objectName.toString();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAliases() {
        Object object = this.aliasesLock;
        synchronized (object) {
            return this.aliases;
        }
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder stringBuilder = new StringBuilder("type=Host");
        stringBuilder.append(this.getMBeanKeyProperties());
        return stringBuilder.toString();
    }

    private class MemoryLeakTrackingListener
    implements LifecycleListener {
        private MemoryLeakTrackingListener() {
        }

        @Override
        public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
            if (lifecycleEvent.getType().equals("after_start") && lifecycleEvent.getSource() instanceof Context) {
                Context context = (Context)lifecycleEvent.getSource();
                StandardHost.this.childClassLoaders.put(context.getLoader().getClassLoader(), context.getServletContext().getContextPath());
            }
        }
    }
}

