# Imported via `make aws_managed_policies`
aws_managed_policies_data = """
{
 "APIGatewayServiceRolePolicy":{
  "CreateDate":"2017-10-20T17:23:10+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticloadbalancing:AddListenerCertificates",
      "elasticloadbalancing:RemoveListenerCertificates",
      "elasticloadbalancing:ModifyListener",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeLoadBalancers",
      "xray:PutTraceSegments",
      "xray:PutTelemetryRecords",
      "xray:GetSamplingTargets",
      "xray:GetSamplingRules",
      "logs:CreateLogDelivery",
      "logs:GetLogDelivery",
      "logs:UpdateLogDelivery",
      "logs:DeleteLogDelivery",
      "logs:ListLogDeliveries",
      "servicediscovery:DiscoverInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "firehose:DescribeDeliveryStream",
      "firehose:PutRecord",
      "firehose:PutRecordBatch"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:firehose:*:*:deliverystream/amazon-apigateway-*"
    },
    {
     "Action":[
      "acm:DescribeCertificate",
      "acm:GetCertificate"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:acm:*:*:certificate/*"
    },
    {
     "Action":"ec2:CreateNetworkInterfacePermission",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "Owner",
        "VpcLinkId"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    },
    {
     "Action":[
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:DeleteNetworkInterface",
      "ec2:AssignPrivateIpAddresses",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterfacePermission",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeNetworkInterfaceAttribute",
      "ec2:DescribeVpcs",
      "ec2:DescribeNetworkInterfacePermissions",
      "ec2:UnassignPrivateIpAddresses",
      "ec2:DescribeSubnets",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"servicediscovery:GetNamespace",
     "Effect":"Allow",
     "Resource":"arn:aws:servicediscovery:*:*:namespace/*"
    },
    {
     "Action":"servicediscovery:GetService",
     "Effect":"Allow",
     "Resource":"arn:aws:servicediscovery:*:*:service/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-12T22:24:40+00:00"
 },
 "AWSAccountActivityAccess":{
  "CreateDate":"2015-02-06T18:41:18+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "account:GetAccountInformation",
      "account:GetAlternateContact",
      "account:GetChallengeQuestions",
      "account:GetContactInformation",
      "account:GetRegionOptStatus",
      "account:ListRegions",
      "billing:GetIAMAccessPreference",
      "billing:GetSellerOfRecord",
      "payments:ListPaymentPreferences"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-portal:ViewBilling"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-07T17:02:30+00:00"
 },
 "AWSAccountManagementFullAccess":{
  "CreateDate":"2021-09-30T23:20:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"account:*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-30T23:20:37+00:00"
 },
 "AWSAccountManagementReadOnlyAccess":{
  "CreateDate":"2021-09-30T23:29:53+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "account:Get*",
      "account:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-30T23:29:53+00:00"
 },
 "AWSAccountUsageReportAccess":{
  "CreateDate":"2015-02-06T18:41:19+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-portal:ViewUsage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:41:19+00:00"
 },
 "AWSAgentlessDiscoveryService":{
  "CreateDate":"2016-08-02T01:35:11+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "awsconnector:RegisterConnector",
      "awsconnector:GetConnectorHealth"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:GetUser",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::connector-platform-upgrade-info/*",
      "arn:aws:s3:::connector-platform-upgrade-info",
      "arn:aws:s3:::connector-platform-upgrade-bundles/*",
      "arn:aws:s3:::connector-platform-upgrade-bundles",
      "arn:aws:s3:::connector-platform-release-notes/*",
      "arn:aws:s3:::connector-platform-release-notes",
      "arn:aws:s3:::prod.agentless.discovery.connector.upgrade/*",
      "arn:aws:s3:::prod.agentless.discovery.connector.upgrade"
     ]
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:PutObjectAcl"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::import-to-ec2-connector-debug-logs/*"
     ]
    },
    {
     "Action":[
      "SNS:Publish"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:metrics-sns-topic-for-*"
    },
    {
     "Action":[
      "Discovery:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Discovery"
    },
    {
     "Action":[
      "arsenal:RegisterOnPremisesAgent"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"arsenal"
    },
    {
     "Action":[
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-02-24T23:08:23+00:00"
 },
 "AWSAppFabricFullAccess":{
  "CreateDate":"2023-06-27T19:51:17+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appfabric:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSListAccess"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3ReadAccess"
    },
    {
     "Action":[
      "firehose:DescribeDeliveryStream",
      "firehose:ListDeliveryStreams"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"FirehoseReadAccess"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"appfabric.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/appfabric.amazonaws.com/AWSServiceRoleForAppFabric",
     "Sid":"AllowUseOfServiceLinkedRole"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-06-27T19:51:17+00:00"
 },
 "AWSAppFabricReadOnlyAccess":{
  "CreateDate":"2023-06-27T19:52:02+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appfabric:GetAppAuthorization",
      "appfabric:GetAppBundle",
      "appfabric:GetIngestion",
      "appfabric:GetIngestionDestination",
      "appfabric:ListAppAuthorizations",
      "appfabric:ListAppBundles",
      "appfabric:ListIngestionDestinations",
      "appfabric:ListIngestions",
      "appfabric:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-06-27T19:52:02+00:00"
 },
 "AWSAppFabricServiceRolePolicy":{
  "CreateDate":"2023-06-26T21:07:45+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"AWS/AppFabric"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchEmitMetric"
    },
    {
     "Action":[
      "s3:PutObject"
     ],
     "Condition":{
      "StringEquals":{
       "s3:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/AWSAppFabric/*",
     "Sid":"S3PutObject"
    },
    {
     "Action":[
      "firehose:PutRecordBatch"
     ],
     "Condition":{
      "StringEqualsIgnoreCase":{
       "aws:ResourceTag/AWSAppFabricManaged":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:firehose:*:*:deliverystream/*",
     "Sid":"FirehosePutRecord"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-06-26T21:07:45+00:00"
 },
 "AWSAppMeshEnvoyAccess":{
  "CreateDate":"2019-07-03T21:29:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appmesh:StreamAggregatedResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-07-03T21:29:37+00:00"
 },
 "AWSAppMeshFullAccess":{
  "CreateDate":"2019-04-16T17:50:40+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appmesh:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":[
        "appmesh.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/appmesh.amazonaws.com/AWSServiceRoleForAppMesh"
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStack*",
      "cloudformation:UpdateStack"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/AWSAppMesh-GettingStarted-*"
    },
    {
     "Action":[
      "acm:ListCertificates",
      "acm:DescribeCertificate",
      "acm-pca:DescribeCertificateAuthority",
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicediscovery:ListNamespaces",
      "servicediscovery:ListServices",
      "servicediscovery:ListInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-07T19:54:08+00:00"
 },
 "AWSAppMeshPreviewEnvoyAccess":{
  "CreateDate":"2019-08-05T23:32:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appmesh-preview:StreamAggregatedResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-05T23:32:39+00:00"
 },
 "AWSAppMeshPreviewServiceRolePolicy":{
  "CreateDate":"2019-06-19T19:07:00+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "servicediscovery:DiscoverInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudMapServiceDiscovery"
    },
    {
     "Action":[
      "acm:DescribeCertificate"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ACMCertificateVerification"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-21T21:06:29+00:00"
 },
 "AWSAppMeshReadOnly":{
  "CreateDate":"2019-04-16T17:51:11+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appmesh:Describe*",
      "appmesh:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudformation:DescribeStack*"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/AWSAppMesh-GettingStarted-*"
    },
    {
     "Action":[
      "acm:ListCertificates",
      "acm:DescribeCertificate",
      "acm-pca:DescribeCertificateAuthority",
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicediscovery:ListNamespaces",
      "servicediscovery:ListServices",
      "servicediscovery:ListInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-07T19:53:16+00:00"
 },
 "AWSAppMeshServiceRolePolicy":{
  "CreateDate":"2019-06-03T18:30:51+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "servicediscovery:DiscoverInstances",
      "servicediscovery:DiscoverInstancesRevision"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudMapServiceDiscovery"
    },
    {
     "Action":[
      "acm:DescribeCertificate"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ACMCertificateVerification"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-10-10T16:46:37+00:00"
 },
 "AWSAppRunnerFullAccess":{
  "CreateDate":"2022-01-11T04:02:09+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"apprunner.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/apprunner.amazonaws.com/AWSServiceRoleForAppRunner"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"apprunner.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"apprunner:*",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AppRunnerAdminAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-11T04:02:09+00:00"
 },
 "AWSAppRunnerReadOnlyAccess":{
  "CreateDate":"2022-02-24T21:24:15+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "apprunner:List*",
      "apprunner:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-24T21:24:15+00:00"
 },
 "AWSAppRunnerServicePolicyForECRAccess":{
  "CreateDate":"2021-05-14T19:17:21+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecr:GetDownloadUrlForLayer",
      "ecr:BatchGetImage",
      "ecr:DescribeImages",
      "ecr:GetAuthorizationToken",
      "ecr:BatchCheckLayerAvailability"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-05-14T19:17:21+00:00"
 },
 "AWSAppSyncAdministrator":{
  "CreateDate":"2018-03-20T21:20:28+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appsync:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "appsync.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"appsync.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/appsync.amazonaws.com/AWSServiceRoleForAppSync*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-04T19:23:49+00:00"
 },
 "AWSAppSyncInvokeFullAccess":{
  "CreateDate":"2018-03-20T21:21:20+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appsync:GraphQL",
      "appsync:GetGraphqlApi",
      "appsync:ListGraphqlApis",
      "appsync:ListApiKeys"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-03-20T21:21:20+00:00"
 },
 "AWSAppSyncPushToCloudWatchLogs":{
  "CreateDate":"2018-04-09T19:38:55+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-04-09T19:38:55+00:00"
 },
 "AWSAppSyncSchemaAuthor":{
  "CreateDate":"2018-03-20T21:21:06+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appsync:GraphQL",
      "appsync:CreateResolver",
      "appsync:CreateType",
      "appsync:DeleteResolver",
      "appsync:DeleteType",
      "appsync:GetResolver",
      "appsync:GetType",
      "appsync:GetDataSource",
      "appsync:GetSchemaCreationStatus",
      "appsync:GetIntrospectionSchema",
      "appsync:GetGraphqlApi",
      "appsync:ListTypes",
      "appsync:ListApiKeys",
      "appsync:ListResolvers",
      "appsync:ListDataSources",
      "appsync:ListGraphqlApis",
      "appsync:StartSchemaCreation",
      "appsync:UpdateResolver",
      "appsync:UpdateType",
      "appsync:TagResource",
      "appsync:UntagResource",
      "appsync:ListTagsForResource",
      "appsync:CreateFunction",
      "appsync:UpdateFunction",
      "appsync:GetFunction",
      "appsync:DeleteFunction",
      "appsync:ListFunctions",
      "appsync:ListResolversByFunction",
      "appsync:EvaluateMappingTemplate",
      "appsync:EvaluateCode"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-02-01T18:36:20+00:00"
 },
 "AWSAppSyncServiceRolePolicy":{
  "CreateDate":"2020-01-21T19:56:53+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "xray:PutTraceSegments",
      "xray:PutTelemetryRecords",
      "xray:GetSamplingTargets",
      "xray:GetSamplingRules",
      "xray:GetSamplingStatisticSummaries"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-01-21T19:56:53+00:00"
 },
 "AWSApplicationAutoScalingCustomResourcePolicy":{
  "CreateDate":"2018-06-04T23:22:44+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "execute-api:Invoke",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-06-04T23:22:44+00:00"
 },
 "AWSApplicationAutoscalingAppStreamFleetPolicy":{
  "CreateDate":"2017-10-20T19:04:06+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "appstream:UpdateFleet",
      "appstream:DescribeFleets",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-10-20T19:04:06+00:00"
 },
 "AWSApplicationAutoscalingCassandraTablePolicy":{
  "CreateDate":"2020-03-18T22:49:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"cassandra:Select",
     "Effect":"Allow",
     "Resource":[
      "arn:*:cassandra:*:*:/keyspace/system/table/*",
      "arn:*:cassandra:*:*:/keyspace/system_schema/table/*",
      "arn:*:cassandra:*:*:/keyspace/system_schema_mcs/table/*"
     ]
    },
    {
     "Action":[
      "cassandra:Alter",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-03-18T22:49:23+00:00"
 },
 "AWSApplicationAutoscalingComprehendEndpointPolicy":{
  "CreateDate":"2019-11-14T18:39:07+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "comprehend:UpdateEndpoint",
      "comprehend:DescribeEndpoint",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-14T18:39:07+00:00"
 },
 "AWSApplicationAutoscalingDynamoDBTablePolicy":{
  "CreateDate":"2017-10-20T21:34:57+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dynamodb:DescribeTable",
      "dynamodb:UpdateTable",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-10-20T21:34:57+00:00"
 },
 "AWSApplicationAutoscalingEC2SpotFleetRequestPolicy":{
  "CreateDate":"2017-10-25T18:23:27+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeSpotFleetRequests",
      "ec2:ModifySpotFleetRequest",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-10-25T18:23:27+00:00"
 },
 "AWSApplicationAutoscalingECSServicePolicy":{
  "CreateDate":"2017-10-25T23:53:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:DescribeServices",
      "ecs:UpdateService",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-10-25T23:53:08+00:00"
 },
 "AWSApplicationAutoscalingEMRInstanceGroupPolicy":{
  "CreateDate":"2017-10-26T00:57:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticmapreduce:ListInstanceGroups",
      "elasticmapreduce:ModifyInstanceGroups",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-10-26T00:57:39+00:00"
 },
 "AWSApplicationAutoscalingElastiCacheRGPolicy":{
  "CreateDate":"2021-08-17T23:41:42+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticache:DescribeReplicationGroups",
      "elasticache:ModifyReplicationGroupShardConfiguration",
      "elasticache:IncreaseReplicaCount",
      "elasticache:DecreaseReplicaCount",
      "elasticache:DescribeCacheClusters",
      "elasticache:DescribeCacheParameters",
      "cloudwatch:DescribeAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch:*:*:alarm:TargetTracking*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-17T23:41:42+00:00"
 },
 "AWSApplicationAutoscalingKafkaClusterPolicy":{
  "CreateDate":"2020-08-24T18:36:01+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "kafka:DescribeCluster",
      "kafka:DescribeClusterOperation",
      "kafka:UpdateBrokerStorage",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-24T18:36:01+00:00"
 },
 "AWSApplicationAutoscalingLambdaConcurrencyPolicy":{
  "CreateDate":"2019-10-21T20:04:17+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "lambda:PutProvisionedConcurrencyConfig",
      "lambda:GetProvisionedConcurrencyConfig",
      "lambda:DeleteProvisionedConcurrencyConfig",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-21T20:04:17+00:00"
 },
 "AWSApplicationAutoscalingNeptuneClusterPolicy":{
  "CreateDate":"2021-09-02T21:14:55+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rds:ListTagsForResource",
      "rds:DescribeDBInstances",
      "rds:DescribeDBClusters",
      "rds:DescribeDBClusterParameters",
      "cloudwatch:DescribeAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"rds:AddTagsToResource",
     "Condition":{
      "StringEquals":{
       "rds:DatabaseEngine":"neptune"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:db:autoscaled-reader*"
     ]
    },
    {
     "Action":"rds:CreateDBInstance",
     "Condition":{
      "StringEquals":{
       "rds:DatabaseEngine":"neptune"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:db:autoscaled-reader*",
      "arn:aws:rds:*:*:cluster:*"
     ]
    },
    {
     "Action":[
      "rds:DeleteDBInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:db:autoscaled-reader*"
     ]
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch:*:*:alarm:TargetTracking*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-02T21:14:55+00:00"
 },
 "AWSApplicationAutoscalingRDSClusterPolicy":{
  "CreateDate":"2017-10-17T17:46:56+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rds:AddTagsToResource",
      "rds:CreateDBInstance",
      "rds:DeleteDBInstance",
      "rds:DescribeDBClusters",
      "rds:DescribeDBInstances",
      "rds:ModifyDBCluster",
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"rds.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-08-07T19:14:24+00:00"
 },
 "AWSApplicationAutoscalingSageMakerEndpointPolicy":{
  "CreateDate":"2018-02-06T19:58:21+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sagemaker:DescribeEndpoint",
      "sagemaker:DescribeEndpointConfig",
      "sagemaker:DescribeInferenceComponent",
      "sagemaker:UpdateEndpointWeightsAndCapacities",
      "sagemaker:UpdateInferenceComponentRuntimeConfig",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:GetMetricData"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"SageMaker"
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch:*:*:alarm:TargetTracking*"
     ],
     "Sid":"SageMakerCloudWatchUpdate"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-13T18:52:34+00:00"
 },
 "AWSApplicationAutoscalingWorkSpacesPoolPolicy":{
  "CreateDate":"2024-06-17T18:39:07+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "workspaces:DescribeWorkspacesPools",
      "workspaces:UpdateWorkspacesPool"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"WorkSpacesActionsOnAllPools"
    },
    {
     "Action":[
      "cloudwatch:DescribeAlarms"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch:*:*:alarm:*"
     ],
     "Sid":"CloudWatchActionsOnAllAlarms"
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DeleteAlarms"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch:*:*:alarm:TargetTracking*"
     ],
     "Sid":"CloudWatchActionsOnTargetTrackingAlarms"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-17T18:39:07+00:00"
 },
 "AWSApplicationDiscoveryAgentAccess":{
  "CreateDate":"2016-05-11T21:38:47+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "arsenal:RegisterOnPremisesAgent"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-02-24T22:26:45+00:00"
 },
 "AWSApplicationDiscoveryAgentlessCollectorAccess":{
  "CreateDate":"2022-08-16T21:00:59+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "arsenal:RegisterOnPremisesAgent"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ecr-public:DescribeImages"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ecr-public::446372222237:repository/6e5498e4-8c31-4f57-9991-13b4b992ff7b"
    },
    {
     "Action":[
      "ecr-public:GetAuthorizationToken"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sts:GetServiceBearerToken"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-08-16T21:00:59+00:00"
 },
 "AWSApplicationDiscoveryServiceFullAccess":{
  "CreateDate":"2016-05-11T21:30:50+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgh:*",
      "discovery:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"continuousexport.discovery.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/continuousexport.discovery.amazonaws.com/AWSServiceRoleForApplicationDiscoveryServiceContinuousExport*"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/continuousexport.discovery.amazonaws.com/AWSServiceRoleForApplicationDiscoveryServiceContinuousExport*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "migrationhub.amazonaws.com",
        "dmsintegration.migrationhub.amazonaws.com",
        "smsintegration.migrationhub.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-19T21:21:26+00:00"
 },
 "AWSApplicationMigrationAgentInstallationPolicy":{
  "CreateDate":"2022-06-19T07:51:04+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:GetAgentInstallationAssetsForMgn",
      "mgn:SendClientMetricsForMgn",
      "mgn:SendClientLogsForMgn",
      "mgn:RegisterAgentForMgn",
      "mgn:VerifyClientRoleForMgn"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgn:IssueClientCertificateForMgn"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgn:*:*:source-server/*"
    },
    {
     "Action":"mgn:TagResource",
     "Condition":{
      "StringEquals":{
       "mgn:CreateAction":"RegisterAgentForMgn"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:mgn:*:*:source-server/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-09-20T11:21:24+00:00"
 },
 "AWSApplicationMigrationAgentPolicy":{
  "CreateDate":"2021-04-07T07:00:21+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:SendAgentMetricsForMgn",
      "mgn:SendAgentLogsForMgn",
      "mgn:SendClientMetricsForMgn",
      "mgn:SendClientLogsForMgn"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgn:RegisterAgentForMgn",
      "mgn:UpdateAgentSourcePropertiesForMgn",
      "mgn:UpdateAgentReplicationInfoForMgn",
      "mgn:UpdateAgentConversionInfoForMgn",
      "mgn:GetAgentInstallationAssetsForMgn",
      "mgn:GetAgentCommandForMgn",
      "mgn:GetAgentConfirmedResumeInfoForMgn",
      "mgn:GetAgentRuntimeConfigurationForMgn",
      "mgn:UpdateAgentBacklogForMgn",
      "mgn:GetAgentReplicationInfoForMgn"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"mgn:TagResource",
     "Effect":"Allow",
     "Resource":"arn:aws:mgn:*:*:source-server/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-09-20T11:13:40+00:00"
 },
 "AWSApplicationMigrationAgentPolicy_v2":{
  "CreateDate":"2022-06-06T14:14:38+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:SendAgentMetricsForMgn",
      "mgn:SendAgentLogsForMgn",
      "mgn:UpdateAgentSourcePropertiesForMgn",
      "mgn:UpdateAgentReplicationInfoForMgn",
      "mgn:UpdateAgentConversionInfoForMgn",
      "mgn:GetAgentCommandForMgn",
      "mgn:GetAgentConfirmedResumeInfoForMgn",
      "mgn:GetAgentRuntimeConfigurationForMgn",
      "mgn:UpdateAgentBacklogForMgn",
      "mgn:GetAgentReplicationInfoForMgn",
      "mgn:IssueClientCertificateForMgn"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgn:*:*:source-server/${aws:SourceIdentity}"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-06T14:14:38+00:00"
 },
 "AWSApplicationMigrationConversionServerPolicy":{
  "CreateDate":"2021-04-07T06:48:58+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:SendClientMetricsForMgn",
      "mgn:SendClientLogsForMgn",
      "mgn:GetChannelCommandsForMgn",
      "mgn:SendChannelCommandResultForMgn"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-07T06:48:58+00:00"
 },
 "AWSApplicationMigrationEC2Access":{
  "CreateDate":"2021-04-07T07:05:22+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSApplicationMigrationConversionServerRole"
     ]
    },
    {
     "Action":[
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:DescribeSnapshots",
      "ec2:DescribeImages",
      "ec2:DescribeVolumes"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "mgn.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:ModifyLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplate"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "mgn.amazonaws.com"
       ]
      },
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*"
    },
    {
     "Action":[
      "ec2:DeleteLaunchTemplate"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "mgn.amazonaws.com"
       ]
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*"
    },
    {
     "Action":[
      "ec2:DeleteVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "ec2:ModifyInstanceAttribute",
      "ec2:GetConsoleOutput",
      "ec2:GetConsoleScreenshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:RevokeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":"ec2:CreateSecurityGroup",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc/*"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:DetachVolume",
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:DetachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ]
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateSecurityGroup",
        "CreateVolume",
        "CreateSnapshot",
        "RunInstances",
        "CreateLaunchTemplate"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:ModifyVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:volume/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-02-06T16:07:02+00:00"
 },
 "AWSApplicationMigrationFullAccess":{
  "CreateDate":"2021-04-07T06:56:05+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor0"
    },
    {
     "Action":[
      "kms:ListAliases",
      "kms:DescribeKey"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor1"
    },
    {
     "Action":[
      "ec2:DescribeKeyPairs",
      "ec2:DescribeTags",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribePlacementGroups",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstanceTypeOfferings",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeVolumes",
      "ec2:GetEbsEncryptionByDefault",
      "ec2:GetEbsDefaultKmsKeyId"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor2"
    },
    {
     "Action":"license-manager:ListLicenseConfigurations",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor3"
    },
    {
     "Action":"elasticloadbalancing:DescribeLoadBalancers",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor4"
    },
    {
     "Action":"iam:ListInstanceProfiles",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor5"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSApplicationMigrationLaunchInstanceWithSsmRole",
      "arn:aws:iam::*:role/service-role/AWSApplicationMigrationLaunchInstanceWithDrsRole"
     ],
     "Sid":"VisualEditor6"
    },
    {
     "Action":[
      "drs:DescribeSourceServers"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor7"
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"VisualEditor8"
    },
    {
     "Action":[
      "ssm:ListCommandInvocations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor9"
    },
    {
     "Action":[
      "ssm:DescribeInstanceInformation",
      "ssm:GetCommandInvocation"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor10"
    },
    {
     "Action":[
      "ssm:DescribeDocument",
      "ssm:SendCommand"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSDisasterRecovery-InstallDRAgentOnInstance",
      "arn:aws:ssm:*:*:document/AWSMigration-*"
     ],
     "Sid":"VisualEditor11"
    },
    {
     "Action":[
      "drs:DisconnectSourceServer"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceConfiguredDR":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*",
     "Sid":"VisualEditor12"
    },
    {
     "Action":[
      "ssm:GetParameter",
      "ssm:PutParameter"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/ManagedByAWSApplicationMigrationService-*",
     "Sid":"VisualEditor13"
    },
    {
     "Action":[
      "servicequotas:GetServiceQuota"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor14"
    },
    {
     "Action":[
      "ssm:GetAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:automation-execution/*",
     "Sid":"VisualEditor15"
    },
    {
     "Action":[
      "ssm:GetDocument"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSDisasterRecovery-InstallDRAgentOnInstance",
      "arn:aws:ssm:*:*:document/AWSMigration-*"
     ],
     "Sid":"VisualEditor16"
    },
    {
     "Action":[
      "ssm:GetParameters"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/ManagedByAWSApplicationMigrationService-*",
     "Sid":"VisualEditor17"
    },
    {
     "Action":[
      "ssm:StartAutomationExecution"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"mgn.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:automation-definition/AWSMigration-*:$DEFAULT",
     "Sid":"VisualEditor18"
    },
    {
     "Action":"ssm:ListCommands",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor19"
    },
    {
     "Action":[
      "ssm:DescribeParameters"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "mgn.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor20"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-19T08:30:02+00:00"
 },
 "AWSApplicationMigrationMGHAccess":{
  "CreateDate":"2021-04-07T07:10:01+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgh:AssociateCreatedArtifact",
      "mgh:CreateProgressUpdateStream",
      "mgh:DisassociateCreatedArtifact",
      "mgh:GetHomeRegion",
      "mgh:ImportMigrationTask",
      "mgh:NotifyMigrationTaskState",
      "mgh:PutResourceAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-07T07:10:01+00:00"
 },
 "AWSApplicationMigrationReadOnlyAccess":{
  "CreateDate":"2021-04-07T07:15:26+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:DescribeJobLogItems",
      "mgn:DescribeJobs",
      "mgn:DescribeSourceServers",
      "mgn:DescribeReplicationConfigurationTemplates",
      "mgn:GetLaunchConfiguration",
      "mgn:DescribeVcenterClients",
      "mgn:GetReplicationConfiguration",
      "mgn:DescribeLaunchConfigurationTemplates",
      "mgn:ListSourceServerActions",
      "mgn:ListTemplateActions",
      "mgn:ListApplications",
      "mgn:ListWaves",
      "mgn:ListExports",
      "mgn:ListImports",
      "mgn:ListImportErrors",
      "mgn:ListExportErrors"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicequotas:GetServiceQuota"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-20T08:58:08+00:00"
 },
 "AWSApplicationMigrationReplicationServerPolicy":{
  "CreateDate":"2021-04-07T07:21:57+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:SendClientMetricsForMgn",
      "mgn:SendClientLogsForMgn",
      "mgn:GetChannelCommandsForMgn",
      "mgn:SendChannelCommandResultForMgn",
      "mgn:GetAgentSnapshotCreditsForMgn",
      "mgn:DescribeReplicationServerAssociationsForMgn",
      "mgn:DescribeSnapshotRequestsForMgn",
      "mgn:BatchDeleteSnapshotRequestForMgn",
      "mgn:NotifyAgentAuthenticationForMgn",
      "mgn:BatchCreateVolumeSnapshotGroupForMgn",
      "mgn:UpdateAgentReplicationProcessStateForMgn",
      "mgn:NotifyAgentReplicationProgressForMgn",
      "mgn:NotifyAgentConnectedForMgn",
      "mgn:NotifyAgentDisconnectedForMgn"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CreateSnapshot"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-07T07:21:57+00:00"
 },
 "AWSApplicationMigrationSSMAccess":{
  "CreateDate":"2022-11-27T09:29:05+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:GetCommandInvocation",
      "ssm:DescribeInstanceInformation"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "mgn.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ssm:SendCommand",
      "ssm:DescribeDocument",
      "ssm:StartAutomationExecution"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "mgn.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/*",
      "arn:aws:ssm:*:*:automation-definition/*:*"
     ]
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "mgn.amazonaws.com"
       ]
      },
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "ssm:ListDocuments"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:ListDocumentVersions",
      "ssm:GetDocument"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:document/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-20T10:57:51+00:00"
 },
 "AWSApplicationMigrationServiceEc2InstancePolicy":{
  "CreateDate":"2023-08-22T13:19:02+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:SendClientLogsForMgn",
      "mgn:RegisterAgentForMgn",
      "mgn:GetAgentInstallationAssetsForMgn"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"MgnAgentInstallation"
    },
    {
     "Action":[
      "mgn:SendAgentMetricsForMgn",
      "mgn:SendAgentLogsForMgn",
      "mgn:UpdateAgentSourcePropertiesForMgn",
      "mgn:UpdateAgentReplicationInfoForMgn",
      "mgn:UpdateAgentConversionInfoForMgn",
      "mgn:GetAgentCommandForMgn",
      "mgn:GetAgentConfirmedResumeInfoForMgn",
      "mgn:GetAgentRuntimeConfigurationForMgn",
      "mgn:UpdateAgentBacklogForMgn",
      "mgn:GetAgentReplicationInfoForMgn"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgn:*:*:source-server/*",
     "Sid":"MgnAgentReplication"
    },
    {
     "Action":"mgn:TagResource",
     "Condition":{
      "StringEquals":{
       "mgn:CreateAction":"RegisterAgentForMgn"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:mgn:*:*:source-server/*",
     "Sid":"MgnSourceServerTagResource"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-01-03T14:19:47+00:00"
 },
 "AWSApplicationMigrationServiceRolePolicy":{
  "CreateDate":"2021-04-07T06:43:20+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"mgn:ListTagsForResource",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"kms:ListRetirableGrants",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgh:AssociateCreatedArtifact",
      "mgh:CreateProgressUpdateStream",
      "mgh:DisassociateCreatedArtifact",
      "mgh:GetHomeRegion",
      "mgh:ImportMigrationTask",
      "mgh:NotifyMigrationTaskState",
      "mgh:PutResourceAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeVolumes",
      "ec2:GetEbsDefaultKmsKeyId",
      "ec2:GetEbsEncryptionByDefault"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:DescribeAccount"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:organizations::*:account/*"
    },
    {
     "Action":[
      "organizations:DescribeOrganization",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListDelegatedAdministrators",
      "organizations:ListAccounts"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:RegisterImage",
      "ec2:DeregisterImage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:ModifyLaunchTemplate",
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*"
    },
    {
     "Action":[
      "ec2:DeleteVolume"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "ec2:ModifyInstanceAttribute",
      "ec2:GetConsoleOutput",
      "ec2:GetConsoleScreenshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:RevokeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateVolume"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc/*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplate"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:DetachVolume",
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Null":{
       "ec2:ResourceTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:DetachVolume"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSApplicationMigrationServiceManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSApplicationMigrationReplicationServerRole",
      "arn:aws:iam::*:role/service-role/AWSApplicationMigrationConversionServerRole"
     ]
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateLaunchTemplate",
        "CreateSecurityGroup",
        "CreateVolume",
        "CreateSnapshot",
        "RunInstances"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:launch-template/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-06-20T09:12:04+00:00"
 },
 "AWSApplicationMigrationVCenterClientPolicy":{
  "CreateDate":"2021-11-08T12:53:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgn:CreateVcenterClientForMgn",
      "mgn:DescribeVcenterClients"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "mgn:GetVcenterClientCommandsForMgn",
      "mgn:SendVcenterClientCommandResultForMgn",
      "mgn:SendVcenterClientLogsForMgn",
      "mgn:SendVcenterClientMetricsForMgn",
      "mgn:DeleteVcenterClient",
      "mgn:TagResource",
      "mgn:NotifyVcenterClientStartedForMgn"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgn:*:*:vcenter-client/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-08T12:53:08+00:00"
 },
 "AWSArtifactAccountSync":{
  "CreateDate":"2018-04-10T23:04:33+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:ListAccounts",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-04-10T23:04:33+00:00"
 },
 "AWSArtifactReportsReadOnlyAccess":{
  "CreateDate":"2024-01-02T22:42:58+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "artifact:Get",
      "artifact:GetReport",
      "artifact:GetReportMetadata",
      "artifact:GetTermForReport",
      "artifact:ListReports"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ArtifactReportActions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-01-02T22:42:58+00:00"
 },
 "AWSArtifactServiceRolePolicy":{
  "CreateDate":"2023-08-21T20:27:31+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:ListAccounts",
      "organizations:DescribeOrganization",
      "organizations:DescribeAccount",
      "organizations:ListAWSServiceAccessForOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-08-21T20:27:31+00:00"
 },
 "AWSAuditManagerAdministratorAccess":{
  "CreateDate":"2020-12-11T20:02:42+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "auditmanager:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AuditManagerAccess"
    },
    {
     "Action":[
      "organizations:ListAccountsForParent",
      "organizations:ListAccounts",
      "organizations:DescribeOrganization",
      "organizations:DescribeOrganizationalUnit",
      "organizations:DescribeAccount",
      "organizations:ListParents",
      "organizations:ListChildren"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"OrganizationsAccess"
    },
    {
     "Action":[
      "organizations:RegisterDelegatedAdministrator",
      "organizations:DeregisterDelegatedAdministrator",
      "organizations:EnableAWSServiceAccess"
     ],
     "Condition":{
      "StringLikeIfExists":{
       "organizations:ServicePrincipal":[
        "auditmanager.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowOnlyAuditManagerIntegration"
    },
    {
     "Action":[
      "iam:GetUser",
      "iam:ListUsers",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMAccess"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"auditmanager.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/auditmanager.amazonaws.com/AWSServiceRoleForAuditManager*",
     "Sid":"IAMAccessCreateSLR"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:UpdateRoleDescription",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/auditmanager.amazonaws.com/AWSServiceRoleForAuditManager*",
     "Sid":"IAMAccessManageSLR"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3Access"
    },
    {
     "Action":[
      "kms:DescribeKey",
      "kms:ListKeys",
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KmsAccess"
    },
    {
     "Action":[
      "kms:CreateGrant"
     ],
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":"true"
      },
      "StringLike":{
       "kms:ViaService":"auditmanager.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KmsCreateGrantAccess"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSAccess"
    },
    {
     "Action":[
      "events:PutRule"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "events:source":[
        "aws.securityhub"
       ]
      },
      "StringEquals":{
       "events:detail-type":"Security Hub Findings - Imported"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CreateEventsAccess"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:DescribeRule",
      "events:EnableRule",
      "events:DisableRule",
      "events:ListTargetsByRule",
      "events:PutTargets",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/AuditManagerSecurityHubFindingsReceiver",
     "Sid":"EventsAccess"
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"TagAccess"
    },
    {
     "Action":[
      "controlcatalog:ListCommonControls",
      "controlcatalog:ListDomains",
      "controlcatalog:ListObjectives"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ControlCatalogAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-15T23:46:15+00:00"
 },
 "AWSAuditManagerServiceRolePolicy":{
  "CreateDate":"2020-12-08T15:12:12+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm:GetAccountConfiguration",
      "acm:ListCertificates",
      "autoscaling:DescribeAutoScalingGroups",
      "backup:ListBackupPlans",
      "backup:ListRecoveryPointsByResource",
      "bedrock:GetCustomModel",
      "bedrock:GetFoundationModel",
      "bedrock:GetModelCustomizationJob",
      "bedrock:GetModelInvocationLoggingConfiguration",
      "bedrock:ListCustomModels",
      "bedrock:ListFoundationModels",
      "bedrock:ListGuardrails",
      "bedrock:ListModelCustomizationJobs",
      "cloudfront:GetDistribution",
      "cloudfront:GetDistributionConfig",
      "cloudfront:ListDistributions",
      "cloudtrail:GetTrail",
      "cloudtrail:ListTrails",
      "cloudtrail:DescribeTrails",
      "cloudtrail:LookupEvents",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DescribeAlarmsForMetric",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics",
      "cognito-idp:DescribeUserPool",
      "config:DescribeConfigRules",
      "config:DescribeDeliveryChannels",
      "config:ListDiscoveredResources",
      "directconnect:DescribeDirectConnectGateways",
      "directconnect:DescribeVirtualGateways",
      "dynamodb:DescribeContinuousBackups",
      "dynamodb:DescribeBackup",
      "dynamodb:DescribeTableReplicaAutoScaling",
      "dynamodb:DescribeTable",
      "dynamodb:ListBackups",
      "dynamodb:ListGlobalTables",
      "dynamodb:ListTables",
      "ec2:DescribeInstanceCreditSpecifications",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeSecurityGroupRules",
      "ec2:DescribeVpcEndpointConnections",
      "ec2:DescribeVpcEndpointServiceConfigurations",
      "ec2:GetLaunchTemplateData",
      "ec2:DescribeAddresses",
      "ec2:DescribeCustomerGateways",
      "ec2:DescribeEgressOnlyInternetGateways",
      "ec2:DescribeFlowLogs",
      "ec2:DescribeInstances",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations",
      "ec2:DescribeLocalGateways",
      "ec2:DescribeLocalGatewayVirtualInterfaces",
      "ec2:DescribeNatGateways",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeTransitGateways",
      "ec2:DescribeVolumes",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeVpcPeeringConnections",
      "ec2:DescribeVpcs",
      "ec2:DescribeVpnConnections",
      "ec2:DescribeVpnGateways",
      "ec2:GetEbsDefaultKmsKeyId",
      "ec2:GetEbsEncryptionByDefault",
      "ecs:DescribeClusters",
      "eks:DescribeAddonVersions",
      "elasticache:DescribeCacheClusters",
      "elasticache:DescribeServiceUpdates",
      "elasticfilesystem:DescribeAccessPoints",
      "elasticfilesystem:DescribeFileSystems",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeSslPolicies",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticmapreduce:ListClusters",
      "elasticmapreduce:ListSecurityConfigurations",
      "events:DescribeRule",
      "events:ListConnections",
      "events:ListEventBuses",
      "events:ListEventSources",
      "events:ListRules",
      "firehose:ListDeliveryStreams",
      "fsx:DescribeFileSystems",
      "guardduty:ListDetectors",
      "iam:GenerateCredentialReport",
      "iam:GetAccountAuthorizationDetails",
      "iam:GetAccessKeyLastUsed",
      "iam:GetCredentialReport",
      "iam:GetGroupPolicy",
      "iam:GetPolicy",
      "iam:GetPolicyVersion",
      "iam:GetRolePolicy",
      "iam:GetUser",
      "iam:GetUserPolicy",
      "iam:GetAccountPasswordPolicy",
      "iam:GetAccountSummary",
      "iam:ListAttachedGroupPolicies",
      "iam:ListAttachedUserPolicies",
      "iam:ListEntitiesForPolicy",
      "iam:ListGroupsForUser",
      "iam:ListGroupPolicies",
      "iam:ListGroups",
      "iam:ListOpenIdConnectProviders",
      "iam:ListPolicies",
      "iam:ListRolePolicies",
      "iam:ListRoles",
      "iam:ListSamlProviders",
      "iam:ListUserPolicies",
      "iam:ListUsers",
      "iam:ListVirtualMFADevices",
      "iam:ListPolicyVersions",
      "iam:ListAccessKeys",
      "iam:ListAttachedRolePolicies",
      "iam:ListMfaDeviceTags",
      "iam:ListMfaDevices",
      "kafka:ListClusters",
      "kafka:ListKafkaVersions",
      "kinesis:ListStreams",
      "kms:DescribeKey",
      "kms:GetKeyPolicy",
      "kms:GetKeyRotationStatus",
      "kms:ListGrants",
      "kms:ListKeyPolicies",
      "kms:ListKeys",
      "lambda:ListFunctions",
      "license-manager:ListAssociationsForLicenseConfiguration",
      "license-manager:ListLicenseConfigurations",
      "license-manager:ListUsageForLicenseConfiguration",
      "logs:DescribeDestinations",
      "logs:DescribeExportTasks",
      "logs:DescribeLogGroups",
      "logs:DescribeMetricFilters",
      "logs:DescribeResourcePolicies",
      "logs:FilterLogEvents",
      "logs:GetDataProtectionPolicy",
      "es:DescribeDomains",
      "es:DescribeDomain",
      "es:DescribeDomainConfig",
      "es:ListDomainNames",
      "organizations:DescribeOrganization",
      "organizations:DescribePolicy",
      "rds:DescribeCertificates",
      "rds:DescribeDBClusterEndpoints",
      "rds:DescribeDBClusterParameterGroups",
      "rds:DescribeDBInstances",
      "rds:DescribeDBSecurityGroups",
      "rds:DescribeDBClusters",
      "rds:DescribeDBInstanceAutomatedBackups",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSnapshots",
      "redshift:DescribeLoggingStatus",
      "route53:GetQueryLoggingConfig",
      "sagemaker:DescribeAlgorithm",
      "sagemaker:DescribeFlowDefinition",
      "sagemaker:DescribeHumanTaskUi",
      "sagemaker:DescribeModelBiasJobDefinition",
      "sagemaker:DescribeModelCard",
      "sagemaker:DescribeModelQualityJobDefinition",
      "sagemaker:DescribeDomain",
      "sagemaker:DescribeEndpoint",
      "sagemaker:DescribeEndpointConfig",
      "sagemaker:DescribeLabelingJob",
      "sagemaker:DescribeModel",
      "sagemaker:DescribeTrainingJob",
      "sagemaker:DescribeUserProfile",
      "sagemaker:ListAlgorithms",
      "sagemaker:ListDomains",
      "sagemaker:ListEndpoints",
      "sagemaker:ListEndpointConfigs",
      "sagemaker:ListFlowDefinitions",
      "sagemaker:ListHumanTaskUis",
      "sagemaker:ListLabelingJobs",
      "sagemaker:ListModels",
      "sagemaker:ListModelBiasJobDefinitions",
      "sagemaker:ListModelCards",
      "sagemaker:ListModelQualityJobDefinitions",
      "sagemaker:ListMonitoringAlerts",
      "sagemaker:ListMonitoringSchedules",
      "sagemaker:ListTrainingJobs",
      "sagemaker:ListUserProfiles",
      "s3:GetBucketPublicAccessBlock",
      "s3:GetBucketVersioning",
      "s3:GetEncryptionConfiguration",
      "s3:GetLifecycleConfiguration",
      "s3:ListAllMyBuckets",
      "secretsmanager:DescribeSecret",
      "secretsmanager:ListSecrets",
      "securityhub:DescribeStandards",
      "sns:ListTagsForResource",
      "sns:ListTopics",
      "sqs:ListQueues",
      "waf-regional:GetRule",
      "waf-regional:GetWebAcl",
      "waf:GetRule",
      "waf:GetRuleGroup",
      "waf:ListActivatedRulesInRuleGroup",
      "waf:ListWebAcls",
      "wafv2:ListWebAcls",
      "waf-regional:GetLoggingConfiguration",
      "waf-regional:ListRuleGroups",
      "waf-regional:ListSubscribedRuleGroups",
      "waf-regional:ListWebACLs",
      "waf-regional:ListRules",
      "waf:ListRuleGroups",
      "waf:ListRules"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"APIsAccess"
    },
    {
     "Action":[
      "s3:GetBucketAcl",
      "s3:GetBucketLogging",
      "s3:GetBucketOwnershipControls",
      "s3:GetBucketPolicy",
      "s3:GetBucketTagging"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":[
        "${aws:PrincipalAccount}"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3Access"
    },
    {
     "Action":[
      "apigateway:GET"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":[
        "${aws:PrincipalAccount}"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/restapis",
      "arn:aws:apigateway:*::/restapis/*/stages/*",
      "arn:aws:apigateway:*::/restapis/*/stages"
     ],
     "Sid":"APIGatewayAccess"
    },
    {
     "Action":[
      "events:PutRule"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "events:source":[
        "aws.securityhub"
       ]
      },
      "Null":{
       "events:source":"false"
      },
      "StringEquals":{
       "events:detail-type":"Security Hub Findings - Imported"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/AuditManagerSecurityHubFindingsReceiver",
     "Sid":"CreateEventsAccess"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:DescribeRule",
      "events:EnableRule",
      "events:DisableRule",
      "events:ListTargetsByRule",
      "events:PutTargets",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/AuditManagerSecurityHubFindingsReceiver",
     "Sid":"EventsAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-09-24T23:22:25+00:00"
 },
 "AWSAutoScalingPlansEC2AutoScalingPolicy":{
  "CreateDate":"2018-08-23T22:46:59+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:GetMetricData",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeScheduledActions",
      "autoscaling:BatchPutScheduledUpdateGroupAction",
      "autoscaling:BatchDeleteScheduledAction"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-08-23T22:46:59+00:00"
 },
 "AWSBCMDataExportsServiceRolePolicy":{
  "CreateDate":"2024-06-10T17:40:19+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cost-optimization-hub:ListEnrollmentStatuses",
      "cost-optimization-hub:ListRecommendations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CostOptimizationRecommendationAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-10T17:40:19+00:00"
 },
 "AWSBackupAuditAccess":{
  "CreateDate":"2021-08-24T01:02:23+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "backup:CreateFramework",
      "backup:UpdateFramework",
      "backup:ListFrameworks",
      "backup:DescribeFramework",
      "backup:DeleteFramework",
      "backup:ListBackupPlans",
      "backup:ListBackupVaults",
      "backup:CreateReportPlan",
      "backup:UpdateReportPlan",
      "backup:ListReportPlans",
      "backup:DescribeReportPlan",
      "backup:DeleteReportPlan",
      "backup:StartReportJob",
      "backup:ListReportJobs",
      "backup:DescribeReportJob"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus",
      "config:DescribeComplianceByConfigRule"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "config:GetComplianceDetailsByConfigRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:config-rule/*"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets",
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-04-10T21:23:31+00:00"
 },
 "AWSBackupDataTransferAccess":{
  "CreateDate":"2022-11-10T22:48:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "backup-storage:StartObject",
      "backup-storage:PutChunk",
      "backup-storage:GetChunk",
      "backup-storage:ListChunks",
      "backup-storage:ListObjects",
      "backup-storage:GetObjectMetadata",
      "backup-storage:NotifyObjectComplete"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-11-10T22:48:05+00:00"
 },
 "AWSBackupFullAccess":{
  "CreateDate":"2019-11-18T22:21:52+00:00",
  "DefaultVersionId":"v18",
  "Document":{
   "Statement":[
    {
     "Action":"backup:*",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AwsBackupAllAccessPermissions"
    },
    {
     "Action":"backup-storage:*",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AwsBackupStorageAllAccessPermissions"
    },
    {
     "Action":[
      "rds:DescribeDBSnapshots",
      "rds:ListTagsForResource",
      "rds:DescribeDBInstances",
      "rds:describeDBEngineVersions",
      "rds:describeOptionGroups",
      "rds:describeOrderableDBInstanceOptions",
      "rds:describeDBSubnetGroups",
      "rds:describeDBClusterSnapshots",
      "rds:describeDBClusters",
      "rds:describeDBParameterGroups",
      "rds:DescribeDBClusterParameterGroups",
      "rds:DescribeDBInstanceAutomatedBackups",
      "rds:DescribeDBClusterAutomatedBackups"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RdsPermissions"
    },
    {
     "Action":[
      "rds:DeleteDBSnapshot",
      "rds:DeleteDBClusterSnapshot"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RdsDeletePermissions"
    },
    {
     "Action":[
      "dynamodb:ListBackups",
      "dynamodb:ListTables"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DynamoDbPermissions"
    },
    {
     "Action":[
      "dynamodb:DeleteBackup"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DynamoDbDeleteBackupPermissions"
    },
    {
     "Action":[
      "elasticfilesystem:DescribeFilesystems"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:elasticfilesystem:*:*:file-system/*",
     "Sid":"EfsFileSystemPermissions"
    },
    {
     "Action":[
      "ec2:DescribeSnapshots",
      "ec2:DescribeVolumes",
      "ec2:describeAvailabilityZones",
      "ec2:DescribeVpcs",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeImages",
      "ec2:DescribeSubnets",
      "ec2:DescribePlacementGroups",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeAddresses"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Ec2Permissions"
    },
    {
     "Action":[
      "ec2:DeleteSnapshot",
      "ec2:DeregisterImage"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Ec2DeletePermissions"
    },
    {
     "Action":[
      "tag:GetTagKeys",
      "tag:GetTagValues",
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ResourceGroupTaggingPermissions"
    },
    {
     "Action":[
      "storagegateway:DescribeCachediSCSIVolumes",
      "storagegateway:DescribeStorediSCSIVolumes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*/volume/*",
     "Sid":"StorageGatewayVolumePermissions"
    },
    {
     "Action":[
      "storagegateway:ListGateways"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:*",
     "Sid":"StorageGatewayPermissions"
    },
    {
     "Action":[
      "storagegateway:DescribeGatewayInformation",
      "storagegateway:ListLocalDisks"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*",
     "Sid":"StorageGatewayGatewayPermissions"
    },
    {
     "Action":[
      "storagegateway:ListVolumes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"StorageGatewayGatewayStarPermissions"
    },
    {
     "Action":[
      "iam:ListRoles",
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IamRolePermissions"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "backup.amazonaws.com",
        "restore-testing.backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/*AwsBackup*",
      "arn:aws:iam::*:role/*AWSBackup*"
     ],
     "Sid":"IamPassRolePermissions"
    },
    {
     "Action":"organizations:DescribeOrganization",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AwsOrganizationsPermissions"
    },
    {
     "Action":[
      "kms:ListKeys",
      "kms:DescribeKey",
      "kms:GenerateDataKey",
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KmsPermissions"
    },
    {
     "Action":[
      "kms:CreateGrant"
     ],
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":true
      },
      "ForAnyValue:StringEquals":{
       "kms:EncryptionContextKeys":"aws:backup:backup-vault"
      },
      "StringLike":{
       "kms:ViaService":"backup.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KmsCreateGrantPermissions"
    },
    {
     "Action":[
      "ssm:CancelCommand",
      "ssm:GetCommandInvocation"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SystemManagerCommandPermissions"
    },
    {
     "Action":"ssm:SendCommand",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSEC2-CreateVssSnapshot",
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"SystemManagerSendCommandPermissions"
    },
    {
     "Action":[
      "fsx:DescribeFileSystems",
      "fsx:DescribeBackups",
      "fsx:DescribeVolumes",
      "fsx:DescribeStorageVirtualMachines"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"FsxPermissions"
    },
    {
     "Action":"fsx:DeleteBackup",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*",
     "Sid":"FsxDeletePermissions"
    },
    {
     "Action":"ds:DescribeDirectories",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DirectoryServicePermissions"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "backup.amazonaws.com",
        "restore-testing.backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IamCreateServiceLinkedRolePermissions"
    },
    {
     "Action":[
      "backup-gateway:AssociateGatewayToServer",
      "backup-gateway:CreateGateway",
      "backup-gateway:DeleteGateway",
      "backup-gateway:DeleteHypervisor",
      "backup-gateway:DisassociateGatewayFromServer",
      "backup-gateway:ImportHypervisorConfiguration",
      "backup-gateway:ListGateways",
      "backup-gateway:ListHypervisors",
      "backup-gateway:ListTagsForResource",
      "backup-gateway:ListVirtualMachines",
      "backup-gateway:PutMaintenanceStartTime",
      "backup-gateway:TagResource",
      "backup-gateway:TestHypervisorConfiguration",
      "backup-gateway:UntagResource",
      "backup-gateway:UpdateGatewayInformation",
      "backup-gateway:UpdateHypervisor"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"BackupGatewayPermissions"
    },
    {
     "Action":[
      "backup-gateway:GetHypervisor",
      "backup-gateway:GetHypervisorPropertyMappings",
      "backup-gateway:PutHypervisorPropertyMappings",
      "backup-gateway:StartVirtualMachinesMetadataSync"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:hypervisor/*",
     "Sid":"BackupGatewayHypervisorPermissions"
    },
    {
     "Action":[
      "backup-gateway:GetVirtualMachine"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:vm/*",
     "Sid":"BackupGatewayVirtualMachinePermissions"
    },
    {
     "Action":[
      "backup-gateway:GetBandwidthRateLimitSchedule",
      "backup-gateway:GetGateway",
      "backup-gateway:PutBandwidthRateLimitSchedule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:gateway/*",
     "Sid":"BackupGatewayGatewayPermissions"
    },
    {
     "Action":"cloudwatch:GetMetricData",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchPermissions"
    },
    {
     "Action":[
      "timestream:ListTables",
      "timestream:ListDatabases"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:timestream:*:*:database/*"
     ],
     "Sid":"TimestreamDatabasePermissions"
    },
    {
     "Action":[
      "timestream:DescribeEndpoints"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"TimestreamPermissions"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*",
     "Sid":"S3BucketPermissions"
    },
    {
     "Action":[
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSubnetGroups",
      "redshift:DescribeClusterSnapshots",
      "redshift:DescribeSnapshotSchedules"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:redshift:*:*:cluster:*",
      "arn:aws:redshift:*:*:subnetgroup:*",
      "arn:aws:redshift:*:*:snapshot:*/*",
      "arn:aws:redshift:*:*:snapshotschedule:*"
     ],
     "Sid":"RedshiftResourcesPermissions"
    },
    {
     "Action":[
      "redshift:DescribeNodeConfigurationOptions",
      "redshift:DescribeOrderableClusterOptions",
      "redshift:DescribeClusterParameterGroups",
      "redshift:DescribeClusterTracks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RedshiftPermissions"
    },
    {
     "Action":[
      "cloudformation:ListStacks"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/*"
     ],
     "Sid":"CloudFormationStackPermissions"
    },
    {
     "Action":[
      "ssm-sap:GetOperation",
      "ssm-sap:ListDatabases",
      "ssm-sap:GetDatabase",
      "ssm-sap:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SystemsManagerForSapPermissions"
    },
    {
     "Action":[
      "ram:GetResourceShareAssociations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ResourceAccessManagerPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-09-26T19:18:54+00:00"
 },
 "AWSBackupGatewayServiceRolePolicyForVirtualMachineMetadataSync":{
  "CreateDate":"2022-12-15T19:43:11+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "backup-gateway:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:vm/*",
     "Sid":"ListVmTags"
    },
    {
     "Action":[
      "backup-gateway:TagResource",
      "backup-gateway:UntagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:vm/*",
     "Sid":"VMTagPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-12-15T19:43:11+00:00"
 },
 "AWSBackupOperatorAccess":{
  "CreateDate":"2019-11-18T22:23:17+00:00",
  "DefaultVersionId":"v16",
  "Document":{
   "Statement":[
    {
     "Action":[
      "backup:Get*",
      "backup:List*",
      "backup:Describe*",
      "backup:CreateBackupSelection",
      "backup:DeleteBackupSelection",
      "backup:StartBackupJob",
      "backup:StartRestoreJob",
      "backup:StartCopyJob"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AwsBackupAllAccess"
    },
    {
     "Action":[
      "rds:DescribeDBSnapshots",
      "rds:ListTagsForResource",
      "rds:DescribeDBInstances",
      "rds:describeDBEngineVersions",
      "rds:describeOptionGroups",
      "rds:describeOrderableDBInstanceOptions",
      "rds:describeDBSubnetGroups",
      "rds:DescribeDBClusterSnapshots",
      "rds:DescribeDBClusters",
      "rds:DescribeDBParameterGroups",
      "rds:DescribeDBClusterParameterGroups",
      "rds:DescribeDBInstanceAutomatedBackups",
      "rds:DescribeDBClusterAutomatedBackups"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RDSDescribeAccess"
    },
    {
     "Action":[
      "dynamodb:ListBackups",
      "dynamodb:ListTables"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DynamoDBAccess"
    },
    {
     "Action":[
      "elasticfilesystem:DescribeFilesystems"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:elasticfilesystem:*:*:file-system/*",
     "Sid":"EFSAccess"
    },
    {
     "Action":[
      "ec2:DescribeSnapshots",
      "ec2:DescribeVolumes",
      "ec2:describeAvailabilityZones",
      "ec2:DescribeVpcs",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeImages",
      "ec2:DescribeSubnets",
      "ec2:DescribePlacementGroups",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeAddresses"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2Access"
    },
    {
     "Action":[
      "tag:GetTagKeys",
      "tag:GetTagValues",
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"TagReadAccess"
    },
    {
     "Action":[
      "storagegateway:DescribeCachediSCSIVolumes",
      "storagegateway:DescribeStorediSCSIVolumes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*/volume/*",
     "Sid":"StorageGatewaySCSIAccess"
    },
    {
     "Action":[
      "storagegateway:ListGateways"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:*",
     "Sid":"StorageGatewayReadAccess"
    },
    {
     "Action":[
      "storagegateway:DescribeGatewayInformation",
      "storagegateway:ListLocalDisks"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*",
     "Sid":"StorageGatewayDiskReadAccess"
    },
    {
     "Action":[
      "storagegateway:ListVolumes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"StorageGatewayVolumeReadAccess"
    },
    {
     "Action":[
      "iam:ListRoles",
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMRoleAccess"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"backup.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/*AwsBackup*",
      "arn:aws:iam::*:role/*AWSBackup*"
     ],
     "Sid":"PassRoleAccess"
    },
    {
     "Action":"organizations:DescribeOrganization",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"OrganizationsAccess"
    },
    {
     "Action":[
      "ssm:CancelCommand",
      "ssm:GetCommandInvocation"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SSMReadAccess"
    },
    {
     "Action":"ssm:SendCommand",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSEC2-CreateVssSnapshot",
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"SSMComandAccess"
    },
    {
     "Action":"fsx:DescribeBackups",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*",
     "Sid":"FSXDescribeAccess"
    },
    {
     "Action":"fsx:DescribeFileSystems",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:file-system/*",
     "Sid":"FSxFileAccess"
    },
    {
     "Action":"fsx:DescribeVolumes",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:volume/*/*",
     "Sid":"FSxVolumeAccess"
    },
    {
     "Action":"fsx:DescribeStorageVirtualMachines",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:storage-virtual-machine/*/*",
     "Sid":"FSxMachineAccess"
    },
    {
     "Action":"ds:DescribeDirectories",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DirectoryServiceAccess"
    },
    {
     "Action":[
      "backup-gateway:ListGateways",
      "backup-gateway:ListHypervisors",
      "backup-gateway:ListTagsForResource",
      "backup-gateway:ListVirtualMachines"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"BackupGatewayListAccess"
    },
    {
     "Action":[
      "backup-gateway:GetHypervisor",
      "backup-gateway:GetHypervisorPropertyMappings"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:hypervisor/*",
     "Sid":"BackupGatewayHypervisorAccess"
    },
    {
     "Action":[
      "backup-gateway:GetVirtualMachine"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:vm/*",
     "Sid":"BackupGatewayMachineAccess"
    },
    {
     "Action":[
      "backup-gateway:GetBandwidthRateLimitSchedule",
      "backup-gateway:GetGateway"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:gateway/*",
     "Sid":"BackupGatewayAccess"
    },
    {
     "Action":"cloudwatch:GetMetricData",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchAccess"
    },
    {
     "Action":[
      "timestream:ListDatabases",
      "timestream:ListTables"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:timestream:*:*:database/*"
     ],
     "Sid":"TimestreamListAccess"
    },
    {
     "Action":[
      "timestream:DescribeEndpoints"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"TimestreamDescribeAccess"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*",
     "Sid":"S3ListAccess"
    },
    {
     "Action":[
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSubnetGroups",
      "redshift:DescribeClusterSnapshots",
      "redshift:DescribeSnapshotSchedules"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:redshift:*:*:cluster:*",
      "arn:aws:redshift:*:*:subnetgroup:*",
      "arn:aws:redshift:*:*:snapshot:*/*",
      "arn:aws:redshift:*:*:snapshotschedule:*"
     ],
     "Sid":"RedshiftAccess"
    },
    {
     "Action":[
      "redshift:DescribeNodeConfigurationOptions",
      "redshift:DescribeOrderableClusterOptions",
      "redshift:DescribeClusterParameterGroups",
      "redshift:DescribeClusterTracks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RedshiftOptionsAccess"
    },
    {
     "Action":[
      "cloudformation:ListStacks"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/*"
     ],
     "Sid":"CloudFormationAccess"
    },
    {
     "Action":[
      "ssm-sap:GetOperation",
      "ssm-sap:ListDatabases"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SAPAccess"
    },
    {
     "Action":[
      "ssm-sap:GetDatabase",
      "ssm-sap:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm-sap:*:*:*",
     "Sid":"SAPDatabaseAccess"
    },
    {
     "Action":[
      "ram:GetResourceShareAssociations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RAMAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-07-24T18:58:33+00:00"
 },
 "AWSBackupOrganizationAdminAccess":{
  "CreateDate":"2020-06-24T16:23:14+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DisableAWSServiceAccess",
      "organizations:EnableAWSServiceAccess",
      "organizations:ListDelegatedAdministrators"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":[
        "backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:RegisterDelegatedAdministrator",
      "organizations:DeregisterDelegatedAdministrator"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":[
        "backup.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:organizations::*:account/*"
    },
    {
     "Action":[
      "organizations:AttachPolicy",
      "organizations:ListPoliciesForTarget",
      "organizations:ListTargetsForPolicy",
      "organizations:DetachPolicy",
      "organizations:DisablePolicyType",
      "organizations:DescribePolicy",
      "organizations:DescribeEffectivePolicy",
      "organizations:ListPolicies",
      "organizations:EnablePolicyType",
      "organizations:CreatePolicy",
      "organizations:UpdatePolicy",
      "organizations:DeletePolicy"
     ],
     "Condition":{
      "StringLikeIfExists":{
       "organizations:PolicyType":[
        "BACKUP_POLICY"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:ListRoots",
      "organizations:ListParents",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListAccountsForParent",
      "organizations:ListAccounts",
      "organizations:DescribeOrganization",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListChildren",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganizationalUnit"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-11-18T18:26:40+00:00"
 },
 "AWSBackupRestoreAccessForSAPHANA":{
  "CreateDate":"2022-11-10T22:43:27+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "backup:Get*",
      "backup:List*",
      "backup:Describe*",
      "backup:StartBackupJob",
      "backup:StartRestoreJob"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm-sap:GetOperation",
      "ssm-sap:ListDatabases"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm-sap:BackupDatabase",
      "ssm-sap:RestoreDatabase",
      "ssm-sap:UpdateHanaBackupSettings",
      "ssm-sap:GetDatabase",
      "ssm-sap:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm-sap:*:*:*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-11-10T22:43:27+00:00"
 },
 "AWSBackupServiceLinkedRolePolicyForBackup":{
  "CreateDate":"2020-06-02T23:08:40+00:00",
  "DefaultVersionId":"v16",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticfilesystem:Backup",
      "elasticfilesystem:DescribeTags"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/aws:elasticfilesystem:default-backup":"enabled"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:elasticfilesystem:*:*:file-system/*",
     "Sid":"EFSResourcePermissions"
    },
    {
     "Action":[
      "tag:GetResources",
      "elasticfilesystem:DescribeFileSystems",
      "dynamodb:ListTables",
      "storagegateway:ListVolumes",
      "ec2:DescribeVolumes",
      "ec2:DescribeInstances",
      "rds:DescribeDBInstances",
      "rds:DescribeDBClusters",
      "fsx:DescribeFileSystems",
      "fsx:DescribeVolumes",
      "s3:ListAllMyBuckets",
      "s3:GetBucketTagging"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribePermissions"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CopySnapshot"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*",
     "Sid":"SnapshotCopyTagPermissions"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "AWSBackupManagedResource"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*::snapshot/*"
     ],
     "Sid":"EC2CreateBackupTagPermissions"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "Null":{
       "ec2:ResourceTag/AWSBackupManagedResource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*::snapshot/*"
     ],
     "Sid":"EC2CreateTagsPermissions"
    },
    {
     "Action":[
      "ec2:DescribeSnapshots",
      "ec2:DescribeSnapshotTierStatus",
      "ec2:DescribeImages",
      "rds:DescribeDBSnapshots",
      "rds:DescribeDBClusterSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2RDSDescribePermissions"
    },
    {
     "Action":"ec2:CopySnapshot",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*",
     "Sid":"EBSCopyPermissions"
    },
    {
     "Action":"ec2:CopyImage",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2CopyPermissions"
    },
    {
     "Action":[
      "ec2:DeregisterImage",
      "ec2:DeleteSnapshot",
      "ec2:ModifySnapshotTier"
     ],
     "Condition":{
      "Null":{
       "ec2:ResourceTag/AWSBackupManagedResource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2ModifyPermissions"
    },
    {
     "Action":[
      "rds:AddTagsToResource",
      "rds:CopyDBSnapshot",
      "rds:DeleteDBSnapshot",
      "rds:DeleteDBInstanceAutomatedBackup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:rds:*:*:snapshot:awsbackup:*",
     "Sid":"RDSInstanceAndSnashotPermissions"
    },
    {
     "Action":[
      "rds:AddTagsToResource",
      "rds:CopyDBClusterSnapshot",
      "rds:DeleteDBClusterSnapshot"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:rds:*:*:cluster-snapshot:awsbackup:*",
     "Sid":"RDSClusterPermissions"
    },
    {
     "Action":"kms:DescribeKey",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSDescribePermissions"
    },
    {
     "Action":[
      "kms:ListGrants",
      "kms:ReEncryptFrom",
      "kms:GenerateDataKeyWithoutPlaintext"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":[
        "ec2.*.amazonaws.com",
        "rds.*.amazonaws.com",
        "fsx.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSGrantPermissions"
    },
    {
     "Action":"kms:CreateGrant",
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":"true"
      },
      "StringLike":{
       "kms:ViaService":[
        "ec2.*.amazonaws.com",
        "rds.*.amazonaws.com",
        "fsx.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSCreateGrantPermissions"
    },
    {
     "Action":[
      "fsx:CopyBackup",
      "fsx:TagResource",
      "fsx:DescribeBackups",
      "fsx:DeleteBackup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*",
     "Sid":"FsxPermissions"
    },
    {
     "Action":"dynamodb:DeleteBackup",
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*/backup/*",
     "Sid":"DynamoDBDeletePermissions"
    },
    {
     "Action":[
      "backup-gateway:ListVirtualMachines"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"BackupGateway"
    },
    {
     "Action":[
      "backup-gateway:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:vm/*",
     "Sid":"ListTagsForBackupGateway"
    },
    {
     "Action":[
      "dynamodb:ListTagsOfResource",
      "dynamodb:DescribeTable"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*",
     "Sid":"DynamoDBPermissions"
    },
    {
     "Action":[
      "storagegateway:DescribeCachediSCSIVolumes",
      "storagegateway:DescribeStorediSCSIVolumes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*/volume/*",
     "Sid":"StorageGatewayPermissions"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:PutTargets",
      "events:DescribeRule",
      "events:EnableRule",
      "events:PutRule",
      "events:RemoveTargets",
      "events:ListTargetsByRule",
      "events:DisableRule"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/AwsBackupManagedRule*"
     ],
     "Sid":"EventBridgePermissions"
    },
    {
     "Action":"events:ListRules",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EventBridgeRulesPermissions"
    },
    {
     "Action":[
      "ssm-sap:GetOperation",
      "ssm-sap:UpdateHANABackupSettings"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SSMSAPPermissions"
    },
    {
     "Action":[
      "timestream:ListDatabases",
      "timestream:ListTables",
      "timestream:ListTagsForResource",
      "timestream:DescribeDatabase",
      "timestream:DescribeTable",
      "timestream:GetAwsBackupStatus",
      "timestream:GetAwsRestoreStatus"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:timestream:*:*:database/*"
     ],
     "Sid":"TimestreamResourcePermissions"
    },
    {
     "Action":[
      "timestream:DescribeEndpoints"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"TimestreamPermissions"
    },
    {
     "Action":[
      "redshift:DescribeClusterSnapshots",
      "redshift:DescribeTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:redshift:*:*:snapshot:*/*",
      "arn:aws:redshift:*:*:cluster:*"
     ],
     "Sid":"RedshiftDescribePermissions"
    },
    {
     "Action":[
      "redshift:DeleteClusterSnapshot"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:redshift:*:*:snapshot:*/*"
     ],
     "Sid":"RedshiftClusterSnapshotPermissions"
    },
    {
     "Action":[
      "redshift:DescribeClusters"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:redshift:*:*:cluster:*"
     ],
     "Sid":"RedshiftClusterPermissions"
    },
    {
     "Action":[
      "cloudformation:ListStacks"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/*"
     ],
     "Sid":"CloudformationStackPermissions"
    },
    {
     "Action":[
      "backup:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "aws:PrincipalAccount":"${aws:ResourceAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:backup:*:*:recovery-point:*",
     "Sid":"RecoveryPointTaggingPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-17T17:12:59+00:00"
 },
 "AWSBackupServiceLinkedRolePolicyForBackupTest":{
  "CreateDate":"2020-05-12T17:37:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticfilesystem:Backup",
      "elasticfilesystem:DescribeTags"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/aws:elasticfilesystem:default-backup":"enabled"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:elasticfilesystem:*:*:file-system/*"
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-12T17:37:29+00:00"
 },
 "AWSBackupServiceRolePolicyForBackup":{
  "CreateDate":"2019-01-10T21:01:28+00:00",
  "DefaultVersionId":"v20",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dynamodb:DescribeTable",
      "dynamodb:CreateBackup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*",
     "Sid":"DynamoDBPermissions"
    },
    {
     "Action":[
      "dynamodb:DescribeBackup",
      "dynamodb:DeleteBackup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*/backup/*",
     "Sid":"DynamoDBBackupResourcePermissions"
    },
    {
     "Action":[
      "rds:AddTagsToResource",
      "rds:ListTagsForResource",
      "rds:DescribeDBSnapshots",
      "rds:CreateDBSnapshot",
      "rds:CopyDBSnapshot",
      "rds:DescribeDBInstances",
      "rds:CreateDBClusterSnapshot",
      "rds:DescribeDBClusters",
      "rds:DescribeDBClusterSnapshots",
      "rds:CopyDBClusterSnapshot",
      "rds:DescribeDBClusterAutomatedBackups"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DynamoDBBackupPermissions"
    },
    {
     "Action":"rds:DeleteDBInstanceAutomatedBackup",
     "Effect":"Allow",
     "Resource":"arn:aws:rds:*:*:auto-backup:*",
     "Sid":"RDSInstanceAutomatedBackupPermissions"
    },
    {
     "Action":[
      "rds:ModifyDBCluster"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:cluster:*"
     ],
     "Sid":"RDSClusterPermissions"
    },
    {
     "Action":"rds:DeleteDBClusterAutomatedBackup",
     "Effect":"Allow",
     "Resource":"arn:aws:rds:*:*:cluster-auto-backup:*",
     "Sid":"RDSClusterBackupPermissions"
    },
    {
     "Action":[
      "rds:ModifyDBInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:db:*"
     ],
     "Sid":"RDSModifyPermissions"
    },
    {
     "Action":[
      "rds:DeleteDBSnapshot",
      "rds:ModifyDBSnapshotAttribute"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:snapshot:awsbackup:*"
     ],
     "Sid":"RDSBackupPermissions"
    },
    {
     "Action":[
      "rds:DeleteDBClusterSnapshot",
      "rds:ModifyDBClusterSnapshotAttribute"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:cluster-snapshot:awsbackup:*"
     ],
     "Sid":"RDSClusterModifyPermissions"
    },
    {
     "Action":[
      "storagegateway:CreateSnapshot",
      "storagegateway:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*/volume/*",
     "Sid":"StorageGatewayPermissions"
    },
    {
     "Action":[
      "ec2:CopySnapshot"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*",
     "Sid":"EBSCopyPermissions"
    },
    {
     "Action":[
      "ec2:CopyImage"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2CopyPermissions"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteSnapshot"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*",
     "Sid":"EBSTagAndDeletePermissions"
    },
    {
     "Action":[
      "ec2:CreateImage",
      "ec2:DeregisterImage",
      "ec2:DescribeSnapshots",
      "ec2:DescribeTags",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceCreditSpecifications",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeElasticGpus",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DescribeSnapshotTierStatus"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2Permissions"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:image/*",
     "Sid":"EC2TagPermissions"
    },
    {
     "Action":[
      "ec2:ModifySnapshotAttribute",
      "ec2:ModifyImageAttribute"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/aws:backup:source-resource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2ModifyPermissions"
    },
    {
     "Action":[
      "ec2:ModifySnapshotTier"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/aws:backup:source-resource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*",
     "Sid":"EBSSnapshotTierPermissions"
    },
    {
     "Action":[
      "backup:DescribeBackupVault",
      "backup:CopyIntoBackupVault"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup:*:*:backup-vault:*",
     "Sid":"BackupVaultPermissions"
    },
    {
     "Action":[
      "backup:CopyFromBackupVault"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"BackupVaultCopyPermissions"
    },
    {
     "Action":[
      "elasticfilesystem:Backup",
      "elasticfilesystem:DescribeTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:elasticfilesystem:*:*:file-system/*",
     "Sid":"EFSPermissions"
    },
    {
     "Action":[
      "ec2:CreateSnapshot",
      "ec2:DeleteSnapshot",
      "ec2:DescribeVolumes",
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*:*:volume/*"
     ],
     "Sid":"EBSResourcePermissions"
    },
    {
     "Action":[
      "kms:Decrypt",
      "kms:GenerateDataKey"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":[
        "dynamodb.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSDynamoDBPermissions"
    },
    {
     "Action":"kms:DescribeKey",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSPermissions"
    },
    {
     "Action":"kms:CreateGrant",
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSCreateGrantPermissions"
    },
    {
     "Action":[
      "kms:GenerateDataKeyWithoutPlaintext"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":[
        "ec2.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:kms:*:*:key/*",
     "Sid":"KMSDataKeyEC2Permissions"
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"GetResourcesPermissions"
    },
    {
     "Action":[
      "ssm:CancelCommand",
      "ssm:GetCommandInvocation"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SSMPermissions"
    },
    {
     "Action":"ssm:SendCommand",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSEC2-CreateVssSnapshot",
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"SSMSendPermissions"
    },
    {
     "Action":"fsx:DescribeBackups",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*",
     "Sid":"FsxBackupPermissions"
    },
    {
     "Action":"fsx:CreateBackup",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:fsx:*:*:file-system/*",
      "arn:aws:fsx:*:*:backup/*",
      "arn:aws:fsx:*:*:volume/*"
     ],
     "Sid":"FsxCreateBackupPermissions"
    },
    {
     "Action":"fsx:DescribeFileSystems",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:file-system/*",
     "Sid":"FsxPermissions"
    },
    {
     "Action":"fsx:DescribeVolumes",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:volume/*",
     "Sid":"FsxVolumePermissions"
    },
    {
     "Action":"fsx:ListTagsForResource",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:fsx:*:*:file-system/*",
      "arn:aws:fsx:*:*:volume/*"
     ],
     "Sid":"FsxListTagsPermissions"
    },
    {
     "Action":"fsx:DeleteBackup",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*",
     "Sid":"FsxDeletePermissions"
    },
    {
     "Action":[
      "fsx:ListTagsForResource",
      "fsx:ManageBackupPrincipalAssociations",
      "fsx:CopyBackup",
      "fsx:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*",
     "Sid":"FsxResourcePermissions"
    },
    {
     "Action":[
      "dynamodb:StartAwsBackupJob",
      "dynamodb:ListTagsOfResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*",
     "Sid":"DynamodbBackupPermissions"
    },
    {
     "Action":[
      "backup-gateway:Backup",
      "backup-gateway:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:vm/*",
     "Sid":"BackupGatewayBackupPermissions"
    },
    {
     "Action":[
      "cloudformation:ListStacks",
      "cloudformation:GetTemplate",
      "cloudformation:DescribeStacks",
      "cloudformation:ListStackResources"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/*/*",
     "Sid":"CloudformationStackPermissions"
    },
    {
     "Action":[
      "redshift:CreateClusterSnapshot",
      "redshift:DescribeClusterSnapshots",
      "redshift:DescribeTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:redshift:*:*:snapshot:*/*",
      "arn:aws:redshift:*:*:cluster:*"
     ],
     "Sid":"RedshiftCreatePermissions"
    },
    {
     "Action":[
      "redshift:DeleteClusterSnapshot"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:redshift:*:*:snapshot:*/*"
     ],
     "Sid":"RedshiftSnapshotPermissions"
    },
    {
     "Action":[
      "redshift:DescribeClusters"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:redshift:*:*:cluster:*"
     ],
     "Sid":"RedshiftPermissions"
    },
    {
     "Action":[
      "redshift:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:redshift:*:*:snapshot:*/*"
     ],
     "Sid":"RedshiftResourcePermissions"
    },
    {
     "Action":[
      "timestream:StartAwsBackupJob",
      "timestream:GetAwsBackupStatus",
      "timestream:ListTables",
      "timestream:ListDatabases",
      "timestream:ListTagsForResource",
      "timestream:DescribeTable",
      "timestream:DescribeDatabase"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:timestream:*:*:database/*"
     ],
     "Sid":"TimestreamResourcePermissions"
    },
    {
     "Action":[
      "timestream:DescribeEndpoints"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"TimestreamEndpointPermissions"
    },
    {
     "Action":[
      "ssm-sap:GetOperation",
      "ssm-sap:ListDatabases"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SSMSAPPermissions"
    },
    {
     "Action":[
      "ssm-sap:BackupDatabase",
      "ssm-sap:UpdateHanaBackupSettings",
      "ssm-sap:GetDatabase",
      "ssm-sap:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm-sap:*:*:*",
     "Sid":"SSMSAPResourcePermissions"
    },
    {
     "Action":[
      "backup:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "aws:PrincipalAccount":"${aws:ResourceAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:backup:*:*:recovery-point:*",
     "Sid":"RecoveryPointTaggingPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-09-27T20:02:34+00:00"
 },
 "AWSBackupServiceRolePolicyForRestores":{
  "CreateDate":"2019-01-12T00:23:54+00:00",
  "DefaultVersionId":"v20",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dynamodb:Scan",
      "dynamodb:Query",
      "dynamodb:UpdateItem",
      "dynamodb:PutItem",
      "dynamodb:GetItem",
      "dynamodb:DeleteItem",
      "dynamodb:BatchWriteItem",
      "dynamodb:DescribeTable"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*",
     "Sid":"DynamoDBPermissions"
    },
    {
     "Action":[
      "dynamodb:RestoreTableFromBackup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*/backup/*",
     "Sid":"DynamoDBBackupResourcePermissions"
    },
    {
     "Action":[
      "ec2:CreateVolume",
      "ec2:DeleteVolume"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*:*:volume/*"
     ],
     "Sid":"EBSPermissions"
    },
    {
     "Action":[
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeSnapshots",
      "ec2:DescribeVolumes",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeSnapshotTierStatus"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2DescribePermissions"
    },
    {
     "Action":[
      "storagegateway:DeleteVolume",
      "storagegateway:DescribeCachediSCSIVolumes",
      "storagegateway:DescribeStorediSCSIVolumes",
      "storagegateway:AddTagsToResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*/volume/*",
     "Sid":"StorageGatewayVolumePermissions"
    },
    {
     "Action":[
      "storagegateway:DescribeGatewayInformation",
      "storagegateway:CreateStorediSCSIVolume",
      "storagegateway:CreateCachediSCSIVolume"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:gateway/*",
     "Sid":"StorageGatewayGatewayPermissions"
    },
    {
     "Action":[
      "storagegateway:ListVolumes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:storagegateway:*:*:*",
     "Sid":"StorageGatewayListPermissions"
    },
    {
     "Action":[
      "rds:DescribeDBInstances",
      "rds:DescribeDBSnapshots",
      "rds:ListTagsForResource",
      "rds:RestoreDBInstanceFromDBSnapshot",
      "rds:DeleteDBInstance",
      "rds:AddTagsToResource",
      "rds:DescribeDBClusters",
      "rds:RestoreDBClusterFromSnapshot",
      "rds:DeleteDBCluster",
      "rds:RestoreDBInstanceToPointInTime",
      "rds:DescribeDBClusterSnapshots",
      "rds:RestoreDBClusterToPointInTime"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RDSPermissions"
    },
    {
     "Action":[
      "elasticfilesystem:Restore",
      "elasticfilesystem:CreateFilesystem",
      "elasticfilesystem:DescribeFilesystems",
      "elasticfilesystem:DeleteFilesystem",
      "elasticfilesystem:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:elasticfilesystem:*:*:file-system/*",
     "Sid":"EFSPermissions"
    },
    {
     "Action":"kms:DescribeKey",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSDescribePermissions"
    },
    {
     "Action":[
      "kms:Decrypt",
      "kms:Encrypt",
      "kms:GenerateDataKey",
      "kms:ReEncryptTo",
      "kms:ReEncryptFrom",
      "kms:GenerateDataKeyWithoutPlaintext"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":[
        "dynamodb.*.amazonaws.com",
        "ec2.*.amazonaws.com",
        "elasticfilesystem.*.amazonaws.com",
        "rds.*.amazonaws.com",
        "redshift.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSPermissions"
    },
    {
     "Action":"kms:CreateGrant",
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSCreateGrantPermissions"
    },
    {
     "Action":[
      "ebs:CompleteSnapshot",
      "ebs:StartSnapshot",
      "ebs:PutSnapshotBlock"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*",
     "Sid":"EBSSnapshotBlockPermissions"
    },
    {
     "Action":[
      "rds:CreateDBInstance"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:rds:*:*:db:*",
     "Sid":"RDSResourcePermissions"
    },
    {
     "Action":[
      "ec2:DeleteSnapshot",
      "ec2:DeleteTags",
      "ec2:RestoreSnapshotTier"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/aws:backup:source-resource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*",
     "Sid":"EC2DeleteAndRestorePermissions"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws:backup:source-resource"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"EC2CreateTagsScopedPermissions"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2RunInstancesPermissions"
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"EC2TerminateInstancesPermissions"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "ForAnyValue:StringLike":{
       "ec2:CreateAction":[
        "RunInstances",
        "CreateVolume"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:volume/*"
     ],
     "Sid":"EC2CreateTagsPermissions"
    },
    {
     "Action":[
      "fsx:CreateFileSystemFromBackup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:fsx:*:*:file-system/*",
      "arn:aws:fsx:*:*:backup/*"
     ],
     "Sid":"FsxPermissions"
    },
    {
     "Action":[
      "fsx:DescribeFileSystems",
      "fsx:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:file-system/*",
     "Sid":"FsxTagPermissions"
    },
    {
     "Action":"fsx:DescribeBackups",
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*",
     "Sid":"FsxBackupPermissions"
    },
    {
     "Action":[
      "fsx:DeleteFileSystem",
      "fsx:UntagResource"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/aws:backup:source-resource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:file-system/*",
     "Sid":"FsxDeletePermissions"
    },
    {
     "Action":[
      "fsx:DescribeVolumes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:volume/*",
     "Sid":"FsxDescribePermissions"
    },
    {
     "Action":[
      "fsx:CreateVolumeFromBackup",
      "fsx:TagResource"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws:backup:source-resource"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:fsx:*:*:volume/*"
     ],
     "Sid":"FsxVolumeTagPermissions"
    },
    {
     "Action":[
      "fsx:CreateVolumeFromBackup",
      "fsx:TagResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:fsx:*:*:storage-virtual-machine/*",
      "arn:aws:fsx:*:*:backup/*",
      "arn:aws:fsx:*:*:volume/*"
     ],
     "Sid":"FsxBackupTagPermissions"
    },
    {
     "Action":[
      "fsx:DeleteVolume",
      "fsx:UntagResource"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/aws:backup:source-resource":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:volume/*",
     "Sid":"FsxVolumePermissions"
    },
    {
     "Action":"ds:DescribeDirectories",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DSPermissions"
    },
    {
     "Action":[
      "dynamodb:RestoreTableFromAwsBackup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/*",
     "Sid":"DynamoDBRestorePermissions"
    },
    {
     "Action":[
      "backup-gateway:Restore"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:backup-gateway:*:*:hypervisor/*",
     "Sid":"GatewayRestorePermissions"
    },
    {
     "Action":[
      "cloudformation:CreateChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:*/*/*",
     "Sid":"CloudformationChangeSetPermissions"
    },
    {
     "Action":[
      "redshift:RestoreFromClusterSnapshot",
      "redshift:RestoreTableFromClusterSnapshot"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:redshift:*:*:snapshot:*/*",
      "arn:aws:redshift:*:*:cluster:*"
     ],
     "Sid":"RedshiftClusterSnapshotPermissions"
    },
    {
     "Action":[
      "redshift:DescribeClusters"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:redshift:*:*:cluster:*"
     ],
     "Sid":"RedshiftClusterPermissions"
    },
    {
     "Action":[
      "redshift:DescribeTableRestoreStatus"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RedshiftTablePermissions"
    },
    {
     "Action":[
      "timestream:StartAwsRestoreJob",
      "timestream:GetAwsRestoreStatus",
      "timestream:ListTables",
      "timestream:ListTagsForResource",
      "timestream:ListDatabases",
      "timestream:DescribeTable",
      "timestream:DescribeDatabase"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:timestream:*:*:database/*"
     ],
     "Sid":"TimestreamResourcePermissions"
    },
    {
     "Action":[
      "timestream:DescribeEndpoints"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"TimestreamEndpointPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-12-15T22:05:32+00:00"
 },
 "AWSBackupServiceRolePolicyForS3Backup":{
  "CreateDate":"2022-02-18T17:40:24+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":"cloudwatch:GetMetricData",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchGetMetricDataPermissions"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:PutTargets",
      "events:DescribeRule",
      "events:EnableRule",
      "events:PutRule",
      "events:RemoveTargets",
      "events:ListTargetsByRule",
      "events:DisableRule"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/AwsBackupManagedRule*"
     ],
     "Sid":"EventBridgePermissionsForAwsBackupManagedRule"
    },
    {
     "Action":"events:ListRules",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EventBridgeListRulesPermissions"
    },
    {
     "Action":[
      "kms:Decrypt",
      "kms:DescribeKey"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":"s3.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KmsPermissions"
    },
    {
     "Action":[
      "s3:GetBucketTagging",
      "s3:GetInventoryConfiguration",
      "s3:ListBucketVersions",
      "s3:ListBucket",
      "s3:GetBucketVersioning",
      "s3:GetBucketLocation",
      "s3:GetBucketAcl",
      "s3:PutInventoryConfiguration",
      "s3:GetBucketNotification",
      "s3:PutBucketNotification"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*",
     "Sid":"S3BucketPermissions"
    },
    {
     "Action":[
      "s3:GetObjectAcl",
      "s3:GetObject",
      "s3:GetObjectVersionTagging",
      "s3:GetObjectVersionAcl",
      "s3:GetObjectTagging",
      "s3:GetObjectVersion"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/*",
     "Sid":"S3ObjectPermissions"
    },
    {
     "Action":"s3:ListAllMyBuckets",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3ListBucketPermissions"
    },
    {
     "Action":[
      "backup:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "aws:PrincipalAccount":"${aws:ResourceAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:backup:*:*:recovery-point:*",
     "Sid":"RecoveryPointTaggingPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-17T17:12:03+00:00"
 },
 "AWSBackupServiceRolePolicyForS3Restore":{
  "CreateDate":"2022-02-18T17:39:37+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:CreateBucket",
      "s3:ListBucketVersions",
      "s3:ListBucket",
      "s3:GetBucketVersioning",
      "s3:GetBucketLocation",
      "s3:PutBucketVersioning",
      "s3:PutBucketOwnershipControls",
      "s3:GetBucketOwnershipControls"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion",
      "s3:DeleteObject",
      "s3:PutObjectVersionAcl",
      "s3:GetObjectVersionAcl",
      "s3:GetObjectTagging",
      "s3:PutObjectTagging",
      "s3:GetObjectAcl",
      "s3:PutObjectAcl",
      "s3:ListMultipartUploadParts",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*/*"
     ]
    },
    {
     "Action":[
      "kms:DescribeKey",
      "kms:GenerateDataKey",
      "kms:Decrypt"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":"s3.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-02-07T00:06:00+00:00"
 },
 "AWSBatchFullAccess":{
  "CreateDate":"2016-12-06T19:35:42+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "batch:*",
      "cloudwatch:GetMetricStatistics",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeVpcs",
      "ec2:DescribeImages",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeLaunchTemplateVersions",
      "ecs:DescribeClusters",
      "ecs:Describe*",
      "ecs:List*",
      "eks:DescribeCluster",
      "eks:ListClusters",
      "logs:Describe*",
      "logs:Get*",
      "logs:TestMetricFilter",
      "logs:FilterLogEvents",
      "iam:ListInstanceProfiles",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSBatchServiceRole",
      "arn:aws:iam::*:role/service-role/AWSBatchServiceRole",
      "arn:aws:iam::*:role/ecsInstanceRole",
      "arn:aws:iam::*:instance-profile/ecsInstanceRole",
      "arn:aws:iam::*:role/iaws-ec2-spot-fleet-role",
      "arn:aws:iam::*:role/aws-ec2-spot-fleet-role",
      "arn:aws:iam::*:role/AWSBatchJobRole*"
     ]
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"batch.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*Batch*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-10-24T16:09:09+00:00"
 },
 "AWSBatchServiceEventTargetRole":{
  "CreateDate":"2018-02-28T22:31:13+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "batch:SubmitJob"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-02-28T22:31:13+00:00"
 },
 "AWSBatchServiceRole":{
  "CreateDate":"2016-12-06T19:36:24+00:00",
  "DefaultVersionId":"v13",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeImages",
      "ec2:DescribeImageAttribute",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DescribeSpotFleetInstances",
      "ec2:DescribeSpotFleetRequests",
      "ec2:DescribeSpotPriceHistory",
      "ec2:DescribeSpotFleetRequestHistory",
      "ec2:DescribeVpcClassicLink",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:CreateLaunchTemplate",
      "ec2:DeleteLaunchTemplate",
      "ec2:RequestSpotFleet",
      "ec2:CancelSpotFleetRequests",
      "ec2:ModifySpotFleetRequest",
      "ec2:TerminateInstances",
      "ec2:RunInstances",
      "autoscaling:DescribeAccountLimits",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeLaunchConfigurations",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:CreateLaunchConfiguration",
      "autoscaling:CreateAutoScalingGroup",
      "autoscaling:UpdateAutoScalingGroup",
      "autoscaling:SetDesiredCapacity",
      "autoscaling:DeleteLaunchConfiguration",
      "autoscaling:DeleteAutoScalingGroup",
      "autoscaling:CreateOrUpdateTags",
      "autoscaling:SuspendProcesses",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:TerminateInstanceInAutoScalingGroup",
      "ecs:DescribeClusters",
      "ecs:DescribeContainerInstances",
      "ecs:DescribeTaskDefinition",
      "ecs:DescribeTasks",
      "ecs:ListAccountSettings",
      "ecs:ListClusters",
      "ecs:ListContainerInstances",
      "ecs:ListTaskDefinitionFamilies",
      "ecs:ListTaskDefinitions",
      "ecs:ListTasks",
      "ecs:CreateCluster",
      "ecs:DeleteCluster",
      "ecs:RegisterTaskDefinition",
      "ecs:DeregisterTaskDefinition",
      "ecs:RunTask",
      "ecs:StartTask",
      "ecs:StopTask",
      "ecs:UpdateContainerAgent",
      "ecs:DeregisterContainerInstance",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:DescribeLogGroups",
      "iam:GetInstanceProfile",
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSBatchPolicyStatement1"
    },
    {
     "Action":"ecs:TagResource",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ecs:*:*:task/*_Batch_*"
     ],
     "Sid":"AWSBatchPolicyStatement2"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn",
        "ecs-tasks.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AWSBatchPolicyStatement3"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "spot.amazonaws.com",
        "spotfleet.amazonaws.com",
        "autoscaling.amazonaws.com",
        "ecs.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSBatchPolicyStatement4"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"RunInstances"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AWSBatchPolicyStatement5"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-12-05T18:49:44+00:00"
 },
 "AWSBillingConductorFullAccess":{
  "CreateDate":"2022-04-13T18:02:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "billingconductor:*",
      "organizations:ListAccounts",
      "pricing:DescribeServices"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-13T18:02:29+00:00"
 },
 "AWSBillingConductorReadOnlyAccess":{
  "CreateDate":"2022-04-13T18:02:59+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "billingconductor:List*",
      "organizations:ListAccounts",
      "pricing:DescribeServices"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-13T18:02:59+00:00"
 },
 "AWSBillingReadOnlyAccess":{
  "CreateDate":"2020-08-27T20:08:51+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "account:GetAccountInformation",
      "aws-portal:ViewBilling",
      "billing:GetBillingData",
      "billing:GetBillingDetails",
      "billing:GetBillingNotifications",
      "billing:GetBillingPreferences",
      "billing:GetCredits",
      "billing:GetContractInformation",
      "billing:GetIAMAccessPreference",
      "billing:GetSellerOfRecord",
      "billing:ListBillingViews",
      "budgets:ViewBudget",
      "budgets:DescribeBudgetActionsForBudget",
      "budgets:DescribeBudgetAction",
      "budgets:DescribeBudgetActionsForAccount",
      "budgets:DescribeBudgetActionHistories",
      "ce:DescribeCostCategoryDefinition",
      "ce:GetCostAndUsage",
      "ce:ListCostCategoryDefinitions",
      "ce:ListTagsForResource",
      "ce:ListCostAllocationTags",
      "ce:ListCostAllocationTagBackfillHistory",
      "ce:GetTags",
      "ce:GetDimensionValues",
      "consolidatedbilling:ListLinkedAccounts",
      "consolidatedbilling:GetAccountBillingRole",
      "cur:GetClassicReport",
      "cur:GetClassicReportPreferences",
      "cur:GetUsageReport",
      "cur:DescribeReportDefinitions",
      "freetier:GetFreeTierAlertPreference",
      "freetier:GetFreeTierUsage",
      "invoicing:GetInvoiceEmailDeliveryPreferences",
      "invoicing:GetInvoicePDF",
      "invoicing:ListInvoiceSummaries",
      "payments:GetPaymentInstrument",
      "payments:GetPaymentStatus",
      "payments:ListPaymentPreferences",
      "payments:ListTagsForResource",
      "payments:ListPaymentInstruments",
      "purchase-orders:GetPurchaseOrder",
      "purchase-orders:ViewPurchaseOrders",
      "purchase-orders:ListPurchaseOrderInvoices",
      "purchase-orders:ListPurchaseOrders",
      "purchase-orders:ListTagsForResource",
      "sustainability:GetCarbonFootprintSummary",
      "tax:GetTaxRegistrationDocument",
      "tax:GetTaxInheritance",
      "tax:ListTaxRegistrations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor0"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-23T23:23:30+00:00"
 },
 "AWSBudgetsActionsWithAWSResourceControlAccess":{
  "CreateDate":"2020-10-15T17:19:12+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "budgets:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-portal:ViewBilling"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"budgets.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-portal:ModifyBilling",
      "ec2:DescribeInstances",
      "iam:ListGroups",
      "iam:ListPolicies",
      "iam:ListRoles",
      "iam:ListUsers",
      "organizations:ListAccounts",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListPolicies",
      "organizations:ListRoots",
      "rds:DescribeDBInstances",
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-15T17:19:12+00:00"
 },
 "AWSBudgetsActions_RolePolicyForResourceAdministrationWithSSM":{
  "CreateDate":"2022-05-25T19:03:30+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstanceStatus",
      "ec2:StartInstances",
      "ec2:StopInstances",
      "rds:DescribeDBInstances",
      "rds:StartDBInstance",
      "rds:StopDBInstance"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:automation-definition/AWS-StartEC2Instance:*",
      "arn:aws:ssm:*:*:automation-definition/AWS-StopEC2Instance:*",
      "arn:aws:ssm:*:*:automation-definition/AWS-StartRdsInstance:*",
      "arn:aws:ssm:*:*:automation-definition/AWS-StopRdsInstance:*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-25T19:03:30+00:00"
 },
 "AWSBudgetsReadOnlyAccess":{
  "CreateDate":"2020-10-15T17:18:28+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-portal:ViewBilling",
      "budgets:ViewBudget",
      "budgets:Describe*",
      "budgets:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSBudgetsReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-17T17:41:25+00:00"
 },
 "AWSBugBustFullAccess":{
  "CreateDate":"2021-06-24T07:03:26+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeguru-reviewer:DescribeCodeReview",
      "codeguru-reviewer:ListRecommendations",
      "codeguru-reviewer:ListCodeReviews"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeGuruReviewerPermission"
    },
    {
     "Action":[
      "codeguru-profiler:ListProfilingGroups",
      "codeguru-profiler:DescribeProfilingGroup"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeGuruProfilerPermission"
    },
    {
     "Action":[
      "bugbust:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSBugBustFullAccess"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"bugbust.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/bugbust.amazonaws.com/AWSServiceRoleForBugBust",
     "Sid":"AWSBugBustSLRCreation"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-22T20:04:29+00:00"
 },
 "AWSBugBustPlayerAccess":{
  "CreateDate":"2021-06-24T07:15:00+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeguru-reviewer:DescribeCodeReview",
      "codeguru-reviewer:ListRecommendations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeGuruReviewerPermission"
    },
    {
     "Action":[
      "codeguru-profiler:DescribeProfilingGroup"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeGuruProfilerPermission"
    },
    {
     "Action":[
      "bugbust:ListBugs",
      "bugbust:ListProfilingGroups",
      "bugbust:JoinEvent",
      "bugbust:GetEvent",
      "bugbust:ListEvents",
      "bugbust:GetJoinEventStatus",
      "bugbust:ListEventScores",
      "bugbust:ListEventParticipants",
      "bugbust:UpdateWorkItem",
      "bugbust:ListPullRequests"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSBugBustPlayerAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-24T07:15:00+00:00"
 },
 "AWSBugBustServiceRolePolicy":{
  "CreateDate":"2021-06-24T06:59:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeguru-reviewer:ListRecommendations",
      "codeguru-reviewer:UntagResource",
      "codeguru-reviewer:DescribeCodeReview"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/bugbust":"enabled"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-24T06:59:05+00:00"
 },
 "AWSCertificateManagerFullAccess":{
  "CreateDate":"2016-01-21T17:02:36+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"acm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/acm.amazonaws.com/AWSServiceRoleForCertificateManager*"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus",
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/acm.amazonaws.com/AWSServiceRoleForCertificateManager*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-17T22:18:28+00:00"
 },
 "AWSCertificateManagerPrivateCAAuditor":{
  "CreateDate":"2018-10-23T16:51:08+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:CreateCertificateAuthorityAuditReport",
      "acm-pca:DescribeCertificateAuthority",
      "acm-pca:DescribeCertificateAuthorityAuditReport",
      "acm-pca:GetCertificateAuthorityCsr",
      "acm-pca:GetCertificateAuthorityCertificate",
      "acm-pca:GetCertificate",
      "acm-pca:GetPolicy",
      "acm-pca:ListPermissions",
      "acm-pca:ListTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-17T22:54:12+00:00"
 },
 "AWSCertificateManagerPrivateCAFullAccess":{
  "CreateDate":"2018-10-23T16:54:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-10-23T16:54:50+00:00"
 },
 "AWSCertificateManagerPrivateCAPrivilegedUser":{
  "CreateDate":"2019-06-20T17:43:13+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:IssueCertificate"
     ],
     "Condition":{
      "StringLike":{
       "acm-pca:TemplateArn":[
        "arn:aws:acm-pca:::template/*CACertificate*/V*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:IssueCertificate"
     ],
     "Condition":{
      "StringNotLike":{
       "acm-pca:TemplateArn":[
        "arn:aws:acm-pca:::template/*CACertificate*/V*"
       ]
      }
     },
     "Effect":"Deny",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:RevokeCertificate",
      "acm-pca:GetCertificate",
      "acm-pca:ListPermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-20T17:43:13+00:00"
 },
 "AWSCertificateManagerPrivateCAReadOnly":{
  "CreateDate":"2018-10-23T16:57:04+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":{
    "Action":[
     "acm-pca:DescribeCertificateAuthority",
     "acm-pca:DescribeCertificateAuthorityAuditReport",
     "acm-pca:ListCertificateAuthorities",
     "acm-pca:GetCertificateAuthorityCsr",
     "acm-pca:GetCertificateAuthorityCertificate",
     "acm-pca:GetCertificate",
     "acm-pca:GetPolicy",
     "acm-pca:ListPermissions",
     "acm-pca:ListTags"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-17T22:54:22+00:00"
 },
 "AWSCertificateManagerPrivateCAUser":{
  "CreateDate":"2018-10-23T16:53:33+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:IssueCertificate"
     ],
     "Condition":{
      "StringLike":{
       "acm-pca:TemplateArn":[
        "arn:aws:acm-pca:::template/EndEntityCertificate/V*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:IssueCertificate"
     ],
     "Condition":{
      "StringNotLike":{
       "acm-pca:TemplateArn":[
        "arn:aws:acm-pca:::template/EndEntityCertificate/V*"
       ]
      }
     },
     "Effect":"Deny",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:RevokeCertificate",
      "acm-pca:GetCertificate",
      "acm-pca:ListPermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-20T17:42:37+00:00"
 },
 "AWSCertificateManagerReadOnly":{
  "CreateDate":"2016-01-21T17:07:33+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":{
    "Action":[
     "acm:DescribeCertificate",
     "acm:ListCertificates",
     "acm:GetCertificate",
     "acm:ListTagsForCertificate",
     "acm:GetAccountConfiguration"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-03-15T16:25:21+00:00"
 },
 "AWSChatbotServiceLinkedRolePolicy":{
  "CreateDate":"2019-11-18T16:39:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sns:ListSubscriptionsByTopic",
      "sns:ListTopics",
      "sns:Unsubscribe",
      "sns:Subscribe",
      "sns:ListSubscriptions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:PutLogEvents",
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/chatbot/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-18T16:39:50+00:00"
 },
 "AWSCleanRoomsFullAccess":{
  "CreateDate":"2023-01-12T16:10:54+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cleanrooms:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CleanRoomsAccess"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"cleanrooms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/service-role/*cleanrooms*",
     "Sid":"PassServiceRole"
    },
    {
     "Action":[
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListRolesToPickServiceRole"
    },
    {
     "Action":[
      "iam:GetRole",
      "iam:ListRolePolicies",
      "iam:ListAttachedRolePolicies"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/service-role/*cleanrooms*",
     "Sid":"GetRoleAndListRolePoliciesToInspectServiceRole"
    },
    {
     "Action":[
      "iam:ListPolicies"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListPoliciesToInspectServiceRolePolicy"
    },
    {
     "Action":[
      "iam:GetPolicy",
      "iam:GetPolicyVersion"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:policy/*cleanrooms*",
     "Sid":"GetPolicyToInspectServiceRolePolicy"
    },
    {
     "Action":[
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:GetTable",
      "glue:GetTables",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:GetSchema",
      "glue:GetSchemaVersion",
      "glue:BatchGetPartition"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleDisplayTables"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsolePickQueryResultsBucketListAll"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListBucketVersions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::cleanrooms-queryresults*",
     "Sid":"SetQueryResultsBucket"
    },
    {
     "Action":[
      "s3:ListBucket",
      "s3:PutObject"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"cleanrooms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::cleanrooms-queryresults*",
     "Sid":"WriteQueryResults"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::cleanrooms-queryresults*",
     "Sid":"ConsoleDisplayQueryResults"
    },
    {
     "Action":[
      "logs:CreateLogDelivery",
      "logs:GetLogDelivery",
      "logs:UpdateLogDelivery",
      "logs:DeleteLogDelivery",
      "logs:ListLogDeliveries"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"cleanrooms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EstablishLogDeliveries"
    },
    {
     "Action":[
      "logs:DescribeLogGroups"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"cleanrooms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SetupLogGroupsDescribe"
    },
    {
     "Action":[
      "logs:CreateLogGroup"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"cleanrooms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/cleanrooms*",
     "Sid":"SetupLogGroupsCreate"
    },
    {
     "Action":[
      "logs:DescribeResourcePolicies",
      "logs:PutResourcePolicy"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"cleanrooms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SetupLogGroupsResourcePolicy"
    },
    {
     "Action":[
      "logs:StartQuery"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/cleanrooms*",
     "Sid":"ConsoleLogSummaryQueryLogs"
    },
    {
     "Action":[
      "logs:GetQueryResults"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleLogSummaryObtainLogs"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-21T15:35:13+00:00"
 },
 "AWSCleanRoomsFullAccessNoQuerying":{
  "CreateDate":"2023-01-12T16:12:31+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cleanrooms:BatchGetCollaborationAnalysisTemplate",
      "cleanrooms:BatchGetSchema",
      "cleanrooms:BatchGetSchemaAnalysisRule",
      "cleanrooms:CreateAnalysisTemplate",
      "cleanrooms:CreateCollaboration",
      "cleanrooms:CreateConfiguredTable",
      "cleanrooms:CreateConfiguredTableAnalysisRule",
      "cleanrooms:CreateConfiguredTableAssociation",
      "cleanrooms:CreateMembership",
      "cleanrooms:DeleteAnalysisTemplate",
      "cleanrooms:DeleteCollaboration",
      "cleanrooms:DeleteConfiguredTable",
      "cleanrooms:DeleteConfiguredTableAnalysisRule",
      "cleanrooms:DeleteConfiguredTableAssociation",
      "cleanrooms:DeleteMember",
      "cleanrooms:DeleteMembership",
      "cleanrooms:GetAnalysisTemplate",
      "cleanrooms:GetCollaborationAnalysisTemplate",
      "cleanrooms:GetCollaboration",
      "cleanrooms:GetConfiguredTable",
      "cleanrooms:GetConfiguredTableAnalysisRule",
      "cleanrooms:GetConfiguredTableAssociation",
      "cleanrooms:GetMembership",
      "cleanrooms:GetProtectedQuery",
      "cleanrooms:GetSchema",
      "cleanrooms:GetSchemaAnalysisRule",
      "cleanrooms:ListAnalysisTemplates",
      "cleanrooms:ListCollaborationAnalysisTemplates",
      "cleanrooms:ListCollaborations",
      "cleanrooms:ListConfiguredTableAssociations",
      "cleanrooms:ListConfiguredTables",
      "cleanrooms:ListMembers",
      "cleanrooms:ListMemberships",
      "cleanrooms:ListProtectedQueries",
      "cleanrooms:ListSchemas",
      "cleanrooms:UpdateAnalysisTemplate",
      "cleanrooms:UpdateCollaboration",
      "cleanrooms:UpdateConfiguredTable",
      "cleanrooms:UpdateConfiguredTableAnalysisRule",
      "cleanrooms:UpdateConfiguredTableAssociation",
      "cleanrooms:UpdateMembership",
      "cleanrooms:ListTagsForResource",
      "cleanrooms:UntagResource",
      "cleanrooms:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CleanRoomsAccess"
    },
    {
     "Action":[
      "cleanrooms:StartProtectedQuery",
      "cleanrooms:UpdateProtectedQuery"
     ],
     "Effect":"Deny",
     "Resource":"*",
     "Sid":"CleanRoomsNoQuerying"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"cleanrooms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/service-role/*cleanrooms*",
     "Sid":"PassServiceRole"
    },
    {
     "Action":[
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListRolesToPickServiceRole"
    },
    {
     "Action":[
      "iam:GetRole",
      "iam:ListRolePolicies",
      "iam:ListAttachedRolePolicies"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/service-role/*cleanrooms*",
     "Sid":"GetRoleAndListRolePoliciesToInspectServiceRole"
    },
    {
     "Action":[
      "iam:ListPolicies"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListPoliciesToInspectServiceRolePolicy"
    },
    {
     "Action":[
      "iam:GetPolicy",
      "iam:GetPolicyVersion"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:policy/*cleanrooms*",
     "Sid":"GetPolicyToInspectServiceRolePolicy"
    },
    {
     "Action":[
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:GetTable",
      "glue:GetTables",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:GetSchema",
      "glue:GetSchemaVersion",
      "glue:BatchGetPartition"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleDisplayTables"
    },
    {
     "Action":[
      "logs:CreateLogDelivery",
      "logs:GetLogDelivery",
      "logs:UpdateLogDelivery",
      "logs:DeleteLogDelivery",
      "logs:ListLogDeliveries"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"cleanrooms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EstablishLogDeliveries"
    },
    {
     "Action":[
      "logs:DescribeLogGroups"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"cleanrooms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SetupLogGroupsDescribe"
    },
    {
     "Action":[
      "logs:CreateLogGroup"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"cleanrooms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/cleanrooms*",
     "Sid":"SetupLogGroupsCreate"
    },
    {
     "Action":[
      "logs:DescribeResourcePolicies",
      "logs:PutResourcePolicy"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"cleanrooms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SetupLogGroupsResourcePolicy"
    },
    {
     "Action":[
      "logs:StartQuery"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/cleanrooms*",
     "Sid":"ConsoleLogSummaryQueryLogs"
    },
    {
     "Action":[
      "logs:GetQueryResults"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleLogSummaryObtainLogs"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-14T18:31:21+00:00"
 },
 "AWSCleanRoomsMLFullAccess":{
  "CreateDate":"2023-11-29T21:02:06+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cleanrooms-ml:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CleanRoomsMLFullAccess"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"cleanrooms-ml.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/cleanrooms-ml*"
     ],
     "Sid":"PassServiceRole"
    },
    {
     "Action":[
      "cleanrooms:GetCollaboration",
      "cleanrooms:GetConfiguredAudienceModelAssociation",
      "cleanrooms:GetMembership",
      "cleanrooms:ListAnalysisTemplates",
      "cleanrooms:ListCollaborationAnalysisTemplates",
      "cleanrooms:ListCollaborationConfiguredAudienceModelAssociations",
      "cleanrooms:ListCollaborations",
      "cleanrooms:ListConfiguredTableAssociations",
      "cleanrooms:ListConfiguredTables",
      "cleanrooms:ListMembers",
      "cleanrooms:ListMemberships",
      "cleanrooms:ListProtectedQueries",
      "cleanrooms:ListSchemas",
      "cleanrooms:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CleanRoomsConsoleNavigation"
    },
    {
     "Action":[
      "cleanrooms:ListMembers"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cleanrooms-ml.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CollaborationMembershipCheck"
    },
    {
     "Action":[
      "cleanrooms:CreateConfiguredAudienceModelAssociation"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AssociateModels"
    },
    {
     "Action":[
      "cleanrooms:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cleanrooms:*:*:membership/*/configuredaudiencemodelassociation/*",
     "Sid":"TagAssociations"
    },
    {
     "Action":[
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListRolesToPickServiceRole"
    },
    {
     "Action":[
      "iam:GetRole",
      "iam:ListRolePolicies",
      "iam:ListAttachedRolePolicies"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/cleanrooms-ml*",
      "arn:aws:iam::*:role/role/cleanrooms-ml*"
     ],
     "Sid":"GetRoleAndListRolePoliciesToInspectServiceRole"
    },
    {
     "Action":[
      "iam:ListPolicies"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListPoliciesToInspectServiceRolePolicy"
    },
    {
     "Action":[
      "iam:GetPolicy",
      "iam:GetPolicyVersion"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:policy/*cleanroomsml*",
     "Sid":"GetPolicyToInspectServiceRolePolicy"
    },
    {
     "Action":[
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:GetTable",
      "glue:GetTables",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:GetSchema",
      "glue:GetSchemaVersion",
      "glue:BatchGetPartition"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleDisplayTables"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsolePickOutputBucket"
    },
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*cleanrooms-ml*",
     "Sid":"ConsolePickS3Location"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-29T21:02:06+00:00"
 },
 "AWSCleanRoomsMLReadOnlyAccess":{
  "CreateDate":"2023-11-29T20:55:31+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cleanrooms:GetCollaboration",
      "cleanrooms:GetConfiguredAudienceModelAssociation",
      "cleanrooms:GetMembership",
      "cleanrooms:ListAnalysisTemplates",
      "cleanrooms:ListCollaborationAnalysisTemplates",
      "cleanrooms:ListCollaborationConfiguredAudienceModelAssociations",
      "cleanrooms:ListCollaborations",
      "cleanrooms:ListConfiguredTableAssociations",
      "cleanrooms:ListConfiguredTables",
      "cleanrooms:ListMembers",
      "cleanrooms:ListMemberships",
      "cleanrooms:ListProtectedQueries",
      "cleanrooms:ListSchemas",
      "cleanrooms:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CleanRoomsConsoleNavigation"
    },
    {
     "Action":[
      "cleanrooms-ml:Get*",
      "cleanrooms-ml:List*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CleanRoomsMLRead"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-29T20:55:31+00:00"
 },
 "AWSCleanRoomsReadOnlyAccess":{
  "CreateDate":"2023-01-12T16:10:48+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cleanrooms:BatchGet*",
      "cleanrooms:Get*",
      "cleanrooms:List*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CleanRoomsRead"
    },
    {
     "Action":[
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:GetTable",
      "glue:GetTables",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:GetSchema",
      "glue:GetSchemaVersion",
      "glue:BatchGetPartition"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleDisplayTables"
    },
    {
     "Action":[
      "logs:StartQuery"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/cleanrooms*",
     "Sid":"ConsoleLogSummaryQueryLogs"
    },
    {
     "Action":[
      "logs:GetQueryResults"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleLogSummaryObtainLogs"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-01-12T16:10:48+00:00"
 },
 "AWSCloud9Administrator":{
  "CreateDate":"2017-11-30T16:17:28+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloud9:*",
      "iam:GetUser",
      "iam:ListUsers",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "ec2:DescribeInstanceTypeOfferings",
      "ec2:DescribeRouteTables"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"cloud9.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:StartSession",
      "ssm:GetConnectionStatus"
     ],
     "Condition":{
      "StringEquals":{
       "aws:CalledViaFirst":"cloud9.amazonaws.com"
      },
      "StringLike":{
       "ssm:resourceTag/aws:cloud9:environment":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ssm:StartSession"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-10-11T12:59:29+00:00"
 },
 "AWSCloud9EnvironmentMember":{
  "CreateDate":"2017-11-30T16:18:28+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloud9:GetUserSettings",
      "cloud9:UpdateUserSettings",
      "iam:GetUser",
      "iam:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloud9:DescribeEnvironmentMemberships"
     ],
     "Condition":{
      "Null":{
       "cloud9:EnvironmentId":"true",
       "cloud9:UserArn":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ssm:StartSession",
      "ssm:GetConnectionStatus"
     ],
     "Condition":{
      "StringEquals":{
       "aws:CalledViaFirst":"cloud9.amazonaws.com"
      },
      "StringLike":{
       "ssm:resourceTag/aws:cloud9:environment":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ssm:StartSession"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-10-11T12:13:40+00:00"
 },
 "AWSCloud9SSMInstanceProfile":{
  "CreateDate":"2020-05-14T11:40:49+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssmmessages:CreateControlChannel",
      "ssmmessages:CreateDataChannel",
      "ssmmessages:OpenControlChannel",
      "ssmmessages:OpenDataChannel",
      "ssm:UpdateInstanceInformation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-14T11:40:49+00:00"
 },
 "AWSCloud9ServiceRolePolicy":{
  "CreateDate":"2017-11-30T13:44:08+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:RunInstances",
      "ec2:CreateSecurityGroup",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceStatus",
      "cloudformation:CreateStack",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStackResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:TerminateInstances",
      "ec2:DeleteSecurityGroup",
      "ec2:AuthorizeSecurityGroupIngress"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudformation:DeleteStack"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/aws-cloud9-*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringLike":{
       "aws:RequestTag/Name":"aws-cloud9-*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:security-group/*"
     ]
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-name":"aws-cloud9-*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:license-manager:*:*:license-configuration:*"
     ]
    },
    {
     "Action":[
      "iam:ListInstanceProfiles",
      "iam:GetInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:instance-profile/cloud9/*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSCloud9SSMAccessRole"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-17T14:06:15+00:00"
 },
 "AWSCloud9User":{
  "CreateDate":"2017-11-30T16:16:17+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloud9:UpdateUserSettings",
      "cloud9:GetUserSettings",
      "iam:GetUser",
      "iam:ListUsers",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "ec2:DescribeInstanceTypeOfferings",
      "ec2:DescribeRouteTables"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloud9:CreateEnvironmentEC2",
      "cloud9:CreateEnvironmentSSH"
     ],
     "Condition":{
      "Null":{
       "cloud9:OwnerArn":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloud9:GetUserPublicKey"
     ],
     "Condition":{
      "Null":{
       "cloud9:UserArn":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloud9:DescribeEnvironmentMemberships"
     ],
     "Condition":{
      "Null":{
       "cloud9:EnvironmentId":"true",
       "cloud9:UserArn":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"cloud9.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:StartSession",
      "ssm:GetConnectionStatus"
     ],
     "Condition":{
      "StringEquals":{
       "aws:CalledViaFirst":"cloud9.amazonaws.com"
      },
      "StringLike":{
       "ssm:resourceTag/aws:cloud9:environment":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ssm:StartSession"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-10-11T13:24:10+00:00"
 },
 "AWSCloudFormationFullAccess":{
  "CreateDate":"2019-07-26T21:50:35+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-07-26T21:50:35+00:00"
 },
 "AWSCloudFormationReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:39:49+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:Describe*",
      "cloudformation:EstimateTemplateCost",
      "cloudformation:Get*",
      "cloudformation:List*",
      "cloudformation:ValidateTemplate",
      "cloudformation:Detect*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-13T17:40:07+00:00"
 },
 "AWSCloudFrontLogger":{
  "CreateDate":"2018-06-12T20:15:23+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/cloudfront/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-22T19:33:51+00:00"
 },
 "AWSCloudHSMFullAccess":{
  "CreateDate":"2015-02-06T18:39:51+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"cloudhsm:*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:39:51+00:00"
 },
 "AWSCloudHSMReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:39:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudhsm:Get*",
      "cloudhsm:List*",
      "cloudhsm:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:39:52+00:00"
 },
 "AWSCloudHSMRole":{
  "CreateDate":"2015-02-06T18:41:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:CreateTags",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaceAttribute",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DetachNetworkInterface"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:41:23+00:00"
 },
 "AWSCloudMapDiscoverInstanceAccess":{
  "CreateDate":"2018-11-29T00:02:42+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "servicediscovery:DiscoverInstances",
      "servicediscovery:DiscoverInstancesRevision"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-09-20T21:48:09+00:00"
 },
 "AWSCloudMapFullAccess":{
  "CreateDate":"2018-11-28T23:57:31+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "route53:GetHostedZone",
      "route53:ListHostedZonesByName",
      "route53:CreateHostedZone",
      "route53:DeleteHostedZone",
      "route53:ChangeResourceRecordSets",
      "route53:CreateHealthCheck",
      "route53:GetHealthCheck",
      "route53:DeleteHealthCheck",
      "route53:UpdateHealthCheck",
      "ec2:DescribeVpcs",
      "ec2:DescribeRegions",
      "ec2:DescribeInstances",
      "servicediscovery:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-29T19:15:35+00:00"
 },
 "AWSCloudMapReadOnlyAccess":{
  "CreateDate":"2018-11-28T23:45:26+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "servicediscovery:Get*",
      "servicediscovery:List*",
      "servicediscovery:DiscoverInstances",
      "servicediscovery:DiscoverInstancesRevision"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-09-20T21:47:45+00:00"
 },
 "AWSCloudMapRegisterInstanceAccess":{
  "CreateDate":"2018-11-29T00:04:57+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "route53:GetHostedZone",
      "route53:ListHostedZonesByName",
      "route53:ChangeResourceRecordSets",
      "route53:CreateHealthCheck",
      "route53:GetHealthCheck",
      "route53:DeleteHealthCheck",
      "route53:UpdateHealthCheck",
      "servicediscovery:Get*",
      "servicediscovery:List*",
      "servicediscovery:RegisterInstance",
      "servicediscovery:DeregisterInstance",
      "servicediscovery:DiscoverInstances",
      "servicediscovery:DiscoverInstancesRevision",
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-09-20T21:47:06+00:00"
 },
 "AWSCloudShellFullAccess":{
  "CreateDate":"2020-12-15T18:07:44+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudshell:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T18:07:44+00:00"
 },
 "AWSCloudTrail_FullAccess":{
  "CreateDate":"2020-10-08T23:41:15+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sns:AddPermission",
      "sns:CreateTopic",
      "sns:SetTopicAttributes",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sns:*:*:aws-cloudtrail-logs*"
     ]
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:PutBucketPolicy",
      "s3:PutBucketPublicAccessBlock"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-cloudtrail-logs*"
     ]
    },
    {
     "Action":[
      "s3:ListAllMyBuckets",
      "s3:GetBucketLocation",
      "s3:GetBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"cloudtrail:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:aws-cloudtrail-logs*"
     ]
    },
    {
     "Action":[
      "iam:ListRoles",
      "iam:GetRolePolicy",
      "iam:GetUser"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"cloudtrail.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:CreateKey",
      "kms:CreateAlias",
      "kms:ListKeys",
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lambda:ListFunctions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dynamodb:ListGlobalTables",
      "dynamodb:ListTables"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-02-22T19:01:00+00:00"
 },
 "AWSCloudTrail_ReadOnlyAccess":{
  "CreateDate":"2022-06-14T17:19:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudtrail:Get*",
      "cloudtrail:Describe*",
      "cloudtrail:List*",
      "cloudtrail:LookupEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-14T17:19:05+00:00"
 },
 "AWSCloudWatchAlarms_ActionSSMIncidentsServiceRolePolicy":{
  "CreateDate":"2021-04-27T13:30:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"ssm-incidents:StartIncident",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"StartIncidentPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-27T13:30:52+00:00"
 },
 "AWSCodeArtifactAdminAccess":{
  "CreateDate":"2020-06-16T23:53:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeartifact:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"sts:GetServiceBearerToken",
     "Condition":{
      "StringEquals":{
       "sts:AWSServiceName":"codeartifact.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-16T23:53:23+00:00"
 },
 "AWSCodeArtifactReadOnlyAccess":{
  "CreateDate":"2020-06-25T21:23:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codeartifact:Describe*",
      "codeartifact:Get*",
      "codeartifact:List*",
      "codeartifact:ReadFromRepository"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"sts:GetServiceBearerToken",
     "Condition":{
      "StringEquals":{
       "sts:AWSServiceName":"codeartifact.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-25T21:23:52+00:00"
 },
 "AWSCodeBuildAdminAccess":{
  "CreateDate":"2016-12-01T19:04:44+00:00",
  "DefaultVersionId":"v14",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codebuild:*",
      "codecommit:GetBranch",
      "codecommit:GetCommit",
      "codecommit:GetRepository",
      "codecommit:ListBranches",
      "codecommit:ListRepositories",
      "cloudwatch:GetMetricStatistics",
      "ec2:DescribeVpcs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ecr:DescribeRepositories",
      "ecr:ListImages",
      "elasticfilesystem:DescribeFileSystems",
      "events:DeleteRule",
      "events:DescribeRule",
      "events:DisableRule",
      "events:EnableRule",
      "events:ListTargetsByRule",
      "events:ListRuleNamesByTarget",
      "events:PutRule",
      "events:PutTargets",
      "events:RemoveTargets",
      "logs:GetLogEvents",
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSServicesAccess"
    },
    {
     "Action":[
      "logs:DeleteLogGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/codebuild/*:log-stream:*",
     "Sid":"CWLDeleteLogGroupAccess"
    },
    {
     "Action":[
      "ssm:PutParameter"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/CodeBuild/*",
     "Sid":"SSMParameterWriteAccess"
    },
    {
     "Action":[
      "ssm:StartSession"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ecs:*:*:task/*/*",
     "Sid":"SSMStartSessionAccess"
    },
    {
     "Action":[
      "codestar-connections:CreateConnection",
      "codestar-connections:DeleteConnection",
      "codestar-connections:UpdateConnectionInstallation",
      "codestar-connections:TagResource",
      "codestar-connections:UntagResource",
      "codestar-connections:ListConnections",
      "codestar-connections:ListInstallationTargets",
      "codestar-connections:ListTagsForResource",
      "codestar-connections:GetConnection",
      "codestar-connections:GetIndividualAccessToken",
      "codestar-connections:GetInstallationUrl",
      "codestar-connections:PassConnection",
      "codestar-connections:StartOAuthHandshake",
      "codestar-connections:UseConnection"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:codestar-connections:*:*:connection/*",
      "arn:aws:codeconnections:*:*:connection/*"
     ],
     "Sid":"CodeStarConnectionsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:DeleteNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codebuild:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:SetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codestar-notifications*",
     "Sid":"CodeStarNotificationsSNSTopicCreateAccess"
    },
    {
     "Action":[
      "sns:ListTopics",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSTopicListAccess"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations",
      "chatbot:ListMicrosoftTeamsChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-02T01:45:44+00:00"
 },
 "AWSCodeBuildDeveloperAccess":{
  "CreateDate":"2016-12-01T19:02:32+00:00",
  "DefaultVersionId":"v15",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codebuild:StartBuild",
      "codebuild:StopBuild",
      "codebuild:StartBuildBatch",
      "codebuild:StopBuildBatch",
      "codebuild:RetryBuild",
      "codebuild:RetryBuildBatch",
      "codebuild:BatchGet*",
      "codebuild:GetResourcePolicy",
      "codebuild:DescribeTestCases",
      "codebuild:DescribeCodeCoverages",
      "codebuild:List*",
      "codecommit:GetBranch",
      "codecommit:GetCommit",
      "codecommit:GetRepository",
      "codecommit:ListBranches",
      "cloudwatch:GetMetricStatistics",
      "events:DescribeRule",
      "events:ListTargetsByRule",
      "events:ListRuleNamesByTarget",
      "logs:GetLogEvents",
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSServicesAccess"
    },
    {
     "Action":[
      "ssm:PutParameter"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/CodeBuild/*",
     "Sid":"SSMParameterWriteAccess"
    },
    {
     "Action":[
      "ssm:StartSession"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ecs:*:*:task/*/*",
     "Sid":"SSMStartSessionAccess"
    },
    {
     "Action":[
      "codestar-connections:ListConnections",
      "codestar-connections:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:codestar-connections:*:*:connection/*",
      "arn:aws:codeconnections:*:*:connection/*"
     ],
     "Sid":"CodeStarConnectionsUserAccess"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codebuild:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "sns:ListTopics",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSTopicListAccess"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations",
      "chatbot:ListMicrosoftTeamsChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-02T01:36:55+00:00"
 },
 "AWSCodeBuildReadOnlyAccess":{
  "CreateDate":"2016-12-01T19:03:41+00:00",
  "DefaultVersionId":"v12",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codebuild:BatchGet*",
      "codebuild:GetResourcePolicy",
      "codebuild:List*",
      "codebuild:DescribeTestCases",
      "codebuild:DescribeCodeCoverages",
      "codecommit:GetBranch",
      "codecommit:GetCommit",
      "codecommit:GetRepository",
      "cloudwatch:GetMetricStatistics",
      "events:DescribeRule",
      "events:ListTargetsByRule",
      "events:ListRuleNamesByTarget",
      "logs:GetLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSServicesAccess"
    },
    {
     "Action":[
      "codestar-connections:ListConnections",
      "codestar-connections:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:codestar-connections:*:*:connection/*",
      "arn:aws:codeconnections:*:*:connection/*"
     ],
     "Sid":"CodeStarConnectionsUserAccess"
    },
    {
     "Action":[
      "codestar-notifications:DescribeNotificationRule"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codebuild:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsPowerUserAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-02T01:23:27+00:00"
 },
 "AWSCodeCommitFullAccess":{
  "CreateDate":"2015-07-09T17:02:19+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codecommit:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:DescribeRule",
      "events:DisableRule",
      "events:EnableRule",
      "events:PutRule",
      "events:PutTargets",
      "events:RemoveTargets",
      "events:ListTargetsByRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/codecommit*",
     "Sid":"CloudWatchEventsCodeCommitRulesAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:DeleteTopic",
      "sns:Subscribe",
      "sns:Unsubscribe",
      "sns:SetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codecommit*",
     "Sid":"SNSTopicAndSubscriptionAccess"
    },
    {
     "Action":[
      "sns:ListTopics",
      "sns:ListSubscriptionsByTopic",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSTopicAndSubscriptionReadAccess"
    },
    {
     "Action":[
      "lambda:ListFunctions"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LambdaReadOnlyListAccess"
    },
    {
     "Action":[
      "iam:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMReadOnlyListAccess"
    },
    {
     "Action":[
      "iam:ListAccessKeys",
      "iam:ListSSHPublicKeys",
      "iam:ListServiceSpecificCredentials"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMReadOnlyConsoleAccess"
    },
    {
     "Action":[
      "iam:DeleteSSHPublicKey",
      "iam:GetSSHPublicKey",
      "iam:ListSSHPublicKeys",
      "iam:UpdateSSHPublicKey",
      "iam:UploadSSHPublicKey"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMUserSSHKeys"
    },
    {
     "Action":[
      "iam:CreateServiceSpecificCredential",
      "iam:UpdateServiceSpecificCredential",
      "iam:DeleteServiceSpecificCredential",
      "iam:ResetServiceSpecificCredential"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMSelfManageServiceSpecificCredentials"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:DeleteNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codecommit:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource",
      "codestar-notifications:ListEventTypes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:SetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codestar-notifications*",
     "Sid":"CodeStarNotificationsSNSTopicCreateAccess"
    },
    {
     "Action":[
      "codeguru-reviewer:AssociateRepository",
      "codeguru-reviewer:DescribeRepositoryAssociation",
      "codeguru-reviewer:ListRepositoryAssociations",
      "codeguru-reviewer:DisassociateRepository",
      "codeguru-reviewer:DescribeCodeReview",
      "codeguru-reviewer:ListCodeReviews"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AmazonCodeGuruReviewerFullAccess"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"codeguru-reviewer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/codeguru-reviewer.amazonaws.com/AWSServiceRoleForAmazonCodeGuruReviewer",
     "Sid":"AmazonCodeGuruReviewerSLRCreation"
    },
    {
     "Action":[
      "events:PutRule",
      "events:PutTargets",
      "events:DeleteRule",
      "events:RemoveTargets"
     ],
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"codeguru-reviewer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchEventsManagedRules"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations",
      "chatbot:ListMicrosoftTeamsChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    },
    {
     "Action":[
      "codestar-connections:ListConnections",
      "codestar-connections:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codestar-connections:*:*:connection/*",
     "Sid":"CodeStarConnectionsReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-07-17T21:50:11+00:00"
 },
 "AWSCodeCommitPowerUser":{
  "CreateDate":"2015-07-09T17:06:49+00:00",
  "DefaultVersionId":"v15",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codecommit:AssociateApprovalRuleTemplateWithRepository",
      "codecommit:BatchAssociateApprovalRuleTemplateWithRepositories",
      "codecommit:BatchDisassociateApprovalRuleTemplateFromRepositories",
      "codecommit:BatchGet*",
      "codecommit:BatchDescribe*",
      "codecommit:Create*",
      "codecommit:DeleteBranch",
      "codecommit:DeleteFile",
      "codecommit:Describe*",
      "codecommit:DisassociateApprovalRuleTemplateFromRepository",
      "codecommit:EvaluatePullRequestApprovalRules",
      "codecommit:Get*",
      "codecommit:List*",
      "codecommit:Merge*",
      "codecommit:OverridePullRequestApprovalRules",
      "codecommit:Put*",
      "codecommit:Post*",
      "codecommit:TagResource",
      "codecommit:Test*",
      "codecommit:UntagResource",
      "codecommit:Update*",
      "codecommit:GitPull",
      "codecommit:GitPush"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:DescribeRule",
      "events:DisableRule",
      "events:EnableRule",
      "events:PutRule",
      "events:PutTargets",
      "events:RemoveTargets",
      "events:ListTargetsByRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/codecommit*",
     "Sid":"CloudWatchEventsCodeCommitRulesAccess"
    },
    {
     "Action":[
      "sns:Subscribe",
      "sns:Unsubscribe"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codecommit*",
     "Sid":"SNSTopicAndSubscriptionAccess"
    },
    {
     "Action":[
      "sns:ListTopics",
      "sns:ListSubscriptionsByTopic",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSTopicAndSubscriptionReadAccess"
    },
    {
     "Action":[
      "lambda:ListFunctions"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LambdaReadOnlyListAccess"
    },
    {
     "Action":[
      "iam:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMReadOnlyListAccess"
    },
    {
     "Action":[
      "iam:ListAccessKeys",
      "iam:ListSSHPublicKeys",
      "iam:ListServiceSpecificCredentials"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMReadOnlyConsoleAccess"
    },
    {
     "Action":[
      "iam:DeleteSSHPublicKey",
      "iam:GetSSHPublicKey",
      "iam:ListSSHPublicKeys",
      "iam:UpdateSSHPublicKey",
      "iam:UploadSSHPublicKey"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMUserSSHKeys"
    },
    {
     "Action":[
      "iam:CreateServiceSpecificCredential",
      "iam:UpdateServiceSpecificCredential",
      "iam:DeleteServiceSpecificCredential",
      "iam:ResetServiceSpecificCredential"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMSelfManageServiceSpecificCredentials"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codecommit:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource",
      "codestar-notifications:ListEventTypes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "codeguru-reviewer:AssociateRepository",
      "codeguru-reviewer:DescribeRepositoryAssociation",
      "codeguru-reviewer:ListRepositoryAssociations",
      "codeguru-reviewer:DisassociateRepository",
      "codeguru-reviewer:DescribeCodeReview",
      "codeguru-reviewer:ListCodeReviews"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AmazonCodeGuruReviewerFullAccess"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"codeguru-reviewer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/codeguru-reviewer.amazonaws.com/AWSServiceRoleForAmazonCodeGuruReviewer",
     "Sid":"AmazonCodeGuruReviewerSLRCreation"
    },
    {
     "Action":[
      "events:PutRule",
      "events:PutTargets",
      "events:DeleteRule",
      "events:RemoveTargets"
     ],
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"codeguru-reviewer.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchEventsManagedRules"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations",
      "chatbot:ListMicrosoftTeamsChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    },
    {
     "Action":[
      "codestar-connections:ListConnections",
      "codestar-connections:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codestar-connections:*:*:connection/*",
     "Sid":"CodeStarConnectionsReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-07-17T21:49:06+00:00"
 },
 "AWSCodeCommitReadOnly":{
  "CreateDate":"2015-07-09T17:05:06+00:00",
  "DefaultVersionId":"v11",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codecommit:BatchGet*",
      "codecommit:BatchDescribe*",
      "codecommit:Describe*",
      "codecommit:EvaluatePullRequestApprovalRules",
      "codecommit:Get*",
      "codecommit:List*",
      "codecommit:GitPull"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "events:DescribeRule",
      "events:ListTargetsByRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/codecommit*",
     "Sid":"CloudWatchEventsCodeCommitRulesReadOnlyAccess"
    },
    {
     "Action":[
      "sns:ListTopics",
      "sns:ListSubscriptionsByTopic",
      "sns:GetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSSubscriptionAccess"
    },
    {
     "Action":[
      "lambda:ListFunctions"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LambdaReadOnlyListAccess"
    },
    {
     "Action":[
      "iam:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMReadOnlyListAccess"
    },
    {
     "Action":[
      "iam:ListSSHPublicKeys",
      "iam:ListServiceSpecificCredentials",
      "iam:ListAccessKeys",
      "iam:GetSSHPublicKey"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:user/${aws:username}",
     "Sid":"IAMReadOnlyConsoleAccess"
    },
    {
     "Action":[
      "codestar-connections:ListConnections",
      "codestar-connections:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codestar-connections:*:*:connection/*",
     "Sid":"CodeStarConnectionsReadOnlyAccess"
    },
    {
     "Action":[
      "codestar-notifications:DescribeNotificationRule"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codecommit:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadOnlyAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "codeguru-reviewer:DescribeRepositoryAssociation",
      "codeguru-reviewer:ListRepositoryAssociations",
      "codeguru-reviewer:DescribeCodeReview",
      "codeguru-reviewer:ListCodeReviews"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AmazonCodeGuruReviewerReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-18T18:18:01+00:00"
 },
 "AWSCodeDeployDeployerAccess":{
  "CreateDate":"2015-05-19T18:18:43+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codedeploy:Batch*",
      "codedeploy:CreateDeployment",
      "codedeploy:Get*",
      "codedeploy:List*",
      "codedeploy:RegisterApplicationRevision"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codedeploy:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource",
      "codestar-notifications:ListEventTypes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSTopicListAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-04-02T16:16:11+00:00"
 },
 "AWSCodeDeployFullAccess":{
  "CreateDate":"2015-05-19T18:13:23+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":"codedeploy:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:DeleteNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codedeploy:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource",
      "codestar-notifications:ListEventTypes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:SetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codestar-notifications*",
     "Sid":"CodeStarNotificationsSNSTopicCreateAccess"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSTopicListAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-04-02T16:14:47+00:00"
 },
 "AWSCodeDeployReadOnlyAccess":{
  "CreateDate":"2015-05-19T18:21:32+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codedeploy:Batch*",
      "codedeploy:Get*",
      "codedeploy:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "codestar-notifications:DescribeNotificationRule"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codedeploy:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsPowerUserAccess"
    },
    {
     "Action":[
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsListAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-04-02T16:20:09+00:00"
 },
 "AWSCodeDeployRole":{
  "CreateDate":"2015-05-04T18:05:37+00:00",
  "DefaultVersionId":"v11",
  "Document":{
   "Statement":[
    {
     "Action":[
      "autoscaling:CompleteLifecycleAction",
      "autoscaling:DeleteLifecycleHook",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeLifecycleHooks",
      "autoscaling:PutLifecycleHook",
      "autoscaling:RecordLifecycleActionHeartbeat",
      "autoscaling:CreateAutoScalingGroup",
      "autoscaling:CreateOrUpdateTags",
      "autoscaling:UpdateAutoScalingGroup",
      "autoscaling:EnableMetricsCollection",
      "autoscaling:DescribePolicies",
      "autoscaling:DescribeScheduledActions",
      "autoscaling:DescribeNotificationConfigurations",
      "autoscaling:SuspendProcesses",
      "autoscaling:ResumeProcesses",
      "autoscaling:AttachLoadBalancers",
      "autoscaling:AttachLoadBalancerTargetGroups",
      "autoscaling:PutScalingPolicy",
      "autoscaling:PutScheduledUpdateGroupAction",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:PutWarmPool",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:DeleteAutoScalingGroup",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:TerminateInstances",
      "tag:GetResources",
      "sns:Publish",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:PutMetricAlarm",
      "elasticloadbalancing:DescribeLoadBalancerAttributes",
      "elasticloadbalancing:DescribeTargetGroupAttributes",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:DeregisterTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-08-16T20:38:58+00:00"
 },
 "AWSCodeDeployRoleForCloudFormation":{
  "CreateDate":"2020-05-19T17:12:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:lambda:*:*:function:CodeDeployHook_*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-19T17:12:52+00:00"
 },
 "AWSCodeDeployRoleForECS":{
  "CreateDate":"2018-11-27T20:40:57+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:DescribeServices",
      "ecs:CreateTaskSet",
      "ecs:UpdateServicePrimaryTaskSet",
      "ecs:DeleteTaskSet",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:ModifyListener",
      "elasticloadbalancing:DescribeRules",
      "elasticloadbalancing:ModifyRule",
      "lambda:InvokeFunction",
      "cloudwatch:DescribeAlarms",
      "sns:Publish",
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "ecs-tasks.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-23T22:37:46+00:00"
 },
 "AWSCodeDeployRoleForECSLimited":{
  "CreateDate":"2018-11-27T20:42:42+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:DescribeServices",
      "ecs:CreateTaskSet",
      "ecs:UpdateServicePrimaryTaskSet",
      "ecs:DeleteTaskSet",
      "cloudwatch:DescribeAlarms"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:CodeDeployTopic_*"
    },
    {
     "Action":[
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:ModifyListener",
      "elasticloadbalancing:DescribeRules",
      "elasticloadbalancing:ModifyRule"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:lambda:*:*:function:CodeDeployHook_*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Condition":{
      "StringEquals":{
       "s3:ExistingObjectTag/UseWithCodeDeploy":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "ecs-tasks.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/ecsTaskExecutionRole",
      "arn:aws:iam::*:role/ECSTaskExecution*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-23T22:10:29+00:00"
 },
 "AWSCodeDeployRoleForLambda":{
  "CreateDate":"2017-11-28T14:05:44+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:DescribeAlarms",
      "lambda:UpdateAlias",
      "lambda:GetAlias",
      "lambda:GetProvisionedConcurrencyConfig",
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/CodeDeploy/*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Condition":{
      "StringEquals":{
       "s3:ExistingObjectTag/UseWithCodeDeploy":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:lambda:*:*:function:CodeDeployHook_*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-03T19:53:10+00:00"
 },
 "AWSCodeDeployRoleForLambdaLimited":{
  "CreateDate":"2020-08-17T17:14:14+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:DescribeAlarms",
      "lambda:UpdateAlias",
      "lambda:GetAlias",
      "lambda:GetProvisionedConcurrencyConfig"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/CodeDeploy/*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectVersion"
     ],
     "Condition":{
      "StringEquals":{
       "s3:ExistingObjectTag/UseWithCodeDeploy":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:lambda:*:*:function:CodeDeployHook_*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-17T17:14:14+00:00"
 },
 "AWSCodePipelineApproverAccess":{
  "CreateDate":"2016-07-28T18:59:17+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineState",
      "codepipeline:GetPipelineExecution",
      "codepipeline:ListPipelineExecutions",
      "codepipeline:ListPipelines",
      "codepipeline:PutApprovalResult"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-08-02T17:24:58+00:00"
 },
 "AWSCodePipelineCustomActionAccess":{
  "CreateDate":"2015-07-09T17:02:54+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codepipeline:AcknowledgeJob",
      "codepipeline:GetJobDetails",
      "codepipeline:PollForJobs",
      "codepipeline:PutJobFailureResult",
      "codepipeline:PutJobSuccessResult"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-07-09T17:02:54+00:00"
 },
 "AWSCodePipeline_FullAccess":{
  "CreateDate":"2020-08-03T22:38:28+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codepipeline:*",
      "cloudformation:DescribeStacks",
      "cloudformation:ListStacks",
      "cloudformation:ListChangeSets",
      "cloudtrail:DescribeTrails",
      "codebuild:BatchGetProjects",
      "codebuild:CreateProject",
      "codebuild:ListCuratedEnvironmentImages",
      "codebuild:ListProjects",
      "codecommit:ListBranches",
      "codecommit:GetReferences",
      "codecommit:ListRepositories",
      "codedeploy:BatchGetDeploymentGroups",
      "codedeploy:ListApplications",
      "codedeploy:ListDeploymentGroups",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ecr:DescribeRepositories",
      "ecr:ListImages",
      "ecs:ListClusters",
      "ecs:ListServices",
      "elasticbeanstalk:DescribeApplications",
      "elasticbeanstalk:DescribeEnvironments",
      "iam:ListRoles",
      "iam:GetRole",
      "lambda:ListFunctions",
      "events:ListRules",
      "events:ListTargetsByRule",
      "events:DescribeRule",
      "opsworks:DescribeApps",
      "opsworks:DescribeLayers",
      "opsworks:DescribeStacks",
      "s3:ListAllMyBuckets",
      "sns:ListTopics",
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListTargets",
      "codestar-notifications:ListTagsforResource",
      "codestar-notifications:ListEventTypes",
      "states:ListStateMachines"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodePipelineAuthoringAccess"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:ListBucket",
      "s3:GetBucketPolicy",
      "s3:GetBucketVersioning",
      "s3:GetObjectVersion",
      "s3:CreateBucket",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3::*:codepipeline-*",
     "Sid":"CodePipelineArtifactsReadWriteAccess"
    },
    {
     "Action":[
      "cloudtrail:PutEventSelectors",
      "cloudtrail:CreateTrail",
      "cloudtrail:GetEventSelectors",
      "cloudtrail:StartLogging"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudtrail:*:*:trail/codepipeline-source-trail",
     "Sid":"CodePipelineSourceTrailReadWriteAccess"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "events.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/cwe-role-*"
     ],
     "Sid":"EventsIAMPassRole"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "codepipeline.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodePipelineIAMPassRole"
    },
    {
     "Action":[
      "events:PutRule",
      "events:PutTargets",
      "events:DeleteRule",
      "events:DisableRule",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/codepipeline-*"
     ],
     "Sid":"CodePipelineEventsReadWriteAccess"
    },
    {
     "Action":[
      "codestar-notifications:CreateNotificationRule",
      "codestar-notifications:DescribeNotificationRule",
      "codestar-notifications:UpdateNotificationRule",
      "codestar-notifications:DeleteNotificationRule",
      "codestar-notifications:Subscribe",
      "codestar-notifications:Unsubscribe"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codepipeline:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadWriteAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:SetTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:codestar-notifications*",
     "Sid":"CodeStarNotificationsSNSTopicCreateAccess"
    },
    {
     "Action":[
      "chatbot:DescribeSlackChannelConfigurations",
      "chatbot:ListMicrosoftTeamsChannelConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsChatbotAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-14T17:06:23+00:00"
 },
 "AWSCodePipeline_ReadOnlyAccess":{
  "CreateDate":"2020-08-03T22:25:17+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineState",
      "codepipeline:GetPipelineExecution",
      "codepipeline:ListPipelineExecutions",
      "codepipeline:ListActionExecutions",
      "codepipeline:ListActionTypes",
      "codepipeline:ListPipelines",
      "codepipeline:ListTagsForResource",
      "s3:ListAllMyBuckets",
      "codestar-notifications:ListNotificationRules",
      "codestar-notifications:ListEventTypes",
      "codestar-notifications:ListTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:ListBucket",
      "s3:GetBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3::*:codepipeline-*"
    },
    {
     "Action":[
      "codestar-notifications:DescribeNotificationRule"
     ],
     "Condition":{
      "StringLike":{
       "codestar-notifications:NotificationsForResource":"arn:aws:codepipeline:*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarNotificationsReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-03T22:25:17+00:00"
 },
 "AWSCodeStarFullAccess":{
  "CreateDate":"2017-04-19T16:23:19+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codestar:*",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "cloud9:DescribeEnvironment*",
      "cloud9:ValidateEnvironmentName"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CodeStarEC2"
    },
    {
     "Action":[
      "cloudformation:DescribeStack*",
      "cloudformation:ListStacks*",
      "cloudformation:GetTemplateSummary"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awscodestar-*"
     ],
     "Sid":"CodeStarCF"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-28T00:06:28+00:00"
 },
 "AWSCodeStarNotificationsServiceRolePolicy":{
  "CreateDate":"2019-11-05T16:10:21+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "events:PutTargets",
      "events:PutRule",
      "events:DescribeRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/awscodestarnotifications-*"
    },
    {
     "Action":[
      "sns:CreateTopic"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:CodeStarNotifications-*"
    },
    {
     "Action":[
      "codecommit:GetCommentsForPullRequest",
      "codecommit:GetCommentsForComparedCommit",
      "chatbot:DescribeSlackChannelConfigurations",
      "chatbot:UpdateSlackChannelConfiguration",
      "codecommit:GetDifferences",
      "codepipeline:ListActionExecutions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "codecommit:GetFile"
     ],
     "Condition":{
      "StringNotEquals":{
       "aws:ResourceTag/ExcludeFileContentFromNotifications":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-03-19T16:01:55+00:00"
 },
 "AWSCodeStarServiceRole":{
  "CreateDate":"2017-04-19T15:20:50+00:00",
  "DefaultVersionId":"v11",
  "Document":{
   "Statement":[
    {
     "Action":[
      "events:PutTargets",
      "events:RemoveTargets",
      "events:PutRule",
      "events:DeleteRule",
      "events:DescribeRule"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/awscodestar-*"
     ],
     "Sid":"ProjectEventRules"
    },
    {
     "Action":[
      "cloudformation:*Stack*",
      "cloudformation:CreateChangeSet",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:DeleteChangeSet",
      "cloudformation:GetTemplate"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awscodestar-*",
      "arn:aws:cloudformation:*:*:stack/awseb-*",
      "arn:aws:cloudformation:*:*:stack/aws-cloud9-*",
      "arn:aws:cloudformation:*:aws:transform/CodeStar*"
     ],
     "Sid":"ProjectStack"
    },
    {
     "Action":[
      "cloudformation:GetTemplateSummary",
      "cloudformation:DescribeChangeSet"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProjectStackTemplate"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::awscodestar-*/*"
     ],
     "Sid":"ProjectQuickstarts"
    },
    {
     "Action":[
      "s3:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-codestar-*",
      "arn:aws:s3:::elasticbeanstalk-*"
     ],
     "Sid":"ProjectS3Buckets"
    },
    {
     "Action":[
      "codestar:*",
      "codecommit:*",
      "codepipeline:*",
      "codedeploy:*",
      "codebuild:*",
      "autoscaling:*",
      "cloudwatch:Put*",
      "ec2:*",
      "elasticbeanstalk:*",
      "elasticloadbalancing:*",
      "iam:ListRoles",
      "logs:*",
      "sns:*",
      "cloud9:CreateEnvironmentEC2",
      "cloud9:DeleteEnvironment",
      "cloud9:DescribeEnvironment*",
      "cloud9:ListEnvironments"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProjectServices"
    },
    {
     "Action":[
      "iam:AttachRolePolicy",
      "iam:CreateRole",
      "iam:DeleteRole",
      "iam:DeleteRolePolicy",
      "iam:DetachRolePolicy",
      "iam:GetRole",
      "iam:PassRole",
      "iam:GetRolePolicy",
      "iam:PutRolePolicy",
      "iam:SetDefaultPolicyVersion",
      "iam:CreatePolicy",
      "iam:DeletePolicy",
      "iam:AddRoleToInstanceProfile",
      "iam:CreateInstanceProfile",
      "iam:DeleteInstanceProfile",
      "iam:RemoveRoleFromInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/CodeStarWorker*",
      "arn:aws:iam::*:policy/CodeStarWorker*",
      "arn:aws:iam::*:instance-profile/awscodestar-*"
     ],
     "Sid":"ProjectWorkerRoles"
    },
    {
     "Action":[
      "iam:AttachUserPolicy",
      "iam:DetachUserPolicy"
     ],
     "Condition":{
      "ArnEquals":{
       "iam:PolicyArn":[
        "arn:aws:iam::*:policy/CodeStar_*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProjectTeamMembers"
    },
    {
     "Action":[
      "iam:CreatePolicy",
      "iam:DeletePolicy",
      "iam:CreatePolicyVersion",
      "iam:DeletePolicyVersion",
      "iam:ListEntitiesForPolicy",
      "iam:ListPolicyVersions",
      "iam:GetPolicy",
      "iam:GetPolicyVersion"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:policy/CodeStar_*"
     ],
     "Sid":"ProjectRoles"
    },
    {
     "Action":[
      "iam:ListAttachedRolePolicies"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-codestar-service-role",
      "arn:aws:iam::*:role/service-role/aws-codestar-service-role"
     ],
     "Sid":"InspectServiceRole"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"cloud9.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMLinkRole"
    },
    {
     "Action":[
      "config:DescribeConfigRules"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DescribeConfigRuleForARN"
    },
    {
     "Action":[
      "codestar-connections:UseConnection",
      "codestar-connections:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProjectCodeStarConnections"
    },
    {
     "Action":"codestar-connections:PassConnection",
     "Condition":{
      "StringEqualsIfExists":{
       "codestar-connections:PassedToService":"codepipeline.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProjectCodeStarConnectionsPassConnections"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-20T19:11:03+00:00"
 },
 "AWSCompromisedKeyQuarantine":{
  "CreateDate":"2020-08-11T18:04:13+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:AttachGroupPolicy",
      "iam:AttachRolePolicy",
      "iam:AttachUserPolicy",
      "iam:ChangePassword",
      "iam:CreateAccessKey",
      "iam:CreateInstanceProfile",
      "iam:CreateLoginProfile",
      "iam:CreateRole",
      "iam:CreateUser",
      "iam:DetachUserPolicy",
      "iam:PutUserPermissionsBoundary",
      "iam:PutUserPolicy",
      "iam:UpdateAccessKey",
      "iam:UpdateAccountPasswordPolicy",
      "iam:UpdateUser",
      "ec2:RequestSpotInstances",
      "ec2:RunInstances",
      "ec2:StartInstances",
      "organizations:CreateAccount",
      "organizations:CreateOrganization",
      "organizations:InviteAccountToOrganization",
      "lambda:CreateFunction",
      "lightsail:Create*",
      "lightsail:Start*",
      "lightsail:Delete*",
      "lightsail:Update*",
      "lightsail:GetInstanceAccessDetails",
      "lightsail:DownloadDefaultKeyPair"
     ],
     "Effect":"Deny",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-11T18:04:13+00:00"
 },
 "AWSCompromisedKeyQuarantineV2":{
  "CreateDate":"2021-04-21T22:30:59+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudtrail:LookupEvents",
      "ec2:RequestSpotInstances",
      "ec2:RunInstances",
      "ec2:StartInstances",
      "iam:AddUserToGroup",
      "iam:AttachGroupPolicy",
      "iam:AttachRolePolicy",
      "iam:AttachUserPolicy",
      "iam:ChangePassword",
      "iam:CreateAccessKey",
      "iam:CreateInstanceProfile",
      "iam:CreateLoginProfile",
      "iam:CreatePolicyVersion",
      "iam:CreateRole",
      "iam:CreateUser",
      "iam:DetachUserPolicy",
      "iam:PassRole",
      "iam:PutGroupPolicy",
      "iam:PutRolePolicy",
      "iam:PutUserPermissionsBoundary",
      "iam:PutUserPolicy",
      "iam:SetDefaultPolicyVersion",
      "iam:UpdateAccessKey",
      "iam:UpdateAccountPasswordPolicy",
      "iam:UpdateAssumeRolePolicy",
      "iam:UpdateLoginProfile",
      "iam:UpdateUser",
      "lambda:AddLayerVersionPermission",
      "lambda:AddPermission",
      "lambda:CreateFunction",
      "lambda:GetPolicy",
      "lambda:ListTags",
      "lambda:PutProvisionedConcurrencyConfig",
      "lambda:TagResource",
      "lambda:UntagResource",
      "lambda:UpdateFunctionCode",
      "lightsail:Create*",
      "lightsail:Delete*",
      "lightsail:DownloadDefaultKeyPair",
      "lightsail:GetInstanceAccessDetails",
      "lightsail:Start*",
      "lightsail:Update*",
      "organizations:CreateAccount",
      "organizations:CreateOrganization",
      "organizations:InviteAccountToOrganization",
      "s3:DeleteBucket",
      "s3:DeleteObject",
      "s3:DeleteObjectVersion",
      "s3:PutLifecycleConfiguration",
      "s3:PutBucketAcl",
      "s3:PutBucketOwnershipControls",
      "s3:DeleteBucketPolicy",
      "s3:ObjectOwnerOverrideToBucketOwner",
      "s3:PutAccountPublicAccessBlock",
      "s3:PutBucketPolicy",
      "s3:ListAllMyBuckets",
      "ec2:PurchaseReservedInstancesOffering",
      "ec2:AcceptReservedInstancesExchangeQuote",
      "ec2:CreateReservedInstancesListing",
      "savingsplans:CreateSavingsPlan"
     ],
     "Effect":"Deny",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-16T00:20:25+00:00"
 },
 "AWSCompromisedKeyQuarantineV3":{
  "CreateDate":"2024-08-21T17:36:49+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudtrail:LookupEvents",
      "ec2:RequestSpotInstances",
      "ec2:RunInstances",
      "ec2:StartInstances",
      "iam:AddUserToGroup",
      "iam:AttachGroupPolicy",
      "iam:AttachRolePolicy",
      "iam:AttachUserPolicy",
      "iam:ChangePassword",
      "iam:CreateAccessKey",
      "iam:CreateInstanceProfile",
      "iam:CreateLoginProfile",
      "iam:CreatePolicyVersion",
      "iam:CreateRole",
      "iam:CreateUser",
      "iam:DetachUserPolicy",
      "iam:PassRole",
      "iam:PutGroupPolicy",
      "iam:PutRolePolicy",
      "iam:PutUserPermissionsBoundary",
      "iam:PutUserPolicy",
      "iam:SetDefaultPolicyVersion",
      "iam:UpdateAccessKey",
      "iam:UpdateAccountPasswordPolicy",
      "iam:UpdateAssumeRolePolicy",
      "iam:UpdateLoginProfile",
      "iam:UpdateUser",
      "lambda:AddLayerVersionPermission",
      "lambda:AddPermission",
      "lambda:CreateFunction",
      "lambda:GetPolicy",
      "lambda:ListTags",
      "lambda:PutProvisionedConcurrencyConfig",
      "lambda:TagResource",
      "lambda:UntagResource",
      "lambda:UpdateFunctionCode",
      "lightsail:Create*",
      "lightsail:Delete*",
      "lightsail:DownloadDefaultKeyPair",
      "lightsail:GetInstanceAccessDetails",
      "lightsail:Start*",
      "lightsail:Update*",
      "organizations:CreateAccount",
      "organizations:CreateOrganization",
      "organizations:InviteAccountToOrganization",
      "s3:DeleteBucket",
      "s3:DeleteObject",
      "s3:DeleteObjectVersion",
      "s3:PutLifecycleConfiguration",
      "s3:PutBucketAcl",
      "s3:PutBucketOwnershipControls",
      "s3:DeleteBucketPolicy",
      "s3:ObjectOwnerOverrideToBucketOwner",
      "s3:PutAccountPublicAccessBlock",
      "s3:PutBucketPolicy",
      "s3:ListAllMyBuckets",
      "ec2:PurchaseReservedInstancesOffering",
      "ec2:AcceptReservedInstancesExchangeQuote",
      "ec2:CreateReservedInstancesListing",
      "savingsplans:CreateSavingsPlan"
     ],
     "Effect":"Deny",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-08-21T17:36:49+00:00"
 },
 "AWSConfigMultiAccountSetupPolicy":{
  "CreateDate":"2019-06-17T18:03:16+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "config:PutConfigRule",
      "config:DeleteConfigRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:config-rule/aws-service-rule/config-multiaccountsetup.amazonaws.com/*"
    },
    {
     "Action":[
      "config:DescribeConfigurationRecorders"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:ListAccounts",
      "organizations:DescribeOrganization",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:DescribeAccount"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "config:PutConformancePack",
      "config:DeleteConformancePack"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:conformance-pack/aws-service-conformance-pack/config-multiaccountsetup.amazonaws.com/*"
    },
    {
     "Action":[
      "config:DescribeConformancePackStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/config-conforms.amazonaws.com/AWSServiceRoleForConfigConforms"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"config-conforms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/config-conforms.amazonaws.com/AWSServiceRoleForConfigConforms"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-02-24T01:39:49+00:00"
 },
 "AWSConfigRemediationServiceRolePolicy":{
  "CreateDate":"2019-06-18T21:21:35+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:GetDocument",
      "ssm:DescribeDocument",
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-18T21:21:35+00:00"
 },
 "AWSConfigRoleForOrganizations":{
  "CreateDate":"2018-03-19T22:53:01+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:ListAccounts",
      "organizations:DescribeOrganization",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListDelegatedAdministrators"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-24T20:19:13+00:00"
 },
 "AWSConfigRulesExecutionRole":{
  "CreateDate":"2016-03-25T17:59:36+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/AWSLogs/*/Config/*"
    },
    {
     "Action":[
      "config:Put*",
      "config:Get*",
      "config:List*",
      "config:Describe*",
      "config:BatchGet*",
      "config:Select*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-05-13T21:33:30+00:00"
 },
 "AWSConfigServiceRolePolicy":{
  "CreateDate":"2018-05-30T23:31:46+00:00",
  "DefaultVersionId":"v52",
  "Document":{
   "Statement":[
    {
     "Action":[
      "access-analyzer:GetAnalyzer",
      "access-analyzer:GetArchiveRule",
      "access-analyzer:ListAnalyzers",
      "access-analyzer:ListArchiveRules",
      "access-analyzer:ListTagsForResource",
      "account:GetAlternateContact",
      "acm-pca:DescribeCertificateAuthority",
      "acm-pca:GetCertificateAuthorityCertificate",
      "acm-pca:GetCertificateAuthorityCsr",
      "acm-pca:ListCertificateAuthorities",
      "acm-pca:ListTags",
      "acm:DescribeCertificate",
      "acm:ListCertificates",
      "acm:ListTagsForCertificate",
      "airflow:GetEnvironment",
      "airflow:ListEnvironments",
      "airflow:ListTagsForResource",
      "amplify:GetApp",
      "amplify:GetBranch",
      "amplify:ListApps",
      "amplify:ListBranches",
      "amplifyuibuilder:ExportThemes",
      "amplifyuibuilder:GetTheme",
      "amplifyuibuilder:ListThemes",
      "aoss:BatchGetCollection",
      "aoss:BatchGetLifecyclePolicy",
      "aoss:BatchGetVpcEndpoint",
      "aoss:GetAccessPolicy",
      "aoss:GetSecurityConfig",
      "aoss:GetSecurityPolicy",
      "aoss:ListAccessPolicies",
      "aoss:ListCollections",
      "aoss:ListLifecyclePolicies",
      "aoss:ListSecurityConfigs",
      "aoss:ListSecurityPolicies",
      "aoss:ListVpcEndpoints",
      "app-integrations:GetEventIntegration",
      "app-integrations:ListEventIntegrationAssociations",
      "app-integrations:ListEventIntegrations",
      "appconfig:GetApplication",
      "appconfig:GetConfigurationProfile",
      "appconfig:GetDeployment",
      "appconfig:GetDeploymentStrategy",
      "appconfig:GetEnvironment",
      "appconfig:GetExtensionAssociation",
      "appconfig:GetHostedConfigurationVersion",
      "appconfig:ListApplications",
      "appconfig:ListConfigurationProfiles",
      "appconfig:ListDeployments",
      "appconfig:ListDeploymentStrategies",
      "appconfig:ListEnvironments",
      "appconfig:ListExtensionAssociations",
      "appconfig:ListHostedConfigurationVersions",
      "appconfig:ListTagsForResource",
      "appflow:DescribeConnectorProfiles",
      "appflow:DescribeFlow",
      "appflow:ListFlows",
      "appflow:ListTagsForResource",
      "application-autoscaling:DescribeScalableTargets",
      "application-autoscaling:DescribeScalingPolicies",
      "appmesh:DescribeGatewayRoute",
      "appmesh:DescribeMesh",
      "appmesh:DescribeRoute",
      "appmesh:DescribeVirtualGateway",
      "appmesh:DescribeVirtualNode",
      "appmesh:DescribeVirtualRouter",
      "appmesh:DescribeVirtualService",
      "appmesh:ListGatewayRoutes",
      "appmesh:ListMeshes",
      "appmesh:ListRoutes",
      "appmesh:ListTagsForResource",
      "appmesh:ListVirtualGateways",
      "appmesh:ListVirtualNodes",
      "appmesh:ListVirtualRouters",
      "appmesh:ListVirtualServices",
      "apprunner:DescribeService",
      "apprunner:DescribeVpcConnector",
      "apprunner:ListServices",
      "apprunner:ListTagsForResource",
      "apprunner:ListVpcConnectors",
      "appstream:DescribeAppBlockBuilders",
      "appstream:DescribeApplications",
      "appstream:DescribeDirectoryConfigs",
      "appstream:DescribeFleets",
      "appstream:DescribeStacks",
      "appstream:ListTagsForResource",
      "appsync:GetApiCache",
      "appsync:GetGraphqlApi",
      "appsync:ListGraphqlApis",
      "aps:DescribeAlertManagerDefinition",
      "aps:DescribeLoggingConfiguration",
      "APS:DescribeRuleGroupsNamespace",
      "APS:DescribeWorkspace",
      "aps:ListRuleGroupsNamespaces",
      "aps:ListTagsForResource",
      "APS:ListWorkspaces",
      "athena:GetDataCatalog",
      "athena:GetPreparedStatement",
      "athena:GetWorkGroup",
      "athena:ListDataCatalogs",
      "athena:ListPreparedStatements",
      "athena:ListTagsForResource",
      "athena:ListWorkGroups",
      "auditmanager:GetAccountStatus",
      "auditmanager:GetAssessment",
      "auditmanager:ListAssessments",
      "autoscaling-plans:DescribeScalingPlanResources",
      "autoscaling-plans:DescribeScalingPlans",
      "autoscaling-plans:GetScalingPlanResourceForecastData",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeLaunchConfigurations",
      "autoscaling:DescribeLifecycleHooks",
      "autoscaling:DescribePolicies",
      "autoscaling:DescribeScheduledActions",
      "autoscaling:DescribeTags",
      "autoscaling:DescribeWarmPool",
      "backup-gateway:ListTagsForResource",
      "backup-gateway:ListVirtualMachines",
      "backup:DescribeBackupVault",
      "backup:DescribeFramework",
      "backup:DescribeProtectedResource",
      "backup:DescribeRecoveryPoint",
      "backup:DescribeReportPlan",
      "backup:GetBackupPlan",
      "backup:GetBackupSelection",
      "backup:GetBackupVaultAccessPolicy",
      "backup:GetBackupVaultNotifications",
      "backup:GetRestoreTestingPlan",
      "backup:GetRestoreTestingSelection",
      "backup:ListBackupPlans",
      "backup:ListBackupSelections",
      "backup:ListBackupVaults",
      "backup:ListFrameworks",
      "backup:ListRecoveryPointsByBackupVault",
      "backup:ListReportPlans",
      "backup:ListRestoreTestingPlans",
      "backup:ListRestoreTestingSelections",
      "backup:ListTags",
      "batch:DescribeComputeEnvironments",
      "batch:DescribeJobQueues",
      "batch:DescribeSchedulingPolicies",
      "batch:ListSchedulingPolicies",
      "batch:ListTagsForResource",
      "billingconductor:ListAccountAssociations",
      "billingconductor:ListBillingGroups",
      "billingconductor:ListCustomLineItems",
      "billingconductor:ListPricingPlans",
      "billingconductor:ListPricingRules",
      "billingconductor:ListPricingRulesAssociatedToPricingPlan",
      "billingconductor:ListTagsForResource",
      "budgets:DescribeBudgetAction",
      "budgets:DescribeBudgetActionsForAccount",
      "budgets:DescribeBudgetActionsForBudget",
      "budgets:ViewBudget",
      "cassandra:Select",
      "ce:GetAnomalyMonitors",
      "ce:GetAnomalySubscriptions",
      "cloud9:DescribeEnvironmentMemberships",
      "cloud9:DescribeEnvironments",
      "cloud9:ListEnvironments",
      "cloud9:ListTagsForResource",
      "cloudformation:DescribeType",
      "cloudformation:GetResource",
      "cloudformation:ListResources",
      "cloudformation:ListStackResources",
      "cloudformation:ListStacks",
      "cloudformation:ListTypes",
      "cloudfront:GetFunction",
      "cloudfront:GetOriginAccessControl",
      "cloudfront:GetResponseHeadersPolicy",
      "cloudfront:ListDistributions",
      "cloudfront:ListFunctions",
      "cloudfront:ListOriginAccessControls",
      "cloudfront:ListResponseHeadersPolicies",
      "cloudfront:ListTagsForResource",
      "cloudtrail:DescribeTrails",
      "cloudTrail:GetChannel",
      "cloudtrail:GetEventDataStore",
      "cloudtrail:GetEventSelectors",
      "cloudtrail:GetTrailStatus",
      "cloudTrail:ListChannels",
      "cloudtrail:ListEventDataStores",
      "cloudtrail:ListTags",
      "cloudtrail:ListTrails",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DescribeAlarmsForMetric",
      "cloudwatch:DescribeAnomalyDetectors",
      "cloudwatch:GetDashboard",
      "cloudwatch:GetMetricStream",
      "cloudwatch:ListDashboards",
      "cloudwatch:ListMetricStreams",
      "cloudwatch:ListTagsForResource",
      "codeartifact:DescribeRepository",
      "codeartifact:GetRepositoryPermissionsPolicy",
      "codeartifact:ListDomains",
      "codeartifact:ListPackages",
      "codeartifact:ListPackageVersions",
      "codeartifact:ListRepositories",
      "codeartifact:ListTagsForResource",
      "codebuild:BatchGetReportGroups",
      "codebuild:ListReportGroups",
      "codecommit:GetRepository",
      "codecommit:GetRepositoryTriggers",
      "codecommit:ListRepositories",
      "codecommit:ListTagsForResource",
      "codedeploy:GetDeploymentConfig",
      "codeguru-profiler:DescribeProfilingGroup",
      "codeguru-profiler:GetNotificationConfiguration",
      "codeguru-profiler:GetPolicy",
      "codeguru-profiler:ListProfilingGroups",
      "codeguru-reviewer:DescribeRepositoryAssociation",
      "codeguru-reviewer:ListRepositoryAssociations",
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineState",
      "codepipeline:ListPipelines",
      "cognito-identity:DescribeIdentityPool",
      "cognito-identity:GetIdentityPoolRoles",
      "cognito-identity:GetPrincipalTagAttributeMap",
      "cognito-identity:ListIdentityPools",
      "cognito-identity:ListTagsForResource",
      "cognito-idp:DescribeIdentityProvider",
      "cognito-idp:DescribeResourceServer",
      "cognito-idp:DescribeUserPool",
      "cognito-idp:DescribeUserPoolClient",
      "cognito-idp:DescribeUserPoolDomain",
      "cognito-idp:GetGroup",
      "cognito-idp:GetUserPoolMfaConfig",
      "cognito-idp:ListGroups",
      "cognito-idp:ListIdentityProviders",
      "cognito-idp:ListResourceServers",
      "cognito-idp:ListTagsForResource",
      "cognito-idp:ListUserPoolClients",
      "cognito-idp:ListUserPools",
      "config:BatchGet*",
      "config:Describe*",
      "config:Get*",
      "config:List*",
      "config:Put*",
      "config:Select*",
      "connect:DescribeEvaluationForm",
      "connect:DescribeInstance",
      "connect:DescribeInstanceStorageConfig",
      "connect:DescribePhoneNumber",
      "connect:DescribePrompt",
      "connect:DescribeQuickConnect",
      "connect:DescribeRule",
      "connect:DescribeUser",
      "connect:GetTaskTemplate",
      "connect:ListApprovedOrigins",
      "connect:ListEvaluationForms",
      "connect:ListInstanceAttributes",
      "connect:ListInstances",
      "connect:ListInstanceStorageConfigs",
      "connect:ListIntegrationAssociations",
      "connect:ListPhoneNumbers",
      "connect:ListPhoneNumbersV2",
      "connect:ListPrompts",
      "connect:ListQuickConnects",
      "connect:ListRules",
      "connect:ListSecurityKeys",
      "connect:ListTagsForResource",
      "connect:ListTaskTemplates",
      "connect:ListUsers",
      "connect:SearchAvailablePhoneNumbers",
      "databrew:DescribeDataset",
      "databrew:DescribeJob",
      "databrew:DescribeProject",
      "databrew:DescribeRecipe",
      "databrew:DescribeRuleset",
      "databrew:DescribeSchedule",
      "databrew:ListDatasets",
      "databrew:ListJobs",
      "databrew:ListProjects",
      "databrew:ListRecipes",
      "databrew:ListRecipeVersions",
      "databrew:ListRulesets",
      "databrew:ListSchedules",
      "datasync:DescribeAgent",
      "datasync:DescribeLocationEfs",
      "datasync:DescribeLocationFsxLustre",
      "datasync:DescribeLocationFsxWindows",
      "datasync:DescribeLocationHdfs",
      "datasync:DescribeLocationNfs",
      "datasync:DescribeLocationObjectStorage",
      "datasync:DescribeLocationS3",
      "datasync:DescribeLocationSmb",
      "datasync:DescribeTask",
      "datasync:ListAgents",
      "datasync:ListLocations",
      "datasync:ListTagsForResource",
      "datasync:ListTasks",
      "dax:DescribeClusters",
      "dax:DescribeParameterGroups",
      "dax:DescribeParameters",
      "dax:DescribeSubnetGroups",
      "dax:ListTags",
      "detective:ListGraphs",
      "detective:ListTagsForResource",
      "devicefarm:GetInstanceProfile",
      "devicefarm:GetNetworkProfile",
      "devicefarm:GetProject",
      "devicefarm:GetTestGridProject",
      "devicefarm:ListInstanceProfiles",
      "devicefarm:ListNetworkProfiles",
      "devicefarm:ListProjects",
      "devicefarm:ListTagsForResource",
      "devicefarm:ListTestGridProjects",
      "devops-guru:GetResourceCollection",
      "dms:DescribeCertificates",
      "dms:DescribeEndpoints",
      "dms:DescribeEventSubscriptions",
      "dms:DescribeReplicationInstances",
      "dms:DescribeReplicationSubnetGroups",
      "dms:DescribeReplicationTaskAssessmentRuns",
      "dms:DescribeReplicationTasks",
      "dms:ListTagsForResource",
      "ds:DescribeDirectories",
      "ds:DescribeDomainControllers",
      "ds:DescribeEventTopics",
      "ds:ListLogSubscriptions",
      "ds:ListTagsForResource",
      "dynamodb:DescribeContinuousBackups",
      "dynamodb:DescribeGlobalTable",
      "dynamodb:DescribeGlobalTableSettings",
      "dynamodb:DescribeLimits",
      "dynamodb:DescribeTable",
      "dynamodb:DescribeTableReplicaAutoScaling",
      "dynamodb:DescribeTimeToLive",
      "dynamodb:ListTables",
      "dynamodb:ListTagsOfResource",
      "ec2:Describe*",
      "ec2:DescribeClientVpnAuthorizationRules",
      "ec2:DescribeClientVpnEndpoints",
      "ec2:DescribeDhcpOptions",
      "ec2:DescribeFleets",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribePlacementGroups",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSpotFleetRequests",
      "ec2:DescribeTags",
      "ec2:DescribeTrafficMirrorFilters",
      "ec2:DescribeTrafficMirrorSessions",
      "ec2:DescribeTrafficMirrorTargets",
      "ec2:DescribeVolumeAttribute",
      "ec2:DescribeVolumes",
      "ec2:GetEbsEncryptionByDefault",
      "ec2:GetInstanceTypesFromInstanceRequirements",
      "ec2:GetIpamPoolAllocations",
      "ec2:GetIpamPoolCidrs",
      "ec2:GetManagedPrefixListEntries",
      "ec2:GetNetworkInsightsAccessScopeAnalysisFindings",
      "ec2:GetNetworkInsightsAccessScopeContent",
      "ecr-public:DescribeRepositories",
      "ecr-public:GetRepositoryCatalogData",
      "ecr-public:GetRepositoryPolicy",
      "ecr-public:ListTagsForResource",
      "ecr:BatchGetRepositoryScanningConfiguration",
      "ecr:DescribePullThroughCacheRules",
      "ecr:DescribeRegistry",
      "ecr:DescribeRepositories",
      "ecr:GetLifecyclePolicy",
      "ecr:GetRegistryPolicy",
      "ecr:GetRepositoryPolicy",
      "ecr:ListTagsForResource",
      "ecs:DescribeCapacityProviders",
      "ecs:DescribeClusters",
      "ecs:DescribeServices",
      "ecs:DescribeTaskDefinition",
      "ecs:DescribeTaskSets",
      "ecs:ListClusters",
      "ecs:ListServices",
      "ecs:ListTagsForResource",
      "ecs:ListTaskDefinitionFamilies",
      "ecs:ListTaskDefinitions",
      "eks:DescribeAddon",
      "eks:DescribeCluster",
      "eks:DescribeFargateProfile",
      "eks:DescribeIdentityProviderConfig",
      "eks:DescribeNodegroup",
      "eks:ListAddons",
      "eks:ListClusters",
      "eks:ListFargateProfiles",
      "eks:ListIdentityProviderConfigs",
      "eks:ListNodegroups",
      "eks:ListTagsForResource",
      "elasticache:DescribeCacheClusters",
      "elasticache:DescribeCacheParameterGroups",
      "elasticache:DescribeCacheParameters",
      "elasticache:DescribeCacheSecurityGroups",
      "elasticache:DescribeCacheSubnetGroups",
      "elasticache:DescribeGlobalReplicationGroups",
      "elasticache:DescribeReplicationGroups",
      "elasticache:DescribeSnapshots",
      "elasticache:DescribeUserGroups",
      "elasticache:DescribeUsers",
      "elasticache:ListTagsForResource",
      "elasticbeanstalk:DescribeConfigurationSettings",
      "elasticbeanstalk:DescribeEnvironments",
      "elasticfilesystem:DescribeAccessPoints",
      "elasticfilesystem:DescribeBackupPolicy",
      "elasticfilesystem:DescribeFileSystemPolicy",
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:DescribeLifecycleConfiguration",
      "elasticfilesystem:DescribeMountTargets",
      "elasticfilesystem:DescribeMountTargetSecurityGroups",
      "elasticfilesystem:DescribeTags",
      "elasticloadbalancing:DescribeListenerCertificates",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeLoadBalancerAttributes",
      "elasticloadbalancing:DescribeLoadBalancerPolicies",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeRules",
      "elasticloadbalancing:DescribeTags",
      "elasticloadbalancing:DescribeTargetGroupAttributes",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticmapreduce:DescribeCluster",
      "elasticmapreduce:DescribeSecurityConfiguration",
      "elasticmapreduce:DescribeStep",
      "elasticmapreduce:DescribeStudio",
      "elasticmapreduce:GetBlockPublicAccessConfiguration",
      "elasticmapreduce:GetManagedScalingPolicy",
      "elasticmapreduce:GetStudioSessionMapping",
      "elasticmapreduce:ListClusters",
      "elasticmapreduce:ListInstanceFleets",
      "elasticmapreduce:ListInstanceGroups",
      "elasticmapreduce:ListInstances",
      "elasticmapreduce:ListSecurityConfigurations",
      "elasticmapreduce:ListSteps",
      "elasticmapreduce:ListStudios",
      "elasticmapreduce:ListStudioSessionMappings",
      "emr-containers:DescribeVirtualCluster",
      "emr-containers:ListVirtualClusters",
      "emr-serverless:GetApplication",
      "emr-serverless:ListApplications",
      "es:DescribeDomain",
      "es:DescribeDomains",
      "es:DescribeElasticsearchDomain",
      "es:DescribeElasticsearchDomains",
      "es:GetCompatibleElasticsearchVersions",
      "es:GetCompatibleVersions",
      "es:ListDomainNames",
      "es:ListTags",
      "events:DescribeApiDestination",
      "events:DescribeArchive",
      "events:DescribeConnection",
      "events:DescribeEndpoint",
      "events:DescribeEventBus",
      "events:DescribeRule",
      "events:ListApiDestinations",
      "events:ListArchives",
      "events:ListConnections",
      "events:ListEndpoints",
      "events:ListEventBuses",
      "events:ListRules",
      "events:ListTagsForResource",
      "events:ListTargetsByRule",
      "evidently:GetLaunch",
      "evidently:GetProject",
      "evidently:GetSegment",
      "evidently:ListLaunches",
      "evidently:ListProjects",
      "evidently:ListSegments",
      "evidently:ListTagsForResource",
      "finspace:GetEnvironment",
      "finspace:ListEnvironments",
      "firehose:DescribeDeliveryStream",
      "firehose:ListDeliveryStreams",
      "firehose:ListTagsForDeliveryStream",
      "fis:GetExperimentTemplate",
      "fis:ListExperimentTemplates",
      "fms:GetNotificationChannel",
      "fms:GetPolicy",
      "fms:ListPolicies",
      "fms:ListTagsForResource",
      "forecast:DescribeDataset",
      "forecast:DescribeDatasetGroup",
      "forecast:ListDatasetGroups",
      "forecast:ListDatasets",
      "forecast:ListTagsForResource",
      "frauddetector:GetDetectors",
      "frauddetector:GetDetectorVersion",
      "frauddetector:GetEntityTypes",
      "frauddetector:GetEventTypes",
      "frauddetector:GetExternalModels",
      "frauddetector:GetLabels",
      "frauddetector:GetModels",
      "frauddetector:GetOutcomes",
      "frauddetector:GetRules",
      "frauddetector:GetVariables",
      "frauddetector:ListTagsForResource",
      "fsx:DescribeBackups",
      "fsx:DescribeDataRepositoryAssociations",
      "fsx:DescribeFileSystems",
      "fsx:DescribeSnapshots",
      "fsx:DescribeStorageVirtualMachines",
      "fsx:DescribeVolumes",
      "fsx:ListTagsForResource",
      "gamelift:DescribeAlias",
      "gamelift:DescribeBuild",
      "gamelift:DescribeFleetAttributes",
      "gamelift:DescribeFleetCapacity",
      "gamelift:DescribeFleetLocationAttributes",
      "gamelift:DescribeFleetLocationCapacity",
      "gamelift:DescribeFleetPortSettings",
      "gamelift:DescribeGameServerGroup",
      "gamelift:DescribeGameSessionQueues",
      "gamelift:DescribeMatchmakingConfigurations",
      "gamelift:DescribeMatchmakingRuleSets",
      "gamelift:DescribeRuntimeConfiguration",
      "gamelift:DescribeScript",
      "gamelift:DescribeVpcPeeringAuthorizations",
      "gamelift:DescribeVpcPeeringConnections",
      "gamelift:ListAliases",
      "gamelift:ListBuilds",
      "gamelift:ListFleets",
      "gamelift:ListGameServerGroups",
      "gamelift:ListScripts",
      "gamelift:ListTagsForResource",
      "geo:DescribeGeofenceCollection",
      "geo:DescribeMap",
      "geo:DescribePlaceIndex",
      "geo:DescribeRouteCalculator",
      "geo:DescribeTracker",
      "geo:ListGeofenceCollections",
      "geo:ListMaps",
      "geo:ListPlaceIndexes",
      "geo:ListRouteCalculators",
      "geo:ListTrackerConsumers",
      "geo:ListTrackers",
      "globalaccelerator:DescribeAccelerator",
      "globalaccelerator:DescribeEndpointGroup",
      "globalaccelerator:DescribeListener",
      "globalaccelerator:ListAccelerators",
      "globalaccelerator:ListEndpointGroups",
      "globalaccelerator:ListListeners",
      "globalaccelerator:ListTagsForResource",
      "glue:BatchGetDevEndpoints",
      "glue:BatchGetJobs",
      "glue:BatchGetWorkflows",
      "glue:GetClassifier",
      "glue:GetClassifiers",
      "glue:GetCrawler",
      "glue:GetCrawlers",
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:GetDevEndpoint",
      "glue:GetDevEndpoints",
      "glue:GetJob",
      "glue:GetJobs",
      "glue:GetMLTransform",
      "glue:GetMLTransforms",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:GetSecurityConfiguration",
      "glue:GetSecurityConfigurations",
      "glue:GetTable",
      "glue:GetTags",
      "glue:GetTrigger",
      "glue:GetWorkflow",
      "glue:ListCrawlers",
      "glue:ListDevEndpoints",
      "glue:ListJobs",
      "glue:ListMLTransforms",
      "glue:ListTriggers",
      "glue:ListWorkflows",
      "grafana:DescribeWorkspace",
      "grafana:DescribeWorkspaceAuthentication",
      "grafana:DescribeWorkspaceConfiguration",
      "grafana:ListWorkspaces",
      "greengrass:DescribeComponent",
      "greengrass:GetComponent",
      "greengrass:ListComponents",
      "greengrass:ListComponentVersions",
      "groundstation:GetConfig",
      "groundstation:GetDataflowEndpointGroup",
      "groundstation:GetMissionProfile",
      "groundstation:ListConfigs",
      "groundstation:ListDataflowEndpointGroups",
      "groundstation:ListMissionProfiles",
      "groundstation:ListTagsForResource",
      "guardduty:DescribePublishingDestination",
      "guardduty:GetAdministratorAccount",
      "guardduty:GetDetector",
      "guardduty:GetFilter",
      "guardduty:GetFindings",
      "guardduty:GetIPSet",
      "guardduty:GetMasterAccount",
      "guardduty:GetMemberDetectors",
      "guardduty:GetMembers",
      "guardduty:GetThreatIntelSet",
      "guardduty:ListDetectors",
      "guardduty:ListFilters",
      "guardduty:ListFindings",
      "guardduty:ListIPSets",
      "guardduty:ListMembers",
      "guardduty:ListOrganizationAdminAccounts",
      "guardduty:ListPublishingDestinations",
      "guardduty:ListTagsForResource",
      "guardduty:ListThreatIntelSets",
      "healthlake:DescribeFHIRDatastore",
      "healthlake:ListFHIRDatastores",
      "healthlake:ListTagsForResource",
      "iam:GenerateCredentialReport",
      "iam:GetAccountAuthorizationDetails",
      "iam:GetAccountPasswordPolicy",
      "iam:GetAccountSummary",
      "iam:GetCredentialReport",
      "iam:GetGroup",
      "iam:GetGroupPolicy",
      "iam:GetInstanceProfile",
      "iam:GetOpenIDConnectProvider",
      "iam:GetPolicy",
      "iam:GetPolicyVersion",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:GetSAMLProvider",
      "iam:GetServerCertificate",
      "iam:GetUser",
      "iam:GetUserPolicy",
      "iam:ListAccessKeys",
      "iam:ListAttachedGroupPolicies",
      "iam:ListAttachedRolePolicies",
      "iam:ListAttachedUserPolicies",
      "iam:ListEntitiesForPolicy",
      "iam:ListGroupPolicies",
      "iam:ListGroups",
      "iam:ListGroupsForUser",
      "iam:ListInstanceProfiles",
      "iam:ListInstanceProfilesForRole",
      "iam:ListInstanceProfileTags",
      "iam:ListMFADevices",
      "iam:ListMFADeviceTags",
      "iam:ListOpenIDConnectProviders",
      "iam:ListPolicyVersions",
      "iam:ListRolePolicies",
      "iam:ListRoles",
      "iam:ListSAMLProviders",
      "iam:ListServerCertificates",
      "iam:ListUserPolicies",
      "iam:ListUsers",
      "iam:ListVirtualMFADevices",
      "imagebuilder:GetComponent",
      "imagebuilder:GetContainerRecipe",
      "imagebuilder:GetDistributionConfiguration",
      "imagebuilder:GetImage",
      "imagebuilder:GetImagePipeline",
      "imagebuilder:GetImageRecipe",
      "imagebuilder:GetInfrastructureConfiguration",
      "imagebuilder:GetLifecyclePolicy",
      "imagebuilder:ListComponentBuildVersions",
      "imagebuilder:ListComponents",
      "imagebuilder:ListContainerRecipes",
      "imagebuilder:ListDistributionConfigurations",
      "imagebuilder:ListImageBuildVersions",
      "imagebuilder:ListImagePipelines",
      "imagebuilder:ListImageRecipes",
      "imagebuilder:ListImages",
      "imagebuilder:ListInfrastructureConfigurations",
      "imagebuilder:ListLifecyclePolicies",
      "inspector2:BatchGetAccountStatus",
      "inspector2:GetDelegatedAdminAccount",
      "inspector2:ListFilters",
      "inspector2:ListMembers",
      "iot:DescribeAccountAuditConfiguration",
      "iot:DescribeAuthorizer",
      "iot:DescribeBillingGroup",
      "iot:DescribeCACertificate",
      "iot:DescribeCertificate",
      "iot:DescribeCustomMetric",
      "iot:DescribeDimension",
      "iot:DescribeDomainConfiguration",
      "iot:DescribeFleetMetric",
      "iot:DescribeJobTemplate",
      "iot:DescribeMitigationAction",
      "iot:DescribeProvisioningTemplate",
      "iot:DescribeRoleAlias",
      "iot:DescribeScheduledAudit",
      "iot:DescribeSecurityProfile",
      "iot:GetPolicy",
      "iot:GetTopicRule",
      "iot:GetTopicRuleDestination",
      "iot:ListAuthorizers",
      "iot:ListBillingGroups",
      "iot:ListCACertificates",
      "iot:ListCertificates",
      "iot:ListCustomMetrics",
      "iot:ListDimensions",
      "iot:ListDomainConfigurations",
      "iot:ListFleetMetrics",
      "iot:ListJobTemplates",
      "iot:ListMitigationActions",
      "iot:ListPolicies",
      "iot:ListProvisioningTemplates",
      "iot:ListRoleAliases",
      "iot:ListScheduledAudits",
      "iot:ListSecurityProfiles",
      "iot:ListSecurityProfilesForTarget",
      "iot:ListTagsForResource",
      "iot:ListTargetsForSecurityProfile",
      "iot:ListTopicRuleDestinations",
      "iot:ListTopicRules",
      "iot:ListV2LoggingLevels",
      "iot:ValidateSecurityProfileBehaviors",
      "iotanalytics:DescribeChannel",
      "iotanalytics:DescribeDataset",
      "iotanalytics:DescribeDatastore",
      "iotanalytics:DescribePipeline",
      "iotanalytics:ListChannels",
      "iotanalytics:ListDatasets",
      "iotanalytics:ListDatastores",
      "iotanalytics:ListPipelines",
      "iotanalytics:ListTagsForResource",
      "iotevents:DescribeAlarmModel",
      "iotevents:DescribeDetectorModel",
      "iotevents:DescribeInput",
      "iotevents:ListAlarmModels",
      "iotevents:ListDetectorModels",
      "iotevents:ListInputs",
      "iotevents:ListTagsForResource",
      "iotsitewise:DescribeAccessPolicy",
      "iotsitewise:DescribeAsset",
      "iotsitewise:DescribeAssetModel",
      "iotsitewise:DescribeDashboard",
      "iotsitewise:DescribeGateway",
      "iotsitewise:DescribePortal",
      "iotsitewise:DescribeProject",
      "iotsitewise:ListAccessPolicies",
      "iotsitewise:ListAssetModels",
      "iotsitewise:ListAssets",
      "iotsitewise:ListDashboards",
      "iotsitewise:ListGateways",
      "iotsitewise:ListPortals",
      "iotsitewise:ListProjectAssets",
      "iotsitewise:ListProjects",
      "iotsitewise:ListTagsForResource",
      "iottwinmaker:GetComponentType",
      "iottwinmaker:GetEntity",
      "iottwinmaker:GetScene",
      "iottwinmaker:GetSyncJob",
      "iottwinmaker:GetWorkspace",
      "iottwinmaker:ListComponentTypes",
      "iottwinmaker:ListEntities",
      "iottwinmaker:ListScenes",
      "iottwinmaker:ListSyncJobs",
      "iottwinmaker:ListTagsForResource",
      "iottwinmaker:ListWorkspaces",
      "iotwireless:GetFuotaTask",
      "iotwireless:GetMulticastGroup",
      "iotwireless:GetServiceProfile",
      "iotwireless:GetWirelessDevice",
      "iotwireless:GetWirelessGatewayTaskDefinition",
      "iotwireless:ListFuotaTasks",
      "iotwireless:ListMulticastGroups",
      "iotwireless:ListServiceProfiles",
      "iotwireless:ListTagsForResource",
      "iotwireless:ListWirelessDevices",
      "iotwireless:ListWirelessGatewayTaskDefinitions",
      "ivs:GetChannel",
      "ivs:GetEncoderConfiguration",
      "ivs:GetPlaybackKeyPair",
      "ivs:GetPlaybackRestrictionPolicy",
      "ivs:GetRecordingConfiguration",
      "ivs:GetStage",
      "ivs:GetStorageConfiguration",
      "ivs:GetStreamKey",
      "ivs:ListChannels",
      "ivs:ListEncoderConfigurations",
      "ivs:ListPlaybackKeyPairs",
      "ivs:ListPlaybackRestrictionPolicies",
      "ivs:ListRecordingConfigurations",
      "ivs:ListStages",
      "ivs:ListStorageConfigurations",
      "ivs:ListStreamKeys",
      "ivs:ListTagsForResource",
      "kafka:DescribeCluster",
      "kafka:DescribeClusterV2",
      "kafka:DescribeConfiguration",
      "kafka:DescribeConfigurationRevision",
      "kafka:DescribeVpcConnection",
      "kafka:GetClusterPolicy",
      "kafka:ListClusters",
      "kafka:ListClustersV2",
      "kafka:ListConfigurations",
      "kafka:ListScramSecrets",
      "kafka:ListTagsForResource",
      "kafka:ListVpcConnections",
      "kafkaconnect:DescribeConnector",
      "kafkaconnect:ListConnectors",
      "kendra:DescribeIndex",
      "kendra:ListIndices",
      "kendra:ListTagsForResource",
      "kinesis:DescribeStreamConsumer",
      "kinesis:DescribeStreamSummary",
      "kinesis:ListStreamConsumers",
      "kinesis:ListStreams",
      "kinesis:ListTagsForStream",
      "kinesisanalytics:DescribeApplication",
      "kinesisanalytics:ListApplications",
      "kinesisanalytics:ListTagsForResource",
      "kinesisvideo:DescribeSignalingChannel",
      "kinesisvideo:DescribeStream",
      "kinesisvideo:ListSignalingChannels",
      "kinesisvideo:ListStreams",
      "kinesisvideo:ListTagsForResource",
      "kinesisvideo:ListTagsForStream",
      "kms:DescribeKey",
      "kms:GetKeyPolicy",
      "kms:GetKeyRotationStatus",
      "kms:ListAliases",
      "kms:ListKeys",
      "kms:ListResourceTags",
      "lakeformation:DescribeResource",
      "lakeformation:GetDataLakeSettings",
      "lakeformation:ListPermissions",
      "lakeformation:ListResources",
      "lambda:GetAlias",
      "lambda:GetCodeSigningConfig",
      "lambda:GetFunction",
      "lambda:GetFunctionCodeSigningConfig",
      "lambda:GetLayerVersion",
      "lambda:GetPolicy",
      "lambda:ListAliases",
      "lambda:ListCodeSigningConfigs",
      "lambda:ListFunctions",
      "lambda:ListLayers",
      "lambda:ListLayerVersions",
      "lambda:ListTags",
      "lambda:ListVersionsByFunction",
      "lex:DescribeBot",
      "lex:DescribeBotAlias",
      "lex:DescribeBotVersion",
      "lex:DescribeResourcePolicy",
      "lex:ListBotAliases",
      "lex:ListBotLocales",
      "lex:ListBots",
      "lex:ListBotVersions",
      "lex:ListTagsForResource",
      "license-manager:GetGrant",
      "license-manager:GetLicense",
      "license-manager:ListDistributedGrants",
      "license-manager:ListLicenses",
      "license-manager:ListReceivedGrants",
      "lightsail:GetAlarms",
      "lightsail:GetBuckets",
      "lightsail:GetCertificates",
      "lightsail:GetContainerServices",
      "lightsail:GetDisk",
      "lightsail:GetDisks",
      "lightsail:GetDistributions",
      "lightsail:GetInstance",
      "lightsail:GetInstances",
      "lightsail:GetKeyPair",
      "lightsail:GetLoadBalancer",
      "lightsail:GetLoadBalancers",
      "lightsail:GetLoadBalancerTlsCertificates",
      "lightsail:GetRelationalDatabase",
      "lightsail:GetRelationalDatabaseParameters",
      "lightsail:GetRelationalDatabases",
      "lightsail:GetStaticIp",
      "lightsail:GetStaticIps",
      "logs:DescribeDestinations",
      "logs:DescribeLogGroups",
      "logs:DescribeMetricFilters",
      "logs:GetDataProtectionPolicy",
      "logs:GetLogDelivery",
      "logs:ListLogDeliveries",
      "logs:ListTagsLogGroup",
      "lookoutequipment:DescribeInferenceScheduler",
      "lookoutequipment:ListTagsForResource",
      "lookoutmetrics:DescribeAlert",
      "lookoutmetrics:DescribeAnomalyDetector",
      "lookoutmetrics:ListAlerts",
      "lookoutmetrics:ListAnomalyDetectors",
      "lookoutmetrics:ListMetricSets",
      "lookoutmetrics:ListTagsForResource",
      "lookoutvision:DescribeProject",
      "lookoutvision:ListProjects",
      "m2:GetEnvironment",
      "m2:ListEnvironments",
      "m2:ListTagsForResource",
      "macie2:DescribeOrganizationConfiguration",
      "macie2:GetAutomatedDiscoveryConfiguration",
      "macie2:GetClassificationExportConfiguration",
      "macie2:GetCustomDataIdentifier",
      "macie2:GetFindingsPublicationConfiguration",
      "macie2:GetMacieSession",
      "macie2:ListCustomDataIdentifiers",
      "macie2:ListTagsForResource",
      "managedblockchain:GetMember",
      "managedblockchain:GetNetwork",
      "managedblockchain:GetNode",
      "managedblockchain:ListInvitations",
      "managedblockchain:ListMembers",
      "managedblockchain:ListNodes",
      "mediaconnect:DescribeBridge",
      "mediaconnect:DescribeFlow",
      "mediaconnect:DescribeGateway",
      "mediaconnect:ListBridges",
      "mediaconnect:ListFlows",
      "mediaconnect:ListGateways",
      "mediaconnect:ListTagsForResource",
      "mediapackage-vod:DescribePackagingConfiguration",
      "mediapackage-vod:DescribePackagingGroup",
      "mediapackage-vod:ListPackagingConfigurations",
      "mediapackage-vod:ListPackagingGroups",
      "mediapackage-vod:ListTagsForResource",
      "mediatailor:DescribeChannel",
      "mediatailor:DescribeLiveSource",
      "mediatailor:DescribeSourceLocation",
      "mediatailor:DescribeVodSource",
      "mediatailor:GetPlaybackConfiguration",
      "mediatailor:ListChannels",
      "mediatailor:ListLiveSources",
      "mediatailor:ListPlaybackConfigurations",
      "mediatailor:ListSourceLocations",
      "mediatailor:ListVodSources",
      "memorydb:DescribeAcls",
      "memorydb:DescribeClusters",
      "memorydb:DescribeParameterGroups",
      "memorydb:DescribeParameters",
      "memorydb:DescribeSubnetGroups",
      "memorydb:DescribeUsers",
      "memorydb:ListTags",
      "mobiletargeting:GetApp",
      "mobiletargeting:GetApplicationSettings",
      "mobiletargeting:GetApps",
      "mobiletargeting:GetCampaign",
      "mobiletargeting:GetCampaigns",
      "mobiletargeting:GetEmailChannel",
      "mobiletargeting:GetEmailTemplate",
      "mobiletargeting:GetEventStream",
      "mobiletargeting:GetInAppTemplate",
      "mobiletargeting:GetSegment",
      "mobiletargeting:GetSegments",
      "mobiletargeting:ListTagsForResource",
      "mobiletargeting:ListTemplates",
      "mq:DescribeBroker",
      "mq:ListBrokers",
      "network-firewall:DescribeLoggingConfiguration",
      "network-firewall:ListFirewalls",
      "networkmanager:DescribeGlobalNetworks",
      "networkmanager:GetConnectPeer",
      "networkmanager:GetCustomerGatewayAssociations",
      "networkmanager:GetDevices",
      "networkmanager:GetLinkAssociations",
      "networkmanager:GetLinks",
      "networkmanager:GetSites",
      "networkmanager:GetTransitGatewayRegistrations",
      "networkmanager:ListConnectPeers",
      "networkmanager:ListTagsForResource",
      "nimble:GetLaunchProfile",
      "nimble:GetLaunchProfileDetails",
      "nimble:GetStreamingImage",
      "nimble:GetStudio",
      "nimble:GetStudioComponent",
      "nimble:ListLaunchProfiles",
      "nimble:ListStreamingImages",
      "nimble:ListStudioComponents",
      "nimble:ListStudios",
      "omics:GetWorkflow",
      "omics:ListWorkflows",
      "opsworks:DescribeInstances",
      "opsworks:DescribeLayers",
      "opsworks:DescribeTimeBasedAutoScaling",
      "opsworks:DescribeVolumes",
      "opsworks:ListTags",
      "organizations:DescribeAccount",
      "organizations:DescribeEffectivePolicy",
      "organizations:DescribeOrganization",
      "organizations:DescribeOrganizationalUnit",
      "organizations:DescribePolicy",
      "organizations:DescribeResourcePolicy",
      "organizations:ListAccounts",
      "organizations:ListAccountsForParent",
      "organizations:ListDelegatedAdministrators",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListParents",
      "organizations:ListPolicies",
      "organizations:ListPoliciesForTarget",
      "organizations:ListRoots",
      "organizations:ListTagsForResource",
      "organizations:ListTargetsForPolicy",
      "panorama:DescribeApplicationInstance",
      "panorama:DescribeApplicationInstanceDetails",
      "panorama:DescribePackage",
      "panorama:DescribePackageVersion",
      "panorama:ListApplicationInstances",
      "panorama:ListNodes",
      "panorama:ListPackages",
      "personalize:DescribeDataset",
      "personalize:DescribeDatasetGroup",
      "personalize:DescribeSchema",
      "personalize:DescribeSolution",
      "personalize:ListDatasetGroups",
      "personalize:ListDatasetImportJobs",
      "personalize:ListDatasets",
      "personalize:ListSchemas",
      "personalize:ListSolutions",
      "personalize:ListTagsForResource",
      "profile:GetDomain",
      "profile:GetIntegration",
      "profile:GetProfileObjectType",
      "profile:ListDomains",
      "profile:ListIntegrations",
      "profile:ListProfileObjectTypes",
      "profile:ListTagsForResource",
      "quicksight:DescribeAccountSubscription",
      "quicksight:DescribeAnalysis",
      "quicksight:DescribeAnalysisPermissions",
      "quicksight:DescribeDashboard",
      "quicksight:DescribeDashboardPermissions",
      "quicksight:DescribeDataSet",
      "quicksight:DescribeDataSetPermissions",
      "quicksight:DescribeDataSetRefreshProperties",
      "quicksight:DescribeDataSource",
      "quicksight:DescribeDataSourcePermissions",
      "quicksight:DescribeTemplate",
      "quicksight:DescribeTemplatePermissions",
      "quicksight:DescribeTheme",
      "quicksight:DescribeThemePermissions",
      "quicksight:ListAnalyses",
      "quicksight:ListDashboards",
      "quicksight:ListDataSets",
      "quicksight:ListDataSources",
      "quicksight:ListTagsForResource",
      "quicksight:ListTemplates",
      "quicksight:ListThemes",
      "ram:GetPermission",
      "ram:GetResourceShareAssociations",
      "ram:GetResourceShares",
      "ram:ListPermissionAssociations",
      "ram:ListPermissions",
      "ram:ListPermissionVersions",
      "ram:ListResources",
      "ram:ListResourceSharePermissions",
      "rds:DescribeDBClusterParameterGroups",
      "rds:DescribeDBClusterParameters",
      "rds:DescribeDBClusters",
      "rds:DescribeDBClusterSnapshotAttributes",
      "rds:DescribeDBClusterSnapshots",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeDBParameterGroups",
      "rds:DescribeDBParameters",
      "rds:DescribeDBProxies",
      "rds:DescribeDBProxyEndpoints",
      "rds:DescribeDBSecurityGroups",
      "rds:DescribeDBSnapshotAttributes",
      "rds:DescribeDBSnapshots",
      "rds:DescribeDBSubnetGroups",
      "rds:DescribeEngineDefaultClusterParameters",
      "rds:DescribeEventSubscriptions",
      "rds:DescribeGlobalClusters",
      "rds:DescribeOptionGroups",
      "rds:ListTagsForResource",
      "redshift-serverless:GetNamespace",
      "redshift-serverless:GetWorkgroup",
      "redshift-serverless:ListNamespaces",
      "redshift-serverless:ListTagsForResource",
      "redshift-serverless:ListWorkgroups",
      "redshift:DescribeClusterParameterGroups",
      "redshift:DescribeClusterParameters",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSecurityGroups",
      "redshift:DescribeClusterSnapshots",
      "redshift:DescribeClusterSubnetGroups",
      "redshift:DescribeEndpointAccess",
      "redshift:DescribeEndpointAuthorization",
      "redshift:DescribeEventSubscriptions",
      "redshift:DescribeLoggingStatus",
      "redshift:DescribeScheduledActions",
      "redshift:DescribeTags",
      "refactor-spaces:GetEnvironment",
      "refactor-spaces:GetService",
      "refactor-spaces:ListApplications",
      "refactor-spaces:ListEnvironments",
      "refactor-spaces:ListServices",
      "rekognition:DescribeStreamProcessor",
      "rekognition:ListStreamProcessors",
      "rekognition:ListTagsForResource",
      "resiliencehub:DescribeApp",
      "resiliencehub:DescribeAppVersionTemplate",
      "resiliencehub:DescribeResiliencyPolicy",
      "resiliencehub:ListApps",
      "resiliencehub:ListAppVersionResourceMappings",
      "resiliencehub:ListResiliencyPolicies",
      "resiliencehub:ListTagsForResource",
      "resource-explorer-2:GetIndex",
      "resource-explorer-2:ListIndexes",
      "resource-explorer-2:ListTagsForResource",
      "resource-groups:GetGroup",
      "resource-groups:GetGroupConfiguration",
      "resource-groups:GetGroupQuery",
      "resource-groups:GetTags",
      "resource-groups:ListGroupResources",
      "resource-groups:ListGroups",
      "robomaker:DescribeRobotApplication",
      "robomaker:DescribeSimulationApplication",
      "robomaker:ListRobotApplications",
      "robomaker:ListSimulationApplications",
      "route53-recovery-control-config:DescribeCluster",
      "route53-recovery-control-config:DescribeControlPanel",
      "route53-recovery-control-config:DescribeRoutingControl",
      "route53-recovery-control-config:DescribeSafetyRule",
      "route53-recovery-control-config:ListClusters",
      "route53-recovery-control-config:ListControlPanels",
      "route53-recovery-control-config:ListRoutingControls",
      "route53-recovery-control-config:ListSafetyRules",
      "route53-recovery-control-config:ListTagsForResource",
      "route53-recovery-readiness:GetCell",
      "route53-recovery-readiness:GetReadinessCheck",
      "route53-recovery-readiness:GetRecoveryGroup",
      "route53-recovery-readiness:GetResourceSet",
      "route53-recovery-readiness:ListCells",
      "route53-recovery-readiness:ListReadinessChecks",
      "route53-recovery-readiness:ListRecoveryGroups",
      "route53-recovery-readiness:ListResourceSets",
      "route53:GetChange",
      "route53:GetDNSSEC",
      "route53:GetHealthCheck",
      "route53:GetHostedZone",
      "route53:ListCidrBlocks",
      "route53:ListCidrCollections",
      "route53:ListCidrLocations",
      "route53:ListHealthChecks",
      "route53:ListHostedZones",
      "route53:ListHostedZonesByName",
      "route53:ListQueryLoggingConfigs",
      "route53:ListResourceRecordSets",
      "route53:ListTagsForResource",
      "route53resolver:GetFirewallDomainList",
      "route53resolver:GetFirewallRuleGroup",
      "route53resolver:GetFirewallRuleGroupAssociation",
      "route53resolver:GetResolverDnssecConfig",
      "route53resolver:GetResolverEndpoint",
      "route53resolver:GetResolverQueryLogConfig",
      "route53resolver:GetResolverQueryLogConfigAssociation",
      "route53resolver:GetResolverRule",
      "route53resolver:GetResolverRuleAssociation",
      "route53resolver:ListFirewallDomainLists",
      "route53resolver:ListFirewallDomains",
      "route53resolver:ListFirewallRuleGroupAssociations",
      "route53resolver:ListFirewallRuleGroups",
      "route53resolver:ListFirewallRules",
      "route53resolver:ListResolverDnssecConfigs",
      "route53resolver:ListResolverEndpointIpAddresses",
      "route53resolver:ListResolverEndpoints",
      "route53resolver:ListResolverQueryLogConfigAssociations",
      "route53resolver:ListResolverQueryLogConfigs",
      "route53resolver:ListResolverRuleAssociations",
      "route53resolver:ListResolverRules",
      "route53resolver:ListTagsForResource",
      "rum:GetAppMonitor",
      "rum:GetAppMonitorData",
      "rum:ListAppMonitors",
      "rum:ListTagsForResource",
      "s3-outposts:GetAccessPoint",
      "s3-outposts:GetAccessPointPolicy",
      "s3-outposts:GetBucket",
      "s3-outposts:GetBucketPolicy",
      "s3-outposts:GetBucketTagging",
      "s3-outposts:GetLifecycleConfiguration",
      "s3-outposts:ListAccessPoints",
      "s3-outposts:ListEndpoints",
      "s3-outposts:ListRegionalBuckets",
      "s3:GetAccelerateConfiguration",
      "s3:GetAccessPoint",
      "s3:GetAccessPointForObjectLambda",
      "s3:GetAccessPointPolicy",
      "s3:GetAccessPointPolicyForObjectLambda",
      "s3:GetAccessPointPolicyStatus",
      "s3:GetAccessPointPolicyStatusForObjectLambda",
      "s3:GetAccountPublicAccessBlock",
      "s3:GetBucketAcl",
      "s3:GetBucketCORS",
      "s3:GetBucketLocation",
      "s3:GetBucketLogging",
      "s3:GetBucketNotification",
      "s3:GetBucketObjectLockConfiguration",
      "s3:GetBucketPolicy",
      "s3:GetBucketPolicyStatus",
      "s3:GetBucketPublicAccessBlock",
      "s3:GetBucketRequestPayment",
      "s3:GetBucketTagging",
      "s3:GetBucketVersioning",
      "s3:GetBucketWebsite",
      "s3:GetEncryptionConfiguration",
      "s3:GetLifecycleConfiguration",
      "s3:GetMultiRegionAccessPoint",
      "s3:GetMultiRegionAccessPointPolicy",
      "s3:GetMultiRegionAccessPointPolicyStatus",
      "s3:GetReplicationConfiguration",
      "s3:GetStorageLensConfiguration",
      "s3:GetStorageLensConfigurationTagging",
      "s3:ListAccessPoints",
      "s3:ListAccessPointsForObjectLambda",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "s3:ListMultiRegionAccessPoints",
      "s3:ListStorageLensConfigurations",
      "s3express:GetBucketPolicy",
      "s3express:ListAllMyDirectoryBuckets",
      "sagemaker:DescribeAppImageConfig",
      "sagemaker:DescribeCodeRepository",
      "sagemaker:DescribeDataQualityJobDefinition",
      "sagemaker:DescribeDeviceFleet",
      "sagemaker:DescribeDomain",
      "sagemaker:DescribeEndpoint",
      "sagemaker:DescribeEndpointConfig",
      "sagemaker:DescribeFeatureGroup",
      "sagemaker:DescribeImage",
      "sagemaker:DescribeImageVersion",
      "sagemaker:DescribeInferenceExperiment",
      "sagemaker:DescribeModel",
      "sagemaker:DescribeModelBiasJobDefinition",
      "sagemaker:DescribeModelExplainabilityJobDefinition",
      "sagemaker:DescribeModelQualityJobDefinition",
      "sagemaker:DescribeMonitoringSchedule",
      "sagemaker:DescribeNotebookInstance",
      "sagemaker:DescribeNotebookInstanceLifecycleConfig",
      "sagemaker:DescribePipeline",
      "sagemaker:DescribeProject",
      "sagemaker:DescribeWorkteam",
      "sagemaker:ListAppImageConfigs",
      "sagemaker:ListCodeRepositories",
      "sagemaker:ListDataQualityJobDefinitions",
      "sagemaker:ListDeviceFleets",
      "sagemaker:ListDomains",
      "sagemaker:ListEndpointConfigs",
      "sagemaker:ListEndpoints",
      "sagemaker:ListFeatureGroups",
      "sagemaker:ListImages",
      "sagemaker:ListImageVersions",
      "sagemaker:ListInferenceExperiments",
      "sagemaker:ListModelBiasJobDefinitions",
      "sagemaker:ListModelExplainabilityJobDefinitions",
      "sagemaker:ListModelQualityJobDefinitions",
      "sagemaker:ListModels",
      "sagemaker:ListMonitoringSchedules",
      "sagemaker:ListNotebookInstanceLifecycleConfigs",
      "sagemaker:ListNotebookInstances",
      "sagemaker:ListPipelines",
      "sagemaker:ListProjects",
      "sagemaker:ListTags",
      "sagemaker:ListWorkteams",
      "scheduler:GetSchedule",
      "scheduler:ListSchedules",
      "schemas:DescribeDiscoverer",
      "schemas:DescribeRegistry",
      "schemas:DescribeSchema",
      "schemas:GetResourcePolicy",
      "schemas:ListDiscoverers",
      "schemas:ListRegistries",
      "schemas:ListSchemas",
      "sdb:GetAttributes",
      "sdb:ListDomains",
      "secretsmanager:ListSecrets",
      "secretsmanager:ListSecretVersionIds",
      "securityhub:DescribeHub",
      "serviceCatalog:DescribePortfolioShares",
      "servicediscovery:GetInstance",
      "servicediscovery:GetNamespace",
      "servicediscovery:GetService",
      "servicediscovery:ListInstances",
      "servicediscovery:ListNamespaces",
      "servicediscovery:ListServices",
      "servicediscovery:ListTagsForResource",
      "ses:DescribeReceiptRule",
      "ses:DescribeReceiptRuleSet",
      "ses:GetConfigurationSet",
      "ses:GetConfigurationSetEventDestinations",
      "ses:GetContactList",
      "ses:GetEmailTemplate",
      "ses:GetTemplate",
      "ses:ListConfigurationSets",
      "ses:ListContactLists",
      "ses:ListEmailTemplates",
      "ses:ListReceiptFilters",
      "ses:ListReceiptRuleSets",
      "ses:ListTemplates",
      "shield:DescribeDRTAccess",
      "shield:DescribeProtection",
      "shield:DescribeSubscription",
      "signer:GetSigningProfile",
      "signer:ListProfilePermissions",
      "signer:ListSigningProfiles",
      "sns:GetDataProtectionPolicy",
      "sns:GetSMSSandboxAccountStatus",
      "sns:GetSubscriptionAttributes",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptions",
      "sns:ListSubscriptionsByTopic",
      "sns:ListTagsForResource",
      "sns:ListTopics",
      "sqs:GetQueueAttributes",
      "sqs:ListQueues",
      "sqs:ListQueueTags",
      "ssm-sap:ListTagsForResource",
      "ssm:DescribeAutomationExecutions",
      "ssm:DescribeDocument",
      "ssm:DescribeDocumentPermission",
      "ssm:DescribeParameters",
      "ssm:GetAutomationExecution",
      "ssm:GetDocument",
      "ssm:ListDocuments",
      "ssm:ListTagsForResource",
      "sso:DescribeInstanceAccessControlAttributeConfiguration",
      "sso:DescribePermissionSet",
      "sso:GetInlinePolicyForPermissionSet",
      "sso:ListManagedPoliciesInPermissionSet",
      "sso:ListPermissionSets",
      "sso:ListTagsForResource",
      "states:DescribeActivity",
      "states:DescribeStateMachine",
      "states:ListActivities",
      "states:ListStateMachines",
      "states:ListTagsForResource",
      "storagegateway:ListGateways",
      "storagegateway:ListTagsForResource",
      "storagegateway:ListVolumes",
      "sts:GetCallerIdentity",
      "support:DescribeCases",
      "synthetics:DescribeCanaries",
      "synthetics:DescribeCanariesLastRun",
      "synthetics:DescribeRuntimeVersions",
      "synthetics:GetCanary",
      "synthetics:GetCanaryRuns",
      "synthetics:GetGroup",
      "synthetics:ListAssociatedGroups",
      "synthetics:ListGroupResources",
      "synthetics:ListGroups",
      "synthetics:ListTagsForResource",
      "tag:GetResources",
      "timestream:DescribeDatabase",
      "timestream:DescribeEndpoints",
      "timestream:DescribeTable",
      "timestream:ListDatabases",
      "timestream:ListTables",
      "timestream:ListTagsForResource",
      "transfer:DescribeAgreement",
      "transfer:DescribeCertificate",
      "transfer:DescribeConnector",
      "transfer:DescribeProfile",
      "transfer:DescribeServer",
      "transfer:DescribeUser",
      "transfer:DescribeWorkflow",
      "transfer:ListAgreements",
      "transfer:ListCertificates",
      "transfer:ListConnectors",
      "transfer:ListProfiles",
      "transfer:ListServers",
      "transfer:ListTagsForResource",
      "transfer:ListUsers",
      "transfer:ListWorkflows",
      "voiceid:DescribeDomain",
      "voiceid:ListTagsForResource",
      "waf-regional:GetLoggingConfiguration",
      "waf-regional:GetWebACL",
      "waf-regional:GetWebACLForResource",
      "waf-regional:ListLoggingConfigurations",
      "waf:GetLoggingConfiguration",
      "waf:GetWebACL",
      "wafv2:GetLoggingConfiguration",
      "wafv2:GetRuleGroup",
      "wafv2:ListRuleGroups",
      "wafv2:ListTagsForResource",
      "workspaces:DescribeConnectionAliases",
      "workspaces:DescribeTags",
      "workspaces:DescribeWorkspaces"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSConfigServiceRolePolicyStatementID"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/config/*",
     "Sid":"AWSConfigSLRLogStatementID"
    },
    {
     "Action":"logs:PutLogEvents",
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/config/*:log-stream:config-rule-evaluation/*",
     "Sid":"AWSConfigSLRLogEventStatementID"
    },
    {
     "Action":[
      "apigateway:GET"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/apis",
      "arn:aws:apigateway:*::/apis/*",
      "arn:aws:apigateway:*::/apis/*/integrations",
      "arn:aws:apigateway:*::/apis/*/integrations/*",
      "arn:aws:apigateway:*::/domainnames",
      "arn:aws:apigateway:*::/clientcertificates",
      "arn:aws:apigateway:*::/clientcertificates/*",
      "arn:aws:apigateway:*::/restapis",
      "arn:aws:apigateway:*::/restapis/*/resources/*/methods/*",
      "arn:aws:apigateway:*::/restapis/*",
      "arn:aws:apigateway:*::/restapis/*/stages/*",
      "arn:aws:apigateway:*::/restapis/*/stages",
      "arn:aws:apigateway:*::/restapis/*/resources",
      "arn:aws:apigateway:*::/restapis/*/resources/*/methods/*/integration",
      "arn:aws:apigateway:*::/restapis/*/resources/*",
      "arn:aws:apigateway:*::/apis/*/routes/*",
      "arn:aws:apigateway:*::/apis/*/routes",
      "arn:aws:apigateway:*::/v2/apis/*/routes",
      "arn:aws:apigateway:*::/v2/apis/*/routes/*",
      "arn:aws:apigateway:*::/v2/apis",
      "arn:aws:apigateway:*::/v2/apis/*",
      "arn:aws:apigateway:*::/v2/apis/*/integrations",
      "arn:aws:apigateway:*::/v2/apis/*/integrations/*"
     ],
     "Sid":"AWSConfigSLRApiGatewayStatementID"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-09-12T22:00:12+00:00"
 },
 "AWSConfigUserAccess":{
  "CreateDate":"2015-02-18T19:38:41+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "config:Get*",
      "config:Describe*",
      "config:Deliver*",
      "config:List*",
      "config:Select*",
      "tag:GetResources",
      "tag:GetTagKeys",
      "cloudtrail:DescribeTrails",
      "cloudtrail:GetTrailStatus",
      "cloudtrail:LookupEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-03-18T20:27:47+00:00"
 },
 "AWSConnector":{
  "CreateDate":"2015-02-11T17:14:31+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":"iam:GetUser",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:DeleteBucket",
      "s3:DeleteObject",
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:PutObject",
      "s3:PutObjectAcl",
      "s3:AbortMultipartUpload",
      "s3:ListBucketMultipartUploads",
      "s3:ListMultipartUploadParts"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::import-to-ec2-*"
    },
    {
     "Action":[
      "ec2:CancelConversionTask",
      "ec2:CancelExportTask",
      "ec2:CreateImage",
      "ec2:CreateInstanceExportTask",
      "ec2:CreateTags",
      "ec2:CreateVolume",
      "ec2:DeleteTags",
      "ec2:DeleteVolume",
      "ec2:DescribeConversionTasks",
      "ec2:DescribeExportTasks",
      "ec2:DescribeImages",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstances",
      "ec2:DescribeRegions",
      "ec2:DescribeTags",
      "ec2:DetachVolume",
      "ec2:ImportInstance",
      "ec2:ImportVolume",
      "ec2:ModifyInstanceAttribute",
      "ec2:RunInstances",
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "ec2:ImportImage",
      "ec2:DescribeImportImageTasks",
      "ec2:DeregisterImage",
      "ec2:DescribeSnapshots",
      "ec2:DeleteSnapshot",
      "ec2:CancelImportTask",
      "ec2:ImportSnapshot",
      "ec2:DescribeImportSnapshotTasks"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "SNS:Publish"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:metrics-sns-topic-for-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-09-28T19:50:38+00:00"
 },
 "AWSControlTowerAccountServiceRolePolicy":{
  "CreateDate":"2023-06-05T22:04:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"events:PutRule",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "events:source":"aws.securityhub"
      },
      "Null":{
       "events:detail-type":"false"
      },
      "StringEquals":{
       "events:ManagedBy":"controltower.amazonaws.com",
       "events:detail-type":"Security Hub Findings - Imported"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/*ControlTower*",
     "Sid":"AllowPutRuleOnSpecificSourcesAndDetailTypes"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:EnableRule",
      "events:DisableRule",
      "events:PutTargets",
      "events:RemoveTargets"
     ],
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"controltower.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/*ControlTower*",
     "Sid":"AllowOtherOperationsOnRulesManagedByControlTower"
    },
    {
     "Action":[
      "events:DescribeRule",
      "events:ListTargetsByRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/*ControlTower*",
     "Sid":"AllowDescribeOperationsOnRulesManagedByControlTower"
    },
    {
     "Action":"sns:publish",
     "Condition":{
      "StringEquals":{
       "aws:PrincipalAccount":"${aws:ResourceAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:aws-controltower-AggregateSecurityNotifications",
     "Sid":"AllowControlTowerToPublishSecurityNotifications"
    },
    {
     "Action":[
      "securityhub:DescribeStandardsControls",
      "securityhub:GetEnabledStandards"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:securityhub:*:*:hub/default",
     "Sid":"AllowActionsForSecurityHubIntegration"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-06-05T22:04:50+00:00"
 },
 "AWSControlTowerServiceRolePolicy":{
  "CreateDate":"2019-05-03T18:19:11+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:CreateStackInstances",
      "cloudformation:CreateStackSet",
      "cloudformation:DeleteStack",
      "cloudformation:DeleteStackInstances",
      "cloudformation:DeleteStackSet",
      "cloudformation:DescribeStackInstance",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeStackSet",
      "cloudformation:DescribeStackSetOperation",
      "cloudformation:ListStackInstances",
      "cloudformation:UpdateStack",
      "cloudformation:UpdateStackInstances",
      "cloudformation:UpdateStackSet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:type/resource/AWS-IAM-Role"
     ]
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:CreateStackInstances",
      "cloudformation:CreateStackSet",
      "cloudformation:DeleteStack",
      "cloudformation:DeleteStackInstances",
      "cloudformation:DeleteStackSet",
      "cloudformation:DescribeStackInstance",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeStackSet",
      "cloudformation:DescribeStackSetOperation",
      "cloudformation:GetTemplate",
      "cloudformation:ListStackInstances",
      "cloudformation:UpdateStack",
      "cloudformation:UpdateStackInstances",
      "cloudformation:UpdateStackSet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/AWSControlTower*/*",
      "arn:aws:cloudformation:*:*:stack/StackSet-AWSControlTower*/*",
      "arn:aws:cloudformation:*:*:stackset/AWSControlTower*:*",
      "arn:aws:cloudformation:*:*:stackset-target/AWSControlTower*/*"
     ]
    },
    {
     "Action":[
      "cloudtrail:CreateTrail",
      "cloudtrail:DeleteTrail",
      "cloudtrail:GetTrailStatus",
      "cloudtrail:StartLogging",
      "cloudtrail:StopLogging",
      "cloudtrail:UpdateTrail",
      "cloudtrail:PutEventSelectors",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:PutRetentionPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:aws-controltower/CloudTrailLogs:*",
      "arn:aws:cloudtrail:*:*:trail/aws-controltower*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-controltower*/*"
     ]
    },
    {
     "Action":[
      "sts:AssumeRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSControlTowerExecution",
      "arn:aws:iam::*:role/AWSControlTowerBlueprintAccess"
     ]
    },
    {
     "Action":[
      "cloudtrail:DescribeTrails",
      "ec2:DescribeAvailabilityZones",
      "iam:ListRoles",
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups",
      "organizations:CreateAccount",
      "organizations:DescribeAccount",
      "organizations:DescribeCreateAccountStatus",
      "organizations:DescribeOrganization",
      "organizations:DescribeOrganizationalUnit",
      "organizations:DescribePolicy",
      "organizations:ListAccounts",
      "organizations:ListAccountsForParent",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListChildren",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListParents",
      "organizations:ListPoliciesForTarget",
      "organizations:ListTargetsForPolicy",
      "organizations:ListRoots",
      "organizations:MoveAccount",
      "servicecatalog:AssociatePrincipalWithPortfolio"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole",
      "iam:GetUser",
      "iam:ListAttachedRolePolicies",
      "iam:GetRolePolicy"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSControlTowerStackSetRole",
      "arn:aws:iam::*:role/service-role/AWSControlTowerCloudTrailRole",
      "arn:aws:iam::*:role/service-role/AWSControlTowerConfigAggregatorRoleForOrganizations"
     ]
    },
    {
     "Action":[
      "config:DeleteConfigurationAggregator",
      "config:PutConfigurationAggregator",
      "config:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/aws-control-tower":"managed-by-control-tower"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:EnableAWSServiceAccess",
      "organizations:DisableAWSServiceAccess"
     ],
     "Condition":{
      "StringLike":{
       "organizations:ServicePrincipal":[
        "config.amazonaws.com",
        "cloudtrail.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"cloudtrail.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "account:EnableRegion",
      "account:ListRegions",
      "account:GetRegionOptStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-04-12T19:15:51+00:00"
 },
 "AWSCostAndUsageReportAutomationPolicy":{
  "CreateDate":"2021-11-01T21:27:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetBucketTagging",
      "s3:PutBucketTagging",
      "s3:GetBucketPolicy",
      "s3:PutBucketPolicy",
      "s3:ListBucket",
      "s3:CreateBucket"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::aws-map-cur-bucket-*"
    },
    {
     "Action":[
      "cur:PutReportDefinition",
      "cur:DeleteReportDefinition",
      "cur:DescribeReportDefinitions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cur:*:*:definition/map-migrated-report"
    },
    {
     "Action":"cur:DescribeReportDefinitions",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-01T21:27:29+00:00"
 },
 "AWSDMSFleetAdvisorServiceRolePolicy":{
  "CreateDate":"2023-03-06T09:10:42+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":"cloudwatch:PutMetricData",
    "Condition":{
     "StringEquals":{
      "cloudwatch:namespace":"AWS/DMS/FleetAdvisor"
     }
    },
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-06T09:10:42+00:00"
 },
 "AWSDMSServerlessServiceRolePolicy":{
  "CreateDate":"2023-05-18T20:28:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dms:CreateReplicationInstance",
      "dms:CreateReplicationTask"
     ],
     "Condition":{
      "StringEquals":{
       "dms:req-tag/ResourceCreatedBy":"DMSServerless"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"id0"
    },
    {
     "Action":[
      "dms:DescribeReplicationInstances",
      "dms:DescribeReplicationTasks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"id1"
    },
    {
     "Action":[
      "dms:StartReplicationTask",
      "dms:StopReplicationTask",
      "dms:DeleteReplicationTask",
      "dms:DeleteReplicationInstance"
     ],
     "Condition":{
      "StringEqualsIgnoreCase":{
       "aws:ResourceTag/ResourceCreatedBy":"DMSServerless"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:dms:*:*:rep:*",
      "arn:aws:dms:*:*:task:*"
     ],
     "Sid":"id2"
    },
    {
     "Action":[
      "dms:TestConnection",
      "dms:DeleteConnection"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:dms:*:*:rep:*",
      "arn:aws:dms:*:*:endpoint:*"
     ],
     "Sid":"id3"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-05-18T20:28:05+00:00"
 },
 "AWSDataExchangeFullAccess":{
  "CreateDate":"2019-11-13T19:27:59+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dataexchange:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DataExchangeActions"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*aws-data-exchange*",
     "Sid":"S3GetActionConditionalResourceAndADX"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      },
      "StringEqualsIgnoreCase":{
       "s3:ExistingObjectTag/AWSDataExchange":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3GetActionConditionalTagAndADX"
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:PutObjectAcl"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*aws-data-exchange*",
     "Sid":"S3WriteActions"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3ReadActions"
    },
    {
     "Action":[
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:ListEntities",
      "aws-marketplace:StartChangeSet",
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:CancelChangeSet",
      "aws-marketplace:GetAgreementApprovalRequest",
      "aws-marketplace:ListAgreementApprovalRequests",
      "aws-marketplace:AcceptAgreementApprovalRequest",
      "aws-marketplace:RejectAgreementApprovalRequest",
      "aws-marketplace:UpdateAgreementApprovalRequest",
      "aws-marketplace:SearchAgreements",
      "aws-marketplace:GetAgreementTerms",
      "aws-marketplace:TagResource",
      "aws-marketplace:UntagResource",
      "aws-marketplace:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSMarketplaceProviderActions"
    },
    {
     "Action":[
      "aws-marketplace:Subscribe",
      "aws-marketplace:Unsubscribe",
      "aws-marketplace:ViewSubscriptions",
      "aws-marketplace:GetAgreementRequest",
      "aws-marketplace:ListAgreementRequests",
      "aws-marketplace:CancelAgreementRequest",
      "aws-marketplace:ListPrivateListings",
      "aws-marketplace:DescribeAgreement"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSMarketplaceSubscriberActions"
    },
    {
     "Action":[
      "kms:DescribeKey",
      "kms:ListAliases",
      "kms:ListKeys"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSActions"
    },
    {
     "Action":[
      "redshift:AuthorizeDataShare"
     ],
     "Condition":{
      "StringEqualsIgnoreCase":{
       "redshift:ConsumerIdentifier":"ADX"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RedshiftConditionalActions"
    },
    {
     "Action":[
      "redshift:DescribeDataSharesForProducer",
      "redshift:DescribeDataShares"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RedshiftActions"
    },
    {
     "Action":[
      "apigateway:GET"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"APIGatewayActions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-24T19:54:18+00:00"
 },
 "AWSDataExchangeProviderFullAccess":{
  "CreateDate":"2019-11-13T19:27:55+00:00",
  "DefaultVersionId":"v12",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dataexchange:CreateDataSet",
      "dataexchange:CreateRevision",
      "dataexchange:CreateAsset",
      "dataexchange:Get*",
      "dataexchange:Update*",
      "dataexchange:List*",
      "dataexchange:Delete*",
      "dataexchange:TagResource",
      "dataexchange:UntagResource",
      "dataexchange:PublishDataSet",
      "dataexchange:SendApiAsset",
      "dataexchange:RevokeRevision",
      "dataexchange:SendDataSetNotification",
      "tag:GetTagKeys",
      "tag:GetTagValues"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DataExchangeActions"
    },
    {
     "Action":[
      "dataexchange:CreateJob",
      "dataexchange:StartJob",
      "dataexchange:CancelJob"
     ],
     "Condition":{
      "StringEquals":{
       "dataexchange:JobType":[
        "IMPORT_ASSETS_FROM_S3",
        "IMPORT_ASSET_FROM_SIGNED_URL",
        "EXPORT_ASSETS_TO_S3",
        "EXPORT_ASSET_TO_SIGNED_URL",
        "IMPORT_ASSET_FROM_API_GATEWAY_API",
        "IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DataExchangeJobsActions"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*aws-data-exchange*",
     "Sid":"S3GetActionConditionalResourceAndADX"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      },
      "StringEqualsIgnoreCase":{
       "s3:ExistingObjectTag/AWSDataExchange":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3GetActionConditionalTagAndADX"
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:PutObjectAcl"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*aws-data-exchange*",
     "Sid":"S3WriteActions"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3ReadActions"
    },
    {
     "Action":[
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:ListEntities",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:StartChangeSet",
      "aws-marketplace:CancelChangeSet",
      "aws-marketplace:GetAgreementApprovalRequest",
      "aws-marketplace:ListAgreementApprovalRequests",
      "aws-marketplace:AcceptAgreementApprovalRequest",
      "aws-marketplace:RejectAgreementApprovalRequest",
      "aws-marketplace:UpdateAgreementApprovalRequest",
      "aws-marketplace:SearchAgreements",
      "aws-marketplace:GetAgreementTerms"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSMarketplaceActions"
    },
    {
     "Action":[
      "kms:DescribeKey",
      "kms:ListAliases",
      "kms:ListKeys"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSActions"
    },
    {
     "Action":[
      "redshift:AuthorizeDataShare"
     ],
     "Condition":{
      "StringEqualsIgnoreCase":{
       "redshift:ConsumerIdentifier":"ADX"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RedshiftConditionalActions"
    },
    {
     "Action":[
      "redshift:DescribeDataSharesForProducer",
      "redshift:DescribeDataShares"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RedshiftActions"
    },
    {
     "Action":[
      "apigateway:GET"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"APIGatewayActions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-08-15T17:32:54+00:00"
 },
 "AWSDataExchangeReadOnly":{
  "CreateDate":"2019-11-13T19:27:37+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dataexchange:GetAsset",
      "dataexchange:GetDataSet",
      "dataexchange:GetEventAction",
      "dataexchange:GetJob",
      "dataexchange:GetRevision",
      "dataexchange:ListDataSetRevisions",
      "dataexchange:ListDataSets",
      "dataexchange:ListEventActions",
      "dataexchange:ListJobs",
      "dataexchange:ListRevisionAssets",
      "dataexchange:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DataExchangeReadOnlyActions"
    },
    {
     "Action":[
      "aws-marketplace:ViewSubscriptions",
      "aws-marketplace:GetAgreementRequest",
      "aws-marketplace:ListAgreementRequests",
      "aws-marketplace:GetAgreementApprovalRequest",
      "aws-marketplace:ListAgreementApprovalRequests",
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:ListEntities",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:SearchAgreements",
      "aws-marketplace:GetAgreementTerms",
      "aws-marketplace:ListPrivateListings",
      "aws-marketplace:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSMarketplaceReadOnlyActions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-07-22T13:36:03+00:00"
 },
 "AWSDataExchangeSubscriberFullAccess":{
  "CreateDate":"2019-11-13T19:27:52+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dataexchange:Get*",
      "dataexchange:List*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DataExchangeReadOnlyActions"
    },
    {
     "Action":[
      "dataexchange:CreateJob",
      "dataexchange:StartJob",
      "dataexchange:CancelJob"
     ],
     "Condition":{
      "StringEquals":{
       "dataexchange:JobType":[
        "EXPORT_ASSETS_TO_S3",
        "EXPORT_ASSET_TO_SIGNED_URL",
        "EXPORT_REVISIONS_TO_S3"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DataExchangeExportActions"
    },
    {
     "Action":[
      "dataexchange:CreateEventAction",
      "dataexchange:UpdateEventAction",
      "dataexchange:DeleteEventAction",
      "dataexchange:SendApiAsset"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DataExchangeEventActionActions"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "dataexchange.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*aws-data-exchange*",
     "Sid":"S3GetActionConditionalResourceAndADX"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3ReadActions"
    },
    {
     "Action":[
      "aws-marketplace:Subscribe",
      "aws-marketplace:Unsubscribe",
      "aws-marketplace:ViewSubscriptions",
      "aws-marketplace:GetAgreementRequest",
      "aws-marketplace:ListAgreementRequests",
      "aws-marketplace:CancelAgreementRequest",
      "aws-marketplace:ListPrivateListings"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSMarketplaceSubscriberActions"
    },
    {
     "Action":[
      "kms:DescribeKey",
      "kms:ListAliases",
      "kms:ListKeys"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSActions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-21T17:36:35+00:00"
 },
 "AWSDataLifecycleManagerSSMFullAccess":{
  "CreateDate":"2023-10-31T20:29:44+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:GetCommandInvocation",
      "ssm:ListCommands",
      "ssm:DescribeInstanceInformation"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowSSMReadOnlyAccess"
    },
    {
     "Action":[
      "ssm:SendCommand",
      "ssm:DescribeDocument",
      "ssm:GetDocument"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/DLMScriptsAccess":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/*"
     ],
     "Sid":"AllowTaggedSSMDocumentsOnly"
    },
    {
     "Action":[
      "ssm:SendCommand",
      "ssm:DescribeDocument",
      "ssm:GetDocument"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSEC2-CreateVssSnapshot",
      "arn:aws:ssm:*:*:document/AWSSystemsManagerSAP-CreateDLMSnapshotForSAPHANA"
     ],
     "Sid":"AllowSpecificAWSOwnedSSMDocuments"
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"AllowAllEC2Instances"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-16T22:31:54+00:00"
 },
 "AWSDataLifecycleManagerServiceRole":{
  "CreateDate":"2018-07-06T19:34:16+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateSnapshot",
      "ec2:CreateSnapshots",
      "ec2:DeleteSnapshot",
      "ec2:DescribeInstances",
      "ec2:DescribeVolumes",
      "ec2:DescribeSnapshots",
      "ec2:EnableFastSnapshotRestores",
      "ec2:DescribeFastSnapshotRestores",
      "ec2:DisableFastSnapshotRestores",
      "ec2:CopySnapshot",
      "ec2:ModifySnapshotAttribute",
      "ec2:DescribeSnapshotAttribute",
      "ec2:DescribeSnapshotTierStatus",
      "ec2:ModifySnapshotTier"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":[
      "events:PutRule",
      "events:DeleteRule",
      "events:DescribeRule",
      "events:EnableRule",
      "events:DisableRule",
      "events:ListTargetsByRule",
      "events:PutTargets",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/AwsDataLifecycleRule.managed-cwe.*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-09-19T17:34:08+00:00"
 },
 "AWSDataLifecycleManagerServiceRoleForAMIManagement":{
  "CreateDate":"2020-10-21T19:39:41+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"ec2:CreateTags",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*::image/*"
     ]
    },
    {
     "Action":[
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeImageAttribute",
      "ec2:DescribeVolumes",
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:DeleteSnapshot",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":[
      "ec2:ResetImageAttribute",
      "ec2:DeregisterImage",
      "ec2:CreateImage",
      "ec2:CopyImage",
      "ec2:ModifyImageAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:EnableImageDeprecation",
      "ec2:DisableImageDeprecation"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::image/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-19T17:03:44+00:00"
 },
 "AWSDataPipeline_FullAccess":{
  "CreateDate":"2017-01-19T23:14:54+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:List*",
      "dynamodb:DescribeTable",
      "rds:DescribeDBInstances",
      "rds:DescribeDBSecurityGroups",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSecurityGroups",
      "sns:ListTopics",
      "sns:Subscribe",
      "iam:ListRoles",
      "iam:GetRolePolicy",
      "iam:GetInstanceProfile",
      "iam:ListInstanceProfiles",
      "datapipeline:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/DataPipelineDefaultResourceRole",
      "arn:aws:iam::*:role/DataPipelineDefaultRole"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-08-17T18:48:39+00:00"
 },
 "AWSDataPipeline_PowerUser":{
  "CreateDate":"2017-01-19T23:16:46+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:List*",
      "dynamodb:DescribeTable",
      "rds:DescribeDBInstances",
      "rds:DescribeDBSecurityGroups",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSecurityGroups",
      "sns:ListTopics",
      "iam:ListRoles",
      "iam:GetRolePolicy",
      "iam:GetInstanceProfile",
      "iam:ListInstanceProfiles",
      "datapipeline:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/DataPipelineDefaultResourceRole",
      "arn:aws:iam::*:role/DataPipelineDefaultRole"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-08-17T18:49:42+00:00"
 },
 "AWSDataSyncDiscoveryServiceRolePolicy":{
  "CreateDate":"2023-03-20T22:19:51+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}",
       "secretsmanager:ResourceTag/aws:secretsmanager:owningService":"datasync"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:*:secretsmanager:*:*:secret:datasync!*"
     ]
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:*:logs:*:*:log-group:/aws/datasync*"
     ]
    },
    {
     "Action":[
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:*:logs:*:*:log-group:/aws/datasync:log-stream:*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-20T22:19:51+00:00"
 },
 "AWSDataSyncFullAccess":{
  "CreateDate":"2019-01-18T19:40:36+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "datasync:*",
      "ec2:CreateNetworkInterface",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeRegions",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcEndpoints",
      "ec2:ModifyNetworkInterfaceAttribute",
      "fsx:DescribeFileSystems",
      "fsx:DescribeStorageVirtualMachines",
      "elasticfilesystem:DescribeAccessPoints",
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:DescribeMountTargets",
      "iam:GetRole",
      "iam:ListRoles",
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups",
      "logs:DescribeResourcePolicies",
      "outposts:ListOutposts",
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "s3:ListBucketVersions",
      "s3-outposts:ListAccessPoints",
      "s3-outposts:ListRegionalBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DataSyncFullAccessPermissions"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "datasync.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DataSyncPassRolePermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-07-22T16:13:41+00:00"
 },
 "AWSDataSyncReadOnlyAccess":{
  "CreateDate":"2019-01-18T19:18:44+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "datasync:Describe*",
      "datasync:List*",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:DescribeMountTargets",
      "fsx:DescribeFileSystems",
      "iam:GetRole",
      "iam:ListRoles",
      "logs:DescribeLogGroups",
      "logs:DescribeResourcePolicies",
      "s3:ListAllMyBuckets",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-30T17:59:22+00:00"
 },
 "AWSDeadlineCloud-FleetWorker":{
  "CreateDate":"2024-04-01T17:21:47+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "deadline:AssumeFleetRoleForWorker",
      "deadline:UpdateWorker",
      "deadline:UpdateWorkerSchedule",
      "deadline:BatchGetJobEntity",
      "deadline:AssumeQueueRoleForWorker"
     ],
     "Condition":{
      "StringEquals":{
       "aws:PrincipalAccount":"${aws:ResourceAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RunTasksPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-01T17:21:47+00:00"
 },
 "AWSDeadlineCloud-UserAccessFarms":{
  "CreateDate":"2024-04-01T16:54:00+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "identitystore:DescribeGroup",
      "identitystore:DescribeUser",
      "identitystore:ListGroupMembershipsForMember",
      "deadline:GetApplicationVersion",
      "ec2:DescribeInstanceTypes",
      "identitystore:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AdditionalPermissions"
    },
    {
     "Action":[
      "deadline:AssociateMemberToFarm",
      "deadline:AssociateMemberToFleet",
      "deadline:AssociateMemberToJob",
      "deadline:AssociateMemberToQueue",
      "deadline:CreateBudget",
      "deadline:DeleteBudget",
      "deadline:DisassociateMemberFromFarm",
      "deadline:DisassociateMemberFromFleet",
      "deadline:DisassociateMemberFromJob",
      "deadline:DisassociateMemberFromQueue",
      "deadline:GetBudget",
      "deadline:GetSessionsStatisticsAggregation",
      "deadline:ListBudgets",
      "deadline:StartSessionsStatisticsAggregation",
      "deadline:UpdateBudget"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:FarmMembershipLevels":[
        "OWNER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OwnerLevelPermissions"
    },
    {
     "Action":[
      "deadline:AssociateMemberToFarm",
      "deadline:AssociateMemberToFleet",
      "deadline:AssociateMemberToJob",
      "deadline:AssociateMemberToQueue"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:FarmMembershipLevels":[
        "MANAGER"
       ]
      },
      "StringEquals":{
       "deadline:AssociatedMembershipLevel":[
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER",
        ""
       ],
       "deadline:MembershipLevel":[
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ManagerLevelMemberAssociation"
    },
    {
     "Action":[
      "deadline:DisassociateMemberFromFarm",
      "deadline:DisassociateMemberFromFleet",
      "deadline:DisassociateMemberFromJob",
      "deadline:DisassociateMemberFromQueue"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:FarmMembershipLevels":[
        "MANAGER"
       ]
      },
      "StringEquals":{
       "deadline:AssociatedMembershipLevel":[
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER",
        ""
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ManagerLevelMemberDisassociation"
    },
    {
     "Action":[
      "deadline:ListFarmMembers",
      "deadline:ListFleetMembers",
      "deadline:ListJobMembers",
      "deadline:ListQueueMembers",
      "deadline:UpdateJob",
      "deadline:UpdateSession",
      "deadline:UpdateStep",
      "deadline:UpdateTask"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:FarmMembershipLevels":[
        "OWNER",
        "MANAGER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OwnerManagerPermissions"
    },
    {
     "Action":[
      "deadline:AssumeQueueRoleForUser",
      "deadline:CreateJob"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:FarmMembershipLevels":[
        "OWNER",
        "MANAGER",
        "CONTRIBUTOR"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OwnerManagerContributorPermissions"
    },
    {
     "Action":[
      "deadline:AssumeFleetRoleForRead",
      "deadline:AssumeQueueRoleForRead",
      "deadline:GetFarm",
      "deadline:GetFleet",
      "deadline:GetJob",
      "deadline:GetQueue",
      "deadline:GetQueueEnvironment",
      "deadline:GetQueueFleetAssociation",
      "deadline:GetSession",
      "deadline:GetSessionAction",
      "deadline:GetStep",
      "deadline:GetStorageProfile",
      "deadline:GetStorageProfileForQueue",
      "deadline:GetTask",
      "deadline:GetWorker",
      "deadline:ListQueueEnvironments",
      "deadline:ListQueueFleetAssociations",
      "deadline:ListSessionActions",
      "deadline:ListSessions",
      "deadline:ListSessionsForWorker",
      "deadline:ListStepConsumers",
      "deadline:ListStepDependencies",
      "deadline:ListSteps",
      "deadline:ListStorageProfiles",
      "deadline:ListStorageProfilesForQueue",
      "deadline:ListTasks",
      "deadline:ListWorkers",
      "deadline:SearchJobs",
      "deadline:SearchSteps",
      "deadline:SearchTasks",
      "deadline:SearchWorkers"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:FarmMembershipLevels":[
        "OWNER",
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllLevelsPermissions"
    },
    {
     "Action":[
      "deadline:ListFarms",
      "deadline:ListFleets",
      "deadline:ListJobs",
      "deadline:ListQueues"
     ],
     "Condition":{
      "StringEquals":{
       "deadline:RequesterPrincipalId":"${deadline:PrincipalId}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ListBasedOnMembership"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-01T16:54:00+00:00"
 },
 "AWSDeadlineCloud-UserAccessFleets":{
  "CreateDate":"2024-04-01T17:01:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "identitystore:DescribeGroup",
      "identitystore:DescribeUser",
      "identitystore:ListGroupMembershipsForMember",
      "deadline:GetApplicationVersion",
      "ec2:DescribeInstanceTypes",
      "identitystore:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AdditionalPermissions"
    },
    {
     "Action":[
      "deadline:AssociateMemberToFleet",
      "deadline:DisassociateMemberFromFleet"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:FleetMembershipLevels":[
        "OWNER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OwnerLevelPermissions"
    },
    {
     "Action":[
      "deadline:AssociateMemberToFleet"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:FleetMembershipLevels":[
        "MANAGER"
       ]
      },
      "StringEquals":{
       "deadline:AssociatedMembershipLevel":[
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER",
        ""
       ],
       "deadline:MembershipLevel":[
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ManagerLevelMemberAssociation"
    },
    {
     "Action":[
      "deadline:DisassociateMemberFromFleet"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:FleetMembershipLevels":[
        "MANAGER"
       ]
      },
      "StringEquals":{
       "deadline:AssociatedMembershipLevel":[
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER",
        ""
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ManagerLevelMemberDisassociation"
    },
    {
     "Action":[
      "deadline:ListFleetMembers"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:FleetMembershipLevels":[
        "OWNER",
        "MANAGER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OwnerManagerPermissions"
    },
    {
     "Action":[
      "deadline:AssumeFleetRoleForRead",
      "deadline:GetFleet",
      "deadline:GetQueueFleetAssociation",
      "deadline:GetWorker",
      "deadline:ListQueueFleetAssociations",
      "deadline:ListSessionsForWorker",
      "deadline:ListWorkers",
      "deadline:SearchWorkers"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:FleetMembershipLevels":[
        "OWNER",
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllLevelsPermissions"
    },
    {
     "Action":[
      "deadline:ListFleets"
     ],
     "Condition":{
      "StringEquals":{
       "deadline:RequesterPrincipalId":"${deadline:PrincipalId}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ListBasedOnMembership"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-01T17:01:50+00:00"
 },
 "AWSDeadlineCloud-UserAccessJobs":{
  "CreateDate":"2024-04-01T17:05:38+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "identitystore:DescribeGroup",
      "identitystore:DescribeUser",
      "identitystore:ListGroupMembershipsForMember",
      "deadline:GetApplicationVersion",
      "ec2:DescribeInstanceTypes",
      "identitystore:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AdditionalPermissions"
    },
    {
     "Action":[
      "deadline:AssociateMemberToJob",
      "deadline:DisassociateMemberFromJob"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:JobMembershipLevels":[
        "OWNER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OwnerLevelPermissions"
    },
    {
     "Action":[
      "deadline:AssociateMemberToJob"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:JobMembershipLevels":[
        "MANAGER"
       ]
      },
      "StringEquals":{
       "deadline:AssociatedMembershipLevel":[
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER",
        ""
       ],
       "deadline:MembershipLevel":[
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ManagerLevelMemberAssociation"
    },
    {
     "Action":[
      "deadline:DisassociateMemberFromJob"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:JobMembershipLevels":[
        "MANAGER"
       ]
      },
      "StringEquals":{
       "deadline:AssociatedMembershipLevel":[
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER",
        ""
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ManagerLevelMemberDisassociation"
    },
    {
     "Action":[
      "deadline:ListJobMembers",
      "deadline:UpdateJob",
      "deadline:UpdateSession",
      "deadline:UpdateStep",
      "deadline:UpdateTask"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:JobMembershipLevels":[
        "OWNER",
        "MANAGER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OwnerManagerPermissions"
    },
    {
     "Action":[
      "deadline:GetJob",
      "deadline:GetSession",
      "deadline:GetSessionAction",
      "deadline:GetStep",
      "deadline:GetTask",
      "deadline:ListSessionActions",
      "deadline:ListSessions",
      "deadline:ListStepConsumers",
      "deadline:ListStepDependencies",
      "deadline:ListSteps",
      "deadline:ListTasks",
      "deadline:SearchSteps",
      "deadline:SearchTasks"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:JobMembershipLevels":[
        "OWNER",
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllLevelsPermissions"
    },
    {
     "Action":[
      "deadline:ListJobs"
     ],
     "Condition":{
      "StringEquals":{
       "deadline:RequesterPrincipalId":"${deadline:PrincipalId}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ListBasedOnMembership"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-01T17:05:38+00:00"
 },
 "AWSDeadlineCloud-UserAccessQueues":{
  "CreateDate":"2024-04-01T17:10:03+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "identitystore:DescribeGroup",
      "identitystore:DescribeUser",
      "identitystore:ListGroupMembershipsForMember",
      "deadline:GetApplicationVersion",
      "ec2:DescribeInstanceTypes",
      "identitystore:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AdditionalPermissions"
    },
    {
     "Action":[
      "deadline:AssociateMemberToJob",
      "deadline:AssociateMemberToQueue",
      "deadline:DisassociateMemberFromJob",
      "deadline:DisassociateMemberFromQueue"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:QueueMembershipLevels":[
        "OWNER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OwnerLevelPermissions"
    },
    {
     "Action":[
      "deadline:AssociateMemberToJob",
      "deadline:AssociateMemberToQueue"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:QueueMembershipLevels":[
        "MANAGER"
       ]
      },
      "StringEquals":{
       "deadline:AssociatedMembershipLevel":[
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER",
        ""
       ],
       "deadline:MembershipLevel":[
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ManagerLevelMemberAssociation"
    },
    {
     "Action":[
      "deadline:DisassociateMemberFromJob",
      "deadline:DisassociateMemberFromQueue"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:QueueMembershipLevels":[
        "MANAGER"
       ]
      },
      "StringEquals":{
       "deadline:AssociatedMembershipLevel":[
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER",
        ""
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ManagerLevelMemberDisassociation"
    },
    {
     "Action":[
      "deadline:ListJobMembers",
      "deadline:ListQueueMembers",
      "deadline:UpdateJob",
      "deadline:UpdateSession",
      "deadline:UpdateStep",
      "deadline:UpdateTask"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:QueueMembershipLevels":[
        "OWNER",
        "MANAGER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OwnerManagerPermissions"
    },
    {
     "Action":[
      "deadline:AssumeQueueRoleForUser",
      "deadline:CreateJob"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:QueueMembershipLevels":[
        "OWNER",
        "MANAGER",
        "CONTRIBUTOR"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OwnerManagerContributorPermissions"
    },
    {
     "Action":[
      "deadline:AssumeQueueRoleForRead",
      "deadline:GetJob",
      "deadline:GetQueue",
      "deadline:GetQueueEnvironment",
      "deadline:GetQueueFleetAssociation",
      "deadline:GetSession",
      "deadline:GetSessionAction",
      "deadline:GetStep",
      "deadline:GetStorageProfileForQueue",
      "deadline:GetTask",
      "deadline:ListQueueEnvironments",
      "deadline:ListQueueFleetAssociations",
      "deadline:ListSessionActions",
      "deadline:ListSessions",
      "deadline:ListStepConsumers",
      "deadline:ListStepDependencies",
      "deadline:ListSteps",
      "deadline:ListStorageProfilesForQueue",
      "deadline:ListTasks",
      "deadline:SearchJobs",
      "deadline:SearchSteps",
      "deadline:SearchTasks"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "deadline:QueueMembershipLevels":[
        "OWNER",
        "MANAGER",
        "CONTRIBUTOR",
        "VIEWER"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllLevelsPermissions"
    },
    {
     "Action":[
      "deadline:ListJobs",
      "deadline:ListQueues"
     ],
     "Condition":{
      "StringEquals":{
       "deadline:RequesterPrincipalId":"${deadline:PrincipalId}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ListBasedOnMembership"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-01T17:10:03+00:00"
 },
 "AWSDeadlineCloud-WorkerHost":{
  "CreateDate":"2024-04-01T17:28:28+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "deadline:CreateWorker",
      "deadline:AssumeFleetRoleForWorker"
     ],
     "Condition":{
      "StringEquals":{
       "aws:PrincipalAccount":"${aws:ResourceAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"JoinFleetPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-01T17:28:28+00:00"
 },
 "AWSDeepLensLambdaFunctionAccessPolicy":{
  "CreateDate":"2017-11-29T15:47:18+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::deeplens*/*",
      "arn:aws:s3:::deeplens*"
     ],
     "Sid":"DeepLensS3ObjectAccess"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents",
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/greengrass/*",
     "Sid":"DeepLensGreenGrassCloudWatchAccess"
    },
    {
     "Action":[
      "deeplens:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensAccess"
    },
    {
     "Action":[
      "kinesisvideo:DescribeStream",
      "kinesisvideo:CreateStream",
      "kinesisvideo:GetDataEndpoint",
      "kinesisvideo:PutMedia"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensKinesisVideoAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-11T23:11:55+00:00"
 },
 "AWSDeepLensServiceRolePolicy":{
  "CreateDate":"2017-11-29T15:46:36+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:CreateThing",
      "iot:DeleteThing",
      "iot:DeleteThingShadow",
      "iot:DescribeThing",
      "iot:GetThingShadow",
      "iot:UpdateThing",
      "iot:UpdateThingShadow"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/deeplens*"
     ],
     "Sid":"DeepLensIoTThingAccess"
    },
    {
     "Action":[
      "iot:AttachThingPrincipal",
      "iot:DetachThingPrincipal",
      "iot:UpdateCertificate",
      "iot:DeleteCertificate",
      "iot:DetachPrincipalPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/deeplens*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"DeepLensIoTCertificateAccess"
    },
    {
     "Action":[
      "iot:CreateKeysAndCertificate",
      "iot:CreatePolicy",
      "iot:CreatePolicyVersion"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensIoTCreateCertificateAndPolicyAccess"
    },
    {
     "Action":[
      "iot:AttachPrincipalPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:policy/deeplens*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"DeepLensIoTAttachCertificatePolicyAccess"
    },
    {
     "Action":[
      "iot:GetThingShadow",
      "iot:UpdateThingShadow"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/deeplens*"
     ],
     "Sid":"DeepLensIoTDataAccess"
    },
    {
     "Action":[
      "iot:DescribeEndpoint"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensIoTEndpointAccess"
    },
    {
     "Action":[
      "deeplens:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensAccess"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::deeplens*"
     ],
     "Sid":"DeepLensS3ObjectAccess"
    },
    {
     "Action":[
      "s3:DeleteBucket",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::deeplens*"
     ],
     "Sid":"DeepLensS3Buckets"
    },
    {
     "Action":[
      "s3:CreateBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensCreateS3Buckets"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "greengrass.amazonaws.com",
        "sagemaker.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensIAMPassRoleAccess"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEqualsIfExists":{
       "iam:PassedToService":"lambda.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSDeepLens*",
      "arn:aws:iam::*:role/service-role/AWSDeepLens*"
     ],
     "Sid":"DeepLensIAMLambdaPassRoleAccess"
    },
    {
     "Action":[
      "greengrass:AssociateRoleToGroup",
      "greengrass:AssociateServiceRoleToAccount",
      "greengrass:CreateResourceDefinition",
      "greengrass:CreateResourceDefinitionVersion",
      "greengrass:CreateCoreDefinition",
      "greengrass:CreateCoreDefinitionVersion",
      "greengrass:CreateDeployment",
      "greengrass:CreateFunctionDefinition",
      "greengrass:CreateFunctionDefinitionVersion",
      "greengrass:CreateGroup",
      "greengrass:CreateGroupCertificateAuthority",
      "greengrass:CreateGroupVersion",
      "greengrass:CreateLoggerDefinition",
      "greengrass:CreateLoggerDefinitionVersion",
      "greengrass:CreateSubscriptionDefinition",
      "greengrass:CreateSubscriptionDefinitionVersion",
      "greengrass:DeleteCoreDefinition",
      "greengrass:DeleteFunctionDefinition",
      "greengrass:DeleteGroup",
      "greengrass:DeleteLoggerDefinition",
      "greengrass:DeleteSubscriptionDefinition",
      "greengrass:DisassociateRoleFromGroup",
      "greengrass:DisassociateServiceRoleFromAccount",
      "greengrass:GetAssociatedRole",
      "greengrass:GetConnectivityInfo",
      "greengrass:GetCoreDefinition",
      "greengrass:GetCoreDefinitionVersion",
      "greengrass:GetDeploymentStatus",
      "greengrass:GetDeviceDefinition",
      "greengrass:GetDeviceDefinitionVersion",
      "greengrass:GetFunctionDefinition",
      "greengrass:GetFunctionDefinitionVersion",
      "greengrass:GetGroup",
      "greengrass:GetGroupCertificateAuthority",
      "greengrass:GetGroupCertificateConfiguration",
      "greengrass:GetGroupVersion",
      "greengrass:GetLoggerDefinition",
      "greengrass:GetLoggerDefinitionVersion",
      "greengrass:GetResourceDefinition",
      "greengrass:GetServiceRoleForAccount",
      "greengrass:GetSubscriptionDefinition",
      "greengrass:GetSubscriptionDefinitionVersion",
      "greengrass:ListCoreDefinitionVersions",
      "greengrass:ListCoreDefinitions",
      "greengrass:ListDeployments",
      "greengrass:ListDeviceDefinitionVersions",
      "greengrass:ListDeviceDefinitions",
      "greengrass:ListFunctionDefinitionVersions",
      "greengrass:ListFunctionDefinitions",
      "greengrass:ListGroupCertificateAuthorities",
      "greengrass:ListGroupVersions",
      "greengrass:ListGroups",
      "greengrass:ListLoggerDefinitionVersions",
      "greengrass:ListLoggerDefinitions",
      "greengrass:ListSubscriptionDefinitionVersions",
      "greengrass:ListSubscriptionDefinitions",
      "greengrass:ResetDeployments",
      "greengrass:UpdateConnectivityInfo",
      "greengrass:UpdateCoreDefinition",
      "greengrass:UpdateDeviceDefinition",
      "greengrass:UpdateFunctionDefinition",
      "greengrass:UpdateGroup",
      "greengrass:UpdateGroupCertificateConfiguration",
      "greengrass:UpdateLoggerDefinition",
      "greengrass:UpdateSubscriptionDefinition",
      "greengrass:UpdateResourceDefinition"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensGreenGrassAccess"
    },
    {
     "Action":[
      "lambda:CreateFunction",
      "lambda:DeleteFunction",
      "lambda:GetFunction",
      "lambda:GetFunctionConfiguration",
      "lambda:ListFunctions",
      "lambda:ListVersionsByFunction",
      "lambda:PublishVersion",
      "lambda:UpdateFunctionCode",
      "lambda:UpdateFunctionConfiguration"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:deeplens*"
     ],
     "Sid":"DeepLensLambdaAdminFunctionAccess"
    },
    {
     "Action":[
      "lambda:GetFunction",
      "lambda:GetFunctionConfiguration",
      "lambda:ListFunctions",
      "lambda:ListVersionsByFunction"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:*"
     ],
     "Sid":"DeepLensLambdaUsersFunctionAccess"
    },
    {
     "Action":[
      "sagemaker:CreateTrainingJob",
      "sagemaker:DescribeTrainingJob",
      "sagemaker:StopTrainingJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sagemaker:*:*:training-job/deeplens*"
     ],
     "Sid":"DeepLensSageMakerWriteAccess"
    },
    {
     "Action":[
      "sagemaker:DescribeTrainingJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sagemaker:*:*:training-job/*"
     ],
     "Sid":"DeepLensSageMakerReadAccess"
    },
    {
     "Action":[
      "kinesisvideo:CreateStream",
      "kinesisvideo:DescribeStream",
      "kinesisvideo:DeleteStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kinesisvideo:*:*:stream/deeplens*/*"
     ],
     "Sid":"DeepLensKinesisVideoStreamAccess"
    },
    {
     "Action":[
      "kinesisvideo:GetDataEndpoint"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepLensKinesisVideoEndpointAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-25T19:25:06+00:00"
 },
 "AWSDeepRacerAccountAdminAccess":{
  "CreateDate":"2021-10-28T01:27:13+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "deepracer:*"
     ],
     "Condition":{
      "Null":{
       "deepracer:UserToken":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DeepRacerAdminAccessStatement"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-28T01:27:13+00:00"
 },
 "AWSDeepRacerCloudFormationAccessPolicy":{
  "CreateDate":"2019-02-28T21:59:49+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:AllocateAddress",
      "ec2:AttachInternetGateway",
      "ec2:AssociateRouteTable",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateInternetGateway",
      "ec2:CreateNatGateway",
      "ec2:CreateNetworkAcl",
      "ec2:CreateNetworkAclEntry",
      "ec2:CreateRoute",
      "ec2:CreateRouteTable",
      "ec2:CreateSecurityGroup",
      "ec2:CreateSubnet",
      "ec2:CreateTags",
      "ec2:CreateVpc",
      "ec2:CreateVpcEndpoint",
      "ec2:DeleteInternetGateway",
      "ec2:DeleteNatGateway",
      "ec2:DeleteNetworkAcl",
      "ec2:DeleteNetworkAclEntry",
      "ec2:DeleteRoute",
      "ec2:DeleteRouteTable",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteSubnet",
      "ec2:DeleteTags",
      "ec2:DeleteVpc",
      "ec2:DeleteVpcEndpoints",
      "ec2:DescribeAddresses",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeNatGateways",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeTags",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeVpcs",
      "ec2:DetachInternetGateway",
      "ec2:DisassociateRouteTable",
      "ec2:ModifySubnetAttribute",
      "ec2:ModifyVpcAttribute",
      "ec2:ReleaseAddress",
      "ec2:ReplaceNetworkAclAssociation",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:RevokeSecurityGroupIngress"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLikeIfExists":{
       "iam:PassedToService":"lambda.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/service-role/AWSDeepRacerLambdaAccessRole"
    },
    {
     "Action":[
      "lambda:CreateFunction",
      "lambda:GetFunction",
      "lambda:DeleteFunction",
      "lambda:TagResource",
      "lambda:UpdateFunctionCode"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:*DeepRacer*",
      "arn:aws:lambda:*:*:function:*Deepracer*",
      "arn:aws:lambda:*:*:function:*deepracer*"
     ]
    },
    {
     "Action":[
      "s3:PutBucketPolicy",
      "s3:CreateBucket",
      "s3:ListBucket",
      "s3:GetBucketAcl",
      "s3:DeleteBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*DeepRacer*",
      "arn:aws:s3:::*Deepracer*",
      "arn:aws:s3:::*deepracer*"
     ]
    },
    {
     "Action":[
      "robomaker:CreateSimulationApplication",
      "robomaker:CreateSimulationApplicationVersion",
      "robomaker:DeleteSimulationApplication",
      "robomaker:DescribeSimulationApplication",
      "robomaker:ListSimulationApplications",
      "robomaker:TagResource",
      "robomaker:UpdateSimulationApplication"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:robomaker:*:*:/createSimulationApplication",
      "arn:aws:robomaker:*:*:simulation-application/deepracer*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-14T17:02:04+00:00"
 },
 "AWSDeepRacerDefaultMultiUserAccess":{
  "CreateDate":"2021-10-28T01:27:13+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "deepracer:Add*",
      "deepracer:Remove*",
      "deepracer:Create*",
      "deepracer:Perform*",
      "deepracer:Clone*",
      "deepracer:Get*",
      "deepracer:List*",
      "deepracer:Edit*",
      "deepracer:Start*",
      "deepracer:Set*",
      "deepracer:Update*",
      "deepracer:Delete*",
      "deepracer:Stop*",
      "deepracer:Import*",
      "deepracer:Tag*",
      "deepracer:Untag*"
     ],
     "Condition":{
      "Bool":{
       "deepracer:MultiUser":"true"
      },
      "Null":{
       "deepracer:UserToken":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "deepracer:GetAccountConfig",
      "deepracer:GetTrack",
      "deepracer:ListTracks",
      "deepracer:TestRewardFunction"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "deepracer:Admin*"
     ],
     "Effect":"Deny",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-28T01:27:13+00:00"
 },
 "AWSDeepRacerFullAccess":{
  "CreateDate":"2020-10-05T22:03:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:DeleteObject",
      "s3:DeleteObjectVersion",
      "s3:GetBucketPolicy",
      "s3:PutBucketPolicy",
      "s3:ListBucket",
      "s3:GetBucketAcl",
      "s3:GetObject",
      "s3:GetObjectVersion",
      "s3:GetObjectAcl",
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*DeepRacer*",
      "arn:aws:s3:::*Deepracer*",
      "arn:aws:s3:::*deepracer*",
      "arn:aws:s3:::dr-*",
      "arn:aws:s3:::*DeepRacer*/*",
      "arn:aws:s3:::*Deepracer*/*",
      "arn:aws:s3:::*deepracer*/*",
      "arn:aws:s3:::dr-*/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-05T22:03:10+00:00"
 },
 "AWSDeepRacerRoboMakerAccessPolicy":{
  "CreateDate":"2019-02-28T21:59:58+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "robomaker:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudwatch:PutMetricData",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeVpcs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/robomaker/SimulationJobs",
      "arn:aws:logs:*:*:log-group:/aws/robomaker/SimulationJobs:log-stream:*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListAllMyBuckets",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*DeepRacer*",
      "arn:aws:s3:::*Deepracer*",
      "arn:aws:s3:::*deepracer*",
      "arn:aws:s3:::dr-*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Condition":{
      "StringEqualsIgnoreCase":{
       "s3:ExistingObjectTag/DeepRacer":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kinesisvideo:CreateStream",
      "kinesisvideo:DescribeStream",
      "kinesisvideo:GetDataEndpoint",
      "kinesisvideo:PutMedia",
      "kinesisvideo:TagStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kinesisvideo:*:*:stream/dr-*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-02-28T21:59:58+00:00"
 },
 "AWSDeepRacerServiceRolePolicy":{
  "CreateDate":"2019-02-28T21:58:09+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "deepracer:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "robomaker:*",
      "sagemaker:*",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudformation:ListStackResources",
      "cloudformation:DescribeStacks",
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStackResource",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DetectStackDrift",
      "cloudformation:DescribeStackDriftDetectionStatus",
      "cloudformation:DescribeStackResourceDrifts"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"robomaker.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSDeepRacer*",
      "arn:aws:iam::*:role/service-role/AWSDeepRacer*"
     ]
    },
    {
     "Action":[
      "cloudwatch:GetMetricData",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:GetLogEvents",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lambda:CreateFunction",
      "lambda:DeleteFunction",
      "lambda:GetFunction",
      "lambda:InvokeFunction",
      "lambda:UpdateFunctionCode"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:*DeepRacer*",
      "arn:aws:lambda:*:*:function:*Deepracer*",
      "arn:aws:lambda:*:*:function:*deepracer*",
      "arn:aws:lambda:*:*:function:*dr-*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetBucketLocation",
      "s3:DeleteObject",
      "s3:ListBucket",
      "s3:PutObject",
      "s3:PutBucketPolicy",
      "s3:GetBucketAcl"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*DeepRacer*",
      "arn:aws:s3:::*Deepracer*",
      "arn:aws:s3:::*deepracer*",
      "arn:aws:s3:::dr-*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Condition":{
      "StringEqualsIgnoreCase":{
       "s3:ExistingObjectTag/DeepRacer":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kinesisvideo:CreateStream",
      "kinesisvideo:DeleteStream",
      "kinesisvideo:DescribeStream",
      "kinesisvideo:GetDataEndpoint",
      "kinesisvideo:GetHLSStreamingSessionURL",
      "kinesisvideo:GetMedia",
      "kinesisvideo:PutMedia",
      "kinesisvideo:TagStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kinesisvideo:*:*:stream/dr-*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-12T20:55:34+00:00"
 },
 "AWSDenyAll":{
  "CreateDate":"2019-05-01T22:36:14+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "*"
     ],
     "Effect":"Deny",
     "Resource":"*",
     "Sid":"DenyAll"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-12-18T16:42:05+00:00"
 },
 "AWSDeviceFarmFullAccess":{
  "CreateDate":"2015-07-13T16:37:38+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "devicefarm:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-07-13T16:37:38+00:00"
 },
 "AWSDeviceFarmServiceRolePolicy":{
  "CreateDate":"2022-09-20T21:02:28+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateNetworkInterface"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:security-group/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateNetworkInterface"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/AWSDeviceFarmManaged":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CreateNetworkInterface"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    },
    {
     "Action":[
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/AWSDeviceFarmManaged":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    },
    {
     "Action":[
      "ec2:ModifyNetworkInterfaceAttribute"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "ec2:ModifyNetworkInterfaceAttribute"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/AWSDeviceFarmManaged":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-09-20T21:02:28+00:00"
 },
 "AWSDeviceFarmTestGridServiceRolePolicy":{
  "CreateDate":"2021-05-26T22:01:35+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateNetworkInterface"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:security-group/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateNetworkInterface"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/AWSDeviceFarmManaged":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CreateNetworkInterface"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    },
    {
     "Action":[
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/AWSDeviceFarmManaged":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    },
    {
     "Action":[
      "ec2:ModifyNetworkInterfaceAttribute"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "ec2:ModifyNetworkInterfaceAttribute"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/AWSDeviceFarmManaged":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-05-26T22:01:35+00:00"
 },
 "AWSDirectConnectFullAccess":{
  "CreateDate":"2015-02-06T18:40:07+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "directconnect:*",
      "ec2:DescribeVpnGateways",
      "ec2:DescribeTransitGateways"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-04-30T15:29:29+00:00"
 },
 "AWSDirectConnectReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:40:08+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "directconnect:Describe*",
      "directconnect:List*",
      "ec2:DescribeVpnGateways",
      "ec2:DescribeTransitGateways"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-18T18:48:22+00:00"
 },
 "AWSDirectConnectServiceRolePolicy":{
  "CreateDate":"2021-01-14T18:35:27+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "secretsmanager:DescribeSecret",
      "secretsmanager:ListSecretVersionIds",
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:secretsmanager:*:*:secret:*directconnect*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-14T18:35:27+00:00"
 },
 "AWSDirectoryServiceDataFullAccess":{
  "CreateDate":"2024-09-18T21:45:17+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:AccessDSData",
      "ds-data:AddGroupMember",
      "ds-data:CreateGroup",
      "ds-data:CreateUser",
      "ds-data:DeleteGroup",
      "ds-data:DeleteUser",
      "ds-data:DescribeGroup",
      "ds-data:DescribeUser",
      "ds-data:DisableUser",
      "ds-data:ListGroupMembers",
      "ds-data:ListGroups",
      "ds-data:ListGroupsForMember",
      "ds-data:ListUsers",
      "ds-data:RemoveGroupMember",
      "ds-data:SearchGroups",
      "ds-data:SearchUsers",
      "ds-data:UpdateGroup",
      "ds-data:UpdateUser"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ds:*:*:directory/*"
     ],
     "Sid":"DSDataFullAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-09-18T21:45:17+00:00"
 },
 "AWSDirectoryServiceDataReadOnlyAccess":{
  "CreateDate":"2024-09-18T22:00:34+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:AccessDSData",
      "ds-data:DescribeGroup",
      "ds-data:DescribeUser",
      "ds-data:ListGroupMembers",
      "ds-data:ListGroups",
      "ds-data:ListGroupsForMember",
      "ds-data:ListUsers",
      "ds-data:SearchGroups",
      "ds-data:SearchUsers"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ds:*:*:directory/*"
     ],
     "Sid":"DSDataReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-09-18T22:00:34+00:00"
 },
 "AWSDirectoryServiceFullAccess":{
  "CreateDate":"2015-02-06T18:41:11+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:*",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateNetworkInterface",
      "ec2:CreateSecurityGroup",
      "ec2:DeleteNetworkInterface",
      "ec2:DeleteSecurityGroup",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:DescribeSecurityGroups",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptions",
      "sns:ListSubscriptionsByTopic",
      "sns:ListTopics",
      "iam:ListRoles",
      "organizations:ListAccountsForParent",
      "organizations:ListRoots",
      "organizations:ListAccounts",
      "organizations:DescribeOrganization",
      "organizations:DescribeAccount",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListAWSServiceAccessForOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DirectoryServiceFullAccess"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:DeleteTopic",
      "sns:SetTopicAttributes",
      "sns:Subscribe",
      "sns:Unsubscribe"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:DirectoryMonitoring*",
     "Sid":"DirectoryServiceEventTopic"
    },
    {
     "Action":[
      "organizations:EnableAWSServiceAccess",
      "organizations:DisableAWSServiceAccess"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":"ds.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DirectoryServiceOrganizations"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:security-group/*"
     ],
     "Sid":"DirectoryServiceTags"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-02T20:38:17+00:00"
 },
 "AWSDirectoryServiceReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:41:12+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:Check*",
      "ds:Describe*",
      "ds:Get*",
      "ds:List*",
      "ds:Verify*",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "sns:ListTopics",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptions",
      "sns:ListSubscriptionsByTopic",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAWSServiceAccessForOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-09-25T21:54:01+00:00"
 },
 "AWSDiscoveryContinuousExportFirehosePolicy":{
  "CreateDate":"2018-08-09T18:29:39+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:GetTableVersions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:AbortMultipartUpload",
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:ListBucketMultipartUploads",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-application-discovery-service-*"
     ]
    },
    {
     "Action":[
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/application-discovery-service/firehose:log-stream:*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-08T17:32:46+00:00"
 },
 "AWSEC2CapacityReservationFleetRolePolicy":{
  "CreateDate":"2021-09-29T14:43:09+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeCapacityReservations",
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateCapacityReservation",
      "ec2:CancelCapacityReservation",
      "ec2:ModifyCapacityReservation"
     ],
     "Condition":{
      "StringLike":{
       "ec2:CapacityReservationFleet":"arn:aws:ec2:*:*:capacity-reservation-fleet/crf-*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:capacity-reservation/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CreateCapacityReservation"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:capacity-reservation/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-29T14:43:09+00:00"
 },
 "AWSEC2FleetServiceRolePolicy":{
  "CreateDate":"2018-03-21T00:08:55+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeImages",
      "ec2:DescribeSubnets",
      "ec2:RequestSpotInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"spot.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2SpotManagement"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:spot-instances-request/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"RunInstances"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:volume/*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:ec2:fleet-id":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-04T20:10:31+00:00"
 },
 "AWSEC2SpotFleetServiceRolePolicy":{
  "CreateDate":"2017-10-23T19:13:06+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeImages",
      "ec2:DescribeSubnets",
      "ec2:RequestSpotInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:spot-instances-request/*",
      "arn:aws:ec2:*:*:spot-fleet-request/*",
      "arn:aws:ec2:*:*:volume/*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:ec2spot:fleet-request-id":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/*"
     ]
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterTargets"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:*/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-03-16T19:16:21+00:00"
 },
 "AWSEC2SpotServiceRolePolicy":{
  "CreateDate":"2017-09-18T18:51:54+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "StringNotEquals":{
       "ec2:InstanceMarketType":"spot"
      }
     },
     "Effect":"Deny",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"RunInstances"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-12-12T00:13:51+00:00"
 },
 "AWSEC2VssSnapshotPolicy":{
  "CreateDate":"2024-03-27T16:32:53+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstanceAttribute"
     ],
     "Condition":{
      "StringLike":{
       "ec2:SourceInstanceARN":"*${ec2:InstanceId}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"DescribeInstanceInfo"
    },
    {
     "Action":[
      "ec2:CreateSnapshots"
     ],
     "Condition":{
      "StringLike":{
       "aws:RequestTag/AwsVssConfig":"*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:snapshot/*"
     ],
     "Sid":"CreateSnapshotsWithTag"
    },
    {
     "Action":[
      "ec2:CreateSnapshots"
     ],
     "Condition":{
      "StringLike":{
       "ec2:SourceInstanceARN":"*${ec2:InstanceId}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"CreateSnapshotsAccessInstance"
    },
    {
     "Action":[
      "ec2:CreateSnapshots"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:volume/*"
     ],
     "Sid":"CreateSnapshotsAccessVolume"
    },
    {
     "Action":[
      "ec2:CreateImage"
     ],
     "Condition":{
      "StringLike":{
       "aws:RequestTag/AwsVssConfig":"*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:image/*"
     ],
     "Sid":"CreateImageWithTag"
    },
    {
     "Action":[
      "ec2:CreateImage"
     ],
     "Condition":{
      "StringLike":{
       "ec2:SourceInstanceARN":"*${ec2:InstanceId}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"CreateImageAccessInstance"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateImage",
        "CreateSnapshots"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:image/*"
     ],
     "Sid":"CreateTagsOnResourceCreation"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "AppConsistent",
        "Device"
       ]
      },
      "StringLike":{
       "ec2:ResourceTag/AwsVssConfig":"*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:image/*"
     ],
     "Sid":"CreateTagsAfterResourceCreation"
    },
    {
     "Action":[
      "ec2:DescribeImages",
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribeImagesAndSnapshots"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-27T16:32:53+00:00"
 },
 "AWSECRPullThroughCache_ServiceRolePolicy":{
  "CreateDate":"2021-11-26T21:51:09+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecr:GetAuthorizationToken",
      "ecr:BatchCheckLayerAvailability",
      "ecr:InitiateLayerUpload",
      "ecr:UploadLayerPart",
      "ecr:CompleteLayerUpload",
      "ecr:PutImage"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ECR"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:ecr-pullthroughcache/*",
     "Sid":"SecretsManager"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-13T15:23:16+00:00"
 },
 "AWSElasticBeanstalkCustomPlatformforEC2Role":{
  "CreateDate":"2017-02-21T22:50:30+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:AttachVolume",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CopyImage",
      "ec2:CreateImage",
      "ec2:CreateKeypair",
      "ec2:CreateSecurityGroup",
      "ec2:CreateSnapshot",
      "ec2:CreateTags",
      "ec2:CreateVolume",
      "ec2:DeleteKeypair",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteSnapshot",
      "ec2:DeleteVolume",
      "ec2:DeregisterImage",
      "ec2:DescribeImageAttribute",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeRegions",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeTags",
      "ec2:DescribeVolumes",
      "ec2:DetachVolume",
      "ec2:GetPasswordData",
      "ec2:ModifyImageAttribute",
      "ec2:ModifyInstanceAttribute",
      "ec2:ModifySnapshotAttribute",
      "ec2:RegisterImage",
      "ec2:RunInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2Access"
    },
    {
     "Action":[
      "s3:Get*",
      "s3:List*",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::elasticbeanstalk-*",
      "arn:aws:s3:::elasticbeanstalk-*/*"
     ],
     "Sid":"BucketAccess"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:DescribeLogStreams"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/platform/*",
     "Sid":"CloudWatchLogsAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-02-21T22:50:30+00:00"
 },
 "AWSElasticBeanstalkEnhancedHealth":{
  "CreateDate":"2016-02-08T23:17:27+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTargetHealth",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:GetConsoleOutput",
      "ec2:AssociateAddress",
      "ec2:DescribeAddresses",
      "ec2:DescribeSecurityGroups",
      "sqs:GetQueueAttributes",
      "sqs:GetQueueUrl",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:DescribeNotificationConfigurations",
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "logs:DescribeLogStreams",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*:log-stream:*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-04-09T22:12:53+00:00"
 },
 "AWSElasticBeanstalkMaintenance":{
  "CreateDate":"2019-01-11T23:22:52+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:CreateChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:DeleteChangeSet",
      "cloudformation:ListChangeSets",
      "cloudformation:DescribeStacks",
      "cloudformation:TagResource",
      "cloudformation:UntagResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awseb-*",
      "arn:aws:cloudformation:*:*:stack/eb-*"
     ],
     "Sid":"AllowCloudformationChangeSetOperationsOnElasticBeanstalkStacks"
    },
    {
     "Action":"elasticloadbalancing:DescribeLoadBalancers",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowElasticBeanstalkStacksUpdateExecuteSuccessfully"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-29T21:48:04+00:00"
 },
 "AWSElasticBeanstalkManagedUpdatesCustomerRolePolicy":{
  "CreateDate":"2021-03-03T22:18:00+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "elasticbeanstalk:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ElasticBeanstalkPermissions"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "elasticbeanstalk.amazonaws.com",
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn",
        "autoscaling.amazonaws.com",
        "elasticloadbalancing.amazonaws.com",
        "ecs.amazonaws.com",
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*",
     "Sid":"AllowPassRoleToElasticBeanstalkAndDownstreamServices"
    },
    {
     "Action":[
      "autoscaling:DescribeAccountLimits",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:DescribeLaunchConfigurations",
      "autoscaling:DescribeLoadBalancers",
      "autoscaling:DescribeNotificationConfigurations",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:DescribeScheduledActions",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstances",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcClassicLink",
      "ec2:DescribeVpcs",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeTargetHealth",
      "logs:DescribeLogGroups",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeOrderableDBInstanceOptions",
      "sns:ListSubscriptionsByTopic"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ReadOnlyPermissions"
    },
    {
     "Action":[
      "ec2:AllocateAddress",
      "ec2:AssociateAddress",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateLaunchTemplate",
      "ec2:CreateLaunchTemplateVersion",
      "ec2:CreateSecurityGroup",
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions",
      "ec2:DeleteSecurityGroup",
      "ec2:DisassociateAddress",
      "ec2:ReleaseAddress",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:RevokeSecurityGroupIngress"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2BroadOperationPermissions"
    },
    {
     "Action":"ec2:RunInstances",
     "Condition":{
      "ArnLike":{
       "ec2:LaunchTemplate":"arn:aws:ec2:*:*:launch-template/*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2RunInstancesOperationPermissions"
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":[
        "arn:aws:cloudformation:*:*:stack/awseb-e-*",
        "arn:aws:cloudformation:*:*:stack/eb-*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"EC2TerminateInstancesOperationPermissions"
    },
    {
     "Action":[
      "ecs:CreateCluster",
      "ecs:DescribeClusters",
      "ecs:RegisterTaskDefinition"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ECSBroadOperationPermissions"
    },
    {
     "Action":"ecs:DeleteCluster",
     "Effect":"Allow",
     "Resource":"arn:aws:ecs:*:*:cluster/awseb-*",
     "Sid":"ECSDeleteClusterOperationPermissions"
    },
    {
     "Action":[
      "autoscaling:AttachInstances",
      "autoscaling:CreateAutoScalingGroup",
      "autoscaling:CreateLaunchConfiguration",
      "autoscaling:CreateOrUpdateTags",
      "autoscaling:DeleteLaunchConfiguration",
      "autoscaling:DeleteAutoScalingGroup",
      "autoscaling:DeleteScheduledAction",
      "autoscaling:DetachInstances",
      "autoscaling:DeletePolicy",
      "autoscaling:PutScalingPolicy",
      "autoscaling:PutScheduledUpdateGroupAction",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:ResumeProcesses",
      "autoscaling:SetDesiredCapacity",
      "autoscaling:SuspendProcesses",
      "autoscaling:TerminateInstanceInAutoScalingGroup",
      "autoscaling:UpdateAutoScalingGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/awseb-e-*",
      "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/eb-*",
      "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/awseb-e-*",
      "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/eb-*"
     ],
     "Sid":"ASGOperationPermissions"
    },
    {
     "Action":[
      "cloudformation:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awseb-*",
      "arn:aws:cloudformation:*:*:stack/eb-*"
     ],
     "Sid":"CFNOperationPermissions"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:ApplySecurityGroupsToLoadBalancer",
      "elasticloadbalancing:ConfigureHealthCheck",
      "elasticloadbalancing:CreateLoadBalancer",
      "elasticloadbalancing:DeleteLoadBalancer",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:DeregisterTargets",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
      "elasticloadbalancing:RegisterTargets"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:targetgroup/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:targetgroup/eb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/eb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/*/awseb-*/*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/*/eb-*/*"
     ],
     "Sid":"ELBOperationPermissions"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:DeleteLogGroup",
      "logs:PutRetentionPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*",
     "Sid":"CWLogsOperationPermissions"
    },
    {
     "Action":[
      "s3:DeleteObject",
      "s3:GetObject",
      "s3:GetObjectAcl",
      "s3:GetObjectVersion",
      "s3:GetObjectVersionAcl",
      "s3:PutObject",
      "s3:PutObjectAcl",
      "s3:PutObjectVersionAcl"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*/*",
     "Sid":"S3ObjectOperationPermissions"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:GetBucketPolicy",
      "s3:ListBucket",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*",
     "Sid":"S3BucketOperationPermissions"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:GetTopicAttributes",
      "sns:SetTopicAttributes",
      "sns:Subscribe"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:ElasticBeanstalkNotifications-*",
     "Sid":"SNSOperationPermissions"
    },
    {
     "Action":[
      "sqs:GetQueueAttributes",
      "sqs:GetQueueUrl"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sqs:*:*:awseb-e-*",
      "arn:aws:sqs:*:*:eb-*"
     ],
     "Sid":"SQSOperationPermissions"
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch:*:*:alarm:awseb-*",
      "arn:aws:cloudwatch:*:*:alarm:eb-*"
     ],
     "Sid":"CWPutMetricAlarmOperationPermissions"
    },
    {
     "Action":[
      "ecs:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "ecs:CreateAction":[
        "CreateCluster",
        "RegisterTaskDefinition"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowECSTagResource"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-23T23:15:54+00:00"
 },
 "AWSElasticBeanstalkManagedUpdatesServiceRolePolicy":{
  "CreateDate":"2019-11-21T22:35:06+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLikeIfExists":{
       "iam:PassedToService":[
        "elasticbeanstalk.amazonaws.com",
        "ec2.amazonaws.com",
        "autoscaling.amazonaws.com",
        "elasticloadbalancing.amazonaws.com",
        "ecs.amazonaws.com",
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowPassRoleToElasticBeanstalkAndDownstreamServices"
    },
    {
     "Action":[
      "ec2:releaseAddress",
      "ec2:allocateAddress",
      "ec2:DisassociateAddress",
      "ec2:AssociateAddress"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SingleInstanceAPIs"
    },
    {
     "Action":[
      "ecs:RegisterTaskDefinition",
      "ecs:DeRegisterTaskDefinition",
      "ecs:List*",
      "ecs:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ECS"
    },
    {
     "Action":[
      "elasticbeanstalk:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ElasticBeanstalkAPIs"
    },
    {
     "Action":[
      "cloudformation:Describe*",
      "cloudformation:List*",
      "ec2:Describe*",
      "autoscaling:Describe*",
      "elasticloadbalancing:Describe*",
      "logs:DescribeLogGroups",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptionsByTopic",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReadOnlyAPIs"
    },
    {
     "Action":[
      "autoscaling:AttachInstances",
      "autoscaling:CreateAutoScalingGroup",
      "autoscaling:CreateLaunchConfiguration",
      "autoscaling:CreateOrUpdateTags",
      "autoscaling:DeleteAutoScalingGroup",
      "autoscaling:DeleteLaunchConfiguration",
      "autoscaling:DeleteScheduledAction",
      "autoscaling:DetachInstances",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:PutScalingPolicy",
      "autoscaling:PutScheduledUpdateGroupAction",
      "autoscaling:ResumeProcesses",
      "autoscaling:SuspendProcesses",
      "autoscaling:TerminateInstanceInAutoScalingGroup",
      "autoscaling:UpdateAutoScalingGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/awseb-e-*",
      "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/awseb-e-*",
      "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/eb-*",
      "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/eb-*"
     ],
     "Sid":"ASG"
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:CancelUpdateStack",
      "cloudformation:DeleteStack",
      "cloudformation:GetTemplate",
      "cloudformation:UpdateStack",
      "cloudformation:TagResource",
      "cloudformation:UntagResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awseb-e-*",
      "arn:aws:cloudformation:*:*:stack/eb-*"
     ],
     "Sid":"CFN"
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":[
        "arn:aws:cloudformation:*:*:stack/awseb-e-*",
        "arn:aws:cloudformation:*:*:stack/eb-*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"EC2"
    },
    {
     "Action":[
      "s3:DeleteObject",
      "s3:GetObject",
      "s3:GetObjectAcl",
      "s3:GetObjectVersion",
      "s3:GetObjectVersionAcl",
      "s3:PutObject",
      "s3:PutObjectAcl",
      "s3:PutObjectVersionAcl"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*/*",
     "Sid":"S3Obj"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:GetBucketPolicy",
      "s3:ListBucket",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*",
     "Sid":"S3Bucket"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:DeleteLogGroup",
      "logs:PutRetentionPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*",
     "Sid":"CWL"
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:DeRegisterTargets",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:targetgroup/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/awseb-e-*",
      "arn:aws:elasticloadbalancing:*:*:targetgroup/eb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/eb-*"
     ],
     "Sid":"ELB"
    },
    {
     "Action":[
      "sns:CreateTopic"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:ElasticBeanstalkNotifications-Environment-*",
     "Sid":"SNS"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplate",
      "ec2:DeleteLaunchTemplate",
      "ec2:CreateLaunchTemplateVersion",
      "ec2:DeleteLaunchTemplateVersions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"EC2LaunchTemplate"
    },
    {
     "Action":"ec2:RunInstances",
     "Condition":{
      "ArnLike":{
       "ec2:LaunchTemplate":"arn:aws:ec2:*:*:launch-template/*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowLaunchTemplateRunInstances"
    },
    {
     "Action":[
      "ecs:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "ecs:CreateAction":[
        "RegisterTaskDefinition"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowECSTagResource"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-29T23:11:34+00:00"
 },
 "AWSElasticBeanstalkMulticontainerDocker":{
  "CreateDate":"2016-02-08T23:15:29+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:Poll",
      "ecs:StartTask",
      "ecs:StopTask",
      "ecs:DiscoverPollEndpoint",
      "ecs:StartTelemetrySession",
      "ecs:RegisterContainerInstance",
      "ecs:DeregisterContainerInstance",
      "ecs:DescribeContainerInstances",
      "ecs:Submit*",
      "ecs:DescribeTasks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ECSAccess"
    },
    {
     "Action":[
      "ecs:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "ecs:CreateAction":[
        "RegisterContainerInstance",
        "StartTask"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowECSTagResource"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-23T22:04:20+00:00"
 },
 "AWSElasticBeanstalkReadOnly":{
  "CreateDate":"2021-01-22T19:02:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm:ListCertificates",
      "autoscaling:DescribeAccountLimits",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:DescribeLaunchConfigurations",
      "autoscaling:DescribePolicies",
      "autoscaling:DescribeLoadBalancers",
      "autoscaling:DescribeNotificationConfigurations",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:DescribeScheduledActions",
      "cloudformation:DescribeStackResource",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStacks",
      "cloudformation:GetTemplate",
      "cloudformation:ListStackResources",
      "cloudformation:ListStacks",
      "cloudformation:ValidateTemplate",
      "cloudtrail:LookupEvents",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:ListMetrics",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeImages",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "elasticbeanstalk:Check*",
      "elasticbeanstalk:Describe*",
      "elasticbeanstalk:List*",
      "elasticbeanstalk:RequestEnvironmentInfo",
      "elasticbeanstalk:RetrieveEnvironmentInfo",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeSSLPolicies",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeTargetHealth",
      "iam:GetRole",
      "iam:ListAttachedRolePolicies",
      "iam:ListInstanceProfiles",
      "iam:ListRolePolicies",
      "iam:ListRoles",
      "iam:ListServerCertificates",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeOrderableDBInstanceOptions",
      "rds:DescribeDBSnapshots",
      "s3:ListAllMyBuckets",
      "sns:ListSubscriptionsByTopic",
      "sns:ListTopics",
      "sqs:ListQueues"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowAPIs"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetObjectAcl",
      "s3:GetObjectVersion",
      "s3:GetObjectVersionAcl",
      "s3:GetBucketLocation",
      "s3:GetBucketPolicy",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*",
     "Sid":"AllowS3"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-22T19:02:37+00:00"
 },
 "AWSElasticBeanstalkRoleCWL":{
  "CreateDate":"2020-06-05T21:49:06+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:DeleteLogGroup",
      "logs:PutRetentionPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*",
     "Sid":"AllowCWL"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-05T21:49:06+00:00"
 },
 "AWSElasticBeanstalkRoleCore":{
  "CreateDate":"2020-06-05T21:48:24+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":"arn:aws:cloudformation:*:*:stack/awseb-e-*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"TerminateInstances"
    },
    {
     "Action":[
      "ec2:ReleaseAddress",
      "ec2:AllocateAddress",
      "ec2:DisassociateAddress",
      "ec2:AssociateAddress",
      "ec2:CreateTags",
      "ec2:DeleteTags",
      "ec2:CreateSecurityGroup",
      "ec2:DeleteSecurityGroup",
      "ec2:AuthorizeSecurityGroup*",
      "ec2:RevokeSecurityGroup*",
      "ec2:CreateLaunchTemplate*",
      "ec2:DeleteLaunchTemplate*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2"
    },
    {
     "Action":"ec2:RunInstances",
     "Condition":{
      "ArnLike":{
       "ec2:LaunchTemplate":"arn:aws:ec2:*:*:launch-template/*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LTRunInstances"
    },
    {
     "Action":[
      "autoscaling:AttachInstances",
      "autoscaling:*LoadBalancer*",
      "autoscaling:*AutoScalingGroup",
      "autoscaling:*LaunchConfiguration",
      "autoscaling:DeleteScheduledAction",
      "autoscaling:DetachInstances",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:PutScalingPolicy",
      "autoscaling:PutScheduledUpdateGroupAction",
      "autoscaling:ResumeProcesses",
      "autoscaling:SuspendProcesses",
      "autoscaling:*Tags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/awseb-e-*",
      "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/awseb-e-*"
     ],
     "Sid":"ASG"
    },
    {
     "Action":[
      "autoscaling:DeletePolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ASGPolicy"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"elasticbeanstalk.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/elasticbeanstalk.amazonaws.com/AWSServiceRoleForElasticBeanstalk*"
     ],
     "Sid":"EBSLR"
    },
    {
     "Action":[
      "s3:Delete*",
      "s3:Get*",
      "s3:Put*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::elasticbeanstalk-*/*",
      "arn:aws:s3:::elasticbeanstalk-env-resources-*/*"
     ],
     "Sid":"S3Obj"
    },
    {
     "Action":[
      "s3:GetBucket*",
      "s3:ListBucket",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::elasticbeanstalk-*",
     "Sid":"S3Bucket"
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:GetTemplate",
      "cloudformation:ListStackResources",
      "cloudformation:UpdateStack",
      "cloudformation:ContinueUpdateRollback",
      "cloudformation:CancelUpdateStack",
      "cloudformation:TagResource",
      "cloudformation:UntagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/awseb-e-*",
     "Sid":"CFN"
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DeleteAlarms"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudwatch:*:*:alarm:awseb-*",
     "Sid":"CloudWatch"
    },
    {
     "Action":[
      "elasticloadbalancing:Create*",
      "elasticloadbalancing:Delete*",
      "elasticloadbalancing:Modify*",
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:DeRegisterTargets",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
      "elasticloadbalancing:*Tags",
      "elasticloadbalancing:ConfigureHealthCheck",
      "elasticloadbalancing:SetRulePriorities",
      "elasticloadbalancing:SetLoadBalancerPoliciesOfListener"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticloadbalancing:*:*:targetgroup/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/app/awseb-*/*",
      "arn:aws:elasticloadbalancing:*:*:loadbalancer/net/awseb-*/*",
      "arn:aws:elasticloadbalancing:*:*:listener/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:listener/app/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:listener/net/awseb-*",
      "arn:aws:elasticloadbalancing:*:*:listener-rule/app/awseb-*/*/*/*"
     ],
     "Sid":"ELB"
    },
    {
     "Action":[
      "autoscaling:Describe*",
      "cloudformation:Describe*",
      "logs:Describe*",
      "ec2:Describe*",
      "ecs:Describe*",
      "ecs:List*",
      "elasticloadbalancing:Describe*",
      "rds:Describe*",
      "sns:List*",
      "iam:List*",
      "acm:Describe*",
      "acm:List*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListAPIs"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "elasticbeanstalk.amazonaws.com",
        "ec2.amazonaws.com",
        "autoscaling.amazonaws.com",
        "elasticloadbalancing.amazonaws.com",
        "ecs.amazonaws.com",
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-elasticbeanstalk-*",
     "Sid":"AllowPassRole"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-30T00:01:53+00:00"
 },
 "AWSElasticBeanstalkRoleECS":{
  "CreateDate":"2020-06-05T21:47:27+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:CreateCluster",
      "ecs:DeleteCluster",
      "ecs:RegisterTaskDefinition",
      "ecs:DeRegisterTaskDefinition"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowECS"
    },
    {
     "Action":[
      "ecs:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "ecs:CreateAction":[
        "CreateCluster",
        "RegisterTaskDefinition"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowECSTagResource"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-23T22:43:56+00:00"
 },
 "AWSElasticBeanstalkRoleRDS":{
  "CreateDate":"2020-06-05T21:46:55+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rds:CreateDBSecurityGroup",
      "rds:DeleteDBSecurityGroup",
      "rds:AuthorizeDBSecurityGroupIngress",
      "rds:CreateDBInstance",
      "rds:ModifyDBInstance",
      "rds:DeleteDBInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:secgrp:awseb-e-*",
      "arn:aws:rds:*:*:db:*"
     ],
     "Sid":"AllowRDS"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-05T21:46:55+00:00"
 },
 "AWSElasticBeanstalkRoleSNS":{
  "CreateDate":"2020-06-05T21:46:22+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sns:CreateTopic",
      "sns:SetTopicAttributes",
      "sns:DeleteTopic"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sns:*:*:ElasticBeanstalkNotifications-*"
     ],
     "Sid":"AllowBeanstalkManageSNS"
    },
    {
     "Action":[
      "sns:GetTopicAttributes",
      "sns:Subscribe",
      "sns:Unsubscribe",
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowSNSPublish"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-05T21:46:22+00:00"
 },
 "AWSElasticBeanstalkRoleWorkerTier":{
  "CreateDate":"2020-06-05T21:43:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sqs:TagQueue",
      "sqs:DeleteQueue",
      "sqs:GetQueueAttributes",
      "sqs:CreateQueue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sqs:*:*:awseb-e-*",
     "Sid":"AllowSQS"
    },
    {
     "Action":[
      "dynamodb:CreateTable",
      "dynamodb:TagResource",
      "dynamodb:DescribeTable",
      "dynamodb:DeleteTable"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/awseb-e-*",
     "Sid":"AllowDDB"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-05T21:43:37+00:00"
 },
 "AWSElasticBeanstalkService":{
  "CreateDate":"2016-04-11T20:27:23+00:00",
  "DefaultVersionId":"v17",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awseb-*",
      "arn:aws:cloudformation:*:*:stack/eb-*"
     ],
     "Sid":"AllowCloudformationOperationsOnElasticBeanstalkStacks"
    },
    {
     "Action":[
      "logs:DeleteLogGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk*"
     ],
     "Sid":"AllowDeleteCloudwatchLogGroups"
    },
    {
     "Action":[
      "ecs:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "ecs:CreateAction":[
        "CreateCluster",
        "RegisterTaskDefinition"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowECSTagResource"
    },
    {
     "Action":[
      "s3:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::elasticbeanstalk-*",
      "arn:aws:s3:::elasticbeanstalk-*/*"
     ],
     "Sid":"AllowS3OperationsOnElasticBeanstalkBuckets"
    },
    {
     "Action":"ec2:RunInstances",
     "Condition":{
      "ArnLike":{
       "ec2:LaunchTemplate":"arn:aws:ec2:*:*:launch-template/*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowLaunchTemplateRunInstances"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags"
     ],
     "Condition":{
      "StringEquals":{
       "elasticloadbalancing:CreateAction":[
        "CreateLoadBalancer"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowELBAddTags"
    },
    {
     "Action":[
      "autoscaling:AttachInstances",
      "autoscaling:CreateAutoScalingGroup",
      "autoscaling:CreateLaunchConfiguration",
      "autoscaling:CreateOrUpdateTags",
      "autoscaling:DeleteLaunchConfiguration",
      "autoscaling:DeleteAutoScalingGroup",
      "autoscaling:DeleteScheduledAction",
      "autoscaling:DescribeAccountLimits",
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:DescribeLaunchConfigurations",
      "autoscaling:DescribeLoadBalancers",
      "autoscaling:DescribeNotificationConfigurations",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:DescribeScheduledActions",
      "autoscaling:DetachInstances",
      "autoscaling:DeletePolicy",
      "autoscaling:PutScalingPolicy",
      "autoscaling:PutScheduledUpdateGroupAction",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:ResumeProcesses",
      "autoscaling:SetDesiredCapacity",
      "autoscaling:SuspendProcesses",
      "autoscaling:TerminateInstanceInAutoScalingGroup",
      "autoscaling:UpdateAutoScalingGroup",
      "cloudwatch:PutMetricAlarm",
      "ec2:AssociateAddress",
      "ec2:AllocateAddress",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateLaunchTemplate",
      "ec2:CreateLaunchTemplateVersion",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions",
      "ec2:CreateSecurityGroup",
      "ec2:DeleteSecurityGroup",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DescribeVpcClassicLink",
      "ec2:DisassociateAddress",
      "ec2:ReleaseAddress",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:TerminateInstances",
      "ecs:CreateCluster",
      "ecs:DeleteCluster",
      "ecs:DescribeClusters",
      "ecs:RegisterTaskDefinition",
      "elasticbeanstalk:*",
      "elasticloadbalancing:ApplySecurityGroupsToLoadBalancer",
      "elasticloadbalancing:ConfigureHealthCheck",
      "elasticloadbalancing:CreateLoadBalancer",
      "elasticloadbalancing:DeleteLoadBalancer",
      "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:DeregisterTargets",
      "iam:ListRoles",
      "iam:PassRole",
      "logs:CreateLogGroup",
      "logs:PutRetentionPolicy",
      "logs:DescribeLogGroups",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstances",
      "rds:DescribeOrderableDBInstanceOptions",
      "s3:GetObject",
      "s3:GetObjectAcl",
      "s3:ListBucket",
      "sns:CreateTopic",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptionsByTopic",
      "sns:Subscribe",
      "sns:SetTopicAttributes",
      "sqs:GetQueueAttributes",
      "sqs:GetQueueUrl",
      "codebuild:CreateProject",
      "codebuild:DeleteProject",
      "codebuild:BatchGetBuilds",
      "codebuild:StartBuild"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowOperations"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-05-10T19:29:34+00:00"
 },
 "AWSElasticBeanstalkServiceRolePolicy":{
  "CreateDate":"2017-09-13T23:46:37+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStackResource",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStacks"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/awseb-*",
      "arn:aws:cloudformation:*:*:stack/eb-*"
     ],
     "Sid":"AllowCloudformationReadOperationsOnElasticBeanstalkStacks"
    },
    {
     "Action":[
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:DescribeNotificationConfigurations",
      "autoscaling:DescribeScalingActivities",
      "autoscaling:PutNotificationConfiguration",
      "ec2:DescribeInstanceStatus",
      "ec2:AssociateAddress",
      "ec2:DescribeAddresses",
      "ec2:DescribeInstances",
      "ec2:DescribeSecurityGroups",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticloadbalancing:DescribeTargetGroups",
      "lambda:GetFunction",
      "sqs:GetQueueAttributes",
      "sqs:GetQueueUrl",
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowOperations"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams",
      "logs:DeleteLogGroup",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*",
     "Sid":"AllowOperationsOnHealthStreamingLogs"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-06T21:59:51+00:00"
 },
 "AWSElasticBeanstalkWebTier":{
  "CreateDate":"2016-02-08T23:08:54+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:Get*",
      "s3:List*",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::elasticbeanstalk-*",
      "arn:aws:s3:::elasticbeanstalk-*/*"
     ],
     "Sid":"BucketAccess"
    },
    {
     "Action":[
      "xray:PutTraceSegments",
      "xray:PutTelemetryRecords",
      "xray:GetSamplingRules",
      "xray:GetSamplingTargets",
      "xray:GetSamplingStatisticSummaries"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"XRayAccess"
    },
    {
     "Action":[
      "logs:PutLogEvents",
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk*"
     ],
     "Sid":"CloudWatchLogsAccess"
    },
    {
     "Action":[
      "elasticbeanstalk:PutInstanceStatistics"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticbeanstalk:*:*:application/*",
      "arn:aws:elasticbeanstalk:*:*:environment/*"
     ],
     "Sid":"ElasticBeanstalkHealthAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-09T19:38:36+00:00"
 },
 "AWSElasticBeanstalkWorkerTier":{
  "CreateDate":"2016-02-08T23:12:02+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"MetricsAccess"
    },
    {
     "Action":[
      "xray:PutTraceSegments",
      "xray:PutTelemetryRecords",
      "xray:GetSamplingRules",
      "xray:GetSamplingTargets",
      "xray:GetSamplingStatisticSummaries"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"XRayAccess"
    },
    {
     "Action":[
      "sqs:ChangeMessageVisibility",
      "sqs:DeleteMessage",
      "sqs:ReceiveMessage",
      "sqs:SendMessage"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"QueueAccess"
    },
    {
     "Action":[
      "s3:Get*",
      "s3:List*",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::elasticbeanstalk-*",
      "arn:aws:s3:::elasticbeanstalk-*/*"
     ],
     "Sid":"BucketAccess"
    },
    {
     "Action":[
      "dynamodb:BatchGetItem",
      "dynamodb:BatchWriteItem",
      "dynamodb:DeleteItem",
      "dynamodb:GetItem",
      "dynamodb:PutItem",
      "dynamodb:Query",
      "dynamodb:Scan",
      "dynamodb:UpdateItem"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:dynamodb:*:*:table/*-stack-AWSEBWorkerCronLeaderRegistry*"
     ],
     "Sid":"DynamoPeriodicTasks"
    },
    {
     "Action":[
      "logs:PutLogEvents",
      "logs:CreateLogStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk*"
     ],
     "Sid":"CloudWatchLogsAccess"
    },
    {
     "Action":[
      "elasticbeanstalk:PutInstanceStatistics"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:elasticbeanstalk:*:*:application/*",
      "arn:aws:elasticbeanstalk:*:*:environment/*"
     ],
     "Sid":"ElasticBeanstalkHealthAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-09T19:53:40+00:00"
 },
 "AWSElasticDisasterRecoveryAgentInstallationPolicy":{
  "CreateDate":"2021-11-17T10:37:54+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:GetAgentInstallationAssetsForDrs",
      "drs:SendClientLogsForDrs",
      "drs:SendClientMetricsForDrs",
      "drs:CreateSourceServerForDrs",
      "drs:CreateRecoveryInstanceForDrs",
      "drs:DescribeRecoveryInstances",
      "drs:CreateSourceNetwork"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSAgentInstallationPolicy1"
    },
    {
     "Action":"drs:TagResource",
     "Condition":{
      "StringEquals":{
       "drs:CreateAction":"CreateSourceServerForDrs"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*",
     "Sid":"DRSAgentInstallationPolicy2"
    },
    {
     "Action":"drs:TagResource",
     "Condition":{
      "StringEquals":{
       "drs:CreateAction":"CreateRecoveryInstanceForDrs"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*",
     "Sid":"DRSAgentInstallationPolicy3"
    },
    {
     "Action":"drs:TagResource",
     "Condition":{
      "StringEquals":{
       "drs:CreateAction":"CreateSourceNetwork"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-network/*",
     "Sid":"DRSAgentInstallationPolicy4"
    },
    {
     "Action":"drs:IssueAgentCertificateForDrs",
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*",
     "Sid":"DRSAgentInstallationPolicy5"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-27T12:38:51+00:00"
 },
 "AWSElasticDisasterRecoveryAgentPolicy":{
  "CreateDate":"2021-11-17T10:32:32+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:SendAgentMetricsForDrs",
      "drs:SendAgentLogsForDrs",
      "drs:UpdateAgentSourcePropertiesForDrs",
      "drs:UpdateAgentReplicationInfoForDrs",
      "drs:UpdateAgentConversionInfoForDrs",
      "drs:GetAgentCommandForDrs",
      "drs:GetAgentConfirmedResumeInfoForDrs",
      "drs:GetAgentRuntimeConfigurationForDrs",
      "drs:UpdateAgentBacklogForDrs",
      "drs:GetAgentReplicationInfoForDrs",
      "drs:IssueAgentCertificateForDrs"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/${aws:SourceIdentity}",
     "Sid":"DRSAgentPolicy1"
    },
    {
     "Action":[
      "drs:GetAgentInstallationAssetsForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSAgentPolicy2"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-27T13:44:15+00:00"
 },
 "AWSElasticDisasterRecoveryConsoleFullAccess":{
  "CreateDate":"2021-11-17T10:46:29+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess1"
    },
    {
     "Action":[
      "kms:ListAliases",
      "kms:DescribeKey"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess2"
    },
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstanceTypeOfferings",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeVolumes",
      "ec2:GetEbsEncryptionByDefault",
      "ec2:GetEbsDefaultKmsKeyId",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeCapacityReservations",
      "ec2:DescribeHosts"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess3"
    },
    {
     "Action":"license-manager:ListLicenseConfigurations",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess4"
    },
    {
     "Action":"resource-groups:ListGroups",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess5"
    },
    {
     "Action":"elasticloadbalancing:DescribeLoadBalancers",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess6"
    },
    {
     "Action":[
      "iam:ListInstanceProfiles",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess7"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryConversionServerRole",
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryRecoveryInstanceRole"
     ],
     "Sid":"ConsoleFullAccess8"
    },
    {
     "Action":[
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*",
     "Sid":"ConsoleFullAccess9"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:ModifyLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions",
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"ConsoleFullAccess10"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplate"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"ConsoleFullAccess11"
    },
    {
     "Action":[
      "ec2:DeleteVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"ConsoleFullAccess12"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "ec2:ModifyInstanceAttribute",
      "ec2:GetConsoleOutput",
      "ec2:GetConsoleScreenshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"ConsoleFullAccess13"
    },
    {
     "Action":[
      "ec2:RevokeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*",
     "Sid":"ConsoleFullAccess14"
    },
    {
     "Action":[
      "ec2:CreateVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"ConsoleFullAccess15"
    },
    {
     "Action":"ec2:CreateSecurityGroup",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc/*",
     "Sid":"ConsoleFullAccess16"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*",
     "Sid":"ConsoleFullAccess17"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"ConsoleFullAccess18"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*",
     "Sid":"ConsoleFullAccess19"
    },
    {
     "Action":[
      "ec2:DetachVolume",
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"ConsoleFullAccess20"
    },
    {
     "Action":[
      "ec2:DetachVolume",
      "ec2:AttachVolume",
      "ec2:StartInstances",
      "ec2:GetConsoleOutput",
      "ec2:GetConsoleScreenshot"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "drs.amazonaws.com"
       ]
      },
      "StringEquals":{
       "ec2:ResourceTag/AWSDRS":"AllowLaunchingIntoThisInstance"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"ConsoleFullAccess21"
    },
    {
     "Action":[
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"ConsoleFullAccess22"
    },
    {
     "Action":[
      "ec2:DetachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"ConsoleFullAccess23"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"ConsoleFullAccess24"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ],
     "Sid":"ConsoleFullAccess25"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateSecurityGroup",
        "CreateVolume",
        "CreateSnapshot",
        "RunInstances"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"ConsoleFullAccess26"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateLaunchTemplate"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"ConsoleFullAccess27"
    },
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:ListStacks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess28"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess29"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-10-16T12:24:20+00:00"
 },
 "AWSElasticDisasterRecoveryConsoleFullAccess_v2":{
  "CreateDate":"2023-11-27T13:35:19+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess1"
    },
    {
     "Action":[
      "kms:ListAliases",
      "kms:DescribeKey"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess2"
    },
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstanceTypeOfferings",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeVolumes",
      "ec2:GetEbsEncryptionByDefault",
      "ec2:GetEbsDefaultKmsKeyId",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeCapacityReservations",
      "ec2:DescribeHosts",
      "ec2:GetInstanceTypesFromInstanceRequirements"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess3"
    },
    {
     "Action":"license-manager:ListLicenseConfigurations",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess4"
    },
    {
     "Action":"resource-groups:ListGroups",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess5"
    },
    {
     "Action":"elasticloadbalancing:DescribeLoadBalancers",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess6"
    },
    {
     "Action":[
      "iam:ListInstanceProfiles",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess7"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryConversionServerRole",
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryRecoveryInstanceRole",
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryRecoveryInstanceWithLaunchActionsRole"
     ],
     "Sid":"ConsoleFullAccess8"
    },
    {
     "Action":[
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*",
     "Sid":"ConsoleFullAccess9"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:ModifyLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions",
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"ConsoleFullAccess10"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplate"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"ConsoleFullAccess11"
    },
    {
     "Action":[
      "ec2:DeleteVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"ConsoleFullAccess12"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "ec2:ModifyInstanceAttribute",
      "ec2:GetConsoleOutput",
      "ec2:GetConsoleScreenshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"ConsoleFullAccess13"
    },
    {
     "Action":[
      "ec2:RevokeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*",
     "Sid":"ConsoleFullAccess14"
    },
    {
     "Action":[
      "ec2:CreateVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"ConsoleFullAccess15"
    },
    {
     "Action":"ec2:CreateSecurityGroup",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc/*",
     "Sid":"ConsoleFullAccess16"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*",
     "Sid":"ConsoleFullAccess17"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"ConsoleFullAccess18"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*",
     "Sid":"ConsoleFullAccess19"
    },
    {
     "Action":[
      "ec2:DetachVolume",
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"ConsoleFullAccess20"
    },
    {
     "Action":[
      "ec2:DetachVolume",
      "ec2:AttachVolume",
      "ec2:StartInstances",
      "ec2:GetConsoleOutput",
      "ec2:GetConsoleScreenshot"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "drs.amazonaws.com"
       ]
      },
      "StringEquals":{
       "ec2:ResourceTag/AWSDRS":"AllowLaunchingIntoThisInstance"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"ConsoleFullAccess21"
    },
    {
     "Action":[
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "ec2:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"ConsoleFullAccess22"
    },
    {
     "Action":[
      "ec2:DetachVolume"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"ConsoleFullAccess23"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"ConsoleFullAccess24"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ],
     "Sid":"ConsoleFullAccess25"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateSecurityGroup",
        "CreateVolume",
        "CreateSnapshot",
        "RunInstances"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"ConsoleFullAccess26"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateLaunchTemplate"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"ConsoleFullAccess27"
    },
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:ListStacks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess28"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess29"
    },
    {
     "Action":[
      "ssm:DescribeInstanceInformation",
      "ssm:DescribeParameters"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "drs.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ConsoleFullAccess30"
    },
    {
     "Action":[
      "ssm:SendCommand",
      "ssm:StartAutomationExecution"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "drs.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:automation-definition/AWS-CreateImage:$DEFAULT",
      "arn:aws:ssm:*:*:document/AWSMigration-ValidateNetworkConnectivity",
      "arn:aws:ssm:*:*:document/AWSMigration-VerifyMountedVolumes",
      "arn:aws:ssm:*:*:document/AWSMigration-ValidateHttpResponse",
      "arn:aws:ssm:*:*:document/AWSMigration-ValidateDiskSpace",
      "arn:aws:ssm:*:*:document/AWSMigration-VerifyProcessIsRunning",
      "arn:aws:ssm:*:*:document/AWSMigration-LinuxTimeSyncSetting",
      "arn:aws:ssm:*:*:document/AWSEC2-ApplicationInsightsCloudwatchAgentInstallAndConfigure"
     ],
     "Sid":"ConsoleFullAccess31"
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "drs.amazonaws.com"
       ]
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"ConsoleFullAccess32"
    },
    {
     "Action":[
      "ssm:ListDocuments",
      "ssm:ListCommandInvocations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ConsoleFullAccess33"
    },
    {
     "Action":[
      "ssm:GetParameter",
      "ssm:PutParameter"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/ManagedByAWSElasticDisasterRecoveryService-*",
     "Sid":"ConsoleFullAccess34"
    },
    {
     "Action":[
      "ssm:DescribeDocument",
      "ssm:GetDocument"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:document/*",
     "Sid":"ConsoleFullAccess35"
    },
    {
     "Action":[
      "ssm:GetParameters"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:parameter/ManagedByAWSElasticDisasterRecovery-*"
     ],
     "Sid":"ConsoleFullAccess36"
    },
    {
     "Action":[
      "ssm:GetAutomationExecution"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:automation-execution/*",
     "Sid":"ConsoleFullAccess37"
    },
    {
     "Action":[
      "ec2:AssociateIamInstanceProfile"
     ],
     "Condition":{
      "Bool":{
       "aws:ViaAWSService":"true"
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"ConsoleFullAccess38"
    },
    {
     "Action":"ec2:CreateFleet",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "drs.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:fleet/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ],
     "Sid":"ConsoleFullAccess39"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "drs.amazonaws.com"
       ]
      },
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateFleet"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"ConsoleFullAccess40"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-07-29T19:38:08+00:00"
 },
 "AWSElasticDisasterRecoveryConversionServerPolicy":{
  "CreateDate":"2021-11-17T13:42:23+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:SendClientMetricsForDrs",
      "drs:SendClientLogsForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSConversionServerPolicy1"
    },
    {
     "Action":[
      "drs:GetChannelCommandsForDrs",
      "drs:SendChannelCommandResultForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSConversionServerPolicy2"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-27T13:13:38+00:00"
 },
 "AWSElasticDisasterRecoveryCrossAccountReplicationPolicy":{
  "CreateDate":"2023-05-14T07:16:47+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeVolumes",
      "ec2:DescribeVolumeAttribute",
      "ec2:DescribeInstances",
      "drs:DescribeSourceServers",
      "drs:DescribeReplicationConfigurationTemplates",
      "drs:CreateSourceServerForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CrossAccountPolicy1"
    },
    {
     "Action":[
      "drs:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "drs:CreateAction":"CreateSourceServerForDrs"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*",
     "Sid":"CrossAccountPolicy2"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-01-17T13:19:58+00:00"
 },
 "AWSElasticDisasterRecoveryEc2InstancePolicy":{
  "CreateDate":"2022-05-26T12:30:18+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:GetAgentInstallationAssetsForDrs",
      "drs:SendClientLogsForDrs",
      "drs:SendClientMetricsForDrs",
      "drs:CreateSourceServerForDrs",
      "drs:CreateSourceNetwork"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSEc2InstancePolicy1"
    },
    {
     "Action":[
      "drs:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "drs:CreateAction":"CreateSourceServerForDrs"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*",
     "Sid":"DRSEc2InstancePolicy2"
    },
    {
     "Action":[
      "drs:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "drs:CreateAction":"CreateSourceNetwork"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-network/*",
     "Sid":"DRSEc2InstancePolicy3"
    },
    {
     "Action":[
      "drs:SendAgentMetricsForDrs",
      "drs:SendAgentLogsForDrs",
      "drs:UpdateAgentSourcePropertiesForDrs",
      "drs:UpdateAgentReplicationInfoForDrs",
      "drs:UpdateAgentConversionInfoForDrs",
      "drs:GetAgentCommandForDrs",
      "drs:GetAgentConfirmedResumeInfoForDrs",
      "drs:GetAgentRuntimeConfigurationForDrs",
      "drs:UpdateAgentBacklogForDrs",
      "drs:GetAgentReplicationInfoForDrs"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*",
     "Sid":"DRSEc2InstancePolicy4"
    },
    {
     "Action":[
      "sts:AssumeRole",
      "sts:TagSession"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "sts:TransitiveTagKeys":"SourceInstanceARN"
      },
      "StringLike":{
       "aws:RequestTag/SourceInstanceARN":"${ec2:SourceInstanceARN}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/DRSCrossAccountAgentAuthorizedRole_*"
     ],
     "Sid":"DRSEc2InstancePolicy5"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-27T13:39:44+00:00"
 },
 "AWSElasticDisasterRecoveryFailbackInstallationPolicy":{
  "CreateDate":"2021-11-17T11:02:03+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:SendClientLogsForDrs",
      "drs:SendClientMetricsForDrs",
      "drs:DescribeRecoveryInstances",
      "drs:DescribeSourceServers"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSFailbackInstallationPolicy1"
    },
    {
     "Action":[
      "drs:TagResource",
      "drs:IssueAgentCertificateForDrs",
      "drs:AssociateFailbackClientToRecoveryInstanceForDrs",
      "drs:GetSuggestedFailbackClientDeviceMappingForDrs",
      "drs:UpdateAgentReplicationInfoForDrs",
      "drs:UpdateFailbackClientDeviceMappingForDrs"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:recovery-instance/*",
     "Sid":"DRSFailbackInstallationPolicy2"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-27T13:43:08+00:00"
 },
 "AWSElasticDisasterRecoveryFailbackPolicy":{
  "CreateDate":"2021-11-17T10:41:40+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:SendClientMetricsForDrs",
      "drs:SendClientLogsForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSFailbackPolicy1"
    },
    {
     "Action":[
      "drs:GetChannelCommandsForDrs",
      "drs:SendChannelCommandResultForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSFailbackPolicy2"
    },
    {
     "Action":[
      "drs:DescribeReplicationServerAssociationsForDrs",
      "drs:DescribeRecoveryInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSFailbackPolicy3"
    },
    {
     "Action":[
      "drs:GetFailbackCommandForDrs",
      "drs:UpdateFailbackClientLastSeenForDrs",
      "drs:NotifyAgentAuthenticationForDrs",
      "drs:UpdateAgentReplicationProcessStateForDrs",
      "drs:NotifyAgentReplicationProgressForDrs",
      "drs:NotifyAgentConnectedForDrs",
      "drs:NotifyAgentDisconnectedForDrs",
      "drs:NotifyConsistencyAttainedForDrs",
      "drs:GetFailbackLaunchRequestedForDrs",
      "drs:IssueAgentCertificateForDrs"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:recovery-instance/${aws:SourceIdentity}",
     "Sid":"DRSFailbackPolicy4"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-27T12:56:46+00:00"
 },
 "AWSElasticDisasterRecoveryLaunchActionsPolicy":{
  "CreateDate":"2023-09-13T07:38:26+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:DescribeInstanceInformation",
      "ssm:DescribeParameters"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "drs.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"LaunchActionsPolicy1"
    },
    {
     "Action":[
      "ssm:SendCommand",
      "ssm:StartAutomationExecution"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "drs.amazonaws.com"
       ]
      },
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/*",
      "arn:aws:ssm:*:*:automation-definition/*:*"
     ],
     "Sid":"LaunchActionsPolicy2"
    },
    {
     "Action":[
      "ssm:SendCommand",
      "ssm:StartAutomationExecution"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "drs.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*::document/AWS-*",
      "arn:aws:ssm:*::document/AWSCodeDeployAgent-*",
      "arn:aws:ssm:*::document/AWSConfigRemediation-*",
      "arn:aws:ssm:*::document/AWSConformancePacks-*",
      "arn:aws:ssm:*::document/AWSDisasterRecovery-*",
      "arn:aws:ssm:*::document/AWSDistroOTel-*",
      "arn:aws:ssm:*::document/AWSDocs-*",
      "arn:aws:ssm:*::document/AWSEC2-*",
      "arn:aws:ssm:*::document/AWSEC2Launch-*",
      "arn:aws:ssm:*::document/AWSFIS-*",
      "arn:aws:ssm:*::document/AWSFleetManager-*",
      "arn:aws:ssm:*::document/AWSIncidents-*",
      "arn:aws:ssm:*::document/AWSKinesisTap-*",
      "arn:aws:ssm:*::document/AWSMigration-*",
      "arn:aws:ssm:*::document/AWSNVMe-*",
      "arn:aws:ssm:*::document/AWSNitroEnclavesWindows-*",
      "arn:aws:ssm:*::document/AWSObservabilityExporter-*",
      "arn:aws:ssm:*::document/AWSPVDriver-*",
      "arn:aws:ssm:*::document/AWSQuickSetupType-*",
      "arn:aws:ssm:*::document/AWSQuickStarts-*",
      "arn:aws:ssm:*::document/AWSRefactorSpaces-*",
      "arn:aws:ssm:*::document/AWSResilienceHub-*",
      "arn:aws:ssm:*::document/AWSSAP-*",
      "arn:aws:ssm:*::document/AWSSAPTools-*",
      "arn:aws:ssm:*::document/AWSSQLServer-*",
      "arn:aws:ssm:*::document/AWSSSO-*",
      "arn:aws:ssm:*::document/AWSSupport-*",
      "arn:aws:ssm:*::document/AWSSystemsManagerSAP-*",
      "arn:aws:ssm:*::document/AmazonCloudWatch-*",
      "arn:aws:ssm:*::document/AmazonCloudWatchAgent-*",
      "arn:aws:ssm:*::document/AmazonECS-*",
      "arn:aws:ssm:*::document/AmazonEFSUtils-*",
      "arn:aws:ssm:*::document/AmazonEKS-*",
      "arn:aws:ssm:*::document/AmazonInspector-*",
      "arn:aws:ssm:*::document/AmazonInspector2-*",
      "arn:aws:ssm:*::document/AmazonInternal-*",
      "arn:aws:ssm:*::document/AwsEnaNetworkDriver-*",
      "arn:aws:ssm:*::document/AwsVssComponents-*",
      "arn:aws:ssm:*::automation-definition/AWS-*:*",
      "arn:aws:ssm:*::automation-definition/AWSCodeDeployAgent-*:*",
      "arn:aws:ssm:*::automation-definition/AWSConfigRemediation-*:*",
      "arn:aws:ssm:*::automation-definition/AWSConformancePacks-*:*",
      "arn:aws:ssm:*::automation-definition/AWSDisasterRecovery-*:*",
      "arn:aws:ssm:*::automation-definition/AWSDistroOTel-*:*",
      "arn:aws:ssm:*::automation-definition/AWSDocs-*:*",
      "arn:aws:ssm:*::automation-definition/AWSEC2-*:*",
      "arn:aws:ssm:*::automation-definition/AWSEC2Launch-*:*",
      "arn:aws:ssm:*::automation-definition/AWSFIS-*:*",
      "arn:aws:ssm:*::automation-definition/AWSFleetManager-*:*",
      "arn:aws:ssm:*::automation-definition/AWSIncidents-*:*",
      "arn:aws:ssm:*::automation-definition/AWSKinesisTap-*:*",
      "arn:aws:ssm:*::automation-definition/AWSMigration-*:*",
      "arn:aws:ssm:*::automation-definition/AWSNVMe-*:*",
      "arn:aws:ssm:*::automation-definition/AWSNitroEnclavesWindows-*:*",
      "arn:aws:ssm:*::automation-definition/AWSObservabilityExporter-*:*",
      "arn:aws:ssm:*::automation-definition/AWSPVDriver-*:*",
      "arn:aws:ssm:*::automation-definition/AWSQuickSetupType-*:*",
      "arn:aws:ssm:*::automation-definition/AWSQuickStarts-*:*",
      "arn:aws:ssm:*::automation-definition/AWSRefactorSpaces-*:*",
      "arn:aws:ssm:*::automation-definition/AWSResilienceHub-*:*",
      "arn:aws:ssm:*::automation-definition/AWSSAP-*:*",
      "arn:aws:ssm:*::automation-definition/AWSSAPTools-*:*",
      "arn:aws:ssm:*::automation-definition/AWSSQLServer-*:*",
      "arn:aws:ssm:*::automation-definition/AWSSSO-*:*",
      "arn:aws:ssm:*::automation-definition/AWSSupport-*:*",
      "arn:aws:ssm:*::automation-definition/AWSSystemsManagerSAP-*:*",
      "arn:aws:ssm:*::automation-definition/AmazonCloudWatch-*:*",
      "arn:aws:ssm:*::automation-definition/AmazonCloudWatchAgent-*:*",
      "arn:aws:ssm:*::automation-definition/AmazonECS-*:*",
      "arn:aws:ssm:*::automation-definition/AmazonEFSUtils-*:*",
      "arn:aws:ssm:*::automation-definition/AmazonEKS-*:*",
      "arn:aws:ssm:*::automation-definition/AmazonInspector-*:*",
      "arn:aws:ssm:*::automation-definition/AmazonInspector2-*:*",
      "arn:aws:ssm:*::automation-definition/AmazonInternal-*:*",
      "arn:aws:ssm:*::automation-definition/AwsEnaNetworkDriver-*:*",
      "arn:aws:ssm:*::automation-definition/AwsVssComponents-*:*"
     ],
     "Sid":"LaunchActionsPolicy3"
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "drs.amazonaws.com"
       ]
      },
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"LaunchActionsPolicy4"
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "drs.amazonaws.com"
       ]
      },
      "StringEquals":{
       "aws:ResourceTag/AWSDRS":"AllowLaunchingIntoThisInstance"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"LaunchActionsPolicy5"
    },
    {
     "Action":[
      "ssm:ListDocuments",
      "ssm:ListCommandInvocations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LaunchActionsPolicy6"
    },
    {
     "Action":[
      "ssm:ListDocumentVersions",
      "ssm:GetDocument",
      "ssm:DescribeDocument"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:document/*",
     "Sid":"LaunchActionsPolicy7"
    },
    {
     "Action":[
      "ssm:GetAutomationExecution"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:automation-execution/*",
     "Sid":"LaunchActionsPolicy8"
    },
    {
     "Action":[
      "ssm:GetParameters"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/ManagedByAWSElasticDisasterRecoveryService-*",
     "Sid":"LaunchActionsPolicy9"
    },
    {
     "Action":[
      "ssm:GetParameter",
      "ssm:PutParameter"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/ManagedByAWSElasticDisasterRecoveryService-*",
     "Sid":"LaunchActionsPolicy10"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"drs.amazonaws.com"
      },
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryRecoveryInstanceWithLaunchActionsRole"
     ],
     "Sid":"LaunchActionsPolicy11"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-19T07:29:42+00:00"
 },
 "AWSElasticDisasterRecoveryNetworkReplicationPolicy":{
  "CreateDate":"2023-06-11T12:36:48+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeVpcs",
      "ec2:DescribeSubnets",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeRouteTables",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeDhcpOptions",
      "ec2:DescribeInstances",
      "ec2:DescribeManagedPrefixLists",
      "ec2:GetManagedPrefixListEntries",
      "ec2:GetManagedPrefixListAssociations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSNetworkReplicationPolicy1"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-01-02T13:25:23+00:00"
 },
 "AWSElasticDisasterRecoveryReadOnlyAccess":{
  "CreateDate":"2021-11-17T10:50:05+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:DescribeJobLogItems",
      "drs:DescribeJobs",
      "drs:DescribeRecoveryInstances",
      "drs:DescribeRecoverySnapshots",
      "drs:DescribeReplicationConfigurationTemplates",
      "drs:DescribeSourceServers",
      "drs:GetFailbackReplicationConfiguration",
      "drs:GetLaunchConfiguration",
      "drs:GetReplicationConfiguration",
      "drs:ListExtensibleSourceServers",
      "drs:ListStagingAccounts",
      "drs:ListTagsForResource",
      "drs:ListLaunchActions"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSReadOnlyAccess1"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:GetInstanceTypesFromInstanceRequirements"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSReadOnlyAccess2"
    },
    {
     "Action":"iam:ListRoles",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSReadOnlyAccess4"
    },
    {
     "Action":"ssm:ListCommandInvocations",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSReadOnlyAccess5"
    },
    {
     "Action":"ssm:GetParameter",
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/ManagedByAWSElasticDisasterRecovery-*",
     "Sid":"DRSReadOnlyAccess6"
    },
    {
     "Action":[
      "ssm:DescribeDocument",
      "ssm:GetDocument"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWS-CreateImage",
      "arn:aws:ssm:*:*:document/AWSMigration-ValidateNetworkConnectivity",
      "arn:aws:ssm:*:*:document/AWSMigration-VerifyMountedVolumes",
      "arn:aws:ssm:*:*:document/AWSMigration-ValidateHttpResponse",
      "arn:aws:ssm:*:*:document/AWSMigration-ValidateDiskSpace",
      "arn:aws:ssm:*:*:document/AWSMigration-VerifyProcessIsRunning",
      "arn:aws:ssm:*:*:document/AWSMigration-LinuxTimeSyncSetting",
      "arn:aws:ssm:*:*:document/AWSEC2-ApplicationInsightsCloudwatchAgentInstallAndConfigure"
     ],
     "Sid":"DRSReadOnlyAccess7"
    },
    {
     "Action":[
      "ssm:GetAutomationExecution"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:automation-execution/*",
     "Sid":"DRSReadOnlyAccess8"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-07-29T19:39:26+00:00"
 },
 "AWSElasticDisasterRecoveryRecoveryInstancePolicy":{
  "CreateDate":"2021-11-17T10:20:43+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:SendAgentMetricsForDrs",
      "drs:SendAgentLogsForDrs",
      "drs:UpdateAgentSourcePropertiesForDrs",
      "drs:UpdateAgentReplicationInfoForDrs",
      "drs:UpdateAgentConversionInfoForDrs",
      "drs:GetAgentCommandForDrs",
      "drs:GetAgentConfirmedResumeInfoForDrs",
      "drs:GetAgentRuntimeConfigurationForDrs",
      "drs:UpdateAgentBacklogForDrs",
      "drs:GetAgentReplicationInfoForDrs",
      "drs:UpdateReplicationCertificateForDrs",
      "drs:NotifyReplicationServerAuthenticationForDrs"
     ],
     "Condition":{
      "StringEquals":{
       "drs:EC2InstanceARN":"${ec2:SourceInstanceARN}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:recovery-instance/*",
     "Sid":"DRSRecoveryInstancePolicy1"
    },
    {
     "Action":[
      "drs:DescribeRecoveryInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSRecoveryInstancePolicy2"
    },
    {
     "Action":[
      "ec2:DescribeInstanceTypes"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSRecoveryInstancePolicy3"
    },
    {
     "Action":[
      "drs:GetAgentInstallationAssetsForDrs",
      "drs:SendClientLogsForDrs",
      "drs:CreateSourceServerForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSRecoveryInstancePolicy4"
    },
    {
     "Action":[
      "drs:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "drs:CreateAction":"CreateSourceServerForDrs"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*",
     "Sid":"DRSRecoveryInstancePolicy5"
    },
    {
     "Action":[
      "drs:SendAgentMetricsForDrs",
      "drs:SendAgentLogsForDrs",
      "drs:UpdateAgentSourcePropertiesForDrs",
      "drs:UpdateAgentReplicationInfoForDrs",
      "drs:UpdateAgentConversionInfoForDrs",
      "drs:GetAgentCommandForDrs",
      "drs:GetAgentConfirmedResumeInfoForDrs",
      "drs:GetAgentRuntimeConfigurationForDrs",
      "drs:UpdateAgentBacklogForDrs",
      "drs:GetAgentReplicationInfoForDrs"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*",
     "Sid":"DRSRecoveryInstancePolicy6"
    },
    {
     "Action":[
      "sts:AssumeRole",
      "sts:TagSession"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "sts:TransitiveTagKeys":"SourceInstanceARN"
      },
      "StringLike":{
       "aws:RequestTag/SourceInstanceARN":"${ec2:SourceInstanceARN}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/DRSCrossAccountAgentAuthorizedRole_*"
     ],
     "Sid":"DRSRecoveryInstancePolicy7"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-27T13:11:08+00:00"
 },
 "AWSElasticDisasterRecoveryReplicationServerPolicy":{
  "CreateDate":"2021-11-17T13:34:00+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:SendClientMetricsForDrs",
      "drs:SendClientLogsForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSReplicationServerPolicy1"
    },
    {
     "Action":[
      "drs:GetChannelCommandsForDrs",
      "drs:SendChannelCommandResultForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSReplicationServerPolicy2"
    },
    {
     "Action":[
      "drs:GetAgentSnapshotCreditsForDrs",
      "drs:DescribeReplicationServerAssociationsForDrs",
      "drs:DescribeSnapshotRequestsForDrs",
      "drs:BatchDeleteSnapshotRequestForDrs",
      "drs:NotifyAgentAuthenticationForDrs",
      "drs:BatchCreateVolumeSnapshotGroupForDrs",
      "drs:UpdateAgentReplicationProcessStateForDrs",
      "drs:NotifyAgentReplicationProgressForDrs",
      "drs:NotifyAgentConnectedForDrs",
      "drs:NotifyAgentDisconnectedForDrs",
      "drs:NotifyVolumeEventForDrs",
      "drs:SendVolumeStatsForDrs"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSReplicationServerPolicy3"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSReplicationServerPolicy4"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"DRSReplicationServerPolicy5"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*",
     "Sid":"DRSReplicationServerPolicy6"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CreateSnapshot"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSReplicationServerPolicy7"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-27T13:28:14+00:00"
 },
 "AWSElasticDisasterRecoveryServiceRolePolicy":{
  "CreateDate":"2021-11-17T10:56:17+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSServiceRolePolicy1"
    },
    {
     "Action":[
      "drs:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:recovery-instance/*",
     "Sid":"DRSServiceRolePolicy2"
    },
    {
     "Action":[
      "drs:CreateRecoveryInstanceForDrs",
      "drs:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:drs:*:*:source-server/*",
     "Sid":"DRSServiceRolePolicy3"
    },
    {
     "Action":"iam:GetInstanceProfile",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSServiceRolePolicy4"
    },
    {
     "Action":"kms:ListRetirableGrants",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSServiceRolePolicy5"
    },
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeVolumes",
      "ec2:DescribeVolumeAttribute",
      "ec2:GetEbsDefaultKmsKeyId",
      "ec2:GetEbsEncryptionByDefault",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeVpcs",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribeRouteTables",
      "ec2:DescribeDhcpOptions",
      "ec2:DescribeManagedPrefixLists",
      "ec2:GetManagedPrefixListEntries",
      "ec2:GetManagedPrefixListAssociations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSServiceRolePolicy6"
    },
    {
     "Action":[
      "ec2:RegisterImage"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSServiceRolePolicy7"
    },
    {
     "Action":[
      "ec2:DeregisterImage"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSServiceRolePolicy8"
    },
    {
     "Action":[
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*",
     "Sid":"DRSServiceRolePolicy9"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:ModifyLaunchTemplate",
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"DRSServiceRolePolicy10"
    },
    {
     "Action":[
      "ec2:DeleteVolume",
      "ec2:ModifyVolume"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"DRSServiceRolePolicy11"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances",
      "ec2:ModifyInstanceAttribute",
      "ec2:GetConsoleOutput",
      "ec2:GetConsoleScreenshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"DRSServiceRolePolicy12"
    },
    {
     "Action":[
      "ec2:RevokeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*",
     "Sid":"DRSServiceRolePolicy13"
    },
    {
     "Action":[
      "ec2:CreateVolume"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"DRSServiceRolePolicy14"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*",
     "Sid":"DRSServiceRolePolicy15"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc/*",
     "Sid":"DRSServiceRolePolicy16"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplate"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"DRSServiceRolePolicy17"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"DRSServiceRolePolicy18"
    },
    {
     "Action":[
      "ec2:CreateSnapshot"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*",
     "Sid":"DRSServiceRolePolicy19"
    },
    {
     "Action":[
      "ec2:DetachVolume",
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"DRSServiceRolePolicy20"
    },
    {
     "Action":[
      "ec2:AttachVolume"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"DRSServiceRolePolicy21"
    },
    {
     "Action":[
      "ec2:DetachVolume"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"DRSServiceRolePolicy22"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"DRSServiceRolePolicy23"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ],
     "Sid":"DRSServiceRolePolicy24"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryReplicationServerRole",
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryConversionServerRole",
      "arn:aws:iam::*:role/service-role/AWSElasticDisasterRecoveryRecoveryInstanceRole"
     ],
     "Sid":"DRSServiceRolePolicy25"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":[
        "CreateLaunchTemplate",
        "CreateSecurityGroup",
        "CreateVolume",
        "CreateSnapshot",
        "RunInstances"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:launch-template/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"DRSServiceRolePolicy26"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSElasticDisasterRecoveryManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:image/*"
     ],
     "Sid":"DRSServiceRolePolicy27"
    },
    {
     "Action":"cloudwatch:GetMetricData",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSServiceRolePolicy28"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-01-17T13:49:07+00:00"
 },
 "AWSElasticDisasterRecoveryStagingAccountPolicy":{
  "CreateDate":"2022-05-26T09:49:18+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:DescribeSourceServers",
      "drs:DescribeRecoverySnapshots",
      "drs:CreateConvertedSnapshotForDrs",
      "drs:GetReplicationConfiguration",
      "drs:DescribeJobs",
      "drs:DescribeJobLogItems"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSStagingAccountPolicy1"
    },
    {
     "Action":[
      "ec2:ModifySnapshotAttribute"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      },
      "StringEquals":{
       "ec2:Add/userId":"${aws:SourceIdentity}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*",
     "Sid":"DRSStagingAccountPolicy2"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-27T13:07:49+00:00"
 },
 "AWSElasticDisasterRecoveryStagingAccountPolicy_v2":{
  "CreateDate":"2023-01-05T12:11:44+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "drs:DescribeSourceServers",
      "drs:DescribeRecoverySnapshots",
      "drs:CreateConvertedSnapshotForDrs",
      "drs:GetReplicationConfiguration",
      "drs:DescribeJobs",
      "drs:DescribeJobLogItems"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DRSStagingAccountPolicyv21"
    },
    {
     "Action":[
      "ec2:ModifySnapshotAttribute"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSElasticDisasterRecoveryManaged":"false"
      },
      "StringEquals":{
       "ec2:Add/userId":"${aws:SourceIdentity}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*",
     "Sid":"DRSStagingAccountPolicyv22"
    },
    {
     "Action":"drs:IssueAgentCertificateForDrs",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:drs:*:*:source-server/*"
     ],
     "Sid":"DRSStagingAccountPolicyv23"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-27T13:32:09+00:00"
 },
 "AWSElasticLoadBalancingClassicServiceRolePolicy":{
  "CreateDate":"2017-09-19T22:36:18+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeAddresses",
      "ec2:DescribeInstances",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeVpcs",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeClassicLinkInstances",
      "ec2:DescribeVpcClassicLink",
      "ec2:CreateSecurityGroup",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AssociateAddress",
      "ec2:DisassociateAddress",
      "ec2:AttachNetworkInterface",
      "ec2:DetachNetworkInterface",
      "ec2:AssignPrivateIpAddresses",
      "ec2:AssignIpv6Addresses",
      "ec2:UnassignIpv6Addresses"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-07T23:04:27+00:00"
 },
 "AWSElasticLoadBalancingServiceRolePolicy":{
  "CreateDate":"2017-09-19T22:19:04+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeAddresses",
      "ec2:DescribeCoipPools",
      "ec2:DescribeInstances",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeVpcs",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeClassicLinkInstances",
      "ec2:DescribeVpcClassicLink",
      "ec2:CreateSecurityGroup",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:GetCoipPoolUsage",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:AllocateAddress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:AssociateAddress",
      "ec2:DisassociateAddress",
      "ec2:AttachNetworkInterface",
      "ec2:DetachNetworkInterface",
      "ec2:AssignPrivateIpAddresses",
      "ec2:AssignIpv6Addresses",
      "ec2:ReleaseAddress",
      "ec2:UnassignIpv6Addresses",
      "ec2:DescribeVpcPeeringConnections",
      "logs:CreateLogDelivery",
      "logs:GetLogDelivery",
      "logs:UpdateLogDelivery",
      "logs:DeleteLogDelivery",
      "logs:ListLogDeliveries",
      "outposts:GetOutpostInstanceTypes"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-26T19:01:48+00:00"
 },
 "AWSElementalMediaConvertFullAccess":{
  "CreateDate":"2018-06-25T19:25:35+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mediaconvert:*",
      "s3:ListAllMyBuckets",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "mediaconvert.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-10T22:52:25+00:00"
 },
 "AWSElementalMediaConvertReadOnly":{
  "CreateDate":"2018-06-25T19:25:14+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mediaconvert:Get*",
      "mediaconvert:List*",
      "mediaconvert:DescribeEndpoints",
      "s3:ListAllMyBuckets",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-10T22:52:18+00:00"
 },
 "AWSElementalMediaLiveFullAccess":{
  "CreateDate":"2020-07-08T17:07:14+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":"medialive:*",
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-07-08T17:07:14+00:00"
 },
 "AWSElementalMediaLiveReadOnly":{
  "CreateDate":"2020-07-08T16:38:07+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "medialive:Get*",
      "medialive:List*",
      "medialive:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSElementalMediaLiveReadOnly"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-07-22T17:08:46+00:00"
 },
 "AWSElementalMediaPackageFullAccess":{
  "CreateDate":"2017-12-29T23:39:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":"mediapackage:*",
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-12-29T23:39:52+00:00"
 },
 "AWSElementalMediaPackageReadOnly":{
  "CreateDate":"2017-12-30T00:04:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":[
     "mediapackage:List*",
     "mediapackage:Describe*"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-12-30T00:04:29+00:00"
 },
 "AWSElementalMediaPackageV2FullAccess":{
  "CreateDate":"2023-07-25T20:29:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":"mediapackagev2:*",
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-07-25T20:29:37+00:00"
 },
 "AWSElementalMediaPackageV2ReadOnly":{
  "CreateDate":"2023-07-25T20:31:25+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":[
     "mediapackagev2:List*",
     "mediapackagev2:Get*"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-07-25T20:31:25+00:00"
 },
 "AWSElementalMediaStoreFullAccess":{
  "CreateDate":"2018-03-05T23:15:31+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mediastore:*"
     ],
     "Condition":{
      "Bool":{
       "aws:SecureTransport":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-03-05T23:15:31+00:00"
 },
 "AWSElementalMediaStoreReadOnly":{
  "CreateDate":"2018-03-08T19:48:22+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mediastore:Get*",
      "mediastore:List*",
      "mediastore:Describe*"
     ],
     "Condition":{
      "Bool":{
       "aws:SecureTransport":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-03-08T19:48:22+00:00"
 },
 "AWSElementalMediaTailorFullAccess":{
  "CreateDate":"2021-11-23T00:04:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":"mediatailor:*",
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-23T00:04:39+00:00"
 },
 "AWSElementalMediaTailorReadOnly":{
  "CreateDate":"2021-11-23T00:05:01+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":[
     "mediatailor:List*",
     "mediatailor:Describe*",
     "mediatailor:Get*"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-23T00:05:01+00:00"
 },
 "AWSEnhancedClassicNetworkingMangementPolicy":{
  "CreateDate":"2017-09-20T17:29:09+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeSecurityGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-09-20T17:29:09+00:00"
 },
 "AWSEntityResolutionConsoleFullAccess":{
  "CreateDate":"2023-08-17T17:54:14+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "entityresolution:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EntityResolutionAccess"
    },
    {
     "Action":[
      "glue:GetSchema",
      "glue:SearchTables",
      "glue:GetSchemaByDefinition",
      "glue:GetSchemaVersion",
      "glue:GetSchemaVersionsDiff",
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:GetTable",
      "glue:GetTables",
      "glue:GetTableVersion",
      "glue:GetTableVersions"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"GlueSourcesConsoleDisplay"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3BucketsConsoleDisplay"
    },
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetBucketLocation",
      "s3:ListBucketVersions",
      "s3:GetBucketVersioning"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3SourcesConsoleDisplay"
    },
    {
     "Action":[
      "tag:GetTagKeys",
      "tag:GetTagValues"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"TaggingConsoleDisplay"
    },
    {
     "Action":[
      "kms:DescribeKey",
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMSConsoleDisplay"
    },
    {
     "Action":[
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListRolesToPickRoleForPassing"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "entityresolution.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*entityresolution*",
     "Sid":"PassRoleToEntityResolutionService"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:PutTargets",
      "events:PutRule"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/entity-resolution-automatic*"
     ],
     "Sid":"ManageEventBridgeRules"
    },
    {
     "Action":[
      "dataexchange:GetDataSet"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ADXReadAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-10-16T18:46:10+00:00"
 },
 "AWSEntityResolutionConsoleReadOnlyAccess":{
  "CreateDate":"2023-08-17T18:18:36+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "entityresolution:Get*",
      "entityresolution:List*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EntityResolutionRead"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-08-17T18:18:36+00:00"
 },
 "AWSFMAdminFullAccess":{
  "CreateDate":"2018-05-09T18:06:18+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "fms:*",
      "waf:*",
      "waf-regional:*",
      "elasticloadbalancing:SetWebACL",
      "firehose:ListDeliveryStreams",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListRoots",
      "organizations:ListChildren",
      "organizations:ListAccounts",
      "organizations:ListAccountsForParent",
      "organizations:ListOrganizationalUnitsForParent",
      "shield:GetSubscriptionState",
      "route53resolver:ListFirewallRuleGroups",
      "route53resolver:GetFirewallRuleGroup",
      "wafv2:ListRuleGroups",
      "wafv2:ListAvailableManagedRuleGroups",
      "wafv2:CheckCapacity",
      "wafv2:PutLoggingConfiguration",
      "wafv2:ListAvailableManagedRuleGroupVersions",
      "network-firewall:DescribeRuleGroup",
      "network-firewall:DescribeRuleGroupMetadata",
      "network-firewall:ListRuleGroups",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeRegions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:PutBucketPolicy",
      "s3:GetBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-waf-logs-*"
     ]
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "fms.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "organizations:EnableAWSServiceAccess",
      "organizations:ListDelegatedAdministrators",
      "organizations:RegisterDelegatedAdministrator",
      "organizations:DeregisterDelegatedAdministrator"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":[
        "fms.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-10-20T23:39:06+00:00"
 },
 "AWSFMAdminReadOnlyAccess":{
  "CreateDate":"2018-05-09T20:07:39+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "fms:Get*",
      "fms:List*",
      "waf:Get*",
      "waf:List*",
      "waf-regional:Get*",
      "waf-regional:List*",
      "firehose:ListDeliveryStreams",
      "organizations:DescribeOrganization",
      "organizations:DescribeAccount",
      "organizations:ListRoots",
      "organizations:ListChildren",
      "organizations:ListAccounts",
      "organizations:ListAccountsForParent",
      "organizations:ListOrganizationalUnitsForParent",
      "shield:GetSubscriptionState",
      "route53resolver:ListFirewallRuleGroups",
      "route53resolver:GetFirewallRuleGroup",
      "wafv2:ListRuleGroups",
      "wafv2:ListAvailableManagedRuleGroups",
      "wafv2:CheckCapacity",
      "wafv2:ListAvailableManagedRuleGroupVersions",
      "network-firewall:DescribeRuleGroup",
      "network-firewall:DescribeRuleGroupMetadata",
      "network-firewall:ListRuleGroups",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeRegions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-waf-logs-*"
     ]
    },
    {
     "Action":[
      "organizations:ListDelegatedAdministrators"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":[
        "fms.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-10-31T22:42:13+00:00"
 },
 "AWSFMMemberReadOnlyAccess":{
  "CreateDate":"2018-05-09T21:05:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "fms:GetAdminAccount",
      "waf:Get*",
      "waf:List*",
      "waf-regional:Get*",
      "waf-regional:List*",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-05-09T21:05:29+00:00"
 },
 "AWSFaultInjectionSimulatorEC2Access":{
  "CreateDate":"2022-10-26T20:39:26+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:RebootInstances",
      "ec2:SendSpotInstanceInterruptions",
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"AllowEc2Actions"
    },
    {
     "Action":[
      "kms:CreateGrant"
     ],
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":"true"
      },
      "StringLike":{
       "kms:ViaService":"ec2.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kms:*:*:key/*"
     ],
     "Sid":"AllowEc2InstancesWithEncryptedEbsVolumes"
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ssm:*:*:document/*"
     ],
     "Sid":"AllowSSMSendOnEc2"
    },
    {
     "Action":[
      "ssm:CancelCommand",
      "ssm:ListCommands"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowSSMStopOnEc2"
    },
    {
     "Action":"ec2:DescribeInstances",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribeInstances"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-27T15:08:12+00:00"
 },
 "AWSFaultInjectionSimulatorECSAccess":{
  "CreateDate":"2022-10-26T20:37:56+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:DescribeClusters",
      "ecs:ListContainerInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ecs:*:*:cluster/*"
     ],
     "Sid":"Clusters"
    },
    {
     "Action":[
      "ecs:DescribeTasks",
      "ecs:StopTask"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ecs:*:*:task/*/*"
     ],
     "Sid":"Tasks"
    },
    {
     "Action":[
      "ecs:UpdateContainerInstancesState"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ecs:*:*:container-instance/*/*"
     ],
     "Sid":"ContainerInstances"
    },
    {
     "Action":[
      "ecs:ListTasks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListTasks"
    },
    {
     "Action":"ssm:SendCommand",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:managed-instance/*",
      "arn:aws:ssm:*:*:document/*"
     ],
     "Sid":"SSMSend"
    },
    {
     "Action":[
      "ssm:ListCommands",
      "ssm:CancelCommand"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SSMList"
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"TargetResolutionByTags"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-01-25T16:16:02+00:00"
 },
 "AWSFaultInjectionSimulatorEKSAccess":{
  "CreateDate":"2022-10-26T20:34:43+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":"ec2:DescribeInstances",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribeInstances"
    },
    {
     "Action":"ec2:TerminateInstances",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"TerminateInstances"
    },
    {
     "Action":"ec2:DescribeSubnets",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribeSubnets"
    },
    {
     "Action":"eks:DescribeCluster",
     "Effect":"Allow",
     "Resource":"arn:aws:eks:*:*:cluster/*",
     "Sid":"DescribeCluster"
    },
    {
     "Action":"eks:DescribeNodegroup",
     "Effect":"Allow",
     "Resource":"arn:aws:eks:*:*:nodegroup/*",
     "Sid":"DescribeNodeGroup"
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"TargetResolutionByTags"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-13T16:44:51+00:00"
 },
 "AWSFaultInjectionSimulatorNetworkAccess":{
  "CreateDate":"2022-10-26T20:32:50+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/managedByFIS":"true",
       "ec2:CreateAction":"CreateNetworkAcl"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-acl/*",
     "Sid":"CreateTagsOnNetworkAcl"
    },
    {
     "Action":"ec2:CreateNetworkAcl",
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/managedByFIS":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-acl/*",
     "Sid":"CreateNetworkAcl"
    },
    {
     "Action":[
      "ec2:CreateNetworkAclEntry",
      "ec2:DeleteNetworkAcl"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/managedByFIS":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-acl/*",
      "arn:aws:ec2:*:*:vpc/*"
     ],
     "Sid":"DeleteNetworkAcl"
    },
    {
     "Action":"ec2:CreateNetworkAcl",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc/*",
     "Sid":"CreateNetworkAclOnVpc"
    },
    {
     "Action":[
      "ec2:DescribeVpcs",
      "ec2:DescribeManagedPrefixLists",
      "ec2:DescribeSubnets",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeVpcPeeringConnections",
      "ec2:DescribeRouteTables",
      "ec2:DescribeTransitGatewayPeeringAttachments",
      "ec2:DescribeTransitGatewayAttachments",
      "ec2:DescribeTransitGateways"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VpcActions"
    },
    {
     "Action":"ec2:ReplaceNetworkAclAssociation",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:network-acl/*"
     ],
     "Sid":"ReplaceNetworkAclAssociation"
    },
    {
     "Action":"ec2:GetManagedPrefixListEntries",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:prefix-list/*",
     "Sid":"GetManagedPrefixListEntries"
    },
    {
     "Action":"ec2:CreateRouteTable",
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/managedByFIS":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:route-table/*",
     "Sid":"CreateRouteTable"
    },
    {
     "Action":"ec2:CreateRouteTable",
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc/*",
     "Sid":"CreateRouteTableOnVpc"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/managedByFIS":"true",
       "ec2:CreateAction":"CreateRouteTable"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:route-table/*",
     "Sid":"CreateTagsOnRouteTable"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/managedByFIS":"true",
       "ec2:CreateAction":"CreateNetworkInterface"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*",
     "Sid":"CreateTagsOnNetworkInterface"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/managedByFIS":"true",
       "ec2:CreateAction":"CreateManagedPrefixList"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:prefix-list/*",
     "Sid":"CreateTagsOnPrefixList"
    },
    {
     "Action":"ec2:DeleteRouteTable",
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/managedByFIS":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:route-table/*",
      "arn:aws:ec2:*:*:vpc/*"
     ],
     "Sid":"DeleteRouteTable"
    },
    {
     "Action":"ec2:CreateRoute",
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/managedByFIS":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:route-table/*",
     "Sid":"CreateRoute"
    },
    {
     "Action":"ec2:CreateNetworkInterface",
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/managedByFIS":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*",
     "Sid":"CreateNetworkInterface"
    },
    {
     "Action":"ec2:CreateNetworkInterface",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:security-group/*"
     ],
     "Sid":"CreateNetworkInterfaceOnSubnet"
    },
    {
     "Action":"ec2:DeleteNetworkInterface",
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/managedByFIS":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*",
     "Sid":"DeleteNetworkInterface"
    },
    {
     "Action":"ec2:CreateManagedPrefixList",
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/managedByFIS":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:prefix-list/*",
     "Sid":"CreateManagedPrefixList"
    },
    {
     "Action":"ec2:DeleteManagedPrefixList",
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/managedByFIS":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:prefix-list/*",
     "Sid":"DeleteManagedPrefixList"
    },
    {
     "Action":"ec2:ModifyManagedPrefixList",
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/managedByFIS":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:prefix-list/*",
     "Sid":"ModifyManagedPrefixList"
    },
    {
     "Action":"ec2:ReplaceRouteTableAssociation",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:route-table/*"
     ],
     "Sid":"ReplaceRouteTableAssociation"
    },
    {
     "Action":"ec2:AssociateRouteTable",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:route-table/*"
     ],
     "Sid":"AssociateRouteTable"
    },
    {
     "Action":"ec2:DisassociateRouteTable",
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/managedByFIS":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:route-table/*"
     ],
     "Sid":"DisassociateRouteTable"
    },
    {
     "Action":"ec2:DisassociateRouteTable",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*"
     ],
     "Sid":"DisassociateRouteTableOnSubnet"
    },
    {
     "Action":"ec2:ModifyVpcEndpoint",
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/managedByFIS":"true"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:route-table/*"
     ],
     "Sid":"ModifyVpcEndpointOnRouteTable"
    },
    {
     "Action":"ec2:ModifyVpcEndpoint",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:vpc-endpoint/*"
     ],
     "Sid":"ModifyVpcEndpoint"
    },
    {
     "Action":[
      "ec2:DisassociateTransitGatewayRouteTable",
      "ec2:AssociateTransitGatewayRouteTable"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:transit-gateway-route-table/*",
      "arn:aws:ec2:*:*:transit-gateway-attachment/*"
     ],
     "Sid":"TransitGatewayRouteTableAssociation"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-01-25T16:07:44+00:00"
 },
 "AWSFaultInjectionSimulatorRDSAccess":{
  "CreateDate":"2022-10-26T20:30:57+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rds:FailoverDBCluster"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:cluster:*"
     ],
     "Sid":"AllowFailover"
    },
    {
     "Action":[
      "rds:RebootDBInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:rds:*:*:db:*"
     ],
     "Sid":"AllowReboot"
    },
    {
     "Action":[
      "rds:DescribeDBClusters",
      "rds:DescribeDBInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribeResources"
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"TargetResolutionByTags"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-13T16:23:29+00:00"
 },
 "AWSFaultInjectionSimulatorSSMAccess":{
  "CreateDate":"2022-10-26T15:33:44+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*"
    },
    {
     "Action":[
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:automation-definition/*:*"
     ]
    },
    {
     "Action":[
      "ssm:GetAutomationExecution",
      "ssm:StopAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:automation-execution/*"
     ]
    },
    {
     "Action":"ssm:SendCommand",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ssm:*:*:document/*"
     ]
    },
    {
     "Action":[
      "ssm:ListCommands",
      "ssm:CancelCommand"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-06-02T22:55:18+00:00"
 },
 "AWSFinSpaceServiceRolePolicy":{
  "CreateDate":"2023-05-12T16:42:03+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"cloudwatch:PutMetricData",
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":[
        "AWS/FinSpace",
        "AWS/Usage"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSFinSpaceServiceRolePolicy"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-12-01T21:05:00+00:00"
 },
 "AWSForWordPressPluginPolicy":{
  "CreateDate":"2019-10-30T00:27:46+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "polly:SynthesizeSpeech",
      "polly:DescribeVoices",
      "translate:TranslateText"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Permissions1"
    },
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetBucketAcl",
      "s3:GetBucketPolicy",
      "s3:PutObject",
      "s3:DeleteObject",
      "s3:CreateBucket",
      "s3:PutObjectAcl"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::audio_for_wordpress*",
      "arn:aws:s3:::audio-for-wordpress*"
     ],
     "Sid":"Permissions2"
    },
    {
     "Action":[
      "acm:AddTagsToCertificate",
      "acm:DescribeCertificate",
      "acm:RequestCertificate",
      "cloudformation:CreateStack",
      "cloudfront:ListDistributions"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestedRegion":"us-east-1"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Permissions3"
    },
    {
     "Action":[
      "acm:DeleteCertificate",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStackResources",
      "cloudformation:UpdateStack",
      "cloudfront:CreateDistribution",
      "cloudfront:CreateInvalidation",
      "cloudfront:DeleteDistribution",
      "cloudfront:GetDistribution",
      "cloudfront:GetInvalidation",
      "cloudfront:TagResource",
      "cloudfront:UpdateDistribution"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/createdBy":"AWSForWordPressPlugin"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Permissions4"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-01-20T23:20:47+00:00"
 },
 "AWSGitSyncServiceRolePolicy":{
  "CreateDate":"2023-11-16T17:05:42+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codestar-connections:UseConnection",
      "codeconnections:UseConnection"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:codestar-connections:*:*:connection/*",
      "arn:aws:codeconnections:*:*:connection/*"
     ],
     "Sid":"AccessGitRepos"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-26T18:12:31+00:00"
 },
 "AWSGlobalAcceleratorSLRPolicy":{
  "CreateDate":"2019-04-05T19:39:13+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeInstances",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeSubnets",
      "ec2:DescribeRegions",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeAddresses"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2Action1"
    },
    {
     "Action":[
      "ec2:DeleteSecurityGroup",
      "ec2:AssignIpv6Addresses",
      "ec2:UnassignIpv6Addresses"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/AWSServiceName":"GlobalAccelerator"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2Action2"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup",
      "ec2:DescribeSecurityGroups"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2Action3"
    },
    {
     "Action":[
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeTargetGroups"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ElbAction1"
    },
    {
     "Action":"ec2:CreateTags",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:network-interface/*"
     ],
     "Sid":"EC2Action4"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-09-12T16:45:28+00:00"
 },
 "AWSGlueConsoleFullAccess":{
  "CreateDate":"2017-08-14T13:37:39+00:00",
  "DefaultVersionId":"v14",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:*",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSubnetGroups",
      "iam:ListRoles",
      "iam:ListUsers",
      "iam:ListGroups",
      "iam:ListRolePolicies",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:ListAttachedRolePolicies",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeRouteTables",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeInstances",
      "ec2:DescribeImages",
      "rds:DescribeDBInstances",
      "rds:DescribeDBClusters",
      "rds:DescribeDBSubnetGroups",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "s3:GetBucketAcl",
      "s3:GetBucketLocation",
      "cloudformation:ListStacks",
      "cloudformation:DescribeStacks",
      "cloudformation:GetTemplateSummary",
      "dynamodb:ListTables",
      "kms:ListAliases",
      "kms:DescribeKey",
      "cloudwatch:GetMetricData",
      "cloudwatch:ListDashboards",
      "databrew:ListRecipes",
      "databrew:ListRecipeVersions",
      "databrew:DescribeRecipe"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"BaseAppPermissions"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-glue-*/*",
      "arn:aws:s3:::*/*aws-glue-*/*",
      "arn:aws:s3:::aws-glue-*"
     ]
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:CreateBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-glue-*"
     ]
    },
    {
     "Action":[
      "logs:GetLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:/aws-glue/*"
     ]
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/aws-glue*/*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:key-pair/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:volume/*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances",
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/aws:cloudformation:logical-id":"ZeppelinInstance"
      },
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":"arn:aws:cloudformation:*:*:stack/aws-glue-*/*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "glue.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSGlueServiceRole*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "ec2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSGlueServiceNotebookRole*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "glue.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSGlueServiceRole*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-07-14T14:37:54+00:00"
 },
 "AWSGlueConsoleSageMakerNotebookFullAccess":{
  "CreateDate":"2018-10-05T17:52:35+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:*",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSubnetGroups",
      "iam:ListRoles",
      "iam:ListRolePolicies",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:ListAttachedRolePolicies",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeRouteTables",
      "ec2:DescribeVpcAttribute",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeInstances",
      "ec2:DescribeImages",
      "ec2:CreateNetworkInterface",
      "ec2:AttachNetworkInterface",
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeNetworkInterfaces",
      "rds:DescribeDBInstances",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "s3:GetBucketAcl",
      "s3:GetBucketLocation",
      "cloudformation:DescribeStacks",
      "cloudformation:GetTemplateSummary",
      "dynamodb:ListTables",
      "kms:ListAliases",
      "kms:DescribeKey",
      "sagemaker:ListNotebookInstances",
      "cloudformation:ListStacks",
      "cloudwatch:GetMetricData",
      "cloudwatch:ListDashboards"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*/*aws-glue-*/*",
      "arn:aws:s3:::aws-glue-*"
     ]
    },
    {
     "Action":[
      "s3:CreateBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-glue-*"
     ]
    },
    {
     "Action":[
      "logs:GetLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:/aws-glue/*"
     ]
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/aws-glue*/*"
    },
    {
     "Action":[
      "sagemaker:CreatePresignedNotebookInstanceUrl",
      "sagemaker:CreateNotebookInstance",
      "sagemaker:DeleteNotebookInstance",
      "sagemaker:DescribeNotebookInstance",
      "sagemaker:StartNotebookInstance",
      "sagemaker:StopNotebookInstance",
      "sagemaker:UpdateNotebookInstance",
      "sagemaker:ListTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sagemaker:*:*:notebook-instance/aws-glue-*"
    },
    {
     "Action":[
      "sagemaker:DescribeNotebookInstanceLifecycleConfig",
      "sagemaker:CreateNotebookInstanceLifecycleConfig",
      "sagemaker:DeleteNotebookInstanceLifecycleConfig",
      "sagemaker:ListNotebookInstanceLifecycleConfigs"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sagemaker:*:*:notebook-instance-lifecycle-config/aws-glue-*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:key-pair/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:volume/*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances",
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/aws:cloudformation:logical-id":"ZeppelinInstance"
      },
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":"arn:aws:cloudformation:*:*:stack/aws-glue-*/*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Condition":{
      "ForAllValues:StringLike":{
       "aws:TagKeys":[
        "aws-glue-*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "glue.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSGlueServiceRole*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "ec2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSGlueServiceNotebookRole*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "sagemaker.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSGlueServiceSageMakerNotebookRole*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "glue.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/service-role/AWSGlueServiceRole*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-15T15:24:19+00:00"
 },
 "AWSGlueDataBrewServiceRole":{
  "CreateDate":"2020-12-04T21:26:50+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:GetDatabases",
      "glue:GetPartitions",
      "glue:GetTable",
      "glue:GetTables",
      "glue:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"GlueDataPermissions"
    },
    {
     "Action":[
      "glue:BatchGetCustomEntityTypes",
      "glue:GetCustomEntityType"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"GluePIIPermissions"
    },
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::databrew-public-datasets-*"
     ],
     "Sid":"S3PublicDatasetAccess"
    },
    {
     "Action":[
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeRouteTables",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcAttribute",
      "ec2:CreateNetworkInterface"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"EC2NetworkingPermissions"
    },
    {
     "Action":"ec2:DeleteNetworkInterface",
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/aws-glue-service-resource":"*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"EC2DeleteGlueNetworkInterfacePermissions"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws-glue-service-resource"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:security-group/*"
     ],
     "Sid":"EC2GlueTaggingPermissions"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws-glue-databrew/*"
     ],
     "Sid":"GlueDatabrewLogGroupPermissions"
    },
    {
     "Action":[
      "lakeformation:GetDataAccess"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LakeFormationPermissions"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:databrew!default-*",
     "Sid":"SecretsManagerPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-20T23:28:52+00:00"
 },
 "AWSGlueSchemaRegistryFullAccess":{
  "CreateDate":"2020-11-20T00:19:00+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:CreateRegistry",
      "glue:UpdateRegistry",
      "glue:DeleteRegistry",
      "glue:GetRegistry",
      "glue:ListRegistries",
      "glue:CreateSchema",
      "glue:UpdateSchema",
      "glue:DeleteSchema",
      "glue:GetSchema",
      "glue:ListSchemas",
      "glue:RegisterSchemaVersion",
      "glue:DeleteSchemaVersions",
      "glue:GetSchemaByDefinition",
      "glue:GetSchemaVersion",
      "glue:GetSchemaVersionsDiff",
      "glue:ListSchemaVersions",
      "glue:CheckSchemaVersionValidity",
      "glue:PutSchemaVersionMetadata",
      "glue:RemoveSchemaVersionMetadata",
      "glue:QuerySchemaVersionMetadata"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AWSGlueSchemaRegistryFullAccess"
    },
    {
     "Action":[
      "glue:GetTags",
      "glue:TagResource",
      "glue:UnTagResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:glue:*:*:schema/*",
      "arn:aws:glue:*:*:registry/*"
     ],
     "Sid":"AWSGlueSchemaRegistryTagsFullAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-20T00:19:00+00:00"
 },
 "AWSGlueSchemaRegistryReadonlyAccess":{
  "CreateDate":"2020-11-20T00:20:06+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:GetRegistry",
      "glue:ListRegistries",
      "glue:GetSchema",
      "glue:ListSchemas",
      "glue:GetSchemaByDefinition",
      "glue:GetSchemaVersion",
      "glue:ListSchemaVersions",
      "glue:GetSchemaVersionsDiff",
      "glue:CheckSchemaVersionValidity",
      "glue:QuerySchemaVersionMetadata",
      "glue:GetTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AWSGlueSchemaRegistryReadonlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-20T00:20:06+00:00"
 },
 "AWSGlueServiceNotebookRole":{
  "CreateDate":"2017-08-14T13:37:42+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:CreateDatabase",
      "glue:CreatePartition",
      "glue:CreateTable",
      "glue:DeleteDatabase",
      "glue:DeletePartition",
      "glue:DeleteTable",
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:GetTable",
      "glue:GetTableVersions",
      "glue:GetTables",
      "glue:UpdateDatabase",
      "glue:UpdatePartition",
      "glue:UpdateTable",
      "glue:CreateConnection",
      "glue:CreateJob",
      "glue:DeleteConnection",
      "glue:DeleteJob",
      "glue:GetConnection",
      "glue:GetConnections",
      "glue:GetDevEndpoint",
      "glue:GetDevEndpoints",
      "glue:GetJob",
      "glue:GetJobs",
      "glue:UpdateJob",
      "glue:BatchDeleteConnection",
      "glue:UpdateConnection",
      "glue:GetUserDefinedFunction",
      "glue:UpdateUserDefinedFunction",
      "glue:GetUserDefinedFunctions",
      "glue:DeleteUserDefinedFunction",
      "glue:CreateUserDefinedFunction",
      "glue:BatchGetPartition",
      "glue:BatchDeletePartition",
      "glue:BatchCreatePartition",
      "glue:BatchDeleteTable",
      "glue:UpdateDevEndpoint",
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListAllMyBuckets",
      "s3:GetBucketAcl",
      "codewhisperer:GenerateRecommendations"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::crawler-public*",
      "arn:aws:s3:::aws-glue*"
     ]
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:DeleteObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-glue*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws-glue-service-resource"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-10-09T15:59:41+00:00"
 },
 "AWSGlueServiceRole":{
  "CreateDate":"2017-08-14T13:37:21+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "glue:*",
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListAllMyBuckets",
      "s3:GetBucketAcl",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeRouteTables",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcAttribute",
      "iam:ListRolePolicies",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "cloudwatch:PutMetricData"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:CreateBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-glue-*"
     ]
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject",
      "s3:DeleteObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-glue-*/*",
      "arn:aws:s3:::*/*aws-glue-*/*"
     ]
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::crawler-public*",
      "arn:aws:s3:::aws-glue-*"
     ]
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:*:/aws-glue/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws-glue-service-resource"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-09-11T16:39:47+00:00"
 },
 "AWSGrafanaAccountAdministrator":{
  "CreateDate":"2021-02-23T00:20:38+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSGrafanaOrganizationAdmin"
    },
    {
     "Action":"iam:GetRole",
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*",
     "Sid":"GrafanaIAMGetRolePermission"
    },
    {
     "Action":[
      "grafana:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSGrafanaPermissions"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"grafana.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*",
     "Sid":"GrafanaIAMPassRolePermission"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-15T22:36:18+00:00"
 },
 "AWSGrafanaConsoleReadOnlyAccess":{
  "CreateDate":"2021-02-23T00:10:40+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "grafana:Describe*",
      "grafana:List*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSGrafanaConsoleReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-02-15T22:30:54+00:00"
 },
 "AWSGrafanaWorkspacePermissionManagement":{
  "CreateDate":"2021-02-23T00:15:54+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "grafana:DescribeWorkspace",
      "grafana:DescribeWorkspaceAuthentication",
      "grafana:UpdatePermissions",
      "grafana:ListPermissions",
      "grafana:ListWorkspaces"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:grafana:*:*:/workspaces*",
     "Sid":"AWSGrafanaPermissions"
    },
    {
     "Action":[
      "sso:DescribeRegisteredRegions",
      "sso:GetSharedSsoConfiguration",
      "sso:ListDirectoryAssociations",
      "sso:GetManagedApplicationInstance",
      "sso:ListProfiles",
      "sso:AssociateProfile",
      "sso:DisassociateProfile",
      "sso:GetProfile",
      "sso:ListProfileAssociations",
      "sso-directory:DescribeUser",
      "sso-directory:DescribeGroup"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMIdentityCenterPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-15T22:17:26+00:00"
 },
 "AWSGrafanaWorkspacePermissionManagementV2":{
  "CreateDate":"2024-01-05T18:39:46+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "grafana:DescribeWorkspace",
      "grafana:DescribeWorkspaceAuthentication",
      "grafana:UpdatePermissions",
      "grafana:ListPermissions",
      "grafana:ListWorkspaces"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:grafana:*:*:/workspaces*",
     "Sid":"AWSGrafanaPermissions"
    },
    {
     "Action":[
      "sso:DescribeRegisteredRegions",
      "sso:GetSharedSsoConfiguration",
      "sso:ListDirectoryAssociations",
      "sso:GetManagedApplicationInstance",
      "sso:ListProfiles",
      "sso:GetProfile",
      "sso:ListProfileAssociations",
      "sso-directory:DescribeUser",
      "sso-directory:DescribeGroup"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMIdentityCenterPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-01-05T18:39:46+00:00"
 },
 "AWSGreengrassFullAccess":{
  "CreateDate":"2017-05-03T00:47:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "greengrass:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-05-03T00:47:37+00:00"
 },
 "AWSGreengrassReadOnlyAccess":{
  "CreateDate":"2018-10-30T16:01:43+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "greengrass:List*",
      "greengrass:Get*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-10-30T16:01:43+00:00"
 },
 "AWSGreengrassResourceAccessRolePolicy":{
  "CreateDate":"2017-02-14T21:17:24+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:DeleteThingShadow",
      "iot:GetThingShadow",
      "iot:UpdateThingShadow"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/GG_*",
      "arn:aws:iot:*:*:thing/*-gcm",
      "arn:aws:iot:*:*:thing/*-gda",
      "arn:aws:iot:*:*:thing/*-gci"
     ],
     "Sid":"AllowGreengrassAccessToShadows"
    },
    {
     "Action":[
      "iot:DescribeThing"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iot:*:*:thing/*",
     "Sid":"AllowGreengrassToDescribeThings"
    },
    {
     "Action":[
      "iot:DescribeCertificate"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iot:*:*:cert/*",
     "Sid":"AllowGreengrassToDescribeCertificates"
    },
    {
     "Action":[
      "greengrass:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowGreengrassToCallGreengrassServices"
    },
    {
     "Action":[
      "lambda:GetFunction",
      "lambda:GetFunctionConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowGreengrassToGetLambdaFunctions"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:greengrass-*",
     "Sid":"AllowGreengrassToGetGreengrassSecrets"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*Greengrass*",
      "arn:aws:s3:::*GreenGrass*",
      "arn:aws:s3:::*greengrass*",
      "arn:aws:s3:::*Sagemaker*",
      "arn:aws:s3:::*SageMaker*",
      "arn:aws:s3:::*sagemaker*"
     ],
     "Sid":"AllowGreengrassAccessToS3Objects"
    },
    {
     "Action":[
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowGreengrassAccessToS3BucketLocation"
    },
    {
     "Action":[
      "sagemaker:DescribeTrainingJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sagemaker:*:*:training-job/*"
     ],
     "Sid":"AllowGreengrassAccessToSageMakerTrainingJobs"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-14T00:35:02+00:00"
 },
 "AWSGroundStationAgentInstancePolicy":{
  "CreateDate":"2023-03-29T15:23:12+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "groundstation:RegisterAgent",
      "groundstation:UpdateAgentStatus",
      "groundstation:GetAgentConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-29T15:23:12+00:00"
 },
 "AWSHealthFullAccess":{
  "CreateDate":"2016-12-06T12:30:31+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:EnableAWSServiceAccess",
      "organizations:DisableAWSServiceAccess"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":"health.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "health:*",
      "organizations:ListAccounts",
      "organizations:ListParents",
      "organizations:DescribeAccount",
      "organizations:ListDelegatedAdministrators"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"health.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-16T18:11:34+00:00"
 },
 "AWSHealthImagingFullAccess":{
  "CreateDate":"2023-07-25T23:39:40+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "medical-imaging:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"medical-imaging.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-07-25T23:39:40+00:00"
 },
 "AWSHealthImagingReadOnlyAccess":{
  "CreateDate":"2023-07-25T23:40:40+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "medical-imaging:GetDICOMImportJob",
      "medical-imaging:GetDatastore",
      "medical-imaging:GetImageFrame",
      "medical-imaging:GetImageSet",
      "medical-imaging:GetImageSetMetadata",
      "medical-imaging:ListDICOMImportJobs",
      "medical-imaging:ListDatastores",
      "medical-imaging:ListImageSetVersions",
      "medical-imaging:ListTagsForResource",
      "medical-imaging:SearchImageSets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-08-01T15:18:49+00:00"
 },
 "AWSHealth_EventProcessorServiceRolePolicy":{
  "CreateDate":"2023-01-13T19:24:56+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "events:DeleteRule",
      "events:PutTargets",
      "events:PutRule",
      "events:RemoveTargets"
     ],
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"event-processor.health.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "events:DescribeRule",
      "events:ListTargetsByRule"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-01-13T19:24:56+00:00"
 },
 "AWSIAMIdentityCenterAllowListForIdentityContext":{
  "CreateDate":"2023-11-08T15:21:33+00:00",
  "DefaultVersionId":"v11",
  "Document":{
   "Statement":[
    {
     "Effect":"Deny",
     "NotAction":[
      "aoss:APIAccessAll",
      "athena:BatchGetNamedQuery",
      "athena:BatchGetPreparedStatement",
      "athena:BatchGetQueryExecution",
      "athena:CreateNamedQuery",
      "athena:CreatePreparedStatement",
      "athena:DeleteNamedQuery",
      "athena:DeletePreparedStatement",
      "athena:GetNamedQuery",
      "athena:GetPreparedStatement",
      "athena:GetQueryExecution",
      "athena:GetQueryResults",
      "athena:GetQueryResultsStream",
      "athena:GetQueryRuntimeStatistics",
      "athena:GetWorkGroup",
      "athena:ListNamedQueries",
      "athena:ListPreparedStatements",
      "athena:ListQueryExecutions",
      "athena:StartQueryExecution",
      "athena:StopQueryExecution",
      "athena:UpdateNamedQuery",
      "athena:UpdatePreparedStatement",
      "athena:GetDatabase",
      "athena:GetDataCatalog",
      "athena:GetTableMetadata",
      "athena:ListDatabases",
      "athena:ListDataCatalogs",
      "athena:ListTableMetadata",
      "athena:ListWorkGroups",
      "elasticmapreduce:GetClusterSessionCredentials",
      "elasticmapreduce:AddJobFlowSteps",
      "elasticmapreduce:DescribeCluster",
      "elasticmapreduce:CancelSteps",
      "elasticmapreduce:DescribeStep",
      "elasticmapreduce:ListSteps",
      "es:ESHttpHead",
      "es:ESHttpPost",
      "es:ESHttpGet",
      "es:ESHttpPatch",
      "es:ESHttpDelete",
      "es:ESHttpPut",
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:GetTable",
      "glue:GetTables",
      "glue:GetTableVersions",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:BatchGetPartition",
      "glue:GetColumnStatisticsForPartition",
      "glue:GetColumnStatisticsForTable",
      "glue:SearchTables",
      "glue:CreateDatabase",
      "glue:UpdateDatabase",
      "glue:DeleteDatabase",
      "glue:CreateTable",
      "glue:DeleteTable",
      "glue:BatchDeleteTable",
      "glue:UpdateTable",
      "glue:BatchCreatePartition",
      "glue:CreatePartition",
      "glue:DeletePartition",
      "glue:BatchDeletePartition",
      "glue:UpdatePartition",
      "glue:BatchUpdatePartition",
      "glue:DeleteColumnStatisticsForPartition",
      "glue:DeleteColumnStatisticsForTable",
      "glue:UpdateColumnStatisticsForPartition",
      "glue:UpdateColumnStatisticsForTable",
      "lakeformation:GetDataAccess",
      "s3:GetAccessGrantsInstanceForPrefix",
      "s3:GetDataAccess",
      "s3:ListCallerAccessGrants",
      "q:StartConversation",
      "q:SendMessage",
      "q:ListConversations",
      "q:GetConversation",
      "q:StartTroubleshootingAnalysis",
      "q:GetTroubleshootingResults",
      "q:StartTroubleshootingResolutionExplanation",
      "q:UpdateTroubleshootingCommandResult",
      "qapps:CreateQApp",
      "qapps:PredictProblemStatementFromConversation",
      "qapps:PredictQAppFromProblemStatement",
      "qapps:CopyQApp",
      "qapps:GetQApp",
      "qapps:ListQApps",
      "qapps:UpdateQApp",
      "qapps:DeleteQApp",
      "qapps:AssociateQAppWithUser",
      "qapps:DisassociateQAppFromUser",
      "qapps:ImportDocumentToQApp",
      "qapps:ImportDocumentToQAppSession",
      "qapps:CreateLibraryItem",
      "qapps:GetLibraryItem",
      "qapps:UpdateLibraryItem",
      "qapps:CreateLibraryItemReview",
      "qapps:ListLibraryItems",
      "qapps:CreateSubscriptionToken",
      "qapps:StartQAppSession",
      "qapps:StopQAppSession",
      "qapps:PredictQApp",
      "qapps:ImportDocument",
      "qapps:AssociateLibraryItemReview",
      "qapps:DisassociateLibraryItemReview",
      "qapps:GetQAppSession",
      "qapps:UpdateQAppSession",
      "qapps:GetQAppSessionMetadata",
      "qapps:UpdateQAppSessionMetadata",
      "qapps:TagResource",
      "qbusiness:Chat",
      "qbusiness:ChatSync",
      "qbusiness:ListConversations",
      "qbusiness:ListMessages",
      "qbusiness:DeleteConversation",
      "qbusiness:PutFeedback",
      "sts:SetContext"
     ],
     "Resource":"*",
     "Sid":"TrustedIdentityPropagation"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-09-04T19:52:35+00:00"
 },
 "AWSIPAMServiceRolePolicy":{
  "CreateDate":"2021-11-30T19:08:11+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeByoipCidrs",
      "ec2:DescribeIpv6Pools",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribePublicIpv4Pools",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSecurityGroupRules",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeVpnConnections",
      "ec2:GetIpamDiscoveredAccounts",
      "ec2:GetIpamDiscoveredPublicAddresses",
      "ec2:GetIpamDiscoveredResourceCidrs",
      "globalaccelerator:ListAccelerators",
      "globalaccelerator:ListByoipCidrs",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:ListDelegatedAdministrators"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IPAMDiscoveryDescribeActions"
    },
    {
     "Action":"cloudwatch:PutMetricData",
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"AWS/IPAM"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudWatchMetricsPublishActions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-08T19:05:45+00:00"
 },
 "AWSIQContractServiceRolePolicy":{
  "CreateDate":"2019-08-22T19:28:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:Subscribe"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-22T19:28:39+00:00"
 },
 "AWSIQFullAccess":{
  "CreateDate":"2019-04-04T23:13:42+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iq:*",
      "iq-permission:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "permission.iq.amazonaws.com",
        "contract.iq.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-25T20:22:34+00:00"
 },
 "AWSIQPermissionServiceRolePolicy":{
  "CreateDate":"2019-08-22T19:36:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:DeleteRole",
      "iam:ListAttachedRolePolicies"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSIQPermission-*"
    },
    {
     "Action":[
      "iam:AttachRolePolicy"
     ],
     "Condition":{
      "ArnEquals":{
       "iam:PolicyARN":"arn:aws:iam::aws:policy/AWSDenyAll"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSIQPermission-*"
    },
    {
     "Action":[
      "iam:DetachRolePolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/AWSIQPermission-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-22T19:36:29+00:00"
 },
 "AWSIdentitySyncFullAccess":{
  "CreateDate":"2022-03-23T23:29:33+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:AuthorizeApplication",
      "ds:UnauthorizeApplication"
     ],
     "Effect":"Allow",
     "Resource":"arn:*:ds:*:*:*/*"
    },
    {
     "Action":[
      "identity-sync:DeleteSyncProfile",
      "identity-sync:CreateSyncProfile",
      "identity-sync:GetSyncProfile",
      "identity-sync:StartSync",
      "identity-sync:StopSync",
      "identity-sync:CreateSyncFilter",
      "identity-sync:DeleteSyncFilter",
      "identity-sync:ListSyncFilters",
      "identity-sync:CreateSyncTarget",
      "identity-sync:DeleteSyncTarget",
      "identity-sync:GetSyncTarget",
      "identity-sync:UpdateSyncTarget"
     ],
     "Effect":"Allow",
     "Resource":"arn:*:identity-sync:*:*:*/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-23T23:29:33+00:00"
 },
 "AWSIdentitySyncReadOnlyAccess":{
  "CreateDate":"2022-03-23T23:29:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "identity-sync:GetSyncProfile",
      "identity-sync:ListSyncFilters",
      "identity-sync:GetSyncTarget"
     ],
     "Effect":"Allow",
     "Resource":"arn:*:identity-sync:*:*:*/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-23T23:29:52+00:00"
 },
 "AWSImageBuilderFullAccess":{
  "CreateDate":"2019-12-20T18:25:12+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "imagebuilder:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:*imagebuilder*"
    },
    {
     "Action":[
      "license-manager:ListLicenseConfigurations",
      "license-manager:ListLicenseSpecificationsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/imagebuilder.amazonaws.com/AWSServiceRoleForImageBuilder"
    },
    {
     "Action":[
      "iam:GetInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:instance-profile/*imagebuilder*"
    },
    {
     "Action":[
      "iam:ListInstanceProfiles",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:instance-profile/*imagebuilder*",
      "arn:aws:iam::*:role/*imagebuilder*"
     ]
    },
    {
     "Action":[
      "s3:ListAllMyBuckets",
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3::*:*imagebuilder*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"imagebuilder.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/imagebuilder.amazonaws.com/AWSServiceRoleForImageBuilder"
    },
    {
     "Action":[
      "ec2:DescribeImages",
      "ec2:DescribeSnapshots",
      "ec2:DescribeVpcs",
      "ec2:DescribeRegions",
      "ec2:DescribeVolumes",
      "ec2:DescribeSubnets",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeInstanceTypeOfferings",
      "ec2:DescribeLaunchTemplates"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-13T17:33:42+00:00"
 },
 "AWSImageBuilderReadOnlyAccess":{
  "CreateDate":"2019-12-19T22:29:23+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "imagebuilder:Get*",
      "imagebuilder:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/imagebuilder.amazonaws.com/AWSServiceRoleForImageBuilder"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-19T22:29:23+00:00"
 },
 "AWSImportExportFullAccess":{
  "CreateDate":"2015-02-06T18:40:43+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "importexport:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:40:43+00:00"
 },
 "AWSImportExportReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:40:42+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "importexport:ListJobs",
      "importexport:GetStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:40:42+00:00"
 },
 "AWSIncidentManagerIncidentAccessServiceRolePolicy":{
  "CreateDate":"2023-11-13T00:01:23+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStackResources",
      "codedeploy:BatchGetDeployments",
      "codedeploy:ListDeployments",
      "codedeploy:ListDeploymentTargets",
      "autoscaling:DescribeAutoScalingInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IncidentAccessPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-02-20T23:02:11+00:00"
 },
 "AWSIncidentManagerResolverAccess":{
  "CreateDate":"2021-05-10T06:12:34+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm-incidents:StartIncident"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"StartIncidentPermissions"
    },
    {
     "Action":[
      "ssm-incidents:ListResponsePlans",
      "ssm-incidents:GetResponsePlan"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ResponsePlanReadOnlyPermissions"
    },
    {
     "Action":[
      "ssm-incidents:ListIncidentRecords",
      "ssm-incidents:GetIncidentRecord",
      "ssm-incidents:UpdateIncidentRecord",
      "ssm-incidents:ListTimelineEvents",
      "ssm-incidents:CreateTimelineEvent",
      "ssm-incidents:GetTimelineEvent",
      "ssm-incidents:UpdateTimelineEvent",
      "ssm-incidents:DeleteTimelineEvent",
      "ssm-incidents:ListRelatedItems",
      "ssm-incidents:UpdateRelatedItems"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IncidentRecordResolverPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-05-10T06:12:34+00:00"
 },
 "AWSIncidentManagerServiceRolePolicy":{
  "CreateDate":"2021-05-10T03:34:45+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm-incidents:ListIncidentRecords",
      "ssm-incidents:CreateTimelineEvent"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"UpdateIncidentRecordPermissions"
    },
    {
     "Action":[
      "ssm:CreateOpsItem",
      "ssm:AssociateOpsItemRelatedItem"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RelatedOpsItemPermissions"
    },
    {
     "Action":"ssm-contacts:StartEngagement",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IncidentEngagementPermissions"
    },
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"AWS/IncidentManager"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PutMetricDataPermission"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-12-05T02:11:58+00:00"
 },
 "AWSIoT1ClickFullAccess":{
  "CreateDate":"2018-05-11T22:10:14+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot1click:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-05-11T22:10:14+00:00"
 },
 "AWSIoT1ClickReadOnlyAccess":{
  "CreateDate":"2018-05-11T21:49:24+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot1click:Describe*",
      "iot1click:Get*",
      "iot1click:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-05-11T21:49:24+00:00"
 },
 "AWSIoTAnalyticsFullAccess":{
  "CreateDate":"2018-06-18T23:02:45+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotanalytics:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-06-18T23:02:45+00:00"
 },
 "AWSIoTAnalyticsReadOnlyAccess":{
  "CreateDate":"2018-06-18T21:37:49+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotanalytics:Describe*",
      "iotanalytics:List*",
      "iotanalytics:Get*",
      "iotanalytics:SampleChannelData"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-06-18T21:37:49+00:00"
 },
 "AWSIoTConfigAccess":{
  "CreateDate":"2015-10-27T21:52:07+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:AcceptCertificateTransfer",
      "iot:AddThingToThingGroup",
      "iot:AssociateTargetsWithJob",
      "iot:AttachPolicy",
      "iot:AttachPrincipalPolicy",
      "iot:AttachThingPrincipal",
      "iot:CancelCertificateTransfer",
      "iot:CancelJob",
      "iot:CancelJobExecution",
      "iot:ClearDefaultAuthorizer",
      "iot:CreateAuthorizer",
      "iot:CreateCertificateFromCsr",
      "iot:CreateJob",
      "iot:CreateKeysAndCertificate",
      "iot:CreateOTAUpdate",
      "iot:CreatePolicy",
      "iot:CreatePolicyVersion",
      "iot:CreateRoleAlias",
      "iot:CreateStream",
      "iot:CreateThing",
      "iot:CreateThingGroup",
      "iot:CreateThingType",
      "iot:CreateTopicRule",
      "iot:DeleteAuthorizer",
      "iot:DeleteCACertificate",
      "iot:DeleteCertificate",
      "iot:DeleteJob",
      "iot:DeleteJobExecution",
      "iot:DeleteOTAUpdate",
      "iot:DeletePolicy",
      "iot:DeletePolicyVersion",
      "iot:DeleteRegistrationCode",
      "iot:DeleteRoleAlias",
      "iot:DeleteStream",
      "iot:DeleteThing",
      "iot:DeleteThingGroup",
      "iot:DeleteThingType",
      "iot:DeleteTopicRule",
      "iot:DeleteV2LoggingLevel",
      "iot:DeprecateThingType",
      "iot:DescribeAuthorizer",
      "iot:DescribeCACertificate",
      "iot:DescribeCertificate",
      "iot:DescribeDefaultAuthorizer",
      "iot:DescribeEndpoint",
      "iot:DescribeEventConfigurations",
      "iot:DescribeIndex",
      "iot:DescribeJob",
      "iot:DescribeJobExecution",
      "iot:DescribeRoleAlias",
      "iot:DescribeStream",
      "iot:DescribeThing",
      "iot:DescribeThingGroup",
      "iot:DescribeThingRegistrationTask",
      "iot:DescribeThingType",
      "iot:DetachPolicy",
      "iot:DetachPrincipalPolicy",
      "iot:DetachThingPrincipal",
      "iot:DisableTopicRule",
      "iot:EnableTopicRule",
      "iot:GetEffectivePolicies",
      "iot:GetIndexingConfiguration",
      "iot:GetJobDocument",
      "iot:GetLoggingOptions",
      "iot:GetOTAUpdate",
      "iot:GetPolicy",
      "iot:GetPolicyVersion",
      "iot:GetRegistrationCode",
      "iot:GetTopicRule",
      "iot:GetV2LoggingOptions",
      "iot:ListAttachedPolicies",
      "iot:ListAuthorizers",
      "iot:ListCACertificates",
      "iot:ListCertificates",
      "iot:ListCertificatesByCA",
      "iot:ListIndices",
      "iot:ListJobExecutionsForJob",
      "iot:ListJobExecutionsForThing",
      "iot:ListJobs",
      "iot:ListOTAUpdates",
      "iot:ListOutgoingCertificates",
      "iot:ListPolicies",
      "iot:ListPolicyPrincipals",
      "iot:ListPolicyVersions",
      "iot:ListPrincipalPolicies",
      "iot:ListPrincipalThings",
      "iot:ListRoleAliases",
      "iot:ListStreams",
      "iot:ListTargetsForPolicy",
      "iot:ListThingGroups",
      "iot:ListThingGroupsForThing",
      "iot:ListThingPrincipals",
      "iot:ListThingRegistrationTaskReports",
      "iot:ListThingRegistrationTasks",
      "iot:ListThings",
      "iot:ListThingsInThingGroup",
      "iot:ListThingTypes",
      "iot:ListTopicRules",
      "iot:ListV2LoggingLevels",
      "iot:RegisterCACertificate",
      "iot:RegisterCertificate",
      "iot:RegisterThing",
      "iot:RejectCertificateTransfer",
      "iot:RemoveThingFromThingGroup",
      "iot:ReplaceTopicRule",
      "iot:SearchIndex",
      "iot:SetDefaultAuthorizer",
      "iot:SetDefaultPolicyVersion",
      "iot:SetLoggingOptions",
      "iot:SetV2LoggingLevel",
      "iot:SetV2LoggingOptions",
      "iot:StartThingRegistrationTask",
      "iot:StopThingRegistrationTask",
      "iot:TestAuthorization",
      "iot:TestInvokeAuthorizer",
      "iot:TransferCertificate",
      "iot:UpdateAuthorizer",
      "iot:UpdateCACertificate",
      "iot:UpdateCertificate",
      "iot:UpdateEventConfigurations",
      "iot:UpdateIndexingConfiguration",
      "iot:UpdateRoleAlias",
      "iot:UpdateStream",
      "iot:UpdateThing",
      "iot:UpdateThingGroup",
      "iot:UpdateThingGroupsForThing",
      "iot:UpdateAccountAuditConfiguration",
      "iot:DescribeAccountAuditConfiguration",
      "iot:DeleteAccountAuditConfiguration",
      "iot:StartOnDemandAuditTask",
      "iot:CancelAuditTask",
      "iot:DescribeAuditTask",
      "iot:ListAuditTasks",
      "iot:CreateScheduledAudit",
      "iot:UpdateScheduledAudit",
      "iot:DeleteScheduledAudit",
      "iot:DescribeScheduledAudit",
      "iot:ListScheduledAudits",
      "iot:ListAuditFindings",
      "iot:CreateSecurityProfile",
      "iot:DescribeSecurityProfile",
      "iot:UpdateSecurityProfile",
      "iot:DeleteSecurityProfile",
      "iot:AttachSecurityProfile",
      "iot:DetachSecurityProfile",
      "iot:ListSecurityProfiles",
      "iot:ListSecurityProfilesForTarget",
      "iot:ListTargetsForSecurityProfile",
      "iot:ListActiveViolations",
      "iot:ListViolationEvents",
      "iot:ValidateSecurityProfileBehaviors"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-27T20:48:00+00:00"
 },
 "AWSIoTConfigReadOnlyAccess":{
  "CreateDate":"2015-10-27T21:52:31+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:DescribeAuthorizer",
      "iot:DescribeCACertificate",
      "iot:DescribeCertificate",
      "iot:DescribeDefaultAuthorizer",
      "iot:DescribeEndpoint",
      "iot:DescribeEventConfigurations",
      "iot:DescribeIndex",
      "iot:DescribeJob",
      "iot:DescribeJobExecution",
      "iot:DescribeRoleAlias",
      "iot:DescribeStream",
      "iot:DescribeThing",
      "iot:DescribeThingGroup",
      "iot:DescribeThingRegistrationTask",
      "iot:DescribeThingType",
      "iot:GetEffectivePolicies",
      "iot:GetIndexingConfiguration",
      "iot:GetJobDocument",
      "iot:GetLoggingOptions",
      "iot:GetOTAUpdate",
      "iot:GetPolicy",
      "iot:GetPolicyVersion",
      "iot:GetRegistrationCode",
      "iot:GetTopicRule",
      "iot:GetV2LoggingOptions",
      "iot:ListAttachedPolicies",
      "iot:ListAuthorizers",
      "iot:ListCACertificates",
      "iot:ListCertificates",
      "iot:ListCertificatesByCA",
      "iot:ListIndices",
      "iot:ListJobExecutionsForJob",
      "iot:ListJobExecutionsForThing",
      "iot:ListJobs",
      "iot:ListOTAUpdates",
      "iot:ListOutgoingCertificates",
      "iot:ListPolicies",
      "iot:ListPolicyPrincipals",
      "iot:ListPolicyVersions",
      "iot:ListPrincipalPolicies",
      "iot:ListPrincipalThings",
      "iot:ListRoleAliases",
      "iot:ListStreams",
      "iot:ListTargetsForPolicy",
      "iot:ListThingGroups",
      "iot:ListThingGroupsForThing",
      "iot:ListThingPrincipals",
      "iot:ListThingRegistrationTaskReports",
      "iot:ListThingRegistrationTasks",
      "iot:ListThings",
      "iot:ListThingsInThingGroup",
      "iot:ListThingTypes",
      "iot:ListTopicRules",
      "iot:ListV2LoggingLevels",
      "iot:SearchIndex",
      "iot:TestAuthorization",
      "iot:TestInvokeAuthorizer",
      "iot:DescribeAccountAuditConfiguration",
      "iot:DescribeAuditTask",
      "iot:ListAuditTasks",
      "iot:DescribeScheduledAudit",
      "iot:ListScheduledAudits",
      "iot:ListAuditFindings",
      "iot:DescribeSecurityProfile",
      "iot:ListSecurityProfiles",
      "iot:ListSecurityProfilesForTarget",
      "iot:ListTargetsForSecurityProfile",
      "iot:ListActiveViolations",
      "iot:ListViolationEvents",
      "iot:ValidateSecurityProfileBehaviors"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-27T20:52:40+00:00"
 },
 "AWSIoTDataAccess":{
  "CreateDate":"2015-10-27T21:51:18+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:Connect",
      "iot:Publish",
      "iot:Subscribe",
      "iot:Receive",
      "iot:GetThingShadow",
      "iot:UpdateThingShadow",
      "iot:DeleteThingShadow",
      "iot:ListNamedShadowsForThing"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-23T21:34:47+00:00"
 },
 "AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction":{
  "CreateDate":"2019-08-07T17:55:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:ListPrincipalThings",
      "iot:AddThingToThingGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-07T17:55:37+00:00"
 },
 "AWSIoTDeviceDefenderAudit":{
  "CreateDate":"2018-07-18T21:17:40+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:GetLoggingOptions",
      "iot:GetV2LoggingOptions",
      "iot:ListCACertificates",
      "iot:ListCertificates",
      "iot:DescribeCACertificate",
      "iot:DescribeCertificate",
      "iot:ListPolicies",
      "iot:GetPolicy",
      "iot:GetEffectivePolicies",
      "iot:ListRoleAliases",
      "iot:DescribeRoleAlias",
      "cognito-identity:GetIdentityPoolRoles",
      "iam:ListRolePolicies",
      "iam:ListAttachedRolePolicies",
      "iam:GetRole",
      "iam:GetPolicy",
      "iam:GetPolicyVersion",
      "iam:GetRolePolicy",
      "iam:GenerateServiceLastAccessedDetails",
      "iam:GetServiceLastAccessedDetails"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-25T23:52:43+00:00"
 },
 "AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction":{
  "CreateDate":"2019-08-07T17:04:07+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:SetV2LoggingOptions"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "iot.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-07T17:04:07+00:00"
 },
 "AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction":{
  "CreateDate":"2019-08-07T17:04:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-07T17:04:37+00:00"
 },
 "AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction":{
  "CreateDate":"2019-08-07T17:04:57+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:CreatePolicyVersion"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-07T17:04:57+00:00"
 },
 "AWSIoTDeviceDefenderUpdateCACertMitigationAction":{
  "CreateDate":"2019-08-07T17:05:49+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:UpdateCACertificate"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-07T17:05:49+00:00"
 },
 "AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction":{
  "CreateDate":"2019-08-07T17:06:00+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:UpdateCertificate"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-08-07T17:06:00+00:00"
 },
 "AWSIoTDeviceTesterForFreeRTOSFullAccess":{
  "CreateDate":"2020-02-12T20:33:53+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"iot.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/idt-*",
     "Sid":"VisualEditor0"
    },
    {
     "Action":[
      "iot:DeleteThing",
      "iot:AttachThingPrincipal",
      "iot:DeleteCertificate",
      "iot:GetRegistrationCode",
      "iot:CreatePolicy",
      "iot:UpdateCACertificate",
      "s3:ListBucket",
      "iot:DescribeEndpoint",
      "iot:CreateOTAUpdate",
      "iot:CreateStream",
      "signer:ListSigningJobs",
      "acm:ListCertificates",
      "iot:CreateKeysAndCertificate",
      "iot:UpdateCertificate",
      "iot:CreateCertificateFromCsr",
      "iot:DetachThingPrincipal",
      "iot:RegisterCACertificate",
      "iot:CreateThing",
      "iam:ListRoles",
      "iot:RegisterCertificate",
      "iot:DeleteCACertificate",
      "signer:PutSigningProfile",
      "s3:ListAllMyBuckets",
      "signer:ListSigningPlatforms",
      "iot-device-tester:SendMetrics",
      "iot-device-tester:SupportedVersion",
      "iot-device-tester:LatestIdt",
      "iot-device-tester:CheckVersion",
      "iot-device-tester:DownloadTestSuite"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor1"
    },
    {
     "Action":[
      "iam:GetRole",
      "signer:StartSigningJob",
      "acm:GetCertificate",
      "signer:DescribeSigningJob",
      "s3:CreateBucket",
      "execute-api:Invoke",
      "s3:DeleteBucket",
      "s3:PutBucketVersioning",
      "signer:CancelSigningProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:execute-api:us-east-1:098862408343:9xpmnvs5h4/prod/POST/metrics",
      "arn:aws:signer:*:*:/signing-profiles/*",
      "arn:aws:signer:*:*:/signing-jobs/*",
      "arn:aws:iam::*:role/idt-*",
      "arn:aws:acm:*:*:certificate/*",
      "arn:aws:s3:::idt-*",
      "arn:aws:s3:::afr-ota*"
     ],
     "Sid":"VisualEditor2"
    },
    {
     "Action":[
      "iot:DeleteStream",
      "iot:DeleteCertificate",
      "iot:AttachPolicy",
      "iot:DetachPolicy",
      "iot:DeletePolicy",
      "s3:ListBucketVersions",
      "iot:UpdateCertificate",
      "iot:GetOTAUpdate",
      "iot:DeleteOTAUpdate",
      "iot:DescribeJobExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::afr-ota*",
      "arn:aws:iot:*:*:thinggroup/idt*",
      "arn:aws:iam::*:role/idt-*"
     ],
     "Sid":"VisualEditor3"
    },
    {
     "Action":[
      "iot:DeleteCertificate",
      "iot:AttachPolicy",
      "iot:DetachPolicy",
      "s3:DeleteObjectVersion",
      "iot:DeleteOTAUpdate",
      "s3:PutObject",
      "s3:GetObject",
      "iot:DeleteStream",
      "iot:DeletePolicy",
      "s3:DeleteObject",
      "iot:UpdateCertificate",
      "iot:GetOTAUpdate",
      "s3:GetObjectVersion",
      "iot:DescribeJobExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::afr-ota*/*",
      "arn:aws:s3:::idt-*/*",
      "arn:aws:iot:*:*:policy/idt*",
      "arn:aws:iam::*:role/idt-*",
      "arn:aws:iot:*:*:otaupdate/idt*",
      "arn:aws:iot:*:*:thing/idt*",
      "arn:aws:iot:*:*:cert/*",
      "arn:aws:iot:*:*:job/*",
      "arn:aws:iot:*:*:stream/*"
     ],
     "Sid":"VisualEditor4"
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::afr-ota*/*",
      "arn:aws:s3:::idt-*/*"
     ],
     "Sid":"VisualEditor5"
    },
    {
     "Action":[
      "iot:CancelJobExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:job/*",
      "arn:aws:iot:*:*:thing/idt*"
     ],
     "Sid":"VisualEditor6"
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/Owner":"IoTDeviceTester"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"VisualEditor7"
    },
    {
     "Action":[
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:DeleteSecurityGroup"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/Owner":"IoTDeviceTester"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*"
     ],
     "Sid":"VisualEditor8"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/Owner":"IoTDeviceTester"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"VisualEditor9"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:key-pair/*",
      "arn:aws:ec2:*:*:placement-group/*",
      "arn:aws:ec2:*:*:snapshot/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:subnet/*"
     ],
     "Sid":"VisualEditor10"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/Owner":"IoTDeviceTester"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*"
     ],
     "Sid":"VisualEditor11"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeSecurityGroups",
      "ssm:DescribeParameters",
      "ssm:GetParameters"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor12"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:TagKeys":[
        "Owner"
       ]
      },
      "StringEquals":{
       "ec2:CreateAction":[
        "RunInstances",
        "CreateSecurityGroup"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"VisualEditor13"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-08-10T20:30:07+00:00"
 },
 "AWSIoTDeviceTesterForGreengrassFullAccess":{
  "CreateDate":"2020-02-20T21:21:27+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "iot.amazonaws.com",
        "lambda.amazonaws.com",
        "greengrass.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/idt-*",
     "Sid":"VisualEditor1"
    },
    {
     "Action":[
      "lambda:CreateFunction",
      "iot:DeleteCertificate",
      "lambda:DeleteFunction",
      "execute-api:Invoke",
      "iot:UpdateCertificate"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:execute-api:us-east-1:098862408343:9xpmnvs5h4/prod/POST/metrics",
      "arn:aws:lambda:*:*:function:idt-*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"VisualEditor2"
    },
    {
     "Action":[
      "iot:CreateThing",
      "iot:DeleteThing"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/idt-*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"VisualEditor3"
    },
    {
     "Action":[
      "iot:AttachPolicy",
      "iot:DetachPolicy",
      "iot:DeletePolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:policy/idt-*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"VisualEditor4"
    },
    {
     "Action":[
      "iot:CreateJob",
      "iot:DescribeJob",
      "iot:DescribeJobExecution",
      "iot:DeleteJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/idt-*",
      "arn:aws:iot:*:*:job/*"
     ],
     "Sid":"VisualEditor5"
    },
    {
     "Action":[
      "iot:DescribeEndpoint",
      "greengrass:*",
      "iam:ListAttachedRolePolicies",
      "iot:CreatePolicy",
      "iot:GetThingShadow",
      "iot:CreateKeysAndCertificate",
      "iot:ListThings",
      "iot:UpdateThingShadow",
      "iot:CreateCertificateFromCsr",
      "iot-device-tester:SendMetrics",
      "iot-device-tester:SupportedVersion",
      "iot-device-tester:LatestIdt",
      "iot-device-tester:CheckVersion",
      "iot-device-tester:DownloadTestSuite"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor6"
    },
    {
     "Action":[
      "iot:DetachThingPrincipal",
      "iot:AttachThingPrincipal"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/idt-*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"VisualEditor7"
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:DeleteObjectVersion",
      "s3:ListBucketVersions",
      "s3:CreateBucket",
      "s3:DeleteObject",
      "s3:DeleteBucket"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::idt*",
     "Sid":"VisualEditor8"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-25T17:01:56+00:00"
 },
 "AWSIoTEventsFullAccess":{
  "CreateDate":"2019-01-10T22:51:57+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotevents:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-01-10T22:51:57+00:00"
 },
 "AWSIoTEventsReadOnlyAccess":{
  "CreateDate":"2019-01-10T22:50:08+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotevents:Describe*",
      "iotevents:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-09-23T17:22:04+00:00"
 },
 "AWSIoTFleetHubFederationAccess":{
  "CreateDate":"2020-12-15T08:08:05+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:DescribeIndex",
      "iot:DescribeThingGroup",
      "iot:GetBucketsAggregation",
      "iot:GetCardinality",
      "iot:GetIndexingConfiguration",
      "iot:GetPercentiles",
      "iot:GetStatistics",
      "iot:SearchIndex",
      "iot:CreateFleetMetric",
      "iot:ListFleetMetrics",
      "iot:DeleteFleetMetric",
      "iot:DescribeFleetMetric",
      "iot:UpdateFleetMetric",
      "iot:DescribeCustomMetric",
      "iot:ListCustomMetrics",
      "iot:ListDimensions",
      "iot:ListMetricValues",
      "iot:ListThingGroups",
      "iot:ListThingsInThingGroup",
      "iot:ListJobTemplates",
      "iot:DescribeJobTemplate",
      "iot:ListJobs",
      "iot:CreateJob",
      "iot:CancelJob",
      "iot:DescribeJob",
      "iot:ListJobExecutionsForJob",
      "iot:ListJobExecutionsForThing",
      "iot:DescribeJobExecution",
      "iot:ListSecurityProfiles",
      "iot:DescribeSecurityProfile",
      "iot:ListActiveViolations",
      "iot:GetThingShadow",
      "iot:ListNamedShadowsForThing",
      "iot:CancelJobExecution",
      "iot:DescribeEndpoint",
      "iotfleethub:DescribeApplication",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:GetMetricData",
      "cloudwatch:ListMetrics",
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sns:CreateTopic",
      "sns:DeleteTopic",
      "sns:ListSubscriptionsByTopic",
      "sns:Subscribe",
      "sns:Unsubscribe"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:iotfleethub*"
    },
    {
     "Action":[
      "cloudwatch:PutMetricAlarm",
      "cloudwatch:DeleteAlarms",
      "cloudwatch:DescribeAlarmHistory"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudwatch:*:*:iotfleethub*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-04T18:03:01+00:00"
 },
 "AWSIoTFleetwiseServiceRolePolicy":{
  "CreateDate":"2022-09-21T23:27:48+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":[
        "AWS/IoTFleetWise"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-09-21T23:27:48+00:00"
 },
 "AWSIoTFullAccess":{
  "CreateDate":"2015-10-08T15:19:49+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:*",
      "iotjobsdata:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-19T21:39:11+00:00"
 },
 "AWSIoTLogging":{
  "CreateDate":"2015-10-08T15:17:25+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:PutMetricFilter",
      "logs:PutRetentionPolicy",
      "logs:GetLogEvents",
      "logs:DeleteLogStream"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-10-08T15:17:25+00:00"
 },
 "AWSIoTOTAUpdate":{
  "CreateDate":"2017-12-20T20:36:53+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":[
     "iot:CreateJob",
     "signer:DescribeSigningJob"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-12-20T20:36:53+00:00"
 },
 "AWSIoTRuleActions":{
  "CreateDate":"2015-10-08T15:14:51+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":{
    "Action":[
     "dynamodb:PutItem",
     "kinesis:PutRecord",
     "iot:Publish",
     "s3:PutObject",
     "sns:Publish",
     "sqs:SendMessage*",
     "cloudwatch:SetAlarmState",
     "cloudwatch:PutMetricData",
     "es:ESHttpPut",
     "firehose:PutRecord"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-01-16T19:28:19+00:00"
 },
 "AWSIoTSiteWiseConsoleFullAccess":{
  "CreateDate":"2019-05-31T21:37:49+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"iotsitewise:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iotanalytics:List*",
      "iotanalytics:Describe*",
      "iotanalytics:Create*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iot:DescribeEndpoint",
      "iot:GetThingShadow"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "greengrass:GetGroup",
      "greengrass:GetGroupVersion",
      "greengrass:GetCoreDefinitionVersion",
      "greengrass:ListGroups"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "secretsmanager:ListSecrets",
      "secretsmanager:CreateSecret"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "secretsmanager:UpdateSecret"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:greengrass-*"
    },
    {
     "Action":[
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"iotsitewise.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/iotsitewise.amazonaws.com/AWSServiceRoleForIoTSiteWise*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"iotsitewise.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/iotsitewise.amazonaws.com/AWSServiceRoleForIoTSiteWise*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-05-31T21:37:49+00:00"
 },
 "AWSIoTSiteWiseFullAccess":{
  "CreateDate":"2018-12-04T20:53:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotsitewise:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-12-04T20:53:39+00:00"
 },
 "AWSIoTSiteWiseMonitorPortalAccess":{
  "CreateDate":"2020-05-19T20:01:21+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotsitewise:CreateProject",
      "iotsitewise:DescribeProject",
      "iotsitewise:UpdateProject",
      "iotsitewise:DeleteProject",
      "iotsitewise:ListProjects",
      "iotsitewise:BatchAssociateProjectAssets",
      "iotsitewise:BatchDisassociateProjectAssets",
      "iotsitewise:ListProjectAssets",
      "iotsitewise:CreateDashboard",
      "iotsitewise:DescribeDashboard",
      "iotsitewise:UpdateDashboard",
      "iotsitewise:DeleteDashboard",
      "iotsitewise:ListDashboards",
      "iotsitewise:CreateAccessPolicy",
      "iotsitewise:DescribeAccessPolicy",
      "iotsitewise:UpdateAccessPolicy",
      "iotsitewise:DeleteAccessPolicy",
      "iotsitewise:ListAccessPolicies",
      "iotsitewise:DescribeAsset",
      "iotsitewise:ListAssets",
      "iotsitewise:ListAssociatedAssets",
      "iotsitewise:DescribeAssetProperty",
      "iotsitewise:GetAssetPropertyValue",
      "iotsitewise:GetAssetPropertyValueHistory",
      "iotsitewise:GetAssetPropertyAggregates",
      "sso-directory:DescribeUsers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-05-19T20:01:21+00:00"
 },
 "AWSIoTSiteWiseMonitorServiceRolePolicy":{
  "CreateDate":"2019-11-14T00:59:10+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotsitewise:CreateProject",
      "iotsitewise:DescribeProject",
      "iotsitewise:UpdateProject",
      "iotsitewise:DeleteProject",
      "iotsitewise:ListProjects",
      "iotsitewise:BatchAssociateProjectAssets",
      "iotsitewise:BatchDisassociateProjectAssets",
      "iotsitewise:ListProjectAssets",
      "iotsitewise:CreateDashboard",
      "iotsitewise:DescribeDashboard",
      "iotsitewise:UpdateDashboard",
      "iotsitewise:DeleteDashboard",
      "iotsitewise:ListDashboards",
      "iotsitewise:CreateAccessPolicy",
      "iotsitewise:DescribeAccessPolicy",
      "iotsitewise:UpdateAccessPolicy",
      "iotsitewise:DeleteAccessPolicy",
      "iotsitewise:ListAccessPolicies",
      "iotsitewise:DescribeAsset",
      "iotsitewise:ListAssets",
      "iotsitewise:ListAssociatedAssets",
      "iotsitewise:DescribeAssetProperty",
      "iotsitewise:GetAssetPropertyValue",
      "iotsitewise:GetAssetPropertyValueHistory",
      "iotsitewise:GetAssetPropertyAggregates",
      "sso-directory:DescribeUsers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-13T22:19:25+00:00"
 },
 "AWSIoTSiteWiseReadOnlyAccess":{
  "CreateDate":"2018-12-04T20:55:11+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotsitewise:Describe*",
      "iotsitewise:List*",
      "iotsitewise:Get*",
      "iotsitewise:BatchGet*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-09-16T19:05:20+00:00"
 },
 "AWSIoTThingsRegistration":{
  "CreateDate":"2017-12-01T20:21:52+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:AddThingToThingGroup",
      "iot:AttachPolicy",
      "iot:AttachPrincipalPolicy",
      "iot:AttachThingPrincipal",
      "iot:CreateCertificateFromCsr",
      "iot:CreatePolicy",
      "iot:CreateThing",
      "iot:DescribeCertificate",
      "iot:DescribeThing",
      "iot:DescribeThingGroup",
      "iot:DescribeThingType",
      "iot:DetachPolicy",
      "iot:DetachThingPrincipal",
      "iot:GetPolicy",
      "iot:ListAttachedPolicies",
      "iot:ListPolicyPrincipals",
      "iot:ListPrincipalPolicies",
      "iot:ListPrincipalThings",
      "iot:ListTargetsForPolicy",
      "iot:ListThingGroupsForThing",
      "iot:ListThingPrincipals",
      "iot:RegisterCertificate",
      "iot:RegisterThing",
      "iot:RemoveThingFromThingGroup",
      "iot:UpdateCertificate",
      "iot:UpdateThing",
      "iot:UpdateThingGroupsForThing",
      "iot:AddThingToBillingGroup",
      "iot:DescribeBillingGroup",
      "iot:RemoveThingFromBillingGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-05T19:20:12+00:00"
 },
 "AWSIoTTwinMakerServiceRolePolicy":{
  "CreateDate":"2023-11-13T18:59:42+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotsitewise:DescribeAsset"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iotsitewise:*:*:asset/*"
     ],
     "Sid":"SiteWiseAssetReadAccess"
    },
    {
     "Action":[
      "iotsitewise:DescribeAssetModel"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iotsitewise:*:*:asset-model/*"
     ],
     "Sid":"SiteWiseAssetModelReadAccess"
    },
    {
     "Action":[
      "iotsitewise:ListAssets",
      "iotsitewise:ListAssetModels"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"SiteWiseAssetModelAndAssetListAccess"
    },
    {
     "Action":[
      "iottwinmaker:GetEntity",
      "iottwinmaker:CreateEntity",
      "iottwinmaker:UpdateEntity",
      "iottwinmaker:DeleteEntity",
      "iottwinmaker:ListEntities",
      "iottwinmaker:GetComponentType",
      "iottwinmaker:CreateComponentType",
      "iottwinmaker:UpdateComponentType",
      "iottwinmaker:DeleteComponentType",
      "iottwinmaker:ListComponentTypes"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "iottwinmaker:linkedServices":[
        "IOTSITEWISE"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iottwinmaker:*:*:workspace/*"
     ],
     "Sid":"TwinMakerAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-13T18:59:42+00:00"
 },
 "AWSIoTWirelessDataAccess":{
  "CreateDate":"2020-12-15T15:31:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotwireless:SendDataToWirelessDevice"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T15:31:39+00:00"
 },
 "AWSIoTWirelessFullAccess":{
  "CreateDate":"2020-12-15T15:27:57+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotwireless:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T15:27:57+00:00"
 },
 "AWSIoTWirelessFullPublishAccess":{
  "CreateDate":"2020-12-15T15:29:59+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:DescribeEndpoint",
      "iot:Publish"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T15:29:59+00:00"
 },
 "AWSIoTWirelessGatewayCertManager":{
  "CreateDate":"2020-12-15T15:30:48+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:CreateKeysAndCertificate",
      "iot:DescribeCertificate",
      "iot:ListCertificates"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IoTWirelessGatewayCertManager"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T15:30:48+00:00"
 },
 "AWSIoTWirelessLogging":{
  "CreateDate":"2020-12-15T15:32:40+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/iotwireless*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T15:32:40+00:00"
 },
 "AWSIoTWirelessReadOnlyAccess":{
  "CreateDate":"2020-12-15T15:28:56+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotwireless:List*",
      "iotwireless:Get*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T15:28:56+00:00"
 },
 "AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy":{
  "CreateDate":"2018-11-14T20:10:53+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudhsm:Describe*",
      "ec2:CreateNetworkInterface",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateSecurityGroup",
      "ec2:DescribeSecurityGroups",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:DeleteSecurityGroup",
      "ec2:DescribeVpcs",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribeNetworkInterfaces"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-10T19:03:34+00:00"
 },
 "AWSKeyManagementServiceMultiRegionKeysServiceRolePolicy":{
  "CreateDate":"2021-06-16T15:37:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "kms:SynchronizeMultiRegionKey"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-16T15:37:37+00:00"
 },
 "AWSKeyManagementServicePowerUser":{
  "CreateDate":"2015-02-06T18:40:40+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "kms:CreateAlias",
      "kms:CreateKey",
      "kms:DeleteAlias",
      "kms:Describe*",
      "kms:GenerateRandom",
      "kms:Get*",
      "kms:List*",
      "kms:TagResource",
      "kms:UntagResource",
      "iam:ListGroups",
      "iam:ListRoles",
      "iam:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-03-07T00:55:11+00:00"
 },
 "AWSLakeFormationCrossAccountManager":{
  "CreateDate":"2020-08-04T20:59:46+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ram:CreateResourceShare"
     ],
     "Condition":{
      "StringLikeIfExists":{
       "ram:RequestedResourceType":[
        "glue:Table",
        "glue:Database",
        "glue:Catalog"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowCreateResourceShare"
    },
    {
     "Action":[
      "ram:UpdateResourceShare",
      "ram:DeleteResourceShare",
      "ram:AssociateResourceShare",
      "ram:DisassociateResourceShare",
      "ram:GetResourceShares"
     ],
     "Condition":{
      "StringLike":{
       "ram:ResourceShareName":[
        "LakeFormation*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowManageResourceShare"
    },
    {
     "Action":[
      "ram:AssociateResourceSharePermission"
     ],
     "Condition":{
      "StringLike":{
       "ram:PermissionArn":[
        "arn:aws:ram::aws:permission/AWSRAMLFEnabled*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowManageResourceSharePermissions"
    },
    {
     "Action":[
      "glue:PutResourcePolicy",
      "glue:DeleteResourcePolicy",
      "organizations:DescribeOrganization",
      "organizations:DescribeAccount",
      "ram:Get*",
      "ram:List*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowXAcctManagerPermissions"
    },
    {
     "Action":[
      "organizations:ListRoots",
      "organizations:ListAccountsForParent",
      "organizations:ListOrganizationalUnitsForParent"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowOrganizationsPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-22T18:51:56+00:00"
 },
 "AWSLakeFormationDataAdmin":{
  "CreateDate":"2019-08-08T17:33:44+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "lakeformation:*",
      "cloudtrail:DescribeTrails",
      "cloudtrail:LookupEvents",
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:CreateDatabase",
      "glue:UpdateDatabase",
      "glue:DeleteDatabase",
      "glue:GetConnections",
      "glue:SearchTables",
      "glue:GetTable",
      "glue:CreateTable",
      "glue:UpdateTable",
      "glue:DeleteTable",
      "glue:GetTableVersions",
      "glue:GetPartitions",
      "glue:GetTables",
      "glue:ListWorkflows",
      "glue:BatchGetWorkflows",
      "glue:DeleteWorkflow",
      "glue:GetWorkflowRuns",
      "glue:StartWorkflowRun",
      "glue:GetWorkflow",
      "s3:ListBucket",
      "s3:GetBucketLocation",
      "s3:ListAllMyBuckets",
      "s3:GetBucketAcl",
      "iam:ListUsers",
      "iam:ListRoles",
      "iam:GetRole",
      "iam:GetRolePolicy"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSLakeFormationDataAdminAllow"
    },
    {
     "Action":[
      "lakeformation:PutDataLakeSettings"
     ],
     "Effect":"Deny",
     "Resource":"*",
     "Sid":"AWSLakeFormationDataAdminDeny"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-22T18:27:42+00:00"
 },
 "AWSLambdaBasicExecutionRole":{
  "CreateDate":"2015-04-09T15:03:43+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-04-09T15:03:43+00:00"
 },
 "AWSLambdaDynamoDBExecutionRole":{
  "CreateDate":"2015-04-09T15:09:29+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "dynamodb:DescribeStream",
      "dynamodb:GetRecords",
      "dynamodb:GetShardIterator",
      "dynamodb:ListStreams",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-04-09T15:09:29+00:00"
 },
 "AWSLambdaENIManagementAccess":{
  "CreateDate":"2016-12-06T00:37:27+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DeleteNetworkInterface",
      "ec2:AssignPrivateIpAddresses",
      "ec2:UnassignPrivateIpAddresses"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-01T20:07:26+00:00"
 },
 "AWSLambdaExecute":{
  "CreateDate":"2015-02-06T18:40:46+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:*"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:40:46+00:00"
 },
 "AWSLambdaInvocation-DynamoDB":{
  "CreateDate":"2015-02-06T18:40:47+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "dynamodb:DescribeStream",
      "dynamodb:GetRecords",
      "dynamodb:GetShardIterator",
      "dynamodb:ListStreams"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:40:47+00:00"
 },
 "AWSLambdaKinesisExecutionRole":{
  "CreateDate":"2015-04-09T15:14:16+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "kinesis:DescribeStream",
      "kinesis:DescribeStreamSummary",
      "kinesis:GetRecords",
      "kinesis:GetShardIterator",
      "kinesis:ListShards",
      "kinesis:ListStreams",
      "kinesis:SubscribeToShard",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-19T20:09:24+00:00"
 },
 "AWSLambdaMSKExecutionRole":{
  "CreateDate":"2020-08-11T17:35:05+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "kafka:DescribeCluster",
      "kafka:DescribeClusterV2",
      "kafka:GetBootstrapBrokers",
      "ec2:CreateNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeVpcs",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-08-02T20:08:02+00:00"
 },
 "AWSLambdaReplicator":{
  "CreateDate":"2017-05-23T17:53:03+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "lambda:CreateFunction",
      "lambda:DeleteFunction",
      "lambda:DisableReplication"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:*"
     ],
     "Sid":"LambdaCreateDeletePermission"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLikeIfExists":{
       "iam:PassedToService":"lambda.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"IamPassRolePermission"
    },
    {
     "Action":[
      "cloudfront:ListDistributionsByLambdaFunction"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"CloudFrontListDistributions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-12-08T00:17:54+00:00"
 },
 "AWSLambdaRole":{
  "CreateDate":"2015-02-06T18:41:28+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:41:28+00:00"
 },
 "AWSLambdaSQSQueueExecutionRole":{
  "CreateDate":"2018-06-14T21:50:45+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sqs:ReceiveMessage",
      "sqs:DeleteMessage",
      "sqs:GetQueueAttributes",
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-06-14T21:50:45+00:00"
 },
 "AWSLambdaVPCAccessExecutionRole":{
  "CreateDate":"2016-02-11T23:15:26+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "ec2:CreateNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSubnets",
      "ec2:DeleteNetworkInterface",
      "ec2:AssignPrivateIpAddresses",
      "ec2:UnassignPrivateIpAddresses"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSLambdaVPCAccessExecutionPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-01-05T22:38:26+00:00"
 },
 "AWSLambda_FullAccess":{
  "CreateDate":"2020-11-17T21:14:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:ListStackResources",
      "cloudwatch:ListMetrics",
      "cloudwatch:GetMetricData",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "kms:ListAliases",
      "iam:GetPolicy",
      "iam:GetPolicyVersion",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:ListAttachedRolePolicies",
      "iam:ListRolePolicies",
      "iam:ListRoles",
      "lambda:*",
      "logs:DescribeLogGroups",
      "states:DescribeStateMachine",
      "states:ListStateMachines",
      "tag:GetResources",
      "xray:GetTraceSummaries",
      "xray:BatchGetTraces"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"lambda.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:DescribeLogStreams",
      "logs:GetLogEvents",
      "logs:FilterLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/lambda/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-17T21:14:08+00:00"
 },
 "AWSLambda_ReadOnlyAccess":{
  "CreateDate":"2020-11-17T21:10:32+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:ListStacks",
      "cloudformation:ListStackResources",
      "cloudwatch:GetMetricData",
      "cloudwatch:ListMetrics",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "kms:ListAliases",
      "iam:GetPolicy",
      "iam:GetPolicyVersion",
      "iam:GetRole",
      "iam:GetRolePolicy",
      "iam:ListAttachedRolePolicies",
      "iam:ListRolePolicies",
      "iam:ListRoles",
      "logs:DescribeLogGroups",
      "lambda:Get*",
      "lambda:List*",
      "states:DescribeStateMachine",
      "states:ListStateMachines",
      "tag:GetResources",
      "xray:GetTraceSummaries",
      "xray:BatchGetTraces"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:DescribeLogStreams",
      "logs:GetLogEvents",
      "logs:FilterLogEvents",
      "logs:StartQuery",
      "logs:StopQuery",
      "logs:DescribeQueries",
      "logs:GetLogGroupFields",
      "logs:GetLogRecord",
      "logs:GetQueryResults"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/lambda/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-07-27T17:32:05+00:00"
 },
 "AWSLicenseManagerConsumptionPolicy":{
  "CreateDate":"2021-08-11T23:18:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":[
     "license-manager:CheckoutLicense",
     "license-manager:CheckInLicense",
     "license-manager:ExtendLicenseConsumption",
     "license-manager:GetLicense"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-08-11T23:18:08+00:00"
 },
 "AWSLicenseManagerLinuxSubscriptionsServiceRolePolicy":{
  "CreateDate":"2022-12-20T18:54:54+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeRegions"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"EC2Permissions"
    },
    {
     "Action":[
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:DescribeAccount",
      "organizations:ListChildren",
      "organizations:ListParents",
      "organizations:ListAccountsForParent",
      "organizations:ListRoots",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListDelegatedAdministrators"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OrganizationPermissions"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}",
       "aws:ResourceTag/LicenseManagerLinuxSubscriptions":"enabled"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:secretsmanager:*:*:secret:*"
     ],
     "Sid":"SecretsManagerPermissions"
    },
    {
     "Action":[
      "kms:Decrypt"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}",
       "aws:ResourceTag/LicenseManagerLinuxSubscriptions":"enabled"
      },
      "StringLike":{
       "kms:ViaService":[
        "secretsmanager.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kms:*:*:key/*"
     ],
     "Sid":"KMSPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-07-08T22:04:56+00:00"
 },
 "AWSLicenseManagerMasterAccountRolePolicy":{
  "CreateDate":"2018-11-26T19:03:51+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:GetLifecycleConfiguration",
      "s3:PutLifecycleConfiguration",
      "s3:GetBucketPolicy",
      "s3:PutBucketPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-license-manager-service-*"
     ],
     "Sid":"S3BucketPermissions"
    },
    {
     "Action":[
      "s3:AbortMultipartUpload",
      "s3:PutObject",
      "s3:GetObject",
      "s3:ListBucketMultipartUploads",
      "s3:ListMultipartUploadParts"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-license-manager-service-*"
     ],
     "Sid":"S3ObjectPermissions1"
    },
    {
     "Action":[
      "s3:DeleteObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-license-manager-service-*/resource_sync/*"
     ],
     "Sid":"S3ObjectPermissions2"
    },
    {
     "Action":[
      "athena:GetQueryExecution",
      "athena:GetQueryResults",
      "athena:StartQueryExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AthenaPermissions"
    },
    {
     "Action":[
      "glue:GetTable",
      "glue:GetPartition",
      "glue:GetPartitions"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"GluePermissions"
    },
    {
     "Action":[
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:DescribeAccount",
      "organizations:ListChildren",
      "organizations:ListParents",
      "organizations:ListAccountsForParent",
      "organizations:ListRoots",
      "organizations:ListAWSServiceAccessForOrganization"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OrganizationPermissions"
    },
    {
     "Action":[
      "ram:GetResourceShares",
      "ram:GetResourceShareAssociations",
      "ram:TagResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"RAMPermissions1"
    },
    {
     "Action":[
      "ram:CreateResourceShare"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/Service":"LicenseManager"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"RAMPermissions2"
    },
    {
     "Action":[
      "ram:AssociateResourceShare",
      "ram:DisassociateResourceShare",
      "ram:UpdateResourceShare",
      "ram:DeleteResourceShare"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/Service":"LicenseManager"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"RAMPermissions3"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"IAMGetRoles"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "cloudformation.amazonaws.com",
        "glue.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/LicenseManagerServiceResourceDataSyncRole*"
     ],
     "Sid":"IAMPassRoles"
    },
    {
     "Action":[
      "cloudformation:UpdateStack",
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStacks"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/LicenseManagerCrossAccountCloudDiscoveryStack/*"
     ],
     "Sid":"CloudformationPermission"
    },
    {
     "Action":[
      "glue:CreateTable",
      "glue:UpdateTable",
      "glue:DeleteTable",
      "glue:UpdateJob",
      "glue:UpdateCrawler"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:glue:*:*:catalog",
      "arn:aws:glue:*:*:crawler/LicenseManagerResourceSynDataCrawler",
      "arn:aws:glue:*:*:job/LicenseManagerResourceSynDataProcessJob",
      "arn:aws:glue:*:*:table/license_manager_resource_inventory_db/*",
      "arn:aws:glue:*:*:table/license_manager_resource_sync/*",
      "arn:aws:glue:*:*:database/license_manager_resource_inventory_db",
      "arn:aws:glue:*:*:database/license_manager_resource_sync"
     ],
     "Sid":"GlueUpdatePermissions"
    },
    {
     "Action":[
      "resource-groups:PutGroupPolicy"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "ram.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RGPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-05-31T20:50:26+00:00"
 },
 "AWSLicenseManagerMemberAccountRolePolicy":{
  "CreateDate":"2018-11-26T19:04:32+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "license-manager:UpdateLicenseSpecificationsForResource",
      "license-manager:GetLicenseConfiguration"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"LicenseManagerPermissions"
    },
    {
     "Action":[
      "ssm:ListInventoryEntries",
      "ssm:GetInventory",
      "ssm:CreateAssociation",
      "ssm:CreateResourceDataSync",
      "ssm:DeleteResourceDataSync",
      "ssm:ListResourceDataSync",
      "ssm:ListAssociations"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"SSMPermissions"
    },
    {
     "Action":[
      "ram:AcceptResourceShareInvitation",
      "ram:GetResourceShareInvitations"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"RAMPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-15T22:09:32+00:00"
 },
 "AWSLicenseManagerServiceRolePolicy":{
  "CreateDate":"2018-11-26T19:02:53+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"license-management.marketplace.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/license-management.marketplace.amazonaws.com/AWSServiceRoleForMarketplaceLicenseManagement"
     ],
     "Sid":"IAMPermissions"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"license-manager.member-account.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:*:iam::*:role/aws-service-role/license-manager.member-account.amazonaws.com/AWSServiceRoleForAWSLicenseManagerMemberAccountRole"
     ],
     "Sid":"IAMPermissionsForCreatingMemberSLR"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-license-manager-service-*"
     ],
     "Sid":"S3BucketPermissions1"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"S3BucketPermissions2"
    },
    {
     "Action":[
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-license-manager-service-*"
     ],
     "Sid":"S3ObjectPermissions"
    },
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sns:*:*:aws-license-manager-service-*"
     ],
     "Sid":"SNSAccountPermissions"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"SNSTopicPermissions"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeImages",
      "ec2:DescribeHosts"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"EC2Permissions"
    },
    {
     "Action":[
      "ssm:ListInventoryEntries",
      "ssm:GetInventory",
      "ssm:CreateAssociation"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"SSMPermissions"
    },
    {
     "Action":[
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:DescribeOrganization",
      "organizations:ListDelegatedAdministrators"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"OrganizationPermissions"
    },
    {
     "Action":[
      "license-manager:GetServiceSettings",
      "license-manager:GetLicense*",
      "license-manager:UpdateLicenseSpecificationsForResource",
      "license-manager:List*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"LicenseManagerPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-30T01:43:19+00:00"
 },
 "AWSLicenseManagerUserSubscriptionsServiceRolePolicy":{
  "CreateDate":"2022-07-30T01:17:18+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:DescribeDirectories",
      "ds:GetAuthorizedApplicationDetails"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DSReadPermissions"
    },
    {
     "Action":[
      "ssm:GetInventory",
      "ssm:GetCommandInvocation",
      "ssm:ListCommandInvocations",
      "ssm:DescribeInstanceInformation"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SSMReadPermissions"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeVpcPeeringConnections"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2ReadPermissions"
    },
    {
     "Action":[
      "ec2:TerminateInstances",
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:productCode":[
        "bz0vcy31ooqlzk5tsash4r1ik",
        "d44g89hc0gp9jdzm99rznthpw",
        "77yzkpa7kvee1y1tt7wnsdwoc"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"EC2WritePermissions"
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*::document/AWS-RunPowerShellScript"
     ],
     "Sid":"SSMDocumentExecutionPermissions"
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/AWSLicenseManager":"UserSubscriptions"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"SSMInstanceExecutionPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-11-21T19:51:42+00:00"
 },
 "AWSM2ServicePolicy":{
  "CreateDate":"2022-06-07T20:26:39+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeSubnets",
      "ec2:CreateNetworkInterface",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeNetworkInterfaces",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:ModifyNetworkInterfaceAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticfilesystem:DescribeMountTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:DeregisterTargets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "fsx:DescribeFileSystems"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":[
        "AWS/M2"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-06-07T20:26:39+00:00"
 },
 "AWSMSKReplicatorExecutionRole":{
  "CreateDate":"2023-12-06T00:07:52+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "kafka-cluster:Connect",
      "kafka-cluster:DescribeCluster",
      "kafka-cluster:AlterCluster",
      "kafka-cluster:DescribeTopic",
      "kafka-cluster:CreateTopic",
      "kafka-cluster:AlterTopic",
      "kafka-cluster:WriteData",
      "kafka-cluster:ReadData",
      "kafka-cluster:AlterGroup",
      "kafka-cluster:DescribeGroup",
      "kafka-cluster:DescribeTopicDynamicConfiguration",
      "kafka-cluster:AlterTopicDynamicConfiguration",
      "kafka-cluster:WriteDataIdempotently"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kafka:*:*:cluster/*"
     ],
     "Sid":"ClusterPermissions"
    },
    {
     "Action":[
      "kafka-cluster:DescribeTopic",
      "kafka-cluster:CreateTopic",
      "kafka-cluster:AlterTopic",
      "kafka-cluster:WriteData",
      "kafka-cluster:ReadData",
      "kafka-cluster:DescribeTopicDynamicConfiguration",
      "kafka-cluster:AlterTopicDynamicConfiguration",
      "kafka-cluster:AlterCluster"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kafka:*:*:topic/*/*"
     ],
     "Sid":"TopicPermissions"
    },
    {
     "Action":[
      "kafka-cluster:AlterGroup",
      "kafka-cluster:DescribeGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:kafka:*:*:group/*/*"
     ],
     "Sid":"GroupPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-25T21:36:08+00:00"
 },
 "AWSManagedServicesDeploymentToolkitPolicy":{
  "CreateDate":"2022-06-09T18:33:03+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:CreateBucket",
      "s3:DeleteBucket",
      "s3:DeleteBucketPolicy",
      "s3:DeleteObject",
      "s3:DeleteObjectTagging",
      "s3:DeleteObjectVersion",
      "s3:DeleteObjectVersionTagging",
      "s3:GetBucketLocation",
      "s3:GetBucketLogging",
      "s3:GetBucketPolicy",
      "s3:GetBucketVersioning",
      "s3:GetLifecycleConfiguration",
      "s3:GetObject",
      "s3:GetObjectAcl",
      "s3:GetObjectAttributes",
      "s3:GetObjectLegalHold",
      "s3:GetObjectRetention",
      "s3:GetObjectTagging",
      "s3:GetObjectVersion",
      "s3:GetObjectVersionAcl",
      "s3:GetObjectVersionAttributes",
      "s3:GetObjectVersionForReplication",
      "s3:GetObjectVersionTagging",
      "s3:GetObjectVersionTorrent",
      "s3:ListBucket",
      "s3:ListBucketVersions",
      "s3:PutBucketAcl",
      "s3:PutBucketLogging",
      "s3:PutBucketObjectLockConfiguration",
      "s3:PutBucketPolicy",
      "s3:PutBucketPublicAccessBlock",
      "s3:PutBucketTagging",
      "s3:PutBucketVersioning",
      "s3:PutEncryptionConfiguration",
      "s3:PutLifecycleConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::ams-cdktoolkit*",
     "Sid":"AMSCDKToolkitS3Permissions"
    },
    {
     "Action":[
      "cloudformation:CreateChangeSet",
      "cloudformation:DeleteChangeSet",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeChangeSet",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStacks",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:GetTemplate",
      "cloudformation:GetTemplateSummary",
      "cloudformation:TagResource",
      "cloudformation:UntagResource",
      "cloudformation:UpdateTerminationProtection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/ams-cdk-toolkit*",
     "Sid":"AMSCDKToolkitCloudFormationPermissions"
    },
    {
     "Action":[
      "ecr:BatchGetRepositoryScanningConfiguration",
      "ecr:CreateRepository",
      "ecr:DeleteLifecyclePolicy",
      "ecr:DeleteRepository",
      "ecr:DeleteRepositoryPolicy",
      "ecr:DescribeRepositories",
      "ecr:GetLifecyclePolicy",
      "ecr:ListTagsForResource",
      "ecr:PutImageScanningConfiguration",
      "ecr:PutImageTagMutability",
      "ecr:PutLifecyclePolicy",
      "ecr:SetRepositoryPolicy",
      "ecr:TagResource",
      "ecr:UntagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ecr:*:*:repository/ams-cdktoolkit*",
     "Sid":"AMSCDKToolkitECRPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-04T20:41:54+00:00"
 },
 "AWSManagedServices_ContactsServiceRolePolicy":{
  "CreateDate":"2023-03-23T17:07:46+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:ListRoleTags",
      "iam:ListUserTags",
      "tag:GetResources",
      "ec2:DescribeTags"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"s3:GetBucketTagging",
     "Condition":{
      "NumericGreaterThanEquals":{
       "s3:TlsVersion":"1.2"
      },
      "StringEquals":{
       "s3:authType":"REST-HEADER",
       "s3:signatureversion":"AWS4-HMAC-SHA256"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-23T17:07:46+00:00"
 },
 "AWSManagedServices_DetectiveControlsConfig_ServiceRolePolicy":{
  "CreateDate":"2022-12-19T23:11:17+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:UpdateTermination*",
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStackResources",
      "cloudformation:CreateChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:GetTemplateSummary",
      "cloudformation:DescribeStacks"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/ams-detective-controls-config-recorder",
      "arn:aws:cloudformation:*:*:stack/ams-detective-controls-config-rules-cdk",
      "arn:aws:cloudformation:*:*:stack/ams-detective-controls-infrastructure-cdk"
     ]
    },
    {
     "Action":[
      "config:DescribeAggregationAuthorizations",
      "config:PutAggregationAuthorization",
      "config:TagResource",
      "config:PutConfigRule"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:config:*:*:aggregation-authorization/540708452589/*",
      "arn:aws:config:*:*::config-rule/*"
     ]
    },
    {
     "Action":[
      "s3:GetBucketPolicy",
      "s3:CreateBucket",
      "s3:DeleteBucket",
      "s3:DeleteBucketPolicy",
      "s3:DeleteObject",
      "s3:ListBucket",
      "s3:ListBucketVersions",
      "s3:GetBucketAcl",
      "s3:PutObject",
      "s3:PutBucketAcl",
      "s3:PutBucketLogging",
      "s3:PutBucketObjectLockConfiguration",
      "s3:PutBucketPolicy",
      "s3:PutBucketPublicAccessBlock",
      "s3:PutBucketTagging",
      "s3:PutBucketVersioning",
      "s3:PutEncryptionConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::ams-config-record-bucket-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-12-19T23:11:17+00:00"
 },
 "AWSManagedServices_EventsServiceRolePolicy":{
  "CreateDate":"2023-02-07T18:41:22+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "events:DeleteRule",
      "events:PutTargets",
      "events:PutRule",
      "events:RemoveTargets"
     ],
     "Condition":{
      "StringEquals":{
       "events:ManagedBy":"events.managedservices.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "events:DescribeRule",
      "events:ListTargetsByRule"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-02-07T18:41:22+00:00"
 },
 "AWSMarketplaceAmiIngestion":{
  "CreateDate":"2020-09-25T20:55:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:ModifySnapshotAttribute"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:us-east-1::snapshot/snap-*"
    },
    {
     "Action":[
      "ec2:DescribeImageAttribute",
      "ec2:DescribeImages",
      "ec2:DescribeSnapshotAttribute",
      "ec2:ModifyImageAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-25T20:55:10+00:00"
 },
 "AWSMarketplaceDeploymentServiceRolePolicy":{
  "CreateDate":"2023-11-15T23:34:33+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "secretsmanager:CreateSecret",
      "secretsmanager:PutSecretValue",
      "secretsmanager:DescribeSecret",
      "secretsmanager:DeleteSecret",
      "secretsmanager:RemoveRegionsFromReplication"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:secretsmanager:*:*:secret:marketplace-deployment*!*"
     ],
     "Sid":"ManageMarketplaceDeploymentSecrets"
    },
    {
     "Action":[
      "secretsmanager:ListSecrets"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ListSecrets"
    },
    {
     "Action":[
      "secretsmanager:TagResource"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "expirationDate"
       ]
      },
      "Null":{
       "aws:RequestTag/expirationDate":"false"
      },
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:marketplace-deployment!*",
     "Sid":"TagMarketplaceDeploymentSecrets"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-15T23:34:33+00:00"
 },
 "AWSMarketplaceFullAccess":{
  "CreateDate":"2015-02-11T17:21:45+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:*",
      "cloudformation:CreateStack",
      "cloudformation:DescribeStackResource",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStacks",
      "cloudformation:List*",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateSecurityGroup",
      "ec2:CreateTags",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DeleteSecurityGroup",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeTags",
      "ec2:DescribeVpcs",
      "ec2:RunInstances",
      "ec2:StartInstances",
      "ec2:StopInstances",
      "ec2:TerminateInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CopyImage",
      "ec2:DeregisterImage",
      "ec2:DescribeSnapshots",
      "ec2:DeleteSnapshot",
      "ec2:CreateImage",
      "ec2:DescribeInstanceStatus",
      "ssm:GetAutomationExecution",
      "ssm:ListDocuments",
      "ssm:DescribeDocument",
      "sns:ListTopics",
      "sns:GetTopicAttributes",
      "sns:CreateTopic",
      "iam:GetRole",
      "iam:GetInstanceProfile",
      "iam:ListRoles",
      "iam:ListInstanceProfiles"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*image-build*"
     ]
    },
    {
     "Action":[
      "sns:Publish",
      "sns:setTopicAttributes"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:*image-build*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:PassedToService":[
        "ec2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:eu-central-1:906690553262:automation-definition/*",
      "arn:aws:ssm:us-east-1:058657716661:automation-definition/*",
      "arn:aws:ssm:ap-northeast-1:340648487307:automation-definition/*",
      "arn:aws:ssm:eu-west-1:564714592864:automation-definition/*",
      "arn:aws:ssm:us-west-2:243045473901:automation-definition/*",
      "arn:aws:ssm:ap-southeast-2:362149219987:automation-definition/*",
      "arn:aws:ssm:eu-west-2:587945719687:automation-definition/*",
      "arn:aws:ssm:us-east-2:134937423163:automation-definition/*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AssociatedResourceARN":[
        "arn:aws:ssm:eu-central-1:906690553262:automation-definition/*",
        "arn:aws:ssm:us-east-1:058657716661:automation-definition/*",
        "arn:aws:ssm:ap-northeast-1:340648487307:automation-definition/*",
        "arn:aws:ssm:eu-west-1:564714592864:automation-definition/*",
        "arn:aws:ssm:us-west-2:243045473901:automation-definition/*",
        "arn:aws:ssm:ap-southeast-2:362149219987:automation-definition/*",
        "arn:aws:ssm:eu-west-2:587945719687:automation-definition/*",
        "arn:aws:ssm:us-east-2:134937423163:automation-definition/*"
       ],
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-04T17:04:00+00:00"
 },
 "AWSMarketplaceGetEntitlements":{
  "CreateDate":"2017-03-27T19:37:24+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:GetEntitlements"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSMarketplaceGetEntitlements"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-05T01:27:20+00:00"
 },
 "AWSMarketplaceImageBuildFullAccess":{
  "CreateDate":"2018-07-31T23:29:49+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:ListBuilds",
      "aws-marketplace:StartBuild",
      "aws-marketplace:DescribeBuilds"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:TerminateInstances",
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/marketplace-image-build:build-id":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/*Automation*",
      "arn:aws:iam::*:role/*Instance*"
     ]
    },
    {
     "Action":[
      "ssm:GetAutomationExecution",
      "ssm:ListDocuments",
      "ssm:DescribeDocument",
      "ec2:DeregisterImage",
      "ec2:CopyImage",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeImages",
      "ec2:DescribeSubnets",
      "ec2:DeleteSnapshot",
      "ec2:CreateImage",
      "ec2:RunInstances",
      "ec2:DescribeInstanceStatus",
      "sns:GetTopicAttributes",
      "iam:GetRole",
      "iam:GetInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*image-build*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sns:*:*:*image-build*"
     ]
    },
    {
     "Action":[
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:eu-central-1:906690553262:automation-definition/*",
      "arn:aws:ssm:us-east-1:058657716661:automation-definition/*",
      "arn:aws:ssm:ap-northeast-1:340648487307:automation-definition/*",
      "arn:aws:ssm:eu-west-1:564714592864:automation-definition/*",
      "arn:aws:ssm:us-west-2:243045473901:automation-definition/*",
      "arn:aws:ssm:ap-southeast-2:362149219987:automation-definition/*",
      "arn:aws:ssm:eu-west-2:587945719687:automation-definition/*",
      "arn:aws:ssm:us-east-2:134937423163:automation-definition/*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringLike":{
       "iam:AssociatedResourceARN":[
        "arn:aws:ssm:eu-central-1:906690553262:automation-definition/*",
        "arn:aws:ssm:us-east-1:058657716661:automation-definition/*",
        "arn:aws:ssm:ap-northeast-1:340648487307:automation-definition/*",
        "arn:aws:ssm:eu-west-1:564714592864:automation-definition/*",
        "arn:aws:ssm:us-west-2:243045473901:automation-definition/*",
        "arn:aws:ssm:ap-southeast-2:362149219987:automation-definition/*",
        "arn:aws:ssm:eu-west-2:587945719687:automation-definition/*",
        "arn:aws:ssm:us-east-2:134937423163:automation-definition/*"
       ],
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringLike":{
       "aws:RequestTag/marketplace-image-build:build-id":"*"
      },
      "StringNotEquals":{
       "ec2:CreateAction":"RunInstances"
      }
     },
     "Effect":"Deny",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-03-04T17:05:09+00:00"
 },
 "AWSMarketplaceLicenseManagementServiceRolePolicy":{
  "CreateDate":"2020-12-03T08:33:40+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DescribeOrganization",
      "license-manager:ListReceivedGrants",
      "license-manager:ListDistributedGrants",
      "license-manager:GetGrant",
      "license-manager:CreateGrant",
      "license-manager:CreateGrantVersion",
      "license-manager:DeleteGrant",
      "license-manager:AcceptGrant"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowLicenseManagerActions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-03T08:33:40+00:00"
 },
 "AWSMarketplaceManageSubscriptions":{
  "CreateDate":"2015-02-06T18:40:32+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:ViewSubscriptions",
      "aws-marketplace:Subscribe",
      "aws-marketplace:Unsubscribe"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:CreatePrivateMarketplaceRequests",
      "aws-marketplace:ListPrivateMarketplaceRequests",
      "aws-marketplace:DescribePrivateMarketplaceRequests"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:ListPrivateListings"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-01-19T23:45:29+00:00"
 },
 "AWSMarketplaceMeteringFullAccess":{
  "CreateDate":"2016-03-17T22:39:22+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:MeterUsage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-03-17T22:39:22+00:00"
 },
 "AWSMarketplaceMeteringRegisterUsage":{
  "CreateDate":"2019-11-21T01:17:54+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:RegisterUsage"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-21T01:17:54+00:00"
 },
 "AWSMarketplaceProcurementSystemAdminFullAccess":{
  "CreateDate":"2019-06-25T13:07:47+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:PutProcurementSystemConfiguration",
      "aws-marketplace:DescribeProcurementSystemConfiguration",
      "organizations:Describe*",
      "organizations:List*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-25T13:07:47+00:00"
 },
 "AWSMarketplacePurchaseOrdersServiceRolePolicy":{
  "CreateDate":"2021-10-27T15:12:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "purchase-orders:ViewPurchaseOrders",
      "purchase-orders:ModifyPurchaseOrders"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowPurchaseOrderActions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-27T15:12:37+00:00"
 },
 "AWSMarketplaceRead-only":{
  "CreateDate":"2015-02-06T18:40:31+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:ViewSubscriptions",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:ListBuilds",
      "aws-marketplace:DescribeBuilds",
      "iam:ListRoles",
      "iam:ListInstanceProfiles",
      "sns:GetTopicAttributes",
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:ListPrivateMarketplaceRequests",
      "aws-marketplace:DescribePrivateMarketplaceRequests"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:ListPrivateListings"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-01-19T23:30:25+00:00"
 },
 "AWSMarketplaceResaleAuthorizationServiceRolePolicy":{
  "CreateDate":"2024-03-05T18:47:54+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ram:CreateResourceShare"
     ],
     "Condition":{
      "ArnLike":{
       "ram:ResourceArn":"arn:aws:aws-marketplace:*:*:AWSMarketplace/ResaleAuthorization/*"
      },
      "Null":{
       "ram:Principal":"true"
      },
      "StringEquals":{
       "ram:RequestedResourceType":"aws-marketplace:Entity"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ram:*:*:*"
     ],
     "Sid":"AllowResaleAuthorizationShareActionsRAMCreate"
    },
    {
     "Action":[
      "ram:AssociateResourceShare"
     ],
     "Condition":{
      "Null":{
       "ram:Principal":"false"
      },
      "StringEquals":{
       "ram:ResourceShareName":"AWSMarketplaceResaleAuthorization"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ram:*:*:*"
     ],
     "Sid":"AllowResaleAuthorizationShareActionsRAMAssociate"
    },
    {
     "Action":[
      "ram:AcceptResourceShareInvitation"
     ],
     "Condition":{
      "StringEquals":{
       "ram:ResourceShareName":"AWSMarketplaceResaleAuthorization"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ram:*:*:*"
     ],
     "Sid":"AllowResaleAuthorizationShareActionsRAMAccept"
    },
    {
     "Action":[
      "ram:GetResourceShareInvitations",
      "ram:GetResourceShareAssociations"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ram:*:*:*"
     ],
     "Sid":"AllowResaleAuthorizationShareActionsRAMGet"
    },
    {
     "Action":[
      "aws-marketplace:PutResourcePolicy",
      "aws-marketplace:GetResourcePolicy"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "ram.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:aws-marketplace:*:*:AWSMarketplace/ResaleAuthorization/*",
     "Sid":"AllowResaleAuthorizationShareActionsMarketplace"
    },
    {
     "Action":[
      "aws-marketplace:DescribeEntity"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:aws-marketplace:*:*:AWSMarketplace/ResaleAuthorization/*",
     "Sid":"AllowResaleAuthorizationShareActionsMarketplaceDescribe"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-05T18:47:54+00:00"
 },
 "AWSMarketplaceSellerFullAccess":{
  "CreateDate":"2019-07-02T20:40:09+00:00",
  "DefaultVersionId":"v12",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace-management:viewReports",
      "aws-marketplace-management:viewSupport",
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:StartChangeSet",
      "aws-marketplace:CancelChangeSet",
      "aws-marketplace:ListEntities",
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:ListTasks",
      "aws-marketplace:DescribeTask",
      "aws-marketplace:UpdateTask",
      "aws-marketplace:CompleteTask",
      "aws-marketplace:GetSellerDashboard",
      "ec2:DescribeImages",
      "ec2:DescribeSnapshots",
      "ec2:ModifyImageAttribute",
      "ec2:ModifySnapshotAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"MarketplaceManagement"
    },
    {
     "Action":[
      "aws-marketplace:SearchAgreements",
      "aws-marketplace:DescribeAgreement",
      "aws-marketplace:GetAgreementTerms"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws-marketplace:AgreementType":[
        "PurchaseAgreement"
       ]
      },
      "StringEquals":{
       "aws-marketplace:PartyType":"Proposer"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AgreementAccess"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*",
     "Sid":"IAMGetRole"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"assets.marketplace.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*",
     "Sid":"AssetScanning"
    },
    {
     "Action":[
      "vendor-insights:GetDataSource",
      "vendor-insights:ListDataSources",
      "vendor-insights:ListSecurityProfiles",
      "vendor-insights:GetSecurityProfile",
      "vendor-insights:GetSecurityProfileSnapshot",
      "vendor-insights:ListSecurityProfileSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VendorInsights"
    },
    {
     "Action":[
      "aws-marketplace:TagResource",
      "aws-marketplace:UntagResource",
      "aws-marketplace:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:aws-marketplace:*:*:AWSMarketplace/*",
     "Sid":"TagManagement"
    },
    {
     "Action":[
      "aws-marketplace-management:GetSellerVerificationDetails",
      "aws-marketplace-management:PutSellerVerificationDetails",
      "aws-marketplace-management:GetBankAccountVerificationDetails",
      "aws-marketplace-management:PutBankAccountVerificationDetails",
      "aws-marketplace-management:GetSecondaryUserVerificationDetails",
      "aws-marketplace-management:PutSecondaryUserVerificationDetails",
      "aws-marketplace-management:GetAdditionalSellerNotificationRecipients",
      "aws-marketplace-management:PutAdditionalSellerNotificationRecipients",
      "payments:GetPaymentInstrument",
      "payments:CreatePaymentInstrument",
      "tax:GetTaxInterview",
      "tax:PutTaxInterview",
      "tax:GetTaxInfoReportingDocument"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SellerSettings"
    },
    {
     "Action":[
      "support:CreateCase"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Support"
    },
    {
     "Action":[
      "aws-marketplace:GetResourcePolicy",
      "aws-marketplace:PutResourcePolicy",
      "aws-marketplace:DeleteResourcePolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:aws-marketplace:*:*:AWSMarketplace/*",
     "Sid":"ResourcePolicyManagement"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"resale-authorization.marketplace.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CreateServiceLinkedRole"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-07-25T16:06:22+00:00"
 },
 "AWSMarketplaceSellerProductsFullAccess":{
  "CreateDate":"2019-07-02T21:06:25+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:StartChangeSet",
      "aws-marketplace:CancelChangeSet",
      "aws-marketplace:ListEntities",
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:ListTasks",
      "aws-marketplace:DescribeTask",
      "aws-marketplace:UpdateTask",
      "aws-marketplace:CompleteTask",
      "ec2:DescribeImages",
      "ec2:DescribeSnapshots",
      "ec2:ModifyImageAttribute",
      "ec2:ModifySnapshotAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"assets.marketplace.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*"
    },
    {
     "Action":[
      "vendor-insights:GetDataSource",
      "vendor-insights:ListDataSources",
      "vendor-insights:ListSecurityProfiles",
      "vendor-insights:GetSecurityProfile",
      "vendor-insights:GetSecurityProfileSnapshot",
      "vendor-insights:ListSecurityProfileSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:TagResource",
      "aws-marketplace:UntagResource",
      "aws-marketplace:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:aws-marketplace:*:*:AWSMarketplace/*"
    },
    {
     "Action":[
      "aws-marketplace:GetResourcePolicy",
      "aws-marketplace:PutResourcePolicy",
      "aws-marketplace:DeleteResourcePolicy"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:aws-marketplace:*:*:AWSMarketplace/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-07-18T22:19:58+00:00"
 },
 "AWSMarketplaceSellerProductsReadOnly":{
  "CreateDate":"2019-07-02T21:40:47+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:ListEntities",
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:ListTasks",
      "aws-marketplace:DescribeTask",
      "ec2:DescribeImages",
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "aws-marketplace:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:aws-marketplace:*:*:AWSMarketplace/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-11-19T00:08:42+00:00"
 },
 "AWSMediaConnectServicePolicy":{
  "CreateDate":"2023-04-03T22:11:40+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ecs:UpdateService",
      "ecs:DeleteService",
      "ecs:CreateService",
      "ecs:DescribeServices",
      "ecs:PutAttributes",
      "ecs:DeleteAttributes",
      "ecs:RunTask",
      "ecs:ListTasks",
      "ecs:StartTask",
      "ecs:StopTask",
      "ecs:DescribeTasks",
      "ecs:DescribeContainerInstances",
      "ecs:UpdateContainerInstancesState"
     ],
     "Condition":{
      "ArnLike":{
       "ecs:cluster":"arn:aws:ecs:*:*:cluster/MediaConnectGateway"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ecs:CreateCluster",
      "ecs:RegisterTaskDefinition"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ecs:UpdateCluster",
      "ecs:UpdateClusterSettings",
      "ecs:ListAttributes",
      "ecs:DescribeClusters",
      "ecs:DeregisterContainerInstance",
      "ecs:ListContainerInstances"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ecs:*:*:cluster/MediaConnectGateway"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-04-03T22:11:40+00:00"
 },
 "AWSMediaTailorServiceRolePolicy":{
  "CreateDate":"2021-09-17T22:27:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"logs:PutLogEvents",
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:MediaTailor/*:log-stream:*"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:MediaTailor/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-17T22:27:10+00:00"
 },
 "AWSMigrationHubDMSAccess":{
  "CreateDate":"2017-08-14T14:00:06+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgh:CreateProgressUpdateStream"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgh:*:*:progressUpdateStream/DMS"
    },
    {
     "Action":[
      "mgh:AssociateCreatedArtifact",
      "mgh:DescribeMigrationTask",
      "mgh:DisassociateCreatedArtifact",
      "mgh:ImportMigrationTask",
      "mgh:ListCreatedArtifacts",
      "mgh:NotifyMigrationTaskState",
      "mgh:PutResourceAttributes",
      "mgh:NotifyApplicationState",
      "mgh:DescribeApplicationState",
      "mgh:AssociateDiscoveredResource",
      "mgh:DisassociateDiscoveredResource",
      "mgh:ListDiscoveredResources"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgh:*:*:progressUpdateStream/DMS/*"
    },
    {
     "Action":[
      "mgh:ListMigrationTasks",
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-07T17:51:53+00:00"
 },
 "AWSMigrationHubDiscoveryAccess":{
  "CreateDate":"2017-08-14T13:30:51+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "discovery:ListConfigurations",
      "discovery:DescribeConfigurations"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":"aws:migrationhub:source-id"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:image/*",
      "arn:aws:ec2:*:*:volume/*"
     ]
    },
    {
     "Action":"dms:AddTagsToResource",
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":"aws:migrationhub:source-id"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:dms:*:*:endpoint:*"
     ]
    },
    {
     "Action":[
      "ec2:DescribeInstanceAttribute"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-06T17:34:42+00:00"
 },
 "AWSMigrationHubFullAccess":{
  "CreateDate":"2017-08-14T14:02:54+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgh:*",
      "discovery:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"continuousexport.discovery.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/continuousexport.discovery.amazonaws.com/AWSServiceRoleForApplicationDiscoveryServiceContinuousExport*"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/continuousexport.discovery.amazonaws.com/AWSServiceRoleForApplicationDiscoveryServiceContinuousExport*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "migrationhub.amazonaws.com",
        "dmsintegration.migrationhub.amazonaws.com",
        "smsintegration.migrationhub.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-19T21:14:41+00:00"
 },
 "AWSMigrationHubOrchestratorConsoleFullAccess":{
  "CreateDate":"2022-04-20T02:26:28+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "migrationhub-orchestrator:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"MHO"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*",
     "Sid":"ListAllMyBuckets"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:GetBucketAcl",
      "s3:GetBucketLocation",
      "s3:ListBucket",
      "s3:ListBucketVersions",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::migrationhub-orchestrator-*",
      "arn:aws:s3:::migrationhub-orchestrator-*/*"
     ],
     "Sid":"S3MHO"
    },
    {
     "Action":[
      "secretsmanager:ListSecrets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ListSecrets"
    },
    {
     "Action":[
      "discovery:DescribeConfigurations",
      "discovery:ListConfigurations",
      "discovery:GetDiscoverySummary"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Configuration"
    },
    {
     "Action":[
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"GetHomeRegion"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeVpcs"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2Describe"
    },
    {
     "Action":[
      "kms:ListKeys",
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"KMS"
    },
    {
     "Action":[
      "iam:ListInstanceProfiles",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMListProfileRole"
    },
    {
     "Action":[
      "ecs:ListClusters"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ECS"
    },
    {
     "Action":[
      "account:ListRegions"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Account"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"migrationhub-orchestrator.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CreateServiceRole"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/migrationhub-orchestrator.amazonaws.com/AWSServiceRoleForMigrationHubOrchestrator*",
     "Sid":"GetRole"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-12-05T17:34:16+00:00"
 },
 "AWSMigrationHubOrchestratorInstanceRolePolicy":{
  "CreateDate":"2022-04-20T02:43:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:migrationhub-orchestrator-*"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::migrationhub-orchestrator-*",
      "arn:aws:s3:::aws-migrationhub-orchestrator-*/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-20T02:43:50+00:00"
 },
 "AWSMigrationHubOrchestratorPlugin":{
  "CreateDate":"2022-04-20T02:25:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:CreateBucket",
      "s3:PutObject",
      "s3:GetObject",
      "s3:GetBucketAcl"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::migrationhub-orchestrator-*"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    },
    {
     "Action":[
      "execute-api:Invoke",
      "execute-api:ManageConnections"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:execute-api:*:*:*/prod/*/put-log-data",
      "arn:aws:execute-api:*:*:*/prod/*/put-metric-data"
     ]
    },
    {
     "Action":[
      "migrationhub-orchestrator:RegisterPlugin",
      "migrationhub-orchestrator:GetMessage",
      "migrationhub-orchestrator:SendMessage"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:migrationhub-orchestrator:*:*:*"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:migrationhub-orchestrator-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-04-20T02:25:10+00:00"
 },
 "AWSMigrationHubOrchestratorServiceRolePolicy":{
  "CreateDate":"2022-04-20T02:24:04+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "discovery:DescribeConfigurations",
      "discovery:ListConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ApplicationDiscoveryService"
    },
    {
     "Action":[
      "launchwizard:ListProvisionedApps",
      "launchwizard:DescribeProvisionedApp",
      "launchwizard:ListDeployments",
      "launchwizard:GetDeployment"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LaunchWizard"
    },
    {
     "Action":[
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2instances"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:ModifyLaunchTemplate"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/AWSApplicationMigrationServiceManaged":"mgn.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ec2MGNLaunchTemplate"
    },
    {
     "Action":[
      "ec2:DescribeLaunchTemplates"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ec2LaunchTemplates"
    },
    {
     "Action":[
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"getHomeRegion"
    },
    {
     "Action":[
      "ssm:SendCommand",
      "ssm:GetCommandInvocation",
      "ssm:CancelCommand"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*::document/AWS-RunRemoteScript",
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:s3:::aws-migrationhub-orchestrator-*",
      "arn:aws:s3:::migrationhub-orchestrator-*"
     ],
     "Sid":"SSMcommand"
    },
    {
     "Action":[
      "ssm:DescribeInstanceInformation",
      "ssm:GetCommandInvocation"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"SSM"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::migrationhub-orchestrator-*",
      "arn:aws:s3:::migrationhub-orchestrator-*/*"
     ],
     "Sid":"s3GetObject"
    },
    {
     "Action":[
      "events:PutTargets",
      "events:DescribeRule",
      "events:DeleteRule",
      "events:PutRule",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:events:*:*:rule/MigrationHubOrchestratorManagedRule*",
     "Sid":"EventBridge"
    },
    {
     "Action":[
      "mgn:GetReplicationConfiguration",
      "mgn:GetLaunchConfiguration",
      "mgn:StartCutover",
      "mgn:FinalizeCutover",
      "mgn:StartTest",
      "mgn:UpdateReplicationConfiguration",
      "mgn:DescribeSourceServers",
      "mgn:MarkAsArchived",
      "mgn:ChangeServerLifeCycleState"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"MGN"
    },
    {
     "Action":[
      "ec2:DescribeImportImageTasks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ec2DescribeImportImage"
    },
    {
     "Action":"s3:ListBucket",
     "Condition":{
      "StringLike":{
       "s3:prefix":"migrationhub-orchestrator-vmie-*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*",
     "Sid":"s3ListBucket"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-04T18:25:12+00:00"
 },
 "AWSMigrationHubRefactorSpaces-EnvironmentsWithoutBridgesFullAccess":{
  "CreateDate":"2023-04-03T20:09:48+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "refactor-spaces:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RefactorSpaces"
    },
    {
     "Action":[
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcEndpointServiceConfigurations",
      "ec2:DescribeVpcs",
      "ec2:DescribeTags",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeInternetGateways"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2Describe"
    },
    {
     "Action":[
      "ec2:CreateVpcEndpointServiceConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VpcEndpointServiceConfigurationCreate"
    },
    {
     "Action":[
      "ec2:DeleteTags"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:environment-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2TagsDelete"
    },
    {
     "Action":"ec2:DeleteVpcEndpointServiceConfigurations",
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VpcEndpointServiceConfigurationDelete"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:CreateLoadBalancer"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:loadbalancer/net/refactor-spaces-nlb-*",
     "Sid":"ELBLoadBalancerCreate"
    },
    {
     "Action":[
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTags",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeListeners"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ELBDescribe"
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:CreateLoadBalancerListeners",
      "elasticloadbalancing:CreateListener",
      "elasticloadbalancing:DeleteListener",
      "elasticloadbalancing:DeleteTargetGroup"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/refactor-spaces:route-id":[
        "*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ELBModify"
    },
    {
     "Action":"elasticloadbalancing:DeleteLoadBalancer",
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:loadbalancer/net/refactor-spaces-nlb-*",
     "Sid":"ELBLoadBalancerDelete"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:CreateListener"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:route-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:*:elasticloadbalancing:*:*:loadbalancer/net/refactor-spaces-nlb-*",
      "arn:*:elasticloadbalancing:*:*:listener/net/refactor-spaces-nlb-*"
     ],
     "Sid":"ELBListenerCreate"
    },
    {
     "Action":"elasticloadbalancing:DeleteListener",
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:listener/net/refactor-spaces-nlb-*",
     "Sid":"ELBListenerDelete"
    },
    {
     "Action":[
      "elasticloadbalancing:DeleteTargetGroup",
      "elasticloadbalancing:RegisterTargets"
     ],
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:targetgroup/refactor-spaces-tg-*",
     "Sid":"ELBTargetGroupModify"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:CreateTargetGroup"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:route-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:targetgroup/refactor-spaces-tg-*",
     "Sid":"ELBTargetGroupCreate"
    },
    {
     "Action":[
      "apigateway:GET",
      "apigateway:DELETE",
      "apigateway:PATCH",
      "apigateway:POST",
      "apigateway:PUT",
      "apigateway:UpdateRestApiPolicy"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/restapis",
      "arn:aws:apigateway:*::/restapis/*",
      "arn:aws:apigateway:*::/vpclinks",
      "arn:aws:apigateway:*::/vpclinks/*",
      "arn:aws:apigateway:*::/tags",
      "arn:aws:apigateway:*::/tags/*"
     ],
     "Sid":"APIGatewayModify"
    },
    {
     "Action":"apigateway:GET",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/vpclinks",
      "arn:aws:apigateway:*::/vpclinks/*"
     ],
     "Sid":"APIGatewayVpcLinksGet"
    },
    {
     "Action":[
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"OrganizationDescribe"
    },
    {
     "Action":[
      "cloudformation:CreateStack"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudformationStackCreate"
    },
    {
     "Action":[
      "cloudformation:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/*",
     "Sid":"CloudformationStackTag"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"refactor-spaces.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CreateRefactorSpacesSLR"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"elasticloadbalancing.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CreateELBSLR"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-11T18:16:48+00:00"
 },
 "AWSMigrationHubRefactorSpaces-SSMAutomationPolicy":{
  "CreateDate":"2023-08-10T15:08:14+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:ModifyInstanceAttribute"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/refactor-spaces:ssm:optin":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:ModifyInstanceAttribute"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:security-group/*"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":"refactor-spaces:ssm:environment-id"
      },
      "StringEquals":{
       "aws:ResourceTag/refactor-spaces:ssm:optin":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":"ssm:GetParameters",
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/ManagedByAWSApplicationMigrationService-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-08-10T15:08:14+00:00"
 },
 "AWSMigrationHubRefactorSpacesFullAccess":{
  "CreateDate":"2021-11-29T07:12:55+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "refactor-spaces:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RefactorSpaces"
    },
    {
     "Action":[
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcEndpointServiceConfigurations",
      "ec2:DescribeVpcs",
      "ec2:DescribeTransitGatewayVpcAttachments",
      "ec2:DescribeTransitGateways",
      "ec2:DescribeTags",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeInternetGateways"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2Describe"
    },
    {
     "Action":[
      "ec2:CreateTransitGateway",
      "ec2:CreateSecurityGroup",
      "ec2:CreateTransitGatewayVpcAttachment"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:environment-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RequestTagTransitGatewayCreate"
    },
    {
     "Action":[
      "ec2:CreateTransitGateway",
      "ec2:CreateSecurityGroup",
      "ec2:CreateTransitGatewayVpcAttachment"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:environment-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ResourceTagTransitGatewayCreate"
    },
    {
     "Action":[
      "ec2:CreateVpcEndpointServiceConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VpcEndpointServiceConfigurationCreate"
    },
    {
     "Action":[
      "ec2:DeleteTransitGateway",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteTransitGatewayVpcAttachment",
      "ec2:CreateRoute",
      "ec2:DeleteRoute",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:environment-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2NetworkingModify"
    },
    {
     "Action":"ec2:DeleteVpcEndpointServiceConfigurations",
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VpcEndpointServiceConfigurationDelete"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:CreateLoadBalancer"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:loadbalancer/net/refactor-spaces-nlb-*",
     "Sid":"ELBLoadBalancerCreate"
    },
    {
     "Action":[
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTags",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeListeners"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ELBDescribe"
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:CreateLoadBalancerListeners",
      "elasticloadbalancing:CreateListener",
      "elasticloadbalancing:DeleteListener",
      "elasticloadbalancing:DeleteTargetGroup"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/refactor-spaces:route-id":[
        "*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ELBModify"
    },
    {
     "Action":"elasticloadbalancing:DeleteLoadBalancer",
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:loadbalancer/net/refactor-spaces-nlb-*",
     "Sid":"ELBLoadBalancerDelete"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:CreateListener"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:route-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:*:elasticloadbalancing:*:*:loadbalancer/net/refactor-spaces-nlb-*",
      "arn:*:elasticloadbalancing:*:*:listener/net/refactor-spaces-nlb-*"
     ],
     "Sid":"ELBListenerCreate"
    },
    {
     "Action":"elasticloadbalancing:DeleteListener",
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:listener/net/refactor-spaces-nlb-*",
     "Sid":"ELBListenerDelete"
    },
    {
     "Action":[
      "elasticloadbalancing:DeleteTargetGroup",
      "elasticloadbalancing:RegisterTargets"
     ],
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:targetgroup/refactor-spaces-tg-*",
     "Sid":"ELBTargetGroupModify"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:CreateTargetGroup"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:route-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:targetgroup/refactor-spaces-tg-*",
     "Sid":"ELBTargetGroupCreate"
    },
    {
     "Action":[
      "apigateway:GET",
      "apigateway:DELETE",
      "apigateway:PATCH",
      "apigateway:POST",
      "apigateway:PUT",
      "apigateway:UpdateRestApiPolicy"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/restapis",
      "arn:aws:apigateway:*::/restapis/*",
      "arn:aws:apigateway:*::/vpclinks",
      "arn:aws:apigateway:*::/vpclinks/*",
      "arn:aws:apigateway:*::/tags",
      "arn:aws:apigateway:*::/tags/*"
     ],
     "Sid":"APIGatewayModify"
    },
    {
     "Action":"apigateway:GET",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/vpclinks",
      "arn:aws:apigateway:*::/vpclinks/*"
     ],
     "Sid":"APIGatewayVpcLinksGet"
    },
    {
     "Action":[
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"OrganizationDescribe"
    },
    {
     "Action":[
      "cloudformation:CreateStack"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudformationStackCreate"
    },
    {
     "Action":[
      "cloudformation:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/*",
     "Sid":"CloudformationStackTag"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"refactor-spaces.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CreateRefactorSpacesSLR"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"elasticloadbalancing.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CreateELBSLR"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-11T17:45:46+00:00"
 },
 "AWSMigrationHubRefactorSpacesServiceRolePolicy":{
  "CreateDate":"2021-11-29T06:50:15+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeVpcEndpointServiceConfigurations",
      "ec2:DescribeTransitGatewayVpcAttachments",
      "elasticloadbalancing:DescribeTargetHealth",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeTargetGroups",
      "ram:GetResourceShareAssociations"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteTransitGatewayVpcAttachment",
      "ec2:CreateRoute",
      "ec2:DeleteRoute",
      "ec2:DeleteTags",
      "ram:DeleteResourceShare",
      "ram:AssociateResourceShare",
      "ram:DisassociateResourceShare"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:environment-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:DeleteVpcEndpointServiceConfigurations",
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "elasticloadbalancing:RegisterTargets",
      "elasticloadbalancing:CreateLoadBalancerListeners",
      "elasticloadbalancing:CreateListener",
      "elasticloadbalancing:DeleteListener",
      "elasticloadbalancing:DeleteTargetGroup"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/refactor-spaces:route-id":[
        "*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "apigateway:PUT",
      "apigateway:POST",
      "apigateway:GET",
      "apigateway:PATCH",
      "apigateway:DELETE"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:application-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/restapis",
      "arn:aws:apigateway:*::/restapis/*",
      "arn:aws:apigateway:*::/vpclinks/*",
      "arn:aws:apigateway:*::/tags",
      "arn:aws:apigateway:*::/tags/*"
     ]
    },
    {
     "Action":"apigateway:GET",
     "Effect":"Allow",
     "Resource":"arn:aws:apigateway:*::/vpclinks/*"
    },
    {
     "Action":"elasticloadbalancing:DeleteLoadBalancer",
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:loadbalancer/net/refactor-spaces-nlb-*"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:CreateListener"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:route-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:*:elasticloadbalancing:*:*:loadbalancer/net/refactor-spaces-nlb-*",
      "arn:*:elasticloadbalancing:*:*:listener/net/refactor-spaces-nlb-*"
     ]
    },
    {
     "Action":"elasticloadbalancing:DeleteListener",
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:listener/net/refactor-spaces-nlb-*"
    },
    {
     "Action":[
      "elasticloadbalancing:DeleteTargetGroup",
      "elasticloadbalancing:RegisterTargets"
     ],
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:targetgroup/refactor-spaces-tg-*"
    },
    {
     "Action":[
      "elasticloadbalancing:DeregisterTargets"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/refactor-spaces:route-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:targetgroup/refactor-spaces-tg-*"
    },
    {
     "Action":[
      "elasticloadbalancing:AddTags",
      "elasticloadbalancing:CreateTargetGroup"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/refactor-spaces:route-id":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:elasticloadbalancing:*:*:targetgroup/refactor-spaces-tg-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-07-20T15:57:53+00:00"
 },
 "AWSMigrationHubSMSAccess":{
  "CreateDate":"2017-08-14T13:57:54+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "mgh:CreateProgressUpdateStream"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgh:*:*:progressUpdateStream/SMS"
    },
    {
     "Action":[
      "mgh:AssociateCreatedArtifact",
      "mgh:DescribeMigrationTask",
      "mgh:DisassociateCreatedArtifact",
      "mgh:ImportMigrationTask",
      "mgh:ListCreatedArtifacts",
      "mgh:NotifyMigrationTaskState",
      "mgh:PutResourceAttributes",
      "mgh:NotifyApplicationState",
      "mgh:DescribeApplicationState",
      "mgh:AssociateDiscoveredResource",
      "mgh:DisassociateDiscoveredResource",
      "mgh:ListDiscoveredResources"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:mgh:*:*:progressUpdateStream/SMS/*"
    },
    {
     "Action":[
      "mgh:ListMigrationTasks",
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-07T18:01:22+00:00"
 },
 "AWSMigrationHubStrategyCollector":{
  "CreateDate":"2021-10-19T20:15:15+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject",
      "s3:GetBucketAcl",
      "s3:CreateBucket",
      "s3:PutEncryptionConfiguration",
      "s3:PutBucketPublicAccessBlock",
      "s3:PutBucketVersioning",
      "s3:PutLifecycleConfiguration",
      "s3:ListBucket",
      "s3:GetBucketLocation"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::migrationhub-strategy-*",
     "Sid":"MHSRAllowS3Resources"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*",
     "Sid":"MHSRAllowS3ListBucket"
    },
    {
     "Action":[
      "application-transformation:PutMetricData",
      "application-transformation:PutLogData",
      "application-transformation:StartPortingCompatibilityAssessment",
      "application-transformation:GetPortingCompatibilityAssessment",
      "application-transformation:StartPortingRecommendationAssessment",
      "application-transformation:GetPortingRecommendationAssessment"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"MHSRAllowMetricsAndLogs"
    },
    {
     "Action":[
      "execute-api:Invoke",
      "execute-api:ManageConnections"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:execute-api:*:*:*/prod/*/put-log-data",
      "arn:aws:execute-api:*:*:*/prod/*/put-metric-data"
     ],
     "Sid":"MHSRAllowExecuteAPI"
    },
    {
     "Action":[
      "migrationhub-strategy:RegisterCollector",
      "migrationhub-strategy:GetAntiPattern",
      "migrationhub-strategy:GetMessage",
      "migrationhub-strategy:SendMessage",
      "migrationhub-strategy:ListAntiPatterns",
      "migrationhub-strategy:ListJarArtifacts",
      "migrationhub-strategy:UpdateCollectorConfiguration",
      "migrationhub-strategy:PutLogData",
      "migrationhub-strategy:PutMetricData"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:migrationhub-strategy:*:*:*",
     "Sid":"MHSRAllowCollectorAPI"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:migrationhub-strategy-*",
     "Sid":"MHSRAllowSecretsManager"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-01T16:21:02+00:00"
 },
 "AWSMigrationHubStrategyConsoleFullAccess":{
  "CreateDate":"2021-10-19T20:13:26+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "migrationhub-strategy:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:CreateBucket",
      "s3:PutEncryptionConfiguration",
      "s3:PutBucketPublicAccessBlock",
      "s3:PutBucketPolicy",
      "s3:PutBucketVersioning",
      "s3:PutLifecycleConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::migrationhub-strategy-*"
    },
    {
     "Action":[
      "secretsmanager:ListSecrets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "discovery:GetDiscoverySummary",
      "discovery:DescribeTags",
      "discovery:DescribeConfigurations",
      "discovery:ListConfigurations"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"migrationhub-strategy.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/migrationhub-strategy.amazonaws.com/AWSMigrationHubStrategyServiceRolePolicy*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-11-09T00:00:06+00:00"
 },
 "AWSMigrationHubStrategyServiceRolePolicy":{
  "CreateDate":"2021-10-19T20:02:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "discovery:ListConfigurations",
      "discovery:DescribeConfigurations",
      "mgh:GetHomeRegion"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"permissionsForAds"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*"
    },
    {
     "Action":[
      "s3:GetBucketAcl",
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:PutObject",
      "s3:PutObjectAcl"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::migrationhub-strategy-*",
     "Sid":"permissionsForS3"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-19T20:02:37+00:00"
 },
 "AWSNetworkFirewallServiceRolePolicy":{
  "CreateDate":"2020-11-17T17:17:26+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:CreateVpcEndpoint",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeInstances",
      "ec2:DescribeNetworkInterfaces"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"acm:DescribeCertificate",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"resource-groups:ListGroupResources",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"tag:GetResources",
     "Condition":{
      "StringEquals":{
       "aws:CalledViaLast":"resource-groups.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/AWSNetworkFirewallManaged":"true",
       "ec2:CreateAction":"CreateVpcEndpoint"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:vpc-endpoint/*"
    },
    {
     "Action":[
      "ec2:DeleteVpcEndpoints"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/AWSNetworkFirewallManaged":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-30T17:19:09+00:00"
 },
 "AWSNetworkManagerCloudWANServiceRolePolicy":{
  "CreateDate":"2022-07-12T12:17:49+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateTransitGatewayRouteTableAnnouncement",
      "ec2:DeleteTransitGatewayRouteTableAnnouncement",
      "ec2:EnableTransitGatewayRouteTablePropagation",
      "ec2:DisableTransitGatewayRouteTablePropagation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-07-12T12:17:49+00:00"
 },
 "AWSNetworkManagerFullAccess":{
  "CreateDate":"2019-12-03T17:37:58+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"networkmanager:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "networkmanager.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-03T17:37:58+00:00"
 },
 "AWSNetworkManagerReadOnlyAccess":{
  "CreateDate":"2019-12-03T17:35:05+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "networkmanager:Describe*",
      "networkmanager:Get*",
      "networkmanager:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-03T17:35:05+00:00"
 },
 "AWSNetworkManagerServiceRolePolicy":{
  "CreateDate":"2019-12-03T14:03:35+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "directconnect:DescribeDirectConnectGateways",
      "directconnect:DescribeConnections",
      "directconnect:DescribeDirectConnectGatewayAttachments",
      "directconnect:DescribeLocations",
      "directconnect:DescribeVirtualInterfaces",
      "ec2:DescribeCustomerGateways",
      "ec2:DescribeTransitGatewayAttachments",
      "ec2:DescribeTransitGatewayRouteTables",
      "ec2:DescribeTransitGateways",
      "ec2:DescribeVpnConnections",
      "ec2:DescribeVpcs",
      "ec2:GetTransitGatewayRouteTableAssociations",
      "ec2:GetTransitGatewayRouteTablePropagations",
      "ec2:SearchTransitGatewayRoutes",
      "ec2:DescribeTransitGatewayPeeringAttachments",
      "ec2:DescribeTransitGatewayConnects",
      "ec2:DescribeTransitGatewayConnectPeers",
      "ec2:DescribeRegions",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListDelegatedAdministrators",
      "ec2:DescribeTransitGatewayRouteTableAnnouncements",
      "ec2:DescribeTransitGatewayPolicyTables",
      "ec2:GetTransitGatewayPolicyTableAssociations",
      "ec2:GetTransitGatewayPolicyTableEntries"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-07-27T19:41:29+00:00"
 },
 "AWSOpsWorksCMInstanceProfileRole":{
  "CreateDate":"2016-11-24T09:48:22+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStackResource",
      "cloudformation:SignalResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:AbortMultipartUpload",
      "s3:DeleteObject",
      "s3:GetObject",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "s3:ListMultipartUploadParts",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::aws-opsworks-cm-*"
    },
    {
     "Action":"acm:GetCertificate",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"secretsmanager:GetSecretValue",
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:opsworks-cm!aws-opsworks-cm-secrets-*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-23T17:34:03+00:00"
 },
 "AWSOpsWorksCMServiceRole":{
  "CreateDate":"2016-11-24T09:49:46+00:00",
  "DefaultVersionId":"v14",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:CreateBucket",
      "s3:DeleteObject",
      "s3:DeleteBucket",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:PutBucketPolicy",
      "s3:PutObject",
      "s3:GetBucketTagging",
      "s3:PutBucketTagging"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-opsworks-cm-*"
     ]
    },
    {
     "Action":[
      "tag:UntagResources",
      "tag:TagResources"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ssm:DescribeInstanceInformation",
      "ssm:GetCommandInvocation",
      "ssm:ListCommandInvocations",
      "ssm:ListCommands"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Condition":{
      "StringLike":{
       "ssm:resourceTag/aws:cloudformation:stack-name":"aws-opsworks-cm-*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*::document/*",
      "arn:aws:s3:::aws-opsworks-cm-*"
     ]
    },
    {
     "Action":[
      "ec2:AllocateAddress",
      "ec2:AssociateAddress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:CreateImage",
      "ec2:CreateSecurityGroup",
      "ec2:CreateSnapshot",
      "ec2:CreateTags",
      "ec2:DeleteSecurityGroup",
      "ec2:DeleteSnapshot",
      "ec2:DeregisterImage",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAddresses",
      "ec2:DescribeImages",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstances",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DisassociateAddress",
      "ec2:ReleaseAddress",
      "ec2:RunInstances",
      "ec2:StopInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances",
      "ec2:RebootInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-name":"aws-opsworks-cm-*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "opsworks-cm:DeleteServer",
      "opsworks-cm:StartMaintenance"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:opsworks-cm:*:*:server/*"
     ]
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStackResources",
      "cloudformation:DescribeStacks",
      "cloudformation:UpdateStack"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/aws-opsworks-cm-*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-opsworks-cm-*",
      "arn:aws:iam::*:role/service-role/aws-opsworks-cm-*"
     ]
    },
    {
     "Action":[
      "acm:DeleteCertificate",
      "acm:ImportCertificate"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "secretsmanager:CreateSecret",
      "secretsmanager:GetSecretValue",
      "secretsmanager:UpdateSecret",
      "secretsmanager:DeleteSecret",
      "secretsmanager:TagResource",
      "secretsmanager:UntagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:opsworks-cm!aws-opsworks-cm-secrets-*"
    },
    {
     "Action":"ec2:DeleteTags",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ec2:*:*:elastic-ip/*",
      "arn:aws:ec2:*:*:security-group/*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-04-23T17:32:13+00:00"
 },
 "AWSOpsWorksCloudWatchLogs":{
  "CreateDate":"2017-03-30T17:47:19+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:DescribeLogStreams"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-03-30T17:47:19+00:00"
 },
 "AWSOpsWorksInstanceRegistration":{
  "CreateDate":"2016-06-03T14:23:15+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "opsworks:DescribeStackProvisioningParameters",
      "opsworks:DescribeStacks",
      "opsworks:RegisterInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2016-06-03T14:23:15+00:00"
 },
 "AWSOpsWorksRegisterCLI_EC2":{
  "CreateDate":"2019-06-18T15:56:17+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "opsworks:AssignInstance",
      "opsworks:CreateLayer",
      "opsworks:DeregisterInstance",
      "opsworks:DescribeInstances",
      "opsworks:DescribeStackProvisioningParameters",
      "opsworks:DescribeStacks",
      "opsworks:UnassignInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-18T15:56:17+00:00"
 },
 "AWSOpsWorksRegisterCLI_OnPremises":{
  "CreateDate":"2019-06-18T15:33:16+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "opsworks:AssignInstance",
      "opsworks:CreateLayer",
      "opsworks:DeregisterInstance",
      "opsworks:DescribeInstances",
      "opsworks:DescribeStackProvisioningParameters",
      "opsworks:DescribeStacks",
      "opsworks:UnassignInstance"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:CreateGroup",
      "iam:AddUserToGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:group/AWS/OpsWorks/OpsWorks-*"
     ]
    },
    {
     "Action":[
      "iam:CreateUser",
      "iam:CreateAccessKey"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:user/AWS/OpsWorks/OpsWorks-*"
     ]
    },
    {
     "Action":[
      "iam:AttachUserPolicy"
     ],
     "Condition":{
      "ArnEquals":{
       "iam:PolicyARN":"arn:aws:iam::aws:policy/AWSOpsWorksInstanceRegistration"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:user/AWS/OpsWorks/OpsWorks-*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-18T15:33:16+00:00"
 },
 "AWSOpsWorks_FullAccess":{
  "CreateDate":"2021-01-22T16:29:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:GetMetricStatistics",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeInstances",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "elasticloadbalancing:DescribeInstanceHealth",
      "elasticloadbalancing:DescribeLoadBalancers",
      "iam:GetRolePolicy",
      "iam:ListInstanceProfiles",
      "iam:ListRoles",
      "iam:ListUsers",
      "opsworks:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"opsworks.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-22T16:29:08+00:00"
 },
 "AWSOrganizationsFullAccess":{
  "CreateDate":"2018-11-06T20:31:57+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":"organizations:*",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSOrganizationsFullAccess"
    },
    {
     "Action":[
      "account:PutAlternateContact",
      "account:DeleteAlternateContact",
      "account:GetAlternateContact",
      "account:GetContactInformation",
      "account:PutContactInformation",
      "account:ListRegions",
      "account:EnableRegion",
      "account:DisableRegion"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSOrganizationsFullAccessAccount"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"organizations.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSOrganizationsFullAccessCreateSLR"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-02-06T17:49:01+00:00"
 },
 "AWSOrganizationsReadOnlyAccess":{
  "CreateDate":"2018-11-06T20:32:38+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:Describe*",
      "organizations:List*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSOrganizationsReadOnly"
    },
    {
     "Action":[
      "account:GetAlternateContact",
      "account:GetContactInformation",
      "account:ListRegions",
      "account:GetRegionOptStatus",
      "account:GetPrimaryEmail"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSOrganizationsReadOnlyAccount"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-07T21:32:16+00:00"
 },
 "AWSOrganizationsServiceTrustPolicy":{
  "CreateDate":"2017-10-10T23:04:07+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:DeleteRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/organizations.amazonaws.com/*"
     ],
     "Sid":"AllowDeletionOfServiceLinkedRoleForOrganizations"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowCreationOfServiceLinkedRoles"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-11-01T06:01:18+00:00"
 },
 "AWSOutpostsAuthorizeServerPolicy":{
  "CreateDate":"2023-01-04T19:23:22+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "outposts:StartConnection",
      "outposts:GetConnection"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-01-04T19:23:22+00:00"
 },
 "AWSOutpostsServiceRolePolicy":{
  "CreateDate":"2020-11-09T22:55:56+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeSecurityGroups",
      "ec2:CreateNetworkInterface",
      "ec2:CreateSecurityGroup"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-11-09T22:55:56+00:00"
 },
 "AWSPCSServiceRolePolicy":{
  "CreateDate":"2024-08-27T16:01:15+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterface"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSPCSManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*",
     "Sid":"PermissionsToCreatePCSNetworkInterfaces"
    },
    {
     "Action":[
      "ec2:CreateNetworkInterface"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:security-group/*"
     ],
     "Sid":"PermissionsToCreatePCSNetworkInterfacesInSubnet"
    },
    {
     "Action":[
      "ec2:DeleteNetworkInterface",
      "ec2:CreateNetworkInterfacePermission"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSPCSManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:network-interface/*",
     "Sid":"PermissionsToManagePCSNetworkInterfaces"
    },
    {
     "Action":[
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeImages",
      "ec2:DescribeImageAttribute"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PermissionsToDescribePCSResources"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplate"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSPCSManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"PermissionsToCreatePCSLaunchTemplates"
    },
    {
     "Action":[
      "ec2:DeleteLaunchTemplate",
      "ec2:DeleteLaunchTemplateVersions",
      "ec2:CreateLaunchTemplateVersion"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSPCSManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:launch-template/*",
     "Sid":"PermissionsToManagePCSLaunchTemplates"
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/AWSPCSManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"PermissionsToTerminatePCSManagedInstances"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/*/AWSPCS*",
      "arn:aws:iam::*:role/AWSPCS*",
      "arn:aws:iam::*:role/aws-pcs/*",
      "arn:aws:iam::*:role/*/aws-pcs/*"
     ],
     "Sid":"PermissionsToPassRoleToEC2"
    },
    {
     "Action":[
      "ec2:RunInstances",
      "ec2:CreateFleet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:key-pair/*",
      "arn:aws:ec2:*:*:launch-template/*",
      "arn:aws:ec2:*:*:placement-group/*",
      "arn:aws:ec2:*:*:capacity-reservation/*",
      "arn:aws:resource-groups:*:*:group/*",
      "arn:aws:ec2:*:*:fleet/*",
      "arn:aws:ec2:*:*:spot-instances-request/*"
     ],
     "Sid":"PermissionsToControlClusterInstanceAttributes"
    },
    {
     "Action":[
      "ec2:RunInstances",
      "ec2:CreateFleet"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/AWSPCSManaged":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ],
     "Sid":"PermissionsToProvisionClusterInstances"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":[
        "RunInstances",
        "CreateLaunchTemplate",
        "CreateFleet",
        "CreateNetworkInterface"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PermissionsToTagPCSResources"
    },
    {
     "Action":"cloudwatch:PutMetricData",
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"AWS/PCS"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PermissionsToPublishMetrics"
    },
    {
     "Action":[
      "secretsmanager:DescribeSecret",
      "secretsmanager:GetSecretValue",
      "secretsmanager:PutSecretValue",
      "secretsmanager:UpdateSecretVersionStage",
      "secretsmanager:DeleteSecret"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}",
       "secretsmanager:ResourceTag/aws:secretsmanager:owningService":"pcs"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:pcs!*",
     "Sid":"PermissionsToManageSecret"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-08-27T16:01:15+00:00"
 },
 "AWSPanoramaApplianceRolePolicy":{
  "CreateDate":"2020-12-01T13:13:18+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/panorama_device*:log-stream:*",
     "Sid":"PanoramaDeviceCreateLogStream"
    },
    {
     "Action":"logs:CreateLogGroup",
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/panorama_device*",
     "Sid":"PanoramaDeviceCreateLogGroup"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-01T13:13:18+00:00"
 },
 "AWSPanoramaApplianceServiceRolePolicy":{
  "CreateDate":"2021-10-20T12:14:03+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/panorama_device*:log-stream:*",
      "arn:aws:logs:*:*:log-group:/aws/panorama/devices/*"
     ],
     "Sid":"PanoramaDeviceCreateLogStream"
    },
    {
     "Action":"logs:CreateLogGroup",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/panorama_device*",
      "arn:aws:logs:*:*:log-group:/aws/panorama/devices/*"
     ],
     "Sid":"PanoramaDeviceCreateLogGroup"
    },
    {
     "Action":"cloudwatch:PutMetricData",
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"PanoramaDeviceMetrics"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PanoramaDevicePutMetric"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:ListBucket",
      "s3:GetObjectVersion"
     ],
     "Condition":{
      "StringLike":{
       "s3:DataAccessPointArn":"arn:aws:s3:*:*:accesspoint/panorama*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*-nodepackage-store-*",
      "arn:aws:s3:::*-application-payload-store-*",
      "arn:aws:s3:*:*:accesspoint/panorama*"
     ],
     "Sid":"PanoramaDeviceS3Access"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-01-17T21:32:36+00:00"
 },
 "AWSPanoramaFullAccess":{
  "CreateDate":"2020-12-01T13:12:47+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "panorama:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:PutObject",
      "s3:PutObjectAcl",
      "s3:DeleteObject",
      "s3:GetObject",
      "s3:ListBucket"
     ],
     "Condition":{
      "StringLike":{
       "s3:DataAccessPointArn":"arn:aws:s3:*:*:accesspoint/panorama*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue",
      "secretsmanager:DescribeSecret",
      "secretsmanager:ListSecretVersionIds",
      "secretsmanager:PutSecretValue",
      "secretsmanager:UpdateSecret"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:secretsmanager:*:*:secret:panorama*",
      "arn:aws:secretsmanager:*:*:secret:Panorama*"
     ]
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"panorama.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "logs:Describe*",
      "logs:Get*",
      "logs:List*",
      "logs:StartQuery",
      "logs:StopQuery",
      "logs:TestMetricFilter",
      "logs:FilterLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/panorama_device*:log-stream:*",
      "arn:aws:logs:*:*:log-group:/aws/panorama/devices/*"
     ]
    },
    {
     "Action":[
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:*"
     ]
    },
    {
     "Action":[
      "cloudwatch:ListMetrics",
      "cloudwatch:GetMetricData",
      "cloudwatch:GetMetricStatistics"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:ListRoles",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"panorama.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-01-12T21:21:04+00:00"
 },
 "AWSPanoramaGreengrassGroupRolePolicy":{
  "CreateDate":"2020-12-01T13:10:22+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:ListBucket",
      "s3:GetBucket*",
      "s3:GetObject",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*aws-panorama*"
     ],
     "Sid":"PanoramaS3Access"
    },
    {
     "Action":"cloudwatch:PutDashboard",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudwatch::*:dashboard/panorama*"
     ],
     "Sid":"PanoramaCLoudWatchPutDashboard"
    },
    {
     "Action":"cloudwatch:PutMetricData",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PanoramaCloudWatchPutMetricData"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents",
      "logs:CreateLogGroup"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/greengrass/*",
     "Sid":"PanoramaGreenGrassCloudWatchAccess"
    },
    {
     "Action":[
      "panorama:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-01-06T19:30:35+00:00"
 },
 "AWSPanoramaSageMakerRolePolicy":{
  "CreateDate":"2020-12-01T13:13:54+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject",
      "s3:GetBucket*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*aws-panorama*"
     ],
     "Sid":"PanoramaSageMakerS3Access"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-01T13:13:54+00:00"
 },
 "AWSPanoramaServiceLinkedRolePolicy":{
  "CreateDate":"2021-10-20T12:12:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:CreateThing",
      "iot:DeleteThing",
      "iot:DeleteThingShadow",
      "iot:DescribeThing",
      "iot:GetThingShadow",
      "iot:UpdateThing",
      "iot:UpdateThingShadow"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/panorama*"
     ],
     "Sid":"PanoramaIoTThingAccess"
    },
    {
     "Action":[
      "iot:AttachThingPrincipal",
      "iot:DetachThingPrincipal",
      "iot:UpdateCertificate",
      "iot:DeleteCertificate",
      "iot:AttachPrincipalPolicy",
      "iot:DetachPrincipalPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/panorama*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"PanoramaIoTCertificateAccess"
    },
    {
     "Action":[
      "iot:CreateKeysAndCertificate"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaIoTCreateCertificateAccess"
    },
    {
     "Action":[
      "iot:CreatePolicy",
      "iot:CreatePolicyVersion",
      "iot:AttachPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:policy/panorama*"
     ],
     "Sid":"PanoramaIoTCreatePolicyAndVersionAccess"
    },
    {
     "Action":[
      "iot:DescribeJobExecution",
      "iot:CreateJob",
      "iot:DeleteJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:job/panorama*",
      "arn:aws:iot:*:*:thing/panorama*"
     ],
     "Sid":"PanoramaIoTJobAccess"
    },
    {
     "Action":[
      "iot:DescribeEndpoint"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaIoTEndpointAccess"
    },
    {
     "Action":[
      "panorama:Describe*",
      "panorama:List*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaReadOnlyAccess"
    },
    {
     "Action":[
      "secretsmanager:GetSecretValue",
      "secretsmanager:DescribeSecret",
      "secretsmanager:CreateSecret",
      "secretsmanager:ListSecretVersionIds",
      "secretsmanager:DeleteSecret"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:secretsmanager:*:*:secret:panorama*",
      "arn:aws:secretsmanager:*:*:secret:Panorama*"
     ],
     "Sid":"SecretsManagerPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-10-20T12:12:50+00:00"
 },
 "AWSPanoramaServiceRolePolicy":{
  "CreateDate":"2020-12-01T13:14:43+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iot:CreateThing",
      "iot:DeleteThing",
      "iot:DeleteThingShadow",
      "iot:DescribeThing",
      "iot:GetThingShadow",
      "iot:UpdateThing",
      "iot:UpdateThingShadow"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/panorama*"
     ],
     "Sid":"PanoramaIoTThingAccess"
    },
    {
     "Action":[
      "iot:AttachThingPrincipal",
      "iot:DetachThingPrincipal",
      "iot:UpdateCertificate",
      "iot:DeleteCertificate",
      "iot:AttachPrincipalPolicy",
      "iot:DetachPrincipalPolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:thing/panorama*",
      "arn:aws:iot:*:*:cert/*"
     ],
     "Sid":"PanoramaIoTCertificateAccess"
    },
    {
     "Action":[
      "iot:CreateKeysAndCertificate",
      "iot:CreatePolicy"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaIoTCreateCertificateAndPolicyAccess"
    },
    {
     "Action":[
      "iot:CreatePolicyVersion"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:policy/panorama*"
     ],
     "Sid":"PanoramaIoTCreatePolicyVersionAccess"
    },
    {
     "Action":[
      "iot:DescribeJobExecution",
      "iot:CreateJob",
      "iot:DeleteJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:job/panorama*",
      "arn:aws:iot:*:*:thing/panorama*"
     ],
     "Sid":"PanoramaIoTJobAccess"
    },
    {
     "Action":[
      "iot:DescribeEndpoint"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaIoTEndpointAccess"
    },
    {
     "Action":[
      "panorama:Describe*",
      "panorama:List*",
      "panorama:Get*"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaAccess"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject",
      "s3:DeleteObject",
      "s3:DeleteBucket",
      "s3:ListBucket",
      "s3:GetBucket*",
      "s3:CreateBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*aws-panorama*"
     ],
     "Sid":"PanoramaS3Access"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "sagemaker.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSPanoramaSageMakerRole",
      "arn:aws:iam::*:role/service-role/AWSPanoramaSageMakerRole"
     ],
     "Sid":"PanoramaIAMPassSageMakerRoleAccess"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "greengrass.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSPanoramaGreengrassGroupRole",
      "arn:aws:iam::*:role/service-role/AWSPanoramaGreengrassGroupRole",
      "arn:aws:iam::*:role/AWSPanoramaGreengrassRole",
      "arn:aws:iam::*:role/service-role/AWSPanoramaGreengrassRole"
     ],
     "Sid":"PanoramaIAMPassGreengrassRoleAccess"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEqualsIfExists":{
       "iam:PassedToService":"iot.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWSPanoramaApplianceRole",
      "arn:aws:iam::*:role/service-role/AWSPanoramaApplianceRole"
     ],
     "Sid":"PanoramaIAMPassIoTRoleAccess"
    },
    {
     "Action":[
      "greengrass:AssociateRoleToGroup",
      "greengrass:AssociateServiceRoleToAccount",
      "greengrass:CreateResourceDefinition",
      "greengrass:CreateResourceDefinitionVersion",
      "greengrass:CreateCoreDefinition",
      "greengrass:CreateCoreDefinitionVersion",
      "greengrass:CreateDeployment",
      "greengrass:CreateFunctionDefinition",
      "greengrass:CreateFunctionDefinitionVersion",
      "greengrass:CreateGroup",
      "greengrass:CreateGroupCertificateAuthority",
      "greengrass:CreateGroupVersion",
      "greengrass:CreateLoggerDefinition",
      "greengrass:CreateLoggerDefinitionVersion",
      "greengrass:CreateSubscriptionDefinition",
      "greengrass:CreateSubscriptionDefinitionVersion",
      "greengrass:DeleteCoreDefinition",
      "greengrass:DeleteFunctionDefinition",
      "greengrass:DeleteResourceDefinition",
      "greengrass:DeleteGroup",
      "greengrass:DeleteLoggerDefinition",
      "greengrass:DeleteSubscriptionDefinition",
      "greengrass:DisassociateRoleFromGroup",
      "greengrass:DisassociateServiceRoleFromAccount",
      "greengrass:GetAssociatedRole",
      "greengrass:GetConnectivityInfo",
      "greengrass:GetCoreDefinition",
      "greengrass:GetCoreDefinitionVersion",
      "greengrass:GetDeploymentStatus",
      "greengrass:GetDeviceDefinition",
      "greengrass:GetDeviceDefinitionVersion",
      "greengrass:GetFunctionDefinition",
      "greengrass:GetFunctionDefinitionVersion",
      "greengrass:GetGroup",
      "greengrass:GetGroupCertificateAuthority",
      "greengrass:GetGroupCertificateConfiguration",
      "greengrass:GetGroupVersion",
      "greengrass:GetLoggerDefinition",
      "greengrass:GetLoggerDefinitionVersion",
      "greengrass:GetResourceDefinition",
      "greengrass:GetServiceRoleForAccount",
      "greengrass:GetSubscriptionDefinition",
      "greengrass:GetSubscriptionDefinitionVersion",
      "greengrass:ListCoreDefinitionVersions",
      "greengrass:ListCoreDefinitions",
      "greengrass:ListDeployments",
      "greengrass:ListDeviceDefinitionVersions",
      "greengrass:ListDeviceDefinitions",
      "greengrass:ListFunctionDefinitionVersions",
      "greengrass:ListFunctionDefinitions",
      "greengrass:ListGroupCertificateAuthorities",
      "greengrass:ListGroupVersions",
      "greengrass:ListGroups",
      "greengrass:ListLoggerDefinitionVersions",
      "greengrass:ListLoggerDefinitions",
      "greengrass:ListSubscriptionDefinitionVersions",
      "greengrass:ListSubscriptionDefinitions",
      "greengrass:ResetDeployments",
      "greengrass:UpdateConnectivityInfo",
      "greengrass:UpdateCoreDefinition",
      "greengrass:UpdateDeviceDefinition",
      "greengrass:UpdateFunctionDefinition",
      "greengrass:UpdateGroup",
      "greengrass:UpdateGroupCertificateConfiguration",
      "greengrass:UpdateLoggerDefinition",
      "greengrass:UpdateSubscriptionDefinition",
      "greengrass:UpdateResourceDefinition"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaGreenGrassAccess"
    },
    {
     "Action":[
      "lambda:GetFunction",
      "lambda:GetFunctionConfiguration",
      "lambda:ListFunctions",
      "lambda:ListVersionsByFunction"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:*"
     ],
     "Sid":"PanoramaLambdaUsersFunctionAccess"
    },
    {
     "Action":[
      "sagemaker:CreateTrainingJob",
      "sagemaker:StopTrainingJob",
      "sagemaker:CreateCompilationJob",
      "sagemaker:DescribeCompilationJob",
      "sagemaker:StopCompilationJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sagemaker:*:*:training-job/panorama*",
      "arn:aws:sagemaker:*:*:compilation-job/panorama*"
     ],
     "Sid":"PanoramaSageMakerWriteAccess"
    },
    {
     "Action":[
      "sagemaker:ListCompilationJobs"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PanoramaSageMakerListAccess"
    },
    {
     "Action":[
      "sagemaker:DescribeTrainingJob"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sagemaker:*:*:training-job/*"
     ],
     "Sid":"PanoramaSageMakerReadAccess"
    },
    {
     "Action":[
      "iot:AttachPolicy",
      "iot:CreateRoleAlias"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iot:*:*:policy/panorama*",
      "arn:aws:iot:*:*:rolealias/panorama*"
     ],
     "Sid":"PanoramaCWLogsAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-01T13:14:43+00:00"
 },
 "AWSPriceListServiceFullAccess":{
  "CreateDate":"2017-11-22T00:36:27+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "pricing:*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSPriceListServiceFullAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-07-02T13:34:19+00:00"
 },
 "AWSPrivateCAAuditor":{
  "CreateDate":"2023-02-14T18:33:44+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:CreateCertificateAuthorityAuditReport",
      "acm-pca:DescribeCertificateAuthority",
      "acm-pca:DescribeCertificateAuthorityAuditReport",
      "acm-pca:GetCertificateAuthorityCsr",
      "acm-pca:GetCertificateAuthorityCertificate",
      "acm-pca:GetCertificate",
      "acm-pca:GetPolicy",
      "acm-pca:ListPermissions",
      "acm-pca:ListTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-02-14T18:33:44+00:00"
 },
 "AWSPrivateCAFullAccess":{
  "CreateDate":"2023-02-14T18:20:59+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-02-14T18:20:59+00:00"
 },
 "AWSPrivateCAPrivilegedUser":{
  "CreateDate":"2023-02-14T18:26:02+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:IssueCertificate"
     ],
     "Condition":{
      "StringLike":{
       "acm-pca:TemplateArn":[
        "arn:aws:acm-pca:::template/*CACertificate*/V*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:IssueCertificate"
     ],
     "Condition":{
      "StringNotLike":{
       "acm-pca:TemplateArn":[
        "arn:aws:acm-pca:::template/*CACertificate*/V*"
       ]
      }
     },
     "Effect":"Deny",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:RevokeCertificate",
      "acm-pca:GetCertificate",
      "acm-pca:ListPermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-02-14T18:26:02+00:00"
 },
 "AWSPrivateCAReadOnly":{
  "CreateDate":"2023-02-14T18:30:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":{
    "Action":[
     "acm-pca:DescribeCertificateAuthority",
     "acm-pca:DescribeCertificateAuthorityAuditReport",
     "acm-pca:ListCertificateAuthorities",
     "acm-pca:GetCertificateAuthorityCsr",
     "acm-pca:GetCertificateAuthorityCertificate",
     "acm-pca:GetCertificate",
     "acm-pca:GetPolicy",
     "acm-pca:ListPermissions",
     "acm-pca:ListTags"
    ],
    "Effect":"Allow",
    "Resource":"*"
   },
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-02-14T18:30:50+00:00"
 },
 "AWSPrivateCAUser":{
  "CreateDate":"2023-02-14T18:16:08+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "acm-pca:IssueCertificate"
     ],
     "Condition":{
      "StringLike":{
       "acm-pca:TemplateArn":[
        "arn:aws:acm-pca:::template/EndEntityCertificate/V*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:IssueCertificate"
     ],
     "Condition":{
      "StringNotLike":{
       "acm-pca:TemplateArn":[
        "arn:aws:acm-pca:::template/EndEntityCertificate/V*"
       ]
      }
     },
     "Effect":"Deny",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:RevokeCertificate",
      "acm-pca:GetCertificate",
      "acm-pca:ListPermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:certificate-authority/*"
    },
    {
     "Action":[
      "acm-pca:ListCertificateAuthorities"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-02-14T18:16:08+00:00"
 },
 "AWSPrivateMarketplaceAdminFullAccess":{
  "CreateDate":"2018-11-27T16:32:32+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:AssociateProductsWithPrivateMarketplace",
      "aws-marketplace:DisassociateProductsFromPrivateMarketplace",
      "aws-marketplace:ListPrivateMarketplaceRequests",
      "aws-marketplace:DescribePrivateMarketplaceRequests"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PrivateMarketplaceRequestPermissions"
    },
    {
     "Action":[
      "aws-marketplace:ListEntities",
      "aws-marketplace:DescribeEntity",
      "aws-marketplace:StartChangeSet",
      "aws-marketplace:ListChangeSets",
      "aws-marketplace:DescribeChangeSet",
      "aws-marketplace:CancelChangeSet"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PrivateMarketplaceCatalogAPIPermissions"
    },
    {
     "Action":[
      "aws-marketplace:TagResource",
      "aws-marketplace:UntagResource",
      "aws-marketplace:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:aws-marketplace:*:*:AWSMarketplace/*",
     "Sid":"PrivateMarketplaceCatalogTaggingPermissions"
    },
    {
     "Action":[
      "organizations:DescribeOrganization",
      "organizations:DescribeOrganizationalUnit",
      "organizations:DescribeAccount",
      "organizations:ListRoots",
      "organizations:ListParents",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListAccountsForParent",
      "organizations:ListAccounts",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListDelegatedAdministrators"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PrivateMarketplaceOrganizationPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-02-14T22:05:08+00:00"
 },
 "AWSPrivateMarketplaceRequests":{
  "CreateDate":"2019-10-28T21:44:03+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:CreatePrivateMarketplaceRequests",
      "aws-marketplace:ListPrivateMarketplaceRequests",
      "aws-marketplace:DescribePrivateMarketplaceRequests"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-28T21:44:03+00:00"
 },
 "AWSPrivateNetworksServiceRolePolicy":{
  "CreateDate":"2021-12-16T23:17:46+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"AWS/Private5G"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-12-16T23:17:46+00:00"
 },
 "AWSProtonCodeBuildProvisioningBasicAccess":{
  "CreateDate":"2022-11-09T21:04:16+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:CreateLogGroup",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/codebuild/AWSProton-*"
     ]
    },
    {
     "Action":"proton:NotifyResourceDeploymentStatusChange",
     "Effect":"Allow",
     "Resource":"arn:aws:proton:*:*:*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-11-09T21:04:16+00:00"
 },
 "AWSProtonCodeBuildProvisioningServiceRolePolicy":{
  "CreateDate":"2022-11-09T21:32:06+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:CreateChangeSet",
      "cloudformation:DeleteChangeSet",
      "cloudformation:DeleteStack",
      "cloudformation:UpdateStack",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeStackEvents",
      "cloudformation:ListStackResources"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/AWSProton-CodeBuild-*"
     ]
    },
    {
     "Action":[
      "codebuild:CreateProject",
      "codebuild:DeleteProject",
      "codebuild:UpdateProject",
      "codebuild:StartBuild",
      "codebuild:StopBuild",
      "codebuild:RetryBuild",
      "codebuild:BatchGetBuilds",
      "codebuild:BatchGetProjects"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codebuild:*:*:project/AWSProton*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEqualsIfExists":{
       "iam:PassedToService":"codebuild.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicequotas:GetServiceQuota"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-05-17T16:11:40+00:00"
 },
 "AWSProtonDeveloperAccess":{
  "CreateDate":"2021-02-17T19:02:08+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codecommit:ListRepositories",
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineExecution",
      "codepipeline:GetPipelineState",
      "codepipeline:ListPipelineExecutions",
      "codepipeline:ListPipelines",
      "codestar-connections:ListConnections",
      "codestar-connections:UseConnection",
      "proton:CancelServiceInstanceDeployment",
      "proton:CancelServicePipelineDeployment",
      "proton:CreateService",
      "proton:DeleteService",
      "proton:GetAccountRoles",
      "proton:GetAccountSettings",
      "proton:GetEnvironment",
      "proton:GetEnvironmentAccountConnection",
      "proton:GetEnvironmentTemplate",
      "proton:GetEnvironmentTemplateMajorVersion",
      "proton:GetEnvironmentTemplateMinorVersion",
      "proton:GetEnvironmentTemplateVersion",
      "proton:GetRepository",
      "proton:GetRepositorySyncStatus",
      "proton:GetResourcesSummary",
      "proton:GetService",
      "proton:GetServiceInstance",
      "proton:GetServiceTemplate",
      "proton:GetServiceTemplateMajorVersion",
      "proton:GetServiceTemplateMinorVersion",
      "proton:GetServiceTemplateVersion",
      "proton:GetTemplateSyncConfig",
      "proton:GetTemplateSyncStatus",
      "proton:ListEnvironmentAccountConnections",
      "proton:ListEnvironmentOutputs",
      "proton:ListEnvironmentProvisionedResources",
      "proton:ListEnvironments",
      "proton:ListEnvironmentTemplateMajorVersions",
      "proton:ListEnvironmentTemplateMinorVersions",
      "proton:ListEnvironmentTemplates",
      "proton:ListEnvironmentTemplateVersions",
      "proton:ListRepositories",
      "proton:ListRepositorySyncDefinitions",
      "proton:ListServiceInstanceOutputs",
      "proton:ListServiceInstanceProvisionedResources",
      "proton:ListServiceInstances",
      "proton:ListServicePipelineOutputs",
      "proton:ListServicePipelineProvisionedResources",
      "proton:ListServices",
      "proton:ListServiceTemplateMajorVersions",
      "proton:ListServiceTemplateMinorVersions",
      "proton:ListServiceTemplates",
      "proton:ListServiceTemplateVersions",
      "proton:ListTagsForResource",
      "proton:UpdateService",
      "proton:UpdateServiceInstance",
      "proton:UpdateServicePipeline",
      "s3:ListAllMyBuckets",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProtonPermissions"
    },
    {
     "Action":"codestar-connections:PassConnection",
     "Condition":{
      "StringEquals":{
       "codestar-connections:PassedToService":"proton.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:codestar-connections:*:*:connection/*",
      "arn:aws:codeconnections:*:*:connection/*"
     ],
     "Sid":"CodeStarConnectionsPermissions"
    },
    {
     "Action":"codeconnections:PassConnection",
     "Condition":{
      "StringEquals":{
       "codeconnections:PassedToService":"proton.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:codestar-connections:*:*:connection/*",
      "arn:aws:codeconnections:*:*:connection/*"
     ],
     "Sid":"CodeConnectionsPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-06T18:26:38+00:00"
 },
 "AWSProtonFullAccess":{
  "CreateDate":"2021-02-17T19:07:18+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "proton:*",
      "codestar-connections:ListConnections",
      "kms:ListAliases",
      "kms:DescribeKey"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProtonPermissions"
    },
    {
     "Action":[
      "kms:CreateGrant"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":"proton.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CreateGrantPermissions"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"proton.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PassRolePermissions"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"sync.proton.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/sync.proton.amazonaws.com/AWSServiceRoleForProtonSync",
     "Sid":"CreateServiceLinkedRolePermissions"
    },
    {
     "Action":[
      "codestar-connections:PassConnection"
     ],
     "Condition":{
      "StringEquals":{
       "codestar-connections:PassedToService":"proton.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:codestar-connections:*:*:connection/*",
      "arn:aws:codeconnections:*:*:connection/*"
     ],
     "Sid":"CodeStarConnectionsPermissions"
    },
    {
     "Action":[
      "codeconnections:PassConnection"
     ],
     "Condition":{
      "StringEquals":{
       "codeconnections:PassedToService":"proton.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:codestar-connections:*:*:connection/*",
      "arn:aws:codeconnections:*:*:connection/*"
     ],
     "Sid":"CodeConnectionsPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-06T18:29:00+00:00"
 },
 "AWSProtonReadOnlyAccess":{
  "CreateDate":"2021-02-17T19:09:12+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "codepipeline:ListPipelineExecutions",
      "codepipeline:ListPipelines",
      "codepipeline:GetPipeline",
      "codepipeline:GetPipelineState",
      "codepipeline:GetPipelineExecution",
      "proton:GetAccountRoles",
      "proton:GetAccountSettings",
      "proton:GetEnvironment",
      "proton:GetEnvironmentAccountConnection",
      "proton:GetEnvironmentTemplate",
      "proton:GetEnvironmentTemplateMajorVersion",
      "proton:GetEnvironmentTemplateMinorVersion",
      "proton:GetEnvironmentTemplateVersion",
      "proton:GetRepository",
      "proton:GetRepositorySyncStatus",
      "proton:GetResourcesSummary",
      "proton:GetService",
      "proton:GetServiceInstance",
      "proton:GetServiceTemplate",
      "proton:GetServiceTemplateMajorVersion",
      "proton:GetServiceTemplateMinorVersion",
      "proton:GetServiceTemplateVersion",
      "proton:GetTemplateSyncConfig",
      "proton:GetTemplateSyncStatus",
      "proton:ListEnvironmentAccountConnections",
      "proton:ListEnvironmentOutputs",
      "proton:ListEnvironmentProvisionedResources",
      "proton:ListEnvironments",
      "proton:ListEnvironmentTemplateMajorVersions",
      "proton:ListEnvironmentTemplateMinorVersions",
      "proton:ListEnvironmentTemplates",
      "proton:ListEnvironmentTemplateVersions",
      "proton:ListRepositories",
      "proton:ListRepositorySyncDefinitions",
      "proton:ListServiceInstanceOutputs",
      "proton:ListServiceInstanceProvisionedResources",
      "proton:ListServiceInstances",
      "proton:ListServicePipelineOutputs",
      "proton:ListServicePipelineProvisionedResources",
      "proton:ListServices",
      "proton:ListServiceTemplateMajorVersions",
      "proton:ListServiceTemplateMinorVersions",
      "proton:ListServiceTemplates",
      "proton:ListServiceTemplateVersions",
      "proton:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-11-18T18:28:24+00:00"
 },
 "AWSProtonServiceGitSyncServiceRolePolicy":{
  "CreateDate":"2023-04-04T15:55:48+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "proton:GetService",
      "proton:UpdateService",
      "proton:UpdateServicePipeline",
      "proton:GetServiceInstance",
      "proton:CreateServiceInstance",
      "proton:UpdateServiceInstance",
      "proton:ListServiceInstances",
      "proton:GetComponent",
      "proton:CreateComponent",
      "proton:ListComponents",
      "proton:UpdateComponent",
      "proton:GetEnvironment",
      "proton:CreateEnvironment",
      "proton:ListEnvironments",
      "proton:UpdateEnvironment"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ProtonServiceSync"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-04-04T15:55:48+00:00"
 },
 "AWSProtonSyncServiceRolePolicy":{
  "CreateDate":"2021-11-23T21:14:36+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "proton:UpdateServiceTemplateVersion",
      "proton:UpdateServiceTemplate",
      "proton:UpdateEnvironmentTemplateVersion",
      "proton:UpdateEnvironmentTemplate",
      "proton:GetServiceTemplateVersion",
      "proton:GetServiceTemplate",
      "proton:GetEnvironmentTemplateVersion",
      "proton:GetEnvironmentTemplate",
      "proton:DeleteServiceTemplateVersion",
      "proton:DeleteEnvironmentTemplateVersion",
      "proton:CreateServiceTemplateVersion",
      "proton:CreateServiceTemplate",
      "proton:CreateEnvironmentTemplateVersion",
      "proton:CreateEnvironmentTemplate",
      "proton:ListEnvironmentTemplateVersions",
      "proton:ListServiceTemplateVersions",
      "proton:CreateEnvironmentTemplateMajorVersion",
      "proton:CreateServiceTemplateMajorVersion"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SyncToProton"
    },
    {
     "Action":[
      "codestar-connections:UseConnection",
      "codeconnections:UseConnection"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:codestar-connections:*:*:connection/*",
      "arn:aws:codeconnections:*:*:connection/*"
     ],
     "Sid":"AccessGitRepos"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-05T01:49:07+00:00"
 },
 "AWSPurchaseOrdersServiceRolePolicy":{
  "CreateDate":"2020-05-06T18:15:47+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "account:GetAccountInformation",
      "account:GetContactInformation",
      "aws-portal:*Billing",
      "consolidatedbilling:GetAccountBillingRole",
      "invoicing:GetInvoicePDF",
      "payments:GetPaymentInstrument",
      "payments:ListPaymentPreferences",
      "purchase-orders:AddPurchaseOrder",
      "purchase-orders:DeletePurchaseOrder",
      "purchase-orders:GetPurchaseOrder",
      "purchase-orders:ListPurchaseOrderInvoices",
      "purchase-orders:ListPurchaseOrders",
      "purchase-orders:ListTagsForResource",
      "purchase-orders:ModifyPurchaseOrders",
      "purchase-orders:TagResource",
      "purchase-orders:UntagResource",
      "purchase-orders:UpdatePurchaseOrder",
      "purchase-orders:UpdatePurchaseOrderStatus",
      "purchase-orders:ViewPurchaseOrders",
      "tax:ListTaxRegistrations"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-07-17T18:59:18+00:00"
 },
 "AWSQuickSetupCFGCPacksPermissionsBoundary":{
  "CreateDate":"2024-06-26T09:52:11+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-CFGCPacks*"
     ],
     "Sid":"ConfigurationRoleGetPermissions"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-CFGCPacks*"
     ],
     "Sid":"ConfigurationRolePassToSSMPermissions"
    },
    {
     "Action":[
      "config:PutConformancePack"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":[
        "${aws:PrincipalAccount}"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:config:*:*:conformance-pack/AWS-QuickSetup-*"
     ],
     "Sid":"PutCPackPermissions"
    },
    {
     "Action":[
      "config:DescribeConformancePackStatus"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribeCPacksPermissions"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"config-conforms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/config-conforms.amazonaws.com/AWSServiceRoleForConfigConforms"
     ],
     "Sid":"ConformancePacksSLRCreatePermissions"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/ssm.amazonaws.com/AWSServiceRoleForAmazonSSM"
     ],
     "Sid":"SystemsManagerSLRCreatePermissions"
    },
    {
     "Action":[
      "iam:ListRoles",
      "config:DescribeConfigurationRecorders",
      "compute-optimizer:GetEnrollmentStatus",
      "support:DescribeTrustedAdvisorChecks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EnableExplorerReadOnlyPermissions"
    },
    {
     "Action":[
      "ssm:UpdateServiceSetting",
      "ssm:GetServiceSetting"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/ssm-patchmanager",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/EC2",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ExplorerOnboarded",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/Association",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ComputeOptimizer",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ConfigCompliance",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/OpsData-TrustedAdvisor",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/SupportCenterCase"
     ],
     "Sid":"ServiceSettingsForExplorerUpdatePermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-26T09:52:11+00:00"
 },
 "AWSQuickSetupDeploymentRolePolicy":{
  "CreateDate":"2024-06-26T09:55:21+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeStackDriftDetectionStatus",
      "cloudformation:ListStacks"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"CfnRead"
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:UpdateStack",
      "cloudformation:DeleteStack",
      "cloudformation:CreateChangeSet",
      "cloudformation:DeleteChangeSet",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:DescribeStackResourceDrifts",
      "cloudformation:DetectStackDrift",
      "cloudformation:DetectStackResourceDrift"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/StackSet-AWS-QuickSetup-*"
     ],
     "Sid":"CfnManage"
    },
    {
     "Action":[
      "resource-groups:GetGroupQuery"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"RGroupsGet"
    },
    {
     "Action":[
      "config:DescribeConformancePacks",
      "config:DescribeConformancePackStatus"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CPacksRead"
    },
    {
     "Action":[
      "config:PutConformancePack",
      "config:DeleteConformancePack"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:conformance-pack/AWS-QuickSetup-*",
     "Sid":"OpsPacksManage"
    },
    {
     "Action":[
      "ssm:CreateDocument",
      "ssm:UpdateDocument",
      "ssm:UpdateDocumentDefaultVersion",
      "ssm:DeleteDocument",
      "ssm:AddTagsToResource",
      "ssm:RemoveTagsFromResource",
      "ssm:ListTagsForResource"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSQuickSetup-*",
      "arn:aws:ssm:*:*:document/AWSOperationsPack-*",
      "arn:aws:ssm:*:*:document/AWSOperationsPackInstance-*"
     ],
     "Sid":"QSDocsManage"
    },
    {
     "Action":[
      "ssm:GetDocument"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSQuickSetup-*",
      "arn:aws:ssm:*:*:document/AWSOperationsPack*",
      "arn:aws:ssm:*::document/AWSConformancePacks-*",
      "arn:aws:ssm:*::document/AWSEC2-UpdateLaunchAgent",
      "arn:aws:ssm:*::document/AWS-ConfigureAWSPackage",
      "arn:aws:ssm:*::document/AWS-EnableExplorer",
      "arn:aws:ssm:*::document/AWS-GatherSoftwareInventory",
      "arn:aws:ssm:*::document/AWS-RunPatchBaselineAssociation",
      "arn:aws:ssm:*::document/AWS-UpdateSSMAgent"
     ],
     "Sid":"QSDocsRead"
    },
    {
     "Action":[
      "ssm:CreateAssociation",
      "ssm:UpdateAssociation",
      "ssm:DeleteAssociation",
      "ssm:DescribeAssociation"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSQuickSetup-*",
      "arn:aws:ssm:*:*:document/AWSOperationsPack*",
      "arn:aws:ssm:*::document/AWSEC2-UpdateLaunchAgent",
      "arn:aws:ssm:*::document/AWS-ConfigureAWSPackage",
      "arn:aws:ssm:*::document/AWS-EnableExplorer",
      "arn:aws:ssm:*::document/AWS-GatherSoftwareInventory",
      "arn:aws:ssm:*::document/AWS-RunPatchBaselineAssociation",
      "arn:aws:ssm:*::document/AWS-UpdateSSMAgent",
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ssm:*:*:managed-instance/*",
      "arn:aws:ssm:*:*:association/*"
     ],
     "Sid":"QSAssociationsManage"
    },
    {
     "Action":[
      "events:DescribeRule",
      "events:PutRule",
      "events:DeleteRule",
      "events:ListTargetsByRule",
      "events:PutTargets",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/*QuickSetup-*"
     ],
     "Sid":"EventRulesManage"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"config-conforms.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/config-conforms.amazonaws.com/AWSServiceRoleForConfigConforms"
     ],
     "Sid":"CPacksSLRCreate"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/ssm.amazonaws.com/AWSServiceRoleForAmazonSSM"
     ],
     "Sid":"SSMSLRCreate"
    },
    {
     "Action":[
      "iam:CreateRole",
      "iam:GetRole",
      "iam:UpdateRole",
      "iam:DeleteRole",
      "iam:GetRolePolicy",
      "iam:ListAttachedRolePolicies",
      "iam:ListRolePolicies",
      "iam:ListRoleTags",
      "iam:TagRole",
      "iam:UntagRole"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-*",
      "arn:aws:iam::*:role/AWSOperationsPack-*"
     ],
     "Sid":"QSConfigRoleManage"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ssm.amazonaws.com",
        "events.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-*",
      "arn:aws:iam::*:role/AWSOperationsPack-*"
     ],
     "Sid":"QSConfigRolePass"
    },
    {
     "Action":[
      "ssm:DescribeDocument"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DocDescribe"
    },
    {
     "Action":[
      "ssm:DeleteDocument"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/QuickSetupID":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LegacyDocClean"
    },
    {
     "Action":[
      "iam:DeleteRole",
      "iam:DeleteRolePolicy"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/QuickSetupID":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*QuickSetup-*",
     "Sid":"LegacyIAMClean"
    },
    {
     "Action":[
      "iam:DeleteRolePolicy",
      "iam:PutRolePolicy",
      "iam:PutRolePermissionsBoundary"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      },
      "StringEquals":{
       "iam:PermissionsBoundary":[
        "arn:aws:iam::aws:policy/AWSQuickSetupCFGCPacksPermissionsBoundary",
        "arn:aws:iam::aws:policy/AWSQuickSetupCFGRecordingPermissionsBoundary",
        "arn:aws:iam::aws:policy/AWSQuickSetupDevOpsGuruPermissionsBoundary",
        "arn:aws:iam::aws:policy/AWSQuickSetupDistributorPermissionsBoundary",
        "arn:aws:iam::aws:policy/AWSQuickSetupSchedulerPermissionsBoundary",
        "arn:aws:iam::aws:policy/AWSQuickSetupSSMHostMgmtPermissionsBoundary"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-*",
      "arn:aws:iam::*:role/AWSOperationsPack-*"
     ],
     "Sid":"QSConfigRoleBounded"
    },
    {
     "Action":[
      "iam:AttachRolePolicy",
      "iam:DetachRolePolicy"
     ],
     "Condition":{
      "ArnEquals":{
       "iam:PolicyARN":[
        "arn:aws:iam::aws:policy/AWSSystemsManagerEnableExplorerExecutionPolicy",
        "arn:aws:iam::aws:policy/AWSSystemsManagerEnableConfigRecordingExecutionPolicy"
       ]
      },
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-*",
      "arn:aws:iam::*:role/AWSOperationsPack-*"
     ],
     "Sid":"QSConfigRoleManagedPolicies"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-26T09:55:21+00:00"
 },
 "AWSQuickSetupDevOpsGuruPermissionsBoundary":{
  "CreateDate":"2024-06-26T09:44:42+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/ssm.amazonaws.com/AWSServiceRoleForAmazonSSM"
     ],
     "Sid":"CreateSystemsManagerSLRPermissions"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"devops-guru.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/devops-guru.amazonaws.com/AWSServiceRoleForDevOpsGuru"
     ],
     "Sid":"CreateDevOpsGuruSLRPermissions"
    },
    {
     "Action":[
      "cloudformation:ListStacks",
      "cloudformation:DescribeStacks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CloudformationReadOnlyPermissions"
    },
    {
     "Action":[
      "devops-guru:AddNotificationChannel"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:sns:*:*:DevOpsGuru-Default-Topic",
      "arn:aws:devops-guru:*:*:/channels"
     ],
     "Sid":"DevOpsGuruNotificationChannelPermissions"
    },
    {
     "Action":[
      "devops-guru:UpdateResourceCollection",
      "devops-guru:UpdateServiceIntegration"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DevOpsGuruConfigurationPermissions"
    },
    {
     "Action":[
      "sns:ListTopics"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SNSReadOnlyPermissions"
    },
    {
     "Action":[
      "sns:AddPermission",
      "sns:CreateTopic",
      "sns:GetTopicAttributes",
      "sns:Publish",
      "sns:SetTopicAttributes",
      "sns:RemovePermission"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sns:*:*:DevOpsGuru-Default-Topic",
     "Sid":"DevOpsGuruDefaultSNSTopicConfigurationPermissions"
    },
    {
     "Action":[
      "iam:ListRoles",
      "config:DescribeConfigurationRecorders",
      "compute-optimizer:GetEnrollmentStatus",
      "support:DescribeTrustedAdvisorChecks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReadOnlyPermissionsForEnablingExplorer"
    },
    {
     "Action":[
      "ssm:UpdateServiceSetting",
      "ssm:GetServiceSetting"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/ssm-patchmanager",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/EC2",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ExplorerOnboarded",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/Association",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ComputeOptimizer",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ConfigCompliance",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/OpsData-TrustedAdvisor",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/SupportCenterCase"
     ],
     "Sid":"SSMExplorerServiceSettingsPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-26T09:44:42+00:00"
 },
 "AWSQuickSetupDistributorPermissionsBoundary":{
  "CreateDate":"2024-06-26T09:50:21+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-RoleForDistributor-*"
     ],
     "Sid":"DistributorAutomationRoleGetPermissions"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-RoleForDistributor-*"
     ],
     "Sid":"DistributorAutomationRolePassPermissions"
    },
    {
     "Action":[
      "iam:CreateRole",
      "iam:DeleteRole",
      "iam:UpdateRole",
      "iam:GetRole"
     ],
     "Condition":{
      "ArnLike":{
       "aws:PrincipalArn":"arn:aws:iam::*:role/AWS-QuickSetup-RoleForDistributor-*"
      },
      "StringLike":{
       "aws:PrincipalTag/QuickSetupManagerID":"*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AmazonSSMRoleForInstancesQuickSetup"
     ],
     "Sid":"DefaultInstanceRoleManagePermissions"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AmazonSSMRoleForInstancesQuickSetup"
     ],
     "Sid":"DefaultInstanceRolePassToEC2Permissions"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AmazonSSMRoleForInstancesQuickSetup"
     ],
     "Sid":"DefaultInstanceRolePassToSSMPermissions"
    },
    {
     "Action":[
      "iam:AttachRolePolicy",
      "iam:DetachRolePolicy"
     ],
     "Condition":{
      "ArnEquals":{
       "iam:PolicyARN":[
        "arn:aws:iam::aws:policy/AmazonElasticFileSystemsUtils",
        "arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore"
       ]
      },
      "ArnLike":{
       "aws:PrincipalArn":"arn:aws:iam::*:role/AWS-QuickSetup-RoleForDistributor-*"
      },
      "StringLike":{
       "aws:PrincipalTag/QuickSetupManagerID":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*",
     "Sid":"InstanceManagementPoliciesAttachPermissions"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/ssm.amazonaws.com/AWSServiceRoleForAmazonSSM"
     ],
     "Sid":"CreateSystemsManagerSLRPermissions"
    },
    {
     "Action":[
      "iam:AddRoleToInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DefaultInstanceRoleAddPermissions"
    },
    {
     "Action":[
      "iam:GetInstanceProfile",
      "iam:GetRolePolicy",
      "iam:ListInstanceProfilesForRole",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"IAMReadOnlyPermissions"
    },
    {
     "Action":[
      "iam:CreateInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:instance-profile/AmazonSSMRoleForInstancesQuickSetup"
     ],
     "Sid":"DefaultInstanceProfileCreatePermissions"
    },
    {
     "Action":[
      "ec2:AssociateIamInstanceProfile"
     ],
     "Condition":{
      "ArnLike":{
       "ec2:NewInstanceProfile":"arn:aws:iam::*:instance-profile/AmazonSSMRoleForInstancesQuickSetup"
      },
      "Null":{
       "ec2:InstanceProfile":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DefaultInstanceProfileAssociationPermissions"
    },
    {
     "Action":[
      "ec2:DisassociateIamInstanceProfile"
     ],
     "Condition":{
      "ArnLike":{
       "ec2:InstanceProfile":"arn:aws:iam::*:instance-profile/AmazonSSMRoleForInstancesQuickSetup"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DefaultInstanceProfileDisassociationPermissions"
    },
    {
     "Action":[
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:automation-definition/AWSQuickSetup-Distributor-*",
      "arn:aws:ssm:*:*:automation-definition/UpdateCloudWatchDocument-Distributor-*",
      "arn:aws:ssm:*:*:automation-definition/AWS-ConfigureAWSPackage*",
      "arn:aws:ssm:*:*:automation-definition/AWS-AttachIAMToInstance*"
     ],
     "Sid":"ConfigurationAutomationsStartPermissions"
    },
    {
     "Action":[
      "ssm:ListTagsForResource",
      "ssm:GetAutomationExecution",
      "ec2:DescribeIamInstanceProfileAssociations",
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReadOnlyPermissionsForEnablingHostManagementBySSM"
    },
    {
     "Action":[
      "config:DescribeConfigurationRecorders",
      "compute-optimizer:GetEnrollmentStatus",
      "support:DescribeTrustedAdvisorChecks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReadOnlyPermissionsForEnablingExplorer"
    },
    {
     "Action":[
      "ssm:UpdateServiceSetting",
      "ssm:GetServiceSetting"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/ssm-patchmanager",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/EC2",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ExplorerOnboarded",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/Association",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ComputeOptimizer",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ConfigCompliance",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/OpsData-TrustedAdvisor",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/SupportCenterCase"
     ],
     "Sid":"SSMExplorerServiceSettingsPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-26T09:50:21+00:00"
 },
 "AWSQuickSetupPatchPolicyBaselineAccess":{
  "CreateDate":"2024-06-26T09:38:00+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"s3:GetObject",
     "Condition":{
      "StringEquals":{
       "aws:PrincipalAccount":[
        "${aws:ResourceAccount}"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::aws-quicksetup-patchpolicy-*",
     "Sid":"QuickSetupPatchingBaselineOverridesS3SameAccountReadOnlyAccess"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "StringEquals":{
       "aws:PrincipalOrgID":[
        "${aws:ResourceOrgID}"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::aws-quicksetup-patchpolicy-*",
     "Sid":"QuickSetupPatchingBaselineOverridesS3OrganizationReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-26T09:38:00+00:00"
 },
 "AWSQuickSetupPatchPolicyDeploymentRolePolicy":{
  "CreateDate":"2024-06-26T09:57:02+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeStackDriftDetectionStatus",
      "cloudformation:ListStacks"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"CfnRead"
    },
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:UpdateStack",
      "cloudformation:DeleteStack",
      "cloudformation:CreateChangeSet",
      "cloudformation:DeleteChangeSet",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:DescribeStackResourceDrifts",
      "cloudformation:DetectStackDrift",
      "cloudformation:DetectStackResourceDrift"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/StackSet-AWS-QuickSetup-*"
     ],
     "Sid":"CfnManage"
    },
    {
     "Action":[
      "resource-groups:GetGroupQuery"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"RGroupsGet"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"S3BucketsList"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:DeleteBucket",
      "s3:DeleteBucketPolicy",
      "s3:Put*",
      "s3:Get*",
      "s3:List*"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      },
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-quicksetup-patchpolicy-access-log-*"
     ],
     "Sid":"AccessLogsBucketManage"
    },
    {
     "Action":[
      "lambda:CreateFunction",
      "lambda:UpdateFunction*",
      "lambda:GetFunction",
      "lambda:ListTags",
      "lambda:TagResource",
      "lambda:DeleteFunction",
      "lambda:InvokeFunction",
      "lambda:UntagResource"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      },
      "StringEquals":{
       "aws:ResourceAccount":[
        "${aws:PrincipalAccount}"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:baseline-overrides-*",
      "arn:aws:lambda:*:*:function:delete-name-tags-*"
     ],
     "Sid":"LambdaManage"
    },
    {
     "Action":[
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LogGroupsDescribe"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:TagResource",
      "logs:PutRetentionPolicy",
      "logs:DeleteLogGroup",
      "logs:ListTagsForResource",
      "logs:UntagResource"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/lambda/baseline-overrides-*",
      "arn:aws:logs:*:*:log-group:/aws/lambda/delete-name-tags-*"
     ],
     "Sid":"LogGroupsManage"
    },
    {
     "Action":[
      "ssm:CreateDocument",
      "ssm:UpdateDocument",
      "ssm:DescribeDocument",
      "ssm:UpdateDocumentDefaultVersion",
      "ssm:DeleteDocument",
      "ssm:AddTagsToResource",
      "ssm:RemoveTagsFromResource",
      "ssm:ListTagsForResource"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSQuickSetup-*",
      "arn:aws:ssm:*:*:document/QuickSetup-*"
     ],
     "Sid":"QSDocsManage"
    },
    {
     "Action":[
      "ssm:GetDocument"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSQuickSetup-*",
      "arn:aws:ssm:*:*:document/QuickSetup-*",
      "arn:aws:ssm:*::document/AWS-EnableExplorer",
      "arn:aws:ssm:*::document/AWS-RunPatchBaseline"
     ],
     "Sid":"QSDocsGet"
    },
    {
     "Action":[
      "ssm:CreateAssociation",
      "ssm:UpdateAssociation",
      "ssm:DeleteAssociation",
      "ssm:DescribeAssociation"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSQuickSetup-*",
      "arn:aws:ssm:*:*:document/QuickSetup-*",
      "arn:aws:ssm:*::document/AWS-EnableExplorer",
      "arn:aws:ssm:*::document/AWS-RunPatchBaseline",
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ssm:*:*:managed-instance/*",
      "arn:aws:ssm:*:*:association/*"
     ],
     "Sid":"QSAssociationsManage"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/ssm.amazonaws.com/AWSServiceRoleForAmazonSSM"
     ],
     "Sid":"SSMSLRCreate"
    },
    {
     "Action":[
      "iam:TagRole",
      "iam:UntagRole",
      "iam:GetRole",
      "iam:UpdateRole",
      "iam:DeleteRole",
      "iam:GetRolePolicy",
      "iam:ListAttachedRolePolicies",
      "iam:ListRolePolicies",
      "iam:ListRoleTags"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-*"
     ],
     "Sid":"ConfigRoleManage"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-*"
     ],
     "Sid":"ConfigRolePassToSSM"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "lambda.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-*"
     ],
     "Sid":"ConfigRolePassToLambda"
    },
    {
     "Action":[
      "ssm:DescribeDocument"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DocDescribe"
    },
    {
     "Action":[
      "ssm:DeleteDocument"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/QuickSetupID":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LegacyDocClean"
    },
    {
     "Action":[
      "iam:DeleteRole",
      "iam:DeleteRolePolicy"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/QuickSetupID":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*QuickSetup-*",
     "Sid":"LegacyIAMClean"
    },
    {
     "Action":[
      "iam:CreateRole",
      "iam:AttachRolePolicy",
      "iam:DeleteRolePolicy",
      "iam:DetachRolePolicy",
      "iam:PutRolePolicy",
      "iam:PutRolePermissionsBoundary"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "cloudformation.amazonaws.com"
       ]
      },
      "StringEquals":{
       "iam:PermissionsBoundary":"arn:aws:iam::aws:policy/AWSQuickSetupPatchPolicyPermissionsBoundary"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-*"
     ],
     "Sid":"ConfigRoleBoundedManage"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-26T09:57:02+00:00"
 },
 "AWSQuickSetupPatchPolicyPermissionsBoundary":{
  "CreateDate":"2024-06-26T09:46:54+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-AutomationRole-*"
     ],
     "Sid":"PatchingAutomationRoleGetPermissions"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-AutomationRole-*"
     ],
     "Sid":"PatchingAutomationRolePassPermissions"
    },
    {
     "Action":[
      "iam:CreateRole",
      "iam:DeleteRole",
      "iam:UpdateRole",
      "iam:GetRole"
     ],
     "Condition":{
      "ArnLike":{
       "aws:PrincipalArn":"arn:aws:iam::*:role/AWS-QuickSetup-AutomationRole-*"
      },
      "StringLike":{
       "aws:PrincipalTag/QuickSetupManagerID":"*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AmazonSSMRoleForInstancesQuickSetup"
     ],
     "Sid":"DefaultInstanceRolePermissions"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AmazonSSMRoleForInstancesQuickSetup"
     ],
     "Sid":"DefaultInstanceRolePassPermissions"
    },
    {
     "Action":[
      "iam:AttachRolePolicy",
      "iam:DetachRolePolicy"
     ],
     "Condition":{
      "ArnEquals":{
       "iam:PolicyARN":[
        "arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore",
        "arn:aws:iam::aws:policy/AWSQuickSetupPatchPolicyBaselineAccess"
       ]
      },
      "ArnLike":{
       "aws:PrincipalArn":"arn:aws:iam::*:role/AWS-QuickSetup-AutomationRole-*"
      },
      "StringLike":{
       "aws:PrincipalTag/QuickSetupManagerID":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*",
     "Sid":"PoliciesAttachPermissions"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/ssm.amazonaws.com/AWSServiceRoleForAmazonSSM"
     ],
     "Sid":"CreateSLRPermissions"
    },
    {
     "Action":[
      "iam:AddRoleToInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"InstanceRoleAddPermissions"
    },
    {
     "Action":[
      "ssm:UpdateManagedInstanceRole"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ManagedInstanceRoleUpdatePermissions"
    },
    {
     "Action":[
      "iam:GetInstanceProfile",
      "iam:GetRolePolicy",
      "iam:ListInstanceProfilesForRole",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"IAMReadOnlyPermissions"
    },
    {
     "Action":[
      "iam:CreateInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:instance-profile/AmazonSSMRoleForInstancesQuickSetup"
     ],
     "Sid":"InstanceProfileCreatePermissions"
    },
    {
     "Action":[
      "ec2:AssociateIamInstanceProfile"
     ],
     "Condition":{
      "ArnLike":{
       "ec2:NewInstanceProfile":"arn:aws:iam::*:instance-profile/AmazonSSMRoleForInstancesQuickSetup"
      },
      "Null":{
       "ec2:InstanceProfile":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"InstanceProfileAssociationPermissions"
    },
    {
     "Action":[
      "ec2:DisassociateIamInstanceProfile"
     ],
     "Condition":{
      "ArnLike":{
       "ec2:InstanceProfile":"arn:aws:iam::*:instance-profile/AmazonSSMRoleForInstancesQuickSetup"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"InstanceProfileDisassociationPermissions"
    },
    {
     "Action":[
      "ssm:DescribeAssociationExecutions",
      "ssm:UpdateAssociation",
      "ssm:DescribeAssociation"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSQuickSetup-*",
      "arn:aws:ec2:*:*:instance/*",
      "arn:aws:ssm:*:*:managed-instance/*",
      "arn:aws:ssm:*:*:association/*"
     ],
     "Sid":"SSMAssociationsPermissions"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:Put*",
      "s3:Get*",
      "s3:List*",
      "s3:DeleteObject",
      "s3:DeleteObjectVersion",
      "s3:DeleteBucket"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":[
        "${aws:PrincipalAccount}"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::aws-quicksetup-patchpolicy-*",
     "Sid":"BaselineS3Permissions"
    },
    {
     "Action":[
      "lambda:InvokeFunction"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":[
        "${aws:PrincipalAccount}"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:lambda:*:*:function:baseline-overrides-*",
      "arn:aws:lambda:*:*:function:delete-name-tags-*"
     ],
     "Sid":"PatchingFunctionsPermissions"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/lambda/baseline-overrides-*",
      "arn:aws:logs:*:*:log-group:/aws/lambda/delete-name-tags-*"
     ],
     "Sid":"LoggingPermissions"
    },
    {
     "Action":[
      "ssm:AddTagsToResource",
      "ssm:RemoveTagsFromResource"
     ],
     "Condition":{
      "ForAllValues:StringLike":{
       "aws:TagKeys":"QSConfigName-*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:managed-instance/*",
     "Sid":"SSMTaggingPermissions"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAllValues:StringLike":{
       "aws:TagKeys":"QSConfigName-*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"EC2TaggingPermissions"
    },
    {
     "Action":[
      "iam:TagRole",
      "iam:UntagRole"
     ],
     "Condition":{
      "ForAllValues:StringLike":{
       "aws:TagKeys":"QSConfigId-*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RoleTaggingPermissions"
    },
    {
     "Action":[
      "ssm:GetPatchBaseline",
      "ssm:GetInventory",
      "ssm:DescribeInstanceInformation",
      "ssm:DescribeAssociation",
      "ssm:GetAutomationExecution",
      "ssm:ListTagsForResource",
      "ec2:DescribeIamInstanceProfileAssociations",
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PatchingReadOnlyPermissions"
    },
    {
     "Action":[
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:automation-definition/AWS-EnableExplorer*",
      "arn:aws:ssm:*:*:automation-definition/AWS-RunPatchBaseline*",
      "arn:aws:ssm:*:*:automation-definition/AWS-AttachIAMToInstance*",
      "arn:aws:ssm:*:*:automation-definition/QuickSetup-*",
      "arn:aws:ssm:*:*:automation-definition/AWSQuickSetup-*"
     ],
     "Sid":"PatchingAutomationsStartPermissions"
    },
    {
     "Action":[
      "iam:ListRoles",
      "config:DescribeConfigurationRecorders",
      "compute-optimizer:GetEnrollmentStatus",
      "support:DescribeTrustedAdvisorChecks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReadOnlyPermissionsForEnablingExplorer"
    },
    {
     "Action":[
      "ssm:UpdateServiceSetting",
      "ssm:GetServiceSetting"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/ssm-patchmanager",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/EC2",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ExplorerOnboarded",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/Association",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ComputeOptimizer",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ConfigCompliance",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/OpsData-TrustedAdvisor",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/SupportCenterCase"
     ],
     "Sid":"ExplorerServiceSettingsPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-26T09:46:54+00:00"
 },
 "AWSQuickSetupSSMHostMgmtPermissionsBoundary":{
  "CreateDate":"2024-06-26T09:48:42+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-HostMgmtRole-*"
     ],
     "Sid":"HostManagementAutomationRoleGetPermissions"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-HostMgmtRole-*"
     ],
     "Sid":"HostManagementAutomationRolePassPermissions"
    },
    {
     "Action":[
      "iam:CreateRole",
      "iam:DeleteRole",
      "iam:UpdateRole",
      "iam:GetRole"
     ],
     "Condition":{
      "ArnLike":{
       "aws:PrincipalArn":"arn:aws:iam::*:role/AWS-QuickSetup-HostMgmtRole-*"
      },
      "StringLike":{
       "aws:PrincipalTag/QuickSetupManagerID":"*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AmazonSSMRoleForInstancesQuickSetup"
     ],
     "Sid":"DefaultInstanceRoleManagePermissions"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AmazonSSMRoleForInstancesQuickSetup"
     ],
     "Sid":"DefaultInstanceRolePassToEC2Permissions"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AmazonSSMRoleForInstancesQuickSetup"
     ],
     "Sid":"DefaultInstanceRolePassToSSMPermissions"
    },
    {
     "Action":[
      "iam:AttachRolePolicy",
      "iam:DetachRolePolicy"
     ],
     "Condition":{
      "ArnEquals":{
       "iam:PolicyARN":[
        "arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore",
        "arn:aws:iam::aws:policy/AmazonSSMPatchAssociation"
       ]
      },
      "ArnLike":{
       "aws:PrincipalArn":"arn:aws:iam::*:role/AWS-QuickSetup-HostMgmtRole-*"
      },
      "StringLike":{
       "aws:PrincipalTag/QuickSetupManagerID":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/*",
     "Sid":"InstanceManagementPoliciesAttachPermissions"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/ssm.amazonaws.com/AWSServiceRoleForAmazonSSM"
     ],
     "Sid":"CreateSystemsManagerSLRPermissions"
    },
    {
     "Action":[
      "iam:AddRoleToInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"DefaultInstanceRoleAddPermissions"
    },
    {
     "Action":[
      "iam:GetInstanceProfile",
      "iam:GetRolePolicy",
      "iam:ListInstanceProfilesForRole",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"IAMReadOnlyPermissions"
    },
    {
     "Action":[
      "iam:CreateInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:instance-profile/AmazonSSMRoleForInstancesQuickSetup"
     ],
     "Sid":"DefaultInstanceProfileCreatePermissions"
    },
    {
     "Action":[
      "ec2:AssociateIamInstanceProfile"
     ],
     "Condition":{
      "ArnLike":{
       "ec2:NewInstanceProfile":"arn:aws:iam::*:instance-profile/AmazonSSMRoleForInstancesQuickSetup"
      },
      "Null":{
       "ec2:InstanceProfile":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DefaultInstanceProfileAssociationPermissions"
    },
    {
     "Action":[
      "ec2:DisassociateIamInstanceProfile"
     ],
     "Condition":{
      "ArnLike":{
       "ec2:InstanceProfile":"arn:aws:iam::*:instance-profile/AmazonSSMRoleForInstancesQuickSetup"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DefaultInstanceProfileDisassociationPermissions"
    },
    {
     "Action":[
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:automation-definition/AWSQuickSetup-HostMgmt-*",
      "arn:aws:ssm:*:*:automation-definition/AWSQuickSetup-CreateAndAttachIAMToInstance-*",
      "arn:aws:ssm:*:*:automation-definition/AWSQuickSetup-UpdateExistingInstanceProfile-*",
      "arn:aws:ssm:*:*:automation-definition/AWSQuickSetup-InstallAndManageCloudWatchDocument-*",
      "arn:aws:ssm:*:*:automation-definition/UpdateCloudWatchDocument-*",
      "arn:aws:ssm:*:*:automation-definition/AWSEC2-UpdateLaunchAgent-*",
      "arn:aws:ssm:*:*:automation-definition/AWS-AttachIAMToInstance*",
      "arn:aws:ssm:*:*:automation-definition/AWS-GatherSoftwareInventory*",
      "arn:aws:ssm:*:*:automation-definition/AWS-RunPatchBaselineAssociation*",
      "arn:aws:ssm:*:*:automation-definition/AWS-UpdateSSMAgent*"
     ],
     "Sid":"ConfigurationAutomationsStartPermissions"
    },
    {
     "Action":[
      "ssm:ListTagsForResource",
      "ssm:GetAutomationExecution",
      "ec2:DescribeIamInstanceProfileAssociations",
      "ec2:DescribeInstances"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReadOnlyPermissionsForEnablingHostManagementBySSM"
    },
    {
     "Action":[
      "config:DescribeConfigurationRecorders",
      "compute-optimizer:GetEnrollmentStatus",
      "support:DescribeTrustedAdvisorChecks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReadOnlyPermissionsForEnablingExplorer"
    },
    {
     "Action":[
      "ssm:UpdateServiceSetting",
      "ssm:GetServiceSetting"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/ssm-patchmanager",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/EC2",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ExplorerOnboarded",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/Association",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ComputeOptimizer",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ConfigCompliance",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/OpsData-TrustedAdvisor",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/SupportCenterCase"
     ],
     "Sid":"SSMExplorerServiceSettingsPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-26T09:48:42+00:00"
 },
 "AWSQuickSetupSchedulerPermissionsBoundary":{
  "CreateDate":"2024-06-26T09:53:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-Scheduler-*"
     ],
     "Sid":"ConfigurationAutomationRoleGetPermissions"
    },
    {
     "Action":[
      "iam:PassRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ssm.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/AWS-QuickSetup-Scheduler-*"
     ],
     "Sid":"ConfigurationAutomationRolePassPermissions"
    },
    {
     "Action":[
      "ssm:GetCalendarState"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWSQuickSetup-ChangeCalendar-*"
     ],
     "Sid":"SystemsManagerCalendarReadOnlyPermissions"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeRegions",
      "ec2:DescribeTags",
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EC2ReadOnlyPermissions"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"EC2StartStopPermissions"
    },
    {
     "Action":[
      "ssm:StartAutomationExecution"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:automation-definition/AWSQuickSetup-StartStateManagerAssociations-*"
     ],
     "Sid":"AutomationStartPermissions"
    },
    {
     "Action":[
      "ssm:StartAssociationsOnce"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:association/*"
     ],
     "Sid":"AssociationsStartOncePermissions"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"ssm.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/ssm.amazonaws.com/AWSServiceRoleForAmazonSSM"
     ],
     "Sid":"CreateSystemsManagerSLRPermissions"
    },
    {
     "Action":[
      "iam:ListRoles",
      "config:DescribeConfigurationRecorders",
      "compute-optimizer:GetEnrollmentStatus",
      "support:DescribeTrustedAdvisorChecks"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReadOnlyPermissionsForEnablingExplorer"
    },
    {
     "Action":[
      "ssm:UpdateServiceSetting",
      "ssm:GetServiceSetting"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/ssm-patchmanager",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsitem/EC2",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ExplorerOnboarded",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/Association",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ComputeOptimizer",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/ConfigCompliance",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/OpsData-TrustedAdvisor",
      "arn:aws:ssm:*:*:servicesetting/ssm/opsdata/SupportCenterCase"
     ],
     "Sid":"SSMExplorerServiceSettingsPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-06-26T09:53:37+00:00"
 },
 "AWSQuickSightAssetBundleExportPolicy":{
  "CreateDate":"2024-03-27T21:31:03+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "quicksight:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:*/*",
     "Sid":"TagReadAccess"
    },
    {
     "Action":[
      "quicksight:DescribeDashboard",
      "quicksight:DescribeDashboardPermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:dashboard/*",
     "Sid":"DashboardReadAccess"
    },
    {
     "Action":[
      "quicksight:DescribeAnalysis",
      "quicksight:DescribeAnalysisPermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:analysis/*",
     "Sid":"AnalysisReadAccess"
    },
    {
     "Action":[
      "quicksight:DescribeDataSet",
      "quicksight:DescribeDataSetRefreshProperties",
      "quicksight:ListRefreshSchedules",
      "quicksight:DescribeDataSetPermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:dataset/*",
     "Sid":"DataSetReadAccess"
    },
    {
     "Action":[
      "quicksight:DescribeDataSource",
      "quicksight:DescribeDataSourcePermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:datasource/*",
     "Sid":"DataSourceReadAccess"
    },
    {
     "Action":[
      "quicksight:DescribeTheme",
      "quicksight:DescribeThemePermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:theme/*",
     "Sid":"ThemeReadAccess"
    },
    {
     "Action":[
      "quicksight:DescribeVPCConnection",
      "quicksight:ListVPCConnections"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:vpcConnection/*",
     "Sid":"VPCConnectionReadAccess"
    },
    {
     "Action":[
      "quicksight:DescribeRefreshSchedule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:dataset/*/refresh-schedule/*",
     "Sid":"RefreshScheduleReadAccess"
    },
    {
     "Action":[
      "quicksight:DescribeAssetBundleExportJob",
      "quicksight:ListAssetBundleExportJobs",
      "quicksight:StartAssetBundleExportJob"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:asset-bundle-export-job/*",
     "Sid":"AssetBundleExportOperations"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-27T21:31:03+00:00"
 },
 "AWSQuickSightAssetBundleImportPolicy":{
  "CreateDate":"2024-03-27T21:40:34+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "quicksight:ListTagsForResource",
      "quicksight:TagResource",
      "quicksight:UntagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:*/*",
     "Sid":"TagWriteAccess"
    },
    {
     "Action":[
      "quicksight:CreateDashboard",
      "quicksight:DeleteDashboard",
      "quicksight:DescribeDashboard",
      "quicksight:UpdateDashboard",
      "quicksight:UpdateDashboardPublishedVersion",
      "quicksight:DescribeDashboardPermissions",
      "quicksight:UpdateDashboardPermissions",
      "quicksight:UpdateDashboardLinks"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:dashboard/*",
     "Sid":"DashboardWriteAccess"
    },
    {
     "Action":[
      "quicksight:CreateAnalysis",
      "quicksight:DeleteAnalysis",
      "quicksight:DescribeAnalysis",
      "quicksight:UpdateAnalysis",
      "quicksight:DescribeAnalysisPermissions",
      "quicksight:UpdateAnalysisPermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:analysis/*",
     "Sid":"AnalysisWriteAccess"
    },
    {
     "Action":[
      "quicksight:CreateDataSet",
      "quicksight:DeleteDataSet",
      "quicksight:DescribeDataSet",
      "quicksight:PassDataSet",
      "quicksight:UpdateDataSet",
      "quicksight:DeleteDataSetRefreshProperties",
      "quicksight:DescribeDataSetRefreshProperties",
      "quicksight:PutDataSetRefreshProperties",
      "quicksight:UpdateDataSetPermissions",
      "quicksight:DescribeDataSetPermissions",
      "quicksight:ListRefreshSchedules"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:dataset/*",
     "Sid":"DataSetWriteAccess"
    },
    {
     "Action":[
      "quicksight:CreateDataSource",
      "quicksight:DescribeDataSource",
      "quicksight:DeleteDataSource",
      "quicksight:PassDataSource",
      "quicksight:UpdateDataSource",
      "quicksight:UpdateDataSourcePermissions",
      "quicksight:DescribeDataSourcePermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:datasource/*",
     "Sid":"DataSourceWriteAccess"
    },
    {
     "Action":[
      "quicksight:CreateTheme",
      "quicksight:DeleteTheme",
      "quicksight:DescribeTheme",
      "quicksight:UpdateTheme",
      "quicksight:DescribeThemePermissions",
      "quicksight:UpdateThemePermissions"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:theme/*",
     "Sid":"ThemeWriteAccess"
    },
    {
     "Action":[
      "quicksight:CreateRefreshSchedule",
      "quicksight:DescribeRefreshSchedule",
      "quicksight:DeleteRefreshSchedule",
      "quicksight:UpdateRefreshSchedule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:dataset/*/refresh-schedule/*",
     "Sid":"RefreshScheduleWriteAccess"
    },
    {
     "Action":[
      "quicksight:ListVPCConnections",
      "quicksight:CreateVPCConnection",
      "quicksight:DescribeVPCConnection",
      "quicksight:DeleteVPCConnection",
      "quicksight:UpdateVPCConnection"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:vpcConnection/*",
     "Sid":"VPCConnectionWriteAccess"
    },
    {
     "Action":[
      "quicksight:DescribeAssetBundleImportJob",
      "quicksight:ListAssetBundleImportJobs",
      "quicksight:StartAssetBundleImportJob"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:quicksight:*:*:asset-bundle-import-job/*",
     "Sid":"AssetBundleImportOperations"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-27T21:40:34+00:00"
 },
 "AWSQuickSightDescribeRDS":{
  "CreateDate":"2015-11-10T23:24:50+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "rds:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-11-10T23:24:50+00:00"
 },
 "AWSQuickSightDescribeRedshift":{
  "CreateDate":"2015-11-10T23:25:01+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "redshift:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-11-10T23:25:01+00:00"
 },
 "AWSQuickSightElasticsearchPolicy":{
  "CreateDate":"2020-09-09T17:27:19+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "es:ESHttpGet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:es:*:*:domain/*/",
      "arn:aws:es:*:*:domain/*/_cluster/settings",
      "arn:aws:es:*:*:domain/*/_cat/indices"
     ]
    },
    {
     "Action":"es:ListDomainNames",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "es:DescribeElasticsearchDomain",
      "es:DescribeDomain"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:es:*:*:domain/*"
     ]
    },
    {
     "Action":[
      "es:ESHttpPost",
      "es:ESHttpGet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:es:*:*:domain/*/_opendistro/_sql",
      "arn:aws:es:*:*:domain/*/_plugin/_sql"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-07T23:25:55+00:00"
 },
 "AWSQuickSightIoTAnalyticsAccess":{
  "CreateDate":"2017-11-29T17:00:54+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iotanalytics:ListDatasets",
      "iotanalytics:DescribeDataset",
      "iotanalytics:GetDatasetContent"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-11-29T17:00:54+00:00"
 },
 "AWSQuickSightListIAM":{
  "CreateDate":"2015-11-10T23:25:07+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-11-10T23:25:07+00:00"
 },
 "AWSQuickSightSageMakerPolicy":{
  "CreateDate":"2020-01-17T17:18:13+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sagemaker:DescribeTransformJob",
      "sagemaker:StopTransformJob",
      "sagemaker:CreateTransformJob"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:sagemaker:*:*:transform-job/quicksight-auto-generated-*",
     "Sid":"SageMakerTransformJobAccess"
    },
    {
     "Action":[
      "sagemaker:ListModels",
      "sagemaker:DescribeModel"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SageMakerModelReadAccess"
    },
    {
     "Action":"s3:GetObject",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::quicksight-ml.*",
      "arn:aws:s3:::sagemaker*"
     ],
     "Sid":"S3ObjectReadAccess"
    },
    {
     "Action":"s3:PutObject",
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::sagemaker*",
     "Sid":"S3ObjectUpdateAccess"
    },
    {
     "Action":"s3:ListBucket",
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::sagemaker*",
     "Sid":"S3BucketReadAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-10-30T17:57:43+00:00"
 },
 "AWSQuickSightTimestreamPolicy":{
  "CreateDate":"2020-09-30T21:47:03+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "timestream:Select",
      "timestream:CancelQuery",
      "timestream:ListTables",
      "timestream:ListDatabases",
      "timestream:ListMeasures",
      "timestream:DescribeTable",
      "timestream:DescribeDatabase",
      "timestream:SelectValues",
      "timestream:DescribeEndpoints"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-09-30T21:47:03+00:00"
 },
 "AWSQuicksightAthenaAccess":{
  "CreateDate":"2016-12-09T02:31:03+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "athena:BatchGetQueryExecution",
      "athena:CancelQueryExecution",
      "athena:GetCatalogs",
      "athena:GetExecutionEngine",
      "athena:GetExecutionEngines",
      "athena:GetNamespace",
      "athena:GetNamespaces",
      "athena:GetQueryExecution",
      "athena:GetQueryExecutions",
      "athena:GetQueryResults",
      "athena:GetQueryResultsStream",
      "athena:GetTable",
      "athena:GetTables",
      "athena:ListQueryExecutions",
      "athena:RunQuery",
      "athena:StartQueryExecution",
      "athena:StopQueryExecution",
      "athena:ListWorkGroups",
      "athena:ListEngineVersions",
      "athena:GetWorkGroup",
      "athena:GetDataCatalog",
      "athena:GetDatabase",
      "athena:GetTableMetadata",
      "athena:ListDataCatalogs",
      "athena:ListDatabases",
      "athena:ListTableMetadata"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "glue:CreateDatabase",
      "glue:DeleteDatabase",
      "glue:GetDatabase",
      "glue:GetDatabases",
      "glue:UpdateDatabase",
      "glue:CreateTable",
      "glue:DeleteTable",
      "glue:BatchDeleteTable",
      "glue:UpdateTable",
      "glue:GetTable",
      "glue:GetTables",
      "glue:BatchCreatePartition",
      "glue:CreatePartition",
      "glue:DeletePartition",
      "glue:BatchDeletePartition",
      "glue:UpdatePartition",
      "glue:GetPartition",
      "glue:GetPartitions",
      "glue:BatchGetPartition"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:ListBucketMultipartUploads",
      "s3:ListMultipartUploadParts",
      "s3:AbortMultipartUpload",
      "s3:CreateBucket",
      "s3:PutObject",
      "s3:PutBucketPublicAccessBlock"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-athena-query-results-*"
     ]
    },
    {
     "Action":[
      "lakeformation:GetDataAccess"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-07T20:09:06+00:00"
 },
 "AWSQuicksightOpenSearchPolicy":{
  "CreateDate":"2021-09-07T23:26:19+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "es:ESHttpGet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:es:*:*:domain/*/",
      "arn:aws:es:*:*:domain/*/_cluster/settings",
      "arn:aws:es:*:*:domain/*/_cat/indices"
     ]
    },
    {
     "Action":"es:ListDomainNames",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "es:DescribeDomain"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:es:*:*:domain/*"
     ]
    },
    {
     "Action":[
      "es:ESHttpPost",
      "es:ESHttpGet"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:es:*:*:domain/*/_opendistro/_sql",
      "arn:aws:es:*:*:domain/*/_plugin/_sql"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-07T23:26:19+00:00"
 },
 "AWSReachabilityAnalyzerServiceRolePolicy":{
  "CreateDate":"2022-11-23T17:12:28+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:ListStackResources",
      "directconnect:DescribeConnections",
      "directconnect:DescribeDirectConnectGatewayAssociations",
      "directconnect:DescribeDirectConnectGatewayAttachments",
      "directconnect:DescribeDirectConnectGateways",
      "directconnect:DescribeVirtualGateways",
      "directconnect:DescribeVirtualInterfaces",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeCustomerGateways",
      "ec2:DescribeInstances",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeManagedPrefixLists",
      "ec2:DescribeNatGateways",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribePrefixLists",
      "ec2:DescribeRegions",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeTransitGatewayAttachments",
      "ec2:DescribeTransitGatewayConnects",
      "ec2:DescribeTransitGatewayPeeringAttachments",
      "ec2:DescribeTransitGatewayRouteTables",
      "ec2:DescribeTransitGatewayVpcAttachments",
      "ec2:DescribeTransitGateways",
      "ec2:DescribeVpcEndpointServiceConfigurations",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeVpcPeeringConnections",
      "ec2:DescribeVpcs",
      "ec2:DescribeVpnConnections",
      "ec2:DescribeVpnGateways",
      "ec2:GetManagedPrefixListEntries",
      "ec2:GetTransitGatewayRouteTablePropagations",
      "ec2:SearchTransitGatewayRoutes",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeLoadBalancerAttributes",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeRules",
      "elasticloadbalancing:DescribeTags",
      "elasticloadbalancing:DescribeTargetGroupAttributes",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeTargetHealth",
      "network-firewall:DescribeFirewall",
      "network-firewall:DescribeFirewallPolicy",
      "network-firewall:DescribeResourcePolicy",
      "network-firewall:DescribeRuleGroup",
      "network-firewall:ListFirewallPolicies",
      "network-firewall:ListFirewalls",
      "network-firewall:ListRuleGroups",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListAccounts",
      "organizations:ListDelegatedAdministrators",
      "resource-groups:ListGroups",
      "resource-groups:ListGroupResources",
      "tag:GetResources",
      "tiros:CreateQuery",
      "tiros:ExtendQuery",
      "tiros:GetQueryAnswer",
      "tiros:GetQueryExplanation",
      "tiros:GetQueryExtensionAccounts"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReachabilityAnalyzerPermissions"
    },
    {
     "Action":[
      "apigateway:GET"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/restapis",
      "arn:aws:apigateway:*::/restapis/*/stages",
      "arn:aws:apigateway:*::/restapis/*/stages/*",
      "arn:aws:apigateway:*::/vpclinks"
     ],
     "Sid":"ApigatewayPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-09-10T16:04:52+00:00"
 },
 "AWSRefactoringToolkitFullAccess":{
  "CreateDate":"2022-10-25T16:41:15+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "a2c:GetContainerizationJobDetails",
      "a2c:GetDeploymentJobDetails",
      "a2c:StartContainerizationJob",
      "a2c:StartDeploymentJob"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"App2ContainerAccess"
    },
    {
     "Action":[
      "cloudformation:CreateChangeSet",
      "cloudformation:CreateStack",
      "cloudformation:DescribeChangeSet",
      "cloudformation:DescribeStackEvents",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:UpdateStack",
      "cloudformation:TagResource",
      "cloudformation:UntagResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:*:cloudformation:*:*:stack/a2c-app-*",
      "arn:*:cloudformation:*:*:stack/a2c-build-*",
      "arn:*:cloudformation:*:*:stack/application-transformation-app-*"
     ],
     "Sid":"CloudformationExecutionAccess"
    },
    {
     "Action":[
      "codebuild:CreateProject",
      "codebuild:UpdateProject"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/a2c-generated":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:codebuild:*:*:project/*",
     "Sid":"CodeBuildCreateAccess"
    },
    {
     "Action":[
      "codebuild:StartBuild"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:codebuild:*:*:project/*",
     "Sid":"CodeBuildExecutionAccess"
    },
    {
     "Action":[
      "ec2:CreateSecurityGroup"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CreateSecurityGroupAccess"
    },
    {
     "Action":[
      "ec2:CreateInternetGateway",
      "ec2:CreateKeyPair",
      "ec2:CreateRoute",
      "ec2:CreateRouteTable",
      "ec2:CreateSubnet",
      "ec2:CreateTags",
      "ec2:CreateVpc",
      "ec2:AuthorizeSecurityGroupIngress"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/a2c-generated":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Ec2CreateAccess"
    },
    {
     "Action":[
      "ec2:CreateInternetGateway",
      "ec2:CreateKeyPair",
      "ec2:CreateRoute",
      "ec2:CreateRouteTable",
      "ec2:CreateSubnet",
      "ec2:CreateTags",
      "ec2:CreateVpc",
      "ec2:AuthorizeSecurityGroupIngress"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/application-transformation":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Ec2CreateAccessATS"
    },
    {
     "Action":[
      "ec2:AssociateRouteTable",
      "ec2:AttachInternetGateway",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:DeleteTags",
      "ec2:ModifySubnetAttribute",
      "ec2:ModifyVpcAttribute",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:CreateSubnet",
      "ec2:CreateRoute",
      "ec2:CreateRouteTable"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/a2c-generated":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Ec2ModifyAccess"
    },
    {
     "Action":[
      "ec2:AssociateRouteTable",
      "ec2:AttachInternetGateway",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:DeleteTags",
      "ec2:ModifySubnetAttribute",
      "ec2:ModifyVpcAttribute",
      "ec2:RevokeSecurityGroupIngress",
      "ec2:CreateSubnet",
      "ec2:CreateRoute",
      "ec2:CreateRouteTable"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/application-transformation":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"Ec2ModifyAccessATS"
    },
    {
     "Action":[
      "ecr:CreateRepository",
      "ecr:TagResource"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/a2c-generated":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:ecr:*:*:repository/*",
     "Sid":"EcrCreateAccess"
    },
    {
     "Action":[
      "ecr:CreateRepository",
      "ecr:TagResource"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/application-transformation":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:ecr:*:*:repository/*",
     "Sid":"EcrCreateAccessATS"
    },
    {
     "Action":[
      "ecr:GetLifecyclePolicy",
      "ecr:GetRepositoryPolicy",
      "ecr:ListImages",
      "ecr:ListTagsForResource",
      "ecr:TagResource",
      "ecr:UntagResource"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/a2c-generated":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:ecr:*:*:repository/*",
     "Sid":"EcrModifyAccess"
    },
    {
     "Action":[
      "ecr:GetLifecyclePolicy",
      "ecr:GetRepositoryPolicy",
      "ecr:ListImages",
      "ecr:ListTagsForResource",
      "ecr:TagResource",
      "ecr:UntagResource"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/application-transformation":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:ecr:*:*:repository/*",
     "Sid":"EcrModifyAccessATS"
    },
    {
     "Action":[
      "ecs:CreateCluster",
      "ecs:CreateService",
      "ecs:RegisterTaskDefinition",
      "ecs:TagResource"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/a2c-generated":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EcsCreateAccess"
    },
    {
     "Action":[
      "ecs:CreateCluster",
      "ecs:CreateService",
      "ecs:RegisterTaskDefinition",
      "ecs:TagResource"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/application-transformation":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EcsCreateAccessATS"
    },
    {
     "Action":[
      "ecs:UpdateService",
      "ecs:TagResource",
      "ecs:UntagResource"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/a2c-generated":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EcsModifyAccess"
    },
    {
     "Action":[
      "ecs:UpdateService",
      "ecs:TagResource",
      "ecs:UntagResource"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/application-transformation":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EcsModifyAccessATS"
    },
    {
     "Action":[
      "ecs:DescribeTaskDefinition"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"cloudformation.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EcsReadTaskDefinitionAccess"
    },
    {
     "Action":[
      "ecs:ExecuteCommand"
     ],
     "Condition":{
      "StringLike":{
       "ecs:container-name":"a2c-sidecar"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EcsExecuteCommandInSidecar"
    },
    {
     "Action":[
      "ecs:ExecuteCommand"
     ],
     "Condition":{
      "StringLike":{
       "ecs:container-name":"application-transformation-sidecar"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EcsExecuteCommandInSidecarATS"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"ecs.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/ecs.amazonaws.com/AWSServiceRoleForECS",
     "Sid":"CreateEcsServiceLinkedRoleAccess"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:TagResource"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "a2c-generated"
       ]
      },
      "Null":{
       "aws:RequestTag/a2c-generated":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/codebuild/*:*",
      "arn:aws:logs:*:*:log-group:/aws/ecs/containerinsights/*:*",
      "arn:aws:logs:*:*:log-group:/aws/ecs/container-logs/*:*"
     ],
     "Sid":"CloudwatchCreateAccess"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:TagResource"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "application-transformation"
       ]
      },
      "Null":{
       "aws:RequestTag/application-transformation":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/ecs/containerinsights/*:*",
      "arn:aws:logs:*:*:log-group:/aws/ecs/container-logs/*:*"
     ],
     "Sid":"CloudwatchCreateAccessATS"
    },
    {
     "Action":[
      "logs:GetLogEvents"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/a2c-generated":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/codebuild/*:*",
      "arn:aws:logs:*:*:log-group:/aws/ecs/containerinsights/*:*",
      "arn:aws:logs:*:*:log-group:/aws/ecs/container-logs/*:*"
     ],
     "Sid":"CloudwatchGetAccess"
    },
    {
     "Action":[
      "logs:GetLogEvents"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/application-transformation":"false"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/ecs/containerinsights/*:*",
      "arn:aws:logs:*:*:log-group:/aws/ecs/container-logs/*:*"
     ],
     "Sid":"CloudwatchGetAccessATS"
    },
    {
     "Action":[
      "ssm:AddTagsToResource",
      "ssm:GetParameters",
      "ssm:PutParameter",
      "ssm:RemoveTagsFromResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/a2c-generated-check-ecs-slr-*",
     "Sid":"SsmParameterAccess"
    },
    {
     "Action":[
      "ssm:DescribeSessions",
      "ssmmessages:CreateControlChannel",
      "ssmmessages:CreateDataChannel",
      "ssmmessages:OpenControlChannel",
      "ssmmessages:OpenDataChannel"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SsmMessagesAccess"
    },
    {
     "Action":[
      "s3:DeleteObject",
      "s3:GetObject",
      "s3:PutObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::*/refactoringtoolkit*",
      "arn:aws:s3:::*/a2c-generated*",
      "arn:aws:s3:::*/application-transformation*"
     ],
     "Sid":"S3ObjectAccess"
    },
    {
     "Action":[
      "s3:ListBucket"
     ],
     "Condition":{
      "StringLike":{
       "s3:prefix":[
        "application-transformation",
        "refactoringtoolkit"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*",
     "Sid":"S3ListAccess"
    },
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "cloudformation:ListStacks",
      "clouddirectory:ListDirectories",
      "codebuild:BatchGetProjects",
      "codebuild:BatchGetBuilds",
      "ds:DescribeDirectories",
      "ec2:DescribeAccountAttributes",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeImages",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeRegions",
      "ecr:DescribeImages",
      "ecr:DescribeRepositories",
      "ecs:DescribeClusters",
      "ecs:DescribeServices",
      "ecs:DescribeTasks",
      "ecs:ListTagsForResource",
      "ecs:ListTasks",
      "iam:ListRoles",
      "s3:GetBucketLocation",
      "s3:GetBucketVersioning",
      "s3:ListAllMyBuckets",
      "secretsmanager:ListSecrets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReadOnlyAccess"
    },
    {
     "Action":"iam:GetRole",
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/ecs.amazonaws.com/AWSServiceRoleForECS",
     "Sid":"GetECSSLR"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws.portingassistant.dotnet.datastore",
      "arn:aws:s3:::aws.portingassistant.dotnet.datastore/*"
     ],
     "Sid":"PortingAssistantFullAccess"
    },
    {
     "Action":[
      "application-transformation:StartPortingCompatibilityAssessment",
      "application-transformation:GetPortingCompatibilityAssessment",
      "application-transformation:StartPortingRecommendationAssessment",
      "application-transformation:GetPortingRecommendationAssessment",
      "application-transformation:PutLogData",
      "application-transformation:PutMetricData",
      "application-transformation:StartContainerization",
      "application-transformation:GetContainerization",
      "application-transformation:StartDeployment",
      "application-transformation:GetDeployment"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ApplicationTransformationAccess"
    },
    {
     "Action":[
      "kms:Decrypt",
      "kms:Encrypt",
      "kms:DescribeKey",
      "kms:GenerateDataKey"
     ],
     "Condition":{
      "ForAnyValue:StringLike":{
       "kms:ResourceAliases":"alias/application-transformation*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:kms:*::*",
     "Sid":"KmsAccess"
    },
    {
     "Action":[
      "ecr:InitiateLayerUpload",
      "ecr:PutImage",
      "ecr:UploadLayerPart",
      "ecr:CompleteLayerUpload",
      "ecr:BatchCheckLayerAvailability",
      "ecr:GetDownloadUrlForLayer"
     ],
     "Condition":{
      "Null":{
       "ecr:ResourceTag/application-transformation":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:ecr:*:*:repository/*",
     "Sid":"EcrPushAccess"
    },
    {
     "Action":[
      "ecr:GetAuthorizationToken"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EcrAuthAccess"
    },
    {
     "Action":[
      "kms:CreateGrant"
     ],
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":true
      },
      "ForAnyValue:StringLike":{
       "kms:ResourceAliases":"alias/application-transformation*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:kms:*::*",
     "Sid":"KmsCreateGrantAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-25T18:43:14+00:00"
 },
 "AWSRefactoringToolkitSidecarPolicy":{
  "CreateDate":"2022-10-25T16:41:12+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssmmessages:OpenControlChannel",
      "ssmmessages:CreateControlChannel",
      "ssmmessages:OpenDataChannel",
      "ssmmessages:CreateDataChannel"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SsmMessagesAccess"
    },
    {
     "Action":[
      "s3:GetObject"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*/refactoringtoolkit*",
     "Sid":"S3GetObjectAccess"
    },
    {
     "Action":[
      "s3:ListBucket"
     ],
     "Condition":{
      "StringLike":{
       "s3:prefix":"refactoringtoolkit*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::*",
     "Sid":"S3ListBucketAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-10-29T22:15:51+00:00"
 },
 "AWSRepostSpaceSupportOperationsPolicy":{
  "CreateDate":"2023-11-26T21:52:15+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "support:AddAttachmentsToSet",
      "support:AddCommunicationToCase",
      "support:CreateCase",
      "support:DescribeCases",
      "support:DescribeCommunications",
      "support:ResolveCase"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"RepostSpaceSupportOperations"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-26T21:52:15+00:00"
 },
 "AWSResilienceHubAsssessmentExecutionPolicy":{
  "CreateDate":"2023-06-27T12:32:15+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "application-autoscaling:DescribeScalableTargets",
      "autoscaling:DescribeAutoScalingGroups",
      "backup:DescribeBackupVault",
      "backup:GetBackupPlan",
      "backup:GetBackupSelection",
      "backup:ListBackupPlans",
      "backup:ListBackupSelections",
      "cloudformation:DescribeStacks",
      "cloudformation:ListStackResources",
      "cloudformation:ValidateTemplate",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:GetMetricData",
      "cloudwatch:GetMetricStatistics",
      "datasync:DescribeTask",
      "datasync:ListLocations",
      "datasync:ListTasks",
      "devops-guru:ListMonitoredResources",
      "dlm:GetLifecyclePolicies",
      "dlm:GetLifecyclePolicy",
      "docdb-elastic:GetCluster",
      "docdb-elastic:GetClusterSnapshot",
      "docdb-elastic:ListClusterSnapshots",
      "docdb-elastic:ListTagsForResource",
      "drs:DescribeJobs",
      "drs:DescribeSourceServers",
      "drs:GetReplicationConfiguration",
      "ds:DescribeDirectories",
      "dynamodb:DescribeContinuousBackups",
      "dynamodb:DescribeGlobalTable",
      "dynamodb:DescribeLimits",
      "dynamodb:DescribeTable",
      "dynamodb:ListGlobalTables",
      "dynamodb:ListTagsOfResource",
      "ec2:DescribeAvailabilityZones",
      "ec2:DescribeFastSnapshotRestores",
      "ec2:DescribeFleets",
      "ec2:DescribeHosts",
      "ec2:DescribeInstances",
      "ec2:DescribeNatGateways",
      "ec2:DescribePlacementGroups",
      "ec2:DescribeRegions",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSubnets",
      "ec2:DescribeTags",
      "ec2:DescribeVolumes",
      "ec2:DescribeVpcEndpoints",
      "ecr:DescribeRegistry",
      "ecs:DescribeCapacityProviders",
      "ecs:DescribeClusters",
      "ecs:DescribeContainerInstances",
      "ecs:DescribeServices",
      "ecs:DescribeTaskDefinition",
      "ecs:ListContainerInstances",
      "ecs:ListServices",
      "eks:DescribeCluster",
      "eks:DescribeFargateProfile",
      "eks:DescribeNodegroup",
      "eks:ListFargateProfiles",
      "eks:ListNodegroups",
      "elasticache:DescribeCacheClusters",
      "elasticache:DescribeGlobalReplicationGroups",
      "elasticache:DescribeReplicationGroups",
      "elasticache:DescribeSnapshots",
      "elasticache:DescribeServerlessCaches",
      "elasticache:DescribeServerlessCacheSnapshots",
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:DescribeLifecycleConfiguration",
      "elasticfilesystem:DescribeMountTargets",
      "elasticfilesystem:DescribeReplicationConfigurations",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTargetGroups",
      "elasticloadbalancing:DescribeTargetHealth",
      "fis:GetExperimentTemplate",
      "fis:ListExperimentTemplates",
      "fis:ListExperiments",
      "fsx:DescribeFileSystems",
      "lambda:GetFunctionConcurrency",
      "lambda:GetFunctionConfiguration",
      "lambda:ListAliases",
      "lambda:ListEventSourceMappings",
      "lambda:ListFunctionEventInvokeConfigs",
      "lambda:ListVersionsByFunction",
      "rds:DescribeDBClusterSnapshots",
      "rds:DescribeDBClusters",
      "rds:DescribeDBInstanceAutomatedBackups",
      "rds:DescribeDBInstances",
      "rds:DescribeDBProxies",
      "rds:DescribeDBProxyTargets",
      "rds:DescribeDBSnapshots",
      "rds:DescribeGlobalClusters",
      "rds:ListTagsForResource",
      "resource-groups:GetGroup",
      "resource-groups:ListGroupResources",
      "route53-recovery-control-config:ListClusters",
      "route53-recovery-control-config:ListControlPanels",
      "route53-recovery-control-config:ListRoutingControls",
      "route53-recovery-readiness:GetReadinessCheckStatus",
      "route53-recovery-readiness:GetResourceSet",
      "route53-recovery-readiness:ListReadinessChecks",
      "route53:GetHealthCheck",
      "route53:ListHealthChecks",
      "route53:ListHostedZones",
      "route53:ListResourceRecordSets",
      "route53resolver:ListResolverEndpoints",
      "route53resolver:ListResolverEndpointIpAddresses",
      "s3:ListBucket",
      "servicecatalog:GetApplication",
      "servicecatalog:ListAssociatedResources",
      "sns:GetSubscriptionAttributes",
      "sns:GetTopicAttributes",
      "sns:ListSubscriptionsByTopic",
      "sqs:GetQueueAttributes",
      "sqs:GetQueueUrl",
      "ssm:DescribeAutomationExecutions",
      "states:DescribeStateMachine",
      "states:ListStateMachineVersions",
      "states:ListStateMachineAliases",
      "tag:GetResources"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSResilienceHubFullResourceStatement"
    },
    {
     "Action":[
      "apigateway:GET"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/apis/*",
      "arn:aws:apigateway:*::/restapis/*",
      "arn:aws:apigateway:*::/usageplans"
     ],
     "Sid":"AWSResilienceHubApiGatewayStatement"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:PutObject",
      "s3:GetObject"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::aws-resilience-hub-artifacts-*",
     "Sid":"AWSResilienceHubS3ArtifactStatement"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:GetBucketLogging",
      "s3:GetBucketObjectLockConfiguration",
      "s3:GetBucketPolicyStatus",
      "s3:GetBucketTagging",
      "s3:GetBucketVersioning",
      "s3:GetMultiRegionAccessPointRoutes",
      "s3:GetReplicationConfiguration",
      "s3:ListAllMyBuckets",
      "s3:ListMultiRegionAccessPoints"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSResilienceHubS3AccessStatement"
    },
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":"ResilienceHub"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSResilienceHubCloudWatchStatement"
    },
    {
     "Action":[
      "ssm:GetParametersByPath"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:parameter/ResilienceHub/*",
     "Sid":"AWSResilienceHubSSMStatement"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-09-17T13:08:36+00:00"
 },
 "AWSResourceAccessManagerFullAccess":{
  "CreateDate":"2019-06-04T17:28:22+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ram:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-06-04T17:28:22+00:00"
 },
 "AWSResourceAccessManagerReadOnlyAccess":{
  "CreateDate":"2019-12-09T20:58:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ram:Get*",
      "ram:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-09T20:58:37+00:00"
 },
 "AWSResourceAccessManagerResourceShareParticipantAccess":{
  "CreateDate":"2019-12-09T20:41:37+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ram:AcceptResourceShareInvitation",
      "ram:GetResourcePolicies",
      "ram:GetResourceShareInvitations",
      "ram:GetResourceShares",
      "ram:ListPendingInvitationResources",
      "ram:ListPrincipals",
      "ram:ListResources",
      "ram:RejectResourceShareInvitation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-12-09T20:41:37+00:00"
 },
 "AWSResourceAccessManagerServiceRolePolicy":{
  "CreateDate":"2018-11-14T19:28:28+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:DescribeOrganizationalUnit",
      "organizations:ListAccounts",
      "organizations:ListAccountsForParent",
      "organizations:ListChildren",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListParents",
      "organizations:ListRoots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:DeleteRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/ram.amazonaws.com/*"
     ],
     "Sid":"AllowDeletionOfServiceLinkedRoleForResourceAccessManager"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-14T19:28:28+00:00"
 },
 "AWSResourceExplorerFullAccess":{
  "CreateDate":"2022-11-07T20:01:20+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "resource-explorer-2:*",
      "ec2:DescribeRegions",
      "ram:ListResources",
      "ram:GetResourceShares",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ResourceExplorerConsoleFullAccess"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "resource-explorer-2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ResourceExplorerSLRAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-14T16:53:46+00:00"
 },
 "AWSResourceExplorerOrganizationsAccess":{
  "CreateDate":"2023-11-14T17:01:12+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "resource-explorer-2:*",
      "ec2:DescribeRegions",
      "ram:ListResources",
      "ram:GetResourceShares",
      "organizations:ListAccounts",
      "organizations:ListRoots",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListAccountsForParent",
      "organizations:ListDelegatedAdministrators",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReadOnlyAccess"
    },
    {
     "Action":[
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/resource-explorer-2.amazonaws.com/AWSServiceRoleForResourceExplorer",
     "Sid":"ResourceExplorerGetSLRAccess"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "resource-explorer-2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ResourceExplorerCreateSLRAccess"
    },
    {
     "Action":[
      "organizations:EnableAWSServiceAccess",
      "organizations:DisableAWSServiceAccess",
      "organizations:RegisterDelegatedAdministrator",
      "organizations:DeregisterDelegatedAdministrator"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":[
        "resource-explorer-2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"OrganizationsAdministratorAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-14T17:01:12+00:00"
 },
 "AWSResourceExplorerReadOnlyAccess":{
  "CreateDate":"2022-11-07T19:56:00+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "resource-explorer-2:Get*",
      "resource-explorer-2:List*",
      "resource-explorer-2:Search",
      "resource-explorer-2:BatchGetView",
      "ec2:DescribeRegions",
      "ram:ListResources",
      "ram:GetResourceShares",
      "organizations:DescribeOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ResourceExplorerReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-14T16:43:41+00:00"
 },
 "AWSResourceExplorerServiceRolePolicy":{
  "CreateDate":"2022-10-25T20:35:29+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudtrail:CreateServiceLinkedChannel",
      "cloudtrail:GetServiceLinkedChannel"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudtrail:*:*:channel/aws-service-channel/resource-explorer-2/*"
     ],
     "Sid":"CloudTrailEventsAccess"
    },
    {
     "Action":[
      "apigateway:GET"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/restapis",
      "arn:aws:apigateway:*::/restapis/*/deployments"
     ],
     "Sid":"ApiGatewayAccess"
    },
    {
     "Action":[
      "access-analyzer:ListAnalyzers",
      "acm-pca:ListCertificateAuthorities",
      "amplify:ListApps",
      "amplify:ListBackendEnvironments",
      "amplify:ListBranches",
      "amplify:ListDomainAssociations",
      "amplifyuibuilder:ListComponents",
      "amplifyuibuilder:ListThemes",
      "app-integrations:ListEventIntegrations",
      "apprunner:ListServices",
      "apprunner:ListVpcConnectors",
      "appstream:DescribeAppBlocks",
      "appstream:DescribeApplications",
      "appstream:DescribeFleets",
      "appstream:DescribeImageBuilders",
      "appstream:DescribeStacks",
      "appsync:ListGraphqlApis",
      "aps:ListRuleGroupsNamespaces",
      "aps:ListWorkspaces",
      "athena:ListDataCatalogs",
      "athena:ListWorkGroups",
      "autoscaling:DescribeAutoScalingGroups",
      "backup:ListBackupPlans",
      "backup:ListReportPlans",
      "batch:DescribeComputeEnvironments",
      "batch:DescribeJobQueues",
      "batch:ListSchedulingPolicies",
      "cloudformation:ListStacks",
      "cloudformation:ListStackSets",
      "cloudfront:ListCachePolicies",
      "cloudfront:ListCloudFrontOriginAccessIdentities",
      "cloudfront:ListDistributions",
      "cloudfront:ListFieldLevelEncryptionConfigs",
      "cloudfront:ListFieldLevelEncryptionProfiles",
      "cloudfront:ListFunctions",
      "cloudfront:ListOriginAccessControls",
      "cloudfront:ListOriginRequestPolicies",
      "cloudfront:ListRealtimeLogConfigs",
      "cloudfront:ListResponseHeadersPolicies",
      "cloudtrail:ListTrails",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DescribeInsightRules",
      "cloudwatch:ListDashboards",
      "cloudwatch:ListMetricStreams",
      "codeartifact:ListDomains",
      "codeartifact:ListRepositories",
      "codebuild:ListProjects",
      "codecommit:ListRepositories",
      "codeguru-profiler:ListProfilingGroups",
      "codepipeline:ListPipelines",
      "codestar-connections:ListConnections",
      "cognito-identity:ListIdentityPools",
      "cognito-idp:ListUserPools",
      "databrew:ListDatasets",
      "databrew:ListRecipes",
      "databrew:ListRulesets",
      "detective:ListGraphs",
      "ds:DescribeDirectories",
      "dynamodb:ListStreams",
      "dynamodb:ListTables",
      "ec2:DescribeAddresses",
      "ec2:DescribeCapacityReservationFleets",
      "ec2:DescribeCapacityReservations",
      "ec2:DescribeCarrierGateways",
      "ec2:DescribeClientVpnEndpoints",
      "ec2:DescribeCustomerGateways",
      "ec2:DescribeDhcpOptions",
      "ec2:DescribeEgressOnlyInternetGateways",
      "ec2:DescribeElasticGpus",
      "ec2:DescribeExportImageTasks",
      "ec2:DescribeExportTasks",
      "ec2:DescribeFleets",
      "ec2:DescribeFlowLogs",
      "ec2:DescribeFpgaImages",
      "ec2:DescribeHostReservations",
      "ec2:DescribeHosts",
      "ec2:DescribeImages",
      "ec2:DescribeImportImageTasks",
      "ec2:DescribeImportSnapshotTasks",
      "ec2:DescribeInstanceEventWindows",
      "ec2:DescribeInstances",
      "ec2:DescribeInternetGateways",
      "ec2:DescribeIpamPools",
      "ec2:DescribeIpams",
      "ec2:DescribeIpamScopes",
      "ec2:DescribeKeyPairs",
      "ec2:DescribeLaunchTemplates",
      "ec2:DescribeManagedPrefixLists",
      "ec2:DescribeNatGateways",
      "ec2:DescribeNetworkAcls",
      "ec2:DescribeNetworkInsightsAccessScopeAnalyses",
      "ec2:DescribeNetworkInsightsAccessScopes",
      "ec2:DescribeNetworkInsightsAnalyses",
      "ec2:DescribeNetworkInsightsPaths",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribePlacementGroups",
      "ec2:DescribePublicIpv4Pools",
      "ec2:DescribeReservedInstances",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSecurityGroupRules",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSpotFleetRequests",
      "ec2:DescribeSpotInstanceRequests",
      "ec2:DescribeSubnets",
      "ec2:DescribeTrafficMirrorFilters",
      "ec2:DescribeTrafficMirrorSessions",
      "ec2:DescribeTrafficMirrorTargets",
      "ec2:DescribeTransitGatewayAttachments",
      "ec2:DescribeTransitGatewayConnectPeers",
      "ec2:DescribeTransitGatewayMulticastDomains",
      "ec2:DescribeTransitGatewayPolicyTables",
      "ec2:DescribeTransitGatewayRouteTableAnnouncements",
      "ec2:DescribeTransitGatewayRouteTables",
      "ec2:DescribeTransitGateways",
      "ec2:DescribeVerifiedAccessEndpoints",
      "ec2:DescribeVerifiedAccessGroups",
      "ec2:DescribeVerifiedAccessInstances",
      "ec2:DescribeVerifiedAccessTrustProviders",
      "ec2:DescribeVolumes",
      "ec2:DescribeVpcEndpoints",
      "ec2:DescribeVpcEndpointServices",
      "ec2:DescribeVpcPeeringConnections",
      "ec2:DescribeVpcs",
      "ec2:DescribeVpnConnections",
      "ec2:DescribeVpnGateways",
      "ec2:GetSubnetCidrReservations",
      "ecr:DescribeRepositories",
      "ecr-public:DescribeRepositories",
      "ecs:DescribeCapacityProviders",
      "ecs:DescribeServices",
      "ecs:ListClusters",
      "ecs:ListContainerInstances",
      "ecs:ListServices",
      "ecs:ListTaskDefinitions",
      "ecs:ListTasks",
      "elasticache:DescribeCacheClusters",
      "elasticache:DescribeCacheParameterGroups",
      "elasticache:DescribeCacheSecurityGroups",
      "elasticache:DescribeCacheSubnetGroups",
      "elasticache:DescribeGlobalReplicationGroups",
      "elasticache:DescribeReplicationGroups",
      "elasticache:DescribeReservedCacheNodes",
      "elasticache:DescribeSnapshots",
      "elasticache:DescribeUserGroups",
      "elasticache:DescribeUsers",
      "elasticbeanstalk:DescribeApplications",
      "elasticbeanstalk:DescribeApplicationVersions",
      "elasticbeanstalk:DescribeEnvironments",
      "elasticfilesystem:DescribeAccessPoints",
      "elasticfilesystem:DescribeFileSystems",
      "elasticloadbalancing:DescribeListeners",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeRules",
      "elasticloadbalancing:DescribeTargetGroups",
      "emr-serverless:ListApplications",
      "es:ListDomainNames",
      "events:ListEventBuses",
      "events:ListRules",
      "evidently:ListExperiments",
      "evidently:ListFeatures",
      "evidently:ListLaunches",
      "evidently:ListProjects",
      "finspace:ListEnvironments",
      "firehose:ListDeliveryStreams",
      "fis:ListExperimentTemplates",
      "forecast:ListDatasetGroups",
      "forecast:ListDatasets",
      "frauddetector:GetDetectors",
      "frauddetector:GetEntityTypes",
      "frauddetector:GetEventTypes",
      "frauddetector:GetLabels",
      "frauddetector:GetOutcomes",
      "frauddetector:GetVariables",
      "gamelift:ListAliases",
      "geo:ListPlaceIndexes",
      "geo:ListTrackers",
      "greengrass:ListComponents",
      "globalaccelerator:ListAccelerators",
      "globalaccelerator:ListEndpointGroups",
      "globalaccelerator:ListListeners",
      "glue:GetDatabases",
      "glue:GetJobs",
      "glue:GetTables",
      "glue:GetTriggers",
      "greengrass:ListComponentVersions",
      "greengrass:ListGroups",
      "healthlake:ListFHIRDatastores",
      "iam:ListGroups",
      "iam:ListInstanceProfiles",
      "iam:ListOpenIDConnectProviders",
      "iam:ListPolicies",
      "iam:ListRoles",
      "iam:ListSAMLProviders",
      "iam:ListServerCertificates",
      "iam:ListUsers",
      "iam:ListVirtualMFADevices",
      "imagebuilder:ListComponentBuildVersions",
      "imagebuilder:ListComponents",
      "imagebuilder:ListContainerRecipes",
      "imagebuilder:ListDistributionConfigurations",
      "imagebuilder:ListImageBuildVersions",
      "imagebuilder:ListImagePipelines",
      "imagebuilder:ListImageRecipes",
      "imagebuilder:ListImages",
      "imagebuilder:ListInfrastructureConfigurations",
      "iotanalytics:ListChannels",
      "iotanalytics:ListDatasets",
      "iotanalytics:ListDatastores",
      "iotanalytics:ListPipelines",
      "iotevents:ListAlarmModels",
      "iotevents:ListDetectorModels",
      "iotevents:ListInputs",
      "iot:ListJobTemplates",
      "iot:ListAuthorizers",
      "iot:ListMitigationActions",
      "iot:ListPolicies",
      "iot:ListProvisioningTemplates",
      "iot:ListRoleAliases",
      "iot:ListSecurityProfiles",
      "iot:ListThings",
      "iot:ListTopicRuleDestinations",
      "iot:ListTopicRules",
      "iotsitewise:ListAssetModels",
      "iotsitewise:ListAssets",
      "iotsitewise:ListGateways",
      "iottwinmaker:ListComponentTypes",
      "iottwinmaker:ListEntities",
      "iottwinmaker:ListScenes",
      "iottwinmaker:ListWorkspaces",
      "kafka:ListConfigurations",
      "kms:ListKeys",
      "ivs:ListChannels",
      "ivs:ListStreamKeys",
      "kafka:ListClusters",
      "kinesis:ListStreamConsumers",
      "kinesis:ListStreams",
      "kinesisanalytics:ListApplications",
      "kinesisvideo:ListStreams",
      "lambda:ListAliases",
      "lambda:ListCodeSigningConfigs",
      "lambda:ListEventSourceMappings",
      "lambda:ListFunctions",
      "lambda:ListLayers",
      "lambda:ListLayerVersions",
      "lex:ListBots",
      "lex:ListBotAliases",
      "logs:DescribeDestinations",
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams",
      "lookoutmetrics:ListAlerts",
      "lookoutvision:ListProjects",
      "mediapackage:ListChannels",
      "mediapackage:ListOriginEndpoints",
      "mediapackage-vod:ListPackagingConfigurations",
      "mediapackage-vod:ListPackagingGroups",
      "mq:ListBrokers",
      "mediatailor:ListPlaybackConfigurations",
      "memorydb:DescribeACLs",
      "memorydb:DescribeClusters",
      "memorydb:DescribeParameterGroups",
      "memorydb:DescribeUsers",
      "mobiletargeting:GetApps",
      "mobiletargeting:GetSegments",
      "mobiletargeting:ListTemplates",
      "network-firewall:ListFirewallPolicies",
      "network-firewall:ListFirewalls",
      "networkmanager:DescribeGlobalNetworks",
      "networkmanager:GetDevices",
      "networkmanager:GetLinks",
      "networkmanager:ListAttachments",
      "networkmanager:ListCoreNetworks",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListDelegatedAdministrators",
      "panorama:ListPackages",
      "personalize:ListDatasetGroups",
      "personalize:ListDatasets",
      "personalize:ListSchemas",
      "qldb:ListJournalKinesisStreamsForLedger",
      "qldb:ListLedgers",
      "rds:DescribeBlueGreenDeployments",
      "rds:DescribeDBClusterEndpoints",
      "rds:DescribeDBClusterParameterGroups",
      "rds:DescribeDBClusters",
      "rds:DescribeDBClusterSnapshots",
      "rds:DescribeDBEngineVersions",
      "rds:DescribeDBInstanceAutomatedBackups",
      "rds:DescribeDBInstances",
      "rds:DescribeDBParameterGroups",
      "rds:DescribeDBProxies",
      "rds:DescribeDBProxyEndpoints",
      "rds:DescribeDBSecurityGroups",
      "rds:DescribeDBSnapshots",
      "rds:DescribeDBSubnetGroups",
      "rds:DescribeEventSubscriptions",
      "rds:DescribeGlobalClusters",
      "rds:DescribeOptionGroups",
      "rds:DescribeReservedDBInstances",
      "redshift:DescribeClusterParameterGroups",
      "redshift:DescribeClusters",
      "redshift:DescribeClusterSnapshots",
      "redshift:DescribeClusterSubnetGroups",
      "redshift:DescribeEventSubscriptions",
      "redshift:DescribeSnapshotCopyGrants",
      "redshift:DescribeSnapshotSchedules",
      "redshift:DescribeUsageLimits",
      "refactor-spaces:ListApplications",
      "refactor-spaces:ListEnvironments",
      "refactor-spaces:ListRoutes",
      "refactor-spaces:ListServices",
      "rekognition:DescribeProjects",
      "resiliencehub:ListApps",
      "resiliencehub:ListResiliencyPolicies",
      "resource-explorer-2:GetIndex",
      "resource-explorer-2:ListIndexes",
      "resource-explorer-2:ListViews",
      "resource-groups:ListGroups",
      "route53:ListHealthChecks",
      "route53:ListHostedZones",
      "route53-recovery-readiness:ListRecoveryGroups",
      "route53-recovery-readiness:ListResourceSets",
      "route53resolver:ListFirewallDomainLists",
      "route53resolver:ListFirewallRuleGroups",
      "route53resolver:ListResolverEndpoints",
      "route53resolver:ListResolverRules",
      "s3:GetBucketLocation",
      "s3:ListAccessPoints",
      "s3:ListAllMyBuckets",
      "s3:ListBucket",
      "s3:ListStorageLensConfigurations",
      "sagemaker:ListModels",
      "sagemaker:ListNotebookInstances",
      "secretsmanager:ListSecrets",
      "servicecatalog:ListApplications",
      "servicecatalog:ListAttributeGroups",
      "signer:ListSigningProfiles",
      "sns:ListTopics",
      "sqs:ListQueues",
      "ssm:DescribeAutomationExecutions",
      "ssm:DescribeInstanceInformation",
      "ssm:DescribeMaintenanceWindows",
      "ssm:DescribeMaintenanceWindowTargets",
      "ssm:DescribeMaintenanceWindowTasks",
      "ssm:DescribeParameters",
      "ssm:DescribePatchBaselines",
      "ssm-incidents:ListResponsePlans",
      "ssm:ListAssociations",
      "ssm:ListDocuments",
      "ssm:ListInventoryEntries",
      "ssm:ListResourceDataSync",
      "states:ListActivities",
      "states:ListStateMachines",
      "timestream:ListDatabases",
      "wisdom:listAssistantAssociations",
      "wisdom:ListAssistants",
      "wisdom:listKnowledgeBases"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"ResourceInventoryAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-08-19T15:51:19+00:00"
 },
 "AWSResourceGroupsReadOnlyAccess":{
  "CreateDate":"2018-03-07T10:27:04+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "resource-groups:Get*",
      "resource-groups:List*",
      "resource-groups:Search*",
      "tag:Get*",
      "cloudformation:DescribeStacks",
      "cloudformation:ListStackResources",
      "ec2:DescribeInstances",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeSnapshots",
      "ec2:DescribeVolumes",
      "ec2:DescribeVpcs",
      "elasticache:DescribeCacheClusters",
      "elasticache:DescribeSnapshots",
      "elasticache:ListTagsForResource",
      "elasticbeanstalk:DescribeEnvironments",
      "elasticmapreduce:DescribeCluster",
      "elasticmapreduce:ListClusters",
      "glacier:ListVaults",
      "glacier:DescribeVault",
      "glacier:ListTagsForVault",
      "kinesis:ListStreams",
      "kinesis:DescribeStream",
      "kinesis:ListTagsForStream",
      "opsworks:DescribeStacks",
      "opsworks:ListTags",
      "rds:DescribeDBInstances",
      "rds:DescribeDBSnapshots",
      "rds:ListTagsForResource",
      "redshift:DescribeClusters",
      "redshift:DescribeTags",
      "route53domains:ListDomains",
      "route53:ListHealthChecks",
      "route53:GetHealthCheck",
      "route53:ListHostedZones",
      "route53:GetHostedZone",
      "route53:ListTagsForResource",
      "storagegateway:ListGateways",
      "storagegateway:DescribeGatewayInformation",
      "storagegateway:ListTagsForResource",
      "s3:ListAllMyBuckets",
      "s3:GetBucketTagging",
      "elasticloadbalancing:DescribeLoadBalancers",
      "elasticloadbalancing:DescribeTags",
      "ssm:ListDocuments"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-02-05T17:56:25+00:00"
 },
 "AWSRoboMakerReadOnlyAccess":{
  "CreateDate":"2018-11-26T05:30:50+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "robomaker:List*",
      "robomaker:BatchDescribe*",
      "robomaker:Describe*",
      "robomaker:Get*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"VisualEditor0"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-08-28T23:10:18+00:00"
 },
 "AWSRoboMakerServicePolicy":{
  "CreateDate":"2018-11-26T06:30:08+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeSecurityGroups",
      "greengrass:CreateDeployment",
      "greengrass:CreateGroupVersion",
      "greengrass:CreateFunctionDefinition",
      "greengrass:CreateFunctionDefinitionVersion",
      "greengrass:GetDeploymentStatus",
      "greengrass:GetGroup",
      "greengrass:GetGroupVersion",
      "greengrass:GetCoreDefinitionVersion",
      "greengrass:GetFunctionDefinitionVersion",
      "greengrass:GetAssociatedRole",
      "lambda:CreateFunction",
      "robomaker:CreateSimulationJob",
      "robomaker:CancelSimulationJob"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "robomaker:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:robomaker:*:*:simulation-job/*"
    },
    {
     "Action":[
      "lambda:UpdateFunctionCode",
      "lambda:GetFunction",
      "lambda:UpdateFunctionConfiguration",
      "lambda:DeleteFunction",
      "lambda:ListVersionsByFunction",
      "lambda:GetAlias",
      "lambda:UpdateAlias",
      "lambda:CreateAlias",
      "lambda:DeleteAlias"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:lambda:*:*:function:aws-robomaker-*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "lambda.amazonaws.com",
        "robomaker.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-11T22:23:45+00:00"
 },
 "AWSRoboMakerServiceRolePolicy":{
  "CreateDate":"2018-11-26T05:33:19+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DeleteNetworkInterface",
      "ec2:DescribeSubnets",
      "ec2:DescribeVpcs",
      "ec2:DescribeSecurityGroups",
      "greengrass:CreateDeployment",
      "greengrass:CreateGroupVersion",
      "greengrass:CreateFunctionDefinition",
      "greengrass:CreateFunctionDefinitionVersion",
      "greengrass:GetDeploymentStatus",
      "greengrass:GetGroup",
      "greengrass:GetGroupVersion",
      "greengrass:GetCoreDefinitionVersion",
      "greengrass:GetFunctionDefinitionVersion",
      "greengrass:GetAssociatedRole",
      "lambda:CreateFunction"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "lambda:UpdateFunctionCode",
      "lambda:GetFunction",
      "lambda:UpdateFunctionConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:lambda:*:*:function:aws-robomaker-*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEqualsIfExists":{
       "iam:PassedToService":"lambda.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2018-11-26T05:33:19+00:00"
 },
 "AWSRoboMaker_FullAccess":{
  "CreateDate":"2020-09-10T18:34:18+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"robomaker:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"s3:GetObject",
     "Condition":{
      "StringEquals":{
       "aws:CalledViaFirst":"robomaker.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ecr:BatchGetImage",
     "Condition":{
      "StringEquals":{
       "aws:CalledViaFirst":"robomaker.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ecr-public:DescribeImages",
     "Condition":{
      "StringEquals":{
       "aws:CalledViaFirst":"robomaker.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"robomaker.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-09-16T21:06:10+00:00"
 },
 "AWSRolesAnywhereServicePolicy":{
  "CreateDate":"2022-07-05T15:26:11+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":[
        "AWS/RolesAnywhere",
        "AWS/Usage"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "acm-pca:GetCertificateAuthorityCertificate",
      "acm-pca:DescribeCertificateAuthority"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:acm-pca:*:*:*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-07-05T15:26:11+00:00"
 },
 "AWSS3OnOutpostsServiceRolePolicy":{
  "CreateDate":"2023-10-03T20:32:36+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeSubnets",
      "ec2:DescribeSecurityGroups",
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeVpcs",
      "ec2:DescribeCoipPools",
      "ec2:GetCoipPoolUsage",
      "ec2:DescribeAddresses",
      "ec2:DescribeLocalGatewayRouteTableVpcAssociations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribeVpcResources"
    },
    {
     "Action":[
      "ec2:CreateNetworkInterface"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:security-group/*"
     ],
     "Sid":"CreateNetworkInterface"
    },
    {
     "Action":[
      "ec2:CreateNetworkInterface"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/CreatedBy":"S3 On Outposts"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:network-interface/*"
     ],
     "Sid":"CreateTagsForCreateNetworkInterface"
    },
    {
     "Action":[
      "ec2:AllocateAddress"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:ipv4pool-ec2/*"
     ],
     "Sid":"AllocateIpAddress"
    },
    {
     "Action":[
      "ec2:AllocateAddress"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/CreatedBy":"S3 On Outposts"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:elastic-ip/*"
     ],
     "Sid":"CreateTagsForAllocateIpAddress"
    },
    {
     "Action":[
      "ec2:ModifyNetworkInterfaceAttribute",
      "ec2:CreateNetworkInterfacePermission",
      "ec2:DeleteNetworkInterface",
      "ec2:DeleteNetworkInterfacePermission",
      "ec2:DisassociateAddress",
      "ec2:ReleaseAddress",
      "ec2:AssociateAddress"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/CreatedBy":"S3 On Outposts"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReleaseVpcResources"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/CreatedBy":[
        "S3 On Outposts"
       ],
       "ec2:CreateAction":[
        "CreateNetworkInterface",
        "AllocateAddress"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"CreateTags"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-10-03T20:32:36+00:00"
 },
 "AWSSSMForSAPServiceLinkedRolePolicy":{
  "CreateDate":"2022-11-16T01:18:21+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeInstances",
      "ssm:GetCommandInvocation",
      "ssm:DescribeInstanceInformation"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribeInstanceActions"
    },
    {
     "Action":"ec2:DescribeInstanceStatus",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribeInstanceStatus"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:PutTargets",
      "events:DescribeRule",
      "events:PutRule",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:*:events:*:*:rule/SSMSAPManagedRule*",
      "arn:*:events:*:*:event-bus/default"
     ],
     "Sid":"TargetRuleActions"
    },
    {
     "Action":[
      "ssm:DescribeDocument",
      "ssm:SendCommand"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:*:ssm:*:*:document/AWSSystemsManagerSAP-*",
      "arn:*:ssm:*:*:document/AWSSSMSAP*",
      "arn:*:ssm:*:*:document/AWSSAP*"
     ],
     "Sid":"DocumentActions"
    },
    {
     "Action":"ssm:SendCommand",
     "Condition":{
      "StringEqualsIgnoreCase":{
       "ssm:resourceTag/SSMForSAPManaged":"True"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:ec2:*:*:instance/*",
     "Sid":"CustomerSendCommand"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "Null":{
       "aws:RequestTag/awsApplication":"false"
      },
      "StringEqualsIgnoreCase":{
       "ec2:ResourceTag/SSMForSAPManaged":"True"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:ec2:*:*:instance/*",
     "Sid":"InstanceTagActions"
    },
    {
     "Action":"ec2:DescribeTags",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribeTag"
    },
    {
     "Action":"servicecatalog:GetApplication",
     "Effect":"Allow",
     "Resource":"arn:*:servicecatalog:*:*:*",
     "Sid":"GetApplication"
    },
    {
     "Action":[
      "servicecatalog:DeleteApplication",
      "servicecatalog:UpdateApplication"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/SSMForSAPCreated":"True"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:servicecatalog:*:*:*",
     "Sid":"UpdateOrDeleteApplication"
    },
    {
     "Action":[
      "servicecatalog:TagResource",
      "servicecatalog:CreateApplication"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/SSMForSAPCreated":"True"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:servicecatalog:*:*:*",
     "Sid":"CreateApplication"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"servicecatalog-appregistry.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/servicecatalog-appregistry.amazonaws.com/AWSServiceRoleForAWSServiceCatalogAppRegistry",
     "Sid":"CreateServiceLinkedRole"
    },
    {
     "Action":"cloudwatch:PutMetricData",
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":[
        "AWS/Usage",
        "AWS/SSMForSAP"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PutMetricData"
    },
    {
     "Action":"servicecatalog:CreateAttributeGroup",
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/SSMForSAPCreated":"True"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:servicecatalog:*:*:/attribute-groups/*",
     "Sid":"CreateAttributeGroup"
    },
    {
     "Action":"servicecatalog:GetAttributeGroup",
     "Effect":"Allow",
     "Resource":"arn:*:servicecatalog:*:*:/attribute-groups/*",
     "Sid":"GetAttributeGroup"
    },
    {
     "Action":"servicecatalog:DeleteAttributeGroup",
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/SSMForSAPCreated":"True"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:servicecatalog:*:*:/attribute-groups/*",
     "Sid":"DeleteAttributeGroup"
    },
    {
     "Action":[
      "servicecatalog:AssociateAttributeGroup",
      "servicecatalog:DisassociateAttributeGroup"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/SSMForSAPCreated":"True"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:servicecatalog:*:*:*",
     "Sid":"AttributeGroupActions"
    },
    {
     "Action":"servicecatalog:ListAssociatedAttributeGroups",
     "Effect":"Allow",
     "Resource":"arn:*:servicecatalog:*:*:*",
     "Sid":"ListAssociatedAttributeGroups"
    },
    {
     "Action":[
      "resource-groups:CreateGroup",
      "resource-groups:Tag"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "SSMForSAPCreated"
       ]
      },
      "StringEquals":{
       "aws:ResourceTag/SSMForSAPCreated":"True"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:resource-groups:*:*:group/SystemsManagerForSAP-*",
     "Sid":"CreateGroup"
    },
    {
     "Action":"resource-groups:GetGroup",
     "Effect":"Allow",
     "Resource":"arn:*:resource-groups:*:*:group/SystemsManagerForSAP-*",
     "Sid":"GetGroup"
    },
    {
     "Action":"resource-groups:DeleteGroup",
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/SSMForSAPCreated":"True"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:resource-groups:*:*:group/SystemsManagerForSAP-*",
     "Sid":"DeleteGroup"
    },
    {
     "Action":[
      "resource-groups:CreateGroup"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/EnableAWSServiceCatalogAppRegistry":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:resource-groups:*:*:group/AWS_AppRegistry_AppTag_*",
     "Sid":"CreateAppTagResourceGroup"
    },
    {
     "Action":[
      "resource-groups:Tag"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/EnableAWSServiceCatalogAppRegistry":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:resource-groups:*:*:group/AWS_AppRegistry_AppTag_*",
     "Sid":"TagAppTagResourceGroup"
    },
    {
     "Action":[
      "resource-groups:GetGroupConfiguration"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:*:resource-groups:*:*:group/AWS_AppRegistry_AppTag_*"
     ],
     "Sid":"GetAppTagResourceGroupConfig"
    },
    {
     "Action":[
      "ec2:StartInstances",
      "ec2:StopInstances"
     ],
     "Condition":{
      "StringEqualsIgnoreCase":{
       "ec2:resourceTag/SSMForSAPManaged":"True"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:*:ec2:*:*:instance/*",
     "Sid":"StartStopInstances"
    },
    {
     "Action":[
      "resource-groups:Tag",
      "resource-groups:CreateGroup"
     ],
     "Condition":{
      "ArnLike":{
       "aws:RequestTag/awsApplication":"arn:aws:resource-groups:*:*:group/*/*"
      },
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "SSMForSAPCreated",
        "awsApplication"
       ]
      },
      "StringEquals":{
       "aws:RequestTag/SSMForSAPCreated":"True"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:resource-groups:*:*:group/SystemsManagerForSAP-*",
     "Sid":"SsmSapResourceGroup"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAllValues:StringLike":{
       "aws:TagKeys":[
        "SystemsManagerForSAP-*"
       ]
      },
      "StringEquals":{
       "aws:ResourceTag/SSMForSAPManaged":"True"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*",
     "Sid":"ManageSsmSapTagsOnEc2Instances"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAllValues:StringLike":{
       "aws:TagKeys":[
        "SystemsManagerForSAP-*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"ManageSsmSapTagsOnEbsVolumes"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ArnLike":{
       "aws:RequestTag/awsApplication":"arn:aws:resource-groups:*:*:group/*/*"
      },
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "awsApplication"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:volume/*",
     "Sid":"ManageAppTagsOnEbsVolumes"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-08-29T22:17:07+00:00"
 },
 "AWSSSMOpsInsightsServiceRolePolicy":{
  "CreateDate":"2021-06-16T20:12:52+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:CreateOpsItem",
      "ssm:AddTagsToResource"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowCreateOpsItem"
    },
    {
     "Action":[
      "ssm:UpdateOpsItem",
      "ssm:GetOpsItem"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/SsmOperationalInsight":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowAccessOpsItem"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-06-16T20:12:52+00:00"
 },
 "AWSSSODirectoryAdministrator":{
  "CreateDate":"2018-10-31T23:54:00+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sso-directory:*",
      "identitystore:*",
      "identitystore-auth:*",
      "sso:ListDirectoryAssociations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSSODirectoryAdministrator"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-10-20T20:34:07+00:00"
 },
 "AWSSSODirectoryReadOnly":{
  "CreateDate":"2018-10-31T23:49:32+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sso-directory:Search*",
      "sso-directory:Describe*",
      "sso-directory:List*",
      "sso-directory:Get*",
      "identitystore:Describe*",
      "identitystore:List*",
      "identitystore-auth:ListSessions",
      "identitystore-auth:BatchGetSession"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSSODirectoryReadOnly"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-11-16T18:17:48+00:00"
 },
 "AWSSSOMasterAccountAdministrator":{
  "CreateDate":"2018-06-27T20:36:51+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"sso.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/sso.amazonaws.com/AWSServiceRoleForSSO",
     "Sid":"AWSSSOCreateSLR"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringLike":{
       "iam:PassedToService":"sso.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/sso.amazonaws.com/AWSServiceRoleForSSO",
     "Sid":"AWSSSOMasterAccountAdministrator"
    },
    {
     "Action":[
      "ds:DescribeTrusts",
      "ds:UnauthorizeApplication",
      "ds:DescribeDirectories",
      "ds:AuthorizeApplication",
      "iam:ListPolicies",
      "organizations:EnableAWSServiceAccess",
      "organizations:ListRoots",
      "organizations:ListAccounts",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListAccountsForParent",
      "organizations:DescribeOrganization",
      "organizations:ListChildren",
      "organizations:DescribeAccount",
      "organizations:ListParents",
      "organizations:ListDelegatedAdministrators",
      "sso:*",
      "sso-directory:*",
      "identitystore:*",
      "identitystore-auth:*",
      "ds:CreateAlias",
      "access-analyzer:ValidatePolicy",
      "signin:CreateTrustedIdentityPropagationApplicationForConsole",
      "signin:ListTrustedIdentityPropagationApplicationsForConsole"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSSOMemberAccountAdministrator"
    },
    {
     "Action":[
      "organizations:RegisterDelegatedAdministrator",
      "organizations:DeregisterDelegatedAdministrator"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":"sso.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSSOManageDelegatedAdministrator"
    },
    {
     "Action":[
      "identity-sync:DeleteSyncProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:identity-sync:*:*:profile/*"
     ],
     "Sid":"AllowDeleteSyncProfile"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-09-26T17:13:59+00:00"
 },
 "AWSSSOMemberAccountAdministrator":{
  "CreateDate":"2018-06-27T20:45:42+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:DescribeDirectories",
      "ds:AuthorizeApplication",
      "ds:UnauthorizeApplication",
      "ds:DescribeTrusts",
      "iam:ListPolicies",
      "organizations:EnableAWSServiceAccess",
      "organizations:DescribeOrganization",
      "organizations:DescribeAccount",
      "organizations:ListRoots",
      "organizations:ListAccounts",
      "organizations:ListAccountsForParent",
      "organizations:ListParents",
      "organizations:ListChildren",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListDelegatedAdministrators",
      "sso:*",
      "sso-directory:*",
      "identitystore:*",
      "identitystore-auth:*",
      "ds:CreateAlias",
      "access-analyzer:ValidatePolicy",
      "signin:CreateTrustedIdentityPropagationApplicationForConsole",
      "signin:ListTrustedIdentityPropagationApplicationsForConsole"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSSOMemberAccountAdministrator"
    },
    {
     "Action":[
      "organizations:RegisterDelegatedAdministrator",
      "organizations:DeregisterDelegatedAdministrator"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":"sso.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSSOManageDelegatedAdministrator"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-26T00:31:10+00:00"
 },
 "AWSSSOReadOnly":{
  "CreateDate":"2018-06-27T20:24:34+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ds:DescribeDirectories",
      "ds:DescribeTrusts",
      "iam:ListPolicies",
      "organizations:DescribeOrganization",
      "organizations:DescribeAccount",
      "organizations:ListParents",
      "organizations:ListChildren",
      "organizations:ListAccounts",
      "organizations:ListRoots",
      "organizations:ListAccountsForParent",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListDelegatedAdministrators",
      "sso:Describe*",
      "sso:Get*",
      "sso:List*",
      "sso:Search*",
      "sso-directory:DescribeDirectory",
      "access-analyzer:ValidatePolicy",
      "signin:ListTrustedIdentityPropagationApplicationsForConsole"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSSOReadOnly"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-26T00:44:59+00:00"
 },
 "AWSSSOServiceRolePolicy":{
  "CreateDate":"2017-12-05T18:36:15+00:00",
  "DefaultVersionId":"v17",
  "Document":{
   "Statement":[
    {
     "Action":[
      "iam:AttachRolePolicy",
      "iam:CreateRole",
      "iam:PutRolePolicy",
      "iam:UpdateRole",
      "iam:UpdateRoleDescription",
      "iam:UpdateAssumeRolePolicy",
      "iam:PutRolePermissionsBoundary",
      "iam:DeleteRolePermissionsBoundary"
     ],
     "Condition":{
      "StringNotEquals":{
       "aws:PrincipalOrgMasterAccountId":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-reserved/sso.amazonaws.com/*"
     ],
     "Sid":"IAMRoleProvisioningActions"
    },
    {
     "Action":[
      "iam:GetRole",
      "iam:ListRoles"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"IAMRoleReadActions"
    },
    {
     "Action":[
      "iam:DeleteRole",
      "iam:DeleteRolePolicy",
      "iam:DetachRolePolicy",
      "iam:ListRolePolicies",
      "iam:ListAttachedRolePolicies"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-reserved/sso.amazonaws.com/*"
     ],
     "Sid":"IAMRoleCleanupActions"
    },
    {
     "Action":[
      "iam:DeleteServiceLinkedRole",
      "iam:GetServiceLinkedRoleDeletionStatus",
      "iam:DeleteRole",
      "iam:GetRole"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/sso.amazonaws.com/AWSServiceRoleForSSO"
     ],
     "Sid":"IAMSLRCleanupActions"
    },
    {
     "Action":[
      "iam:CreateSAMLProvider"
     ],
     "Condition":{
      "StringNotEquals":{
       "aws:PrincipalOrgMasterAccountId":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:saml-provider/AWSSSO_*"
     ],
     "Sid":"IAMSAMLProviderCreationAction"
    },
    {
     "Action":[
      "iam:UpdateSAMLProvider"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:saml-provider/AWSSSO_*"
     ],
     "Sid":"IAMSAMLProviderUpdateAction"
    },
    {
     "Action":[
      "iam:DeleteSAMLProvider",
      "iam:GetSAMLProvider"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:saml-provider/AWSSSO_*"
     ],
     "Sid":"IAMSAMLProviderCleanupActions"
    },
    {
     "Action":[
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:ListDelegatedAdministrators",
      "organizations:ListAWSServiceAccessForOrganization"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ]
    },
    {
     "Action":[
      "ds:UnauthorizeApplication"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowUnauthAppForDirectory"
    },
    {
     "Action":[
      "ds:DescribeDirectories",
      "ds:DescribeTrusts"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowDescribeForDirectory"
    },
    {
     "Action":[
      "identitystore:DescribeUser",
      "identitystore:DescribeGroup",
      "identitystore:ListGroups",
      "identitystore:ListUsers"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"AllowDescribeAndListOperationsOnIdentitySource"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-10-20T20:05:47+00:00"
 },
 "AWSSavingsPlansFullAccess":{
  "CreateDate":"2019-11-06T22:45:18+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"savingsplans:*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-06T22:45:18+00:00"
 },
 "AWSSavingsPlansReadOnlyAccess":{
  "CreateDate":"2019-11-06T22:45:10+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "savingsplans:Describe*",
      "savingsplans:List*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-11-06T22:45:10+00:00"
 },
 "AWSSecurityHubFullAccess":{
  "CreateDate":"2018-11-27T23:54:34+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":"securityhub:*",
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SecurityHubAllowAll"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringLike":{
       "iam:AWSServiceName":"securityhub.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SecurityHubServiceLinkedRole"
    },
    {
     "Action":[
      "guardduty:GetDetector",
      "guardduty:ListDetectors",
      "inspector2:BatchGetAccountStatus",
      "pricing:GetProducts"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"OtherServicePermission"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-23T18:35:45+00:00"
 },
 "AWSSecurityHubOrganizationsAccess":{
  "CreateDate":"2021-03-15T20:53:03+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:ListAccounts",
      "organizations:DescribeOrganization",
      "organizations:ListRoots",
      "organizations:ListDelegatedAdministrators",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:ListOrganizationalUnitsForParent",
      "organizations:ListAccountsForParent",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganizationalUnit"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"OrganizationPermissions"
    },
    {
     "Action":"organizations:EnableAWSServiceAccess",
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":"securityhub.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"OrganizationPermissionsEnable"
    },
    {
     "Action":[
      "organizations:RegisterDelegatedAdministrator",
      "organizations:DeregisterDelegatedAdministrator"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":"securityhub.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:organizations::*:account/o-*/*",
     "Sid":"OrganizationPermissionsDelegatedAdmin"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-16T21:13:44+00:00"
 },
 "AWSSecurityHubReadOnlyAccess":{
  "CreateDate":"2018-11-28T01:34:29+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "securityhub:Get*",
      "securityhub:List*",
      "securityhub:BatchGet*",
      "securityhub:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSSecurityHubReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-02-22T23:45:59+00:00"
 },
 "AWSSecurityHubServiceRolePolicy":{
  "CreateDate":"2018-11-27T23:47:51+00:00",
  "DefaultVersionId":"v14",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudtrail:DescribeTrails",
      "cloudtrail:GetTrailStatus",
      "cloudtrail:GetEventSelectors",
      "cloudwatch:DescribeAlarms",
      "cloudwatch:DescribeAlarmsForMetric",
      "logs:DescribeMetricFilters",
      "sns:ListSubscriptionsByTopic",
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus",
      "config:DescribeConfigRules",
      "config:DescribeConfigRuleEvaluationStatus",
      "config:BatchGetResourceConfig",
      "config:SelectResourceConfig",
      "iam:GenerateCredentialReport",
      "organizations:ListAccounts",
      "config:PutEvaluations",
      "tag:GetResources",
      "iam:GetCredentialReport",
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListChildren",
      "organizations:ListAWSServiceAccessForOrganization",
      "organizations:DescribeOrganizationalUnit",
      "securityhub:BatchDisableStandards",
      "securityhub:BatchEnableStandards",
      "securityhub:BatchUpdateStandardsControlAssociations",
      "securityhub:BatchGetSecurityControls",
      "securityhub:BatchGetStandardsControlAssociations",
      "securityhub:CreateMembers",
      "securityhub:DeleteMembers",
      "securityhub:DescribeHub",
      "securityhub:DescribeOrganizationConfiguration",
      "securityhub:DescribeStandards",
      "securityhub:DescribeStandardsControls",
      "securityhub:DisassociateFromAdministratorAccount",
      "securityhub:DisassociateMembers",
      "securityhub:DisableSecurityHub",
      "securityhub:EnableSecurityHub",
      "securityhub:GetEnabledStandards",
      "securityhub:ListStandardsControlAssociations",
      "securityhub:ListSecurityControlDefinitions",
      "securityhub:UpdateOrganizationConfiguration",
      "securityhub:UpdateSecurityControl",
      "securityhub:UpdateSecurityHubConfiguration",
      "securityhub:UpdateStandardsControl"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SecurityHubServiceRolePermissions"
    },
    {
     "Action":[
      "config:PutConfigRule",
      "config:DeleteConfigRule",
      "config:GetComplianceDetailsByConfigRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:config-rule/aws-service-rule/*securityhub*",
     "Sid":"SecurityHubServiceRoleConfigPermissions"
    },
    {
     "Action":[
      "organizations:ListDelegatedAdministrators"
     ],
     "Condition":{
      "StringEquals":{
       "organizations:ServicePrincipal":[
        "securityhub.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SecurityHubServiceRoleOrganizationsPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-27T03:46:47+00:00"
 },
 "AWSServiceCatalogAdminFullAccess":{
  "CreateDate":"2018-02-15T17:19:40+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStacks",
      "cloudformation:SetStackPolicy",
      "cloudformation:UpdateStack",
      "cloudformation:CreateChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:ListChangeSets",
      "cloudformation:DeleteChangeSet",
      "cloudformation:ListStackResources",
      "cloudformation:TagResource",
      "cloudformation:CreateStackSet",
      "cloudformation:CreateStackInstances",
      "cloudformation:UpdateStackSet",
      "cloudformation:UpdateStackInstances",
      "cloudformation:DeleteStackSet",
      "cloudformation:DeleteStackInstances",
      "cloudformation:DescribeStackSet",
      "cloudformation:DescribeStackInstance",
      "cloudformation:DescribeStackSetOperation",
      "cloudformation:ListStackInstances",
      "cloudformation:ListStackSetOperations",
      "cloudformation:ListStackSetOperationResults"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/SC-*",
      "arn:aws:cloudformation:*:*:stack/StackSet-SC-*",
      "arn:aws:cloudformation:*:*:changeSet/SC-*",
      "arn:aws:cloudformation:*:*:stackset/SC-*"
     ]
    },
    {
     "Action":[
      "cloudformation:CreateUploadBucket",
      "cloudformation:GetTemplateSummary",
      "cloudformation:ValidateTemplate",
      "iam:GetGroup",
      "iam:GetRole",
      "iam:GetUser",
      "iam:ListGroups",
      "iam:ListRoles",
      "iam:ListUsers",
      "servicecatalog:Get*",
      "servicecatalog:Scan*",
      "servicecatalog:Search*",
      "servicecatalog:List*",
      "servicecatalog:TagResource",
      "servicecatalog:UntagResource",
      "servicecatalog:SyncResource",
      "ssm:DescribeDocument",
      "ssm:GetAutomationExecution",
      "ssm:ListDocuments",
      "ssm:ListDocumentVersions",
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicecatalog:Accept*",
      "servicecatalog:Associate*",
      "servicecatalog:Batch*",
      "servicecatalog:Copy*",
      "servicecatalog:Create*",
      "servicecatalog:Delete*",
      "servicecatalog:Describe*",
      "servicecatalog:Disable*",
      "servicecatalog:Disassociate*",
      "servicecatalog:Enable*",
      "servicecatalog:Execute*",
      "servicecatalog:Import*",
      "servicecatalog:Provision*",
      "servicecatalog:Put*",
      "servicecatalog:Reject*",
      "servicecatalog:Terminate*",
      "servicecatalog:Update*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"servicecatalog.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"orgsdatasync.servicecatalog.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/orgsdatasync.servicecatalog.amazonaws.com/AWSServiceRoleForServiceCatalogOrgsDataSync"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-04-13T18:43:01+00:00"
 },
 "AWSServiceCatalogAdminReadOnlyAccess":{
  "CreateDate":"2019-10-25T18:53:38+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeChangeSet",
      "cloudformation:ListChangeSets",
      "cloudformation:ListStackResources",
      "cloudformation:DescribeStackSet",
      "cloudformation:DescribeStackInstance",
      "cloudformation:DescribeStackSetOperation",
      "cloudformation:ListStackInstances",
      "cloudformation:ListStackSetOperations",
      "cloudformation:ListStackSetOperationResults"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/SC-*",
      "arn:aws:cloudformation:*:*:stack/StackSet-SC-*",
      "arn:aws:cloudformation:*:*:changeSet/SC-*",
      "arn:aws:cloudformation:*:*:stackset/SC-*"
     ]
    },
    {
     "Action":[
      "cloudformation:GetTemplateSummary",
      "iam:GetGroup",
      "iam:GetRole",
      "iam:GetUser",
      "iam:ListGroups",
      "iam:ListRoles",
      "iam:ListUsers",
      "servicecatalog:Get*",
      "servicecatalog:List*",
      "servicecatalog:Describe*",
      "servicecatalog:ScanProvisionedProducts",
      "servicecatalog:Search*",
      "ssm:DescribeDocument",
      "ssm:GetAutomationExecution",
      "ssm:ListDocuments",
      "ssm:ListDocumentVersions",
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-25T18:53:38+00:00"
 },
 "AWSServiceCatalogAppRegistryFullAccess":{
  "CreateDate":"2020-11-12T22:25:58+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:UpdateStack",
      "tag:GetResources"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"servicecatalog-appregistry.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AppRegistryUpdateStackAndResourceGroupTagging"
    },
    {
     "Action":[
      "resource-groups:CreateGroup",
      "resource-groups:DeleteGroup",
      "resource-groups:GetGroup",
      "resource-groups:GetTags",
      "resource-groups:Tag",
      "resource-groups:Untag",
      "resource-groups:GetGroupConfiguration",
      "resource-groups:AssociateResource",
      "resource-groups:DisassociateResource"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":"servicecatalog-appregistry.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:resource-groups:*:*:group/AWS_*",
     "Sid":"AppRegistryResourceGroupsIntegration"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"servicecatalog-appregistry.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/aws-service-role/servicecatalog-appregistry.amazonaws.com/AWSServiceRoleForAWSServiceCatalogAppRegistry*",
     "Sid":"AppRegistryServiceLinkedRole"
    },
    {
     "Action":[
      "cloudformation:DescribeStacks",
      "servicecatalog:CreateApplication",
      "servicecatalog:GetApplication",
      "servicecatalog:UpdateApplication",
      "servicecatalog:DeleteApplication",
      "servicecatalog:ListApplications",
      "servicecatalog:AssociateResource",
      "servicecatalog:DisassociateResource",
      "servicecatalog:GetAssociatedResource",
      "servicecatalog:ListAssociatedResources",
      "servicecatalog:AssociateAttributeGroup",
      "servicecatalog:DisassociateAttributeGroup",
      "servicecatalog:ListAssociatedAttributeGroups",
      "servicecatalog:CreateAttributeGroup",
      "servicecatalog:UpdateAttributeGroup",
      "servicecatalog:DeleteAttributeGroup",
      "servicecatalog:GetAttributeGroup",
      "servicecatalog:ListAttributeGroups",
      "servicecatalog:SyncResource",
      "servicecatalog:ListAttributeGroupsForApplication",
      "servicecatalog:GetConfiguration",
      "servicecatalog:PutConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AppRegistryOperations"
    },
    {
     "Action":[
      "servicecatalog:ListTagsForResource",
      "servicecatalog:UntagResource",
      "servicecatalog:TagResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:servicecatalog:*:*:*",
     "Sid":"AppRegistryResourceTagging"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-12-07T21:50:00+00:00"
 },
 "AWSServiceCatalogAppRegistryReadOnlyAccess":{
  "CreateDate":"2020-11-12T22:34:32+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "servicecatalog:GetApplication",
      "servicecatalog:ListApplications",
      "servicecatalog:GetAssociatedResource",
      "servicecatalog:ListAssociatedResources",
      "servicecatalog:ListAssociatedAttributeGroups",
      "servicecatalog:GetAttributeGroup",
      "servicecatalog:ListAttributeGroups",
      "servicecatalog:ListTagsForResource",
      "servicecatalog:ListAttributeGroupsForApplication",
      "servicecatalog:GetConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-11-17T18:16:39+00:00"
 },
 "AWSServiceCatalogAppRegistryServiceRolePolicy":{
  "CreateDate":"2021-05-18T22:18:55+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":"cloudformation:DescribeStacks",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "resource-groups:CreateGroup",
      "resource-groups:Tag"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/EnableAWSServiceCatalogAppRegistry":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "resource-groups:DeleteGroup",
      "resource-groups:UpdateGroup",
      "resource-groups:GetTags",
      "resource-groups:Tag",
      "resource-groups:Untag"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/EnableAWSServiceCatalogAppRegistry":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "resource-groups:GetGroup",
      "resource-groups:GetGroupConfiguration"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:*:resource-groups:*:*:group/AWS_AppRegistry*",
      "arn:*:resource-groups:*:*:group/AWS_CloudFormation_Stack*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-10-26T16:05:52+00:00"
 },
 "AWSServiceCatalogEndUserFullAccess":{
  "CreateDate":"2018-02-15T17:22:32+00:00",
  "DefaultVersionId":"v7",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:CreateStack",
      "cloudformation:DeleteStack",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStacks",
      "cloudformation:SetStackPolicy",
      "cloudformation:ValidateTemplate",
      "cloudformation:UpdateStack",
      "cloudformation:CreateChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:ListChangeSets",
      "cloudformation:DeleteChangeSet",
      "cloudformation:TagResource",
      "cloudformation:CreateStackSet",
      "cloudformation:CreateStackInstances",
      "cloudformation:UpdateStackSet",
      "cloudformation:UpdateStackInstances",
      "cloudformation:DeleteStackSet",
      "cloudformation:DeleteStackInstances",
      "cloudformation:DescribeStackSet",
      "cloudformation:DescribeStackInstance",
      "cloudformation:DescribeStackSetOperation",
      "cloudformation:ListStackInstances",
      "cloudformation:ListStackResources",
      "cloudformation:ListStackSetOperations",
      "cloudformation:ListStackSetOperationResults"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/SC-*",
      "arn:aws:cloudformation:*:*:stack/StackSet-SC-*",
      "arn:aws:cloudformation:*:*:changeSet/SC-*",
      "arn:aws:cloudformation:*:*:stackset/SC-*"
     ]
    },
    {
     "Action":[
      "cloudformation:GetTemplateSummary",
      "servicecatalog:DescribeProduct",
      "servicecatalog:DescribeProductView",
      "servicecatalog:DescribeProvisioningParameters",
      "servicecatalog:ListLaunchPaths",
      "servicecatalog:ProvisionProduct",
      "servicecatalog:SearchProducts",
      "ssm:DescribeDocument",
      "ssm:GetAutomationExecution",
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicecatalog:DescribeProvisionedProduct",
      "servicecatalog:DescribeRecord",
      "servicecatalog:ListRecordHistory",
      "servicecatalog:ListStackInstancesForProvisionedProduct",
      "servicecatalog:ScanProvisionedProducts",
      "servicecatalog:TerminateProvisionedProduct",
      "servicecatalog:UpdateProvisionedProduct",
      "servicecatalog:SearchProvisionedProducts",
      "servicecatalog:CreateProvisionedProductPlan",
      "servicecatalog:DescribeProvisionedProductPlan",
      "servicecatalog:ExecuteProvisionedProductPlan",
      "servicecatalog:DeleteProvisionedProductPlan",
      "servicecatalog:ListProvisionedProductPlans",
      "servicecatalog:ListServiceActionsForProvisioningArtifact",
      "servicecatalog:ExecuteProvisionedProductServiceAction",
      "servicecatalog:DescribeServiceActionExecutionParameters"
     ],
     "Condition":{
      "StringEquals":{
       "servicecatalog:userLevel":"self"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-07-10T20:30:52+00:00"
 },
 "AWSServiceCatalogEndUserReadOnlyAccess":{
  "CreateDate":"2019-10-25T18:49:34+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeChangeSet",
      "cloudformation:ListChangeSets",
      "cloudformation:DescribeStackSet",
      "cloudformation:DescribeStackInstance",
      "cloudformation:DescribeStackSetOperation",
      "cloudformation:ListStackInstances",
      "cloudformation:ListStackResources",
      "cloudformation:ListStackSetOperations",
      "cloudformation:ListStackSetOperationResults"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:cloudformation:*:*:stack/SC-*",
      "arn:aws:cloudformation:*:*:stack/StackSet-SC-*",
      "arn:aws:cloudformation:*:*:changeSet/SC-*",
      "arn:aws:cloudformation:*:*:stackset/SC-*"
     ]
    },
    {
     "Action":[
      "cloudformation:GetTemplateSummary",
      "servicecatalog:DescribeProduct",
      "servicecatalog:DescribeProductView",
      "servicecatalog:DescribeProvisioningParameters",
      "servicecatalog:ListLaunchPaths",
      "servicecatalog:SearchProducts",
      "ssm:DescribeDocument",
      "ssm:GetAutomationExecution",
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "servicecatalog:DescribeProvisionedProduct",
      "servicecatalog:DescribeRecord",
      "servicecatalog:ListRecordHistory",
      "servicecatalog:ListStackInstancesForProvisionedProduct",
      "servicecatalog:ScanProvisionedProducts",
      "servicecatalog:SearchProvisionedProducts",
      "servicecatalog:DescribeProvisionedProductPlan",
      "servicecatalog:ListProvisionedProductPlans",
      "servicecatalog:ListServiceActionsForProvisioningArtifact",
      "servicecatalog:DescribeServiceActionExecutionParameters"
     ],
     "Condition":{
      "StringEquals":{
       "servicecatalog:userLevel":"self"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2019-10-25T18:49:34+00:00"
 },
 "AWSServiceCatalogOrgsDataSyncServiceRolePolicy":{
  "CreateDate":"2023-04-10T20:48:28+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "organizations:DescribeAccount",
      "organizations:DescribeOrganization",
      "organizations:ListAccounts",
      "organizations:ListChildren",
      "organizations:ListParents",
      "organizations:ListAWSServiceAccessForOrganization"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"OrganizationsDataSyncToServiceCatalog"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-04-10T20:48:28+00:00"
 },
 "AWSServiceCatalogSyncServiceRolePolicy":{
  "CreateDate":"2022-11-15T21:20:15+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "servicecatalog:ListProvisioningArtifacts",
      "servicecatalog:DescribeProductAsAdmin",
      "servicecatalog:DeleteProvisioningArtifact",
      "servicecatalog:ListServiceActionsForProvisioningArtifact",
      "servicecatalog:DescribeProvisioningArtifact",
      "servicecatalog:CreateProvisioningArtifact",
      "servicecatalog:UpdateProvisioningArtifact"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ArtifactSyncToServiceCatalog"
    },
    {
     "Action":[
      "codestar-connections:UseConnection",
      "codeconnections:UseConnection"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:codestar-connections:*:*:connection/*",
      "arn:aws:codeconnections:*:*:connection/*"
     ],
     "Sid":"AccessArtifactRepositories"
    },
    {
     "Action":[
      "cloudformation:ValidateTemplate"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ValidateTemplate"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-05-03T17:12:41+00:00"
 },
 "AWSServiceRoleForAmazonEKSNodegroup":{
  "CreateDate":"2019-11-07T01:34:26+00:00",
  "DefaultVersionId":"v9",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:RevokeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:DescribeInstances",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:DeleteSecurityGroup"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/eks":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SharedSecurityGroupRelatedPermissions"
    },
    {
     "Action":[
      "ec2:RevokeSecurityGroupIngress",
      "ec2:AuthorizeSecurityGroupEgress",
      "ec2:AuthorizeSecurityGroupIngress",
      "ec2:DescribeInstances",
      "ec2:RevokeSecurityGroupEgress",
      "ec2:DeleteSecurityGroup"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/eks:nodegroup-name":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"EKSCreatedSecurityGroupRelatedPermissions"
    },
    {
     "Action":[
      "ec2:DeleteLaunchTemplate",
      "ec2:CreateLaunchTemplateVersion"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/eks:nodegroup-name":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"LaunchTemplateRelatedPermissions"
    },
    {
     "Action":[
      "autoscaling:UpdateAutoScalingGroup",
      "autoscaling:DeleteAutoScalingGroup",
      "autoscaling:TerminateInstanceInAutoScalingGroup",
      "autoscaling:CompleteLifecycleAction",
      "autoscaling:PutLifecycleHook",
      "autoscaling:PutNotificationConfiguration",
      "autoscaling:EnableMetricsCollection",
      "autoscaling:PutScheduledUpdateGroupAction",
      "autoscaling:ResumeProcesses",
      "autoscaling:SuspendProcesses"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:autoscaling:*:*:*:autoScalingGroupName/eks-*",
     "Sid":"AutoscalingRelatedPermissions"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"autoscaling.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowAutoscalingToCreateSLR"
    },
    {
     "Action":[
      "autoscaling:CreateOrUpdateTags",
      "autoscaling:CreateAutoScalingGroup"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:TagKeys":[
        "eks",
        "eks:cluster-name",
        "eks:nodegroup-name"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowASGCreationByEKS"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"autoscaling.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowPassRoleToAutoscaling"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEqualsIfExists":{
       "iam:PassedToService":[
        "ec2.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowPassRoleToEC2"
    },
    {
     "Action":[
      "iam:GetRole",
      "ec2:CreateLaunchTemplate",
      "ec2:DescribeInstances",
      "iam:GetInstanceProfile",
      "ec2:DescribeLaunchTemplates",
      "autoscaling:DescribeAutoScalingGroups",
      "ec2:CreateSecurityGroup",
      "ec2:DescribeLaunchTemplateVersions",
      "ec2:RunInstances",
      "ec2:DescribeSecurityGroups",
      "ec2:GetConsoleOutput",
      "ec2:DescribeRouteTables",
      "ec2:DescribeSubnets",
      "ec2:DescribeCapacityReservations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PermissionsToManageResourcesForNodegroups"
    },
    {
     "Action":[
      "iam:CreateInstanceProfile",
      "iam:DeleteInstanceProfile",
      "iam:RemoveRoleFromInstanceProfile",
      "iam:AddRoleToInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:instance-profile/eks-*",
     "Sid":"PermissionsToCreateAndManageInstanceProfiles"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Condition":{
      "ForAnyValue:StringLike":{
       "aws:TagKeys":[
        "eks",
        "eks:cluster-name",
        "eks:nodegroup-name",
        "kubernetes.io/cluster/*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PermissionsToManageEKSAndKubernetesTags"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-08-21T15:51:37+00:00"
 },
 "AWSServiceRoleForAmazonQDeveloper":{
  "CreateDate":"2024-04-25T07:40:41+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":[
        "AWS/Q"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"sid1"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-25T07:40:41+00:00"
 },
 "AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy":{
  "CreateDate":"2020-10-01T09:49:01+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ssm:CreateOpsItem"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-01T09:49:01+00:00"
 },
 "AWSServiceRoleForCloudWatchMetrics_DbPerfInsightsServiceRolePolicy":{
  "CreateDate":"2023-09-07T09:32:32+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "pi:GetResourceMetrics"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-09-07T09:32:32+00:00"
 },
 "AWSServiceRoleForCodeGuru-Profiler":{
  "CreateDate":"2020-06-26T22:04:26+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowSNSPublishToSendNotifications"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-06-26T22:04:26+00:00"
 },
 "AWSServiceRoleForCodeWhispererPolicy":{
  "CreateDate":"2023-03-24T19:39:12+00:00",
  "DefaultVersionId":"v5",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sso-directory:ListMembersInGroup"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"sid1"
    },
    {
     "Action":[
      "sso:ListProfileAssociations",
      "sso:ListProfiles",
      "sso:ListDirectoryAssociations",
      "sso:DescribeRegisteredRegions",
      "sso:GetProfile",
      "sso:GetManagedApplicationInstance",
      "sso:ListApplicationAssignments",
      "sso:DescribeInstance",
      "sso:DescribeApplication"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"sid2"
    },
    {
     "Action":[
      "codeguru-security:CreateUploadUrl"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"sid3"
    },
    {
     "Action":[
      "codeguru-security:CreateScan",
      "codeguru-security:GetScan",
      "codeguru-security:ListFindings",
      "codeguru-security:GetFindings"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:codeguru-security:*:*:scans/CodeWhisperer-*"
     ],
     "Sid":"sid4"
    },
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":[
        "AWS/CodeWhisperer"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"sid5"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-03-29T22:13:56+00:00"
 },
 "AWSServiceRoleForEC2ScheduledInstances":{
  "CreateDate":"2017-10-12T18:31:55+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "aws:TagKeys":[
        "aws:ec2sri:scheduledInstanceId"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:ec2sri:scheduledInstanceId":"*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-10-12T18:31:55+00:00"
 },
 "AWSServiceRoleForGroundStationDataflowEndpointGroupPolicy":{
  "CreateDate":"2022-12-13T23:52:45+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:DescribeAddresses",
      "ec2:DescribeNetworkInterfaces"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-12-13T23:52:45+00:00"
 },
 "AWSServiceRoleForImageBuilder":{
  "CreateDate":"2019-11-29T22:02:13+00:00",
  "DefaultVersionId":"v19",
  "Document":{
   "Statement":[
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*:*:subnet/*",
      "arn:aws:ec2:*:*:network-interface/*",
      "arn:aws:ec2:*:*:security-group/*",
      "arn:aws:ec2:*:*:key-pair/*",
      "arn:aws:ec2:*:*:launch-template/*",
      "arn:aws:license-manager:*:*:license-configuration:*"
     ]
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/CreatedBy":[
        "EC2 Image Builder",
        "EC2 Fast Launch"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:volume/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":[
        "ec2.amazonaws.com",
        "ec2.amazonaws.com.cn",
        "vmie.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:StopInstances",
      "ec2:StartInstances",
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CopyImage",
      "ec2:CreateImage",
      "ec2:CreateLaunchTemplate",
      "ec2:DeregisterImage",
      "ec2:DescribeImages",
      "ec2:DescribeInstanceAttribute",
      "ec2:DescribeInstanceStatus",
      "ec2:DescribeInstances",
      "ec2:DescribeInstanceTypeOfferings",
      "ec2:DescribeInstanceTypes",
      "ec2:DescribeSubnets",
      "ec2:DescribeTags",
      "ec2:ModifyImageAttribute",
      "ec2:DescribeImportImageTasks",
      "ec2:DescribeExportImageTasks",
      "ec2:DescribeSnapshots",
      "ec2:DescribeHosts"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:ModifySnapshotAttribute"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::snapshot/*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/CreatedBy":[
        "EC2 Image Builder",
        "EC2 Fast Launch"
       ],
       "ec2:CreateAction":[
        "RunInstances",
        "CreateImage"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*:*:export-image-task/*"
     ]
    },
    {
     "Action":[
      "ec2:CreateTags"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/CreatedBy":[
        "EC2 Image Builder",
        "EC2 Fast Launch"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::snapshot/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ]
    },
    {
     "Action":[
      "license-manager:UpdateLicenseSpecificationsForResource"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "sns:Publish"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ssm:ListCommands",
      "ssm:ListCommandInvocations",
      "ssm:AddTagsToResource",
      "ssm:DescribeInstanceInformation",
      "ssm:GetAutomationExecution",
      "ssm:StopAutomationExecution",
      "ssm:ListInventoryEntries",
      "ssm:SendAutomationSignal",
      "ssm:DescribeInstanceAssociationsStatus",
      "ssm:DescribeAssociationExecutions",
      "ssm:GetCommandInvocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ssm:SendCommand",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWS-RunPowerShellScript",
      "arn:aws:ssm:*:*:document/AWS-RunShellScript",
      "arn:aws:ssm:*:*:document/AWSEC2-RunSysprep",
      "arn:aws:s3:::*"
     ]
    },
    {
     "Action":[
      "ssm:SendCommand"
     ],
     "Condition":{
      "StringEquals":{
       "ssm:resourceTag/CreatedBy":[
        "EC2 Image Builder"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":"ssm:StartAutomationExecution",
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*:*:automation-definition/ImageBuilder*"
    },
    {
     "Action":[
      "ssm:CreateAssociation",
      "ssm:DeleteAssociation"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*:*:document/AWS-GatherSoftwareInventory",
      "arn:aws:ssm:*:*:association/*",
      "arn:aws:ec2:*:*:instance/*"
     ]
    },
    {
     "Action":[
      "kms:Encrypt",
      "kms:Decrypt",
      "kms:ReEncryptFrom",
      "kms:ReEncryptTo",
      "kms:GenerateDataKeyWithoutPlaintext"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "kms:EncryptionContextKeys":[
        "aws:ebs:id"
       ]
      },
      "StringLike":{
       "kms:ViaService":[
        "ec2.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "kms:DescribeKey"
     ],
     "Condition":{
      "StringLike":{
       "kms:ViaService":[
        "ec2.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"kms:CreateGrant",
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":true
      },
      "StringLike":{
       "kms:ViaService":[
        "ec2.*.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"sts:AssumeRole",
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/EC2ImageBuilderDistributionCrossAccountRole"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:CreateLogGroup",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/imagebuilder/*"
    },
    {
     "Action":[
      "ec2:CreateLaunchTemplateVersion",
      "ec2:DescribeLaunchTemplates",
      "ec2:ModifyLaunchTemplate",
      "ec2:DescribeLaunchTemplateVersions"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:ExportImage"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*::image/*"
    },
    {
     "Action":[
      "ec2:ExportImage"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:export-image-task/*"
    },
    {
     "Action":[
      "ec2:CancelExportTask"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:export-image-task/*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":[
        "ssm.amazonaws.com",
        "ec2fastlaunch.amazonaws.com"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:EnableFastLaunch"
     ],
     "Condition":{
      "StringEquals":{
       "ec2:ResourceTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ec2:*::image/*",
      "arn:aws:ec2:*:*:launch-template/*"
     ]
    },
    {
     "Action":[
      "inspector2:ListCoverage",
      "inspector2:ListFindings"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ecr:CreateRepository"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ecr:TagResource"
     ],
     "Condition":{
      "StringEquals":{
       "aws:RequestTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ecr:*:*:repository/image-builder-*"
    },
    {
     "Action":[
      "ecr:BatchDeleteImage"
     ],
     "Condition":{
      "StringEquals":{
       "ecr:ResourceTag/CreatedBy":"EC2 Image Builder"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ecr:*:*:repository/image-builder-*"
    },
    {
     "Action":[
      "events:DeleteRule",
      "events:DescribeRule",
      "events:PutRule",
      "events:PutTargets",
      "events:RemoveTargets"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:events:*:*:rule/ImageBuilder-*"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-10-19T21:30:10+00:00"
 },
 "AWSServiceRoleForIoTSiteWise":{
  "CreateDate":"2018-11-14T19:19:17+00:00",
  "DefaultVersionId":"v8",
  "Document":{
   "Statement":[
    {
     "Action":[
      "greengrass:GetAssociatedRole",
      "greengrass:GetCoreDefinition",
      "greengrass:GetCoreDefinitionVersion",
      "greengrass:GetGroup",
      "greengrass:GetGroupVersion"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AllowSiteWiseReadGreenGrass"
    },
    {
     "Action":[
      "logs:CreateLogGroup",
      "logs:DescribeLogGroups"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/iotsitewise*",
     "Sid":"AllowSiteWiseAccessLogGroup"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:DescribeLogStreams",
      "logs:PutLogEvents"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:logs:*:*:log-group:/aws/iotsitewise*:log-stream:*",
     "Sid":"AllowSiteWiseAccessLog"
    },
    {
     "Action":[
      "iottwinmaker:GetWorkspace",
      "iottwinmaker:ExecuteQuery"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "iottwinmaker:linkedServices":[
        "IOTSITEWISE"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:iottwinmaker:*:*:workspace/*",
     "Sid":"AllowSiteWiseAccessSiteWiseManagedWorkspaceInTwinMaker"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-13T18:27:50+00:00"
 },
 "AWSServiceRoleForLogDeliveryPolicy":{
  "CreateDate":"2019-10-04T17:31:19+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "firehose:PutRecord",
      "firehose:PutRecordBatch",
      "firehose:ListTagsForDeliveryStream"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/LogDeliveryEnabled":"true"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-07-15T20:07:44+00:00"
 },
 "AWSServiceRoleForMonitronPolicy":{
  "CreateDate":"2020-12-02T19:06:08+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "sso:GetManagedApplicationInstance",
      "sso:GetProfile",
      "sso:ListProfiles",
      "sso:ListProfileAssociations",
      "sso:AssociateProfile",
      "sso:ListDirectoryAssociations",
      "sso-directory:DescribeUsers",
      "sso-directory:SearchUsers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-09-29T20:38:15+00:00"
 },
 "AWSServiceRoleForNeptuneGraphPolicy":{
  "CreateDate":"2023-11-29T14:03:36+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudwatch:PutMetricData"
     ],
     "Condition":{
      "StringEquals":{
       "cloudwatch:namespace":[
        "AWS/Neptune",
        "AWS/Usage"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"GraphMetrics"
    },
    {
     "Action":[
      "logs:CreateLogGroup"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/neptune/*"
     ],
     "Sid":"GraphLogGroup"
    },
    {
     "Action":[
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:DescribeLogStreams"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:logs:*:*:log-group:/aws/neptune/*:log-stream:*"
     ],
     "Sid":"GraphLogEvents"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-29T14:03:36+00:00"
 },
 "AWSServiceRoleForPrivateMarketplaceAdminPolicy":{
  "CreateDate":"2024-02-14T22:28:01+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "aws-marketplace:DescribeEntity"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:aws-marketplace:*:*:AWSMarketplace/Experience/*",
      "arn:aws:aws-marketplace:*:*:AWSMarketplace/Audience/*",
      "arn:aws:aws-marketplace:*:*:AWSMarketplace/ProcurementPolicy/*",
      "arn:aws:aws-marketplace:*:*:AWSMarketplace/BrandingSettings/*"
     ],
     "Sid":"PrivateMarketplaceCatalogDescribePermissions"
    },
    {
     "Action":[
      "aws-marketplace:DescribeChangeSet"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PrivateMarketplaceCatalogDescribeChangeSetPermissions"
    },
    {
     "Action":[
      "aws-marketplace:ListEntities",
      "aws-marketplace:ListChangeSets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"PrivateMarketplaceCatalogListPermissions"
    },
    {
     "Action":[
      "aws-marketplace:StartChangeSet"
     ],
     "Condition":{
      "StringEquals":{
       "catalog:ChangeType":[
        "AssociateAudience",
        "DisassociateAudience"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:aws-marketplace:*:*:AWSMarketplace/Experience/*",
      "arn:aws:aws-marketplace:*:*:AWSMarketplace/ChangeSet/*"
     ],
     "Sid":"PrivateMarketplaceStartChangeSetPermissions"
    },
    {
     "Action":[
      "organizations:DescribeAccount",
      "organizations:DescribeOrganizationalUnit",
      "organizations:ListDelegatedAdministrators",
      "organizations:ListChildren"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"PrivateMarketplaceOrganizationPermissions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-02-14T22:28:01+00:00"
 },
 "AWSServiceRoleForSMS":{
  "CreateDate":"2019-08-06T18:39:29+00:00",
  "DefaultVersionId":"v10",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudformation:CreateChangeSet",
      "cloudformation:CreateStack"
     ],
     "Condition":{
      "ForAllValues:StringEquals":{
       "cloudformation:ResourceTypes":[
        "AWS::EC2::Instance",
        "AWS::ApplicationInsights::Application",
        "AWS::ResourceGroups::Group"
       ]
      },
      "Null":{
       "cloudformation:ResourceTypes":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/sms-app-*/*"
    },
    {
     "Action":[
      "cloudformation:DeleteStack",
      "cloudformation:ExecuteChangeSet",
      "cloudformation:DeleteChangeSet",
      "cloudformation:DescribeChangeSet",
      "cloudformation:DescribeStacks",
      "cloudformation:DescribeStackEvents",
      "cloudformation:DescribeStackResource",
      "cloudformation:DescribeStackResources",
      "cloudformation:GetTemplate"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:cloudformation:*:*:stack/sms-app-*/*"
    },
    {
     "Action":[
      "cloudformation:ValidateTemplate",
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "s3:CreateBucket",
      "s3:DeleteBucket",
      "s3:DeleteObject",
      "s3:GetBucketAcl",
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:PutObject",
      "s3:PutObjectAcl",
      "s3:PutLifecycleConfiguration"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::sms-app-*"
    },
    {
     "Action":[
      "sms:CreateReplicationJob",
      "sms:DeleteReplicationJob",
      "sms:GetReplicationJobs",
      "sms:GetReplicationRuns",
      "sms:GetServers",
      "sms:ImportServerCatalog",
      "sms:StartOnDemandReplicationRun",
      "sms:UpdateReplicationJob"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ssm:SendCommand",
     "Effect":"Allow",
     "Resource":[
      "arn:aws:ssm:*::document/AWS-RunRemoteScript",
      "arn:aws:s3:::sms-app-*"
     ]
    },
    {
     "Action":"ssm:SendCommand",
     "Condition":{
      "StringEquals":{
       "ssm:resourceTag/UseForSMSApplicationValidation":[
        "true"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ssm:CancelCommand",
      "ssm:GetCommandInvocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ec2:CreateTags",
     "Condition":{
      "StringEquals":{
       "ec2:CreateAction":"CopySnapshot"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":"ec2:CopySnapshot",
     "Condition":{
      "StringLike":{
       "aws:RequestTag/SMSJobId":[
        "sms-*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:ModifySnapshotAttribute",
      "ec2:DeleteSnapshot"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/SMSJobId":[
        "sms-*"
       ]
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:snapshot/*"
    },
    {
     "Action":[
      "ec2:CopyImage",
      "ec2:DescribeImages",
      "ec2:DescribeInstances",
      "ec2:DescribeSnapshots",
      "ec2:DescribeSnapshotAttribute",
      "ec2:DeregisterImage",
      "ec2:ImportImage",
      "ec2:DescribeImportImageTasks",
      "ec2:GetEbsEncryptionByDefault"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "iam:GetRole",
      "iam:GetInstanceProfile"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DisassociateIamInstanceProfile",
      "ec2:AssociateIamInstanceProfile",
      "ec2:ReplaceIamInstanceProfileAssociation"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":"arn:aws:cloudformation:*:*:stack/sms-app-*/*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"ec2.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEqualsIfExists":{
       "iam:PassedToService":"cloudformation.amazonaws.com"
      },
      "StringLike":{
       "iam:AssociatedResourceArn":"arn:aws:cloudformation:*:*:stack/sms-app-*/*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:RunInstances"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:CreateTags",
      "ec2:DeleteTags"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:ec2:*:*:instance/*"
    },
    {
     "Action":[
      "ec2:ModifyInstanceAttribute",
      "ec2:StopInstances",
      "ec2:StartInstances",
      "ec2:TerminateInstances"
     ],
     "Condition":{
      "StringLike":{
       "ec2:ResourceTag/aws:cloudformation:stack-id":"arn:aws:cloudformation:*:*:stack/sms-app-*/*"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "applicationinsights:Describe*",
      "applicationinsights:List*",
      "cloudformation:ListStackResources"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "applicationinsights:CreateApplication",
      "applicationinsights:CreateComponent",
      "applicationinsights:UpdateApplication",
      "applicationinsights:DeleteApplication",
      "applicationinsights:UpdateComponentConfiguration",
      "applicationinsights:DeleteComponent"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:applicationinsights:*:*:application/resource-group/sms-app-*"
    },
    {
     "Action":[
      "resource-groups:CreateGroup",
      "resource-groups:GetGroup",
      "resource-groups:UpdateGroup",
      "resource-groups:DeleteGroup"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/aws:cloudformation:stack-id":"arn:aws:cloudformation:*:*:stack/sms-app-*/*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:resource-groups:*:*:group/sms-app-*"
    },
    {
     "Action":[
      "iam:CreateServiceLinkedRole"
     ],
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"application-insights.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:iam::*:role/aws-service-role/application-insights.amazonaws.com/AWSServiceRoleForApplicationInsights"
     ]
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-10-15T17:28:13+00:00"
 },
 "AWSServiceRoleForUserSubscriptions":{
  "CreateDate":"2024-04-25T16:14:06+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "identitystore:DescribeGroup",
      "identitystore:DescribeUser",
      "identitystore:IsMemberInGroups",
      "identitystore:ListGroupMemberships",
      "organizations:DescribeOrganization",
      "sso:DescribeApplication",
      "sso:DescribeInstance",
      "sso:ListInstances"
     ],
     "Effect":"Allow",
     "Resource":[
      "*"
     ],
     "Sid":"SubscriptionManagementPolicy"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-25T16:14:06+00:00"
 },
 "AWSServiceRolePolicyForBackupReports":{
  "CreateDate":"2021-08-19T21:16:45+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "backup:DescribeFramework",
      "backup:ListBackupJobs",
      "backup:ListRestoreJobs",
      "backup:ListCopyJobs"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "config:DescribeConfigurationRecorders",
      "config:DescribeConfigurationRecorderStatus",
      "config:BatchGetResourceConfig",
      "config:SelectResourceConfig",
      "config:DescribeConfigurationAggregators",
      "config:SelectAggregateResourceConfig",
      "config:DescribeConfigRuleEvaluationStatus",
      "config:DescribeConfigRules",
      "s3:GetBucketLocation"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "config:GetComplianceDetailsByConfigRule",
      "config:PutConfigRule",
      "config:DeleteConfigRule"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:config-rule/aws-service-rule/backup.amazonaws.com*"
    },
    {
     "Action":[
      "config:DeleteConfigurationAggregator",
      "config:PutConfigurationAggregator"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:config:*:*:config-aggregator/aws-service-config-aggregator/backup.amazonaws.com*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-03-10T00:51:25+00:00"
 },
 "AWSServiceRolePolicyForBackupRestoreTesting":{
  "CreateDate":"2023-11-10T23:37:45+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "backup:DescribeRecoveryPoint",
      "backup:DescribeRestoreJob",
      "backup:DescribeProtectedResource",
      "backup:GetRecoveryPointRestoreMetadata",
      "backup:ListBackupVaults",
      "backup:ListProtectedResources",
      "backup:ListProtectedResourcesByBackupVault",
      "backup:ListRecoveryPointsByBackupVault",
      "backup:ListRecoveryPointsByResource",
      "backup:ListTags",
      "backup:StartRestoreJob"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"BackupActions"
    },
    {
     "Action":"iam:PassRole",
     "Condition":{
      "StringEquals":{
       "iam:PassedToService":"backup.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IamPassRole"
    },
    {
     "Action":[
      "ec2:DescribeInstances",
      "ec2:DescribeSnapshotTierStatus",
      "ec2:DescribeTags",
      "ec2:DescribeVolumes",
      "elasticfilesystem:DescribeFileSystems",
      "elasticfilesystem:DescribeMountTargets",
      "fsx:DescribeFileSystems",
      "fsx:DescribeVolumes",
      "fsx:ListTagsForResource",
      "rds:DescribeDBInstances",
      "rds:DescribeDBClusters",
      "rds:DescribeDBInstanceAutomatedBackups",
      "rds:DescribeDBClusterAutomatedBackups",
      "rds:ListTagsForResource",
      "redshift:DescribeClusters"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DescribeActions"
    },
    {
     "Action":[
      "ec2:DeleteVolume",
      "ec2:TerminateInstances",
      "elasticfilesystem:DeleteFilesystem",
      "elasticfilesystem:DeleteMountTarget",
      "rds:DeleteDBCluster",
      "rds:DeleteDBInstance",
      "fsx:DeleteFileSystem",
      "fsx:DeleteVolume"
     ],
     "Condition":{
      "Null":{
       "aws:ResourceTag/awsbackup-restore-test":"false"
      }
     },
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"DeleteActions"
    },
    {
     "Action":[
      "dynamodb:DeleteTable",
      "dynamodb:DescribeTable"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:dynamodb:*:*:table/awsbackup-restore-test-*",
     "Sid":"DdbDeleteActions"
    },
    {
     "Action":"redshift:DeleteCluster",
     "Effect":"Allow",
     "Resource":"arn:aws:redshift:*:*:cluster:awsbackup-restore-test-*",
     "Sid":"RedshiftDeleteActions"
    },
    {
     "Action":[
      "s3:DeleteBucket",
      "s3:GetLifecycleConfiguration",
      "s3:PutLifecycleConfiguration"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:s3:::awsbackup-restore-test-*",
     "Sid":"S3DeleteActions"
    },
    {
     "Action":"timestream:DeleteTable",
     "Effect":"Allow",
     "Resource":"arn:aws:timestream:*:*:database/*/table/awsbackup-restore-test-*",
     "Sid":"TimestreamDeleteActions"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-02-14T22:42:37+00:00"
 },
 "AWSShieldDRTAccessPolicy":{
  "CreateDate":"2018-06-05T22:29:39+00:00",
  "DefaultVersionId":"v6",
  "Document":{
   "Statement":[
    {
     "Action":[
      "cloudfront:List*",
      "route53:List*",
      "elasticloadbalancing:Describe*",
      "cloudwatch:Describe*",
      "cloudwatch:Get*",
      "cloudwatch:List*",
      "cloudfront:GetDistribution*",
      "globalaccelerator:ListAccelerators",
      "globalaccelerator:DescribeAccelerator",
      "ec2:DescribeRegions",
      "ec2:DescribeAddresses"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SRTAccessProtectedResources"
    },
    {
     "Action":[
      "shield:*",
      "waf:*",
      "wafv2:*",
      "waf-regional:*",
      "elasticloadbalancing:SetWebACL",
      "cloudfront:UpdateDistribution",
      "apigateway:SetWebACL"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"SRTManageProtections"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2020-12-15T17:28:15+00:00"
 },
 "AWSShieldServiceRolePolicy":{
  "CreateDate":"2021-11-17T19:17:46+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "wafv2:GetWebACL",
      "wafv2:UpdateWebACL",
      "wafv2:GetWebACLForResource",
      "wafv2:ListResourcesForWebACL",
      "cloudfront:ListDistributions",
      "cloudfront:GetDistribution"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"AWSShield"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-11-17T19:17:46+00:00"
 },
 "AWSStepFunctionsConsoleFullAccess":{
  "CreateDate":"2017-01-11T21:54:31+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":"states:*",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:ListRoles",
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:PassRole",
     "Effect":"Allow",
     "Resource":"arn:aws:iam::*:role/service-role/StatesExecutionRole*"
    },
    {
     "Action":"lambda:ListFunctions",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-01-12T00:19:34+00:00"
 },
 "AWSStepFunctionsFullAccess":{
  "CreateDate":"2017-01-11T21:51:32+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":"states:*",
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2017-01-11T21:51:32+00:00"
 },
 "AWSStepFunctionsReadOnlyAccess":{
  "CreateDate":"2017-01-11T21:46:19+00:00",
  "DefaultVersionId":"v4",
  "Document":{
   "Statement":[
    {
     "Action":[
      "states:ListStateMachines",
      "states:ListActivities",
      "states:DescribeStateMachine",
      "states:DescribeStateMachineForExecution",
      "states:ListExecutions",
      "states:DescribeExecution",
      "states:GetExecutionHistory",
      "states:DescribeActivity",
      "states:ListTagsForResource",
      "states:DescribeMapRun",
      "states:ListMapRuns",
      "states:DescribeStateMachineAlias",
      "states:ListStateMachineAliases",
      "states:ListStateMachineVersions",
      "states:ValidateStateMachineDefinition"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ReadOnlyAccess"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-04-26T18:53:54+00:00"
 },
 "AWSStorageGatewayFullAccess":{
  "CreateDate":"2015-02-06T18:41:09+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "storagegateway:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeSnapshots",
      "ec2:DeleteSnapshot"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ssm:GetParameters",
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*::parameter/aws/service/storagegateway/*",
     "Sid":"fetchStorageGatewayParams"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-09-06T20:26:09+00:00"
 },
 "AWSStorageGatewayReadOnlyAccess":{
  "CreateDate":"2015-02-06T18:41:10+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "storagegateway:List*",
      "storagegateway:Describe*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":[
      "ec2:DescribeSnapshots"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"ssm:GetParameters",
     "Effect":"Allow",
     "Resource":"arn:aws:ssm:*::parameter/aws/service/storagegateway/*",
     "Sid":"fetchStorageGatewayParams"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-09-06T20:24:17+00:00"
 },
 "AWSStorageGatewayServiceRolePolicy":{
  "CreateDate":"2021-02-17T19:03:19+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "fsx:ListTagsForResource"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:fsx:*:*:backup/*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/aws-service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2021-02-17T19:03:19+00:00"
 },
 "AWSSupplyChainFederationAdminAccess":{
  "CreateDate":"2023-03-01T18:54:25+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "scn:*"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:scn:*:*:instance/*"
     ],
     "Sid":"AWSSupplyChain"
    },
    {
     "Action":[
      "chime:BatchCreateChannelMembership",
      "chime:CreateAppInstanceUser",
      "chime:CreateChannel",
      "chime:CreateChannelMembership",
      "chime:CreateChannelModerator",
      "chime:Connect",
      "chime:DeleteChannelMembership",
      "chime:DeleteChannelModerator",
      "chime:DescribeChannelMembershipForAppInstanceUser",
      "chime:GetChannelMembershipPreferences",
      "chime:ListChannelMemberships",
      "chime:ListChannelMembershipsForAppInstanceUser",
      "chime:ListChannelMessages",
      "chime:ListChannelModerators",
      "chime:TagResource",
      "chime:PutChannelMembershipPreferences",
      "chime:SendChannelMessage",
      "chime:UpdateChannelReadMarker",
      "chime:UpdateAppInstanceUser"
     ],
     "Condition":{
      "StringLike":{
       "aws:ResourceTag/SCNInstanceId":"*"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:chime:*:*:app-instance/*"
     ],
     "Sid":"ChimeAppInstance"
    },
    {
     "Action":[
      "chime:DescribeChannel"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:chime:*:*:app-instance/*"
     ],
     "Sid":"ChimeChannel"
    },
    {
     "Action":[
      "chime:GetMessagingSessionEndpoint"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"ChimeMessaging"
    },
    {
     "Action":[
      "sso:GetManagedApplicationInstance",
      "sso:ListDirectoryAssociations",
      "sso:AssociateProfile",
      "sso:DisassociateProfile",
      "sso:ListProfiles",
      "sso:GetProfile",
      "sso:ListProfileAssociations"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"IAMIdentityCenter"
    },
    {
     "Action":[
      "appflow:CreateConnectorProfile",
      "appflow:UseConnectorProfile",
      "appflow:DeleteConnectorProfile",
      "appflow:UpdateConnectorProfile"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:appflow:*:*:connectorprofile/scn-*"
     ],
     "Sid":"AppflowConnectorProfile"
    },
    {
     "Action":[
      "appflow:CreateFlow",
      "appflow:DeleteFlow",
      "appflow:DescribeFlow",
      "appflow:DescribeFlowExecutionRecords",
      "appflow:ListFlows",
      "appflow:StartFlow",
      "appflow:StopFlow",
      "appflow:UpdateFlow",
      "appflow:TagResource",
      "appflow:UntagResource"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:appflow:*:*:flow/scn-*"
     ],
     "Sid":"AppflowFlow"
    },
    {
     "Action":[
      "s3:ListAllMyBuckets"
     ],
     "Effect":"Allow",
     "Resource":"*",
     "Sid":"S3ListAllBuckets"
    },
    {
     "Action":[
      "s3:GetBucketLocation",
      "s3:GetBucketPolicy",
      "s3:ListBucket"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-supply-chain-data-*"
     ],
     "Sid":"S3ListSupplyChainBucket"
    },
    {
     "Action":[
      "s3:GetObject",
      "s3:PutObject"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceAccount":"${aws:PrincipalAccount}"
      }
     },
     "Effect":"Allow",
     "Resource":[
      "arn:aws:s3:::aws-supply-chain-data-*"
     ],
     "Sid":"S3ReadWriteObject"
    },
    {
     "Action":"secretsmanager:CreateSecret",
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "appflow.amazonaws.com"
       ]
      },
      "StringLike":{
       "secretsmanager:Name":"appflow!*"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:*",
     "Sid":"SecretsManagerCreateSecret"
    },
    {
     "Action":[
      "secretsmanager:PutResourcePolicy"
     ],
     "Condition":{
      "ForAnyValue:StringEquals":{
       "aws:CalledVia":[
        "appflow.amazonaws.com"
       ]
      },
      "StringEqualsIgnoreCase":{
       "secretsmanager:ResourceTag/aws:secretsmanager:owningService":"appflow"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:secretsmanager:*:*:secret:*",
     "Sid":"SecretsManagerPutResourcePolicy"
    },
    {
     "Action":[
      "kms:ListKeys",
      "kms:ListAliases"
     ],
     "Effect":"Allow",
     "Resource":"arn:aws:kms:*:*:key/*",
     "Sid":"KMSListKeys"
    },
    {
     "Action":[
      "kms:DescribeKey",
      "kms:ListGrants"
     ],
     "Condition":{
      "StringEquals":{
       "aws:ResourceTag/aws-supply-chain-access":"true"
      },
      "StringLike":{
       "kms:ViaService":"appflow.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:kms:*:*:key/*",
     "Sid":"KMSListGrants"
    },
    {
     "Action":[
      "kms:CreateGrant"
     ],
     "Condition":{
      "Bool":{
       "kms:GrantIsForAWSResource":"true"
      },
      "StringEquals":{
       "aws:ResourceTag/aws-supply-chain-access":"true"
      },
      "StringLike":{
       "kms:ViaService":"appflow.*.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"arn:aws:kms:*:*:key/*",
     "Sid":"KMSCreateGrant"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/service-role/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2023-11-01T18:50:13+00:00"
 },
 "AWSSupportAccess":{
  "CreateDate":"2015-02-06T18:41:11+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "support:*"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2015-02-06T18:41:11+00:00"
 },
 "AWSSupportAppFullAccess":{
  "CreateDate":"2022-08-22T16:53:41+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "servicequotas:GetRequestedServiceQuotaChange",
      "servicequotas:GetServiceQuota",
      "servicequotas:RequestServiceQuotaIncrease",
      "support:AddAttachmentsToSet",
      "support:AddCommunicationToCase",
      "support:CreateCase",
      "support:DescribeCases",
      "support:DescribeCommunications",
      "support:DescribeSeverityLevels",
      "support:InitiateChatForCase",
      "support:ResolveCase"
     ],
     "Effect":"Allow",
     "Resource":"*"
    },
    {
     "Action":"iam:CreateServiceLinkedRole",
     "Condition":{
      "StringEquals":{
       "iam:AWSServiceName":"servicequotas.amazonaws.com"
      }
     },
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-08-22T16:53:41+00:00"
 },
 "AWSSupportAppReadOnlyAccess":{
  "CreateDate":"2022-08-22T17:01:15+00:00",
  "DefaultVersionId":"v1",
  "Document":{
   "Statement":[
    {
     "Action":[
      "support:DescribeCases",
      "support:DescribeCommunications"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2022-08-22T17:01:15+00:00"
 },
 "AWSSupportPlansFullAccess":{
  "CreateDate":"2022-09-27T18:19:30+00:00",
  "DefaultVersionId":"v3",
  "Document":{
   "Statement":[
    {
     "Action":[
      "supportplans:GetSupportPlan",
      "supportplans:GetSupportPlanUpdateStatus",
      "supportplans:ListSupportPlanModifiers",
      "supportplans:StartSupportPlanUpdate",
      "supportplans:CreateSupportPlanSchedule"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-09-09T21:15:14+00:00"
 },
 "AWSSupportPlansReadOnlyAccess":{
  "CreateDate":"2022-09-27T18:08:29+00:00",
  "DefaultVersionId":"v2",
  "Document":{
   "Statement":[
    {
     "Action":[
      "supportplans:GetSupportPlan",
      "supportplans:GetSupportPlanUpdateStatus",
      "supportplans:ListSupportPlanModifiers"
     ],
     "Effect":"Allow",
     "Resource":"*"
    }
   ],
   "Version":"2012-10-17"
  },
  "Path":"/",
  "PermissionsBoundaryUsageCount":0,
  "UpdateDate":"2024-09-09T21:21:02+00:00"
 },
 "AWSSupportServiceRolePolicy":{
  "CreateDate":"2018-04-19T18:04:44+00:00",
  "DefaultVersionId":"v37",
  "Document":{
   "Statement":[
    {
     "Action":[
      "apigateway:GET"
     ],
     "Effect":"Allow",
     "Resource":[
      "arn:aws:apigateway:*::/account",
      "arn:aws:apigateway:*::/apis",
      "arn:aws:apigateway:*::/apis/*",
      "arn:aws:apigateway:*::/apis/*/authorizers",
      "arn:aws:apigateway:*::/apis/*/authorizers/*",
      "arn:aws:apigateway:*::/apis/*/deployments",
      "arn:aws:apigateway:*::/apis/*/deployments/*",
      "arn:aws:apigateway:*::/apis/*/integrations",
      "arn:aws:apigateway:*::/apis/*/integrations/*",
      "arn:aws:apigateway:*::/apis/*/integrations/*/integrationresponses",
      "arn:aws:apigateway:*::/apis/*/integrations/*/integrationresponses/*",
      "arn:aws:apigateway:*::/apis/*/models",
      "arn:aws:apigateway:*::/apis/*/models/*",
      "arn:aws:apigateway:*::/apis/*/routes",
      "arn:aws:apigateway:*::/apis/*/routes/*",
      "arn:aws:apigateway:*::/apis/*/routes/*/routeresponses",
      "arn:aws:apigateway:*::/apis/*/routes/*/routeresponses/*",
      "arn:aws:apigateway:*::/apis/*/stages",
      "arn:aws:apigateway:*::/apis/*/stages/*",
      "arn:aws:apigateway:*::/clientcertificates",
      "arn:aws:apigateway:*::/clientcertificates/*",
      "arn:aws:apigateway:*::/domainnames",
      "arn:aws:apigateway:*::/domainnames/*",
      "arn:aws:apigateway:*::/domainnames/*/apimappings",
      "arn:aws:apigateway:*::/domainnames/*/apimappings/*",
      "arn:aws:apigateway:*::/domainnames/*/basepathmappings",
      "arn:aws:apigateway:*::/domainnames/*/basepathmappings/*",
      "arn:aws:apigateway:*::/restapis",
      "arn:aws:apigateway:*::/restapis/*",
      "arn:aws:apigateway:*::/restapis/*/authorizers",
      "arn: