/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

public class XoodyakEngine
implements AEADCipher {
    private boolean forEncryption;
    private byte[] state;
    private int phase;
    private MODE mode;
    private int Rabsorb;
    private final int f_bPrime = 48;
    private final int Rkout = 24;
    private byte[] K;
    private byte[] iv;
    private final int PhaseDown = 1;
    private final int PhaseUp = 2;
    private final int MAXROUNDS = 12;
    private final int TAGLEN = 16;
    final int Rkin = 44;
    private byte[] tag;
    private final int[] RC = new int[]{88, 56, 960, 208, 288, 20, 96, 44, 896, 240, 416, 18};
    private boolean aadFinished;
    private boolean encrypted;
    private boolean initialised = false;
    private final ByteArrayOutputStream aadData = new ByteArrayOutputStream();
    private final ByteArrayOutputStream message = new ByteArrayOutputStream();

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Xoodyak init parameters must include an IV");
        }
        ParametersWithIV ivParams = (ParametersWithIV)params;
        this.iv = ivParams.getIV();
        if (this.iv == null || this.iv.length != 16) {
            throw new IllegalArgumentException("Xoodyak requires exactly 16 bytes of IV");
        }
        if (!(ivParams.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("Xoodyak init parameters must include a key");
        }
        KeyParameter key = (KeyParameter)ivParams.getParameters();
        this.K = key.getKey();
        if (this.K.length != 16) {
            throw new IllegalArgumentException("Xoodyak key must be 128 bits long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, Utils.getPurpose(forEncryption)));
        this.state = new byte[48];
        this.tag = new byte[16];
        this.initialised = true;
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return "Xoodyak AEAD";
    }

    @Override
    public void processAADByte(byte input) {
        if (this.aadFinished) {
            throw new IllegalArgumentException("AAD cannot be added after reading a full block(" + this.getBlockSize() + " bytes) of input for " + (this.forEncryption ? "encryption" : "decryption"));
        }
        this.aadData.write(input);
    }

    @Override
    public void processAADBytes(byte[] input, int inOff, int len) {
        if (this.aadFinished) {
            throw new IllegalArgumentException("AAD cannot be added after reading a full block(" + this.getBlockSize() + " bytes) of input for " + (this.forEncryption ? "encryption" : "decryption"));
        }
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.aadData.write(input, inOff, len);
    }

    @Override
    public int processByte(byte input, byte[] output, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{input}, 0, 1, output, outOff);
    }

    private void processAAD() {
        if (!this.aadFinished) {
            byte[] ad = this.aadData.toByteArray();
            this.AbsorbAny(ad, 0, ad.length, this.Rabsorb, 3);
            this.aadFinished = true;
        }
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        if (this.mode != MODE.ModeKeyed) {
            throw new IllegalArgumentException("Xoodyak has not been initialised");
        }
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.message.write(input, inOff, len);
        int blockLen = this.message.size() - (this.forEncryption ? 0 : 16);
        if (blockLen >= this.getBlockSize()) {
            byte[] blocks = this.message.toByteArray();
            len = blockLen / this.getBlockSize() * this.getBlockSize();
            if (len + outOff > output.length) {
                throw new OutputLengthException("output buffer is too short");
            }
            this.processAAD();
            this.encrypt(blocks, 0, len, output, outOff);
            this.message.reset();
            this.message.write(blocks, len, blocks.length - len);
            return len;
        }
        return 0;
    }

    private int encrypt(byte[] input, int inOff, int len, byte[] output, int outOff) {
        int splitLen;
        int Cu;
        byte[] P = new byte[24];
        int n = Cu = this.encrypted ? 0 : 128;
        for (int IOLen = len; IOLen != 0 || !this.encrypted; IOLen -= splitLen) {
            splitLen = Math.min(IOLen, 24);
            if (this.forEncryption) {
                System.arraycopy(input, inOff, P, 0, splitLen);
            }
            this.Up(null, 0, Cu);
            for (int i = 0; i < splitLen; ++i) {
                output[outOff + i] = (byte)(input[inOff++] ^ this.state[i]);
            }
            if (this.forEncryption) {
                this.Down(P, 0, splitLen, 0);
            } else {
                this.Down(output, outOff, splitLen, 0);
            }
            Cu = 0;
            outOff += splitLen;
            this.encrypted = true;
        }
        return len;
    }

    @Override
    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        byte[] blocks = this.message.toByteArray();
        int len = this.message.size();
        if (this.forEncryption && len + 16 + outOff > output.length || !this.forEncryption && len - 16 + outOff > output.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.processAAD();
        int rv = 0;
        if (this.forEncryption) {
            this.encrypt(blocks, 0, len, output, outOff);
            this.tag = new byte[16];
            this.Up(this.tag, 16, 64);
            System.arraycopy(this.tag, 0, output, outOff += len, 16);
            rv = len + 16;
        } else {
            int inOff;
            rv = inOff = len - 16;
            this.encrypt(blocks, 0, inOff, output, outOff);
            this.tag = new byte[16];
            this.Up(this.tag, 16, 64);
            for (int i = 0; i < 16; ++i) {
                if (this.tag[i] == blocks[inOff++]) continue;
                throw new IllegalArgumentException("Mac does not match");
            }
        }
        this.reset(false);
        return rv;
    }

    @Override
    public byte[] getMac() {
        return this.tag;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return len;
    }

    @Override
    public int getOutputSize(int len) {
        return len + 16;
    }

    @Override
    public void reset() {
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        this.reset(true);
    }

    private void reset(boolean clearMac) {
        if (clearMac) {
            this.tag = null;
        }
        Arrays.fill(this.state, (byte)0);
        this.aadFinished = false;
        this.encrypted = false;
        this.phase = 2;
        this.message.reset();
        this.aadData.reset();
        int KLen = this.K.length;
        int IDLen = this.iv.length;
        byte[] KID = new byte[44];
        this.mode = MODE.ModeKeyed;
        this.Rabsorb = 44;
        System.arraycopy(this.K, 0, KID, 0, KLen);
        System.arraycopy(this.iv, 0, KID, KLen, IDLen);
        KID[KLen + IDLen] = (byte)IDLen;
        this.AbsorbAny(KID, 0, KLen + IDLen + 1, this.Rabsorb, 2);
    }

    private void AbsorbAny(byte[] X, int Xoff, int XLen, int r, int Cd) {
        int splitLen;
        do {
            if (this.phase != 2) {
                this.Up(null, 0, 0);
            }
            splitLen = Math.min(XLen, r);
            this.Down(X, Xoff, splitLen, Cd);
            Cd = 0;
            Xoff += splitLen;
        } while ((XLen -= splitLen) != 0);
    }

    private void Up(byte[] Yi, int YiLen, int Cu) {
        if (this.mode != MODE.ModeHash) {
            this.state[47] = (byte)(this.state[47] ^ Cu);
        }
        int a0 = Pack.littleEndianToInt(this.state, 0);
        int a1 = Pack.littleEndianToInt(this.state, 4);
        int a2 = Pack.littleEndianToInt(this.state, 8);
        int a3 = Pack.littleEndianToInt(this.state, 12);
        int a4 = Pack.littleEndianToInt(this.state, 16);
        int a5 = Pack.littleEndianToInt(this.state, 20);
        int a6 = Pack.littleEndianToInt(this.state, 24);
        int a7 = Pack.littleEndianToInt(this.state, 28);
        int a8 = Pack.littleEndianToInt(this.state, 32);
        int a9 = Pack.littleEndianToInt(this.state, 36);
        int a10 = Pack.littleEndianToInt(this.state, 40);
        int a11 = Pack.littleEndianToInt(this.state, 44);
        for (int i = 0; i < 12; ++i) {
            int p0 = a0 ^ a4 ^ a8;
            int p1 = a1 ^ a5 ^ a9;
            int p2 = a2 ^ a6 ^ a10;
            int p3 = a3 ^ a7 ^ a11;
            int e0 = Integers.rotateLeft(p3, 5) ^ Integers.rotateLeft(p3, 14);
            int e1 = Integers.rotateLeft(p0, 5) ^ Integers.rotateLeft(p0, 14);
            int e2 = Integers.rotateLeft(p1, 5) ^ Integers.rotateLeft(p1, 14);
            int e3 = Integers.rotateLeft(p2, 5) ^ Integers.rotateLeft(p2, 14);
            a0 ^= e0;
            a4 ^= e0;
            a8 ^= e0;
            a1 ^= e1;
            a5 ^= e1;
            a9 ^= e1;
            a2 ^= e2;
            a6 ^= e2;
            a10 ^= e2;
            a3 ^= e3;
            a7 ^= e3;
            a11 ^= e3;
            int b0 = a0;
            int b1 = a1;
            int b2 = a2;
            int b3 = a3;
            int b4 = a7;
            int b5 = a4;
            int b6 = a5;
            int b7 = a6;
            int b8 = Integers.rotateLeft(a8, 11);
            int b9 = Integers.rotateLeft(a9, 11);
            int b10 = Integers.rotateLeft(a10, 11);
            int b11 = Integers.rotateLeft(a11, 11);
            a0 = (b0 ^= this.RC[i]) ^ ~b4 & b8;
            a1 = b1 ^ ~b5 & b9;
            a2 = b2 ^ ~b6 & b10;
            a3 = b3 ^ ~b7 & b11;
            a4 = b4 ^ ~b8 & b0;
            a5 = b5 ^ ~b9 & b1;
            a6 = b6 ^ ~b10 & b2;
            a7 = b7 ^ ~b11 & b3;
            b8 ^= ~b0 & b4;
            b9 ^= ~b1 & b5;
            b10 ^= ~b2 & b6;
            b11 ^= ~b3 & b7;
            a4 = Integers.rotateLeft(a4, 1);
            a5 = Integers.rotateLeft(a5, 1);
            a6 = Integers.rotateLeft(a6, 1);
            a7 = Integers.rotateLeft(a7, 1);
            a8 = Integers.rotateLeft(b10, 8);
            a9 = Integers.rotateLeft(b11, 8);
            a10 = Integers.rotateLeft(b8, 8);
            a11 = Integers.rotateLeft(b9, 8);
        }
        Pack.intToLittleEndian(a0, this.state, 0);
        Pack.intToLittleEndian(a1, this.state, 4);
        Pack.intToLittleEndian(a2, this.state, 8);
        Pack.intToLittleEndian(a3, this.state, 12);
        Pack.intToLittleEndian(a4, this.state, 16);
        Pack.intToLittleEndian(a5, this.state, 20);
        Pack.intToLittleEndian(a6, this.state, 24);
        Pack.intToLittleEndian(a7, this.state, 28);
        Pack.intToLittleEndian(a8, this.state, 32);
        Pack.intToLittleEndian(a9, this.state, 36);
        Pack.intToLittleEndian(a10, this.state, 40);
        Pack.intToLittleEndian(a11, this.state, 44);
        this.phase = 2;
        if (Yi != null) {
            System.arraycopy(this.state, 0, Yi, 0, YiLen);
        }
    }

    void Down(byte[] Xi, int XiOff, int XiLen, int Cd) {
        int i = 0;
        while (i < XiLen) {
            int n = i++;
            this.state[n] = (byte)(this.state[n] ^ Xi[XiOff++]);
        }
        int n = XiLen;
        this.state[n] = (byte)(this.state[n] ^ 1);
        this.state[47] = (byte)(this.state[47] ^ (this.mode == MODE.ModeHash ? Cd & 1 : Cd));
        this.phase = 1;
    }

    public int getBlockSize() {
        return 24;
    }

    public int getKeyBytesSize() {
        return 16;
    }

    public int getIVBytesSize() {
        return 16;
    }

    static enum MODE {
        ModeHash,
        ModeKeyed;

    }
}

