/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.slhdsa;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.slhdsa.HT;
import org.bouncycastle.pqc.crypto.slhdsa.PK;
import org.bouncycastle.pqc.crypto.slhdsa.SK;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAEngine;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPublicKeyParameters;

public class SLHDSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private SLHDSAParameters parameters;

    @Override
    public void init(KeyGenerationParameters param) {
        this.random = param.getRandom();
        this.parameters = ((SLHDSAKeyGenerationParameters)param).getParameters();
    }

    public AsymmetricCipherKeyPair internalGenerateKeyPair(byte[] skSeed, byte[] skPrf, byte[] pkSeed) {
        return this.implGenerateKeyPair(this.parameters.getEngine(), skSeed, skPrf, pkSeed);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        SLHDSAEngine engine = this.parameters.getEngine();
        byte[] skSeed = this.sec_rand(engine.N);
        byte[] skPrf = this.sec_rand(engine.N);
        byte[] pkSeed = this.sec_rand(engine.N);
        return this.implGenerateKeyPair(engine, skSeed, skPrf, pkSeed);
    }

    private AsymmetricCipherKeyPair implGenerateKeyPair(SLHDSAEngine engine, byte[] skSeed, byte[] skPrf, byte[] pkSeed) {
        SK sk = new SK(skSeed, skPrf);
        engine.init(pkSeed);
        PK pk = new PK(pkSeed, new HT((SLHDSAEngine)engine, (byte[])sk.seed, (byte[])pkSeed).htPubKey);
        return new AsymmetricCipherKeyPair(new SLHDSAPublicKeyParameters(this.parameters, pk), new SLHDSAPrivateKeyParameters(this.parameters, sk, pk));
    }

    private byte[] sec_rand(int n) {
        byte[] rv = new byte[n];
        this.random.nextBytes(rv);
        return rv;
    }
}

