
use builtin;
use str;

set edit:completion:arg-completer[qrtool] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'qrtool'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'qrtool'= {
            cand --generate-completion 'Generate shell completion'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand encode 'Encode input data in a QR code'
            cand enc 'Encode input data in a QR code'
            cand e 'Encode input data in a QR code'
            cand decode 'Detect and decode a QR code'
            cand dec 'Detect and decode a QR code'
            cand d 'Detect and decode a QR code'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qrtool;encode'= {
            cand -o 'Output the result to a file'
            cand --output 'Output the result to a file'
            cand -r 'Read input data from a file'
            cand --read-from 'Read input data from a file'
            cand -s 'The module size in pixels'
            cand --size 'The module size in pixels'
            cand -l 'Error correction level'
            cand --error-correction-level 'Error correction level'
            cand --level 'Error correction level'
            cand -v 'The version of the symbol'
            cand --symbol-version 'The version of the symbol'
            cand --symversion 'The version of the symbol'
            cand -m 'The width of margin'
            cand --margin 'The width of margin'
            cand -t 'The format of the output'
            cand --type 'The format of the output'
            cand --optimize-png 'Set the optimization level for a PNG image'
            cand --zopfli 'Use Zopfli to compress PNG image'
            cand --mode 'The mode of the output'
            cand --variant 'The type of QR code'
            cand --foreground 'Foreground color'
            cand --background 'Background color'
            cand --verbose 'Also print the metadata'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'qrtool;enc'= {
            cand -o 'Output the result to a file'
            cand --output 'Output the result to a file'
            cand -r 'Read input data from a file'
            cand --read-from 'Read input data from a file'
            cand -s 'The module size in pixels'
            cand --size 'The module size in pixels'
            cand -l 'Error correction level'
            cand --error-correction-level 'Error correction level'
            cand --level 'Error correction level'
            cand -v 'The version of the symbol'
            cand --symbol-version 'The version of the symbol'
            cand --symversion 'The version of the symbol'
            cand -m 'The width of margin'
            cand --margin 'The width of margin'
            cand -t 'The format of the output'
            cand --type 'The format of the output'
            cand --optimize-png 'Set the optimization level for a PNG image'
            cand --zopfli 'Use Zopfli to compress PNG image'
            cand --mode 'The mode of the output'
            cand --variant 'The type of QR code'
            cand --foreground 'Foreground color'
            cand --background 'Background color'
            cand --verbose 'Also print the metadata'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'qrtool;e'= {
            cand -o 'Output the result to a file'
            cand --output 'Output the result to a file'
            cand -r 'Read input data from a file'
            cand --read-from 'Read input data from a file'
            cand -s 'The module size in pixels'
            cand --size 'The module size in pixels'
            cand -l 'Error correction level'
            cand --error-correction-level 'Error correction level'
            cand --level 'Error correction level'
            cand -v 'The version of the symbol'
            cand --symbol-version 'The version of the symbol'
            cand --symversion 'The version of the symbol'
            cand -m 'The width of margin'
            cand --margin 'The width of margin'
            cand -t 'The format of the output'
            cand --type 'The format of the output'
            cand --optimize-png 'Set the optimization level for a PNG image'
            cand --zopfli 'Use Zopfli to compress PNG image'
            cand --mode 'The mode of the output'
            cand --variant 'The type of QR code'
            cand --foreground 'Foreground color'
            cand --background 'Background color'
            cand --verbose 'Also print the metadata'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'qrtool;decode'= {
            cand -t 'The format of the input'
            cand --type 'The format of the input'
            cand --verbose 'Also print the metadata'
            cand --metadata 'Print only the metadata'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'qrtool;dec'= {
            cand -t 'The format of the input'
            cand --type 'The format of the input'
            cand --verbose 'Also print the metadata'
            cand --metadata 'Print only the metadata'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'qrtool;d'= {
            cand -t 'The format of the input'
            cand --type 'The format of the input'
            cand --verbose 'Also print the metadata'
            cand --metadata 'Print only the metadata'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'qrtool;help'= {
            cand encode 'Encode input data in a QR code'
            cand decode 'Detect and decode a QR code'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qrtool;help;encode'= {
        }
        &'qrtool;help;decode'= {
        }
        &'qrtool;help;help'= {
        }
    ]
    $completions[$command]
}
