/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeSignaturesConstants;
import org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.KeyFactorySpi;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;

public class CompositeSignatures {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.";
    private static final Map<String, String> compositesAttributes = new HashMap<String, String>();

    static {
        compositesAttributes.put("SupportedKeyClasses", "org.bouncycastle.jcajce.CompositePublicKey|org.bouncycastle.jcajce.CompositePrivateKey");
        compositesAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider provider) {
            for (ASN1ObjectIdentifier oid : CompositeSignaturesConstants.supportedIdentifiers) {
                CompositeSignaturesConstants.CompositeName algName = CompositeSignaturesConstants.ASN1IdentifierAlgorithmNameMap.get(oid);
                provider.addAlgorithm("KeyFactory." + algName.getId(), "org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.KeyFactorySpi");
                provider.addAlgorithm("Alg.Alias.KeyFactory", oid, algName.getId());
                provider.addAlgorithm("KeyPairGenerator." + algName.getId(), "org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.KeyPairGeneratorSpi$" + (Object)((Object)algName));
                provider.addAlgorithm("Alg.Alias.KeyPairGenerator", oid, algName.getId());
                provider.addAlgorithm("Signature." + algName.getId(), "org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.SignatureSpi$" + (Object)((Object)algName));
                provider.addAlgorithm("Alg.Alias.Signature", oid, algName.getId());
                provider.addKeyInfoConverter(oid, new KeyFactorySpi());
            }
        }
    }
}

