/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import org.bouncycastle.util.Pack;

class Utils {
    Utils() {
    }

    static void resizeArray(long[] out, int sizeOutBits, long[] in, int sizeInBits, int n1n2ByteSize, int n1n2Byte64Size) {
        long mask = Long.MAX_VALUE;
        int val = 0;
        if (sizeOutBits < sizeInBits) {
            if (sizeOutBits % 64 != 0) {
                val = 64 - sizeOutBits % 64;
            }
            System.arraycopy(in, 0, out, 0, n1n2ByteSize);
            for (int i = 0; i < val; ++i) {
                int n = n1n2Byte64Size - 1;
                out[n] = out[n] & mask >> i;
            }
        } else {
            System.arraycopy(in, 0, out, 0, (sizeInBits + 7) / 8);
        }
    }

    static void fromByte16ArrayToLongArray(long[] output, int[] input) {
        for (int i = 0; i != input.length; i += 4) {
            output[i / 4] = (long)input[i] & 0xFFFFL;
            int n = i / 4;
            output[n] = output[n] | (long)input[i + 1] << 16;
            int n2 = i / 4;
            output[n2] = output[n2] | (long)input[i + 2] << 32;
            int n3 = i / 4;
            output[n3] = output[n3] | (long)input[i + 3] << 48;
        }
    }

    static void fromByteArrayToByte16Array(int[] output, byte[] input) {
        byte[] tmp = input;
        if (input.length % 2 != 0) {
            tmp = new byte[(input.length + 1) / 2 * 2];
            System.arraycopy(input, 0, tmp, 0, input.length);
        }
        int off = 0;
        for (int i = 0; i < output.length; ++i) {
            output[i] = Pack.littleEndianToShort(tmp, off) & 0xFFFF;
            off += 2;
        }
    }

    static void fromLongArrayToByteArray(byte[] out, long[] in) {
        int max = out.length / 8;
        for (int i = 0; i != max; ++i) {
            Pack.longToLittleEndian(in[i], out, i * 8);
        }
        if (out.length % 8 != 0) {
            int off = max * 8;
            int count = 0;
            while (off < out.length) {
                out[off++] = (byte)(in[max] >>> count++ * 8);
            }
        }
    }

    static long bitMask(long a, long b) {
        return (1L << (int)(a % b)) - 1L;
    }

    static void fromByteArrayToLongArray(long[] out, byte[] in) {
        byte[] tmp = in;
        if (in.length % 8 != 0) {
            tmp = new byte[(in.length + 7) / 8 * 8];
            System.arraycopy(in, 0, tmp, 0, in.length);
        }
        int off = 0;
        for (int i = 0; i < out.length; ++i) {
            out[i] = Pack.littleEndianToLong(tmp, off);
            off += 8;
        }
    }

    static void fromByte32ArrayToLongArray(long[] out, int[] in) {
        for (int i = 0; i != in.length; i += 2) {
            out[i / 2] = (long)in[i] & 0xFFFFFFFFL;
            int n = i / 2;
            out[n] = out[n] | (long)in[i + 1] << 32;
        }
    }

    static void fromLongArrayToByte32Array(int[] out, long[] in) {
        for (int i = 0; i != in.length; ++i) {
            out[2 * i] = (int)in[i];
            out[2 * i + 1] = (int)(in[i] >> 32);
        }
    }

    static void copyBytes(int[] src, int offsetSrc, int[] dst, int offsetDst, int lengthBytes) {
        System.arraycopy(src, offsetSrc, dst, offsetDst, lengthBytes / 2);
    }

    static int getByteSizeFromBitSize(int size) {
        return (size + 7) / 8;
    }

    static int getByte64SizeFromBitSize(int size) {
        return (size + 63) / 64;
    }

    static int toUnsigned8bits(int a) {
        return a & 0xFF;
    }

    static int toUnsigned16Bits(int a) {
        return a & 0xFFFF;
    }

    static void xorLongToByte16Array(int[] output, long input, int startIndex) {
        int n = startIndex + 0;
        output[n] = output[n] ^ (int)input & 0xFFFF;
        int n2 = startIndex + 1;
        output[n2] = output[n2] ^ (int)(input >>> 16) & 0xFFFF;
        int n3 = startIndex + 2;
        output[n3] = output[n3] ^ (int)(input >>> 32) & 0xFFFF;
        int n4 = startIndex + 3;
        output[n4] = output[n4] ^ (int)(input >>> 48) & 0xFFFF;
    }
}

