/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import org.hsqldb.lib.HsqlArrayList;

public class StringUtil {
    public static String toZeroPaddedString(long l, int n, int n2) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if (l < 0L) {
            l = -l;
        }
        if ((string = Long.toString(l)).length() > n) {
            string = string.substring(n);
        }
        for (int i = string.length(); i < n; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        if (n2 < n) {
            stringBuilder.setLength(n2);
        }
        return stringBuilder.toString();
    }

    public static String toPaddedString(String string, int n, char c, boolean bl) {
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        if (bl) {
            stringBuilder.append(string);
        }
        for (int i = n2; i < n; ++i) {
            stringBuilder.append(c);
        }
        if (!bl) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String toPaddedString(String string, int n, String string2, boolean bl) {
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 > n) {
            if (bl) {
                return string.substring(0, n);
            }
            return string.substring(n2 - n, n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        int n3 = string.length();
        int n4 = (n - n3) % string2.length();
        if (bl) {
            stringBuilder.append(string);
        }
        while (n3 + string2.length() <= n) {
            stringBuilder.append(string2);
            n3 += string2.length();
        }
        stringBuilder.append(string2.substring(0, n4));
        if (!bl) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String toLowerSubset(String string, char c) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (!Character.isLetterOrDigit(c2)) {
                stringBuilder.append(c);
                continue;
            }
            if (i == 0 && Character.isDigit(c2)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(Character.toLowerCase(c2));
        }
        return stringBuilder.toString();
    }

    public static String arrayToString(Object object) {
        int n = Array.getLength(object);
        int n2 = n - 1;
        StringBuilder stringBuilder = new StringBuilder(2 * (n + 1));
        stringBuilder.append('{');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(Array.get(object, i));
            if (i == n2) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static String getList(String[] stringArray, String string, String string2) {
        int n = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder(n * 16);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(string2);
            if (i + 1 >= n) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String getList(int[] nArray, String string, String string2) {
        int n = nArray.length;
        StringBuilder stringBuilder = new StringBuilder(n * 8);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(nArray[i]);
            stringBuilder.append(string2);
            if (i + 1 >= n) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String getList(long[] lArray, String string, String string2) {
        int n = lArray.length;
        StringBuilder stringBuilder = new StringBuilder(n * 8);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(lArray[i]);
            stringBuilder.append(string2);
            if (i + 1 >= n) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String getList(String[][] stringArray, String string, String string2) {
        int n = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder(n * 16);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(stringArray[i][0]);
            stringBuilder.append(string2);
            if (i + 1 >= n) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static boolean isEmpty(String string) {
        int n;
        int n2 = n = string == null ? 0 : string.length();
        while (n > 0) {
            if (string.charAt(--n) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static int rightTrimSize(String string) {
        int n = string.length();
        while (n > 0) {
            if (string.charAt(--n) == ' ') continue;
            return n + 1;
        }
        return 0;
    }

    public static int skipSpaces(String string, int n) {
        int n2;
        int n3 = string.length();
        for (n2 = n; n2 < n3 && string.charAt(n2) == ' '; ++n2) {
        }
        return n2;
    }

    public static String[] split(String string, String string2) {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        int n = 0;
        boolean bl = true;
        while (bl) {
            int n2 = string.indexOf(string2, n);
            if (n2 == -1) {
                n2 = string.length();
                bl = false;
            }
            hsqlArrayList.add(string.substring(n, n2));
            n = n2 + string2.length();
        }
        return hsqlArrayList.toArray(new String[hsqlArrayList.size()]);
    }
}

