/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.geom;

import java.util.Objects;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;

public enum HorizontalAlignment {
    LEFT,
    CENTER,
    RIGHT;


    public static HorizontalAlignment fromString(String s2) {
        if (LEFT.name().equalsIgnoreCase(s2)) {
            return LEFT;
        }
        if (CENTER.name().equalsIgnoreCase(s2)) {
            return CENTER;
        }
        if (RIGHT.name().equalsIgnoreCase(s2)) {
            return RIGHT;
        }
        return null;
    }

    public static HorizontalAlignment fromString(String s2, HorizontalAlignment defaultValue) {
        Objects.requireNonNull(defaultValue);
        if (s2 == null) {
            return defaultValue;
        }
        HorizontalAlignment result = HorizontalAlignment.fromString(s2 = StringUtils.goUpperCase(s2));
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public String getGraphVizValue() {
        return this.toString().substring(0, 1).toLowerCase();
    }

    public void draw(UGraphic ug, TextBlock tb, double padding, double width) {
        if (this == LEFT) {
            tb.drawU(ug.apply(new UTranslate(padding, padding)));
        } else if (this == RIGHT) {
            XDimension2D dimTb = tb.calculateDimension(ug.getStringBounder());
            tb.drawU(ug.apply(new UTranslate(width - dimTb.getWidth() - padding, padding)));
        } else if (this == CENTER) {
            XDimension2D dimTb = tb.calculateDimension(ug.getStringBounder());
            tb.drawU(ug.apply(new UTranslate((width - dimTb.getWidth()) / 2.0, padding)));
        }
    }
}

