/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram.command;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.cucadiagram.BodierJSon;
import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonParser;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandCreateJson
extends CommandMultilines2<AbstractEntityDiagram> {
    public CommandCreateJson() {
        super(CommandCreateJson.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateJson.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "json"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "(?:[%g]([^%g]+)[%g][%s]+as[%s]+)?([%pLN_.]+)"), StereotypePattern.optional("STEREO"), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "^[%s]*\\}[%s]*$";
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractEntityDiagram diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.trim().removeEmptyLines();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        Entity entity1 = this.executeArg0(diagram, line0);
        if (entity1 == null) {
            return CommandExecutionResult.error("No such entity");
        }
        JsonValue json = this.getJsonValue(lines);
        if (json == null) {
            return CommandExecutionResult.error("Bad data");
        }
        ((BodierJSon)entity1.getBodier()).setJson(json);
        return CommandExecutionResult.ok();
    }

    @Override
    protected CommandControl finalVerification(BlocLines lines) {
        JsonValue json = this.getJsonValue(lines);
        if (json == null) {
            return CommandControl.OK_PARTIAL;
        }
        return super.finalVerification(lines);
    }

    private JsonValue getJsonValue(BlocLines lines) {
        try {
            String sb = this.getJsonString(lines);
            Json.DefaultHandler handler = new Json.DefaultHandler();
            new JsonParser(handler).parse(sb);
            JsonValue json = handler.getValue();
            return json;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getJsonString(BlocLines lines) {
        lines = lines.subExtract(1, 1);
        StringBuilder sb = new StringBuilder("{");
        for (StringLocated sl : lines) {
            String line = sl.getString();
            assert (line.length() > 0);
            sb.append(line);
        }
        sb.append("}");
        return sb.toString();
    }

    private Entity executeArg0(AbstractEntityDiagram diagram, RegexResult line0) throws NoSuchColorException {
        String s2;
        String name = line0.get("NAME", 1);
        Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(name));
        if (quark.getData() != null) {
            return null;
        }
        String displayString = line0.get("NAME", 0);
        String stereotype = line0.get("STEREO", 0);
        Display display = Display.getWithNewlines(displayString);
        if (Display.isNull(display)) {
            display = Display.getWithNewlines(name).withCreoleMode(CreoleMode.SIMPLE_LINE);
        }
        Entity entity = diagram.reallyCreateLeaf(quark, display, LeafType.JSON, null);
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, (s2 = line0.get("COLOR", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s2));
        return entity;
    }
}

